/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.dataframe.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.meteoinfo.data.dataframe.DataFrame;
import org.meteoinfo.data.dataframe.Series;
import org.meteoinfo.data.dataframe.impl.Aggregate;
import org.meteoinfo.data.dataframe.impl.Function;
import org.meteoinfo.data.dataframe.impl.KeyFunction;
import org.meteoinfo.data.dataframe.impl.SparseBitSet;
import org.meteoinfo.data.dataframe.impl.TimeFunction;
import org.meteoinfo.data.dataframe.impl.Transforms;
import org.meteoinfo.data.dataframe.impl.WindowFunction;
import org.meteoinfo.math.ArrayUtil;
import org.meteoinfo.ndarray.Array;

public class Grouping
implements Iterable<Map.Entry<Object, SparseBitSet>> {
    private final Map<Object, SparseBitSet> groups = new LinkedHashMap<Object, SparseBitSet>();
    private final Set<Integer> columns = new LinkedHashSet<Integer>();

    public Grouping() {
    }

    public <V> Grouping(Series series, KeyFunction<V> function) {
        Iterator iter = series.iterator();
        int r = 0;
        while (iter.hasNext()) {
            List row = (List)iter.next();
            Object key = function.apply(row);
            SparseBitSet group = this.groups.get(key);
            if (group == null) {
                group = new SparseBitSet();
                this.groups.put(key, group);
            }
            group.set(r);
            ++r;
        }
    }

    public <V> Grouping(Series series, TimeFunction<DateTime, String> function) {
        Iterator iter = series.getIndex().iterator();
        int r = 0;
        while (iter.hasNext()) {
            Object row = iter.next();
            String key = (String)function.apply((DateTime)row);
            SparseBitSet group = this.groups.get(key);
            if (group == null) {
                group = new SparseBitSet();
                this.groups.put(key, group);
            }
            group.set(r);
            ++r;
        }
    }

    public <V> Grouping(Series series) {
        this(series, new KeyFunction<V>(){

            @Override
            public Object apply(List<V> value) {
                return value.get(0);
            }
        });
    }

    public <V> Grouping(Series series, WindowFunction function) {
        Iterator iter = series.getIndex().iterator();
        int r = 0;
        while (iter.hasNext()) {
            DateTime row = (DateTime)iter.next();
            Object key = function.apply(row);
            SparseBitSet group = this.groups.get(key);
            if (group == null) {
                group = new SparseBitSet();
                this.groups.put(key, group);
            }
            group.set(r);
            ++r;
        }
    }

    public <V> Grouping(DataFrame df, KeyFunction<V> function, Integer ... columns) {
        Iterator iter = df.iterator();
        int r = 0;
        while (iter.hasNext()) {
            List row = (List)iter.next();
            Object key = function.apply(row);
            SparseBitSet group = this.groups.get(key);
            if (group == null) {
                group = new SparseBitSet();
                this.groups.put(key, group);
            }
            group.set(r);
            ++r;
        }
        Integer[] integerArray = columns;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int column = integerArray[i];
            this.columns.add(column);
        }
    }

    public <V> Grouping(DataFrame df, final Integer ... columns) {
        this(df, columns.length == 1 ? new KeyFunction<V>(){

            @Override
            public Object apply(List<V> value) {
                return value.get(columns[0]);
            }
        } : new KeyFunction<V>(){

            @Override
            public Object apply(List<V> value) {
                ArrayList key = new ArrayList(columns.length);
                Integer[] integerArray = columns;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int column = integerArray[i];
                    key.add(value.get(column));
                }
                return Collections.unmodifiableList(key);
            }
        }, columns);
    }

    public <V> Grouping(DataFrame df, WindowFunction function) {
        Iterator iter = df.getIndex().iterator();
        int r = 0;
        while (iter.hasNext()) {
            DateTime row = (DateTime)iter.next();
            Object key = function.apply(row);
            SparseBitSet group = this.groups.get(key);
            if (group == null) {
                group = new SparseBitSet();
                this.groups.put(key, group);
            }
            group.set(r);
            ++r;
        }
    }

    public <V> Series apply(Series series, Function<?, ?> function) {
        if (series.isEmpty()) {
            return series;
        }
        String name = series.getName();
        ArrayList<Object> index = new ArrayList<Object>();
        if (function instanceof Aggregate && !this.groups.isEmpty()) {
            for (Object key : this.groups.keySet()) {
                index.add(key);
            }
        }
        ArrayList column = new ArrayList();
        if (this.groups.isEmpty()) {
            try {
                if (function instanceof Aggregate) {
                    column.add(((Aggregate)Aggregate.class.cast(function)).apply(series.getData()));
                } else {
                    for (int r = 0; r < series.size(); ++r) {
                        column.add(((Function)Function.class.cast(function)).apply(series.getValue(r)));
                    }
                }
            }
            catch (ClassCastException r) {
                // empty catch block
            }
            if (function instanceof Transforms.CumulativeFunction) {
                ((Transforms.CumulativeFunction)Transforms.CumulativeFunction.class.cast(function)).reset();
            }
        } else {
            for (Map.Entry<Object, SparseBitSet> entry : this.groups.entrySet()) {
                SparseBitSet rows = entry.getValue();
                try {
                    if (function instanceof Aggregate) {
                        ArrayList<Object> values = new ArrayList<Object>(rows.cardinality());
                        int r = rows.nextSetBit(0);
                        while (r >= 0) {
                            values.add(series.getValue(r));
                            r = rows.nextSetBit(r + 1);
                        }
                        column.add(((Aggregate)Aggregate.class.cast(function)).apply(values));
                    } else {
                        int r = rows.nextSetBit(0);
                        while (r >= 0) {
                            column.add(((Function)Function.class.cast(function)).apply(series.getValue(r)));
                            r = rows.nextSetBit(r + 1);
                        }
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (!(function instanceof Transforms.CumulativeFunction)) continue;
                ((Transforms.CumulativeFunction)Transforms.CumulativeFunction.class.cast(function)).reset();
            }
        }
        if (!column.isEmpty()) {
            Array grouped = ArrayUtil.array(column, null);
            return new Series(grouped, index, name);
        }
        return null;
    }

    public <V> DataFrame apply(DataFrame df, Function<?, ?> function) {
        if (df.isEmpty()) {
            return df;
        }
        ArrayList<Array> grouped = new ArrayList<Array>();
        List<String> names = df.getColumns().getNames();
        ArrayList<String> newcols = new ArrayList<String>();
        ArrayList<Object> index = new ArrayList<Object>();
        if (function instanceof Aggregate && !this.groups.isEmpty()) {
            for (Object key : this.groups.keySet()) {
                index.add(key);
            }
        }
        for (int c = 0; c < df.size(); ++c) {
            if (this.columns.contains(c)) continue;
            ArrayList column = new ArrayList();
            if (this.groups.isEmpty()) {
                try {
                    if (function instanceof Aggregate) {
                        column.add(((Aggregate)Aggregate.class.cast(function)).apply(df.col(c)));
                    } else {
                        for (int r = 0; r < df.length(); ++r) {
                            column.add(((Function)Function.class.cast(function)).apply(df.getValue(r, c)));
                        }
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (function instanceof Transforms.CumulativeFunction) {
                    ((Transforms.CumulativeFunction)Transforms.CumulativeFunction.class.cast(function)).reset();
                }
            } else {
                for (Map.Entry<Object, SparseBitSet> entry : this.groups.entrySet()) {
                    SparseBitSet rows = entry.getValue();
                    try {
                        if (function instanceof Aggregate) {
                            ArrayList<Object> values = new ArrayList<Object>(rows.cardinality());
                            int r = rows.nextSetBit(0);
                            while (r >= 0) {
                                values.add(df.getValue(r, c));
                                r = rows.nextSetBit(r + 1);
                            }
                            column.add(((Aggregate)Aggregate.class.cast(function)).apply(values));
                        } else {
                            int r = rows.nextSetBit(0);
                            while (r >= 0) {
                                column.add(((Function)Function.class.cast(function)).apply(df.getValue(r, c)));
                                r = rows.nextSetBit(r + 1);
                            }
                        }
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    if (!(function instanceof Transforms.CumulativeFunction)) continue;
                    ((Transforms.CumulativeFunction)Transforms.CumulativeFunction.class.cast(function)).reset();
                }
            }
            if (column.isEmpty()) continue;
            grouped.add(ArrayUtil.array(column, null));
            newcols.add(names.get(c));
        }
        if (index.isEmpty()) {
            int i = 0;
            while ((long)i < ((Array)grouped.get(0)).getSize()) {
                index.add(i);
                ++i;
            }
        }
        return new DataFrame(grouped, index, newcols);
    }

    public Set<Object> keys() {
        return this.groups.keySet();
    }

    public Set<Integer> columns() {
        return this.columns;
    }

    @Override
    public Iterator<Map.Entry<Object, SparseBitSet>> iterator() {
        return this.groups.entrySet().iterator();
    }
}

