/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.mapdata.geotiff;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.mapdata.geotiff.FieldType;
import org.meteoinfo.data.mapdata.geotiff.GeoKey;
import org.meteoinfo.data.mapdata.geotiff.IFDEntry;
import org.meteoinfo.data.mapdata.geotiff.Tag;
import org.meteoinfo.data.mapdata.geotiff.compression.CompressionDecoder;
import org.meteoinfo.data.mapdata.geotiff.compression.DeflateCompression;
import org.meteoinfo.data.mapdata.geotiff.compression.LZWCompression;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.util.BigDecimalUtil;
import org.meteoinfo.math.ArrayMath;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.info.ProjectionInfo;

public class GeoTiff {
    private String filename;
    private RandomAccessFile file;
    private FileChannel channel;
    private List<IFDEntry> tags = new ArrayList<IFDEntry>();
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private boolean readonly;
    private boolean showBytes = false;
    private boolean debugRead = false;
    private boolean debugReadGeoKey = false;
    private boolean showHeaderBytes = false;
    private int headerSize = 8;
    private int firstIFD = 0;
    private int lastIFD = 0;
    private int startOverflowData = 0;
    private int nextOverflowData = 0;
    private List<GeoKey> geokeys = new ArrayList<GeoKey>();

    public GeoTiff(String filename) {
        this.filename = filename;
    }

    public void close() throws IOException {
        if (this.channel != null) {
            if (!this.readonly) {
                this.channel.force(true);
                this.channel.truncate(this.nextOverflowData);
            }
            this.channel.close();
        }
        if (this.file != null) {
            this.file.close();
        }
    }

    void addTag(IFDEntry ifd) {
        this.tags.add(ifd);
    }

    void deleteTag(IFDEntry ifd) {
        this.tags.remove(ifd);
    }

    void setTransform(double xStart, double yStart, double xInc, double yInc) {
        this.addTag(new IFDEntry(Tag.ModelTiepointTag, FieldType.DOUBLE).setValue(new double[]{0.0, 0.0, 0.0, xStart, yStart, 0.0}));
        this.addTag(new IFDEntry(Tag.ModelPixelScaleTag, FieldType.DOUBLE).setValue(new double[]{xInc, yInc, 0.0}));
    }

    void addGeoKey(GeoKey geokey) {
        this.geokeys.add(geokey);
    }

    private void writeGeoKeys() {
        if (this.geokeys.isEmpty()) {
            return;
        }
        int extra_chars = 0;
        int extra_ints = 0;
        int extra_doubles = 0;
        for (GeoKey geokey : this.geokeys) {
            if (geokey.isDouble) {
                extra_doubles += geokey.count();
                continue;
            }
            if (geokey.isString) {
                extra_chars += geokey.valueString().length() + 1;
                continue;
            }
            if (geokey.count() <= 1) continue;
            extra_ints += geokey.count();
        }
        int n = (this.geokeys.size() + 1) * 4;
        int[] values = new int[n + extra_ints];
        double[] dvalues = new double[extra_doubles];
        char[] cvalues = new char[extra_chars];
        int icounter = n;
        int dcounter = 0;
        int ccounter = 0;
        values[0] = 1;
        values[1] = 1;
        values[2] = 0;
        values[3] = this.geokeys.size();
        int count = 4;
        for (GeoKey geokey : this.geokeys) {
            int k;
            values[count++] = geokey.tagCode();
            if (geokey.isDouble) {
                values[count++] = Tag.GeoDoubleParamsTag.getCode();
                values[count++] = geokey.count();
                values[count++] = dcounter;
                for (k = 0; k < geokey.count(); ++k) {
                    dvalues[dcounter++] = geokey.valueD(k);
                }
                continue;
            }
            if (geokey.isString) {
                String s = geokey.valueString();
                values[count++] = Tag.GeoAsciiParamsTag.getCode();
                values[count++] = s.length();
                values[count++] = ccounter;
                for (int k2 = 0; k2 < s.length(); ++k2) {
                    cvalues[ccounter++] = s.charAt(k2);
                }
                cvalues[ccounter++] = '\u0000';
                continue;
            }
            if (geokey.count() > 1) {
                values[count++] = Tag.GeoKeyDirectoryTag.getCode();
                values[count++] = geokey.count();
                values[count++] = icounter;
                for (k = 0; k < geokey.count(); ++k) {
                    values[icounter++] = geokey.value(k);
                }
                continue;
            }
            values[count++] = 0;
            values[count++] = 1;
            values[count++] = geokey.value();
        }
        this.addTag(new IFDEntry(Tag.GeoKeyDirectoryTag, FieldType.SHORT).setValue(values));
        if (extra_doubles > 0) {
            this.addTag(new IFDEntry(Tag.GeoDoubleParamsTag, FieldType.DOUBLE).setValue(dvalues));
        }
        if (extra_chars > 0) {
            this.addTag(new IFDEntry(Tag.GeoAsciiParamsTag, FieldType.ASCII).setValue(new String(cvalues)));
        }
    }

    int writeData(byte[] data, int imageNumber) throws IOException {
        if (this.file == null) {
            this.init();
        }
        if (imageNumber == 1) {
            this.channel.position(this.headerSize);
        } else {
            this.channel.position(this.nextOverflowData);
        }
        ByteBuffer buffer = ByteBuffer.wrap(data);
        this.channel.write(buffer);
        this.firstIFD = imageNumber == 1 ? this.headerSize + data.length : data.length + this.nextOverflowData;
        return this.nextOverflowData;
    }

    int writeData(float[] data, int imageNumber) throws IOException {
        if (this.file == null) {
            this.init();
        }
        if (imageNumber == 1) {
            this.channel.position(this.headerSize);
        } else {
            this.channel.position(this.nextOverflowData);
        }
        ByteBuffer direct = ByteBuffer.allocateDirect(4 * data.length);
        FloatBuffer buffer = direct.asFloatBuffer();
        buffer.put(data);
        this.channel.write(direct);
        this.firstIFD = imageNumber == 1 ? this.headerSize + 4 * data.length : 4 * data.length + this.nextOverflowData;
        return this.nextOverflowData;
    }

    void writeMetadata(int imageNumber) throws IOException {
        if (this.file == null) {
            this.init();
        }
        this.writeGeoKeys();
        Collections.sort(this.tags);
        int start = 0;
        if (imageNumber == 1) {
            start = this.writeHeader(this.channel);
        } else {
            this.channel.position(this.lastIFD);
            ByteBuffer buffer = ByteBuffer.allocate(4);
            if (this.debugRead) {
                System.out.println("position before writing nextIFD= " + this.channel.position() + " IFD is " + this.firstIFD);
            }
            buffer.putInt(this.firstIFD);
            ((Buffer)buffer).flip();
            this.channel.write(buffer);
        }
        this.writeIFD(this.channel, this.firstIFD);
    }

    private int writeHeader(FileChannel channel) throws IOException {
        channel.position(0L);
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put((byte)77);
        buffer.put((byte)77);
        buffer.putShort((short)42);
        buffer.putInt(this.firstIFD);
        ((Buffer)buffer).flip();
        channel.write(buffer);
        return this.firstIFD;
    }

    public void initTags() throws IOException {
        this.tags = new ArrayList<IFDEntry>();
        this.geokeys = new ArrayList<GeoKey>();
    }

    private void init() throws IOException {
        this.file = new RandomAccessFile(this.filename, "rw");
        this.channel = this.file.getChannel();
        if (this.debugRead) {
            System.out.println("Opened file to write: '" + this.filename + "', size=" + this.channel.size());
        }
        this.readonly = false;
    }

    private void writeIFD(FileChannel channel, int start) throws IOException {
        channel.position(start);
        ByteBuffer buffer = ByteBuffer.allocate(2);
        int n = this.tags.size();
        buffer.putShort((short)n);
        ((Buffer)buffer).flip();
        channel.write(buffer);
        this.nextOverflowData = this.startOverflowData = (start += 2) + 12 * this.tags.size() + 4;
        for (IFDEntry elem : this.tags) {
            this.writeIFDEntry(channel, elem, start);
            start += 12;
        }
        channel.position(this.startOverflowData - 4);
        this.lastIFD = this.startOverflowData - 4;
        if (this.debugRead) {
            System.out.println("pos before writing nextIFD= " + channel.position());
        }
        buffer = ByteBuffer.allocate(4);
        buffer.putInt(0);
        ((Buffer)buffer).flip();
        channel.write(buffer);
    }

    private void writeIFDEntry(FileChannel channel, IFDEntry ifd, int start) throws IOException {
        channel.position(start);
        ByteBuffer buffer = ByteBuffer.allocate(12);
        buffer.putShort((short)ifd.tag.getCode());
        buffer.putShort((short)ifd.type.code);
        buffer.putInt(ifd.count);
        int size = ifd.count * ifd.type.size;
        if (size <= 4) {
            int done = this.writeValues(buffer, ifd);
            for (int k = 0; k < 4 - done; ++k) {
                buffer.put((byte)0);
            }
            ((Buffer)buffer).flip();
            channel.write(buffer);
        } else {
            buffer.putInt(this.nextOverflowData);
            ((Buffer)buffer).flip();
            channel.write(buffer);
            channel.position(this.nextOverflowData);
            ByteBuffer vbuffer = ByteBuffer.allocate(size);
            this.writeValues(vbuffer, ifd);
            ((Buffer)vbuffer).flip();
            channel.write(vbuffer);
            this.nextOverflowData += size;
        }
    }

    private int writeValues(ByteBuffer buffer, IFDEntry ifd) {
        int done = 0;
        if (ifd.type == FieldType.ASCII) {
            return this.writeSValue(buffer, ifd);
        }
        if (ifd.type == FieldType.RATIONAL) {
            for (int i = 0; i < ifd.count * 2; ++i) {
                done += this.writeIntValue(buffer, ifd, ifd.value[i]);
            }
        } else if (ifd.type == FieldType.FLOAT) {
            for (int i = 0; i < ifd.count; ++i) {
                buffer.putFloat((float)ifd.valueD[i]);
            }
            done += ifd.count * 4;
        } else if (ifd.type == FieldType.DOUBLE) {
            for (int i = 0; i < ifd.count; ++i) {
                buffer.putDouble(ifd.valueD[i]);
            }
            done += ifd.count * 8;
        } else {
            for (int i = 0; i < ifd.count; ++i) {
                done += this.writeIntValue(buffer, ifd, ifd.value[i]);
            }
        }
        return done;
    }

    private int writeIntValue(ByteBuffer buffer, IFDEntry ifd, int v) {
        switch (ifd.type.code) {
            case 1: {
                buffer.put((byte)v);
                return 1;
            }
            case 3: {
                buffer.putShort((short)v);
                return 2;
            }
            case 4: {
                buffer.putInt(v);
                return 4;
            }
            case 5: {
                buffer.putInt(v);
                return 4;
            }
        }
        return 0;
    }

    private int writeSValue(ByteBuffer buffer, IFDEntry ifd) {
        buffer.put(ifd.valueS.getBytes());
        int size = ifd.valueS.length();
        if (size % 2 == 1) {
            ++size;
        }
        return size;
    }

    public void read() throws IOException {
        this.file = new RandomAccessFile(this.filename, "r");
        this.channel = this.file.getChannel();
        if (this.debugRead) {
            System.out.println("Opened file to read:'" + this.filename + "', size=" + this.channel.size());
        }
        this.readonly = true;
        int nextOffset = this.readHeader(this.channel);
        while (nextOffset > 0) {
            nextOffset = this.readIFD(this.channel, nextOffset);
            this.parseGeoInfo();
        }
    }

    IFDEntry findTag(Tag tag) {
        if (tag == null) {
            return null;
        }
        for (IFDEntry ifd : this.tags) {
            if (ifd.tag != tag) continue;
            return ifd;
        }
        return null;
    }

    public List<double[]> readXY() {
        int i;
        double ydelta;
        double xdelta;
        double maxLat;
        double minLon;
        IFDEntry widthIFD = this.findTag(Tag.ImageWidth);
        IFDEntry heightIFD = this.findTag(Tag.ImageLength);
        int width = widthIFD.value[0];
        int height = heightIFD.value[0];
        double[] X = new double[width];
        double[] Y = new double[height];
        IFDEntry modelTransformationTag = this.findTag(Tag.ModelTransformationTag);
        if (modelTransformationTag != null) {
            minLon = modelTransformationTag.valueD[3];
            maxLat = modelTransformationTag.valueD[7];
            xdelta = modelTransformationTag.valueD[0];
            ydelta = -modelTransformationTag.valueD[5];
        } else {
            IFDEntry modelTiePointTag = this.findTag(Tag.ModelTiepointTag);
            IFDEntry modelPixelScaleTag = this.findTag(Tag.ModelPixelScaleTag);
            minLon = modelTiePointTag.valueD[3];
            maxLat = modelTiePointTag.valueD[4];
            xdelta = modelPixelScaleTag.valueD[0];
            ydelta = modelPixelScaleTag.valueD[1];
        }
        for (i = 0; i < width; ++i) {
            X[i] = BigDecimalUtil.add(minLon, BigDecimalUtil.mul(xdelta, (double)i));
        }
        for (i = 0; i < height; ++i) {
            Y[height - i - 1] = BigDecimalUtil.sub(maxLat, BigDecimalUtil.mul(ydelta, (double)i));
        }
        ArrayList<double[]> xy = new ArrayList<double[]>();
        xy.add(X);
        xy.add(Y);
        return xy;
    }

    public int[][] readData() {
        try {
            IFDEntry widthIFD = this.findTag(Tag.ImageWidth);
            IFDEntry heightIFD = this.findTag(Tag.ImageLength);
            int width = widthIFD.value[0];
            int height = heightIFD.value[0];
            int[] values1d = this.readData(width, height);
            int[][] values = new int[height][width];
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    values[height - i - 1][j] = values1d[i * width + j];
                }
            }
            values1d = null;
            return values;
        }
        catch (IOException ex) {
            Logger.getLogger(GeoTiff.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public GridArray getGridArray() {
        try {
            String projStr;
            int i;
            IFDEntry widthIFD = this.findTag(Tag.ImageWidth);
            IFDEntry heightIFD = this.findTag(Tag.ImageLength);
            int width = widthIFD.value[0];
            int height = heightIFD.value[0];
            GridArray gData = new GridArray();
            gData.data = this.readArray();
            double[] X = new double[width];
            double[] Y = new double[height];
            IFDEntry modelTiePointTag = this.findTag(Tag.ModelTiepointTag);
            IFDEntry modelPixelScaleTag = this.findTag(Tag.ModelPixelScaleTag);
            double minLon = modelTiePointTag.valueD[3];
            double maxLat = modelTiePointTag.valueD[4];
            double xdelt = modelPixelScaleTag.valueD[0];
            double ydelt = modelPixelScaleTag.valueD[1];
            for (i = 0; i < width; ++i) {
                X[i] = minLon + xdelt * (double)i;
            }
            for (i = 0; i < height; ++i) {
                Y[height - i - 1] = maxLat - ydelt * (double)i;
            }
            gData.xArray = X;
            gData.yArray = Y;
            IFDEntry noDataTag = this.findTag(Tag.GDALNoData);
            if (noDataTag != null) {
                double missingValue;
                gData.missingValue = missingValue = Double.parseDouble(noDataTag.valueS);
            }
            gData.projInfo = (projStr = this.getProjection()) != null ? ProjectionInfo.factory(projStr) : KnownCoordinateSystems.geographic.world.WGS1984;
            return gData;
        }
        catch (IOException ex) {
            Logger.getLogger(GeoTiff.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public GridData getGridData() {
        try {
            int i;
            IFDEntry widthIFD = this.findTag(Tag.ImageWidth);
            IFDEntry heightIFD = this.findTag(Tag.ImageLength);
            int width = widthIFD.value[0];
            int height = heightIFD.value[0];
            GridData.Integer gData = new GridData.Integer(height, width);
            int[] values1d = this.readData(width, height);
            for (int i2 = 0; i2 < height; ++i2) {
                for (int j = 0; j < width; ++j) {
                    gData.setValue(height - i2 - 1, j, values1d[i2 * width + j]);
                }
            }
            values1d = null;
            double[] X = new double[width];
            double[] Y = new double[height];
            IFDEntry modelTiePointTag = this.findTag(Tag.ModelTiepointTag);
            IFDEntry modelPixelScaleTag = this.findTag(Tag.ModelPixelScaleTag);
            double minLon = modelTiePointTag.valueD[3];
            double maxLat = modelTiePointTag.valueD[4];
            double xdelt = modelPixelScaleTag.valueD[0];
            double ydelt = modelPixelScaleTag.valueD[1];
            for (i = 0; i < width; ++i) {
                X[i] = minLon + xdelt * (double)i;
            }
            for (i = 0; i < height; ++i) {
                Y[height - i - 1] = maxLat - ydelt * (double)i;
            }
            gData.xArray = X;
            gData.yArray = Y;
            String projStr = this.getProjection();
            gData.projInfo = projStr != null ? ProjectionInfo.factory(projStr) : KnownCoordinateSystems.geographic.world.WGS1984;
            return gData;
        }
        catch (IOException ex) {
            Logger.getLogger(GeoTiff.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public GridData getGridData_Value() {
        try {
            IFDEntry widthIFD = this.findTag(Tag.ImageWidth);
            IFDEntry heightIFD = this.findTag(Tag.ImageLength);
            int width = widthIFD.value[0];
            int height = heightIFD.value[0];
            GridData.Integer gData = new GridData.Integer(height, width);
            int[] values1d = this.readData(width, height);
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    gData.setValue(height - i - 1, j, values1d[i * width + j]);
                }
            }
            values1d = null;
            return gData;
        }
        catch (IOException ex) {
            Logger.getLogger(GeoTiff.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public ProjectionInfo readProj() {
        String projStr = this.getProjection();
        if (projStr != null) {
            return ProjectionInfo.factory(projStr);
        }
        return KnownCoordinateSystems.geographic.world.WGS1984;
    }

    private String getProjection() {
        GeoKey gtModelTypeGeoKey;
        String projStr = null;
        IFDEntry geoKeyDirectoryTag = this.findTag(Tag.GeoKeyDirectoryTag);
        if (geoKeyDirectoryTag != null && (gtModelTypeGeoKey = geoKeyDirectoryTag.findGeoKey(GeoKey.Tag.GTModelTypeGeoKey)).value() == 1) {
            GeoKey projCoordTrans = geoKeyDirectoryTag.findGeoKey(GeoKey.Tag.GeoKey_ProjCoordTrans);
            GeoKey projStdParallel1 = geoKeyDirectoryTag.findGeoKey(GeoKey.Tag.GeoKey_ProjStdParallel1);
            double lat_1 = projStdParallel1 == null ? 0.0 : projStdParallel1.valueD(0);
            GeoKey projStdParallel2 = geoKeyDirectoryTag.findGeoKey(GeoKey.Tag.GeoKey_ProjStdParallel2);
            double lat_2 = projStdParallel2 == null ? 0.0 : projStdParallel2.valueD(0);
            GeoKey projCenterLong = geoKeyDirectoryTag.findGeoKey(GeoKey.Tag.GeoKey_ProjNatOriginLong);
            if (projCenterLong == null) {
                projCenterLong = geoKeyDirectoryTag.findGeoKey(GeoKey.Tag.GeoKey_ProjCenterLong);
            }
            double lon_0 = projCenterLong == null ? 0.0 : projCenterLong.valueD(0);
            GeoKey projNatOriginLat = geoKeyDirectoryTag.findGeoKey(GeoKey.Tag.GeoKey_ProjNatOriginLat);
            double lat_0 = projNatOriginLat == null ? 0.0 : projNatOriginLat.valueD(0);
            GeoKey projFalseEasting = geoKeyDirectoryTag.findGeoKey(GeoKey.Tag.GeoKey_ProjFalseEasting);
            double x_0 = projFalseEasting == null ? 0.0 : projFalseEasting.valueD(0);
            GeoKey projFalseNorthing = geoKeyDirectoryTag.findGeoKey(GeoKey.Tag.GeoKey_ProjFalseNorthing);
            double y_0 = projFalseNorthing == null ? 0.0 : projFalseNorthing.valueD(0);
            GeoKey projScaleAtNatOrigin = geoKeyDirectoryTag.findGeoKey(GeoKey.Tag.ProjScaleAtNatOriginGeoKey);
            double k_0 = projScaleAtNatOrigin == null ? 1.0 : projScaleAtNatOrigin.valueD(0);
            switch (projCoordTrans.value()) {
                case 1: {
                    projStr = "+proj=tmerc+lat_0=" + String.valueOf(lat_0) + "+lon_0=" + String.valueOf(lon_0) + "+k_0=" + String.valueOf(k_0) + "+x_0=" + String.valueOf(x_0) + "+y_0=" + String.valueOf(y_0);
                    break;
                }
                case 11: {
                    projStr = "+proj=aea+lat_1=" + String.valueOf(lat_1) + "+lat_2=" + String.valueOf(lat_2) + "+lon_0=" + String.valueOf(lon_0) + "+lat_0=" + String.valueOf(lat_0) + "+x_0=" + String.valueOf(x_0) + "+y_0=" + String.valueOf(y_0);
                }
            }
        }
        return projStr;
    }

    public int[] readData(int width, int height) throws IOException {
        int[] values;
        block13: {
            block11: {
                int tileSize;
                int vTileNum;
                int hTileNum;
                int tileHeight;
                int tileWidth;
                IFDEntry tileSizeTag;
                int tileOffset;
                IFDEntry tileOffsetTag;
                int bitsPerSample;
                block12: {
                    values = new int[width * height];
                    IFDEntry bitsPerSampleTag = this.findTag(Tag.BitsPerSample);
                    bitsPerSample = bitsPerSampleTag.value[0];
                    tileOffsetTag = this.findTag(Tag.TileOffsets);
                    if (tileOffsetTag == null) break block11;
                    tileOffset = tileOffsetTag.value[0];
                    tileSizeTag = this.findTag(Tag.TileByteCounts);
                    IFDEntry tileLengthTag = this.findTag(Tag.TileLength);
                    IFDEntry tileWidthTag = this.findTag(Tag.TileWidth);
                    tileWidth = tileWidthTag.value[0];
                    tileHeight = tileLengthTag.value[0];
                    hTileNum = (width + tileWidth - 1) / tileWidth;
                    vTileNum = (height + tileHeight - 1) / tileHeight;
                    tileSize = tileSizeTag.value[0];
                    System.out.println("tileOffset =" + tileOffset + " tileSize=" + tileSize);
                    if (bitsPerSample != 8) break block12;
                    for (int i = 0; i < vTileNum; ++i) {
                        for (int j = 0; j < hTileNum; ++j) {
                            int vIdx;
                            int tileIdx = i * hTileNum + j;
                            tileOffset = tileOffsetTag.value[tileIdx];
                            tileSize = tileSizeTag.value[tileIdx];
                            ByteBuffer buffer = this.testReadData(tileOffset, tileSize);
                            for (int h = 0; h < tileHeight && (vIdx = i * tileHeight + h) != height; ++h) {
                                int hIdx;
                                for (int w = 0; w < tileWidth && (hIdx = j * tileWidth + w) != width; ++w) {
                                    int idx = vIdx * width + hIdx;
                                    values[idx] = buffer.get();
                                }
                            }
                        }
                    }
                    break block13;
                }
                if (bitsPerSample != 16) break block13;
                for (int i = 0; i < vTileNum; ++i) {
                    for (int j = 0; j < hTileNum; ++j) {
                        int vIdx;
                        int tileIdx = i * hTileNum + j;
                        tileOffset = tileOffsetTag.value[tileIdx];
                        tileSize = tileSizeTag.value[tileIdx];
                        ByteBuffer buffer = this.testReadData(tileOffset, tileSize);
                        for (int h = 0; h < tileHeight && (vIdx = i * tileHeight + h) != height; ++h) {
                            int hIdx;
                            for (int w = 0; w < tileWidth && (hIdx = j * tileWidth + w) != width; ++w) {
                                int idx = vIdx * width + hIdx;
                                values[idx] = buffer.getShort();
                            }
                        }
                    }
                }
                break block13;
            }
            IFDEntry stripOffsetTag = this.findTag(Tag.StripOffsets);
            if (stripOffsetTag != null) {
                int stripNum = stripOffsetTag.count;
                IFDEntry stripSizeTag = this.findTag(Tag.StripByteCounts);
                int stripSize = stripSizeTag.value[0];
                IFDEntry rowsPerStripTag = this.findTag(Tag.RowsPerStrip);
                int rowNum = rowsPerStripTag.value[0];
                int n = 0;
                for (int i = 0; i < stripNum; ++i) {
                    int stripOffset = stripOffsetTag.value[i];
                    ByteBuffer buffer = this.testReadData(stripOffset, stripSize);
                    for (int j = 0; j < width * rowNum; ++j) {
                        values[n] = buffer.getShort();
                        ++n;
                    }
                }
            }
        }
        return values;
    }

    public int getBandNum() {
        IFDEntry samplesPerPixelTag = this.findTag(Tag.SamplesPerPixel);
        int samplesPerPixel = samplesPerPixelTag.value[0];
        return samplesPerPixel;
    }

    public Array readArray() throws IOException {
        Array r;
        block59: {
            CompressionDecoder cDecoder;
            DataType dataType;
            int bitsPerSample;
            int samplesPerPixel;
            int width;
            block58: {
                IFDEntry tileOffsetTag;
                int compression;
                IFDEntry widthIFD = this.findTag(Tag.ImageWidth);
                IFDEntry heightIFD = this.findTag(Tag.ImageLength);
                width = widthIFD.value[0];
                int height = heightIFD.value[0];
                IFDEntry samplesPerPixelTag = this.findTag(Tag.SamplesPerPixel);
                samplesPerPixel = samplesPerPixelTag.value[0];
                IFDEntry bitsPerSampleTag = this.findTag(Tag.BitsPerSample);
                bitsPerSample = bitsPerSampleTag.value[0];
                int[] shape = samplesPerPixel == 1 ? new int[]{height, width} : new int[]{height, width, samplesPerPixel};
                dataType = DataType.INT;
                IFDEntry sampleFormatTag = this.findTag(Tag.SampleFormat);
                int sampleFormat = 0;
                if (sampleFormatTag != null) {
                    sampleFormat = sampleFormatTag.value[0];
                }
                switch (bitsPerSample) {
                    case 32: {
                        switch (sampleFormat) {
                            case 3: {
                                dataType = DataType.FLOAT;
                            }
                        }
                    }
                }
                r = Array.factory(dataType, shape);
                IFDEntry compressionTag = this.findTag(Tag.Compression);
                cDecoder = null;
                if (compressionTag != null && (compression = compressionTag.value[0]) > 1) {
                    switch (compression) {
                        case 5: {
                            cDecoder = new LZWCompression();
                            break;
                        }
                        case 8: {
                            cDecoder = new DeflateCompression();
                        }
                    }
                }
                if ((tileOffsetTag = this.findTag(Tag.TileOffsets)) == null) break block58;
                Index index = r.getIndex();
                IFDEntry tileSizeTag = this.findTag(Tag.TileByteCounts);
                IFDEntry tileLengthTag = this.findTag(Tag.TileLength);
                IFDEntry tileWidthTag = this.findTag(Tag.TileWidth);
                int tileWidth = tileWidthTag.value[0];
                int tileHeight = tileLengthTag.value[0];
                int hTileNum = (width + tileWidth - 1) / tileWidth;
                int vTileNum = (height + tileHeight - 1) / tileHeight;
                switch (bitsPerSample) {
                    case 8: {
                        for (int i = 0; i < vTileNum; ++i) {
                            for (int j = 0; j < hTileNum; ++j) {
                                int vIdx;
                                int tileIdx = i * hTileNum + j;
                                int tileOffset = tileOffsetTag.value[tileIdx];
                                int tileSize = tileSizeTag.value[tileIdx];
                                ByteBuffer buffer = this.testReadData(tileOffset, tileSize);
                                for (int h = 0; h < tileHeight && (vIdx = i * tileHeight + h) != height; ++h) {
                                    int hIdx;
                                    for (int w = 0; w < tileWidth && (hIdx = j * tileWidth + w) != width; ++w) {
                                        index.set0(vIdx);
                                        index.set1(hIdx);
                                        if (samplesPerPixel == 1) {
                                            r.setInt(index, DataConvert.byte2Int(buffer.get()));
                                            continue;
                                        }
                                        for (int k = 0; k < samplesPerPixel; ++k) {
                                            index.set2(k);
                                            r.setInt(index, DataConvert.byte2Int(buffer.get()));
                                        }
                                    }
                                }
                            }
                        }
                        break block59;
                    }
                    case 16: {
                        for (int i = 0; i < vTileNum; ++i) {
                            for (int j = 0; j < hTileNum; ++j) {
                                int vIdx;
                                int tileIdx = i * hTileNum + j;
                                int tileOffset = tileOffsetTag.value[tileIdx];
                                int tileSize = tileSizeTag.value[tileIdx];
                                ByteBuffer buffer = this.testReadData(tileOffset, tileSize);
                                for (int h = 0; h < tileHeight && (vIdx = i * tileHeight + h) != height; ++h) {
                                    int hIdx;
                                    for (int w = 0; w < tileWidth && (hIdx = j * tileWidth + w) != width; ++w) {
                                        index.set0(vIdx);
                                        index.set1(hIdx);
                                        if (samplesPerPixel == 1) {
                                            r.setInt(index, (int)buffer.getShort());
                                            continue;
                                        }
                                        for (int k = 0; k < samplesPerPixel; ++k) {
                                            index.set2(k);
                                            r.setInt(index, (int)buffer.getShort());
                                        }
                                    }
                                }
                            }
                        }
                        break block59;
                    }
                    case 32: {
                        int size = tileHeight * tileWidth * 4;
                        for (int i = 0; i < vTileNum; ++i) {
                            for (int j = 0; j < hTileNum; ++j) {
                                int vIdx;
                                int tileIdx = i * hTileNum + j;
                                int tileOffset = tileOffsetTag.value[tileIdx];
                                int tileSize = tileSizeTag.value[tileIdx];
                                if (tileSize == 0) continue;
                                ByteBuffer buffer = this.testReadData(tileOffset, tileSize);
                                if (cDecoder != null) {
                                    if ((buffer = ByteBuffer.wrap(cDecoder.decode(buffer.array(), this.byteOrder))).limit() < size) {
                                        ByteBuffer nbuffer = ByteBuffer.allocate(size);
                                        nbuffer.put(buffer.array());
                                        buffer = nbuffer;
                                        ((Buffer)buffer).position(0);
                                    }
                                    buffer.order(this.byteOrder);
                                }
                                block32: for (int h = 0; h < tileHeight && (vIdx = i * tileHeight + h) != height; ++h) {
                                    index.set0(vIdx);
                                    for (int w = 0; w < tileWidth; ++w) {
                                        int hIdx = j * tileWidth + w;
                                        if (hIdx == width) {
                                            buffer.get(new byte[(tileWidth - w) * 4]);
                                            continue block32;
                                        }
                                        index.set1(hIdx);
                                        if (samplesPerPixel == 1) {
                                            if (dataType == DataType.FLOAT) {
                                                r.setFloat(index, buffer.getFloat());
                                                continue;
                                            }
                                            r.setInt(index, buffer.getInt());
                                            continue;
                                        }
                                        for (int k = 0; k < samplesPerPixel; ++k) {
                                            index.set2(k);
                                            if (dataType == DataType.FLOAT) {
                                                r.setFloat(index, buffer.getFloat());
                                                continue;
                                            }
                                            r.setInt(index, buffer.getInt());
                                        }
                                    }
                                }
                            }
                        }
                        break block59;
                    }
                }
                break block59;
            }
            IFDEntry stripOffsetTag = this.findTag(Tag.StripOffsets);
            if (stripOffsetTag != null) {
                int stripNum = stripOffsetTag.count;
                IFDEntry stripSizeTag = this.findTag(Tag.StripByteCounts);
                int stripSize = stripSizeTag.value[0];
                IFDEntry rowsPerStripTag = this.findTag(Tag.RowsPerStrip);
                int rowNum = rowsPerStripTag.value[0];
                int idx = 0;
                switch (bitsPerSample) {
                    case 8: {
                        for (int i = 0; i < stripNum; ++i) {
                            int stripOffset = stripOffsetTag.value[i];
                            ByteBuffer buffer = this.testReadData(stripOffset, stripSize);
                            for (int j = 0; j < width * rowNum; ++j) {
                                for (int k = 0; k < samplesPerPixel; ++k) {
                                    r.setInt(idx, DataConvert.byte2Int(buffer.get()));
                                    ++idx;
                                }
                            }
                        }
                        break;
                    }
                    case 16: {
                        for (int i = 0; i < stripNum; ++i) {
                            int stripOffset = stripOffsetTag.value[i];
                            ByteBuffer buffer = this.testReadData(stripOffset, stripSize);
                            for (int j = 0; j < width * rowNum; ++j) {
                                for (int k = 0; k < samplesPerPixel; ++k) {
                                    if (dataType == DataType.FLOAT) {
                                        r.setFloat(idx, buffer.getFloat());
                                    } else {
                                        r.setInt(idx, buffer.getInt());
                                    }
                                    ++idx;
                                }
                            }
                        }
                        break;
                    }
                    case 32: {
                        for (int i = 0; i < stripNum; ++i) {
                            int stripOffset = stripOffsetTag.value[i];
                            stripSize = stripSizeTag.value[i];
                            ByteBuffer buffer = this.testReadData(stripOffset, stripSize);
                            if (cDecoder != null) {
                                buffer = ByteBuffer.wrap(cDecoder.decode(buffer.array(), this.byteOrder));
                                buffer.order(this.byteOrder);
                            }
                            for (int j = 0; j < width * rowNum; ++j) {
                                for (int k = 0; k < samplesPerPixel; ++k) {
                                    r.setFloat(idx, buffer.getFloat());
                                    ++idx;
                                }
                            }
                        }
                        break;
                    }
                }
            }
        }
        r = ArrayMath.flip(r, 0);
        return r;
    }

    private ByteBuffer testReadData(int offset, int size) throws IOException {
        this.channel.position(offset);
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.order(this.byteOrder);
        this.channel.read(buffer);
        ((Buffer)buffer).flip();
        return buffer;
    }

    private int readHeader(FileChannel channel) throws IOException {
        byte b;
        channel.position(0L);
        ByteBuffer buffer = ByteBuffer.allocate(8);
        channel.read(buffer);
        ((Buffer)buffer).flip();
        if (this.showHeaderBytes) {
            this.printBytes(System.out, "header", buffer, 4);
            buffer.rewind();
        }
        if ((b = buffer.get()) == 73) {
            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
        }
        buffer.order(this.byteOrder);
        ((Buffer)buffer).position(4);
        int firstIFD = buffer.getInt();
        if (this.debugRead) {
            System.out.println(" firstIFD == " + firstIFD);
        }
        return firstIFD;
    }

    private int readIFD(FileChannel channel, int start) throws IOException {
        channel.position(start);
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.order(this.byteOrder);
        int n = channel.read(buffer);
        ((Buffer)buffer).flip();
        if (this.showBytes) {
            this.printBytes(System.out, "IFD", buffer, 2);
            buffer.rewind();
        }
        int nentries = buffer.getShort();
        if (this.debugRead) {
            System.out.println(" nentries = " + nentries);
        }
        start += 2;
        for (int i = 0; i < nentries; ++i) {
            IFDEntry ifd = this.readIFDEntry(channel, start);
            if (this.debugRead) {
                System.out.println(i + " == " + ifd);
            }
            this.tags.add(ifd);
            start += 12;
        }
        if (this.debugRead) {
            System.out.println(" looking for nextIFD at pos == " + channel.position() + " start = " + start);
        }
        channel.position(start);
        buffer = ByteBuffer.allocate(4);
        buffer.order(this.byteOrder);
        n = channel.read(buffer);
        ((Buffer)buffer).flip();
        int nextIFD = buffer.getInt();
        if (this.debugRead) {
            System.out.println(" nextIFD == " + nextIFD);
        }
        return nextIFD;
    }

    private IFDEntry readIFDEntry(FileChannel channel, int start) throws IOException {
        if (this.debugRead) {
            System.out.println("readIFDEntry starting position to " + start);
        }
        channel.position(start);
        ByteBuffer buffer = ByteBuffer.allocate(12);
        buffer.order(this.byteOrder);
        channel.read(buffer);
        ((Buffer)buffer).flip();
        if (this.showBytes) {
            this.printBytes(System.out, "IFDEntry bytes", buffer, 12);
        }
        ((Buffer)buffer).position(0);
        int code = this.readUShortValue(buffer);
        Tag tag = Tag.get(code);
        if (tag == null) {
            tag = new Tag(code);
        }
        FieldType type = FieldType.get(this.readUShortValue(buffer));
        int count = buffer.getInt();
        IFDEntry ifd = new IFDEntry(tag, type, count);
        if (ifd.count * ifd.type.size <= 4) {
            this.readValues(buffer, ifd);
        } else {
            int offset = buffer.getInt();
            if (this.debugRead) {
                System.out.println("position to " + offset);
            }
            channel.position(offset);
            ByteBuffer vbuffer = ByteBuffer.allocate(ifd.count * ifd.type.size);
            vbuffer.order(this.byteOrder);
            channel.read(vbuffer);
            ((Buffer)vbuffer).flip();
            this.readValues(vbuffer, ifd);
        }
        return ifd;
    }

    private void readValues(ByteBuffer buffer, IFDEntry ifd) {
        if (ifd.type == FieldType.ASCII) {
            ifd.valueS = this.readSValue(buffer, ifd);
        } else if (ifd.type == FieldType.RATIONAL) {
            ifd.value = new int[ifd.count * 2];
            for (int i = 0; i < ifd.count * 2; ++i) {
                ifd.value[i] = this.readIntValue(buffer, ifd);
            }
        } else if (ifd.type == FieldType.FLOAT) {
            ifd.valueD = new double[ifd.count];
            for (int i = 0; i < ifd.count; ++i) {
                ifd.valueD[i] = buffer.getFloat();
            }
        } else if (ifd.type == FieldType.DOUBLE) {
            ifd.valueD = new double[ifd.count];
            for (int i = 0; i < ifd.count; ++i) {
                ifd.valueD[i] = buffer.getDouble();
            }
        } else {
            ifd.value = new int[ifd.count];
            for (int i = 0; i < ifd.count; ++i) {
                ifd.value[i] = this.readIntValue(buffer, ifd);
            }
        }
    }

    private int readIntValue(ByteBuffer buffer, IFDEntry ifd) {
        switch (ifd.type.code) {
            case 1: {
                return buffer.get();
            }
            case 2: {
                return buffer.get();
            }
            case 3: {
                return this.readUShortValue(buffer);
            }
            case 4: {
                return buffer.getInt();
            }
            case 5: {
                return buffer.getInt();
            }
        }
        return 0;
    }

    private int readUShortValue(ByteBuffer buffer) {
        return buffer.getShort() & 0xFFFF;
    }

    private String readSValue(ByteBuffer buffer, IFDEntry ifd) {
        byte[] dst = new byte[ifd.count];
        buffer.get(dst);
        return new String(dst);
    }

    private void printBytes(PrintStream ps, String head, ByteBuffer buffer, int n) {
        ps.print(head + " == ");
        for (int i = 0; i < n; ++i) {
            int b = buffer.get();
            int ub = b < 0 ? b + 256 : b;
            ps.print(ub + "(");
            ps.write(b);
            ps.print(") ");
        }
        ps.println();
    }

    private void parseGeoInfo() {
        IFDEntry keyDir = this.findTag(Tag.GeoKeyDirectoryTag);
        IFDEntry dparms = this.findTag(Tag.GeoDoubleParamsTag);
        IFDEntry aparams = this.findTag(Tag.GeoAsciiParamsTag);
        if (null == keyDir) {
            return;
        }
        int nkeys = keyDir.value[3];
        if (this.debugReadGeoKey) {
            System.out.println("parseGeoInfo nkeys = " + nkeys + " keyDir= " + keyDir);
        }
        int pos = 4;
        for (int i = 0; i < nkeys; ++i) {
            int id = keyDir.value[pos++];
            int location = keyDir.value[pos++];
            int vcount = keyDir.value[pos++];
            int offset = keyDir.value[pos++];
            GeoKey.Tag tag = GeoKey.Tag.getOrMake(id);
            GeoKey key = null;
            if (location == 0) {
                key = new GeoKey(id, offset);
            } else {
                Object value;
                int k;
                IFDEntry data = this.findTag(Tag.get(location));
                if (data == null) {
                    System.out.println("********ERROR parseGeoInfo: cant find Tag code = " + location);
                } else if (data.tag == Tag.GeoDoubleParamsTag) {
                    double[] dvalue = new double[vcount];
                    for (k = 0; k < vcount; ++k) {
                        dvalue[k] = data.valueD[offset + k];
                    }
                    key = new GeoKey(tag, dvalue);
                } else if (data.tag == Tag.GeoKeyDirectoryTag) {
                    value = new int[vcount];
                    for (k = 0; k < vcount; ++k) {
                        value[k] = data.value[offset + k];
                    }
                    key = new GeoKey(tag, (int[])value);
                } else if (data.tag == Tag.GeoAsciiParamsTag) {
                    value = data.valueS.substring(offset, offset + vcount);
                    key = new GeoKey(tag, (String)value);
                }
            }
            if (key == null) continue;
            keyDir.addGeoKey(key);
            if (!this.debugReadGeoKey) continue;
            System.out.println(" yyy  add geokey=" + key);
        }
    }

    public void showInfo(PrintStream out) {
        out.println("Geotiff file= " + this.filename);
        for (int i = 0; i < this.tags.size(); ++i) {
            IFDEntry ifd = this.tags.get(i);
            out.println(i + " IFDEntry == " + ifd);
        }
    }

    public String showInfo() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        this.showInfo(new PrintStream(bout));
        return bout.toString();
    }
}

