/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.global.colors;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.colors.ColorUtil;
import org.meteoinfo.legend.LegendManage;

public class ColorMap {
    private Color[] colors;
    private String name = "";
    static final int GRADS_RAINBOW = 0;

    public ColorMap() {
        this.colors = new Color[1];
        this.colors[0] = Color.red;
    }

    public ColorMap(Color c) {
        this.colors = new Color[1];
        this.colors[0] = c;
    }

    public ColorMap(int n) {
        this.colors = new Color[n];
        Random randomColor = new Random();
        for (int i = 0; i < n; ++i) {
            this.colors[i] = new Color(randomColor.nextInt(256), randomColor.nextInt(256), randomColor.nextInt(256));
        }
    }

    public ColorMap(List<Color> cs) {
        this.colors = new Color[cs.size()];
        for (int i = 0; i < cs.size(); ++i) {
            this.colors[i] = cs.get(i);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public Color[] getColors() {
        return this.colors;
    }

    public void setColors(Color[] value) {
        this.colors = value;
    }

    public Color getColor(int idx) {
        return this.colors[idx];
    }

    public Color getColor(float idx) {
        int iidx = (int)idx;
        if (iidx >= this.colors.length - 1) {
            return this.colors[this.colors.length - 1];
        }
        if (idx - (float)iidx == 0.0f) {
            return this.colors[iidx];
        }
        Color sc = this.colors[iidx];
        Color ec = this.colors[iidx + 1];
        float p = idx - (float)iidx;
        Color c = ColorUtil.createColor(sc, ec, p);
        return c;
    }

    public void setColor(int idx, Color color) {
        this.colors[idx] = color;
    }

    public int getColorCount() {
        return this.colors.length;
    }

    public Color[] getColors(int n) {
        if (this.name.equalsIgnoreCase("grads_rainbow")) {
            return this.gradsRainBowColors(n);
        }
        Color[] ncs = new Color[n];
        int cn = this.colors.length;
        float step = (float)(cn - 1) / (float)(n - 1);
        float idx = 0.0f;
        for (int i = 0; i < n; ++i) {
            ncs[i] = this.getColor(idx);
            idx += step;
        }
        return ncs;
    }

    public Color[] getColors_bak(int n) {
        if (this.name.equalsIgnoreCase("grads_rainbow")) {
            return this.gradsRainBowColors(n);
        }
        Color[] ncs = new Color[n];
        int cn = this.colors.length;
        int gap = cn / n;
        if (gap == 0) {
            gap = 1;
        }
        int idx = 0;
        if (cn > n) {
            idx = cn % n / 2;
        }
        for (int i = 0; i < n; ++i) {
            ncs[i] = this.colors[idx];
            if ((idx += gap) < cn) continue;
            idx = 0;
        }
        return ncs;
    }

    public List<Color> getColorList(int n) {
        Color[] cs = this.getColors(n);
        ArrayList<Color> cols = new ArrayList<Color>();
        cols.addAll(Arrays.asList(cs));
        return cols;
    }

    public List<Color> getColorList(int n, int alpha) {
        Color[] cs = this.getColors(n);
        ArrayList<Color> cols = new ArrayList<Color>();
        for (Color c : cs) {
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
            cols.add(c);
        }
        return cols;
    }

    private Color[] gradsRainBowColors(int cNum) {
        if (cNum > 13) {
            return LegendManage.getRainBowColors_HSV(cNum);
        }
        ArrayList<Color> colorList = new ArrayList<Color>();
        colorList.add(new Color(160, 0, 200));
        colorList.add(new Color(110, 0, 220));
        colorList.add(new Color(30, 60, 255));
        colorList.add(new Color(0, 160, 255));
        colorList.add(new Color(0, 200, 200));
        colorList.add(new Color(0, 210, 140));
        colorList.add(new Color(0, 220, 0));
        colorList.add(new Color(160, 230, 50));
        colorList.add(new Color(230, 220, 50));
        colorList.add(new Color(230, 175, 45));
        colorList.add(new Color(240, 130, 40));
        colorList.add(new Color(250, 60, 60));
        colorList.add(new Color(240, 0, 130));
        switch (cNum) {
            case 12: {
                colorList.remove(new Color(0, 210, 140));
                break;
            }
            case 11: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                break;
            }
            case 10: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                break;
            }
            case 9: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                colorList.remove(new Color(160, 230, 50));
                break;
            }
            case 8: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                colorList.remove(new Color(160, 230, 50));
                colorList.remove(new Color(110, 0, 220));
                break;
            }
            case 7: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                colorList.remove(new Color(160, 230, 50));
                colorList.remove(new Color(110, 0, 220));
                colorList.remove(new Color(0, 200, 200));
                break;
            }
            case 6: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                colorList.remove(new Color(160, 230, 50));
                colorList.remove(new Color(110, 0, 220));
                colorList.remove(new Color(0, 200, 200));
                colorList.remove(new Color(240, 130, 40));
                break;
            }
            case 5: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                colorList.remove(new Color(160, 230, 50));
                colorList.remove(new Color(110, 0, 220));
                colorList.remove(new Color(0, 200, 200));
                colorList.remove(new Color(240, 130, 40));
                colorList.remove(new Color(160, 0, 200));
            }
        }
        Color[] cs = new Color[cNum];
        for (int i = 0; i < cNum; ++i) {
            cs[i] = (Color)colorList.get(i);
        }
        return cs;
    }

    public void reverse() {
        int left = 0;
        for (int right = this.colors.length - 1; left < right; ++left, --right) {
            Color temp = this.colors[left];
            this.colors[left] = this.colors[right];
            this.colors[right] = temp;
        }
    }

    private void readFromFile(BufferedReader sr) throws IOException {
        String line = sr.readLine();
        ArrayList<Color> clist = new ArrayList<Color>();
        int n = 0;
        boolean isdouble = false;
        while (line != null) {
            String[] strs = (line = line.trim()).split("\\s+");
            if (strs.length >= 3 && MIMath.isNumeric(strs[0]) && MIMath.isNumeric(strs[1]) && MIMath.isNumeric(strs[2])) {
                int b;
                int g;
                int r;
                if (n == 0 && strs[0].contains(".")) {
                    isdouble = true;
                }
                if (isdouble) {
                    r = (int)(Double.parseDouble(strs[0]) * 255.0);
                    g = (int)(Double.parseDouble(strs[1]) * 255.0);
                    b = (int)(Double.parseDouble(strs[2]) * 255.0);
                } else {
                    r = Integer.parseInt(strs[0]);
                    g = Integer.parseInt(strs[1]);
                    b = Integer.parseInt(strs[2]);
                }
                Color color = new Color(r, g, b);
                clist.add(color);
                ++n;
            }
            line = sr.readLine();
        }
        sr.close();
        this.colors = new Color[clist.size()];
        for (int i = 0; i < clist.size(); ++i) {
            this.colors[i] = (Color)clist.get(i);
        }
    }

    private void readFromFile(BufferedReader sr, int alpha) throws IOException {
        String line = sr.readLine();
        ArrayList<Color> clist = new ArrayList<Color>();
        int n = 0;
        boolean isdouble = false;
        while (line != null) {
            String[] strs = (line = line.trim()).split("\\s+");
            if (strs.length >= 3 && MIMath.isNumeric(strs[0]) && MIMath.isNumeric(strs[1]) && MIMath.isNumeric(strs[2])) {
                int b;
                int g;
                int r;
                if (n == 0 && strs[0].contains(".")) {
                    isdouble = true;
                }
                if (isdouble) {
                    r = (int)(Double.parseDouble(strs[0]) * 255.0);
                    g = (int)(Double.parseDouble(strs[1]) * 255.0);
                    b = (int)(Double.parseDouble(strs[2]) * 255.0);
                } else {
                    r = Integer.parseInt(strs[0]);
                    g = Integer.parseInt(strs[1]);
                    b = Integer.parseInt(strs[2]);
                }
                Color color = new Color(r, g, b, alpha);
                clist.add(color);
                ++n;
            }
            line = sr.readLine();
        }
        sr.close();
        this.colors = new Color[clist.size()];
        for (int i = 0; i < clist.size(); ++i) {
            this.colors[i] = (Color)clist.get(i);
        }
    }

    public void readFromFile(InputStream is) throws IOException {
        BufferedReader sr = new BufferedReader(new InputStreamReader(is));
        this.readFromFile(sr);
    }

    public void readFromFile(String fileName) throws FileNotFoundException, IOException {
        BufferedReader sr = new BufferedReader(new FileReader(new File(fileName)));
        this.readFromFile(sr);
    }

    public void readFromFile(String fileName, int alpha) throws FileNotFoundException, IOException {
        BufferedReader sr = new BufferedReader(new FileReader(new File(fileName)));
        this.readFromFile(sr, alpha);
    }

    public void readFromFile(File file) throws FileNotFoundException, IOException {
        BufferedReader sr = new BufferedReader(new FileReader(file));
        this.readFromFile(sr);
    }
}

