/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.layout;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.event.EventListenerList;
import org.meteoinfo.global.PointF;
import org.meteoinfo.global.event.ILocationChangedListener;
import org.meteoinfo.global.event.ISizeChangedListener;
import org.meteoinfo.global.event.LocationChangedEvent;
import org.meteoinfo.global.event.SizeChangedEvent;
import org.meteoinfo.layout.ElementType;
import org.meteoinfo.layout.ResizeAbility;

public abstract class LayoutElement {
    private final EventListenerList _listeners = new EventListenerList();
    private int _left;
    private int _top;
    private int _width;
    private int _height;
    private ElementType _elementType;
    private Color _foreColor = Color.black;
    private Color _backColor = Color.white;
    private boolean _selected = false;
    private ResizeAbility _resizeAbility = ResizeAbility.None;
    private boolean _visible = true;
    private boolean drawBackColor = false;

    public void addLocationChangedListener(ILocationChangedListener listener) {
        this._listeners.add(ILocationChangedListener.class, listener);
    }

    public void removeLocationChangedListener(ILocationChangedListener listener) {
        this._listeners.remove(ILocationChangedListener.class, listener);
    }

    public void fireLocationChangedEvent() {
        this.fireLocationChangedEvent(new LocationChangedEvent(this));
    }

    private void fireLocationChangedEvent(LocationChangedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ILocationChangedListener.class) continue;
            ((ILocationChangedListener)listeners[i + 1]).locationChangedEvent(event);
        }
    }

    public void addSizeChangedListener(ISizeChangedListener listener) {
        this._listeners.add(ISizeChangedListener.class, listener);
    }

    public void removeSizeChangedListener(ISizeChangedListener listener) {
        this._listeners.remove(ISizeChangedListener.class, listener);
    }

    public void fireSizeChangedEvent() {
        this.fireSizeChangedEvent(new SizeChangedEvent(this));
    }

    private void fireSizeChangedEvent(SizeChangedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ISizeChangedListener.class) continue;
            ((ISizeChangedListener)listeners[i + 1]).sizeChangedEvent(event);
        }
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void setVisible(boolean istrue) {
        this._visible = istrue;
    }

    public int getLeft() {
        return this._left;
    }

    public void setLeft(int left) {
        this._left = left;
        this.fireLocationChangedEvent();
    }

    public int getTop() {
        return this._top;
    }

    public void setTop(int top) {
        this._top = top;
        this.fireLocationChangedEvent();
    }

    public int getWidth() {
        return this._width;
    }

    public void setWidth(int width) {
        this._width = width;
        this.fireSizeChangedEvent();
    }

    public int getHeight() {
        return this._height;
    }

    public void setHeight(int height) {
        this._height = height;
        this.fireSizeChangedEvent();
    }

    public int getRight() {
        return this._left + this._width;
    }

    public int getBottom() {
        return this._top + this._height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this._left, this._top, this._width, this._height);
    }

    public ElementType getElementType() {
        return this._elementType;
    }

    public void setElementType(ElementType type) {
        this._elementType = type;
    }

    public Color getForeColor() {
        return this._foreColor;
    }

    public void setForeColor(Color color) {
        this._foreColor = color;
    }

    public Color getBackColor() {
        return this._backColor;
    }

    public void setBackColor(Color color) {
        this._backColor = color;
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean istrue) {
        this._selected = istrue;
    }

    public ResizeAbility getResizeAbility() {
        return this._resizeAbility;
    }

    public void setResizeAbility(ResizeAbility ra) {
        this._resizeAbility = ra;
    }

    public boolean isDrawBackColor() {
        return this.drawBackColor;
    }

    public void setDrawBackColor(boolean value) {
        this.drawBackColor = value;
    }

    public abstract void paint(Graphics2D var1);

    public abstract void paintOnLayout(Graphics2D var1, PointF var2, float var3);

    public abstract void moveUpdate();

    public abstract void resizeUpdate();

    public PointF pageToScreen(float pageX, float pageY, PointF pageLocation, float zoom) {
        float x = pageX * zoom + pageLocation.X;
        float y = pageY * zoom + pageLocation.Y;
        return new PointF(x, y);
    }
}

