/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.legend;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.meteoinfo.global.event.ISelectedCellChangedListener;
import org.meteoinfo.global.event.SelectedCellChangedEvent;
import org.meteoinfo.layout.MapLayout;
import org.meteoinfo.legend.HatchStyle;
import org.meteoinfo.legend.LegendView;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.legend.SymbolControl;
import org.meteoinfo.map.MapView;
import org.meteoinfo.shape.ShapeTypes;

public class FrmPolygonSymbolSet
extends JDialog {
    private Object _parent = null;
    private PolygonBreak _polygonBreak = null;
    private boolean isLoading = false;
    private JButton jButton_Apply;
    private JButton jButton_OK;
    private JCheckBox jCheckBox_DrawFill;
    private JCheckBox jCheckBox_DrawOutline;
    private JCheckBox jCheckBox_DrawShape;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel_BackColor;
    private JLabel jLabel_FillColor;
    private JLabel jLabel_OutlineColor;
    private JPanel jPanel1;
    private JSpinner jSpinner_OutlineSize;
    private JSpinner jSpinner_TransParency;
    private SymbolControl symbolControl1;

    public FrmPolygonSymbolSet(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("Polygon Symbol Set");
    }

    public FrmPolygonSymbolSet(Dialog parent, boolean modal, Object tparent) {
        super(parent, modal);
        this.initComponents();
        this._parent = tparent;
        this.setTitle("Polygon Symbol Set");
        if (tparent.getClass() == LegendView.class) {
            this.jButton_Apply.setVisible(false);
            this.jButton_OK.setVisible(false);
            this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight() - 40));
        }
        this.symbolControl1.addSelectedCellChangedListener(new ISelectedCellChangedListener(){

            @Override
            public void selectedCellChangedEvent(SelectedCellChangedEvent event) {
                FrmPolygonSymbolSet.this.onSelectedCellChanged(event);
            }
        });
    }

    private void onSelectedCellChanged(SelectedCellChangedEvent event) {
        if (this.isLoading) {
            return;
        }
        this._polygonBreak.setStyle(HatchStyle.values()[this.symbolControl1.getSelectedCell()]);
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_PolygonStyle(this._polygonBreak.getStyle());
        }
    }

    public FrmPolygonSymbolSet(Frame parent, boolean modal, Object tparent) {
        super(parent, modal);
        this.initComponents();
        this._parent = tparent;
        this.setTitle("Polygon Symbol Set");
        if (tparent.getClass() == LegendView.class) {
            this.jButton_Apply.setVisible(false);
            this.jButton_OK.setVisible(false);
            this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight() - 40));
        }
        this.symbolControl1.addSelectedCellChangedListener(new ISelectedCellChangedListener(){

            @Override
            public void selectedCellChangedEvent(SelectedCellChangedEvent event) {
                FrmPolygonSymbolSet.this.onSelectedCellChanged(event);
            }
        });
    }

    private void initComponents() {
        this.jCheckBox_DrawShape = new JCheckBox();
        this.jCheckBox_DrawFill = new JCheckBox();
        this.jCheckBox_DrawOutline = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jSpinner_OutlineSize = new JSpinner();
        this.jLabel4 = new JLabel();
        this.jLabel_OutlineColor = new JLabel();
        this.jButton_OK = new JButton();
        this.jButton_Apply = new JButton();
        this.jLabel_FillColor = new JLabel();
        this.jLabel_BackColor = new JLabel();
        this.jLabel5 = new JLabel();
        this.jSpinner_TransParency = new JSpinner();
        this.symbolControl1 = new SymbolControl();
        this.setDefaultCloseOperation(2);
        this.jCheckBox_DrawShape.setText("Draw Shape");
        this.jCheckBox_DrawShape.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPolygonSymbolSet.this.jCheckBox_DrawShapeActionPerformed(evt);
            }
        });
        this.jCheckBox_DrawFill.setText("Draw Fill");
        this.jCheckBox_DrawFill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPolygonSymbolSet.this.jCheckBox_DrawFillActionPerformed(evt);
            }
        });
        this.jCheckBox_DrawOutline.setText("Draw Outline");
        this.jCheckBox_DrawOutline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPolygonSymbolSet.this.jCheckBox_DrawOutlineActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Fill Color:");
        this.jLabel2.setText("Back Color:");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Outline"));
        this.jPanel1.setToolTipText("Outline");
        this.jPanel1.setName("Outline");
        this.jLabel3.setText("Size:");
        this.jSpinner_OutlineSize.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(100.0f), Float.valueOf(0.5f)));
        this.jSpinner_OutlineSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmPolygonSymbolSet.this.jSpinner_OutlineSizeStateChanged(evt);
            }
        });
        this.jLabel4.setText("Color:");
        this.jLabel_OutlineColor.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel_OutlineColor.setOpaque(true);
        this.jLabel_OutlineColor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmPolygonSymbolSet.this.jLabel_OutlineColorMouseClicked(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner_OutlineSize, -2, 60, -2).addGap(44, 44, 44).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel_OutlineColor, -2, 59, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel_OutlineColor, -2, 19, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jSpinner_OutlineSize, -2, -1, -2).addComponent(this.jLabel4))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButton_OK.setText("OK");
        this.jButton_OK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPolygonSymbolSet.this.jButton_OKActionPerformed(evt);
            }
        });
        this.jButton_Apply.setText("Apply");
        this.jButton_Apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPolygonSymbolSet.this.jButton_ApplyActionPerformed(evt);
            }
        });
        this.jLabel_FillColor.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel_FillColor.setOpaque(true);
        this.jLabel_FillColor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmPolygonSymbolSet.this.jLabel_FillColorMouseClicked(evt);
            }
        });
        this.jLabel_BackColor.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel_BackColor.setOpaque(true);
        this.jLabel_BackColor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmPolygonSymbolSet.this.jLabel_BackColorMouseClicked(evt);
            }
        });
        this.jLabel5.setText("TransParency:");
        this.jSpinner_TransParency.setModel(new SpinnerNumberModel(0, 0, 100, 10));
        this.jSpinner_TransParency.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmPolygonSymbolSet.this.jSpinner_TransParencyStateChanged(evt);
            }
        });
        this.symbolControl1.setCellSize(new Dimension(50, 40));
        this.symbolControl1.setPreferredSize(new Dimension(200, 50));
        this.symbolControl1.setShapeType(ShapeTypes.Polygon);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButton_OK, -2, 77, -2).addGap(38, 38, 38).addComponent(this.jButton_Apply, -2, 82, -2).addGap(45, 45, 45)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox_DrawOutline).addComponent(this.jCheckBox_DrawFill).addComponent(this.jCheckBox_DrawShape)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel_FillColor, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel_BackColor, -1, -1, Short.MAX_VALUE).addComponent(this.jSpinner_TransParency, -2, 59, -2))).addComponent(this.symbolControl1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.symbolControl1, -2, 83, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 17, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBox_DrawShape).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox_DrawFill).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox_DrawOutline)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jSpinner_TransParency, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel_FillColor, -2, 19, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel_BackColor, -2, 19, -2))))).addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_OK).addComponent(this.jButton_Apply)).addContainerGap()));
        this.pack();
    }

    private void jLabel_FillColorMouseClicked(MouseEvent evt) {
        Color c = JColorChooser.showDialog(this.rootPane, null, this.jLabel_FillColor.getBackground());
        if (c == null) {
            return;
        }
        int trans = Integer.parseInt(this.jSpinner_TransParency.getValue().toString());
        trans = (int)((1.0 - (double)trans / 100.0) * 255.0);
        Color aColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), trans);
        this.jLabel_FillColor.setBackground(aColor);
        this._polygonBreak.setColor(aColor);
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_Color(aColor);
        }
    }

    private void jCheckBox_DrawShapeActionPerformed(ActionEvent evt) {
        this._polygonBreak.setDrawShape(this.jCheckBox_DrawShape.isSelected());
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_DrawShape(this.jCheckBox_DrawShape.isSelected());
        }
    }

    private void jCheckBox_DrawFillActionPerformed(ActionEvent evt) {
        this._polygonBreak.setDrawFill(this.jCheckBox_DrawFill.isSelected());
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_DrawFill(this.jCheckBox_DrawFill.isSelected());
        }
    }

    private void jCheckBox_DrawOutlineActionPerformed(ActionEvent evt) {
        this._polygonBreak.setDrawOutline(this.jCheckBox_DrawOutline.isSelected());
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_DrawOutline(this.jCheckBox_DrawOutline.isSelected());
        }
    }

    private void jLabel_BackColorMouseClicked(MouseEvent evt) {
        Color aColor = JColorChooser.showDialog(this.rootPane, null, this.jLabel_BackColor.getBackground());
        if (aColor != null) {
            this.jLabel_BackColor.setBackground(aColor);
            this._polygonBreak.setBackColor(aColor);
            if (this._parent.getClass() == LegendView.class) {
                ((LegendView)this._parent).setLegendBreak_BackColor(aColor);
            }
        }
    }

    private void jLabel_OutlineColorMouseClicked(MouseEvent evt) {
        Color aColor = JColorChooser.showDialog(this.rootPane, null, this.jLabel_OutlineColor.getBackground());
        this.jLabel_OutlineColor.setBackground(aColor);
        this._polygonBreak.setOutlineColor(aColor);
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_OutlineColor(aColor);
        }
    }

    private void jSpinner_OutlineSizeStateChanged(ChangeEvent evt) {
        float size = Float.parseFloat(this.jSpinner_OutlineSize.getValue().toString());
        this._polygonBreak.setOutlineSize(size);
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_OutlineSize(size);
        }
    }

    private void jButton_ApplyActionPerformed(ActionEvent evt) {
        if (this._parent.getClass() == MapView.class) {
            ((MapView)this._parent).paintLayers();
        } else if (this._parent.getClass() == MapLayout.class) {
            ((MapLayout)this._parent).paintGraphics();
        }
    }

    private void jButton_OKActionPerformed(ActionEvent evt) {
        if (this._parent.getClass() == MapView.class) {
            ((MapView)this._parent).setDefPolygonBreak(this._polygonBreak);
            ((MapView)this._parent).paintLayers();
        } else if (this._parent.getClass() == MapLayout.class) {
            ((MapLayout)this._parent).setDefPolygonBreak(this._polygonBreak);
            ((MapLayout)this._parent).paintGraphics();
        }
        this.dispose();
    }

    private void jSpinner_TransParencyStateChanged(ChangeEvent evt) {
        int alpha = Integer.parseInt(this.jSpinner_TransParency.getValue().toString());
        alpha = (int)((1.0 - (double)alpha / 100.0) * 255.0);
        Color c = this._polygonBreak.getColor();
        c = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        this._polygonBreak.setColor(c);
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_Color_Transparency(alpha);
        }
    }

    public void setPolygonBreak(PolygonBreak pgb) {
        this._polygonBreak = pgb;
        this.updateProperties();
    }

    private void updateProperties() {
        this.isLoading = true;
        this.jLabel_FillColor.setBackground(this._polygonBreak.getColor());
        this.jCheckBox_DrawShape.setSelected(this._polygonBreak.isDrawShape());
        int trans = (int)((1.0 - (double)this._polygonBreak.getColor().getAlpha() / 255.0) * 100.0);
        this.jSpinner_TransParency.setValue(trans);
        this.jCheckBox_DrawFill.setSelected(this._polygonBreak.isDrawFill());
        this.jCheckBox_DrawOutline.setSelected(this._polygonBreak.isDrawOutline());
        this.jSpinner_OutlineSize.setValue(Float.valueOf(this._polygonBreak.getOutlineSize()));
        this.jLabel_OutlineColor.setBackground(this._polygonBreak.getOutlineColor());
        this.isLoading = false;
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmPolygonSymbolSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmPolygonSymbolSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmPolygonSymbolSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmPolygonSymbolSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmPolygonSymbolSet dialog = new FrmPolygonSymbolSet((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

