/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.linalg;

import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;

public class EOF {
    private static final int MAX_JACOBI_TIMES = 50;

    public static Object[] SEOF(int N, int LL, double[][] f, DataProMethod method) {
        double[][] H = new double[f.length][f[0].length];
        switch (method) {
            case NONE: {
                for (int i = 0; i < LL; ++i) {
                    System.arraycopy(f[i], 0, H[i], 0, N);
                }
                break;
            }
            case DEPARTURE: {
                H = EOF.dep(N, LL, f);
                break;
            }
            default: {
                H = EOF.nor(N, LL, f);
            }
        }
        return EOF.SEOF(N, LL, f, H);
    }

    public static Object[] SEOF(int N, int LL, double[][] f, double[][] H) {
        int i;
        int j;
        int i2;
        double[][] A = new double[N][N];
        for (int i3 = 0; i3 < N; ++i3) {
            for (int j2 = 0; j2 < N; ++j2) {
                A[i3][j2] = 0.0;
                for (int k = 0; k < LL; ++k) {
                    double[] dArray = A[i3];
                    int n = j2;
                    dArray[n] = dArray[n] + H[k][i3] * H[k][j2];
                }
                A[j2][i3] = A[i3][j2];
            }
        }
        Object[] rr = EOF.jacobi(N, true, A, 50);
        double[] D = (double[])rr[0];
        double[][] V = (double[][])rr[1];
        int[] IX = new int[N];
        for (i2 = 0; i2 < N; ++i2) {
            IX[i2] = i2;
        }
        for (i2 = 0; i2 < N - 1; ++i2) {
            for (j = i2 + 1; j < N; ++j) {
                if (Math.abs(D[i2]) >= Math.abs(D[j])) continue;
                double W1 = D[i2];
                D[i2] = D[j];
                D[j] = W1;
                int k = IX[i2];
                IX[i2] = IX[j];
                IX[j] = k;
            }
        }
        double[][] V1 = new double[N][N];
        for (j = 0; j < N; ++j) {
            int ILW = IX[j];
            for (int i4 = 0; i4 < N; ++i4) {
                V1[i4][j] = V[i4][ILW];
            }
        }
        double[][] T = new double[LL][N];
        for (int L = 0; L < LL; ++L) {
            for (int j3 = 0; j3 < N; ++j3) {
                T[L][j3] = 0.0;
                for (i = 0; i < N; ++i) {
                    double[] dArray = T[L];
                    int n = j3;
                    dArray[n] = dArray[n] + f[L][i] * V1[i][j3];
                }
            }
        }
        double AP = 0.0;
        for (i = 0; i < N; ++i) {
            AP += D[i];
        }
        double[] H1 = new double[N];
        for (int i5 = 0; i5 < N; ++i5) {
            double AP1 = 0.0;
            for (int j4 = 0; j4 <= i5; ++j4) {
                AP1 += D[j4];
            }
            H1[i5] = 1.0 * AP1 / AP;
        }
        return new Object[]{V1, T, H1, D};
    }

    public static Object[] SEOF(Array f, DataProMethod method) {
        int[] shape = f.getShape();
        int LL = shape[0];
        int N = shape[1];
        Array H = Array.factory(DataType.DOUBLE, shape);
        switch (method) {
            case NONE: {
                int i = 0;
                while ((long)i < H.getSize()) {
                    H.setDouble(i, f.getDouble(i));
                    ++i;
                }
                break;
            }
            case DEPARTURE: {
                H = EOF.dep(N, LL, f);
                break;
            }
            default: {
                H = EOF.nor(N, LL, f);
            }
        }
        return EOF.SEOF(N, LL, f, H);
    }

    public static Object[] SEOF(int N, int LL, Array f, DataProMethod method) {
        Array H = Array.factory(DataType.DOUBLE, f.getShape());
        switch (method) {
            case NONE: {
                int i = 0;
                while ((long)i < H.getSize()) {
                    H.setDouble(i, f.getDouble(i));
                    ++i;
                }
                break;
            }
            case DEPARTURE: {
                H = EOF.dep(N, LL, f);
                break;
            }
            default: {
                H = EOF.nor(N, LL, f);
            }
        }
        return EOF.SEOF(N, LL, f, H);
    }

    public static Object[] SEOF(int N, int LL, Array f, Array H) {
        int i;
        int j;
        int i2;
        Array A = Array.factory(DataType.DOUBLE, new int[]{N, N});
        for (int i3 = 0; i3 < N; ++i3) {
            for (int j2 = 0; j2 < N; ++j2) {
                A.setDouble(i3 * N + j2, 0.0);
                for (int k = 0; k < LL; ++k) {
                    A.setDouble(i3 * N + j2, A.getDouble(i3 * N + j2) + H.getDouble(k * N + i3) * H.getDouble(k * N + j2));
                }
                A.setDouble(j2 * N + i3, A.getDouble(i3 * N + j2));
            }
        }
        Object[] rr = EOF.jacobi(N, true, A, 50);
        Array D = (Array)rr[0];
        Array V = (Array)rr[1];
        int[] IX = new int[N];
        for (i2 = 0; i2 < N; ++i2) {
            IX[i2] = i2;
        }
        for (i2 = 0; i2 < N - 1; ++i2) {
            for (j = i2 + 1; j < N; ++j) {
                if (Math.abs(D.getDouble(i2)) >= Math.abs(D.getDouble(j))) continue;
                double W1 = D.getDouble(i2);
                D.setDouble(i2, D.getDouble(j));
                D.setDouble(j, W1);
                int k = IX[i2];
                IX[i2] = IX[j];
                IX[j] = k;
            }
        }
        Array V1 = Array.factory(DataType.DOUBLE, new int[]{N, N});
        for (j = 0; j < N; ++j) {
            int ILW = IX[j];
            for (int i4 = 0; i4 < N; ++i4) {
                V1.setDouble(i4 * N + j, V.getDouble(i4 * N + ILW));
            }
        }
        Array T = Array.factory(DataType.DOUBLE, new int[]{LL, N});
        for (int L = 0; L < LL; ++L) {
            for (int j3 = 0; j3 < N; ++j3) {
                T.setDouble(L * N + j3, 0.0);
                for (i = 0; i < N; ++i) {
                    T.setDouble(L * N + j3, T.getDouble(L * N + j3) + f.getDouble(L * N + i) * V1.getDouble(i * N + j3));
                }
            }
        }
        double AP = 0.0;
        for (i = 0; i < N; ++i) {
            AP += D.getDouble(i);
        }
        Array H1 = Array.factory(DataType.DOUBLE, new int[]{N});
        for (int i5 = 0; i5 < N; ++i5) {
            double AP1 = 0.0;
            for (int j4 = 0; j4 <= i5; ++j4) {
                AP1 += D.getDouble(j4);
            }
            H1.setDouble(i5, 1.0 * AP1 / AP);
        }
        return new Object[]{V1, T, H1, D};
    }

    public static Object[] jacobi(int N, boolean EV, double[][] A) {
        return EOF.jacobi(N, EV, A, 50);
    }

    public static Object[] jacobi(int N, boolean EV, Array A) {
        return EOF.jacobi(N, EV, A, 50);
    }

    public static Object[] jacobi(int N, boolean EV, double[][] A, int MAXTIMES) {
        int k;
        double[] D = new double[N];
        double[][] V = new double[N][N];
        int IRT = 0;
        double[] B = new double[N];
        double[] Z = new double[N];
        if (EV) {
            for (k = 0; k < N; ++k) {
                for (int L = 0; L < N; ++L) {
                    if (k - L == 0) {
                        V[k][k] = 1.0;
                        continue;
                    }
                    V[k][L] = 0.0;
                }
            }
        }
        for (k = 0; k < N; ++k) {
            B[k] = A[k][k];
            D[k] = B[k];
            Z[k] = 0.0;
        }
        for (int i = 0; i < MAXTIMES; ++i) {
            int k2;
            double sm = 0.0;
            int N1 = N - 1;
            for (int k3 = 0; k3 < N1; ++k3) {
                int k1;
                for (int L = k1 = k3 + 1; L < N; ++L) {
                    sm += Math.abs(A[k3][L]);
                }
            }
            if (sm == 0.0) {
                return null;
            }
            double tresh = 0.0;
            if (i - 4 > 0) {
                tresh = 0.2 * sm / (double)(N * N);
            }
            for (k2 = 0; k2 < N1; ++k2) {
                int k1;
                for (int L = k1 = k2 + 1; L < N; ++L) {
                    int j;
                    int L1;
                    double t;
                    double G = 100.0 * Math.abs(A[k2][L]);
                    if (i > 4 && Math.abs(G) == 0.0) {
                        A[k2][L] = 0.0;
                        continue;
                    }
                    if (Math.abs(A[k2][L]) <= tresh) continue;
                    double H = D[L] - D[k2];
                    if (G == 0.0) {
                        t = A[k2][L] / H;
                    } else {
                        double theta = 0.5 * H / A[k2][L];
                        t = 1.0 / (Math.abs(theta) + Math.sqrt(1.0 + theta * theta));
                        if (theta < 0.0) {
                            t = -1.0 * t;
                        }
                    }
                    double c = 1.0 / Math.sqrt(1.0 + t * t);
                    double s = t * c;
                    H = t * A[k2][L];
                    Z[k2] = Z[k2] - H;
                    Z[L] = Z[L] + H;
                    D[k2] = D[k2] - H;
                    D[L] = D[L] + H;
                    A[k2][L] = 0.0;
                    int KM1 = k2 - 1;
                    if (KM1 < 0) {
                        for (int j2 = 0; j2 < KM1; ++j2) {
                            G = A[j2][k2];
                            H = A[j2][L];
                            A[j2][k2] = c * G - s * H;
                            A[j2][L] = s * G + c * H;
                        }
                    }
                    if ((L1 = L - 1) - k1 <= 0) {
                        for (j = k1; j < L1; ++j) {
                            G = A[k2][L];
                            H = A[j][L];
                            A[k2][j] = c * G - s * H;
                            A[j][L] = s * G + c * H;
                        }
                    }
                    if ((L1 = L + 1) < N) {
                        for (j = L1; j < N; ++j) {
                            G = A[k2][j];
                            H = A[L][j];
                            A[k2][j] = c * G - s * H;
                            A[L][j] = s * G + c * H;
                        }
                    }
                    if (EV) {
                        for (j = 0; j < N; ++j) {
                            G = V[j][k2];
                            H = V[j][L];
                            V[j][k2] = c * G - s * H;
                            V[j][L] = s * G + c * H;
                        }
                    }
                    ++IRT;
                }
            }
            for (k2 = 0; k2 < N; ++k2) {
                D[k2] = B[k2] + Z[k2];
                B[k2] = D[k2];
                Z[k2] = 0.0;
            }
        }
        return new Object[]{D, V};
    }

    public static Object[] jacobi(int N, boolean EV, Array A, int MAXTIMES) {
        int k;
        Array D = Array.factory(DataType.DOUBLE, new int[]{N});
        Array V = Array.factory(DataType.DOUBLE, new int[]{N, N});
        int IRT = 0;
        double[] B = new double[N];
        double[] Z = new double[N];
        if (EV) {
            for (k = 0; k < N; ++k) {
                for (int L = 0; L < N; ++L) {
                    if (k - L == 0) {
                        V.setDouble(k * N + k, 1.0);
                        continue;
                    }
                    V.setDouble(k * N + L, 0.0);
                }
            }
        }
        for (k = 0; k < N; ++k) {
            B[k] = A.getDouble(k * N + k);
            D.setDouble(k, B[k]);
            Z[k] = 0.0;
        }
        for (int i = 0; i < MAXTIMES; ++i) {
            int k2;
            double sm = 0.0;
            int N1 = N - 1;
            for (int k3 = 0; k3 < N1; ++k3) {
                int k1;
                for (int L = k1 = k3 + 1; L < N; ++L) {
                    sm += Math.abs(A.getDouble(k3 * N + L));
                }
            }
            if (sm == 0.0) break;
            double tresh = 0.0;
            if (i - 4 > 0) {
                tresh = 0.2 * sm / (double)(N * N);
            }
            for (k2 = 0; k2 < N1; ++k2) {
                int k1;
                for (int L = k1 = k2 + 1; L < N; ++L) {
                    int j;
                    int L1;
                    double t;
                    double G = 100.0 * Math.abs(A.getDouble(k2 * N + L));
                    if (i > 4 && Math.abs(G) == 0.0) {
                        A.setDouble(k2 * N + L, 0.0);
                        continue;
                    }
                    if (Math.abs(A.getDouble(k2 * N + L)) <= tresh) continue;
                    double H = D.getDouble(L) - D.getDouble(k2);
                    if (G == 0.0) {
                        t = A.getDouble(k2 * N + L) / H;
                    } else {
                        double theta = 0.5 * H / A.getDouble(k2 * N + L);
                        t = 1.0 / (Math.abs(theta) + Math.sqrt(1.0 + theta * theta));
                        if (theta < 0.0) {
                            t = -1.0 * t;
                        }
                    }
                    double c = 1.0 / Math.sqrt(1.0 + t * t);
                    double s = t * c;
                    H = t * A.getDouble(k2 * N + L);
                    Z[k2] = Z[k2] - H;
                    Z[L] = Z[L] + H;
                    D.setDouble(k2, D.getDouble(k2) - H);
                    D.setDouble(L, D.getDouble(L) + H);
                    A.setDouble(k2 * N + L, 0.0);
                    int KM1 = k2 - 1;
                    if (KM1 < 0) {
                        for (int j2 = 0; j2 < KM1; ++j2) {
                            G = A.getDouble(j2 * N + k2);
                            H = A.getDouble(j2 * N + L);
                            A.setDouble(j2 * N + k2, c * G - s * H);
                            A.setDouble(j2 * N + L, s * G + c * H);
                        }
                    }
                    if ((L1 = L - 1) - k1 <= 0) {
                        for (j = k1; j < L1; ++j) {
                            G = A.getDouble(k2 * N + L);
                            H = A.getDouble(j * N + L);
                            A.setDouble(k2 * N + j, c * G - s * H);
                            A.setDouble(j * N + L, s * G + c * H);
                        }
                    }
                    if ((L1 = L + 1) < N) {
                        for (j = L1; j < N; ++j) {
                            G = A.getDouble(k2 * N + j);
                            H = A.getDouble(L * N + j);
                            A.setDouble(k2 * N + j, c * G - s * H);
                            A.setDouble(L * N + j, s * G + c * H);
                        }
                    }
                    if (EV) {
                        for (j = 0; j < N; ++j) {
                            G = V.getDouble(j * N + k2);
                            H = V.getDouble(j * N + L);
                            V.setDouble(j * N + k2, c * G - s * H);
                            V.setDouble(j * N + L, s * G + c * H);
                        }
                    }
                    ++IRT;
                }
            }
            for (k2 = 0; k2 < N; ++k2) {
                D.setDouble(k2, B[k2] + Z[k2]);
                B[k2] = D.getDouble(k2);
                Z[k2] = 0.0;
            }
        }
        return new Object[]{D, V};
    }

    static double[] average(int N, int LL, double[][] f) {
        double[] Aver = new double[N];
        int j = 0;
        while (j < N) {
            Aver[j] = 0.0;
            for (int i = 0; i < LL; ++i) {
                int n = j;
                Aver[n] = Aver[n] + f[i][j];
            }
            int n = j++;
            Aver[n] = Aver[n] / (double)LL;
        }
        return Aver;
    }

    static double[] average(int N, int LL, Array f) {
        double[] Aver = new double[N];
        int j = 0;
        while (j < N) {
            Aver[j] = 0.0;
            for (int i = 0; i < LL; ++i) {
                int n = j;
                Aver[n] = Aver[n] + f.getDouble(i * N + j);
            }
            int n = j++;
            Aver[n] = Aver[n] / (double)LL;
        }
        return Aver;
    }

    static double[][] dep(int N, int LL, double[][] f) {
        double[][] H = new double[LL][N];
        double[] Aver = EOF.average(N, LL, f);
        for (int j = 0; j < N; ++j) {
            for (int i = 0; i < LL; ++i) {
                H[i][j] = f[i][j] - Aver[j];
            }
        }
        return H;
    }

    static Array dep(int N, int LL, Array f) {
        Array H = Array.factory(DataType.DOUBLE, f.getShape());
        double[] Aver = EOF.average(N, LL, f);
        for (int j = 0; j < N; ++j) {
            for (int i = 0; i < LL; ++i) {
                H.setDouble(i * N + j, f.getDouble(i * N + j) - Aver[j]);
            }
        }
        return H;
    }

    static double[][] nor(int N, int LL, double[][] f) {
        int i;
        int j;
        double[][] H = new double[LL][N];
        double[] Std = new double[N];
        double[] Aver = EOF.average(N, LL, f);
        for (j = 0; j < N; ++j) {
            Std[j] = 0.0;
            for (i = 0; i < LL; ++i) {
                int n = j;
                Std[n] = Std[n] + (f[i][j] - Aver[j]) * (f[i][j] - Aver[j]);
            }
            Std[j] = Math.sqrt(Std[j] / (double)LL);
        }
        for (j = 0; j < N; ++j) {
            for (i = 0; i < LL; ++i) {
                H[i][j] = (f[i][j] - Aver[j]) / Std[j];
            }
        }
        return H;
    }

    static Array nor(int N, int LL, Array f) {
        int i;
        int j;
        Array H = Array.factory(DataType.DOUBLE, f.getShape());
        double[] Std = new double[N];
        double[] Aver = EOF.average(N, LL, f);
        for (j = 0; j < N; ++j) {
            Std[j] = 0.0;
            for (i = 0; i < LL; ++i) {
                int n = j;
                Std[n] = Std[n] + (f.getDouble(i * N + j) - Aver[j]) * (f.getDouble(i * N + j) - Aver[j]);
            }
            Std[j] = Math.sqrt(Std[j] / (double)LL);
        }
        for (j = 0; j < N; ++j) {
            for (i = 0; i < LL; ++i) {
                H.setDouble(i * N + j, (f.getDouble(i * N + j) - Aver[j]) / Std[j]);
            }
        }
        return H;
    }

    public static enum DataProMethod {
        NONE,
        DEPARTURE,
        NORMALIZED;

    }
}

