/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.meteo;

import org.meteoinfo.math.ArrayMath;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.IndexIterator;

public class MeteoMath {
    public static double cal_Es(double tc) {
        double pol = 0.99999683 + tc * (-0.0090826951 + tc * (7.8736169E-5 + tc * (-6.1117958E-7 + tc * (4.3884187E-9 + tc * (-2.9883885E-11 + tc * (2.1874425E-13 + tc * (-1.7892321E-15 + tc * (1.1112018E-17 + tc * -3.0994571E-20))))))));
        double pol1 = 6.1078 / Math.pow(pol, 8.0);
        return pol1;
    }

    public static double cal_Es_1(double tc) {
        return 6.11 * Math.pow(10.0, 7.5 * tc / (237.7 + tc));
    }

    public static double cal_Es_2(double tc) {
        return 6.112 * Math.exp(17.67 * tc / (tc + 243.5));
    }

    public static double cal_Tdc(double e) {
        if (e <= 0.06 || e >= 1013.0) {
            double lu = 9999.0;
            return lu;
        }
        double x = Math.log(e / 6.1078);
        double dnm = 17.269388 - x;
        double t = 237.3 * x / dnm;
        double fac = 1.0 / (e * dnm);
        double edp = MeteoMath.cal_Es(t);
        double dtdew = (t + 237.3) * fac;
        double dt = dtdew * (e - edp);
        t += dt;
        while (Math.abs(dt) >= 1.0E-4) {
            edp = MeteoMath.cal_Es(t);
            dtdew = (t + 237.3) * fac;
            dt = dtdew * (e - edp);
            t += dt;
        }
        return t;
    }

    public static double cal_Tdc(double t, double rh) {
        double esw = MeteoMath.cal_Es(t);
        double e = esw * (rh / 100.0);
        return MeteoMath.cal_Tdc(e);
    }

    public static double dewpoint2rh(double tc, double tdc) {
        double es = MeteoMath.cal_Es(tc);
        double e = MeteoMath.cal_Es(tdc);
        return e / es * 100.0;
    }

    public static Array dewpoint2rh(Array tdc, Array tc) {
        Array r = Array.factory(tdc.getDataType(), tdc.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, MeteoMath.dewpoint2rh(tc.getDouble(i), tdc.getDouble(i)));
            ++i;
        }
        return r;
    }

    public static double rh2dewpoint(double rh, double t) {
        double esw = MeteoMath.cal_Es(t);
        double e = esw * (rh / 100.0);
        return MeteoMath.cal_Tdc(e);
    }

    public static Array rh2dewpoint(Array rh, Array tc) {
        Array r = Array.factory(rh.getDataType(), rh.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, MeteoMath.rh2dewpoint(rh.getDouble(i), tc.getDouble(i)));
            ++i;
        }
        return r;
    }

    public static double qair2rh(double qair, double tc, double press) {
        double e = qair * press / (0.378 * qair + 0.622);
        double es = MeteoMath.cal_Es_2(tc);
        double rh = e / es * 100.0;
        if (rh > 100.0) {
            rh = 100.0;
        } else if (rh < 0.0) {
            rh = 0.0;
        }
        return rh;
    }

    public static double cal_Tdc_1(double e) {
        return (-430.22 + 237.7 * Math.log(e)) / (-Math.log(e) + 19.08);
    }

    public static double cal_Tdc_1(double tc, double rh) {
        double es = MeteoMath.cal_Es(tc);
        double e = MeteoMath.cal_E(es, rh);
        return MeteoMath.cal_Tdc(e);
    }

    public static double tf2tc(double tf) {
        return 0.5555555555555556 * (tf - 32.0);
    }

    public static double tc2tf(double tc) {
        return 1.8 * tc + 32.0;
    }

    public static double cal_E(double es, double rh) {
        return rh * es / 100.0;
    }

    public static double press2Height(double press) {
        if (press >= 1013.3) {
            return 0.0;
        }
        double[] ps = new double[]{1013.3, 845.4, 700.8, 504.7, 410.4, 307.1, 193.1, 102.8, 46.7, 8.7};
        double[] hs = new double[]{0.0, 1500.0, 3000.0, 5500.0, 7000.0, 9000.0, 12000.0, 16000.0, 21000.0, 32000.0};
        int idx = -1;
        int i = -1;
        for (double p : ps) {
            if (press > p) {
                idx = i;
                break;
            }
            ++i;
        }
        if (idx == -1) {
            return 35000.0;
        }
        double z1 = hs[idx];
        double p1 = ps[idx];
        double z2 = hs[idx + 1];
        double p2 = ps[idx + 1];
        double h = (press - p1) * (z2 - z1) / (p2 - p1) + z1;
        return h;
    }

    public static double height2Press(double height) {
        double[] ps = new double[]{1013.3, 845.4, 700.8, 504.7, 410.4, 307.1, 193.1, 102.8, 46.7, 8.7};
        double[] hs = new double[]{0.0, 1500.0, 3000.0, 5500.0, 7000.0, 9000.0, 12000.0, 16000.0, 21000.0, 32000.0};
        int idx = -1;
        int i = -1;
        for (double h : hs) {
            if (height < h) {
                idx = i;
                break;
            }
            ++i;
        }
        if (idx == -1) {
            return 5.0;
        }
        double z1 = hs[idx];
        double p1 = ps[idx];
        double z2 = hs[idx + 1];
        double p2 = ps[idx + 1];
        double p = (height - z1) * (p2 - p1) / (z2 - z1) + p1;
        return p;
    }

    public static Array calSeaPrs(Array z, Array t, Array p, Array q) {
        int j;
        int i;
        double RD = 287.0;
        double G = 9.81;
        double USSALR = 0.0065;
        double TC = 290.66;
        double PCONST = 10000.0;
        boolean ridiculous_mm5_test = true;
        int[] shape = z.getShape();
        int nz = shape[0];
        int ny = shape[1];
        int nx = shape[2];
        int errcnt = 0;
        int bad_i = -1;
        int bad_j = -1;
        double bad_sfp = -1.0;
        int[][] level = new int[ny][nx];
        Index idx3 = Index.factory(shape);
        for (i = 0; i < ny; ++i) {
            for (j = 0; j < nx; ++j) {
                level[i][j] = -1;
                boolean found = false;
                for (int k = 0; !found && k < nz; ++k) {
                    if (!(p.getDouble(idx3.set(k, i, j)) < p.getDouble(idx3.set(0, i, j)) - PCONST)) continue;
                    level[i][j] = k;
                    found = true;
                }
                if (level[i][j] != -1) continue;
                ++errcnt;
                if (bad_i != -1) continue;
                bad_i = i;
                bad_j = j;
                bad_sfp = p.getDouble(idx3.set(0, i, j)) / 100.0;
            }
        }
        if (errcnt > 0) {
            System.out.println("Error in finding 100 hPa up.  i=" + bad_i + "j=" + bad_j + "sfc_p=" + bad_sfp);
            return null;
        }
        double[][] t_surf = new double[ny][nx];
        double[][] t_sea_level = new double[ny][nx];
        for (i = 0; i < ny; ++i) {
            for (j = 0; j < nx; ++j) {
                int khi;
                int klo = Math.max(level[i][j] - 1, 0);
                if (klo == (khi = Math.min(klo + 1, nz - 1))) {
                    ++errcnt;
                    if (bad_i == -1) {
                        bad_i = i;
                        bad_j = j;
                    }
                }
                double plo = p.getDouble(idx3.set(klo, i, j));
                double phi = p.getDouble(idx3.set(khi, i, j));
                double tlo = t.getDouble(idx3.set(klo, i, j)) * (1.0 + 0.608 * q.getDouble(idx3.set(klo, i, j)));
                double thi = t.getDouble(idx3.set(khi, i, j)) * (1.0 + 0.608 * q.getDouble(idx3.set(khi, i, j)));
                double zlo = z.getDouble(idx3.set(klo, i, j));
                double zhi = z.getDouble(idx3.set(khi, i, j));
                double p_at_pconst = p.getDouble(idx3.set(0, i, j)) - PCONST;
                double t_at_pconst = thi - (thi - tlo) * Math.log(p_at_pconst / phi) * Math.log(plo / phi);
                double z_at_pconst = zhi - (zhi - zlo) * Math.log(p_at_pconst / phi) * Math.log(plo / phi);
                t_surf[i][j] = t_at_pconst * Math.pow(p.getDouble(idx3.set(0, i, j)) / p_at_pconst, USSALR * RD / G);
                t_sea_level[i][j] = t_at_pconst + USSALR * z_at_pconst;
            }
        }
        if (errcnt > 0) {
            System.out.println("Error trapping levels at i=" + bad_i + "j=" + bad_j);
            return null;
        }
        if (ridiculous_mm5_test) {
            boolean l1 = true;
            for (i = 0; i < ny; ++i) {
                for (j = 0; j < nx; ++j) {
                    l1 = t_sea_level[i][j] < TC;
                    boolean l2 = t_surf[i][j] <= TC;
                    boolean l3 = !l1;
                    t_sea_level[i][j] = l2 && l3 ? TC : TC - 0.005 * Math.pow(t_surf[i][j] - TC, 2.0);
                }
            }
        }
        Array sea_level_pressure = Array.factory(DataType.DOUBLE, new int[]{ny, nx});
        for (i = 0; i < ny; ++i) {
            for (j = 0; j < nx; ++j) {
                double v = 0.01 * (p.getDouble(idx3.set(0, i, j)) * Math.exp(2.0 * G * z.getDouble(idx3.set(0, i, j)) / (RD * (t_sea_level[i][j] + t_surf[i][j]))));
                sea_level_pressure.setDouble(i * nx + j, v);
            }
        }
        return sea_level_pressure;
    }

    public static Array tc2tf(Array tc) {
        Array r = Array.factory(tc.getDataType(), tc.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, MeteoMath.tc2tf(tc.getDouble(i)));
            ++i;
        }
        return r;
    }

    public static Array tf2tc(Array tf) {
        Array r = Array.factory(tf.getDataType(), tf.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, MeteoMath.tf2tc(tf.getDouble(i)));
            ++i;
        }
        return r;
    }

    public static Array qair2rh(Array qair, Array temp, double press) {
        Array r = Array.factory(DataType.DOUBLE, qair.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            double rh = MeteoMath.qair2rh(qair.getDouble(i), temp.getDouble(i), press);
            r.setDouble(i, rh);
            ++i;
        }
        return r;
    }

    public static Array qair2rh(Array qair, Array temp, Array press) {
        Array r = Array.factory(DataType.DOUBLE, qair.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            double rh = MeteoMath.qair2rh(qair.getDouble(i), temp.getDouble(i), press.getDouble(i));
            r.setDouble(i, rh);
            ++i;
        }
        return r;
    }

    public static Array press2Height(Array press) {
        Array r = Array.factory(DataType.DOUBLE, press.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            double rh = MeteoMath.press2Height(press.getDouble(i));
            r.setDouble(i, rh);
            ++i;
        }
        return r;
    }

    public static Array height2Press(Array height) {
        Array r = Array.factory(DataType.DOUBLE, height.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            double rh = MeteoMath.height2Press(height.getDouble(i));
            r.setDouble(i, rh);
            ++i;
        }
        return r;
    }

    public static Array[] uv2ds(Array u, Array v) {
        Array windSpeed = ArrayMath.sqrt(ArrayMath.add(ArrayMath.mul(u, u), ArrayMath.mul(v, v)));
        Array windDir = Array.factory(windSpeed.getDataType(), windSpeed.getShape());
        if (u.getIndexPrivate().isFastIterator() && v.getIndexPrivate().isFastIterator()) {
            int i = 0;
            while ((long)i < windSpeed.getSize()) {
                double U = u.getDouble(i);
                double V = v.getDouble(i);
                if (Double.isNaN(U) || Double.isNaN(V)) {
                    windDir.setDouble(i, Double.NaN);
                } else {
                    double wd;
                    double ws = windSpeed.getDouble(i);
                    if (ws == 0.0) {
                        wd = 0.0;
                    } else {
                        wd = Math.asin(U / ws) * 180.0 / Math.PI;
                        if (U <= 0.0 && V < 0.0) {
                            wd = 180.0 - wd;
                        } else if (U > 0.0 && V < 0.0) {
                            wd = 180.0 - wd;
                        } else if (U < 0.0 && V > 0.0) {
                            wd = 360.0 + wd;
                        }
                        wd += 180.0;
                        if (wd >= 360.0) {
                            wd -= 360.0;
                        }
                    }
                    windDir.setDouble(i, wd);
                }
                ++i;
            }
        } else {
            IndexIterator iterU = u.getIndexIterator();
            IndexIterator iterV = v.getIndexIterator();
            IndexIterator iterWS = windSpeed.getIndexIterator();
            IndexIterator iterWD = windDir.getIndexIterator();
            while (iterU.hasNext()) {
                double wd;
                double U = iterU.getDoubleNext();
                double V = iterV.getDoubleNext();
                if (Double.isNaN(U) || Double.isNaN(V)) {
                    iterWD.setDoubleNext(Double.NaN);
                    continue;
                }
                double ws = iterWS.getDoubleNext();
                if (ws == 0.0) {
                    wd = 0.0;
                } else {
                    wd = Math.asin(U / ws) * 180.0 / Math.PI;
                    if (U <= 0.0 && V < 0.0) {
                        wd = 180.0 - wd;
                    } else if (U > 0.0 && V < 0.0) {
                        wd = 180.0 - wd;
                    } else if (U < 0.0 && V > 0.0) {
                        wd = 360.0 + wd;
                    }
                    wd += 180.0;
                    if (wd >= 360.0) {
                        wd -= 360.0;
                    }
                }
                iterWD.setDoubleNext(wd);
            }
        }
        return new Array[]{windDir, windSpeed};
    }

    public static double[] uv2ds(double u, double v) {
        double wd;
        double ws = Math.sqrt(u * u + v * v);
        if (ws == 0.0) {
            wd = 0.0;
        } else {
            wd = Math.asin(u / ws) * 180.0 / Math.PI;
            if (u <= 0.0 && v < 0.0) {
                wd = 180.0 - wd;
            } else if (u > 0.0 && v < 0.0) {
                wd = 180.0 - wd;
            } else if (u < 0.0 && v > 0.0) {
                wd = 360.0 + wd;
            }
            wd += 180.0;
            if (wd >= 360.0) {
                wd -= 360.0;
            }
        }
        return new double[]{wd, ws};
    }

    public static Array[] ds2uv(Array windDir, Array windSpeed) {
        Array U = Array.factory(DataType.DOUBLE, windDir.getShape());
        Array V = Array.factory(DataType.DOUBLE, windDir.getShape());
        if (windDir.getIndexPrivate().isFastIterator() && windSpeed.getIndexPrivate().isFastIterator()) {
            int i = 0;
            while ((long)i < U.getSize()) {
                double dir;
                if (Double.isNaN(windDir.getDouble(i)) || Double.isNaN(windSpeed.getDouble(i))) {
                    U.setDouble(i, Double.NaN);
                    V.setDouble(i, Double.NaN);
                }
                if ((dir = windDir.getDouble(i) + 180.0) > 360.0) {
                    dir -= 360.0;
                }
                dir = dir * Math.PI / 180.0;
                U.setDouble(i, windSpeed.getDouble(i) * Math.sin(dir));
                V.setDouble(i, windSpeed.getDouble(i) * Math.cos(dir));
                ++i;
            }
        } else {
            IndexIterator iterU = U.getIndexIterator();
            IndexIterator iterV = V.getIndexIterator();
            IndexIterator iterWS = windSpeed.getIndexIterator();
            IndexIterator iterWD = windDir.getIndexIterator();
            while (iterU.hasNext()) {
                double dir;
                double wd = iterWD.getDoubleNext();
                double ws = iterWS.getDoubleNext();
                if (Double.isNaN(wd) || Double.isNaN(ws)) {
                    iterU.setDoubleNext(Double.NaN);
                    iterV.setDoubleNext(Double.NaN);
                }
                if ((dir = wd + 180.0) > 360.0) {
                    dir -= 360.0;
                }
                dir = dir * Math.PI / 180.0;
                iterU.setDoubleNext(ws * Math.sin(dir));
                iterV.setDoubleNext(ws * Math.cos(dir));
            }
        }
        return new Array[]{U, V};
    }

    public static double[] ds2uv(double windDir, double windSpeed) {
        double dir = windDir + 180.0;
        if (dir > 360.0) {
            dir -= 360.0;
        }
        dir = dir * Math.PI / 180.0;
        double u = windSpeed * Math.sin(dir);
        double v = windSpeed * Math.cos(dir);
        return new double[]{u, v};
    }
}

