/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.Complex;
import org.meteoinfo.ndarray.ForbiddenConversionException;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.Index0D;
import org.meteoinfo.ndarray.Index1D;
import org.meteoinfo.ndarray.Index2D;
import org.meteoinfo.ndarray.Index3D;
import org.meteoinfo.ndarray.Index4D;
import org.meteoinfo.ndarray.Index5D;
import org.meteoinfo.ndarray.Index6D;
import org.meteoinfo.ndarray.Index7D;
import org.meteoinfo.ndarray.IndexIterator;

public class ArrayComplex
extends Array {
    protected Complex[] storage;

    static ArrayComplex factory(Index index) {
        return ArrayComplex.factory(index, null);
    }

    static ArrayComplex factory(Index index, Complex[] storage) {
        switch (index.getRank()) {
            case 0: {
                return new D0(index, storage);
            }
            case 1: {
                return new D1(index, storage);
            }
            case 2: {
                return new D2(index, storage);
            }
            case 3: {
                return new D3(index, storage);
            }
            case 4: {
                return new D4(index, storage);
            }
            case 5: {
                return new D5(index, storage);
            }
            case 6: {
                return new D6(index, storage);
            }
            case 7: {
                return new D7(index, storage);
            }
        }
        return new ArrayComplex(index, storage);
    }

    public ArrayComplex(int[] shape) {
        super(shape);
        this.storage = new Complex[(int)this.indexCalc.getSize()];
    }

    @Override
    protected Array createView(Index index) {
        return ArrayComplex.factory(index, this.storage);
    }

    ArrayComplex(Index ima, Complex[] data) {
        super(ima);
        this.storage = data != null ? data : new Complex[(int)this.indexCalc.getSize()];
    }

    @Override
    public Object getStorage() {
        return this.storage;
    }

    @Override
    protected void copyFrom1DJavaArray(IndexIterator iter, Object javaArray) {
        Complex[] ja;
        for (Complex aJa : ja = (Complex[])javaArray) {
            iter.setComplexNext(aJa);
        }
    }

    @Override
    protected void copyTo1DJavaArray(IndexIterator iter, Object javaArray) {
        Complex[] ja = (Complex[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            ja[i] = iter.getComplexNext();
        }
    }

    @Override
    public ByteBuffer getDataAsByteBuffer() {
        ByteBuffer bb = ByteBuffer.allocate((int)(8L * this.getSize()));
        DoubleBuffer ib = bb.asDoubleBuffer();
        ib.put((double[])this.get1DJavaArray(Double.TYPE));
        return bb;
    }

    @Override
    public Class getElementType() {
        return Complex.class;
    }

    public Complex get(Index i) {
        return this.storage[i.currentElement()];
    }

    public void set(Index i, Complex value) {
        this.storage[i.currentElement()] = value;
    }

    @Override
    public double getDouble(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setDouble(Index i, double value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public float getFloat(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setFloat(Index i, float value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public long getLong(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setLong(Index i, long value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public int getInt(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setInt(Index i, int value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public short getShort(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setShort(Index i, short value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public byte getByte(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setByte(Index i, byte value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public char getChar(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setChar(Index i, char value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public boolean getBoolean(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setBoolean(Index i, boolean value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public String getString(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setString(Index i, String value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public Complex getComplex(Index i) {
        return this.storage[i.currentElement()];
    }

    @Override
    public void setComplex(Index i, Complex value) {
        this.storage[i.currentElement()] = value;
    }

    @Override
    public Object getObject(Index i) {
        return this.storage[i.currentElement()];
    }

    @Override
    public void setObject(Index i, Object value) {
        this.storage[i.currentElement()] = (Complex)((Object)value);
    }

    @Override
    public double getDouble(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setDouble(int index, double value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public float getFloat(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setFloat(int index, float value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public long getLong(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setLong(int index, long value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public int getInt(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setInt(int index, int value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public short getShort(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setShort(int index, short value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public byte getByte(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setByte(int index, byte value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public char getChar(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setChar(int index, char value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public boolean getBoolean(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setBoolean(int index, boolean value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public String getString(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setString(int index, String value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public Complex getComplex(int index) {
        return this.storage[index];
    }

    @Override
    public void setComplex(int index, Complex value) {
        this.storage[index] = value;
    }

    @Override
    public Object getObject(int index) {
        return this.getDouble(index);
    }

    @Override
    public void setObject(int index, Object value) {
        this.storage[index] = (Complex)((Object)value);
    }

    public static class D7
    extends ArrayComplex {
        private Index7D ix;

        public D7(int len0, int len1, int len2, int len3, int len4, int len5, int len6) {
            super(new int[]{len0, len1, len2, len3, len4, len5, len6});
            this.ix = (Index7D)this.indexCalc;
        }

        private D7(Index i, Complex[] store) {
            super(i, store);
            this.ix = (Index7D)this.indexCalc;
        }

        public Complex get(int i, int j, int k, int l, int m, int n, int o) {
            return this.storage[this.ix.setDirect(i, j, k, l, m, n, o)];
        }

        public void set(int i, int j, int k, int l, int m, int n, int o, Complex value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m, (int)n, (int)o)] = value;
        }
    }

    public static class D6
    extends ArrayComplex {
        private Index6D ix;

        public D6(int len0, int len1, int len2, int len3, int len4, int len5) {
            super(new int[]{len0, len1, len2, len3, len4, len5});
            this.ix = (Index6D)this.indexCalc;
        }

        private D6(Index i, Complex[] store) {
            super(i, store);
            this.ix = (Index6D)this.indexCalc;
        }

        public Complex get(int i, int j, int k, int l, int m, int n) {
            return this.storage[this.ix.setDirect(i, j, k, l, m, n)];
        }

        public void set(int i, int j, int k, int l, int m, int n, Complex value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m, (int)n)] = value;
        }
    }

    public static class D5
    extends ArrayComplex {
        private Index5D ix;

        public D5(int len0, int len1, int len2, int len3, int len4) {
            super(new int[]{len0, len1, len2, len3, len4});
            this.ix = (Index5D)this.indexCalc;
        }

        private D5(Index i, Complex[] store) {
            super(i, store);
            this.ix = (Index5D)this.indexCalc;
        }

        public Complex get(int i, int j, int k, int l, int m) {
            return this.storage[this.ix.setDirect(i, j, k, l, m)];
        }

        public void set(int i, int j, int k, int l, int m, Complex value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m)] = value;
        }
    }

    public static class D4
    extends ArrayComplex {
        private Index4D ix;

        public D4(int len0, int len1, int len2, int len3) {
            super(new int[]{len0, len1, len2, len3});
            this.ix = (Index4D)this.indexCalc;
        }

        private D4(Index i, Complex[] store) {
            super(i, store);
            this.ix = (Index4D)this.indexCalc;
        }

        public Complex get(int i, int j, int k, int l) {
            return this.storage[this.ix.setDirect(i, j, k, l)];
        }

        public void set(int i, int j, int k, int l, Complex value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l)] = value;
        }
    }

    public static class D3
    extends ArrayComplex {
        private Index3D ix;

        public D3(int len0, int len1, int len2) {
            super(new int[]{len0, len1, len2});
            this.ix = (Index3D)this.indexCalc;
        }

        private D3(Index i, Complex[] store) {
            super(i, store);
            this.ix = (Index3D)this.indexCalc;
        }

        public Complex get(int i, int j, int k) {
            return this.storage[this.ix.setDirect(i, j, k)];
        }

        public void set(int i, int j, int k, Complex value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k)] = value;
        }

        public IF getIF() {
            return new IF();
        }

        static /* synthetic */ Index3D access$800(D3 x0) {
            return x0.ix;
        }

        public class IF {
            private int currElement = -1;
            private int size = (int)D3.access$800(D3.this).getSize();

            public boolean hasNext(int howMany) {
                return this.currElement < this.size - howMany;
            }

            public Complex getNext() {
                return D3.this.storage[++this.currElement];
            }

            public void setNext(Complex val) {
                D3.this.storage[++this.currElement] = val;
            }
        }
    }

    public static class D2
    extends ArrayComplex {
        private Index2D ix;

        public D2(int len0, int len1) {
            super(new int[]{len0, len1});
            this.ix = (Index2D)this.indexCalc;
        }

        private D2(Index i, Complex[] store) {
            super(i, store);
            this.ix = (Index2D)this.indexCalc;
        }

        public Complex get(int i, int j) {
            return this.storage[this.ix.setDirect(i, j)];
        }

        public void set(int i, int j, Complex value) {
            this.storage[this.ix.setDirect((int)i, (int)j)] = value;
        }
    }

    public static class D1
    extends ArrayComplex {
        private Index1D ix;

        public D1(int len0) {
            super(new int[]{len0});
            this.ix = (Index1D)this.indexCalc;
        }

        private D1(Index i, Complex[] store) {
            super(i, store);
            this.ix = (Index1D)this.indexCalc;
        }

        public Complex get(int i) {
            return this.storage[this.ix.setDirect(i)];
        }

        public void set(int i, Complex value) {
            this.storage[this.ix.setDirect((int)i)] = value;
        }
    }

    public static class D0
    extends ArrayComplex {
        private Index0D ix;

        public D0() {
            super(new int[0]);
            this.ix = (Index0D)this.indexCalc;
        }

        private D0(Index i, Complex[] store) {
            super(i, store);
            this.ix = (Index0D)this.indexCalc;
        }

        public Complex get() {
            return this.storage[this.ix.currentElement()];
        }

        public void set(Complex value) {
            this.storage[this.ix.currentElement()] = value;
        }
    }
}

