/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.proj4j.proj;

import org.meteoinfo.projection.proj4j.ProjCoordinate;
import org.meteoinfo.projection.proj4j.ProjectionException;
import org.meteoinfo.projection.proj4j.proj.PseudoCylindricalProjection;

public class Eckert6Projection
extends PseudoCylindricalProjection {
    private static final double n = 2.5707963267948966;
    private static final double C_y = Math.sqrt(0.7779690592966855);
    private static final double C_x = C_y / 2.0;
    private static final int MAX_ITER = 8;
    private static final double LOOP_TOL = 1.0E-7;

    public Eckert6Projection() {
        this.proj4Name = "eck6";
        this.name = "Eckert_VI";
    }

    @Override
    public ProjCoordinate project(double lam, double phi, ProjCoordinate xy) {
        int i;
        double k = 2.5707963267948966 * Math.sin(phi);
        for (i = 8; i > 0; --i) {
            double V = (phi + Math.sin(phi) - k) / (1.0 + Math.cos(phi));
            phi -= V;
            if (Math.abs(V) < 1.0E-7) break;
        }
        if (i == 0) {
            throw new ProjectionException("F_ERROR");
        }
        xy.x = C_x * lam * (1.0 + Math.cos(phi));
        xy.y = C_y * phi;
        return xy;
    }

    @Override
    public ProjCoordinate projectInverse(double x, double y, ProjCoordinate lp) {
        lp.y = Math.asin(((y /= C_y) + Math.sin(y)) / 2.5707963267948966);
        lp.x = x / (C_x * (1.0 + Math.cos(y)));
        return lp;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    @Override
    public String toString() {
        return "Eckert VI";
    }
}

