/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.proj4j.proj;

import org.meteoinfo.projection.proj4j.ProjCoordinate;
import org.meteoinfo.projection.proj4j.proj.PseudoCylindricalProjection;

public class MolleweideProjection
extends PseudoCylindricalProjection {
    public static final int MOLLEWEIDE = 0;
    public static final int WAGNER4 = 1;
    public static final int WAGNER5 = 2;
    private static final int MAX_ITER = 10;
    private static final double TOLERANCE = 1.0E-7;
    private int type = 0;
    private double cx;
    private double cy;
    private double cp;

    public MolleweideProjection() {
        this(1.5707963267948966);
    }

    public MolleweideProjection(int type) {
        this.type = type;
        switch (type) {
            case 0: {
                this.init(1.5707963267948966);
                break;
            }
            case 1: {
                this.init(1.0471975511965976);
                break;
            }
            case 2: {
                this.init(1.5707963267948966);
                this.cx = 0.90977;
                this.cy = 1.65014;
                this.cp = 3.00896;
            }
        }
        this.proj4Name = "moll";
        this.name = "Mollweide";
    }

    public MolleweideProjection(double p) {
        this.init(p);
        this.proj4Name = "moll";
        this.name = "Mollweide";
    }

    public void init(double p) {
        double p2 = p + p;
        double sp = Math.sin(p);
        double r = Math.sqrt(Math.PI * 2 * sp / (p2 + Math.sin(p2)));
        this.cx = 2.0 * r / Math.PI;
        this.cy = r / sp;
        this.cp = p2 + Math.sin(p2);
    }

    public MolleweideProjection(double cx, double cy, double cp) {
        this.cx = cx;
        this.cy = cy;
        this.cp = cp;
        this.proj4Name = "moll";
        this.name = "Mollweide";
    }

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate xy) {
        int i;
        double k = this.cp * Math.sin(lpphi);
        for (i = 10; i != 0; --i) {
            double v = (lpphi + Math.sin(lpphi) - k) / (1.0 + Math.cos(lpphi));
            lpphi -= v;
            if (Math.abs(v) < 1.0E-7) break;
        }
        lpphi = i == 0 ? (lpphi < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : (lpphi *= 0.5);
        xy.x = this.cx * lplam * Math.cos(lpphi);
        xy.y = this.cy * Math.sin(lpphi);
        return xy;
    }

    @Override
    public ProjCoordinate projectInverse(double x, double y, ProjCoordinate lp) {
        double lat = Math.asin(y / this.cy);
        double lon = x / (this.cx * Math.cos(lat));
        lat += lat;
        lat = Math.asin((lat + Math.sin(lat)) / this.cp);
        lp.x = lon;
        lp.y = lat;
        return lp;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    @Override
    public String toString() {
        switch (this.type) {
            case 1: {
                return "Wagner IV";
            }
            case 2: {
                return "Wagner V";
            }
        }
        return "Molleweide";
    }
}

