/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.table;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.table.DataColumn;
import org.meteoinfo.table.DataColumnCollection;
import org.meteoinfo.table.DataTable;

public class DataRow {
    private int rowIndex = -1;
    private DataColumnCollection columns;
    private DataTable table;
    private final Map<String, Object> itemMap = new LinkedHashMap<String, Object>();

    public DataRow() {
    }

    public DataRow(DataTable table) {
        this.table = table;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public DataTable getTable() {
        return this.table;
    }

    public void setTable(DataTable value) {
        this.table = value;
    }

    public void setColumns(DataColumnCollection columns) {
        this.columns = columns;
    }

    public void setColumns(DataColumn column) {
        this.columns = new DataColumnCollection();
        this.columns.add(column);
    }

    public DataColumnCollection getColumns() {
        return this.columns;
    }

    public void setValue(int index, Object value) {
        this.setValue((DataColumn)this.columns.get(index), value);
    }

    public void setValue(String columnName, Object value) {
        this.setValue(this.columns.get(columnName), value);
    }

    public void setValue(DataColumn column, Object value) {
        if (column != null) {
            String lowerColumnName = column.getColumnName().toLowerCase();
            if (this.itemMap.containsKey(lowerColumnName)) {
                this.itemMap.remove(lowerColumnName);
            }
            this.itemMap.put(lowerColumnName, column.convertTo(value));
        }
    }

    public void addColumn(DataColumn column) {
        Object value = null;
        switch (column.getDataType()) {
            case INT: {
                value = 0;
                break;
            }
            case STRING: {
                value = "";
                break;
            }
            case FLOAT: {
                value = Float.valueOf(0.0f);
                break;
            }
            case DOUBLE: {
                value = 0.0;
            }
        }
        this.setValue(column, value);
    }

    public void removeColumn(DataColumn column) {
        String lowerColumnName;
        if (column != null && this.itemMap.containsKey(lowerColumnName = column.getColumnName().toLowerCase())) {
            this.itemMap.remove(lowerColumnName);
        }
    }

    public void renameColumn(String oldName, String name) {
        if (this.itemMap.containsKey(oldName = oldName.toLowerCase())) {
            Object value = this.itemMap.get(oldName);
            this.setValue(name, value);
            this.itemMap.remove(oldName);
        }
    }

    public Object getValue(int index) {
        String colName = ((DataColumn)this.columns.get(index)).getColumnName();
        return this.getValue(colName);
    }

    public Object getValue(String columnName) {
        return this.getItemMap().get(columnName.toLowerCase());
    }

    public String getValueStr(String columnName) {
        DataColumn dc = this.columns.get(columnName);
        if (dc.getFormat() == null) {
            return this.getValue(columnName).toString();
        }
        if (dc.getDataType() == DataType.DATE) {
            SimpleDateFormat format = new SimpleDateFormat(dc.getFormat());
            return format.format((Date)this.getValue(columnName));
        }
        return String.format(dc.getFormat(), this.getValue(columnName));
    }

    public String getValueStr(String columnName, String formatStr) {
        if (formatStr == null) {
            return this.getValueStr(columnName);
        }
        DataColumn dc = this.columns.get(columnName);
        if (dc.getDataType() == DataType.DATE) {
            SimpleDateFormat dformat = new SimpleDateFormat(formatStr);
            return dformat.format((Date)this.getValue(columnName));
        }
        return String.format(formatStr, this.getValue(columnName));
    }

    public Map<String, Object> getItemMap() {
        return this.itemMap;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public void copyFrom(DataRow row) {
        this.itemMap.clear();
        for (Object c : this.columns) {
            this.itemMap.put(c.toString().toLowerCase(), row.getValue(c.toString()));
        }
    }

    public DataRow colSelect(DataColumn col) {
        DataRow row = new DataRow();
        row.setColumns(col);
        row.itemMap.put(col.toString().toLowerCase(), this.getValue(col.toString()));
        return row;
    }

    public DataRow colSelect(DataColumnCollection cols) {
        DataRow row = new DataRow();
        row.setColumns(cols);
        for (Object c : cols) {
            row.itemMap.put(c.toString().toLowerCase(), this.getValue(c.toString()));
        }
        return row;
    }

    public Object clone() {
        DataRow row = new DataRow();
        row.setColumns(this.columns);
        for (Object c : this.columns) {
            row.itemMap.put(c.toString().toLowerCase(), this.getValue(c.toString()));
        }
        return row;
    }
}

