/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.bak;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.meteoinfo.bak.ArrayUtil;
import org.meteoinfo.data.analysis.Statistics;
import org.meteoinfo.geoprocess.GeoComputation;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointD;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.math.meteo.MeteoMath;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.Complex;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.MAMath;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.shape.PolygonShape;
import org.meteoinfo.shape.Shape;
import org.python.core.PyComplex;

public class ArrayMath {
    public static double fill_value = -9999.0;

    public static DataType getDataType(Object o) {
        if (o instanceof Integer) {
            return DataType.INT;
        }
        if (o instanceof Float) {
            return DataType.FLOAT;
        }
        if (o instanceof Double) {
            return DataType.DOUBLE;
        }
        if (o instanceof Boolean) {
            return DataType.BOOLEAN;
        }
        return DataType.OBJECT;
    }

    private static DataType commonType(DataType aType, DataType bType) {
        short bnb;
        if (aType == bType) {
            return aType;
        }
        if (aType == DataType.OBJECT || bType == DataType.OBJECT) {
            return DataType.OBJECT;
        }
        short anb = ArrayMath.typeToNBytes(aType);
        if (anb == (bnb = ArrayMath.typeToNBytes(bType))) {
            switch (aType) {
                case INT: 
                case LONG: {
                    return bType;
                }
                case FLOAT: 
                case DOUBLE: {
                    return aType;
                }
            }
        }
        return anb > bnb ? aType : bType;
    }

    public static short typeToNBytes(DataType dataType) {
        switch (dataType) {
            case BYTE: {
                return 1;
            }
            case SHORT: {
                return 2;
            }
            case INT: 
            case FLOAT: {
                return 4;
            }
            case LONG: 
            case DOUBLE: {
                return 8;
            }
        }
        return 0;
    }

    public static boolean isComplex(Array a) {
        Object a0 = a.getObject(0);
        return a0 instanceof Complex;
    }

    public static boolean isNumeric(Array a) {
        boolean r = a.getDataType().isNumeric();
        if (!r) {
            r = ArrayMath.isComplex(a);
        }
        return r;
    }

    public static int broadcastCheck(Array a, Array b) {
        int i;
        int[] bshape;
        int m;
        int[] ashape = a.getShape();
        int n = ashape.length;
        if (n != (m = (bshape = b.getShape()).length)) {
            int len = Math.min(n, m);
            for (int i2 = 0; i2 < len; ++i2) {
                int na = ashape[n - i2 - 1];
                int nb = bshape[m - i2 - 1];
                if (na == nb || na == 1 || nb == 1) continue;
                return -1;
            }
            return 1;
        }
        boolean sameDim = true;
        for (i = 0; i < n; ++i) {
            if (ashape[i] == bshape[i]) continue;
            sameDim = false;
            break;
        }
        if (sameDim) {
            return 0;
        }
        for (i = 0; i < n; ++i) {
            if (ashape[i] == bshape[i] || ashape[i] == 1 || bshape[i] == 1) continue;
            return -1;
        }
        return 1;
    }

    public static int[] broadcast(Array a, Array b) {
        int[] bshape;
        int m;
        int[] ashape = a.getShape();
        int n = ashape.length;
        if (n == (m = (bshape = b.getShape()).length)) {
            int[] shape = new int[n];
            for (int i = 0; i < n; ++i) {
                shape[i] = Math.max(ashape[i], bshape[i]);
            }
            return shape;
        }
        int len = Math.max(n, m);
        int[] shape = new int[len];
        for (int i = 0; i < len; ++i) {
            int nb;
            int na;
            if (m < n) {
                na = ashape[n - i - 1];
                if (m - i - 1 >= 0) {
                    nb = bshape[m - i - 1];
                    shape[n - i - 1] = Math.max(na, nb);
                    continue;
                }
                shape[n - i - 1] = na;
                continue;
            }
            nb = bshape[m - i - 1];
            if (n - i - 1 >= 0) {
                na = ashape[n - i - 1];
                shape[m - i - 1] = Math.max(na, nb);
                continue;
            }
            shape[m - i - 1] = nb;
        }
        return shape;
    }

    private static void setIndex(int broadcast, Index aindex, Index bindex, int[] current, int n, int na, int nb) {
        if (broadcast == 0) {
            aindex.set(current);
            bindex.set(current);
        } else {
            for (int j = 0; j < n; ++j) {
                int ib;
                int ia = na - j - 1;
                if (ia >= 0) {
                    if (aindex.getShape(ia) == 1) {
                        aindex.setDim(ia, 0);
                    } else {
                        aindex.setDim(ia, current[n - j - 1]);
                    }
                }
                if ((ib = nb - j - 1) < 0) continue;
                if (bindex.getShape(ib) == 1) {
                    bindex.setDim(ib, 0);
                    continue;
                }
                bindex.setDim(ib, current[n - j - 1]);
            }
        }
    }

    private static void setIndex(Index aindex, Index bindex, int[] current, int n, int na, int nb) {
        for (int j = 0; j < n; ++j) {
            int ib;
            int ia = na - j - 1;
            if (ia >= 0) {
                if (aindex.getShape(ia) == 1) {
                    aindex.setDim(ia, 0);
                } else {
                    aindex.setDim(ia, current[n - j - 1]);
                }
            }
            if ((ib = nb - j - 1) < 0) continue;
            if (bindex.getShape(ib) == 1) {
                bindex.setDim(ib, 0);
                continue;
            }
            bindex.setDim(ib, current[n - j - 1]);
        }
    }

    public static Array add(Array a, Array b) {
        DataType type = ArrayMath.commonType(a.getDataType(), b.getDataType());
        switch (type) {
            case INT: 
            case SHORT: 
            case BOOLEAN: {
                return ArrayMath.addInt(a, b);
            }
            case FLOAT: {
                return ArrayMath.addFloat(a, b);
            }
            case DOUBLE: {
                return ArrayMath.addDouble(a, b);
            }
            case OBJECT: {
                if (!ArrayMath.isComplex(a) && !ArrayMath.isComplex(b)) break;
                return ArrayMath.addComplex(a, b);
            }
        }
        return null;
    }

    public static Array add(Array a, Number b) {
        DataType bType = ArrayMath.getDataType(b);
        DataType type = ArrayMath.commonType(a.getDataType(), bType);
        switch (type) {
            case INT: 
            case SHORT: 
            case BOOLEAN: {
                return ArrayMath.addInt(a, b.intValue());
            }
            case FLOAT: {
                return ArrayMath.addFloat(a, b.floatValue());
            }
            case DOUBLE: {
                return ArrayMath.addDouble(a, b.doubleValue());
            }
            case OBJECT: {
                if (!ArrayMath.isComplex(a)) break;
                return ArrayMath.addComplex(a, b.doubleValue());
            }
        }
        return null;
    }

    public static Array add(Array a, Complex b) {
        return ArrayMath.addComplex(a, b);
    }

    public static Array add(Array a, PyComplex b) {
        return ArrayMath.addComplex(a, new Complex(b.real, b.imag));
    }

    private static Array addInt_bak(Array a, Array b) {
        int broadcast = ArrayMath.broadcastCheck(a, b);
        if (broadcast != -1) {
            int[] shape = broadcast == 0 ? a.getShape() : ArrayMath.broadcast(a, b);
            Array r = Array.factory(DataType.INT, shape);
            Index index = r.getIndex();
            Index aindex = a.getIndex();
            Index bindex = b.getIndex();
            int n = r.getRank();
            int na = a.getRank();
            int nb = b.getRank();
            int i = 0;
            while ((long)i < r.getSize()) {
                int[] current = index.getCurrentCounter();
                ArrayMath.setIndex(broadcast, aindex, bindex, current, n, na, nb);
                if (a.getInt(aindex) == Integer.MIN_VALUE || b.getInt(bindex) == Integer.MIN_VALUE) {
                    r.setInt(i, Integer.MIN_VALUE);
                } else {
                    r.setInt(i, a.getInt(aindex) + b.getInt(bindex));
                }
                index.incr();
                ++i;
            }
            return r;
        }
        return null;
    }

    private static Array addInt(Array a, Array b) {
        int broadcast = ArrayMath.broadcastCheck(a, b);
        switch (broadcast) {
            case 0: {
                Array r = Array.factory(DataType.INT, a.getShape());
                int i = 0;
                while ((long)i < a.getSize()) {
                    if (a.getInt(i) == Integer.MIN_VALUE || b.getInt(i) == Integer.MIN_VALUE) {
                        r.setInt(i, Integer.MIN_VALUE);
                    } else {
                        r.setInt(i, a.getInt(i) + b.getInt(i));
                    }
                    ++i;
                }
                return r;
            }
            case 1: {
                int[] shape = ArrayMath.broadcast(a, b);
                Array r = Array.factory(DataType.INT, shape);
                Index index = r.getIndex();
                Index aindex = a.getIndex();
                Index bindex = b.getIndex();
                int n = r.getRank();
                int na = a.getRank();
                int nb = b.getRank();
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] current = index.getCurrentCounter();
                    ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                    if (a.getInt(aindex) == Integer.MIN_VALUE || b.getInt(bindex) == Integer.MIN_VALUE) {
                        r.setInt(i, Integer.MIN_VALUE);
                    } else {
                        r.setInt(i, a.getInt(aindex) + b.getInt(bindex));
                    }
                    index.incr();
                    ++i;
                }
                return r;
            }
        }
        return null;
    }

    private static Array addInt(Array a, int b) {
        Array r = Array.factory(DataType.INT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (a.getInt(i) == Integer.MIN_VALUE) {
                r.setInt(i, Integer.MIN_VALUE);
            } else {
                r.setInt(i, a.getInt(i) + b);
            }
            ++i;
        }
        return r;
    }

    private static Array addFloat(Array a, Array b) {
        int broadcast = ArrayMath.broadcastCheck(a, b);
        switch (broadcast) {
            case 0: {
                Array r = Array.factory(DataType.FLOAT, a.getShape());
                int i = 0;
                while ((long)i < a.getSize()) {
                    if (Float.isNaN(a.getFloat(i)) || Float.isNaN(b.getFloat(i))) {
                        r.setFloat(i, Float.NaN);
                    } else {
                        r.setFloat(i, a.getFloat(i) + b.getFloat(i));
                    }
                    ++i;
                }
                return r;
            }
            case 1: {
                int[] shape = ArrayMath.broadcast(a, b);
                Array r = Array.factory(DataType.FLOAT, shape);
                Index index = r.getIndex();
                Index aindex = a.getIndex();
                Index bindex = b.getIndex();
                int n = r.getRank();
                int na = a.getRank();
                int nb = b.getRank();
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] current = index.getCurrentCounter();
                    ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                    if (Float.isNaN(a.getFloat(aindex)) || Float.isNaN(b.getFloat(bindex))) {
                        r.setFloat(i, Float.NaN);
                    } else {
                        r.setFloat(i, a.getFloat(aindex) + b.getFloat(bindex));
                    }
                    index.incr();
                    ++i;
                }
                return r;
            }
        }
        return null;
    }

    private static Array addFloat(Array a, float b) {
        Array r = Array.factory(DataType.FLOAT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (Float.isNaN(a.getFloat(i))) {
                r.setFloat(i, Float.NaN);
            } else {
                r.setFloat(i, a.getFloat(i) + b);
            }
            ++i;
        }
        return r;
    }

    private static Array addDouble(Array a, Array b) {
        int broadcast = ArrayMath.broadcastCheck(a, b);
        switch (broadcast) {
            case 0: {
                Array r = Array.factory(DataType.DOUBLE, a.getShape());
                int i = 0;
                while ((long)i < a.getSize()) {
                    if (Double.isNaN(a.getDouble(i)) || Double.isNaN(b.getDouble(i))) {
                        r.setDouble(i, Double.NaN);
                    } else {
                        r.setDouble(i, a.getDouble(i) + b.getDouble(i));
                    }
                    ++i;
                }
                return r;
            }
            case 1: {
                int[] shape = ArrayMath.broadcast(a, b);
                Array r = Array.factory(DataType.DOUBLE, shape);
                Index index = r.getIndex();
                Index aindex = a.getIndex();
                Index bindex = b.getIndex();
                int n = r.getRank();
                int na = a.getRank();
                int nb = b.getRank();
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] current = index.getCurrentCounter();
                    ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                    if (Double.isNaN(a.getDouble(aindex)) || Double.isNaN(b.getDouble(bindex))) {
                        r.setDouble(i, Double.NaN);
                    } else {
                        r.setDouble(i, a.getDouble(aindex) + b.getDouble(bindex));
                    }
                    index.incr();
                    ++i;
                }
                return r;
            }
        }
        return null;
    }

    private static Array addDouble(Array a, double b) {
        Array r = Array.factory(DataType.DOUBLE, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (Double.isNaN(a.getDouble(i))) {
                r.setDouble(i, Double.NaN);
            } else {
                r.setDouble(i, a.getDouble(i) + b);
            }
            ++i;
        }
        return r;
    }

    private static Array addComplex(Array a, Array b) {
        int broadcast = ArrayMath.broadcastCheck(a, b);
        switch (broadcast) {
            case 0: {
                Array r = Array.factory(DataType.OBJECT, a.getShape());
                if (ArrayMath.isComplex(a)) {
                    if (ArrayMath.isComplex(b)) {
                        int i = 0;
                        while ((long)i < a.getSize()) {
                            Complex v1 = (Complex)((Object)a.getObject(i));
                            Complex v2 = (Complex)((Object)b.getObject(i));
                            if (v1.isNaN() || v2.isNaN()) {
                                r.setObject(i, (Object)v1);
                            } else {
                                r.setObject(i, (Object)v1.add(v2));
                            }
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < a.getSize()) {
                            Complex v = (Complex)((Object)a.getObject(i));
                            if (v.isNaN() || Double.isNaN(b.getDouble(i))) {
                                r.setObject(i, (Object)new Complex(Double.NaN));
                            } else {
                                r.setObject(i, (Object)v.add(b.getDouble(i)));
                            }
                            ++i;
                        }
                    }
                } else {
                    int i = 0;
                    while ((long)i < a.getSize()) {
                        Complex v = (Complex)((Object)b.getObject(i));
                        if (v.isNaN() || Double.isNaN(a.getDouble(i))) {
                            r.setObject(i, (Object)new Complex(Double.NaN));
                        } else {
                            r.setObject(i, (Object)v.add(a.getDouble(i)));
                        }
                        ++i;
                    }
                }
                return r;
            }
            case 1: {
                int[] shape = ArrayMath.broadcast(a, b);
                Array r = Array.factory(DataType.OBJECT, shape);
                Index index = r.getIndex();
                Index aindex = a.getIndex();
                Index bindex = b.getIndex();
                int n = r.getRank();
                int na = a.getRank();
                int nb = b.getRank();
                if (ArrayMath.isComplex(a)) {
                    if (ArrayMath.isComplex(b)) {
                        int i = 0;
                        while ((long)i < r.getSize()) {
                            int[] current = index.getCurrentCounter();
                            ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                            Complex v1 = (Complex)((Object)a.getObject(aindex));
                            Complex v2 = (Complex)((Object)b.getObject(bindex));
                            if (v1.isNaN() || v2.isNaN()) {
                                r.setObject(i, (Object)v1);
                            } else {
                                r.setObject(i, (Object)v1.add(v2));
                            }
                            index.incr();
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < r.getSize()) {
                            int[] current = index.getCurrentCounter();
                            ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                            Complex v = (Complex)((Object)a.getObject(aindex));
                            if (v.isNaN() || Double.isNaN(b.getDouble(bindex))) {
                                r.setObject(i, (Object)new Complex(Double.NaN));
                            } else {
                                r.setObject(i, (Object)v.add(b.getDouble(bindex)));
                            }
                            index.incr();
                            ++i;
                        }
                    }
                } else {
                    int i = 0;
                    while ((long)i < a.getSize()) {
                        int[] current = index.getCurrentCounter();
                        ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                        Complex v = (Complex)((Object)b.getObject(bindex));
                        if (v.isNaN() || Double.isNaN(a.getDouble(aindex))) {
                            r.setObject(i, (Object)new Complex(Double.NaN));
                        } else {
                            r.setObject(i, (Object)v.add(a.getDouble(aindex)));
                        }
                        ++i;
                    }
                }
                return r;
            }
        }
        return null;
    }

    private static Array addComplex(Array a, double b) {
        Array r = Array.factory(DataType.OBJECT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            Complex v = (Complex)((Object)a.getObject(i));
            if (v.isNaN()) {
                r.setObject(i, (Object)v);
            } else {
                r.setObject(i, (Object)v.add(b));
            }
            ++i;
        }
        return r;
    }

    private static Array addComplex(Array a, Complex b) {
        Array r = Array.factory(DataType.OBJECT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            Complex v = (Complex)((Object)a.getObject(i));
            if (v.isNaN()) {
                r.setObject(i, (Object)v);
            } else {
                r.setObject(i, (Object)v.add(b));
            }
            ++i;
        }
        return r;
    }

    public static Array sub(Array a, Array b) {
        DataType type = ArrayMath.commonType(a.getDataType(), b.getDataType());
        switch (type) {
            case INT: 
            case SHORT: 
            case BOOLEAN: {
                return ArrayMath.subInt(a, b);
            }
            case FLOAT: {
                return ArrayMath.subFloat(a, b);
            }
            case DOUBLE: {
                return ArrayMath.subDouble(a, b);
            }
            case OBJECT: {
                if (!ArrayMath.isComplex(a) && !ArrayMath.isComplex(b)) break;
                return ArrayMath.subComplex(a, b);
            }
        }
        return null;
    }

    public static Array sub(Array a, Number b) {
        DataType bType = ArrayMath.getDataType(b);
        DataType type = ArrayMath.commonType(a.getDataType(), bType);
        switch (type) {
            case INT: 
            case SHORT: 
            case BOOLEAN: {
                return ArrayMath.subInt(a, b.intValue());
            }
            case FLOAT: {
                return ArrayMath.subFloat(a, b.floatValue());
            }
            case DOUBLE: {
                return ArrayMath.subDouble(a, b.doubleValue());
            }
            case OBJECT: {
                if (!ArrayMath.isComplex(a)) break;
                return ArrayMath.subComplex(a, b.doubleValue());
            }
        }
        return null;
    }

    public static Array sub(Array a, Complex b) {
        return ArrayMath.subComplex(a, b);
    }

    public static Array sub(Array a, PyComplex b) {
        return ArrayMath.subComplex(a, new Complex(b.real, b.imag));
    }

    public static Array sub(Number b, Array a) {
        DataType bType = ArrayMath.getDataType(b);
        DataType type = ArrayMath.commonType(a.getDataType(), bType);
        switch (type) {
            case INT: 
            case SHORT: 
            case BOOLEAN: {
                return ArrayMath.subInt(b.intValue(), a);
            }
            case FLOAT: {
                return ArrayMath.subFloat(b.floatValue(), a);
            }
            case DOUBLE: {
                return ArrayMath.subDouble(b.doubleValue(), a);
            }
            case OBJECT: {
                if (!ArrayMath.isComplex(a)) break;
                return ArrayMath.subComplex(b.doubleValue(), a);
            }
        }
        return null;
    }

    public static Array sub(Complex b, Array a) {
        return ArrayMath.subComplex(b, a);
    }

    public static Array sub(PyComplex b, Array a) {
        return ArrayMath.subComplex(new Complex(b.real, b.imag), a);
    }

    private static Array subInt(Array a, Array b) {
        int broadcast = ArrayMath.broadcastCheck(a, b);
        switch (broadcast) {
            case 0: {
                Array r = Array.factory(DataType.INT, a.getShape());
                int i = 0;
                while ((long)i < a.getSize()) {
                    r.setInt(i, a.getInt(i) - b.getInt(i));
                    ++i;
                }
                return r;
            }
            case 1: {
                int[] shape = ArrayMath.broadcast(a, b);
                Array r = Array.factory(DataType.INT, shape);
                Index index = r.getIndex();
                Index aindex = a.getIndex();
                Index bindex = b.getIndex();
                int n = r.getRank();
                int na = a.getRank();
                int nb = b.getRank();
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] current = index.getCurrentCounter();
                    ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                    r.setInt(i, a.getInt(aindex) - b.getInt(bindex));
                    index.incr();
                    ++i;
                }
                return r;
            }
        }
        return null;
    }

    private static Array subInt(Array a, int b) {
        Array r = Array.factory(DataType.INT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setInt(i, a.getInt(i) - b);
            ++i;
        }
        return r;
    }

    private static Array subInt(int b, Array a) {
        Array r = Array.factory(DataType.INT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setInt(i, b - a.getInt(i));
            ++i;
        }
        return r;
    }

    private static Array subFloat(Array a, Array b) {
        int broadcast = ArrayMath.broadcastCheck(a, b);
        switch (broadcast) {
            case 0: {
                Array r = Array.factory(DataType.FLOAT, a.getShape());
                int i = 0;
                while ((long)i < a.getSize()) {
                    if (Float.isNaN(a.getFloat(i)) || Float.isNaN(b.getFloat(i))) {
                        r.setFloat(i, Float.NaN);
                    } else {
                        r.setFloat(i, a.getFloat(i) - b.getFloat(i));
                    }
                    ++i;
                }
                return r;
            }
            case 1: {
                int[] shape = ArrayMath.broadcast(a, b);
                Array r = Array.factory(DataType.FLOAT, shape);
                Index index = r.getIndex();
                Index aindex = a.getIndex();
                Index bindex = b.getIndex();
                int n = r.getRank();
                int na = a.getRank();
                int nb = b.getRank();
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] current = index.getCurrentCounter();
                    ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                    if (Float.isNaN(a.getFloat(aindex)) || Float.isNaN(b.getFloat(bindex))) {
                        r.setFloat(i, Float.NaN);
                    } else {
                        r.setFloat(i, a.getFloat(aindex) - b.getFloat(bindex));
                    }
                    index.incr();
                    ++i;
                }
                return r;
            }
        }
        return null;
    }

    private static Array subFloat(Array a, float b) {
        Array r = Array.factory(DataType.FLOAT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setFloat(i, a.getFloat(i) - b);
            ++i;
        }
        return r;
    }

    private static Array subFloat(float b, Array a) {
        Array r = Array.factory(DataType.FLOAT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setFloat(i, b - a.getFloat(i));
            ++i;
        }
        return r;
    }

    private static Array subDouble(Array a, Array b) {
        int broadcast = ArrayMath.broadcastCheck(a, b);
        switch (broadcast) {
            case 0: {
                Array r = Array.factory(DataType.DOUBLE, a.getShape());
                int i = 0;
                while ((long)i < a.getSize()) {
                    if (Double.isNaN(a.getDouble(i)) || Double.isNaN(b.getDouble(i))) {
                        r.setDouble(i, Double.NaN);
                    } else {
                        r.setDouble(i, a.getDouble(i) - b.getDouble(i));
                    }
                    ++i;
                }
                return r;
            }
            case 1: {
                int[] shape = ArrayMath.broadcast(a, b);
                Array r = Array.factory(DataType.DOUBLE, shape);
                Index index = r.getIndex();
                Index aindex = a.getIndex();
                Index bindex = b.getIndex();
                int n = r.getRank();
                int na = a.getRank();
                int nb = b.getRank();
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] current = index.getCurrentCounter();
                    ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                    if (Double.isNaN(a.getDouble(aindex)) || Double.isNaN(b.getDouble(bindex))) {
                        r.setDouble(i, Double.NaN);
                    } else {
                        r.setDouble(i, a.getDouble(aindex) - b.getDouble(bindex));
                    }
                    index.incr();
                    ++i;
                }
                return r;
            }
        }
        return null;
    }

    private static Array subDouble(Array a, double b) {
        Array r = Array.factory(DataType.DOUBLE, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setDouble(i, a.getDouble(i) - b);
            ++i;
        }
        return r;
    }

    private static Array subDouble(double b, Array a) {
        Array r = Array.factory(DataType.DOUBLE, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setDouble(i, b - a.getDouble(i));
            ++i;
        }
        return r;
    }

    private static Array subComplex(Array a, Array b) {
        int broadcast = ArrayMath.broadcastCheck(a, b);
        switch (broadcast) {
            case 0: {
                Array r = Array.factory(DataType.OBJECT, a.getShape());
                if (ArrayMath.isComplex(a)) {
                    if (ArrayMath.isComplex(b)) {
                        int i = 0;
                        while ((long)i < a.getSize()) {
                            Complex v1 = (Complex)((Object)a.getObject(i));
                            Complex v2 = (Complex)((Object)b.getObject(i));
                            if (v1.isNaN() || v2.isNaN()) {
                                r.setObject(i, (Object)v1);
                            } else {
                                r.setObject(i, (Object)v1.subtract(v2));
                            }
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < a.getSize()) {
                            Complex v = (Complex)((Object)a.getObject(i));
                            if (v.isNaN() || Double.isNaN(b.getDouble(i))) {
                                r.setObject(i, (Object)new Complex(Double.NaN));
                            } else {
                                r.setObject(i, (Object)v.subtract(b.getDouble(i)));
                            }
                            ++i;
                        }
                    }
                } else {
                    int i = 0;
                    while ((long)i < a.getSize()) {
                        Complex v = (Complex)((Object)b.getObject(i));
                        if (v.isNaN() || Double.isNaN(a.getDouble(i))) {
                            r.setObject(i, (Object)new Complex(Double.NaN));
                        } else {
                            r.setObject(i, (Object)v.subtract(a.getDouble(i)));
                        }
                        ++i;
                    }
                }
                return r;
            }
            case 1: {
                int[] shape = ArrayMath.broadcast(a, b);
                Array r = Array.factory(DataType.OBJECT, shape);
                Index index = r.getIndex();
                Index aindex = a.getIndex();
                Index bindex = b.getIndex();
                int n = r.getRank();
                int na = a.getRank();
                int nb = b.getRank();
                if (ArrayMath.isComplex(a)) {
                    if (ArrayMath.isComplex(b)) {
                        int i = 0;
                        while ((long)i < r.getSize()) {
                            int[] current = index.getCurrentCounter();
                            ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                            Complex v1 = (Complex)((Object)a.getObject(aindex));
                            Complex v2 = (Complex)((Object)b.getObject(bindex));
                            if (v1.isNaN() || v2.isNaN()) {
                                r.setObject(i, (Object)v1);
                            } else {
                                r.setObject(i, (Object)v1.subtract(v2));
                            }
                            index.incr();
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < r.getSize()) {
                            int[] current = index.getCurrentCounter();
                            ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                            Complex v = (Complex)((Object)a.getObject(aindex));
                            if (v.isNaN() || Double.isNaN(b.getDouble(bindex))) {
                                r.setObject(i, (Object)new Complex(Double.NaN));
                            } else {
                                r.setObject(i, (Object)v.subtract(b.getDouble(bindex)));
                            }
                            index.incr();
                            ++i;
                        }
                    }
                } else {
                    int i = 0;
                    while ((long)i < a.getSize()) {
                        int[] current = index.getCurrentCounter();
                        ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                        Complex v = (Complex)((Object)b.getObject(bindex));
                        if (v.isNaN() || Double.isNaN(a.getDouble(aindex))) {
                            r.setObject(i, (Object)new Complex(Double.NaN));
                        } else {
                            r.setObject(i, (Object)v.subtract(a.getDouble(aindex)));
                        }
                        ++i;
                    }
                }
                return r;
            }
        }
        return null;
    }

    private static Array subComplex(Array a, double b) {
        Array r = Array.factory(DataType.OBJECT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            Complex v = (Complex)((Object)a.getObject(i));
            if (v.isNaN()) {
                r.setObject(i, (Object)v);
            } else {
                r.setObject(i, (Object)v.subtract(b));
            }
            ++i;
        }
        return r;
    }

    private static Array subComplex(Array a, Complex b) {
        Array r = Array.factory(DataType.OBJECT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            Complex v = (Complex)((Object)a.getObject(i));
            if (v.isNaN()) {
                r.setObject(i, (Object)v);
            } else {
                r.setObject(i, (Object)v.subtract(b));
            }
            ++i;
        }
        return r;
    }

    private static Array subComplex(double b, Array a) {
        Array r = Array.factory(DataType.OBJECT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            Complex v = (Complex)((Object)a.getObject(i));
            if (v.isNaN()) {
                r.setObject(i, (Object)v);
            } else {
                r.setObject(i, (Object)v.rSubtract(b));
            }
            ++i;
        }
        return r;
    }

    private static Array subComplex(Complex b, Array a) {
        Array r = Array.factory(DataType.OBJECT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            Complex v = (Complex)((Object)a.getObject(i));
            if (v.isNaN()) {
                r.setObject(i, (Object)v);
            } else {
                r.setObject(i, (Object)b.subtract(v));
            }
            ++i;
        }
        return r;
    }

    public static Array mul(Array a, Array b) {
        DataType type = ArrayMath.commonType(a.getDataType(), b.getDataType());
        switch (type) {
            case INT: 
            case SHORT: 
            case BOOLEAN: {
                return ArrayMath.mulInt(a, b);
            }
            case FLOAT: {
                return ArrayMath.mulFloat(a, b);
            }
            case DOUBLE: {
                return ArrayMath.mulDouble(a, b);
            }
            case OBJECT: {
                if (!ArrayMath.isComplex(a) && !ArrayMath.isComplex(b)) break;
                return ArrayMath.mulComplex(a, b);
            }
        }
        return null;
    }

    public static Array mul(Array a, Number b) {
        DataType bType = ArrayMath.getDataType(b);
        DataType type = ArrayMath.commonType(a.getDataType(), bType);
        switch (type) {
            case INT: 
            case SHORT: 
            case BOOLEAN: {
                return ArrayMath.mulInt(a, b.intValue());
            }
            case FLOAT: {
                return ArrayMath.mulFloat(a, b.floatValue());
            }
            case DOUBLE: {
                return ArrayMath.mulDouble(a, b.doubleValue());
            }
            case OBJECT: {
                if (!ArrayMath.isComplex(a)) break;
                return ArrayMath.mulComplex(a, b.doubleValue());
            }
        }
        return null;
    }

    public static Array mul(Array a, Complex b) {
        return ArrayMath.mulComplex(a, b);
    }

    public static Array mul(Array a, PyComplex b) {
        return ArrayMath.mulComplex(a, new Complex(b.real, b.imag));
    }

    private static Array mulInt(Array a, Array b) {
        int broadcast = ArrayMath.broadcastCheck(a, b);
        switch (broadcast) {
            case 0: {
                Array r = Array.factory(DataType.INT, a.getShape());
                int i = 0;
                while ((long)i < a.getSize()) {
                    if (a.getInt(i) == Integer.MIN_VALUE || b.getInt(i) == Integer.MIN_VALUE) {
                        r.setInt(i, Integer.MIN_VALUE);
                    } else {
                        r.setInt(i, a.getInt(i) * b.getInt(i));
                    }
                    ++i;
                }
                return r;
            }
            case 1: {
                int[] shape = ArrayMath.broadcast(a, b);
                Array r = Array.factory(DataType.INT, shape);
                Index index = r.getIndex();
                Index aindex = a.getIndex();
                Index bindex = b.getIndex();
                int n = r.getRank();
                int na = a.getRank();
                int nb = b.getRank();
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] current = index.getCurrentCounter();
                    ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                    if (a.getInt(aindex) == Integer.MIN_VALUE || b.getInt(bindex) == Integer.MIN_VALUE) {
                        r.setInt(i, Integer.MIN_VALUE);
                    } else {
                        r.setInt(i, a.getInt(aindex) * b.getInt(bindex));
                    }
                    index.incr();
                    ++i;
                }
                return r;
            }
        }
        return null;
    }

    private static Array mulInt(Array a, int b) {
        Array r = Array.factory(DataType.INT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (a.getInt(i) == Integer.MIN_VALUE) {
                r.setInt(i, Integer.MIN_VALUE);
            } else {
                r.setInt(i, a.getInt(i) * b);
            }
            ++i;
        }
        return r;
    }

    private static Array mulFloat(Array a, Array b) {
        int broadcast = ArrayMath.broadcastCheck(a, b);
        switch (broadcast) {
            case 0: {
                Array r = Array.factory(DataType.FLOAT, a.getShape());
                int i = 0;
                while ((long)i < a.getSize()) {
                    if (Float.isNaN(a.getFloat(i)) || Float.isNaN(b.getFloat(i))) {
                        r.setFloat(i, Float.NaN);
                    } else {
                        r.setFloat(i, a.getFloat(i) * b.getFloat(i));
                    }
                    ++i;
                }
                return r;
            }
            case 1: {
                int[] shape = ArrayMath.broadcast(a, b);
                Array r = Array.factory(DataType.FLOAT, shape);
                Index index = r.getIndex();
                Index aindex = a.getIndex();
                Index bindex = b.getIndex();
                int n = r.getRank();
                int na = a.getRank();
                int nb = b.getRank();
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] current = index.getCurrentCounter();
                    ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                    if (Float.isNaN(a.getFloat(aindex)) || Float.isNaN(b.getFloat(bindex))) {
                        r.setFloat(i, Float.NaN);
                    } else {
                        r.setFloat(i, a.getFloat(aindex) * b.getFloat(bindex));
                    }
                    index.incr();
                    ++i;
                }
                return r;
            }
        }
        return null;
    }

    private static Array mulFloat(Array a, float b) {
        Array r = Array.factory(DataType.FLOAT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (Float.isNaN(a.getFloat(i))) {
                r.setFloat(i, Float.NaN);
            } else {
                r.setFloat(i, a.getFloat(i) * b);
            }
            ++i;
        }
        return r;
    }

    private static Array mulDouble(Array a, Array b) {
        int broadcast = ArrayMath.broadcastCheck(a, b);
        switch (broadcast) {
            case 0: {
                Array r = Array.factory(DataType.DOUBLE, a.getShape());
                int i = 0;
                while ((long)i < a.getSize()) {
                    if (Double.isNaN(a.getDouble(i)) || Double.isNaN(b.getDouble(i))) {
                        r.setDouble(i, Double.NaN);
                    } else {
                        r.setDouble(i, a.getDouble(i) * b.getDouble(i));
                    }
                    ++i;
                }
                return r;
            }
            case 1: {
                int[] shape = ArrayMath.broadcast(a, b);
                Array r = Array.factory(DataType.DOUBLE, shape);
                Index index = r.getIndex();
                Index aindex = a.getIndex();
                Index bindex = b.getIndex();
                int n = r.getRank();
                int na = a.getRank();
                int nb = b.getRank();
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] current = index.getCurrentCounter();
                    ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                    if (Double.isNaN(a.getDouble(aindex)) || Double.isNaN(b.getDouble(bindex))) {
                        r.setDouble(i, Double.NaN);
                    } else {
                        r.setDouble(i, a.getDouble(aindex) * b.getDouble(bindex));
                    }
                    index.incr();
                    ++i;
                }
                return r;
            }
        }
        return null;
    }

    private static Array mulDouble(Array a, double b) {
        Array r = Array.factory(DataType.DOUBLE, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (Double.isNaN(a.getDouble(i))) {
                r.setDouble(i, Double.NaN);
            } else {
                r.setDouble(i, a.getDouble(i) * b);
            }
            ++i;
        }
        return r;
    }

    private static Array mulComplex(Array a, Array b) {
        int broadcast = ArrayMath.broadcastCheck(a, b);
        switch (broadcast) {
            case 0: {
                Array r = Array.factory(DataType.OBJECT, a.getShape());
                if (ArrayMath.isComplex(a)) {
                    if (ArrayMath.isComplex(b)) {
                        int i = 0;
                        while ((long)i < a.getSize()) {
                            Complex v1 = (Complex)((Object)a.getObject(i));
                            Complex v2 = (Complex)((Object)b.getObject(i));
                            if (v1.isNaN() || v2.isNaN()) {
                                r.setObject(i, (Object)v1);
                            } else {
                                r.setObject(i, (Object)v1.multiply(v2));
                            }
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < a.getSize()) {
                            Complex v = (Complex)((Object)a.getObject(i));
                            if (v.isNaN() || Double.isNaN(b.getDouble(i))) {
                                r.setObject(i, (Object)new Complex(Double.NaN));
                            } else {
                                r.setObject(i, (Object)v.multiply(b.getDouble(i)));
                            }
                            ++i;
                        }
                    }
                } else {
                    int i = 0;
                    while ((long)i < a.getSize()) {
                        Complex v = (Complex)((Object)b.getObject(i));
                        if (v.isNaN() || Double.isNaN(a.getDouble(i))) {
                            r.setObject(i, (Object)new Complex(Double.NaN));
                        } else {
                            r.setObject(i, (Object)v.multiply(a.getDouble(i)));
                        }
                        ++i;
                    }
                }
                return r;
            }
            case 1: {
                int[] shape = ArrayMath.broadcast(a, b);
                Array r = Array.factory(DataType.OBJECT, shape);
                Index index = r.getIndex();
                Index aindex = a.getIndex();
                Index bindex = b.getIndex();
                int n = r.getRank();
                int na = a.getRank();
                int nb = b.getRank();
                if (ArrayMath.isComplex(a)) {
                    if (ArrayMath.isComplex(b)) {
                        int i = 0;
                        while ((long)i < r.getSize()) {
                            int[] current = index.getCurrentCounter();
                            ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                            Complex v1 = (Complex)((Object)a.getObject(aindex));
                            Complex v2 = (Complex)((Object)b.getObject(bindex));
                            if (v1.isNaN() || v2.isNaN()) {
                                r.setObject(i, (Object)v1);
                            } else {
                                r.setObject(i, (Object)v1.multiply(v2));
                            }
                            index.incr();
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < r.getSize()) {
                            int[] current = index.getCurrentCounter();
                            ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                            Complex v = (Complex)((Object)a.getObject(aindex));
                            if (v.isNaN() || Double.isNaN(b.getDouble(bindex))) {
                                r.setObject(i, (Object)new Complex(Double.NaN));
                            } else {
                                r.setObject(i, (Object)v.multiply(b.getDouble(bindex)));
                            }
                            index.incr();
                            ++i;
                        }
                    }
                } else {
                    int i = 0;
                    while ((long)i < a.getSize()) {
                        int[] current = index.getCurrentCounter();
                        ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                        Complex v = (Complex)((Object)b.getObject(bindex));
                        if (v.isNaN() || Double.isNaN(a.getDouble(aindex))) {
                            r.setObject(i, (Object)new Complex(Double.NaN));
                        } else {
                            r.setObject(i, (Object)v.multiply(a.getDouble(aindex)));
                        }
                        ++i;
                    }
                }
                return r;
            }
        }
        return null;
    }

    private static Array mulComplex(Array a, double b) {
        Array r = Array.factory(DataType.OBJECT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            Complex v = (Complex)((Object)a.getObject(i));
            if (v.isNaN()) {
                r.setObject(i, (Object)v);
            } else {
                r.setObject(i, (Object)v.multiply(b));
            }
            ++i;
        }
        return r;
    }

    private static Array mulComplex(Array a, Complex b) {
        Array r = Array.factory(DataType.OBJECT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            Complex v = (Complex)((Object)a.getObject(i));
            if (v.isNaN()) {
                r.setObject(i, (Object)v);
            } else {
                r.setObject(i, (Object)v.multiply(b));
            }
            ++i;
        }
        return r;
    }

    public static Array div(Array a, Array b) {
        DataType type = ArrayMath.commonType(a.getDataType(), b.getDataType());
        switch (type) {
            case INT: 
            case SHORT: 
            case BOOLEAN: {
                return ArrayMath.divInt(a, b);
            }
            case FLOAT: {
                return ArrayMath.divFloat(a, b);
            }
            case DOUBLE: {
                return ArrayMath.divDouble(a, b);
            }
            case OBJECT: {
                if (!ArrayMath.isComplex(a) && !ArrayMath.isComplex(b)) break;
                return ArrayMath.divComplex(a, b);
            }
        }
        return null;
    }

    public static Array div(Array a, Number b) {
        DataType bType = ArrayMath.getDataType(b);
        DataType type = ArrayMath.commonType(a.getDataType(), bType);
        switch (type) {
            case INT: 
            case SHORT: 
            case BOOLEAN: {
                return ArrayMath.divInt(a, b.intValue());
            }
            case FLOAT: {
                return ArrayMath.divFloat(a, b.floatValue());
            }
            case DOUBLE: {
                return ArrayMath.divDouble(a, b.doubleValue());
            }
            case OBJECT: {
                if (!ArrayMath.isComplex(a)) break;
                return ArrayMath.divComplex(a, b.doubleValue());
            }
        }
        return null;
    }

    public static Array div(Array a, Complex b) {
        return ArrayMath.divComplex(a, b);
    }

    public static Array div(Array a, PyComplex b) {
        return ArrayMath.divComplex(a, new Complex(b.real, b.imag));
    }

    public static Array div(Number b, Array a) {
        DataType bType = ArrayMath.getDataType(b);
        DataType type = ArrayMath.commonType(a.getDataType(), bType);
        switch (type) {
            case INT: 
            case SHORT: 
            case BOOLEAN: {
                return ArrayMath.divInt(b.intValue(), a);
            }
            case FLOAT: {
                return ArrayMath.divFloat(b.floatValue(), a);
            }
            case DOUBLE: {
                return ArrayMath.divDouble(b.doubleValue(), a);
            }
            case OBJECT: {
                if (!ArrayMath.isComplex(a)) break;
                return ArrayMath.divComplex(b.doubleValue(), a);
            }
        }
        return null;
    }

    public static Array div(Complex b, Array a) {
        return ArrayMath.divComplex(b, a);
    }

    public static Array div(PyComplex b, Array a) {
        return ArrayMath.divComplex(new Complex(b.real, b.imag), a);
    }

    private static Array divInt(Array a, Array b) {
        int broadcast = ArrayMath.broadcastCheck(a, b);
        switch (broadcast) {
            case 0: {
                Array r = Array.factory(DataType.INT, a.getShape());
                int i = 0;
                while ((long)i < a.getSize()) {
                    if (a.getInt(i) == Integer.MIN_VALUE || b.getInt(i) == Integer.MIN_VALUE) {
                        r.setInt(i, Integer.MIN_VALUE);
                    } else {
                        r.setInt(i, a.getInt(i) / b.getInt(i));
                    }
                    ++i;
                }
                return r;
            }
            case 1: {
                int[] shape = ArrayMath.broadcast(a, b);
                Array r = Array.factory(DataType.INT, shape);
                Index index = r.getIndex();
                Index aindex = a.getIndex();
                Index bindex = b.getIndex();
                int n = r.getRank();
                int na = a.getRank();
                int nb = b.getRank();
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] current = index.getCurrentCounter();
                    ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                    if (a.getInt(aindex) == Integer.MIN_VALUE || b.getInt(bindex) == Integer.MIN_VALUE) {
                        r.setInt(i, Integer.MIN_VALUE);
                    } else {
                        r.setInt(i, a.getInt(aindex) / b.getInt(bindex));
                    }
                    index.incr();
                    ++i;
                }
                return r;
            }
        }
        return null;
    }

    private static Array divInt(Array a, int b) {
        Array r = Array.factory(DataType.INT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setInt(i, a.getInt(i) / b);
            ++i;
        }
        return r;
    }

    private static Array divInt(int b, Array a) {
        Array r = Array.factory(DataType.INT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setInt(i, b / a.getInt(i));
            ++i;
        }
        return r;
    }

    private static Array divFloat(Array a, Array b) {
        int broadcast = ArrayMath.broadcastCheck(a, b);
        switch (broadcast) {
            case 0: {
                Array r = Array.factory(DataType.FLOAT, a.getShape());
                int i = 0;
                while ((long)i < a.getSize()) {
                    if (Float.isNaN(a.getFloat(i)) || Float.isNaN(b.getFloat(i))) {
                        r.setFloat(i, Float.NaN);
                    } else {
                        r.setFloat(i, a.getFloat(i) / b.getFloat(i));
                    }
                    ++i;
                }
                return r;
            }
            case 1: {
                int[] shape = ArrayMath.broadcast(a, b);
                Array r = Array.factory(DataType.FLOAT, shape);
                Index index = r.getIndex();
                Index aindex = a.getIndex();
                Index bindex = b.getIndex();
                int n = r.getRank();
                int na = a.getRank();
                int nb = b.getRank();
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] current = index.getCurrentCounter();
                    ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                    if (Float.isNaN(a.getFloat(aindex)) || Float.isNaN(b.getFloat(bindex))) {
                        r.setFloat(i, Float.NaN);
                    } else {
                        r.setFloat(i, a.getFloat(aindex) / b.getFloat(bindex));
                    }
                    index.incr();
                    ++i;
                }
                return r;
            }
        }
        return null;
    }

    private static Array divFloat(Array a, float b) {
        Array r = Array.factory(DataType.FLOAT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setFloat(i, a.getFloat(i) / b);
            ++i;
        }
        return r;
    }

    private static Array divFloat(float b, Array a) {
        Array r = Array.factory(DataType.FLOAT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setFloat(i, b / a.getFloat(i));
            ++i;
        }
        return r;
    }

    private static Array divDouble(Array a, Array b) {
        int broadcast = ArrayMath.broadcastCheck(a, b);
        switch (broadcast) {
            case 0: {
                Array r = Array.factory(DataType.DOUBLE, a.getShape());
                int i = 0;
                while ((long)i < a.getSize()) {
                    if (Double.isNaN(a.getDouble(i)) || Double.isNaN(b.getDouble(i))) {
                        r.setDouble(i, Double.NaN);
                    } else {
                        r.setDouble(i, a.getDouble(i) / b.getDouble(i));
                    }
                    ++i;
                }
                return r;
            }
            case 1: {
                int[] shape = ArrayMath.broadcast(a, b);
                Array r = Array.factory(DataType.DOUBLE, shape);
                Index index = r.getIndex();
                Index aindex = a.getIndex();
                Index bindex = b.getIndex();
                int n = r.getRank();
                int na = a.getRank();
                int nb = b.getRank();
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] current = index.getCurrentCounter();
                    ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                    if (Double.isNaN(a.getDouble(aindex)) || Double.isNaN(b.getDouble(bindex))) {
                        r.setDouble(i, Double.NaN);
                    } else {
                        r.setDouble(i, a.getDouble(aindex) / b.getDouble(bindex));
                    }
                    index.incr();
                    ++i;
                }
                return r;
            }
        }
        return null;
    }

    private static Array divDouble(Array a, double b) {
        Array r = Array.factory(DataType.DOUBLE, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setDouble(i, a.getDouble(i) / b);
            ++i;
        }
        return r;
    }

    private static Array divDouble(double b, Array a) {
        Array r = Array.factory(DataType.DOUBLE, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setDouble(i, b / a.getDouble(i));
            ++i;
        }
        return r;
    }

    private static Array divComplex(Array a, Array b) {
        int broadcast = ArrayMath.broadcastCheck(a, b);
        switch (broadcast) {
            case 0: {
                Array r = Array.factory(DataType.OBJECT, a.getShape());
                if (ArrayMath.isComplex(a)) {
                    if (ArrayMath.isComplex(b)) {
                        int i = 0;
                        while ((long)i < a.getSize()) {
                            Complex v1 = (Complex)((Object)a.getObject(i));
                            Complex v2 = (Complex)((Object)b.getObject(i));
                            if (v1.isNaN() || v2.isNaN()) {
                                r.setObject(i, (Object)v1);
                            } else {
                                r.setObject(i, (Object)v1.divide(v2));
                            }
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < a.getSize()) {
                            Complex v = (Complex)((Object)a.getObject(i));
                            if (v.isNaN() || Double.isNaN(b.getDouble(i))) {
                                r.setObject(i, (Object)new Complex(Double.NaN));
                            } else {
                                r.setObject(i, (Object)v.divide(b.getDouble(i)));
                            }
                            ++i;
                        }
                    }
                } else {
                    int i = 0;
                    while ((long)i < a.getSize()) {
                        Complex v = (Complex)((Object)b.getObject(i));
                        if (v.isNaN() || Double.isNaN(a.getDouble(i))) {
                            r.setObject(i, (Object)new Complex(Double.NaN));
                        } else {
                            r.setObject(i, (Object)v.divide(a.getDouble(i)));
                        }
                        ++i;
                    }
                }
                return r;
            }
            case 1: {
                int[] shape = ArrayMath.broadcast(a, b);
                Array r = Array.factory(DataType.OBJECT, shape);
                Index index = r.getIndex();
                Index aindex = a.getIndex();
                Index bindex = b.getIndex();
                int n = r.getRank();
                int na = a.getRank();
                int nb = b.getRank();
                if (ArrayMath.isComplex(a)) {
                    if (ArrayMath.isComplex(b)) {
                        int i = 0;
                        while ((long)i < r.getSize()) {
                            int[] current = index.getCurrentCounter();
                            ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                            Complex v1 = (Complex)((Object)a.getObject(aindex));
                            Complex v2 = (Complex)((Object)b.getObject(bindex));
                            if (v1.isNaN() || v2.isNaN()) {
                                r.setObject(i, (Object)v1);
                            } else {
                                r.setObject(i, (Object)v1.divide(v2));
                            }
                            index.incr();
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < r.getSize()) {
                            int[] current = index.getCurrentCounter();
                            ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                            Complex v = (Complex)((Object)a.getObject(aindex));
                            if (v.isNaN() || Double.isNaN(b.getDouble(bindex))) {
                                r.setObject(i, (Object)new Complex(Double.NaN));
                            } else {
                                r.setObject(i, (Object)v.divide(b.getDouble(bindex)));
                            }
                            index.incr();
                            ++i;
                        }
                    }
                } else {
                    int i = 0;
                    while ((long)i < a.getSize()) {
                        int[] current = index.getCurrentCounter();
                        ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                        Complex v = (Complex)((Object)b.getObject(bindex));
                        if (v.isNaN() || Double.isNaN(a.getDouble(aindex))) {
                            r.setObject(i, (Object)new Complex(Double.NaN));
                        } else {
                            r.setObject(i, (Object)v.divide(a.getDouble(aindex)));
                        }
                        ++i;
                    }
                }
                return r;
            }
        }
        return null;
    }

    private static Array divComplex(Array a, double b) {
        Array r = Array.factory(DataType.OBJECT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            Complex v = (Complex)((Object)a.getObject(i));
            if (v.isNaN()) {
                r.setObject(i, (Object)v);
            } else {
                r.setObject(i, (Object)v.divide(b));
            }
            ++i;
        }
        return r;
    }

    private static Array divComplex(Array a, Complex b) {
        Array r = Array.factory(DataType.OBJECT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            Complex v = (Complex)((Object)a.getObject(i));
            if (v.isNaN()) {
                r.setObject(i, (Object)v);
            } else {
                r.setObject(i, (Object)v.divide(b));
            }
            ++i;
        }
        return r;
    }

    private static Array divComplex(double b, Array a) {
        Array r = Array.factory(DataType.OBJECT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            Complex v = (Complex)((Object)a.getObject(i));
            if (v.isNaN()) {
                r.setObject(i, (Object)v);
            } else {
                r.setObject(i, (Object)v.rDivide(b));
            }
            ++i;
        }
        return r;
    }

    private static Array divComplex(Complex b, Array a) {
        Array r = Array.factory(DataType.OBJECT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            Complex v = (Complex)((Object)a.getObject(i));
            if (v.isNaN()) {
                r.setObject(i, (Object)v);
            } else {
                r.setObject(i, (Object)b.divide(v));
            }
            ++i;
        }
        return r;
    }

    public static Array pow(Array a, Number b) {
        DataType bType = ArrayMath.getDataType(b);
        DataType type = ArrayMath.commonType(a.getDataType(), bType);
        switch (type) {
            case INT: 
            case SHORT: 
            case BOOLEAN: {
                return ArrayMath.powInt(a, b.intValue());
            }
            case FLOAT: 
            case DOUBLE: {
                return ArrayMath.powDouble(a, b.doubleValue());
            }
            case OBJECT: {
                if (!ArrayMath.isComplex(a)) break;
                return ArrayMath.powComplex(a, b.doubleValue());
            }
        }
        return null;
    }

    public static Array pow(Array a, Complex b) {
        return ArrayMath.powComplex(a, b);
    }

    public static Array pow(Array a, PyComplex b) {
        return ArrayMath.powComplex(a, new Complex(b.real, b.imag));
    }

    public static Array pow(Number a, Array b) {
        DataType bType = ArrayMath.getDataType(a);
        DataType type = ArrayMath.commonType(b.getDataType(), bType);
        switch (type) {
            case INT: 
            case SHORT: 
            case BOOLEAN: {
                return ArrayMath.powInt(a.intValue(), b);
            }
            case FLOAT: 
            case DOUBLE: {
                return ArrayMath.powDouble(a.doubleValue(), b);
            }
            case OBJECT: {
                if (!ArrayMath.isComplex(b)) break;
                return ArrayMath.powComplex(a.doubleValue(), b);
            }
        }
        return null;
    }

    public static Array pow(Complex b, Array a) {
        return ArrayMath.powComplex(b, a);
    }

    public static Array pow(PyComplex b, Array a) {
        return ArrayMath.powComplex(new Complex(b.real, b.imag), a);
    }

    public static Array pow(Array a, Array b) {
        DataType type = ArrayMath.commonType(a.getDataType(), b.getDataType());
        switch (type) {
            case INT: 
            case SHORT: {
                return ArrayMath.powInt(a, b);
            }
            case FLOAT: 
            case DOUBLE: {
                return ArrayMath.powDouble(a, b);
            }
            case OBJECT: {
                if (!ArrayMath.isComplex(a) && !ArrayMath.isComplex(b)) break;
                return ArrayMath.powComplex(a, b);
            }
        }
        return null;
    }

    private static Array powInt(Array a, int b) {
        Array r = Array.factory(DataType.INT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setInt(i, (int)Math.pow(a.getInt(i), b));
            ++i;
        }
        return r;
    }

    private static Array powInt(int a, Array b) {
        Array r = Array.factory(DataType.INT, b.getShape());
        int i = 0;
        while ((long)i < b.getSize()) {
            r.setInt(i, (int)Math.pow(a, b.getInt(i)));
            ++i;
        }
        return r;
    }

    private static Array powInt(Array a, Array b) {
        int broadcast = ArrayMath.broadcastCheck(a, b);
        switch (broadcast) {
            case 0: {
                Array r = Array.factory(DataType.INT, a.getShape());
                int i = 0;
                while ((long)i < a.getSize()) {
                    r.setInt(i, (int)Math.pow(a.getInt(i), b.getInt(i)));
                    ++i;
                }
                return r;
            }
            case 1: {
                int[] shape = ArrayMath.broadcast(a, b);
                Array r = Array.factory(DataType.INT, shape);
                Index index = r.getIndex();
                Index aindex = a.getIndex();
                Index bindex = b.getIndex();
                int n = r.getRank();
                int na = a.getRank();
                int nb = b.getRank();
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] current = index.getCurrentCounter();
                    ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                    r.setInt(i, (int)Math.pow(a.getInt(aindex), b.getInt(bindex)));
                    index.incr();
                    ++i;
                }
                return r;
            }
        }
        return null;
    }

    private static Array powDouble(Array a, double b) {
        Array r = Array.factory(DataType.DOUBLE, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setDouble(i, Math.pow(a.getDouble(i), b));
            ++i;
        }
        return r;
    }

    private static Array powDouble(double a, Array b) {
        Array r = Array.factory(DataType.DOUBLE, b.getShape());
        int i = 0;
        while ((long)i < b.getSize()) {
            r.setDouble(i, Math.pow(a, b.getDouble(i)));
            ++i;
        }
        return r;
    }

    private static Array powDouble(Array a, Array b) {
        int broadcast = ArrayMath.broadcastCheck(a, b);
        switch (broadcast) {
            case 0: {
                Array r = Array.factory(DataType.DOUBLE, a.getShape());
                int i = 0;
                while ((long)i < a.getSize()) {
                    if (Double.isNaN(a.getDouble(i)) || Double.isNaN(b.getDouble(i))) {
                        r.setDouble(i, Double.NaN);
                    } else {
                        r.setDouble(i, Math.pow(a.getDouble(i), b.getDouble(i)));
                    }
                    ++i;
                }
                return r;
            }
            case 1: {
                int[] shape = ArrayMath.broadcast(a, b);
                Array r = Array.factory(DataType.DOUBLE, shape);
                Index index = r.getIndex();
                Index aindex = a.getIndex();
                Index bindex = b.getIndex();
                int n = r.getRank();
                int na = a.getRank();
                int nb = b.getRank();
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] current = index.getCurrentCounter();
                    ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                    if (Double.isNaN(a.getDouble(aindex)) || Double.isNaN(b.getDouble(bindex))) {
                        r.setDouble(i, Double.NaN);
                    } else {
                        r.setDouble(i, Math.pow(a.getDouble(aindex), b.getDouble(bindex)));
                    }
                    index.incr();
                    ++i;
                }
                return r;
            }
        }
        return null;
    }

    private static Array powComplex(Array a, Array b) {
        int broadcast = ArrayMath.broadcastCheck(a, b);
        switch (broadcast) {
            case 0: {
                Array r = Array.factory(DataType.OBJECT, a.getShape());
                if (ArrayMath.isComplex(a)) {
                    if (ArrayMath.isComplex(b)) {
                        int i = 0;
                        while ((long)i < a.getSize()) {
                            Complex v1 = (Complex)((Object)a.getObject(i));
                            Complex v2 = (Complex)((Object)b.getObject(i));
                            if (v1.isNaN() || v2.isNaN()) {
                                r.setObject(i, (Object)v1);
                            } else {
                                r.setObject(i, (Object)v1.pow(v2));
                            }
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < a.getSize()) {
                            Complex v = (Complex)((Object)a.getObject(i));
                            if (v.isNaN() || Double.isNaN(b.getDouble(i))) {
                                r.setObject(i, (Object)new Complex(Double.NaN));
                            } else {
                                r.setObject(i, (Object)v.pow(b.getDouble(i)));
                            }
                            ++i;
                        }
                    }
                } else {
                    int i = 0;
                    while ((long)i < a.getSize()) {
                        Complex v = (Complex)((Object)b.getObject(i));
                        if (v.isNaN() || Double.isNaN(a.getDouble(i))) {
                            r.setObject(i, (Object)new Complex(Double.NaN));
                        } else {
                            r.setObject(i, (Object)v.pow(a.getDouble(i)));
                        }
                        ++i;
                    }
                }
                return r;
            }
            case 1: {
                int[] shape = ArrayMath.broadcast(a, b);
                Array r = Array.factory(DataType.OBJECT, shape);
                Index index = r.getIndex();
                Index aindex = a.getIndex();
                Index bindex = b.getIndex();
                int n = r.getRank();
                int na = a.getRank();
                int nb = b.getRank();
                if (ArrayMath.isComplex(a)) {
                    if (ArrayMath.isComplex(b)) {
                        int i = 0;
                        while ((long)i < r.getSize()) {
                            int[] current = index.getCurrentCounter();
                            ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                            Complex v1 = (Complex)((Object)a.getObject(aindex));
                            Complex v2 = (Complex)((Object)b.getObject(bindex));
                            if (v1.isNaN() || v2.isNaN()) {
                                r.setObject(i, (Object)v1);
                            } else {
                                r.setObject(i, (Object)v1.pow(v2));
                            }
                            index.incr();
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < r.getSize()) {
                            int[] current = index.getCurrentCounter();
                            ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                            Complex v = (Complex)((Object)a.getObject(aindex));
                            if (v.isNaN() || Double.isNaN(b.getDouble(bindex))) {
                                r.setObject(i, (Object)new Complex(Double.NaN));
                            } else {
                                r.setObject(i, (Object)v.pow(b.getDouble(bindex)));
                            }
                            index.incr();
                            ++i;
                        }
                    }
                } else {
                    int i = 0;
                    while ((long)i < a.getSize()) {
                        int[] current = index.getCurrentCounter();
                        ArrayMath.setIndex(aindex, bindex, current, n, na, nb);
                        Complex v = (Complex)((Object)b.getObject(bindex));
                        if (v.isNaN() || Double.isNaN(a.getDouble(aindex))) {
                            r.setObject(i, (Object)new Complex(Double.NaN));
                        } else {
                            r.setObject(i, (Object)v.pow(a.getDouble(aindex)));
                        }
                        ++i;
                    }
                }
                return r;
            }
        }
        return null;
    }

    private static Array powComplex(Array a, double b) {
        Array r = Array.factory(DataType.OBJECT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            Complex v = (Complex)((Object)a.getObject(i));
            if (v.isNaN()) {
                r.setObject(i, (Object)v);
            } else {
                r.setObject(i, (Object)v.pow(b));
            }
            ++i;
        }
        return r;
    }

    private static Array powComplex(Array a, Complex b) {
        Array r = Array.factory(DataType.OBJECT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            Complex v = (Complex)((Object)a.getObject(i));
            if (v.isNaN()) {
                r.setObject(i, (Object)v);
            } else {
                r.setObject(i, (Object)v.pow(b));
            }
            ++i;
        }
        return r;
    }

    private static Array powComplex(double b, Array a) {
        Array r = Array.factory(DataType.OBJECT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            Complex v = (Complex)((Object)a.getObject(i));
            if (v.isNaN()) {
                r.setObject(i, (Object)v);
            } else {
                r.setObject(i, (Object)v.rPow(b));
            }
            ++i;
        }
        return r;
    }

    private static Array powComplex(Complex b, Array a) {
        Array r = Array.factory(DataType.OBJECT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            Complex v = (Complex)((Object)a.getObject(i));
            if (v.isNaN()) {
                r.setObject(i, (Object)v);
            } else {
                r.setObject(i, (Object)b.pow(v));
            }
            ++i;
        }
        return r;
    }

    public static Array sqrt(Array a) {
        return ArrayMath.pow(a, 0.5);
    }

    public static Array exp(Array a) {
        Array r;
        if (ArrayMath.isComplex(a)) {
            r = Array.factory(DataType.OBJECT, a.getShape());
            int i = 0;
            while ((long)i < a.getSize()) {
                r.setObject(i, (Object)((Complex)((Object)a.getObject(i))).exp());
                ++i;
            }
        } else {
            r = Array.factory(DataType.DOUBLE, a.getShape());
            int i = 0;
            while ((long)i < a.getSize()) {
                r.setDouble(i, Math.exp(a.getDouble(i)));
                ++i;
            }
        }
        return r;
    }

    public static Array log(Array a) {
        Array r;
        if (ArrayMath.isComplex(a)) {
            r = Array.factory(DataType.OBJECT, a.getShape());
            int i = 0;
            while ((long)i < a.getSize()) {
                r.setObject(i, (Object)((Complex)((Object)a.getObject(i))).log());
                ++i;
            }
        } else {
            r = Array.factory(DataType.DOUBLE, a.getShape());
            int i = 0;
            while ((long)i < a.getSize()) {
                r.setDouble(i, Math.log(a.getDouble(i)));
                ++i;
            }
        }
        return r;
    }

    public static Array log10(Array a) {
        Array r = Array.factory(DataType.DOUBLE, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setDouble(i, Math.log10(a.getDouble(i)));
            ++i;
        }
        return r;
    }

    public static Array abs(Array a) {
        Array r;
        if (ArrayMath.isComplex(a)) {
            r = Array.factory(DataType.DOUBLE, a.getShape());
            int i = 0;
            while ((long)i < a.getSize()) {
                r.setDouble(i, ((Complex)((Object)a.getObject(i))).abs());
                ++i;
            }
        } else {
            r = Array.factory(a.getDataType(), a.getShape());
            int i = 0;
            while ((long)i < a.getSize()) {
                r.setDouble(i, Math.abs(a.getDouble(i)));
                ++i;
            }
        }
        return r;
    }

    public static Array equal(Array a, Array b) {
        Array r = Array.factory(DataType.BOOLEAN, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (a.getDouble(i) == b.getDouble(i)) {
                r.setBoolean(i, true);
            } else {
                r.setBoolean(i, false);
            }
            ++i;
        }
        return r;
    }

    public static Array equal(Array a, Number b) {
        Array r = Array.factory(DataType.BOOLEAN, a.getShape());
        double v = b.doubleValue();
        if (Double.isNaN(v)) {
            int i = 0;
            while ((long)i < a.getSize()) {
                if (Double.isNaN(a.getDouble(i))) {
                    r.setBoolean(i, true);
                } else {
                    r.setBoolean(i, false);
                }
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < a.getSize()) {
                if (a.getDouble(i) == v) {
                    r.setBoolean(i, true);
                } else {
                    r.setBoolean(i, false);
                }
                ++i;
            }
        }
        return r;
    }

    public static Array equal(Array a, String b) {
        Array r = Array.factory(DataType.BOOLEAN, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (a.getObject(i).equals(b)) {
                r.setBoolean(i, true);
            } else {
                r.setBoolean(i, false);
            }
            ++i;
        }
        return r;
    }

    public static Array lessThan(Array a, Array b) {
        Array r = Array.factory(DataType.BOOLEAN, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (a.getDouble(i) < b.getDouble(i)) {
                r.setBoolean(i, true);
            } else {
                r.setBoolean(i, false);
            }
            ++i;
        }
        return r;
    }

    public static Array lessThan(Array a, Number b) {
        Array r = Array.factory(DataType.BOOLEAN, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (a.getDouble(i) < b.doubleValue()) {
                r.setBoolean(i, true);
            } else {
                r.setBoolean(i, false);
            }
            ++i;
        }
        return r;
    }

    public static Array lessThanOrEqual(Array a, Array b) {
        Array r = Array.factory(DataType.BOOLEAN, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (a.getDouble(i) <= b.getDouble(i)) {
                r.setBoolean(i, true);
            } else {
                r.setBoolean(i, false);
            }
            ++i;
        }
        return r;
    }

    public static Array lessThanOrEqual(Array a, Number b) {
        Array r = Array.factory(DataType.BOOLEAN, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (a.getDouble(i) <= b.doubleValue()) {
                r.setBoolean(i, true);
            } else {
                r.setBoolean(i, false);
            }
            ++i;
        }
        return r;
    }

    public static Array greaterThan(Array a, Array b) {
        Array r = Array.factory(DataType.BOOLEAN, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (a.getDouble(i) > b.getDouble(i)) {
                r.setBoolean(i, true);
            } else {
                r.setBoolean(i, false);
            }
            ++i;
        }
        return r;
    }

    public static Array greaterThan(Array a, Number b) {
        Array r = Array.factory(DataType.BOOLEAN, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (a.getDouble(i) > b.doubleValue()) {
                r.setBoolean(i, true);
            } else {
                r.setBoolean(i, false);
            }
            ++i;
        }
        return r;
    }

    public static Array greaterThanOrEqual(Array a, Array b) {
        Array r = Array.factory(DataType.BOOLEAN, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (a.getDouble(i) >= b.getDouble(i)) {
                r.setBoolean(i, true);
            } else {
                r.setBoolean(i, false);
            }
            ++i;
        }
        return r;
    }

    public static Array greaterThanOrEqual(Array a, Number b) {
        Array r = Array.factory(DataType.BOOLEAN, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (a.getDouble(i) >= b.doubleValue()) {
                r.setBoolean(i, true);
            } else {
                r.setBoolean(i, false);
            }
            ++i;
        }
        return r;
    }

    public static Array notEqual(Array a, Array b) {
        Array r = Array.factory(DataType.BOOLEAN, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (a.getDouble(i) != b.getDouble(i)) {
                r.setBoolean(i, true);
            } else {
                r.setBoolean(i, false);
            }
            ++i;
        }
        return r;
    }

    public static Array notEqual(Array a, Number b) {
        Array r = Array.factory(DataType.BOOLEAN, a.getShape());
        double v = b.doubleValue();
        if (Double.isNaN(v)) {
            int i = 0;
            while ((long)i < a.getSize()) {
                if (Double.isNaN(a.getDouble(i))) {
                    r.setBoolean(i, false);
                } else {
                    r.setBoolean(i, true);
                }
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < a.getSize()) {
                if (a.getDouble(i) != v) {
                    r.setBoolean(i, true);
                } else {
                    r.setBoolean(i, false);
                }
                ++i;
            }
        }
        return r;
    }

    public static boolean any(Array a) {
        IndexIterator ii = a.getIndexIterator();
        while (ii.hasNext()) {
            if (!ii.getBooleanNext()) continue;
            return true;
        }
        return false;
    }

    public static Array any(Array a, int axis) throws InvalidRangeException {
        int idx;
        int[] dataShape = a.getShape();
        int[] shape = new int[dataShape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            idx = i;
            if (idx == axis) continue;
            if (idx > axis) {
                --idx;
            }
            shape[idx] = dataShape[i];
        }
        Array r = Array.factory(DataType.BOOLEAN, shape);
        Index indexr = r.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(current[idx], current[idx], 1));
            }
            IndexIterator ii = a.getRangeIterator(ranges);
            boolean b = false;
            while (ii.hasNext()) {
                if (!ii.getBooleanNext()) continue;
                b = true;
                break;
            }
            r.setBoolean(i, b);
            indexr.incr();
            ++i;
        }
        return r;
    }

    public static boolean all(Array a) {
        IndexIterator ii = a.getIndexIterator();
        while (ii.hasNext()) {
            if (ii.getBooleanNext()) continue;
            return false;
        }
        return true;
    }

    public static Array all(Array a, int axis) throws InvalidRangeException {
        int idx;
        int[] dataShape = a.getShape();
        int[] shape = new int[dataShape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            idx = i;
            if (idx == axis) continue;
            if (idx > axis) {
                --idx;
            }
            shape[idx] = dataShape[i];
        }
        Array r = Array.factory(DataType.BOOLEAN, shape);
        Index indexr = r.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(current[idx], current[idx], 1));
            }
            IndexIterator ii = a.getRangeIterator(ranges);
            boolean b = true;
            while (ii.hasNext()) {
                if (ii.getBooleanNext()) continue;
                b = false;
                break;
            }
            r.setBoolean(i, b);
            indexr.incr();
            ++i;
        }
        return r;
    }

    public static Array inValues(Array a, List b) {
        Array r = Array.factory(DataType.BOOLEAN, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (b.contains(a.getObject(i))) {
                r.setBoolean(i, true);
            } else {
                r.setBoolean(i, false);
            }
            ++i;
        }
        return r;
    }

    public static boolean containsNaN(Array a) {
        boolean hasNaN = false;
        int i = 0;
        while ((long)i < a.getSize()) {
            if (Double.isNaN(a.getDouble(i))) {
                hasNaN = true;
                break;
            }
            ++i;
        }
        return hasNaN;
    }

    public static Array removeNaN(Array a) {
        ArrayList<Object> d = new ArrayList<Object>();
        int i = 0;
        while ((long)i < a.getSize()) {
            if (!Double.isNaN(a.getDouble(i))) {
                d.add(a.getObject(i));
            }
            ++i;
        }
        if (d.isEmpty()) {
            return null;
        }
        Array r = Array.factory(a.getDataType(), new int[]{d.size()});
        for (int i2 = 0; i2 < d.size(); ++i2) {
            r.setObject(i2, d.get(i2));
        }
        return r;
    }

    public static Array[] removeNaN(Array ... a) {
        if (a.length == 1) {
            Array[] arrayArray;
            Array r0 = ArrayMath.removeNaN(a[0]);
            if (r0 == null) {
                arrayArray = null;
            } else {
                Array[] arrayArray2 = new Array[1];
                arrayArray = arrayArray2;
                arrayArray2[0] = ArrayMath.removeNaN(a[0]);
            }
            return arrayArray;
        }
        ArrayList<Object> d = new ArrayList<Object>();
        int n = (int)a[0].getSize();
        int m = a.length;
        for (int i = 0; i < n; ++i) {
            boolean isNan = false;
            for (Array aa : a) {
                if (!Double.isNaN(aa.getDouble(i))) continue;
                isNan = true;
                break;
            }
            if (isNan) continue;
            for (Array aa : a) {
                d.add(aa.getObject(i));
            }
        }
        if (d.isEmpty()) {
            return null;
        }
        int len = d.size() / m;
        Array[] r = new Array[m];
        for (int i = 0; i < m; ++i) {
            r[i] = Array.factory(a[i].getDataType(), new int[]{len});
            int jj = i;
            for (int j = 0; j < len; ++j) {
                r[i].setObject(j, d.get(jj));
                jj += m;
            }
        }
        return r;
    }

    public static List<Array> nonzero(Array a) {
        ArrayList r = new ArrayList();
        int ndim = a.getRank();
        for (int i = 0; i < ndim; ++i) {
            r.add(new ArrayList());
        }
        Index index = a.getIndex();
        int i = 0;
        while ((long)i < a.getSize()) {
            double v = a.getDouble(i);
            if (!Double.isNaN(v) && v != 0.0) {
                int[] counter = index.getCurrentCounter();
                for (int j = 0; j < ndim; ++j) {
                    ((List)r.get(j)).add(counter[j]);
                }
            }
            index.incr();
            ++i;
        }
        if (((List)r.get(0)).isEmpty()) {
            return null;
        }
        ArrayList<Array> ra = new ArrayList<Array>();
        for (int i2 = 0; i2 < ndim; ++i2) {
            ra.add(ArrayUtil.array(r.get(i2)));
        }
        return ra;
    }

    public static Array bitAnd(Array a, Number b) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setObject(i, (Object)(a.getInt(i) & b.intValue()));
            ++i;
        }
        return r;
    }

    public static Array bitAnd(Array a, Array b) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setObject(i, (Object)(a.getInt(i) & b.getInt(i)));
            ++i;
        }
        return r;
    }

    public static Array bitOr(Array a, Number b) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setObject(i, (Object)(a.getInt(i) | b.intValue()));
            ++i;
        }
        return r;
    }

    public static Array bitOr(Array a, Array b) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setObject(i, (Object)(a.getInt(i) | b.getInt(i)));
            ++i;
        }
        return r;
    }

    public static Array bitXor(Array a, Number b) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setObject(i, (Object)(a.getInt(i) ^ b.intValue()));
            ++i;
        }
        return r;
    }

    public static Array bitXor(Array a, Array b) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setObject(i, (Object)(a.getInt(i) ^ b.getInt(i)));
            ++i;
        }
        return r;
    }

    public static Array bitInvert(Array a) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        if (a.getDataType() == DataType.BOOLEAN) {
            int i = 0;
            while ((long)i < a.getSize()) {
                r.setObject(i, (Object)(!a.getBoolean(i) ? 1 : 0));
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < a.getSize()) {
                r.setObject(i, (Object)(~a.getInt(i)));
                ++i;
            }
        }
        return r;
    }

    public static Array leftShift(Array a, Number b) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setObject(i, (Object)(a.getInt(i) << b.intValue()));
            ++i;
        }
        return r;
    }

    public static Array leftShift(Array a, Array b) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setObject(i, (Object)(a.getInt(i) << b.getInt(i)));
            ++i;
        }
        return r;
    }

    public static Array rightShift(Array a, Number b) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setObject(i, (Object)(a.getInt(i) >> b.intValue()));
            ++i;
        }
        return r;
    }

    public static Array rightShift(Array a, Array b) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setObject(i, (Object)(a.getInt(i) >> b.getInt(i)));
            ++i;
        }
        return r;
    }

    public static double trapz(Array y, double dx) {
        int n = (int)y.getSize() - 1;
        double a = 1.0;
        double b = (double)n * dx + a;
        double r = 0.0;
        int nn = 0;
        int i = 0;
        while ((long)i < y.getSize()) {
            double v = y.getDouble(i);
            if (!Double.isNaN(v)) {
                r += y.getDouble(i);
                if (i > 0 && i < n) {
                    r += y.getDouble(i);
                }
                ++nn;
            }
            ++i;
        }
        r = nn >= 2 ? (r *= (b - a) / (double)(2 * n)) : Double.NaN;
        return r;
    }

    public static double trapz(Array y, double dx, List<Range> ranges) throws InvalidRangeException {
        int n = 1;
        for (Range range : ranges) {
            n *= range.length();
        }
        double a = 1.0;
        double b = (double)(--n) * dx + a;
        double r = 0.0;
        IndexIterator ii = y.getRangeIterator(ranges);
        int i = 0;
        while (ii.hasNext()) {
            double v = ii.getDoubleNext();
            if (Double.isNaN(v)) continue;
            r += v;
            if (i > 0 && i < n) {
                r += v;
            }
            ++i;
        }
        r = i >= 2 ? (r *= (b - a) / (double)(2 * n)) : Double.NaN;
        return r;
    }

    public static double trapz(Array y, Array x) {
        int n = (int)y.getSize() - 1;
        double r = 0.0;
        int nn = 0;
        for (int i = 0; i < n; ++i) {
            double v = y.getDouble(i);
            if (Double.isNaN(v)) continue;
            r += (x.getDouble(i + 1) - x.getDouble(i)) * (y.getDouble(i + 1) + v);
            ++nn;
        }
        r = nn >= 2 ? (r /= 2.0) : Double.NaN;
        return r;
    }

    public static double trapz(Array y, Array x, List<Range> ranges) throws InvalidRangeException {
        double r = 0.0;
        double v0 = Double.NEGATIVE_INFINITY;
        IndexIterator ii = y.getRangeIterator(ranges);
        int i = 0;
        int n = 0;
        while (ii.hasNext()) {
            double v = ii.getDoubleNext();
            if (Double.isNaN(v)) {
                ++i;
                continue;
            }
            if (Double.isInfinite(v0)) {
                v0 = v;
                continue;
            }
            r += (x.getDouble(i + 1) - x.getDouble(i)) * (v + v0);
            v0 = v;
            ++i;
            ++n;
        }
        r = n >= 2 ? (r /= 2.0) : Double.NaN;
        return r;
    }

    public static Array trapz(Array a, double dx, int axis) throws InvalidRangeException {
        int idx;
        int[] dataShape = a.getShape();
        int[] shape = new int[dataShape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            idx = i;
            if (idx == axis) continue;
            if (idx > axis) {
                --idx;
            }
            shape[idx] = dataShape[i];
        }
        Array r = Array.factory(DataType.DOUBLE, shape);
        Index indexr = r.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(current[idx], current[idx], 1));
            }
            double mean = ArrayMath.trapz(a, dx, ranges);
            r.setDouble(i, mean);
            indexr.incr();
            ++i;
        }
        return r;
    }

    public static Array trapz(Array a, Array x, int axis) throws InvalidRangeException {
        int idx;
        int[] dataShape = a.getShape();
        int[] shape = new int[dataShape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            idx = i;
            if (idx == axis) continue;
            if (idx > axis) {
                --idx;
            }
            shape[idx] = dataShape[i];
        }
        Array r = Array.factory(DataType.DOUBLE, shape);
        Index indexr = r.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(current[idx], current[idx], 1));
            }
            double mean = ArrayMath.trapz(a, x, ranges);
            r.setDouble(i, mean);
            indexr.incr();
            ++i;
        }
        return r;
    }

    public static Array sign(Array x) {
        Array r = Array.factory(DataType.FLOAT, x.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setFloat(i, Math.signum(x.getFloat(i)));
            ++i;
        }
        return r;
    }

    public static Array dot(Array a, Array b) {
        DataType type = ArrayMath.commonType(a.getDataType(), b.getDataType());
        if (a.getRank() == 2) {
            if (a.getShape()[1] != b.getShape()[0]) {
                return null;
            }
            int[] shape = b.getRank() == 2 ? new int[]{a.getShape()[0], b.getShape()[1]} : new int[]{a.getShape()[0]};
            Array r = Array.factory(type, shape);
            Index aIndex = a.getIndex();
            Index bIndex = b.getIndex();
            Index rIndex = r.getIndex();
            int n = a.getShape()[1];
            if (b.getRank() == 2) {
                for (int i = 0; i < shape[0]; ++i) {
                    for (int j = 0; j < shape[1]; ++j) {
                        double v = 0.0;
                        for (int m = 0; m < n; ++m) {
                            v += a.getDouble(aIndex.set(i, m)) * b.getDouble(bIndex.set(m, j));
                        }
                        r.setDouble(rIndex.set(i, j), v);
                    }
                }
            } else {
                for (int i = 0; i < shape[0]; ++i) {
                    double v = 0.0;
                    for (int m = 0; m < n; ++m) {
                        v += a.getDouble(aIndex.set(i, m)) * b.getDouble(bIndex.set(m));
                    }
                    r.setDouble(rIndex.set(i), v);
                }
            }
            return r;
        }
        if (a.getShape()[0] != b.getShape()[0]) {
            return null;
        }
        int[] shape = new int[]{b.getShape()[1]};
        Array r = Array.factory(type, shape);
        int n = a.getShape()[0];
        Index bIndex = b.getIndex();
        for (int i = 0; i < shape[0]; ++i) {
            double v = 0.0;
            for (int j = 0; j < n; ++j) {
                v += a.getDouble(j) * b.getDouble(bIndex.set(j, i));
            }
            r.setDouble(i, v);
        }
        return r;
    }

    public static double vdot(Array a, Array b) {
        double r = 0.0;
        int i = 0;
        while ((long)i < a.getSize()) {
            r += a.getDouble(i) * b.getDouble(i);
            ++i;
        }
        return r;
    }

    public static Array toDegrees(Array a) {
        Array r = Array.factory(a.getDataType() == DataType.DOUBLE ? DataType.DOUBLE : DataType.FLOAT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setDouble(i, Math.toDegrees(a.getDouble(i)));
            ++i;
        }
        return r;
    }

    public static Array toRadians(Array a) {
        Array r = Array.factory(a.getDataType() == DataType.DOUBLE ? DataType.DOUBLE : DataType.FLOAT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setDouble(i, Math.toRadians(a.getDouble(i)));
            ++i;
        }
        return r;
    }

    public static Array sin(Array a) {
        Array r;
        if (ArrayMath.isComplex(a)) {
            r = Array.factory(DataType.OBJECT, a.getShape());
            int i = 0;
            while ((long)i < a.getSize()) {
                r.setObject(i, (Object)((Complex)((Object)a.getObject(i))).sin());
                ++i;
            }
        } else {
            r = Array.factory(a.getDataType() == DataType.DOUBLE ? DataType.DOUBLE : DataType.FLOAT, a.getShape());
            int i = 0;
            while ((long)i < a.getSize()) {
                r.setDouble(i, Math.sin(a.getDouble(i)));
                ++i;
            }
        }
        return r;
    }

    public static Array cos(Array a) {
        Array r;
        if (ArrayMath.isComplex(a)) {
            r = Array.factory(DataType.OBJECT, a.getShape());
            int i = 0;
            while ((long)i < a.getSize()) {
                r.setObject(i, (Object)((Complex)((Object)a.getObject(i))).cos());
                ++i;
            }
        } else {
            r = Array.factory(a.getDataType() == DataType.DOUBLE ? DataType.DOUBLE : DataType.FLOAT, a.getShape());
            int i = 0;
            while ((long)i < a.getSize()) {
                r.setDouble(i, Math.cos(a.getDouble(i)));
                ++i;
            }
        }
        return r;
    }

    public static Array tan(Array a) {
        Array r;
        if (ArrayMath.isComplex(a)) {
            r = Array.factory(DataType.OBJECT, a.getShape());
            int i = 0;
            while ((long)i < a.getSize()) {
                r.setObject(i, (Object)((Complex)((Object)a.getObject(i))).tan());
                ++i;
            }
        } else {
            r = Array.factory(a.getDataType() == DataType.DOUBLE ? DataType.DOUBLE : DataType.FLOAT, a.getShape());
            int i = 0;
            while ((long)i < a.getSize()) {
                r.setDouble(i, Math.tan(a.getDouble(i)));
                ++i;
            }
        }
        return r;
    }

    public static Array asin(Array a) {
        Array r;
        if (ArrayMath.isComplex(a)) {
            r = Array.factory(DataType.OBJECT, a.getShape());
            int i = 0;
            while ((long)i < a.getSize()) {
                r.setObject(i, (Object)((Complex)((Object)a.getObject(i))).asin());
                ++i;
            }
        } else {
            r = Array.factory(a.getDataType() == DataType.DOUBLE ? DataType.DOUBLE : DataType.FLOAT, a.getShape());
            int i = 0;
            while ((long)i < a.getSize()) {
                r.setDouble(i, Math.asin(a.getDouble(i)));
                ++i;
            }
        }
        return r;
    }

    public static Array acos(Array a) {
        Array r;
        if (ArrayMath.isComplex(a)) {
            r = Array.factory(DataType.OBJECT, a.getShape());
            int i = 0;
            while ((long)i < a.getSize()) {
                r.setObject(i, (Object)((Complex)((Object)a.getObject(i))).acos());
                ++i;
            }
        } else {
            r = Array.factory(a.getDataType() == DataType.DOUBLE ? DataType.DOUBLE : DataType.FLOAT, a.getShape());
            int i = 0;
            while ((long)i < a.getSize()) {
                r.setDouble(i, Math.acos(a.getDouble(i)));
                ++i;
            }
        }
        return r;
    }

    public static Array atan(Array a) {
        Array r;
        if (ArrayMath.isComplex(a)) {
            r = Array.factory(DataType.OBJECT, a.getShape());
            int i = 0;
            while ((long)i < a.getSize()) {
                r.setObject(i, (Object)((Complex)((Object)a.getObject(i))).atan());
                ++i;
            }
        } else {
            r = Array.factory(a.getDataType() == DataType.DOUBLE ? DataType.DOUBLE : DataType.FLOAT, a.getShape());
            int i = 0;
            while ((long)i < a.getSize()) {
                r.setDouble(i, Math.atan(a.getDouble(i)));
                ++i;
            }
        }
        return r;
    }

    public static Array atan2(Array a, Array b) {
        Array r = Array.factory(a.getDataType() == DataType.DOUBLE ? DataType.DOUBLE : DataType.FLOAT, a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            r.setDouble(i, Math.atan2(a.getDouble(i), b.getDouble(i)));
            ++i;
        }
        return r;
    }

    public static Array[] cartesianToPolar(Array x, Array y) {
        Array r = Array.factory(DataType.DOUBLE, x.getShape());
        Array B = Array.factory(DataType.DOUBLE, x.getShape());
        int i = 0;
        while ((long)i < x.getSize()) {
            double[] rr = ArrayMath.cartesianToPolar(x.getDouble(i), y.getDouble(i));
            r.setDouble(i, rr[1]);
            B.setDouble(i, rr[0]);
            ++i;
        }
        return new Array[]{B, r};
    }

    public static Array[] polarToCartesian(Array B, Array r) {
        Array x = Array.factory(DataType.DOUBLE, r.getShape());
        Array y = Array.factory(DataType.DOUBLE, r.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            double[] rr = ArrayMath.polarToCartesian(B.getDouble(i), r.getDouble(i));
            x.setDouble(i, rr[0]);
            y.setDouble(i, rr[1]);
            ++i;
        }
        return new Array[]{x, y};
    }

    public static double[] cartesianToPolar(double x, double y) {
        double r = Math.hypot(x, y);
        double B = y >= 0.0 ? (x == 0.0 ? 1.5707963267948966 : Math.asin(x / y)) : (x == 0.0 ? 4.71238898038469 : Math.asin(x / y));
        return new double[]{B, r};
    }

    public static double[] polarToCartesian(double B, double r) {
        double x = Math.cos(B) * r;
        double y = Math.sin(B) * r;
        return new double[]{x, y};
    }

    public static Array copy(Array a) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        MAMath.copy(r, a);
        return r;
    }

    public static Array section(Array a, int[] origin, int[] size, int[] stride) throws InvalidRangeException {
        Array r = a.section(origin, size, stride);
        Array rr = Array.factory(r.getDataType(), r.getShape());
        MAMath.copy(rr, r);
        return rr;
    }

    public static Array section(Array a, List<Range> ranges) throws InvalidRangeException {
        Array r = a.section(ranges);
        Array rr = Array.factory(r.getDataType(), r.getShape());
        MAMath.copy(rr, r);
        return rr;
    }

    public static Array take(Array a, List<Object> ranges) {
        int n = a.getRank();
        int[] shape = new int[n];
        ArrayList<List> indexlist = new ArrayList<List>();
        for (int i = 0; i < n; ++i) {
            Object k = ranges.get(i);
            if (k instanceof Range) {
                Range kr = (Range)k;
                shape[i] = kr.length();
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int j = kr.first(); j <= kr.last(); j += kr.stride()) {
                    list.add(j);
                }
                indexlist.add(list);
                continue;
            }
            List kl = (List)k;
            shape[i] = kl.size();
            indexlist.add(kl);
        }
        Array r = Array.factory(a.getDataType(), shape);
        IndexIterator ii = r.getIndexIterator();
        int[] acurrent = new int[n];
        Index index = a.getIndex();
        while (ii.hasNext()) {
            ii.next();
            int[] current = ii.getCurrentCounter();
            for (int i = 0; i < n; ++i) {
                acurrent[i] = (Integer)((List)indexlist.get(i)).get(current[i]);
            }
            index.set(acurrent);
            ii.setObjectCurrent(a.getObject(index));
        }
        return r;
    }

    public static Array takeValues(Array a, List<List<Integer>> ranges) {
        int n = a.getRank();
        int nn = ranges.get(0).size();
        int[] shape = new int[]{nn};
        Array r = Array.factory(a.getDataType(), shape);
        Index index = a.getIndex();
        int[] current = new int[n];
        for (int i = 0; i < nn; ++i) {
            for (int j = 0; j < n; ++j) {
                current[j] = ranges.get(j).get(i);
            }
            index.set(current);
            r.setObject(i, a.getObject(index));
        }
        return r;
    }

    public static Array setSection(Array a, List<Range> ranges, Number v) throws InvalidRangeException {
        Array r = a.section(ranges);
        IndexIterator iter = r.getIndexIterator();
        if (a.getDataType() == DataType.BOOLEAN) {
            boolean b = true;
            if (v.doubleValue() == 0.0) {
                b = false;
            }
            while (iter.hasNext()) {
                iter.setObjectNext(b);
            }
        } else {
            while (iter.hasNext()) {
                iter.setObjectNext(v);
            }
        }
        r = Array.factory(a.getDataType(), a.getShape(), r.getStorage());
        return r;
    }

    public static Array setSection(Array a, List<Range> ranges, Array v) throws InvalidRangeException {
        Array r = a.section(ranges);
        IndexIterator iter = r.getIndexIterator();
        Index index = v.getIndex();
        while (iter.hasNext()) {
            iter.next();
            iter.setObjectCurrent(v.getObject(index));
            index.incr();
        }
        r = Array.factory(a.getDataType(), a.getShape(), r.getStorage());
        return r;
    }

    public static Array setSection_Mix(Array a, List<Object> ranges, Number v) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int n = a.getRank();
        IndexIterator iter = r.getIndexIterator();
        Index aidx = a.getIndex();
        while (iter.hasNext()) {
            iter.next();
            int[] current = iter.getCurrentCounter();
            boolean isIn = true;
            for (int i = 0; i < n; ++i) {
                Object k = ranges.get(i);
                if (k instanceof Range) {
                    if (((Range)k).contains(current[i])) continue;
                    isIn = false;
                    break;
                }
                if (((List)k).contains(current[i])) continue;
                isIn = false;
                break;
            }
            aidx.set(current);
            if (isIn) {
                iter.setObjectCurrent(v);
                continue;
            }
            iter.setObjectCurrent(a.getObject(aidx));
        }
        return r;
    }

    public static Array setSection_Mix(Array a, List<Object> ranges, Array v) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int n = a.getRank();
        IndexIterator iter = r.getIndexIterator();
        Index aidx = a.getIndex();
        Index vidx = v.getIndex();
        while (iter.hasNext()) {
            iter.next();
            int[] current = iter.getCurrentCounter();
            boolean isIn = true;
            for (int i = 0; i < n; ++i) {
                Object k = ranges.get(i);
                if (k instanceof Range) {
                    if (((Range)k).contains(current[i])) continue;
                    isIn = false;
                    break;
                }
                if (((List)k).contains(current[i])) continue;
                isIn = false;
                break;
            }
            if (isIn) {
                iter.setObjectCurrent(v.getObject(vidx));
                vidx.incr();
                continue;
            }
            aidx.set(current);
            iter.setObjectCurrent(a.getObject(aidx));
        }
        return r;
    }

    public static Array setSection_List(Array a, List<List<Integer>> ranges, Number v) {
        Array r = ArrayMath.copy(a);
        int n = r.getRank();
        int[] count = new int[n];
        Index index = Index.factory(count);
        int m = ranges.get(0).size();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                count[j] = ranges.get(j).get(i);
            }
            index.set(count);
            r.setObject(index, (Object)v);
        }
        return r;
    }

    public static Array setSection_List(Array a, List<List<Integer>> ranges, Array v) {
        Array r = ArrayMath.copy(a);
        int n = r.getRank();
        int[] count = new int[n];
        Index index = Index.factory(count);
        Index vIndex = v.getIndex();
        int m = ranges.get(0).size();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                count[j] = ranges.get(j).get(i);
            }
            index.set(count);
            r.setObject(index, v.getObject(vIndex));
            vIndex.incr();
        }
        return r;
    }

    public static Array flip(Array a, List<Integer> idxs) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        for (int i : idxs) {
            r = a.flip(i);
        }
        Array rr = Array.factory(r.getDataType(), r.getShape());
        MAMath.copy(rr, r);
        return rr;
    }

    public static Array flip(Array a, int idx) {
        Array r = a.flip(idx);
        Array rr = Array.factory(r.getDataType(), r.getShape());
        MAMath.copy(rr, r);
        return rr;
    }

    public static Array transpose(Array a, int dim1, int dim2) {
        Array r = a.transpose(dim1, dim2);
        Array rr = Array.factory(r.getDataType(), r.getShape());
        MAMath.copy(rr, r);
        return rr;
    }

    public static Array rot90(Array a, int k) {
        int[] shape = new int[a.getRank()];
        if (Math.abs(k) % 2 == 1) {
            shape[0] = a.getShape()[1];
            shape[1] = a.getShape()[0];
        } else {
            shape[0] = a.getShape()[0];
            shape[1] = a.getShape()[1];
        }
        if (a.getRank() > 2) {
            for (int i = 2; i < a.getRank(); ++i) {
                shape[i] = a.getShape()[i];
            }
        }
        Array r = Array.factory(a.getDataType(), shape);
        Index indexa = a.getIndex();
        Index indexr = r.getIndex();
        switch (k) {
            case -3: 
            case 1: {
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] countera = indexa.getCurrentCounter();
                    int[] counterr = indexa.getCurrentCounter();
                    counterr[0] = shape[0] - countera[1] - 1;
                    counterr[1] = countera[0];
                    indexr.set(counterr);
                    r.setObject(indexr, a.getObject(indexa));
                    indexa.incr();
                    ++i;
                }
                break;
            }
            case -2: 
            case 2: {
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] countera = indexa.getCurrentCounter();
                    int[] counterr = indexa.getCurrentCounter();
                    counterr[0] = shape[0] - countera[0] - 1;
                    counterr[1] = shape[1] - countera[1] - 1;
                    indexr.set(counterr);
                    r.setObject(indexr, a.getObject(indexa));
                    indexa.incr();
                    ++i;
                }
                break;
            }
            case -1: 
            case 3: {
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] countera = indexa.getCurrentCounter();
                    int[] counterr = indexa.getCurrentCounter();
                    counterr[0] = countera[1];
                    counterr[1] = shape[1] - countera[0] - 1;
                    indexr.set(counterr);
                    r.setObject(indexr, a.getObject(indexa));
                    indexa.incr();
                    ++i;
                }
                break;
            }
            default: {
                r = null;
            }
        }
        return r;
    }

    public static Array join(Array a, Array b, int dim) {
        int[] shape = a.getShape();
        int na = shape[dim];
        shape[dim] = shape[dim] + b.getShape()[dim];
        int n = shape[dim];
        Array r = Array.factory(a.getDataType(), shape);
        IndexIterator iter = r.getIndexIterator();
        IndexIterator itera = a.getIndexIterator();
        IndexIterator iterb = b.getIndexIterator();
        int i = 0;
        while (iter.hasNext()) {
            if (i > 0) {
                int[] current = iter.getCurrentCounter();
                if (current[dim] < na - 1 || current[dim] == n - 1) {
                    iter.setObjectNext(itera.getObjectNext());
                } else {
                    iter.setObjectNext(iterb.getObjectNext());
                }
            } else {
                iter.setObjectNext(itera.getObjectNext());
            }
            ++i;
        }
        return r;
    }

    public static double getMinimum(Array a) {
        IndexIterator iter = a.getIndexIterator();
        double min = Double.MAX_VALUE;
        while (iter.hasNext()) {
            double val = iter.getDoubleNext();
            if (Double.isNaN(val) || !(val < min)) continue;
            min = val;
        }
        if (min == Double.MAX_VALUE) {
            return Double.NaN;
        }
        return min;
    }

    public static double getMaximum(Array a) {
        IndexIterator iter = a.getIndexIterator();
        double max = -1.797693134862316E307;
        while (iter.hasNext()) {
            double val = iter.getDoubleNext();
            if (Double.isNaN(val) || !(val > max)) continue;
            max = val;
        }
        if (max == -1.797693134862316E307) {
            return Double.NaN;
        }
        return max;
    }

    public static double getMinimum(Array a, double missingv) {
        IndexIterator iter = a.getIndexIterator();
        double min = Double.MAX_VALUE;
        while (iter.hasNext()) {
            double val = iter.getDoubleNext();
            if (MIMath.doubleEquals(val, missingv) || !(val < min)) continue;
            min = val;
        }
        return min;
    }

    public static double getMaximum(Array a, double missingv) {
        IndexIterator iter = a.getIndexIterator();
        double max = -1.797693134862316E307;
        while (iter.hasNext()) {
            double val = iter.getDoubleNext();
            if (MIMath.doubleEquals(val, missingv) || !(val > max)) continue;
            max = val;
        }
        return max;
    }

    public static double min(Array a) {
        double min = Double.MAX_VALUE;
        IndexIterator ii = a.getIndexIterator();
        while (ii.hasNext()) {
            double v = ii.getDoubleNext();
            if (Double.isNaN(v) || !(v < min)) continue;
            min = v;
        }
        if (min == Double.MAX_VALUE) {
            return Double.NaN;
        }
        return min;
    }

    public static Array min(Array a, int axis) throws InvalidRangeException {
        int idx;
        int[] dataShape = a.getShape();
        int[] shape = new int[dataShape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            idx = i;
            if (idx == axis) continue;
            if (idx > axis) {
                --idx;
            }
            shape[idx] = dataShape[i];
        }
        Array r = Array.factory(DataType.DOUBLE, shape);
        Index indexr = r.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(current[idx], current[idx], 1));
            }
            double s = ArrayMath.min(a, ranges);
            r.setDouble(i, s);
            indexr.incr();
            ++i;
        }
        return r;
    }

    public static double min(Array a, List<Range> ranges) throws InvalidRangeException {
        double min = Double.MAX_VALUE;
        IndexIterator ii = a.getRangeIterator(ranges);
        while (ii.hasNext()) {
            double v = ii.getDoubleNext();
            if (Double.isNaN(v) || !(v < min)) continue;
            min = v;
        }
        if (min == Double.MAX_VALUE) {
            return Double.NaN;
        }
        return min;
    }

    public static double max(Array a) {
        double max = -1.797693134862316E307;
        IndexIterator ii = a.getIndexIterator();
        while (ii.hasNext()) {
            double v = ii.getDoubleNext();
            if (Double.isNaN(v) || !(v > max)) continue;
            max = v;
        }
        if (max == -1.797693134862316E307) {
            return Double.NaN;
        }
        return max;
    }

    public static Array max(Array a, int axis) throws InvalidRangeException {
        int idx;
        int[] dataShape = a.getShape();
        int[] shape = new int[dataShape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            idx = i;
            if (idx == axis) continue;
            if (idx > axis) {
                --idx;
            }
            shape[idx] = dataShape[i];
        }
        Array r = Array.factory(DataType.DOUBLE, shape);
        Index indexr = r.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(current[idx], current[idx], 1));
            }
            double s = ArrayMath.max(a, ranges);
            r.setDouble(i, s);
            indexr.incr();
            ++i;
        }
        return r;
    }

    public static double max(Array a, List<Range> ranges) throws InvalidRangeException {
        double max = -1.797693134862316E307;
        IndexIterator ii = a.getRangeIterator(ranges);
        while (ii.hasNext()) {
            double v = ii.getDoubleNext();
            if (Double.isNaN(v) || !(v > max)) continue;
            max = v;
        }
        if (max == -1.797693134862316E307) {
            return Double.NaN;
        }
        return max;
    }

    public static Array sum(Array a, int axis) throws InvalidRangeException {
        int idx;
        int[] dataShape = a.getShape();
        int[] shape = new int[dataShape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            idx = i;
            if (idx == axis) continue;
            if (idx > axis) {
                --idx;
            }
            shape[idx] = dataShape[i];
        }
        Array r = Array.factory(DataType.DOUBLE, shape);
        Index indexr = r.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(current[idx], current[idx], 1));
            }
            double s = ArrayMath.sum(a, ranges);
            r.setDouble(i, s);
            indexr.incr();
            ++i;
        }
        return r;
    }

    public static double sum(Array a, List<Range> ranges) throws InvalidRangeException {
        double s = 0.0;
        int n = 0;
        IndexIterator ii = a.getRangeIterator(ranges);
        while (ii.hasNext()) {
            double v = ii.getDoubleNext();
            if (Double.isNaN(v)) continue;
            s += v;
            ++n;
        }
        if (n == 0) {
            s = Double.NaN;
        }
        return s;
    }

    public static Array sum(List<Array> alist) {
        Array r = Array.factory(DataType.DOUBLE, alist.get(0).getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            double sum = 0.0;
            int n = 0;
            for (Array a : alist) {
                double v = a.getDouble(i);
                if (Double.isNaN(v)) continue;
                sum += v;
                ++n;
            }
            if (n == 0) {
                sum = Double.NaN;
            }
            r.setDouble(i, sum);
            ++i;
        }
        return r;
    }

    public static double sum(Array a) {
        double sum = 0.0;
        int n = 0;
        IndexIterator iterA = a.getIndexIterator();
        while (iterA.hasNext()) {
            double v = iterA.getDoubleNext();
            if (Double.isNaN(v)) continue;
            sum += v;
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        return sum;
    }

    public static double sum(Array a, double missingValue) {
        double sum = 0.0;
        IndexIterator iterA = a.getIndexIterator();
        while (iterA.hasNext()) {
            double val = iterA.getDoubleNext();
            if (val == missingValue || Double.isNaN(val)) continue;
            sum += val;
        }
        return sum;
    }

    public static Array cumsum(Array a, int axis) throws InvalidRangeException {
        int idx;
        int[] dataShape = a.getShape();
        int[] shape = new int[dataShape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            idx = i;
            if (idx == axis) continue;
            if (idx > axis) {
                --idx;
            }
            shape[idx] = dataShape[i];
        }
        Array r = Array.factory(a.getDataType(), shape);
        Array rr = Array.factory(a.getDataType(), dataShape);
        Index indexr = r.getIndex();
        Index indexrr = rr.getIndex();
        int[] currentrr = indexrr.getCurrentCounter();
        int i = 0;
        while ((long)i < r.getSize()) {
            int j;
            int[] current = indexr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(current[idx], current[idx], 1));
                currentrr[j] = current[idx];
            }
            List<Double> s = ArrayMath.cumsum(a, ranges);
            for (j = 0; j < s.size(); ++j) {
                currentrr[axis] = j;
                rr.setDouble(indexrr.set(currentrr), (double)s.get(j));
            }
            indexr.incr();
            ++i;
        }
        r = null;
        return rr;
    }

    public static List<Double> cumsum(Array a, List<Range> ranges) throws InvalidRangeException {
        double s = 0.0;
        IndexIterator ii = a.getRangeIterator(ranges);
        ArrayList<Double> r = new ArrayList<Double>();
        while (ii.hasNext()) {
            double v = ii.getDoubleNext();
            r.add(s += v);
        }
        return r;
    }

    public static double prodDouble(Array a) {
        double prod = 1.0;
        IndexIterator iterA = a.getIndexIterator();
        while (iterA.hasNext()) {
            double v = iterA.getDoubleNext();
            if (Double.isNaN(v)) continue;
            prod *= v;
        }
        return prod;
    }

    public static double aveDouble(Array a) {
        double sum = 0.0;
        int n = 0;
        IndexIterator iterA = a.getIndexIterator();
        while (iterA.hasNext()) {
            double v = iterA.getDoubleNext();
            if (Double.isNaN(v)) continue;
            sum += v;
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        return sum / (double)n;
    }

    public static double aveDouble(Array a, double missingValue) {
        double sum = 0.0;
        int n = 0;
        IndexIterator iterA = a.getIndexIterator();
        while (iterA.hasNext()) {
            double val = iterA.getDoubleNext();
            if (val == missingValue || Double.isNaN(val)) continue;
            sum += val;
            ++n;
        }
        return sum / (double)n;
    }

    public static int argMin(Array a) throws InvalidRangeException {
        double min = Double.MAX_VALUE;
        int idx = 0;
        IndexIterator iterator = a.getIndexIterator();
        int i = 0;
        while (iterator.hasNext()) {
            double v = iterator.getDoubleNext();
            if (!Double.isNaN(v) && min > v) {
                min = v;
                idx = i;
            }
            ++i;
        }
        return idx;
    }

    public static Array argMin(Array a, int axis) throws InvalidRangeException {
        int idx;
        int[] dataShape = a.getShape();
        int[] shape = new int[dataShape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            idx = i;
            if (idx == axis) continue;
            if (idx > axis) {
                --idx;
            }
            shape[idx] = dataShape[i];
        }
        Array r = Array.factory(DataType.INT, shape);
        Index indexr = r.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(current[idx], current[idx], 1));
            }
            idx = ArrayMath.argMin(a.section(ranges));
            r.setInt(i, idx);
            indexr.incr();
            ++i;
        }
        return r;
    }

    public static int argMax(Array a) throws InvalidRangeException {
        double max = Double.MIN_VALUE;
        int idx = 0;
        IndexIterator iterator = a.getIndexIterator();
        int i = 0;
        while (iterator.hasNext()) {
            double v = iterator.getDoubleNext();
            if (!Double.isNaN(v) && max < v) {
                max = v;
                idx = i;
            }
            ++i;
        }
        return idx;
    }

    public static Array argMax(Array a, int axis) throws InvalidRangeException {
        int idx;
        int[] dataShape = a.getShape();
        int[] shape = new int[dataShape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            idx = i;
            if (idx == axis) continue;
            if (idx > axis) {
                --idx;
            }
            shape[idx] = dataShape[i];
        }
        Array r = Array.factory(DataType.INT, shape);
        Index indexr = r.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(current[idx], current[idx], 1));
            }
            idx = ArrayMath.argMax(a.section(ranges));
            r.setInt(i, idx);
            indexr.incr();
            ++i;
        }
        return r;
    }

    public static Array mean(Array a, int axis) throws InvalidRangeException {
        int idx;
        int[] dataShape = a.getShape();
        int[] shape = new int[dataShape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            idx = i;
            if (idx == axis) continue;
            if (idx > axis) {
                --idx;
            }
            shape[idx] = dataShape[i];
        }
        Array r = Array.factory(DataType.DOUBLE, shape);
        Index indexr = r.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(current[idx], current[idx], 1));
            }
            double mean = ArrayMath.mean(a, ranges);
            r.setDouble(i, mean);
            indexr.incr();
            ++i;
        }
        return r;
    }

    public static double mean(Array a) {
        double mean = 0.0;
        int n = 0;
        int i = 0;
        while ((long)i < a.getSize()) {
            double v = a.getDouble(i);
            if (!Double.isNaN(v)) {
                mean += v;
                ++n;
            }
            ++i;
        }
        mean = n > 0 ? (mean /= (double)n) : Double.NaN;
        return mean;
    }

    public static Array mean(List<Array> alist) {
        Array r = Array.factory(DataType.DOUBLE, alist.get(0).getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            double sum = 0.0;
            int n = 0;
            for (Array a : alist) {
                double v = a.getDouble(i);
                if (Double.isNaN(v)) continue;
                sum += v;
                ++n;
            }
            sum = n > 0 ? (sum /= (double)n) : Double.NaN;
            r.setDouble(i, sum);
            ++i;
        }
        return r;
    }

    public static double mean(Array a, List<Range> ranges) throws InvalidRangeException {
        double mean = 0.0;
        int n = 0;
        IndexIterator ii = a.getRangeIterator(ranges);
        while (ii.hasNext()) {
            double v = ii.getDoubleNext();
            if (Double.isNaN(v)) continue;
            mean += v;
            ++n;
        }
        mean = n > 0 ? (mean /= (double)n) : Double.NaN;
        return mean;
    }

    public static Array std(Array a, int axis) throws InvalidRangeException {
        int idx;
        int[] dataShape = a.getShape();
        int[] shape = new int[dataShape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            idx = i;
            if (idx == axis) continue;
            if (idx > axis) {
                --idx;
            }
            shape[idx] = dataShape[i];
        }
        Array r = Array.factory(DataType.DOUBLE, shape);
        Index indexr = r.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(current[idx], current[idx], 1));
            }
            double mean = ArrayMath.std(a, ranges);
            r.setDouble(i, mean);
            indexr.incr();
            ++i;
        }
        return r;
    }

    public static double std(Array a, List<Range> ranges) throws InvalidRangeException {
        double v;
        double mean = 0.0;
        int n = 0;
        IndexIterator ii = a.getRangeIterator(ranges);
        while (ii.hasNext()) {
            v = ii.getDoubleNext();
            if (Double.isNaN(v)) continue;
            mean += v;
            ++n;
        }
        mean = n > 0 ? (mean /= (double)n) : Double.NaN;
        if (Double.isNaN(mean)) {
            return Double.NaN;
        }
        double sum = 0.0;
        ii = a.getRangeIterator(ranges);
        while (ii.hasNext()) {
            v = ii.getDoubleNext();
            if (Double.isNaN(v)) continue;
            sum += Math.pow(v - mean, 2.0);
        }
        sum = Math.sqrt(sum / (double)n);
        return sum;
    }

    public static double std(Array a) throws InvalidRangeException {
        double v;
        double mean = 0.0;
        int n = 0;
        IndexIterator ii = a.getIndexIterator();
        while (ii.hasNext()) {
            v = ii.getDoubleNext();
            if (Double.isNaN(v)) continue;
            mean += v;
            ++n;
        }
        if (n > 0) {
            mean /= (double)n;
        } else {
            mean = Double.NaN;
            return mean;
        }
        double sum = 0.0;
        ii = a.getIndexIterator();
        while (ii.hasNext()) {
            v = ii.getDoubleNext();
            if (Double.isNaN(v)) continue;
            sum += Math.pow(v - mean, 2.0);
        }
        sum = Math.sqrt(sum / (double)n);
        return sum;
    }

    public static Array var(Array a, int axis) throws InvalidRangeException {
        int idx;
        int[] dataShape = a.getShape();
        int[] shape = new int[dataShape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            idx = i;
            if (idx == axis) continue;
            if (idx > axis) {
                --idx;
            }
            shape[idx] = dataShape[i];
        }
        Array r = Array.factory(DataType.DOUBLE, shape);
        Index indexr = r.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(current[idx], current[idx], 1));
            }
            double mean = ArrayMath.std(a, ranges);
            r.setDouble(i, mean);
            indexr.incr();
            ++i;
        }
        return r;
    }

    public static double var(Array a, List<Range> ranges) throws InvalidRangeException {
        double v;
        double mean = 0.0;
        int n = 0;
        IndexIterator ii = a.getRangeIterator(ranges);
        while (ii.hasNext()) {
            v = ii.getDoubleNext();
            if (Double.isNaN(v)) continue;
            mean += v;
            ++n;
        }
        mean = n > 0 ? (mean /= (double)n) : Double.NaN;
        if (Double.isNaN(mean)) {
            return Double.NaN;
        }
        double sum = 0.0;
        ii = a.getRangeIterator(ranges);
        while (ii.hasNext()) {
            v = ii.getDoubleNext();
            if (Double.isNaN(v)) continue;
            sum += Math.pow(v - mean, 2.0);
        }
        return sum /= (double)n;
    }

    public static Array median(Array a, int axis) throws InvalidRangeException {
        int idx;
        int[] dataShape = a.getShape();
        int[] shape = new int[dataShape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            idx = i;
            if (idx == axis) continue;
            if (idx > axis) {
                --idx;
            }
            shape[idx] = dataShape[i];
        }
        Array r = Array.factory(DataType.DOUBLE, shape);
        Index indexr = r.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(current[idx], current[idx], 1));
            }
            double mean = ArrayMath.median(a, ranges);
            r.setDouble(i, mean);
            indexr.incr();
            ++i;
        }
        return r;
    }

    public static double median(Array a, List<Range> ranges) throws InvalidRangeException {
        Array b = a.section(ranges);
        double median = Statistics.quantile(b, 2);
        return median;
    }

    public static double median(Array a) {
        return Statistics.quantile(a, 2);
    }

    public static Array maximum(Array x1, Array x2) {
        DataType dt = ArrayMath.commonType(x1.getDataType(), x2.getDataType());
        Array r = Array.factory(dt, x1.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setObject(i, (Object)Math.max(x1.getDouble(i), x2.getDouble(i)));
            ++i;
        }
        return r;
    }

    public static Array fmax(Array x1, Array x2) {
        DataType dt = ArrayMath.commonType(x1.getDataType(), x2.getDataType());
        Array r = Array.factory(dt, x1.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            if (Double.isNaN(x1.getDouble(i))) {
                r.setObject(i, (Object)x2.getDouble(i));
            } else if (Double.isNaN(x2.getDouble(i))) {
                r.setObject(i, (Object)x1.getDouble(i));
            } else {
                r.setObject(i, (Object)Math.max(x1.getDouble(i), x2.getDouble(i)));
            }
            ++i;
        }
        return r;
    }

    public static Array minimum(Array x1, Array x2) {
        DataType dt = ArrayMath.commonType(x1.getDataType(), x2.getDataType());
        Array r = Array.factory(dt, x1.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setObject(i, (Object)Math.min(x1.getDouble(i), x2.getDouble(i)));
            ++i;
        }
        return r;
    }

    public static Array fmin(Array x1, Array x2) {
        DataType dt = ArrayMath.commonType(x1.getDataType(), x2.getDataType());
        Array r = Array.factory(dt, x1.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            if (Double.isNaN(x1.getDouble(i))) {
                r.setObject(i, (Object)x2.getDouble(i));
            } else if (Double.isNaN(x2.getDouble(i))) {
                r.setObject(i, (Object)x1.getDouble(i));
            } else {
                r.setObject(i, (Object)Math.min(x1.getDouble(i), x2.getDouble(i)));
            }
            ++i;
        }
        return r;
    }

    public static Array rolling_mean(Array x, int window, boolean center) {
        int n = (int)x.getSize();
        Array r = Array.factory(DataType.DOUBLE, new int[]{n});
        if (center) {
            int halfn = (window - 1) / 2;
            for (int i = 0; i < n; ++i) {
                int idx;
                double v = 0.0;
                int dn = 0;
                for (int j = 0; j < window && (idx = j < halfn ? i - j : (j == halfn ? i : i + (j - halfn))) >= 0 && idx < n; ++j) {
                    double vv = x.getDouble(idx);
                    if (Double.isNaN(vv)) continue;
                    v += vv;
                    ++dn;
                }
                v = dn > 0 ? (v /= (double)dn) : Double.NaN;
                r.setDouble(i, v);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                double v = 0.0;
                int dn = 0;
                for (int j = 0; j < window && i - j >= 0; ++j) {
                    double vv = x.getDouble(i - j);
                    if (Double.isNaN(vv)) continue;
                    v += vv;
                    ++dn;
                }
                v = dn > 0 ? (v /= (double)dn) : Double.NaN;
                r.setDouble(i, v);
            }
        }
        return r;
    }

    public static void missingToNaN(Array a, Number missingv) {
        if (!a.getDataType().isNumeric()) {
            return;
        }
        IndexIterator iterA = a.getIndexIterator();
        switch (a.getDataType()) {
            case INT: 
            case FLOAT: {
                while (iterA.hasNext()) {
                    float val = iterA.getFloatNext();
                    if (val != missingv.floatValue()) continue;
                    iterA.setFloatCurrent(Float.NaN);
                }
                break;
            }
        }
        while (iterA.hasNext()) {
            double val = iterA.getDoubleNext();
            if (!MIMath.doubleEquals(val, missingv.doubleValue())) continue;
            iterA.setDoubleCurrent(Double.NaN);
        }
    }

    public static void setValue(Array a, Array b, Number value) {
        if (b.getDataType() == DataType.BOOLEAN) {
            int i = 0;
            while ((long)i < a.getSize()) {
                if (b.getBoolean(i)) {
                    a.setObject(i, (Object)value);
                }
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < a.getSize()) {
                if (b.getInt(i) == 1) {
                    a.setObject(i, (Object)value);
                }
                ++i;
            }
        }
    }

    public static void setValue(Array a, Array b, Array value) {
        if (b.getDataType() == DataType.BOOLEAN) {
            int i = 0;
            while ((long)i < a.getSize()) {
                if (b.getBoolean(i)) {
                    a.setObject(i, value.getObject(i));
                }
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < a.getSize()) {
                if (b.getInt(i) == 1) {
                    a.setObject(i, value.getObject(i));
                }
                ++i;
            }
        }
    }

    public static List<Object> asList(Array a) {
        IndexIterator iterA = a.getIndexIterator();
        ArrayList<Object> r = new ArrayList<Object>();
        switch (a.getDataType()) {
            case INT: 
            case SHORT: {
                while (iterA.hasNext()) {
                    r.add(iterA.getIntNext());
                }
                break;
            }
            case FLOAT: {
                while (iterA.hasNext()) {
                    r.add(Float.valueOf(iterA.getFloatNext()));
                }
                break;
            }
            case DOUBLE: {
                while (iterA.hasNext()) {
                    r.add(iterA.getDoubleNext());
                }
                break;
            }
            case BOOLEAN: {
                while (iterA.hasNext()) {
                    r.add(iterA.getBooleanNext());
                }
                break;
            }
            case OBJECT: {
                while (iterA.hasNext()) {
                    r.add(iterA.getObjectNext());
                }
                break;
            }
        }
        return r;
    }

    public static Array[] uv2ds(Array u, Array v) {
        Array windSpeed = ArrayMath.sqrt(ArrayMath.add(ArrayMath.mul(u, u), ArrayMath.mul(v, v)));
        Array windDir = Array.factory(windSpeed.getDataType(), windSpeed.getShape());
        int i = 0;
        while ((long)i < windSpeed.getSize()) {
            double U = u.getDouble(i);
            double V = v.getDouble(i);
            if (Double.isNaN(U) || Double.isNaN(V)) {
                windDir.setDouble(i, Double.NaN);
            } else {
                double wd;
                double ws = windSpeed.getDouble(i);
                if (ws == 0.0) {
                    wd = 0.0;
                } else {
                    wd = Math.asin(U / ws) * 180.0 / Math.PI;
                    if (U <= 0.0 && V < 0.0) {
                        wd = 180.0 - wd;
                    } else if (U > 0.0 && V < 0.0) {
                        wd = 180.0 - wd;
                    } else if (U < 0.0 && V > 0.0) {
                        wd = 360.0 + wd;
                    }
                    wd += 180.0;
                    if (wd >= 360.0) {
                        wd -= 360.0;
                    }
                }
                windDir.setDouble(i, wd);
            }
            ++i;
        }
        return new Array[]{windDir, windSpeed};
    }

    public static double[] uv2ds(double u, double v) {
        double wd;
        double ws = Math.sqrt(u * u + v * v);
        if (ws == 0.0) {
            wd = 0.0;
        } else {
            wd = Math.asin(u / ws) * 180.0 / Math.PI;
            if (u <= 0.0 && v < 0.0) {
                wd = 180.0 - wd;
            } else if (u > 0.0 && v < 0.0) {
                wd = 180.0 - wd;
            } else if (u < 0.0 && v > 0.0) {
                wd = 360.0 + wd;
            }
            wd += 180.0;
            if (wd >= 360.0) {
                wd -= 360.0;
            }
        }
        return new double[]{wd, ws};
    }

    public static Array[] ds2uv(Array windDir, Array windSpeed) {
        Array U = Array.factory(DataType.DOUBLE, windDir.getShape());
        Array V = Array.factory(DataType.DOUBLE, windDir.getShape());
        int i = 0;
        while ((long)i < U.getSize()) {
            double dir;
            if (Double.isNaN(windDir.getDouble(i)) || Double.isNaN(windSpeed.getDouble(i))) {
                U.setDouble(i, Double.NaN);
                V.setDouble(i, Double.NaN);
            }
            if ((dir = windDir.getDouble(i) + 180.0) > 360.0) {
                dir -= 360.0;
            }
            dir = dir * Math.PI / 180.0;
            U.setDouble(i, windSpeed.getDouble(i) * Math.sin(dir));
            V.setDouble(i, windSpeed.getDouble(i) * Math.cos(dir));
            ++i;
        }
        return new Array[]{U, V};
    }

    public static double[] ds2uv(double windDir, double windSpeed) {
        double dir = windDir + 180.0;
        if (dir > 360.0) {
            dir -= 360.0;
        }
        dir = dir * Math.PI / 180.0;
        double u = windSpeed * Math.sin(dir);
        double v = windSpeed * Math.cos(dir);
        return new double[]{u, v};
    }

    public static Array inPolygon(Array a, List<Number> x, List<Number> y, VectorLayer layer) {
        List<? extends Shape> polygons = layer.getShapes();
        return ArrayMath.inPolygon(a, x, y, polygons);
    }

    public static Array inPolygon(Array a, List<Number> x, List<Number> y, PolygonShape ps) {
        ArrayList<PolygonShape> polygons = new ArrayList<PolygonShape>();
        polygons.add(ps);
        return ArrayMath.inPolygon(a, x, y, polygons);
    }

    public static Array inPolygon(Array a, List<Number> x, List<Number> y, List<PolygonShape> polygons) {
        if (a.getRank() == 2) {
            int xNum = x.size();
            int yNum = y.size();
            Array r = Array.factory(DataType.INT, a.getShape());
            for (int i = 0; i < yNum; ++i) {
                for (int j = 0; j < xNum; ++j) {
                    if (GeoComputation.pointInPolygons(polygons, new PointD(x.get(j).doubleValue(), y.get(i).doubleValue()))) {
                        r.setInt(i * xNum + j, 1);
                        continue;
                    }
                    r.setInt(i * xNum + j, -1);
                }
            }
            return r;
        }
        if (a.getRank() == 1) {
            int n = x.size();
            Array r = Array.factory(DataType.INT, a.getShape());
            for (int i = 0; i < n; ++i) {
                if (GeoComputation.pointInPolygons(polygons, new PointD(x.get(i).doubleValue(), y.get(i).doubleValue()))) {
                    r.setInt(i, 1);
                    continue;
                }
                r.setInt(i, -1);
            }
            return r;
        }
        return null;
    }

    public static Array inPolygon(Array x, Array y, List<PolygonShape> polygons) {
        Array r = Array.factory(DataType.BOOLEAN, x.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            if (GeoComputation.pointInPolygons(polygons, new PointD(x.getDouble(i), y.getDouble(i)))) {
                r.setBoolean(i, true);
            } else {
                r.setBoolean(i, false);
            }
            ++i;
        }
        return r;
    }

    public static Array inPolygon(Array a, List<Number> x, List<Number> y, List<Number> x_p, List<Number> y_p) {
        PolygonShape ps = new PolygonShape();
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (int i = 0; i < x_p.size(); ++i) {
            points.add(new PointD(x_p.get(i).doubleValue(), y_p.get(i).doubleValue()));
        }
        ps.setPoints(points);
        ArrayList<PolygonShape> shapes = new ArrayList<PolygonShape>();
        shapes.add(ps);
        return ArrayMath.inPolygon(a, x, y, shapes);
    }

    public static Array inPolygon(Array x, Array y, Array x_p, Array y_p) {
        PolygonShape ps = new PolygonShape();
        ArrayList<PointD> points = new ArrayList<PointD>();
        int i = 0;
        while ((long)i < x_p.getSize()) {
            points.add(new PointD(x_p.getDouble(i), y_p.getDouble(i)));
            ++i;
        }
        ps.setPoints(points);
        ArrayList<PolygonShape> shapes = new ArrayList<PolygonShape>();
        shapes.add(ps);
        return ArrayMath.inPolygon(x, y, shapes);
    }

    public static Array maskout(Array a, List<Number> x, List<Number> y, VectorLayer layer, Number missingValue) {
        List<? extends Shape> polygons = layer.getShapes();
        return ArrayMath.maskout(a, x, y, polygons, missingValue);
    }

    public static Array maskout(Array a, List<Number> x, List<Number> y, PolygonShape polygon, Number missingValue) {
        ArrayList<PolygonShape> polygons = new ArrayList<PolygonShape>();
        polygons.add(polygon);
        return ArrayMath.maskout(a, x, y, polygons, missingValue);
    }

    public static Array maskout(Array a, Array x, Array y, List<PolygonShape> polygons) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (GeoComputation.pointInPolygons(polygons, new PointD(x.getDouble(i), y.getDouble(i)))) {
                r.setObject(i, a.getObject(i));
            } else {
                r.setObject(i, (Object)Double.NaN);
            }
            ++i;
        }
        return r;
    }

    public static Array maskin(Array a, Array x, Array y, List<PolygonShape> polygons) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int i = 0;
        while ((long)i < a.getSize()) {
            if (GeoComputation.pointInPolygons(polygons, new PointD(x.getDouble(i), y.getDouble(i)))) {
                r.setObject(i, (Object)Double.NaN);
            } else {
                r.setObject(i, a.getObject(i));
            }
            ++i;
        }
        return r;
    }

    public static Array[] maskout_Remove(Array a, Array x, Array y, List<PolygonShape> polygons) {
        ArrayList<Object> rdata = new ArrayList<Object>();
        ArrayList<Double> rxdata = new ArrayList<Double>();
        ArrayList<Double> rydata = new ArrayList<Double>();
        int i = 0;
        while ((long)i < a.getSize()) {
            if (GeoComputation.pointInPolygons(polygons, new PointD(x.getDouble(i), y.getDouble(i)))) {
                rdata.add(a.getObject(i));
                rxdata.add(x.getDouble(i));
                rydata.add(y.getDouble(i));
            }
            ++i;
        }
        int n = rdata.size();
        int[] shape = new int[]{n};
        Array r = Array.factory(a.getDataType(), shape);
        Array rx = Array.factory(x.getDataType(), shape);
        Array ry = Array.factory(y.getDataType(), shape);
        for (int i2 = 0; i2 < n; ++i2) {
            r.setObject(i2, rdata.get(i2));
            rx.setDouble(i2, (double)((Double)rxdata.get(i2)));
            ry.setDouble(i2, (double)((Double)rydata.get(i2)));
        }
        return new Array[]{r, rx, ry};
    }

    public static Array[] maskin_Remove(Array a, Array x, Array y, List<PolygonShape> polygons) {
        ArrayList<Object> rdata = new ArrayList<Object>();
        ArrayList<Double> rxdata = new ArrayList<Double>();
        ArrayList<Double> rydata = new ArrayList<Double>();
        int i = 0;
        while ((long)i < a.getSize()) {
            if (!GeoComputation.pointInPolygons(polygons, new PointD(x.getDouble(i), y.getDouble(i)))) {
                rdata.add(a.getObject(i));
                rxdata.add(x.getDouble(i));
                rydata.add(y.getDouble(i));
            }
            ++i;
        }
        int n = rdata.size();
        int[] shape = new int[]{n};
        Array r = Array.factory(a.getDataType(), shape);
        Array rx = Array.factory(x.getDataType(), shape);
        Array ry = Array.factory(y.getDataType(), shape);
        for (int i2 = 0; i2 < n; ++i2) {
            r.setObject(i2, rdata.get(i2));
            rx.setDouble(i2, (double)((Double)rxdata.get(i2)));
            ry.setDouble(i2, (double)((Double)rydata.get(i2)));
        }
        return new Array[]{r, rx, ry};
    }

    public static Array maskout(Array a, List<Number> x, List<Number> y, List<PolygonShape> polygons) {
        return ArrayMath.maskout(a, x, y, polygons, (Number)Double.NaN);
    }

    public static Array maskout(Array a, List<Number> x, List<Number> y, List<PolygonShape> polygons, Number missingValue) {
        Array r;
        block6: {
            int yNum;
            int xNum;
            block5: {
                xNum = x.size();
                yNum = y.size();
                r = Array.factory(a.getDataType(), a.getShape());
                if (a.getRank() != 1) break block5;
                for (int i = 0; i < xNum; ++i) {
                    if (GeoComputation.pointInPolygons(polygons, new PointD(x.get(i).doubleValue(), y.get(i).doubleValue()))) {
                        r.setObject(i, a.getObject(i));
                        continue;
                    }
                    r.setObject(i, (Object)missingValue);
                }
                break block6;
            }
            if (a.getRank() != 2) break block6;
            for (int i = 0; i < yNum; ++i) {
                for (int j = 0; j < xNum; ++j) {
                    int idx = i * xNum + j;
                    if (GeoComputation.pointInPolygons(polygons, new PointD(x.get(j).doubleValue(), y.get(i).doubleValue()))) {
                        r.setObject(idx, a.getObject(idx));
                        continue;
                    }
                    r.setObject(idx, (Object)missingValue);
                }
            }
        }
        return r;
    }

    public static Array maskout(Array a, Array m, Number missingValue) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int n = (int)a.getSize();
        for (int i = 0; i < n; ++i) {
            if (m.getDouble(i) < 0.0) {
                r.setObject(i, (Object)missingValue);
                continue;
            }
            r.setObject(i, a.getObject(i));
        }
        return r;
    }

    public static Array maskout(Array a, Array m) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int n = (int)a.getSize();
        for (int i = 0; i < n; ++i) {
            if (m.getDouble(i) < 0.0) {
                r.setObject(i, (Object)Double.NaN);
                continue;
            }
            r.setObject(i, a.getObject(i));
        }
        return r;
    }

    public static Array maskin(Array a, Array m) {
        Array r = Array.factory(a.getDataType(), a.getShape());
        int n = (int)a.getSize();
        for (int i = 0; i < n; ++i) {
            if (m.getDouble(i) < 0.0) {
                r.setObject(i, a.getObject(i));
                continue;
            }
            r.setObject(i, (Object)Double.NaN);
        }
        return r;
    }

    public static float getR(List<Number> xData, List<Number> yData) {
        int n = xData.size();
        double x_sum = 0.0;
        double y_sum = 0.0;
        for (int i = 0; i < n; ++i) {
            x_sum += xData.get(i).doubleValue();
            y_sum += yData.get(i).doubleValue();
        }
        double sx_sum = 0.0;
        double sy_sum = 0.0;
        double xy_sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sx_sum += xData.get(i).doubleValue() * xData.get(i).doubleValue();
            sy_sum += yData.get(i).doubleValue() * yData.get(i).doubleValue();
            xy_sum += xData.get(i).doubleValue() * yData.get(i).doubleValue();
        }
        double r = ((double)n * xy_sum - x_sum * y_sum) / (Math.sqrt((double)n * sx_sum - x_sum * x_sum) * Math.sqrt((double)n * sy_sum - y_sum * y_sum));
        return (float)r;
    }

    public static float getR(Array xData, Array yData) {
        int n = (int)xData.getSize();
        double x_sum = 0.0;
        double y_sum = 0.0;
        double sx_sum = 0.0;
        double sy_sum = 0.0;
        double xy_sum = 0.0;
        int nn = 0;
        for (int i = 0; i < n; ++i) {
            double x = xData.getDouble(i);
            double y = yData.getDouble(i);
            if (Double.isNaN(x) || Double.isNaN(y)) continue;
            x_sum += x;
            y_sum += y;
            sx_sum += x * x;
            sy_sum += y * y;
            xy_sum += x * y;
            ++nn;
        }
        double r = ((double)nn * xy_sum - x_sum * y_sum) / (Math.sqrt((double)nn * sx_sum - x_sum * x_sum) * Math.sqrt((double)nn * sy_sum - y_sum * y_sum));
        return (float)r;
    }

    public static double[] leastSquareTrend(List<Number> xData, List<Number> yData) {
        int n = xData.size();
        double sumX = 0.0;
        double sumY = 0.0;
        double sumSquareX = 0.0;
        double sumXY = 0.0;
        for (int i = 0; i < n; ++i) {
            sumX += xData.get(i).doubleValue();
            sumY += yData.get(i).doubleValue();
            sumSquareX += xData.get(i).doubleValue() * xData.get(i).doubleValue();
            sumXY += xData.get(i).doubleValue() * yData.get(i).doubleValue();
        }
        double a = (sumSquareX * sumY - sumX * sumXY) / ((double)n * sumSquareX - sumX * sumX);
        double b = ((double)n * sumXY - sumX * sumY) / ((double)n * sumSquareX - sumX * sumX);
        return new double[]{a, b};
    }

    public static double[] lineRegress(List<Number> xData, List<Number> yData) {
        int n = xData.size();
        double x_sum = 0.0;
        double y_sum = 0.0;
        double sx_sum = 0.0;
        double sy_sum = 0.0;
        double xy_sum = 0.0;
        for (int i = 0; i < n; ++i) {
            x_sum += xData.get(i).doubleValue();
            y_sum += yData.get(i).doubleValue();
            sx_sum += xData.get(i).doubleValue() * xData.get(i).doubleValue();
            sy_sum += yData.get(i).doubleValue() * yData.get(i).doubleValue();
            xy_sum += xData.get(i).doubleValue() * yData.get(i).doubleValue();
        }
        double r = ((double)n * xy_sum - x_sum * y_sum) / (Math.sqrt((double)n * sx_sum - x_sum * x_sum) * Math.sqrt((double)n * sy_sum - y_sum * y_sum));
        double a = (sx_sum * y_sum - x_sum * xy_sum) / ((double)n * sx_sum - x_sum * x_sum);
        double b = ((double)n * xy_sum - x_sum * y_sum) / ((double)n * sx_sum - x_sum * x_sum);
        return new double[]{a, b, r};
    }

    public static double[] lineRegress(Array xData, Array yData) {
        double x_sum = 0.0;
        double y_sum = 0.0;
        double sx_sum = 0.0;
        double sy_sum = 0.0;
        double xy_sum = 0.0;
        int n = 0;
        ArrayList<Double> xi = new ArrayList<Double>();
        ArrayList<Double> yi = new ArrayList<Double>();
        int i = 0;
        while ((long)i < xData.getSize()) {
            if (!Double.isNaN(xData.getDouble(i)) && !Double.isNaN(yData.getDouble(i))) {
                xi.add(xData.getDouble(i));
                yi.add(yData.getDouble(i));
                x_sum += xData.getDouble(i);
                y_sum += yData.getDouble(i);
                sx_sum += xData.getDouble(i) * xData.getDouble(i);
                sy_sum += yData.getDouble(i) * yData.getDouble(i);
                xy_sum += xData.getDouble(i) * yData.getDouble(i);
                ++n;
            }
            ++i;
        }
        double r = ((double)n * xy_sum - x_sum * y_sum) / (Math.sqrt((double)n * sx_sum - x_sum * x_sum) * Math.sqrt((double)n * sy_sum - y_sum * y_sum));
        double intercept = (sx_sum * y_sum - x_sum * xy_sum) / ((double)n * sx_sum - x_sum * x_sum);
        double slope = ((double)n * xy_sum - x_sum * y_sum) / ((double)n * sx_sum - x_sum * x_sum);
        int df = n - 2;
        double TINY = 1.0E-20;
        double t = r * Math.sqrt((double)df / ((1.0 - r + TINY) * (1.0 + r + TINY)));
        double p = ArrayMath.studpval(t, df);
        double xbar = x_sum / (double)n;
        double ybar = y_sum / (double)n;
        double rss = 0.0;
        double ssr = 0.0;
        double xxbar = 0.0;
        for (int i2 = 0; i2 < n; ++i2) {
            double fit = slope * (Double)xi.get(i2) + intercept;
            rss += (fit - (Double)yi.get(i2)) * (fit - (Double)yi.get(i2));
            ssr += (fit - ybar) * (fit - ybar);
            xxbar += ((Double)xi.get(i2) - xbar) * ((Double)xi.get(i2) - xbar);
        }
        double svar = rss / (double)df;
        double svar1 = svar / xxbar;
        double svar0 = svar / (double)n + xbar * xbar * svar1;
        svar0 = Math.sqrt(svar0);
        svar1 = Math.sqrt(svar1);
        return new double[]{slope, intercept, r, p, svar1, n};
    }

    private static double statcom(double mq, int mi, int mj, double mb) {
        double zz;
        double mz = zz = 1.0;
        for (int mk = mi; mk <= mj; mk += 2) {
            zz = zz * mq * (double)mk / ((double)mk - mb);
            mz += zz;
        }
        return mz;
    }

    private static double studpval(double mt, int mn) {
        mt = Math.abs(mt);
        double mw = mt / Math.sqrt(mn);
        double th = Math.atan2(mw, 1.0);
        if (mn == 1) {
            return 1.0 - th / 1.5707963267948966;
        }
        double sth = Math.sin(th);
        double cth = Math.cos(th);
        if (mn % 2 == 1) {
            return 1.0 - (th + sth * cth * ArrayMath.statcom(cth * cth, 2, mn - 3, -1.0)) / 1.5707963267948966;
        }
        return 1.0 - sth * ArrayMath.statcom(cth * cth, 1, mn - 3, -1.0);
    }

    public static Array polyVal(List<Number> p, Array x) {
        int n = p.size();
        Array r = Array.factory(DataType.DOUBLE, x.getShape());
        int i = 0;
        while ((long)i < x.getSize()) {
            double val = x.getDouble(i);
            double rval = 0.0;
            for (int j = 0; j < n; ++j) {
                rval += p.get(j).doubleValue() * Math.pow(val, n - j - 1);
            }
            r.setDouble(i, rval);
            ++i;
        }
        return r;
    }

    public static Array cdiff(Array data, int dimIdx) {
        Array r = Array.factory(DataType.DOUBLE, data.getShape());
        Index index = data.getIndex();
        Index indexr = r.getIndex();
        int[] shape = data.getShape();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexr.getCurrentCounter();
            if (current[dimIdx] == 0 || current[dimIdx] == shape[dimIdx] - 1) {
                r.setDouble(indexr, Double.NaN);
            } else {
                int[] cc = Arrays.copyOf(current, current.length);
                cc[dimIdx] = cc[dimIdx] - 1;
                index.set(cc);
                double a = data.getDouble(index);
                cc[dimIdx] = cc[dimIdx] + 2;
                index.set(cc);
                double b = data.getDouble(index);
                if (Double.isNaN(a) || Double.isNaN(b)) {
                    r.setDouble(indexr, Double.NaN);
                } else {
                    r.setDouble(indexr, a - b);
                }
            }
            indexr.incr();
            ++i;
        }
        return r;
    }

    public static Array cdiff_bak(Array data, boolean isX) {
        if (data.getRank() == 2) {
            int xnum = data.getShape()[1];
            int ynum = data.getShape()[0];
            Array r = Array.factory(DataType.DOUBLE, data.getShape());
            for (int i = 0; i < ynum; ++i) {
                for (int j = 0; j < xnum; ++j) {
                    double b;
                    double a;
                    if (i == 0 || i == ynum - 1 || j == 0 || j == xnum - 1) {
                        r.setDouble(i * xnum + j, Double.NaN);
                        continue;
                    }
                    if (isX) {
                        a = data.getDouble(i * xnum + j + 1);
                        b = data.getDouble(i * xnum + j - 1);
                    } else {
                        a = data.getDouble((i + 1) * xnum + j);
                        b = data.getDouble((i - 1) * xnum + j);
                    }
                    if (Double.isNaN(a) || Double.isNaN(b)) {
                        r.setDouble(i * xnum + j, Double.NaN);
                        continue;
                    }
                    r.setDouble(i * xnum + j, a - b);
                }
            }
            return r;
        }
        if (data.getRank() == 1) {
            int n = data.getShape()[0];
            Array r = Array.factory(DataType.DOUBLE, data.getShape());
            for (int i = 0; i < n; ++i) {
                if (i == 0 || i == n - 1) {
                    r.setDouble(i, Double.NaN);
                    continue;
                }
                double a = data.getDouble(i + 1);
                double b = data.getDouble(i - 1);
                if (Double.isNaN(a) || Double.isNaN(b)) {
                    r.setDouble(i, Double.NaN);
                    continue;
                }
                r.setDouble(i, a - b);
            }
            return r;
        }
        System.out.println("Data dimension number must be 1 or 2!");
        return null;
    }

    public static Array hcurl(Array uData, Array vData, List<Number> xx, List<Number> yy) {
        int rank = uData.getRank();
        int[] shape = uData.getShape();
        Array lonData = Array.factory(DataType.DOUBLE, shape);
        Array latData = Array.factory(DataType.DOUBLE, shape);
        Index index = lonData.getIndex();
        int i = 0;
        while ((long)i < lonData.getSize()) {
            int[] current = index.getCurrentCounter();
            lonData.setDouble(index, xx.get(current[rank - 1]).doubleValue());
            latData.setDouble(index, yy.get(current[rank - 2]).doubleValue());
            index.incr();
            ++i;
        }
        Array dv = ArrayMath.cdiff(vData, rank - 1);
        Array dx = ArrayMath.mul(ArrayMath.cdiff(lonData, rank - 1), Math.PI / 180);
        Array du = ArrayMath.cdiff(ArrayMath.mul(uData, ArrayMath.cos(ArrayMath.mul(latData, Math.PI / 180))), rank - 2);
        Array dy = ArrayMath.mul(ArrayMath.cdiff(latData, rank - 2), Math.PI / 180);
        Array gData = ArrayMath.div(ArrayMath.sub(ArrayMath.div(dv, dx), ArrayMath.div(du, dy)), ArrayMath.mul(ArrayMath.cos(ArrayMath.mul(latData, Math.PI / 180)), 6370000.0));
        return gData;
    }

    public static Array hdivg(Array uData, Array vData, List<Number> xx, List<Number> yy) {
        int rank = uData.getRank();
        int[] shape = uData.getShape();
        Array lonData = Array.factory(DataType.DOUBLE, shape);
        Array latData = Array.factory(DataType.DOUBLE, shape);
        Index index = lonData.getIndex();
        int i = 0;
        while ((long)i < lonData.getSize()) {
            int[] current = index.getCurrentCounter();
            lonData.setDouble(index, xx.get(current[rank - 1]).doubleValue());
            latData.setDouble(index, yy.get(current[rank - 2]).doubleValue());
            index.incr();
            ++i;
        }
        Array du = ArrayMath.cdiff(uData, rank - 1);
        Array dx = ArrayMath.mul(ArrayMath.cdiff(lonData, rank - 1), Math.PI / 180);
        Array dv = ArrayMath.cdiff(ArrayMath.mul(vData, ArrayMath.cos(ArrayMath.mul(latData, Math.PI / 180))), rank - 2);
        Array dy = ArrayMath.mul(ArrayMath.cdiff(latData, rank - 2), Math.PI / 180);
        Array gData = ArrayMath.div(ArrayMath.add(ArrayMath.div(du, dx), ArrayMath.div(dv, dy)), ArrayMath.mul(ArrayMath.cos(ArrayMath.mul(latData, Math.PI / 180)), 6370000.0));
        return gData;
    }

    public static Array magnitude(Array uData, Array vData) {
        int[] shape = uData.getShape();
        int xNum = shape[1];
        int yNum = shape[0];
        Array r = Array.factory(DataType.DOUBLE, shape);
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                int idx = i * xNum + j;
                if (Double.isNaN(uData.getDouble(idx)) || Double.isNaN(vData.getDouble(idx))) {
                    r.setDouble(idx, Double.NaN);
                    continue;
                }
                r.setDouble(idx, Math.sqrt(Math.pow(uData.getDouble(idx), 2.0) + Math.pow(vData.getDouble(idx), 2.0)));
            }
        }
        return r;
    }

    public static Array tc2tf(Array tc) {
        Array r = Array.factory(tc.getDataType(), tc.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, MeteoMath.tc2tf(tc.getDouble(i)));
            ++i;
        }
        return r;
    }

    public static Array tf2tc(Array tf) {
        Array r = Array.factory(tf.getDataType(), tf.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, MeteoMath.tf2tc(tf.getDouble(i)));
            ++i;
        }
        return r;
    }

    public static Array qair2rh(Array qair, Array temp, double press) {
        Array r = Array.factory(DataType.DOUBLE, qair.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            double rh = MeteoMath.qair2rh(qair.getDouble(i), temp.getDouble(i), press);
            r.setDouble(i, rh);
            ++i;
        }
        return r;
    }

    public static Array qair2rh(Array qair, Array temp, Array press) {
        Array r = Array.factory(DataType.DOUBLE, qair.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            double rh = MeteoMath.qair2rh(qair.getDouble(i), temp.getDouble(i), press.getDouble(i));
            r.setDouble(i, rh);
            ++i;
        }
        return r;
    }

    public static Array press2Height(Array press) {
        Array r = Array.factory(DataType.DOUBLE, press.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            double rh = MeteoMath.press2Height(press.getDouble(i));
            r.setDouble(i, rh);
            ++i;
        }
        return r;
    }

    public static Array height2Press(Array height) {
        Array r = Array.factory(DataType.DOUBLE, height.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            double rh = MeteoMath.height2Press(height.getDouble(i));
            r.setDouble(i, rh);
            ++i;
        }
        return r;
    }
}

