/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.meteoinfo.chart.CoordinateType;
import org.meteoinfo.chart.plot.XAlign;
import org.meteoinfo.chart.plot.YAlign;
import org.meteoinfo.drawing.Draw;
import org.meteoinfo.global.Extent;
import org.meteoinfo.shape.Shape;
import org.meteoinfo.shape.ShapeTypes;

public class ChartText
extends Shape {
    protected double x;
    protected double y;
    private Font font = new Font("Arial", 0, 14);
    private List<String> text;
    private Color color = Color.black;
    private int lineSpace = 5;
    private CoordinateType coordinates = CoordinateType.DATA;
    private Color background = Color.white;
    private boolean drawBackground = false;
    private boolean drawNeatline = false;
    private Color neatLineColor = Color.black;
    private float neatLineSize = 1.0f;
    private float gap = 3.0f;
    protected float angle = 0.0f;
    private XAlign xAlign = XAlign.LEFT;
    private YAlign yAlign = YAlign.BOTTOM;
    private boolean useExternalFont = false;
    protected double xShift = 0.0;
    protected double yShift = 0.0;

    public ChartText() {
    }

    public ChartText(String text) {
        this();
        this.text = new ArrayList<String>();
        String[] lines = text.split("\n");
        this.text.addAll(Arrays.asList(lines));
    }

    public ChartText(List<String> text) {
        this();
        this.text = text;
    }

    public ChartText(String text, Font font) {
        this();
        this.text = new ArrayList<String>();
        String[] lines = text.split("\n");
        this.text.addAll(Arrays.asList(lines));
        this.font = font;
    }

    public ChartText(List<String> text, Font font) {
        this();
        this.text = text;
        this.font = font;
    }

    public String getText() {
        return this.text.get(0);
    }

    public void setText(String value) {
        this.text = new ArrayList<String>();
        String[] lines = value.split("\n");
        this.text.addAll(Arrays.asList(lines));
    }

    public List<String> getTexts() {
        return this.text;
    }

    public void setTexts(List<String> value) {
        this.text = value;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font value) {
        this.font = value;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color value) {
        this.color = value;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double value) {
        this.x = value;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double value) {
        this.y = value;
    }

    public int getLineSpace() {
        return this.lineSpace;
    }

    public void setLineSpace(int value) {
        this.lineSpace = value;
    }

    public CoordinateType getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(CoordinateType value) {
        this.coordinates = value;
    }

    public void setCoordinates(String value) {
        switch (value) {
            case "axes": {
                this.coordinates = CoordinateType.AXES;
                break;
            }
            case "figure": {
                this.coordinates = CoordinateType.FIGURE;
                break;
            }
            case "data": {
                this.coordinates = CoordinateType.DATA;
                break;
            }
            case "inches": {
                this.coordinates = CoordinateType.INCHES;
            }
        }
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color value) {
        this.background = value;
    }

    public boolean isFill() {
        return this.drawBackground;
    }

    public void setFill(boolean value) {
        this.drawBackground = value;
    }

    public boolean isDrawNeatline() {
        return this.drawNeatline;
    }

    public void setDrawNeatline(boolean value) {
        this.drawNeatline = value;
    }

    public Color getNeatlineColor() {
        return this.neatLineColor;
    }

    public void setNeatlineColor(Color value) {
        this.neatLineColor = value;
    }

    public float getNeatlineSize() {
        return this.neatLineSize;
    }

    public void setNeatlineSize(float value) {
        this.neatLineSize = value;
    }

    public float getGap() {
        return this.gap;
    }

    public void setGap(float value) {
        this.gap = value;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float value) {
        this.angle = value;
    }

    public XAlign getXAlign() {
        return this.xAlign;
    }

    public void setXAlign(XAlign value) {
        this.xAlign = value;
    }

    public void setXAlign(String value) {
        this.xAlign = XAlign.valueOf(value.toUpperCase());
    }

    public YAlign getYAlign() {
        return this.yAlign;
    }

    public void setYAlign(YAlign value) {
        this.yAlign = value;
    }

    public void setYAlign(String value) {
        this.yAlign = YAlign.valueOf(value.toUpperCase());
    }

    public boolean isUseExternalFont() {
        return this.useExternalFont;
    }

    public void setUseExternalFont(boolean value) {
        this.useExternalFont = value;
    }

    public double getXShift() {
        return this.xShift;
    }

    public void setXShift(double value) {
        this.xShift = value;
    }

    public double getYShift() {
        return this.yShift;
    }

    public void setYShift(double value) {
        this.yShift = value;
    }

    public void addText(String value) {
        this.text.add(value);
    }

    @Override
    public ShapeTypes getShapeType() {
        return ShapeTypes.TEXT;
    }

    public int getLineNum() {
        return this.text.size();
    }

    public Dimension getTrueDimension(Graphics2D g) {
        Dimension dim = this.getDimension(g);
        if (this.angle != 0.0f) {
            int width = dim.width;
            int height = dim.height;
            if (this.angle == 90.0f || this.angle == -90.0f) {
                int temp = width;
                width = height;
                height = temp;
            } else {
                width = (int)((double)width * Math.cos(Math.toRadians(this.angle)) + (double)height * Math.sin(Math.toRadians(this.angle)));
                height = (int)((double)width * Math.sin(Math.toRadians(this.angle)) + (double)height * Math.cos(Math.toRadians(this.angle)));
            }
            return new Dimension(width, height);
        }
        return dim;
    }

    public Dimension getDimension(Graphics2D g) {
        g.setFont(this.font);
        int width = 0;
        int height = 0;
        for (String line : this.text) {
            Dimension dim = Draw.getStringDimension(line, g);
            if (width < dim.width) {
                width = dim.width;
            }
            height += dim.height + this.lineSpace;
        }
        return new Dimension(width, height -= this.lineSpace);
    }

    @Override
    public Geometry toGeometry(GeometryFactory factory) {
        return null;
    }

    public void setPoint(double x, double y) {
        this.x = x;
        this.y = y;
        Extent aExtent = new Extent();
        aExtent.minX = x;
        aExtent.maxX = x;
        aExtent.minY = y;
        aExtent.maxY = y;
        this.setExtent(aExtent);
    }

    public String toString() {
        if (this.text.size() == 1) {
            return this.text.get(0);
        }
        String r = "";
        for (int i = 0; i < this.text.size(); ++i) {
            r = i == 0 ? this.text.get(i) : r + "\n" + this.text.get(i);
        }
        return r;
    }

    public void draw(Graphics2D g, float x, float y) {
        Dimension dim = this.getDimension(g);
        x = (float)((double)x + this.xShift);
        y = (float)((double)y + this.yShift);
        AffineTransform tempTrans = g.getTransform();
        if (this.angle != 0.0f) {
            AffineTransform myTrans = (AffineTransform)tempTrans.clone();
            myTrans.translate(x, y);
            myTrans.rotate((double)(-this.angle) * Math.PI / 180.0);
            g.setTransform(myTrans);
            x = 0.0f;
            y = 0.0f;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(x, (double)y - dim.getHeight(), dim.getWidth(), dim.getHeight());
        rect.setRect(rect.x - (double)this.gap, rect.y - (double)this.gap, rect.width + (double)(this.gap * 2.0f), rect.height + (double)(this.gap * 2.0f));
        if (this.drawBackground) {
            g.setColor(this.background);
            g.fill(rect);
        }
        if (this.drawNeatline) {
            g.setColor(this.neatLineColor);
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(this.neatLineSize));
            g.draw(rect);
            g.setStroke(oldStroke);
        }
        g.setColor(this.color);
        g.setFont(this.font);
        switch (this.yAlign) {
            case BOTTOM: {
                y -= (float)dim.height;
                break;
            }
            case CENTER: {
                y -= (float)dim.height * 0.5f;
            }
        }
        for (String str : this.text) {
            dim = Draw.getStringDimension(str, g);
            Draw.drawString(g, x, y, str, this.xAlign, YAlign.TOP, this.useExternalFont);
            y += (float)dim.height;
            y += (float)this.lineSpace;
        }
        if (this.angle != 0.0f) {
            g.setTransform(tempTrans);
        }
    }

    @Override
    public Object clone() {
        ChartText ct = new ChartText();
        ct.angle = this.angle;
        ct.background = this.background;
        ct.color = this.color;
        ct.coordinates = this.coordinates;
        ct.drawBackground = this.drawBackground;
        ct.drawNeatline = this.drawNeatline;
        ct.font = this.font;
        ct.gap = this.gap;
        ct.lineSpace = this.lineSpace;
        ct.neatLineColor = this.neatLineColor;
        ct.neatLineSize = this.neatLineSize;
        ct.text = this.text;
        ct.useExternalFont = this.useExternalFont;
        ct.x = this.x;
        ct.xAlign = this.xAlign;
        ct.y = this.y;
        ct.yAlign = this.yAlign;
        return ct;
    }
}

