/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.util.FPSAnimator;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JPopupMenu;
import org.meteoinfo.chart.IChartPanel;
import org.meteoinfo.chart.MouseMode;
import org.meteoinfo.chart.jogl.Plot3DGL;

public class GLChartPanel
extends GLJPanel
implements IChartPanel {
    private Plot3DGL plot3DGL;
    private final Point mouseDownPoint = new Point(0, 0);
    private Point mouseLastPos = new Point(0, 0);
    private boolean dragMode = false;
    private JPopupMenu popupMenu;
    private MouseMode mouseMode;
    private float distanceX = 0.0f;
    private float distanceY = 0.0f;
    private FPSAnimator animator;

    public GLChartPanel() {
    }

    public GLChartPanel(Plot3DGL pltGL) {
        this.init(pltGL);
    }

    public GLChartPanel(GLCapabilities cap, Plot3DGL pltGL) {
        super((GLCapabilitiesImmutable)cap);
        this.init(pltGL);
    }

    private void init(Plot3DGL pltGL) {
        this.plot3DGL = pltGL;
        this.addGLEventListener(pltGL);
        this.setMouseMode(MouseMode.ROTATE);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                GLChartPanel.this.onMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                GLChartPanel.this.onMouseDragged(e);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
            }
        });
    }

    public Plot3DGL getPlot() {
        return this.plot3DGL;
    }

    public void setPlot(Plot3DGL plot) {
        this.init(plot);
    }

    public MouseMode getMouseMode() {
        return this.mouseMode;
    }

    @Override
    public final void setMouseMode(MouseMode value) {
        this.mouseMode = value;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Cursor customCursor = Cursor.getPredefinedCursor(0);
        switch (this.mouseMode) {
            case SELECT: {
                customCursor = Cursor.getPredefinedCursor(1);
                break;
            }
            case ZOOM_IN: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/zoom_in_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Zoom In");
                break;
            }
            case ZOOM_OUT: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/zoom_out_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Zoom In");
                break;
            }
            case PAN: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/Pan_Open_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Pan");
                break;
            }
            case IDENTIFER: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/identifer_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Identifer");
                break;
            }
            case ROTATE: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/rotate.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Identifer");
            }
        }
        this.setCursor(customCursor);
    }

    void onMousePressed(MouseEvent e) {
        this.mouseDownPoint.x = e.getX();
        this.mouseDownPoint.y = e.getY();
        this.mouseLastPos = (Point)this.mouseDownPoint.clone();
    }

    void onMouseDragged(MouseEvent e) {
        this.dragMode = true;
        int x = e.getX();
        int y = e.getY();
        switch (this.mouseMode) {
            case SELECT: 
            case ZOOM_IN: {
                this.repaint();
                break;
            }
            case ROTATE: {
                if (e.isShiftDown()) {
                    float diffX = (float)(x - this.mouseLastPos.x) / 10.0f;
                    float diffY = (float)(this.mouseLastPos.y - y) / 10.0f;
                    this.distanceX += diffX;
                    this.distanceY += diffY;
                } else {
                    Dimension size = e.getComponent().getSize();
                    float thetaY = 360.0f * ((float)(x - this.mouseLastPos.x) / (float)size.width);
                    float thetaX = 360.0f * ((float)(this.mouseLastPos.y - y) / (float)size.height);
                    float elevation = this.plot3DGL.getAngleX() - thetaX;
                    if (elevation > 0.0f) {
                        elevation = 0.0f;
                    }
                    if (elevation < -180.0f) {
                        elevation = -180.0f;
                    }
                    this.plot3DGL.setAngleX(elevation);
                    float rotation = this.plot3DGL.getAngleY() + thetaY;
                    if (rotation >= 360.0f) {
                        rotation -= 360.0f;
                    }
                    if (rotation < 0.0f) {
                        rotation += 360.0f;
                    }
                    this.plot3DGL.setAngleY(rotation);
                }
                this.repaint();
            }
        }
        this.mouseLastPos.x = x;
        this.mouseLastPos.y = y;
    }

    public GL2 getGL2() {
        return this.getGL().getGL2();
    }

    public BufferedImage paintViewImage() {
        this.plot3DGL.getDrawable().display();
        return this.plot3DGL.getScreenImage();
    }

    @Override
    public void saveImage(String fn) {
        try {
            this.saveImage(fn, null);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(GLChartPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void saveImage(String fn, Integer sleep) throws InterruptedException {
        BufferedImage image;
        this.plot3DGL.getDrawable().display();
        if (sleep != null) {
            Thread.sleep(sleep * 1000);
        }
        if ((image = this.plot3DGL.getScreenImage()) != null) {
            String extension = fn.substring(fn.lastIndexOf(46) + 1);
            try {
                ImageIO.write((RenderedImage)image, extension, new File(fn));
            }
            catch (IOException ex) {
                Logger.getLogger(GLChartPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void saveImage(String fn, int width, int height, Integer sleep) throws InterruptedException {
        BufferedImage image;
        int oWidth = this.getWidth();
        int oHeight = this.getHeight();
        this.setSize(width, height);
        this.plot3DGL.getDrawable().display();
        if (sleep != null) {
            Thread.sleep(sleep * 1000);
        }
        if ((image = this.plot3DGL.getScreenImage()) != null) {
            String extension = fn.substring(fn.lastIndexOf(46) + 1);
            try {
                ImageIO.write((RenderedImage)image, extension, new File(fn));
            }
            catch (IOException ex) {
                Logger.getLogger(GLChartPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.setSize(oWidth, oHeight);
    }

    @Override
    public void onUndoZoomClick() {
    }

    @Override
    public void paintGraphics() {
        this.repaint();
    }

    public void animator_start() {
        this.animator = new FPSAnimator((GLAutoDrawable)this, 300, true);
        this.animator.start();
    }

    public void animator_stop() {
        if (this.animator != null) {
            this.animator.stop();
        }
    }
}

