/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUquadric;
import com.jogamp.opengl.glu.GLUtessellator;
import com.jogamp.opengl.glu.GLUtessellatorCallback;
import com.jogamp.opengl.math.VectorUtil;
import com.jogamp.opengl.util.awt.AWTGLReadBufferUtil;
import com.jogamp.opengl.util.awt.TextRenderer;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import org.meteoinfo.chart.ChartColorBar;
import org.meteoinfo.chart.ChartLegend;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.ChartText3D;
import org.meteoinfo.chart.Margin;
import org.meteoinfo.chart.axis.Axis;
import org.meteoinfo.chart.jogl.GLChartPanel;
import org.meteoinfo.chart.jogl.IsosurfaceGraphics;
import org.meteoinfo.chart.jogl.Lighting;
import org.meteoinfo.chart.jogl.SurfaceGraphics;
import org.meteoinfo.chart.jogl.TextureShape;
import org.meteoinfo.chart.plot.Plot;
import org.meteoinfo.chart.plot.PlotType;
import org.meteoinfo.chart.plot.XAlign;
import org.meteoinfo.chart.plot.YAlign;
import org.meteoinfo.chart.plot3d.GraphicCollection3D;
import org.meteoinfo.data.Dataset;
import org.meteoinfo.geoprocess.GeometryUtil;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.Extent3D;
import org.meteoinfo.global.PointD;
import org.meteoinfo.legend.BarBreak;
import org.meteoinfo.legend.BreakTypes;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.ColorBreakCollection;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.LegendType;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.legend.PolylineBreak;
import org.meteoinfo.math.meteo.MeteoMath;
import org.meteoinfo.shape.CubicShape;
import org.meteoinfo.shape.CylinderShape;
import org.meteoinfo.shape.Graphic;
import org.meteoinfo.shape.ImageShape;
import org.meteoinfo.shape.PointZ;
import org.meteoinfo.shape.PointZShape;
import org.meteoinfo.shape.PolygonZ;
import org.meteoinfo.shape.PolygonZShape;
import org.meteoinfo.shape.Polyline;
import org.meteoinfo.shape.PolylineZShape;
import org.meteoinfo.shape.Shape;
import org.meteoinfo.shape.ShapeTypes;
import org.meteoinfo.shape.WindArrow3D;

public class Plot3DGL
extends Plot
implements GLEventListener {
    private GLAutoDrawable drawable;
    private BufferedImage screenImage;
    private final GLU glu = new GLU();
    private final GraphicCollection3D graphics;
    private Extent3D extent;
    private ChartText title;
    private List<ChartLegend> legends;
    private final Axis xAxis;
    private final Axis yAxis;
    private final Axis zAxis;
    private float xmin;
    private float xmax = 1.0f;
    private float ymin;
    private float ymax = 1.0f;
    private float zmin;
    private float zmax = 1.0f;
    private Color boxColor = Color.getHSBColor(0.0f, 0.0f, 0.95f);
    private Color lineboxColor = Color.getHSBColor(0.0f, 0.0f, 0.8f);
    private boolean boxed;
    private boolean mesh;
    private boolean scaleBox;
    private boolean displayXY;
    private boolean displayZ;
    private boolean displayGrids;
    private boolean drawBoundingBox;
    private boolean hideOnDrag;
    int[] viewport = new int[4];
    float[] mvmatrix = new float[16];
    float[] projmatrix = new float[16];
    private float angleX = -45.0f;
    private float angleY = 45.0f;
    private float distanceX = 0.0f;
    private float distanceY = 0.0f;
    tessellCallBack tessCallback;
    private int width;
    private int height;
    float tickSpace = 5.0f;
    float tickLen = 0.08f;
    private Lighting lighting = new Lighting();
    private boolean antialias;

    public Plot3DGL() {
        this.legends = new ArrayList<ChartLegend>();
        this.xAxis = new Axis();
        this.xAxis.setLabel("X");
        this.xAxis.setTickLength(8);
        this.yAxis = new Axis();
        this.yAxis.setLabel("Y");
        this.yAxis.setTickLength(8);
        this.zAxis = new Axis();
        this.zAxis.setLabel("Z");
        this.zAxis.setTickLength(8);
        this.graphics = new GraphicCollection3D();
        this.hideOnDrag = false;
        this.boxed = true;
        this.displayGrids = false;
        this.displayXY = true;
        this.displayZ = true;
        this.drawBoundingBox = false;
        this.antialias = false;
    }

    public GLAutoDrawable getDrawable() {
        return this.drawable;
    }

    public BufferedImage getScreenImage() {
        return this.screenImage;
    }

    public Extent3D getExtent() {
        return this.extent;
    }

    public void setExtent(Extent3D value) {
        this.extent = value;
        this.xmin = (float)this.extent.minX;
        this.xmax = (float)this.extent.maxX;
        this.ymin = (float)this.extent.minY;
        this.ymax = (float)this.extent.maxY;
        this.zmin = (float)this.extent.minZ;
        this.zmax = (float)this.extent.maxZ;
        this.xAxis.setMinMaxValue(this.xmin, this.xmax);
        this.yAxis.setMinMaxValue(this.ymin, this.ymax);
        this.zAxis.setMinMaxValue(this.zmin, this.zmax);
    }

    public Color getBoxColor() {
        return this.boxColor;
    }

    public void setBoxColor(Color value) {
        this.boxColor = value;
    }

    public Color getLineBoxColor() {
        return this.lineboxColor;
    }

    public void setLineBoxColor(Color value) {
        this.lineboxColor = value;
    }

    public boolean isDrawBoundingBox() {
        return this.drawBoundingBox;
    }

    public void setDrawBoundingBox(boolean value) {
        this.drawBoundingBox = value;
    }

    public void setDisplayXY(boolean value) {
        this.displayXY = value;
    }

    public void setDisplayZ(boolean value) {
        this.displayZ = value;
    }

    public void setDisplayGrids(boolean value) {
        this.displayGrids = value;
    }

    public void setBoxed(boolean value) {
        this.boxed = value;
    }

    public float getAngleX() {
        return this.angleX;
    }

    public void setAngleX(float value) {
        this.angleX = value;
    }

    public float getAngleY() {
        return this.angleY;
    }

    public void setAngleY(float value) {
        this.angleY = value;
    }

    public ChartText getTitle() {
        return this.title;
    }

    public void setTitle(ChartText value) {
        this.title = value;
    }

    public void setTitle(String text) {
        if (this.title == null) {
            this.title = new ChartText(text);
        } else {
            this.title.setText(text);
        }
    }

    public List<ChartLegend> getLegends() {
        return this.legends;
    }

    public ChartLegend getLegend(int idx) {
        if (this.legends.isEmpty()) {
            return null;
        }
        return this.legends.get(idx);
    }

    public ChartLegend getLegend() {
        if (this.legends.isEmpty()) {
            return null;
        }
        return this.legends.get(this.legends.size() - 1);
    }

    public void setLegend(ChartLegend value) {
        this.legends.clear();
        this.legends.add(value);
    }

    public void setLegends(List<ChartLegend> value) {
        this.legends = value;
    }

    public Axis getXAxis() {
        return this.xAxis;
    }

    public Axis getYAxis() {
        return this.yAxis;
    }

    public Axis getZAxis() {
        return this.zAxis;
    }

    public float getXMin() {
        return this.xmin;
    }

    public void setXMin(float value) {
        this.xmin = value;
        this.updateExtent();
        this.xAxis.setMinMaxValue(this.xmin, this.xmax);
    }

    public float getXMax() {
        return this.xmax;
    }

    public void setXMax(float value) {
        this.xmax = value;
        this.updateExtent();
        this.xAxis.setMinMaxValue(this.xmin, this.xmax);
    }

    public void setXMinMax(float min, float max) {
        this.xmin = min;
        this.xmax = max;
        this.updateExtent();
        this.xAxis.setMinMaxValue(min, max);
    }

    public float getYMin() {
        return this.ymin;
    }

    public void setYMin(float value) {
        this.ymin = value;
        this.updateExtent();
        this.yAxis.setMinMaxValue(this.ymin, this.ymax);
    }

    public float getYMax() {
        return this.ymax;
    }

    public void setYMax(float value) {
        this.ymax = value;
        this.updateExtent();
        this.yAxis.setMinMaxValue(this.ymin, this.ymax);
    }

    public void setYMinMax(float min, float max) {
        this.ymin = min;
        this.ymax = max;
        this.updateExtent();
        this.yAxis.setMinMaxValue(min, max);
    }

    public float getZMin() {
        return this.zmin;
    }

    public void setZMin(float value) {
        this.zmin = value;
        this.updateExtent();
        this.zAxis.setMinMaxValue(this.zmin, this.zmax);
    }

    public float getZMax() {
        return this.zmax;
    }

    public void setZMax(float value) {
        this.zmax = value;
        this.updateExtent();
        this.zAxis.setMinMaxValue(this.zmin, this.zmax);
    }

    public void setZMinMax(float min, float max) {
        this.zmin = min;
        this.zmax = max;
        this.updateExtent();
        this.zAxis.setMinMaxValue(min, max);
    }

    public Lighting getLighting() {
        return this.lighting;
    }

    public void setLighting(Lighting value) {
        this.lighting = value;
    }

    public boolean isAntialias() {
        return this.antialias;
    }

    public void setAntialias(boolean value) {
        this.antialias = value;
    }

    public void addLegend(ChartLegend legend) {
        this.legends.clear();
        this.legends.add(legend);
    }

    public void removeLegend(ChartLegend legend) {
        this.legends.remove(legend);
    }

    public void removeLegend(int idx) {
        this.legends.remove(idx);
    }

    @Override
    public Rectangle2D getOuterPositionArea(Rectangle2D area) {
        Rectangle2D rect = this.getOuterPosition();
        double x = area.getWidth() * rect.getX() + area.getX();
        double y = area.getHeight() * (1.0 - rect.getHeight() - rect.getY()) + area.getY();
        double w = area.getWidth() * rect.getWidth();
        double h = area.getHeight() * rect.getHeight();
        return new Rectangle2D.Double(x, y, w, h);
    }

    @Override
    public Dataset getDataset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDataset(Dataset dataset) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PlotType getPlotType() {
        return PlotType.XYZ;
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D area) {
    }

    private void updateExtent() {
        this.extent = new Extent3D(this.xmin, this.xmax, this.ymin, this.ymax, this.zmin, this.zmax);
    }

    public void setAxisTickFont(Font font) {
        this.xAxis.setTickLabelFont(font);
        this.yAxis.setTickLabelFont(font);
        this.zAxis.setTickLabelFont(font);
    }

    public void addGraphic(Graphic g) {
        this.graphics.add(g);
        Extent ex = this.graphics.getExtent();
        if (!ex.is3D()) {
            ex = ex.to3D();
        }
        this.setExtent((Extent3D)ex);
    }

    public void removeGraphic(int idx) {
        this.graphics.remove(idx);
    }

    public void removeLastGraphic() {
        this.graphics.remove(this.graphics.size() - 1);
    }

    public void setAutoExtent() {
    }

    public void display(GLAutoDrawable drawable) {
        Graphic graphic;
        int m;
        GL2 gl = drawable.getGL().getGL2();
        gl.glClear(16640);
        gl.glLoadIdentity();
        gl.glPushMatrix();
        if (this.antialias) {
            gl.glEnable(3042);
            gl.glBlendFunc(770, 771);
            gl.glEnable(2848);
            gl.glHint(3154, 4354);
            gl.glEnable(2832);
            gl.glHint(3153, 4354);
            gl.glEnable(2881);
            gl.glHint(3153, 4354);
        }
        gl.glRotatef(this.angleX, 1.0f, 0.0f, 0.0f);
        gl.glRotatef(this.angleY, 0.0f, 0.0f, 1.0f);
        this.updateMatrix(gl);
        if (this.lighting.isEnable()) {
            this.lighting.start(gl);
            gl.glColorMaterial(1028, 4609);
            gl.glEnable(2903);
        }
        gl.glColor3f(0.0f, 0.0f, 0.0f);
        this.drawBoxGridsTicksLabels(gl);
        this.drawTitle();
        float s = 1.01f;
        gl.glClipPlane(12288, new double[]{1.0, 0.0, 0.0, s}, 0);
        gl.glEnable(12288);
        gl.glClipPlane(12289, new double[]{-1.0, 0.0, 0.0, s}, 0);
        gl.glEnable(12289);
        gl.glClipPlane(12290, new double[]{0.0, -1.0, 0.0, s}, 0);
        gl.glEnable(12290);
        gl.glClipPlane(12291, new double[]{0.0, 1.0, 0.0, s}, 0);
        gl.glEnable(12291);
        gl.glClipPlane(12292, new double[]{0.0, 0.0, 1.0, s}, 0);
        gl.glEnable(12292);
        gl.glClipPlane(12293, new double[]{0.0, 0.0, -1.0, s}, 0);
        gl.glEnable(12293);
        for (m = 0; m < this.graphics.getNumGraphics(); ++m) {
            graphic = this.graphics.get(m);
            this.drawGraphics(gl, graphic);
        }
        gl.glDisable(12288);
        gl.glDisable(12289);
        gl.glDisable(12290);
        gl.glDisable(12291);
        gl.glDisable(12292);
        gl.glDisable(12293);
        for (m = 0; m < this.graphics.getNumGraphics(); ++m) {
            graphic = this.graphics.get(m);
            if (graphic.getNumGraphics() == 1) {
                Shape shape = graphic.getGraphicN(0).getShape();
                if (shape.getShapeType() != ShapeTypes.TEXT) continue;
                this.drawText(gl, (ChartText3D)shape);
                continue;
            }
            for (int i = 0; i < graphic.getNumGraphics(); ++i) {
                Shape shape = graphic.getGraphicN(i).getShape();
                if (shape.getShapeType() != ShapeTypes.TEXT) continue;
                this.drawText(gl, (ChartText3D)shape);
            }
        }
        if (this.lighting.isEnable()) {
            this.lighting.stop(gl);
        }
        gl.glPopMatrix();
        this.updateMatrix(gl);
        this.drawLegend(gl);
        gl.glFlush();
        AWTGLReadBufferUtil glReadBufferUtil = new AWTGLReadBufferUtil(drawable.getGLProfile(), false);
        this.screenImage = glReadBufferUtil.readPixelsToBufferedImage(drawable.getGL(), true);
    }

    private void drawBase(GL2 gl) {
        float[] rgba = this.lineboxColor.getRGBComponents(null);
        gl.glColor3f(rgba[0], rgba[1], rgba[2]);
        gl.glLineWidth(1.0f);
        gl.glBegin(3);
        gl.glVertex3f(-1.0f, 1.0f, -1.0f);
        gl.glVertex3f(-1.0f, -1.0f, -1.0f);
        gl.glVertex3f(1.0f, -1.0f, -1.0f);
        gl.glVertex3f(1.0f, 1.0f, -1.0f);
        gl.glVertex3f(-1.0f, 1.0f, -1.0f);
        gl.glEnd();
    }

    private void updateMatrix(GL2 gl) {
        gl.glGetIntegerv(2978, this.viewport, 0);
        gl.glGetFloatv(2982, this.mvmatrix, 0);
        gl.glGetFloatv(2983, this.projmatrix, 0);
    }

    private float[] toScreen(float vx, float vy, float vz) {
        float[] coord = new float[4];
        this.glu.gluProject(vx, vy, vz, this.mvmatrix, 0, this.projmatrix, 0, this.viewport, 0, coord, 0);
        return coord;
    }

    private float toScreenLength(float x1, float y1, float z1, float x2, float y2, float z2) {
        float[] coord = this.toScreen(x1, y1, z1);
        float sx1 = coord[0];
        float sy1 = coord[1];
        coord = this.toScreen(x2, y2, z2);
        float sx2 = coord[0];
        float sy2 = coord[1];
        return (float)Math.sqrt(Math.pow(sx2 - sx1, 2.0) + Math.pow(sy2 - sy1, 2.0));
    }

    private float toScreenAngle(float x1, float y1, float z1, float x2, float y2, float z2) {
        float[] coord = this.toScreen(x1, y1, z1);
        float sx1 = coord[0];
        float sy1 = coord[1];
        coord = this.toScreen(x2, y2, z2);
        float sx2 = coord[0];
        float sy2 = coord[1];
        return (float)MeteoMath.uv2ds(sx2 - sx1, sy2 - sy1)[0];
    }

    private int getLabelGap(Font font, List<ChartText> labels, double len) {
        TextRenderer textRenderer = new TextRenderer(font);
        int n = labels.size();
        Rectangle2D rect = textRenderer.getBounds("Text".subSequence(0, 4));
        int nn = (int)(len / rect.getHeight());
        if (nn == 0) {
            nn = 1;
        }
        return n / nn + 1;
    }

    private int getLegendTickGap(ChartColorBar legend, double len) {
        if (legend.getTickLabelAngle() != 0.0f) {
            return 1;
        }
        TextRenderer textRenderer = new TextRenderer(legend.getTickLabelFont());
        int n = legend.getLegendScheme().getBreakNum();
        Rectangle2D rect = textRenderer.getBounds("Text".subSequence(0, 4));
        int nn = (int)(len / rect.getHeight());
        if (nn == 0) {
            nn = 1;
        }
        return n / nn + 1;
    }

    private void drawBoxGridsTicksLabels(GL2 gl) {
        float x;
        Rectangle2D rect;
        float v;
        float strWidth;
        YAlign yAlign;
        XAlign xAlign;
        int skip;
        float axisLen;
        List<ChartText> tlabs;
        float y;
        float[] rgba;
        this.drawBase(gl);
        if (this.boxed) {
            if (this.angleY >= 180.0f && this.angleY < 360.0f) {
                rgba = this.lineboxColor.getRGBComponents(null);
                gl.glColor3f(rgba[0], rgba[1], rgba[2]);
                gl.glLineWidth(1.0f);
                gl.glBegin(3);
                gl.glVertex3f(-1.0f, 1.0f, -1.0f);
                gl.glVertex3f(-1.0f, -1.0f, -1.0f);
                gl.glVertex3f(-1.0f, -1.0f, 1.0f);
                gl.glVertex3f(-1.0f, 1.0f, 1.0f);
                gl.glVertex3f(-1.0f, 1.0f, -1.0f);
                gl.glEnd();
            } else {
                rgba = this.lineboxColor.getRGBComponents(null);
                gl.glColor3f(rgba[0], rgba[1], rgba[2]);
                gl.glLineWidth(1.0f);
                gl.glBegin(3);
                gl.glVertex3f(1.0f, 1.0f, -1.0f);
                gl.glVertex3f(1.0f, -1.0f, -1.0f);
                gl.glVertex3f(1.0f, -1.0f, 1.0f);
                gl.glVertex3f(1.0f, 1.0f, 1.0f);
                gl.glVertex3f(1.0f, 1.0f, -1.0f);
                gl.glEnd();
            }
            if (this.angleY >= 90.0f && this.angleY < 270.0f) {
                rgba = this.lineboxColor.getRGBComponents(null);
                gl.glColor3f(rgba[0], rgba[1], rgba[2]);
                gl.glLineWidth(1.0f);
                gl.glBegin(3);
                gl.glVertex3f(-1.0f, -1.0f, -1.0f);
                gl.glVertex3f(1.0f, -1.0f, -1.0f);
                gl.glVertex3f(1.0f, -1.0f, 1.0f);
                gl.glVertex3f(-1.0f, -1.0f, 1.0f);
                gl.glVertex3f(-1.0f, -1.0f, -1.0f);
                gl.glEnd();
            } else {
                rgba = this.lineboxColor.getRGBComponents(null);
                gl.glColor3f(rgba[0], rgba[1], rgba[2]);
                gl.glLineWidth(1.0f);
                gl.glBegin(3);
                gl.glVertex3f(-1.0f, 1.0f, -1.0f);
                gl.glVertex3f(1.0f, 1.0f, -1.0f);
                gl.glVertex3f(1.0f, 1.0f, 1.0f);
                gl.glVertex3f(-1.0f, 1.0f, 1.0f);
                gl.glVertex3f(-1.0f, 1.0f, -1.0f);
                gl.glEnd();
            }
        }
        if (this.displayXY) {
            ChartText label;
            y = this.angleY >= 90.0f && this.angleY < 270.0f ? 1.0f : -1.0f;
            rgba = this.xAxis.getLineColor().getRGBComponents(null);
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            gl.glLineWidth(this.xAxis.getLineWidth());
            gl.glBegin(1);
            gl.glVertex3f(-1.0f, y, -1.0f);
            gl.glVertex3f(1.0f, y, -1.0f);
            gl.glEnd();
            this.xAxis.updateTickLabels();
            tlabs = this.xAxis.getTickLabels();
            axisLen = this.toScreenLength(-1.0f, y, -1.0f, 1.0f, y, -1.0f);
            skip = this.getLabelGap(this.xAxis.getTickLabelFont(), tlabs, axisLen);
            float y1 = y > 0.0f ? y + this.tickLen : y - this.tickLen;
            xAlign = this.angleY < 90.0f || this.angleY >= 180.0f && this.angleY < 270.0f ? XAlign.LEFT : XAlign.RIGHT;
            yAlign = this.angleX > -120.0f ? YAlign.TOP : YAlign.BOTTOM;
            strWidth = 0.0f;
            float strHeight = 0.0f;
            for (int i = 0; i < this.xAxis.getTickValues().length; i += skip) {
                v = (float)this.xAxis.getTickValues()[i];
                if (v < this.xmin || v > this.xmax) continue;
                v = this.transform_xf(v);
                if (i == tlabs.size()) break;
                if (this.displayGrids && v != -1.0f && v != 1.0f) {
                    rgba = this.getLineBoxColor().getRGBComponents(null);
                    gl.glColor3f(rgba[0], rgba[1], rgba[2]);
                    gl.glLineWidth(1.0f);
                    gl.glBegin(1);
                    gl.glVertex3f(v, y, -1.0f);
                    gl.glVertex3f(v, -y, -1.0f);
                    gl.glEnd();
                    if (this.displayZ && this.boxed) {
                        gl.glBegin(1);
                        gl.glVertex3f(v, -y, -1.0f);
                        gl.glVertex3f(v, -y, 1.0f);
                        gl.glEnd();
                    }
                }
                rgba = this.xAxis.getLineColor().getRGBComponents(null);
                gl.glColor3f(rgba[0], rgba[1], rgba[2]);
                gl.glLineWidth(this.xAxis.getLineWidth());
                gl.glBegin(1);
                gl.glVertex3f(v, y, -1.0f);
                gl.glVertex3f(v, y1, -1.0f);
                gl.glEnd();
                rect = this.drawString(gl, tlabs.get(i), v, y1, -1.0f, xAlign, yAlign);
                if ((double)strWidth < rect.getWidth()) {
                    strWidth = (float)rect.getWidth();
                }
                if (!((double)strHeight < rect.getHeight())) continue;
                strHeight = (float)rect.getHeight();
            }
            if ((label = this.xAxis.getLabel()) != null) {
                float angle = this.toScreenAngle(-1.0f, y, -1.0f, 1.0f, y, -1.0f);
                angle = y < 0.0f ? 270.0f - angle : 90.0f - angle;
                float yShift = Math.min(-(strWidth += this.tickSpace), -strWidth);
                if (this.angleX <= -120.0f) {
                    yShift = -yShift;
                }
                this.drawString(gl, label, 0.0f, y1, -1.0f, XAlign.CENTER, yAlign, angle, 0.0f, yShift);
            }
            x = this.angleY >= 180.0f && this.angleY < 360.0f ? 1.0f : -1.0f;
            rgba = this.yAxis.getLineColor().getRGBComponents(null);
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            gl.glLineWidth(this.yAxis.getLineWidth());
            gl.glBegin(1);
            gl.glVertex3f(x, -1.0f, -1.0f);
            gl.glVertex3f(x, 1.0f, -1.0f);
            gl.glEnd();
            this.yAxis.updateTickLabels();
            tlabs = this.yAxis.getTickLabels();
            axisLen = this.toScreenLength(x, -1.0f, -1.0f, x, 1.0f, -1.0f);
            skip = this.getLabelGap(this.yAxis.getTickLabelFont(), tlabs, axisLen);
            float x1 = x > 0.0f ? x + this.tickLen : x - this.tickLen;
            xAlign = this.angleY < 90.0f || this.angleY >= 180.0f && this.angleY < 270.0f ? XAlign.RIGHT : XAlign.LEFT;
            yAlign = this.angleX > -120.0f ? YAlign.TOP : YAlign.BOTTOM;
            strWidth = 0.0f;
            strHeight = 0.0f;
            for (int i = 0; i < this.yAxis.getTickValues().length; i += skip) {
                v = (float)this.yAxis.getTickValues()[i];
                if (v < this.ymin || v > this.ymax) continue;
                v = this.transform_yf(v);
                if (i == tlabs.size()) break;
                if (this.displayGrids && v != -1.0f && v != 1.0f) {
                    rgba = this.getLineBoxColor().getRGBComponents(null);
                    gl.glColor3f(rgba[0], rgba[1], rgba[2]);
                    gl.glLineWidth(1.0f);
                    gl.glBegin(1);
                    gl.glVertex3f(x, v, -1.0f);
                    gl.glVertex3f(-x, v, -1.0f);
                    gl.glEnd();
                    if (this.displayZ && this.boxed) {
                        gl.glBegin(1);
                        gl.glVertex3f(-x, v, -1.0f);
                        gl.glVertex3f(-x, v, 1.0f);
                        gl.glEnd();
                    }
                }
                rgba = this.yAxis.getLineColor().getRGBComponents(null);
                gl.glColor3f(rgba[0], rgba[1], rgba[2]);
                gl.glLineWidth(this.yAxis.getLineWidth());
                gl.glBegin(1);
                gl.glVertex3f(x, v, -1.0f);
                gl.glVertex3f(x1, v, -1.0f);
                gl.glEnd();
                rect = this.drawString(gl, tlabs.get(i), x1, v, -1.0f, xAlign, yAlign);
                if ((double)strWidth < rect.getWidth()) {
                    strWidth = (float)rect.getWidth();
                }
                if (!((double)strHeight < rect.getHeight())) continue;
                strHeight = (float)rect.getHeight();
            }
            if ((label = this.yAxis.getLabel()) != null) {
                float angle = this.toScreenAngle(x, -1.0f, -1.0f, x, 1.0f, -1.0f);
                angle = x > 0.0f ? 270.0f - angle : 90.0f - angle;
                float yShift = Math.min(-(strWidth += this.tickSpace), -strWidth);
                if (this.angleX <= -120.0f) {
                    yShift = -yShift;
                }
                this.drawString(gl, label, x1, 0.0f, -1.0f, XAlign.CENTER, yAlign, angle, 0.0f, yShift);
            }
        }
        if (this.displayZ) {
            ChartText label;
            if (this.angleY < 90.0f) {
                x = -1.0f;
                y = 1.0f;
            } else if (this.angleY < 180.0f) {
                x = 1.0f;
                y = 1.0f;
            } else if (this.angleY < 270.0f) {
                x = 1.0f;
                y = -1.0f;
            } else {
                x = -1.0f;
                y = -1.0f;
            }
            rgba = this.zAxis.getLineColor().getRGBComponents(null);
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            gl.glLineWidth(this.zAxis.getLineWidth());
            gl.glBegin(1);
            gl.glVertex3f(x, y, -1.0f);
            gl.glVertex3f(x, y, 1.0f);
            gl.glEnd();
            this.zAxis.updateTickLabels();
            tlabs = this.zAxis.getTickLabels();
            axisLen = this.toScreenLength(x, y, -1.0f, x, y, 1.0f);
            skip = this.getLabelGap(this.zAxis.getTickLabelFont(), tlabs, axisLen);
            float x1 = x;
            float y1 = y;
            if (x < 0.0f) {
                if (y > 0.0f) {
                    y1 += this.tickLen;
                } else {
                    x1 -= this.tickLen;
                }
            } else if (y > 0.0f) {
                x1 += this.tickLen;
            } else {
                y1 -= this.tickLen;
            }
            xAlign = XAlign.RIGHT;
            yAlign = YAlign.CENTER;
            strWidth = 0.0f;
            for (int i = 0; i < this.zAxis.getTickValues().length; i += skip) {
                v = (float)this.zAxis.getTickValues()[i];
                if (v < this.zmin || v > this.zmax) continue;
                v = this.transform_zf(v);
                if (i == tlabs.size()) break;
                if (this.displayGrids && this.boxed && v != -1.0f && v != 1.0f) {
                    rgba = this.getLineBoxColor().getRGBComponents(null);
                    gl.glColor3f(rgba[0], rgba[1], rgba[2]);
                    gl.glLineWidth(1.0f);
                    gl.glBegin(3);
                    gl.glVertex3f(x, y, v);
                    if (x < 0.0f) {
                        if (y > 0.0f) {
                            gl.glVertex3f(-x, y, v);
                            gl.glVertex3f(-x, -y, v);
                        } else {
                            gl.glVertex3f(x, -y, v);
                            gl.glVertex3f(-x, -y, v);
                        }
                    } else if (y > 0.0f) {
                        gl.glVertex3f(x, -y, v);
                        gl.glVertex3f(-x, -y, v);
                    } else {
                        gl.glVertex3f(-x, y, v);
                        gl.glVertex3f(-x, -y, v);
                    }
                    gl.glEnd();
                }
                rgba = this.zAxis.getLineColor().getRGBComponents(null);
                gl.glColor3f(rgba[0], rgba[1], rgba[2]);
                gl.glLineWidth(this.zAxis.getLineWidth());
                gl.glBegin(1);
                gl.glVertex3f(x, y, v);
                gl.glVertex3f(x1, y1, v);
                gl.glEnd();
                rect = this.drawString(gl, tlabs.get(i), x1, y1, v, xAlign, yAlign, -this.tickSpace, 0.0f);
                if (!((double)strWidth < rect.getWidth())) continue;
                strWidth = (float)rect.getWidth();
            }
            if ((label = this.zAxis.getLabel()) != null) {
                float yShift = strWidth + this.tickSpace * 3.0f;
                this.drawString(gl, label, x1, y1, 0.0f, XAlign.CENTER, YAlign.BOTTOM, 90.0f, 0.0f, yShift);
            }
        }
    }

    Rectangle2D drawString(GL2 gl, ChartText text, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign) {
        return this.drawString(gl, text, vx, vy, vz, xAlign, yAlign, 0.0f, 0.0f);
    }

    Rectangle2D drawString(GL2 gl, ChartText text, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign, float xShift, float yShift) {
        return this.drawString(gl, text.getText(), text.getFont(), text.getColor(), vx, vy, vz, xAlign, yAlign, xShift, yShift);
    }

    Rectangle2D drawString(GL2 gl, String str, Font font, Color color, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign) {
        return this.drawString(gl, str, font, color, vx, vy, vz, xAlign, yAlign, 0.0f, 0.0f);
    }

    Rectangle2D drawString(GL2 gl, String str, Font font, Color color, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign, float xShift, float yShift) {
        float[] coord = this.toScreen(vx, vy, vz);
        float x = coord[0];
        float y = coord[1];
        TextRenderer textRenderer = new TextRenderer(font, true);
        textRenderer.beginRendering(this.width, this.height);
        textRenderer.setColor(color);
        textRenderer.setSmoothing(true);
        Rectangle2D rect = textRenderer.getBounds(str.subSequence(0, str.length()));
        switch (xAlign) {
            case CENTER: {
                x = (float)((double)x - rect.getWidth() * 0.5);
                break;
            }
            case RIGHT: {
                x = (float)((double)x - rect.getWidth());
            }
        }
        switch (yAlign) {
            case CENTER: {
                y = (float)((double)y - rect.getHeight() * 0.5);
                break;
            }
            case TOP: {
                y = (float)((double)y - rect.getHeight());
            }
        }
        textRenderer.draw(str, (int)(x + xShift), (int)(y + yShift));
        textRenderer.endRendering();
        return rect;
    }

    Rectangle2D drawString(GL2 gl, ChartText text, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign, float angle) {
        return this.drawString(gl, text.getText(), text.getFont(), text.getColor(), vx, vy, vz, xAlign, yAlign, angle, 0.0f, 0.0f);
    }

    Rectangle2D drawString(GL2 gl, ChartText text, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign, float angle, float xShift, float yShift) {
        return this.drawString(gl, text.getText(), text.getFont(), text.getColor(), vx, vy, vz, xAlign, yAlign, angle, xShift, yShift);
    }

    Rectangle2D drawString(GL2 gl, String str, Font font, Color color, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign, float angle) {
        return this.drawString(gl, str, font, color, vx, vy, vz, xAlign, yAlign, angle, 0.0f, 0.0f);
    }

    Rectangle2D drawString(GL2 gl, String str, Font font, Color color, float vx, float vy, float vz, XAlign xAlign, YAlign yAlign, float angle, float xShift, float yShift) {
        float[] coord = this.toScreen(vx, vy, vz);
        float x = coord[0];
        float y = coord[1];
        TextRenderer textRenderer = new TextRenderer(font, true);
        textRenderer.beginRendering(this.width, this.height);
        textRenderer.setColor(color);
        textRenderer.setSmoothing(true);
        Rectangle2D rect = textRenderer.getBounds(str.subSequence(0, str.length()));
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glTranslatef(x, y, 0.0f);
        if (angle != 0.0f) {
            gl.glRotatef(angle, 0.0f, 0.0f, 1.0f);
        }
        x = 0.0f;
        y = 0.0f;
        switch (xAlign) {
            case CENTER: {
                x = (float)((double)x - rect.getWidth() * 0.5);
                break;
            }
            case RIGHT: {
                x = (float)((double)x - rect.getWidth());
            }
        }
        switch (yAlign) {
            case CENTER: {
                y = (float)((double)y - rect.getHeight() * 0.5);
                break;
            }
            case TOP: {
                y = (float)((double)y - rect.getHeight());
            }
        }
        textRenderer.draw(str, (int)(x += xShift), (int)(y += yShift));
        textRenderer.endRendering();
        gl.glPopMatrix();
        return rect;
    }

    void drawTitle() {
        if (this.title != null) {
            TextRenderer textRenderer = new TextRenderer(this.title.getFont(), true);
            textRenderer.beginRendering(this.width, this.height);
            textRenderer.setColor(this.title.getColor());
            textRenderer.setSmoothing(true);
            Rectangle2D rect = textRenderer.getBounds(this.title.getText().subSequence(0, this.title.getText().length()));
            float x = (float)this.width / 2.0f - (float)rect.getWidth() / 2.0f;
            float y = (float)this.height - (float)rect.getHeight();
            textRenderer.draw(this.title.getText(), (int)x, (int)y);
            textRenderer.endRendering();
        }
    }

    private void drawGraphics(GL2 gl, Graphic graphic) {
        if (graphic.getNumGraphics() == 1) {
            Graphic gg = graphic.getGraphicN(0);
            this.drawGraphic(gl, gg);
        } else if (graphic instanceof SurfaceGraphics) {
            this.drawSurface(gl, (SurfaceGraphics)graphic);
        } else if (graphic instanceof IsosurfaceGraphics) {
            this.drawIsosurface(gl, (IsosurfaceGraphics)graphic);
        } else {
            boolean isDraw = true;
            if (graphic instanceof GraphicCollection3D) {
                GraphicCollection3D gg = (GraphicCollection3D)graphic;
                if (gg.isAllQuads()) {
                    this.drawQuadsPolygons(gl, gg);
                    isDraw = false;
                } else if (gg.isAllTriangle()) {
                    this.drawTrianglePolygons(gl, gg);
                    isDraw = false;
                }
            }
            if (isDraw) {
                for (int i = 0; i < graphic.getNumGraphics(); ++i) {
                    Graphic gg = graphic.getGraphicN(i);
                    this.drawGraphic(gl, gg);
                }
            }
        }
    }

    private void drawGraphic(GL2 gl, Graphic graphic) {
        Shape shape = graphic.getGraphicN(0).getShape();
        switch (shape.getShapeType()) {
            case Point: 
            case PointZ: {
                this.drawPoint(gl, graphic);
                break;
            }
            case TEXT: {
                break;
            }
            case Polyline: 
            case PolylineZ: {
                this.drawLineString(gl, graphic);
                break;
            }
            case Polygon: 
            case PolygonZ: {
                this.drawPolygonShape(gl, graphic);
                break;
            }
            case WindArraw: {
                this.drawWindArrow(gl, graphic);
                break;
            }
            case CUBIC: {
                this.drawCubic(gl, graphic);
                break;
            }
            case CYLINDER: {
                this.drawCylinder(gl, graphic);
                break;
            }
            case Image: {
                this.drawImage(gl, graphic);
                break;
            }
            case TEXTURE: {
                this.drawTexture(gl, graphic);
            }
        }
    }

    private void drawText(GL2 gl, ChartText3D text) {
        float x = this.transform_xf((float)text.getX());
        float y = this.transform_yf((float)text.getY());
        float z = this.transform_zf((float)text.getZ());
        this.drawString(gl, text, x, y, z, text.getXAlign(), text.getYAlign());
    }

    private void drawPoint(GL2 gl, Graphic graphic) {
        if (this.extent.intersects(graphic.getExtent())) {
            PointZShape shape = (PointZShape)graphic.getShape();
            PointBreak pb = (PointBreak)graphic.getLegend();
            float[] rgba = pb.getColor().getRGBComponents(null);
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            gl.glPointSize(pb.getSize());
            gl.glBegin(0);
            PointZ p = (PointZ)shape.getPoint();
            gl.glVertex3f(this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z));
            gl.glEnd();
        }
    }

    private void drawLineString(GL2 gl, Graphic graphic) {
        if (this.extent.intersects(graphic.getExtent())) {
            PolylineZShape shape = (PolylineZShape)graphic.getShape();
            ColorBreak cb = graphic.getLegend();
            if (cb.getBreakType() == BreakTypes.ColorBreakCollection) {
                ColorBreakCollection cbc = (ColorBreakCollection)cb;
                Polyline line = shape.getPolylines().get(0);
                List<? extends PointD> ps = line.getPointList();
                gl.glBegin(3);
                for (int i = 0; i < ps.size(); ++i) {
                    PolylineBreak polylineBreak = (PolylineBreak)cbc.get(i);
                    float[] fArray = polylineBreak.getColor().getRGBComponents(null);
                    gl.glColor3f(fArray[0], fArray[1], fArray[2]);
                    gl.glLineWidth(polylineBreak.getWidth());
                    PointZ p = (PointZ)ps.get(i);
                    gl.glVertex3f(this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z));
                }
                gl.glEnd();
            } else {
                PolylineBreak pb = (PolylineBreak)cb;
                float[] rgba = pb.getColor().getRGBComponents(null);
                gl.glColor3f(rgba[0], rgba[1], rgba[2]);
                gl.glLineWidth(pb.getWidth());
                gl.glBegin(3);
                for (Polyline polyline : shape.getPolylines()) {
                    List<? extends PointD> ps = polyline.getPointList();
                    for (PointZ pointZ : ps) {
                        gl.glVertex3f(this.transform_xf((float)pointZ.X), this.transform_yf((float)pointZ.Y), this.transform_zf((float)pointZ.Z));
                    }
                }
                gl.glEnd();
            }
        }
    }

    private void drawPolygonShape(GL2 gl, Graphic graphic) {
        if (this.extent.intersects(graphic.getExtent())) {
            PolygonZShape shape = (PolygonZShape)graphic.getShape();
            PolygonBreak pb = (PolygonBreak)graphic.getLegend();
            for (PolygonZ polygonZ : shape.getPolygons()) {
                if (GeometryUtil.isConvex(polygonZ)) {
                    this.drawConvexPolygon(gl, polygonZ, pb);
                    continue;
                }
                this.drawPolygon(gl, polygonZ, pb);
            }
        }
    }

    private void drawPolygon(GL2 gl, PolygonZ aPG, PolygonBreak aPGB) {
        PointZ p;
        float[] rgba;
        if (aPGB.isDrawFill() && aPGB.getColor().getAlpha() > 0) {
            gl.glEnable(32823);
            gl.glPolygonOffset(1.0f, 1.0f);
            rgba = aPGB.getColor().getRGBComponents(null);
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            try {
                double[] v;
                int i;
                GLUtessellator tobj = GLU.gluNewTess();
                GLU.gluTessCallback((GLUtessellator)tobj, (int)100101, (GLUtessellatorCallback)this.tessCallback);
                GLU.gluTessCallback((GLUtessellator)tobj, (int)100105, (GLUtessellatorCallback)this.tessCallback);
                GLU.gluTessCallback((GLUtessellator)tobj, (int)100100, (GLUtessellatorCallback)this.tessCallback);
                GLU.gluTessCallback((GLUtessellator)tobj, (int)100102, (GLUtessellatorCallback)this.tessCallback);
                GLU.gluTessCallback((GLUtessellator)tobj, (int)100103, (GLUtessellatorCallback)this.tessCallback);
                GLU.gluTessBeginPolygon((GLUtessellator)tobj, null);
                GLU.gluTessBeginContour((GLUtessellator)tobj);
                for (i = 0; i < aPG.getOutLine().size() - 1; ++i) {
                    p = (PointZ)aPG.getOutLine().get(i);
                    v = this.transform(p);
                    GLU.gluTessVertex((GLUtessellator)tobj, (double[])v, (int)0, (Object)v);
                }
                GLU.gluTessEndContour((GLUtessellator)tobj);
                if (aPG.hasHole()) {
                    for (i = 0; i < aPG.getHoleLineNumber(); ++i) {
                        GLU.gluTessBeginContour((GLUtessellator)tobj);
                        for (int j = 0; j < aPG.getHoleLine(i).size() - 1; ++j) {
                            p = (PointZ)aPG.getHoleLine(i).get(j);
                            v = this.transform(p);
                            GLU.gluTessVertex((GLUtessellator)tobj, (double[])v, (int)0, (Object)v);
                        }
                        GLU.gluTessEndContour((GLUtessellator)tobj);
                    }
                }
                GLU.gluTessEndPolygon((GLUtessellator)tobj);
                GLU.gluDeleteTess((GLUtessellator)tobj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (aPGB.isDrawOutline()) {
            rgba = aPGB.getOutlineColor().getRGBComponents(null);
            gl.glLineWidth(aPGB.getOutlineSize());
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            gl.glBegin(3);
            for (int i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f(this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z));
            }
            gl.glEnd();
            if (aPG.hasHole()) {
                gl.glBegin(3);
                for (int h = 0; h < aPG.getHoleLines().size(); ++h) {
                    List<? extends PointD> newPList = aPG.getHoleLines().get(h);
                    for (int j = 0; j < newPList.size(); ++j) {
                        p = (PointZ)newPList.get(j);
                        gl.glVertex3f(this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z));
                    }
                }
                gl.glEnd();
            }
            gl.glDisable(32823);
        }
    }

    private void drawConvexPolygon(GL2 gl, PolygonZ aPG, PolygonBreak aPGB) {
        PointZ p;
        int i;
        float[] rgba;
        if (aPGB.isDrawFill()) {
            rgba = aPGB.getColor().getRGBComponents(null);
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            gl.glBegin(9);
            for (i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f(this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z));
            }
            gl.glEnd();
        }
        if (aPGB.isDrawOutline()) {
            rgba = aPGB.getOutlineColor().getRGBComponents(null);
            gl.glLineWidth(aPGB.getOutlineSize());
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            gl.glBegin(3);
            for (i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f(this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z));
            }
            gl.glEnd();
        }
    }

    private void drawQuadsPolygons(GL2 gl, GraphicCollection3D graphic) {
        for (int i = 0; i < graphic.getNumGraphics(); ++i) {
            Graphic gg = graphic.getGraphicN(i);
            if (!this.extent.intersects(gg.getExtent())) continue;
            PolygonZShape shape = (PolygonZShape)gg.getShape();
            PolygonBreak pb = (PolygonBreak)gg.getLegend();
            for (PolygonZ polygonZ : shape.getPolygons()) {
                this.drawQuads(gl, polygonZ, pb);
            }
        }
    }

    private void drawQuads(GL2 gl, PolygonZ aPG, PolygonBreak aPGB) {
        PointZ p;
        int i;
        float[] rgba = aPGB.getColor().getRGBComponents(null);
        if (aPGB.isDrawFill()) {
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            gl.glBegin(7);
            for (i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f(this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z));
            }
            gl.glEnd();
        }
        if (aPGB.isDrawOutline()) {
            rgba = aPGB.getOutlineColor().getRGBComponents(null);
            gl.glLineWidth(aPGB.getOutlineSize());
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            gl.glBegin(3);
            for (i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f(this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z));
            }
            gl.glEnd();
        }
    }

    private void drawTrianglePolygons(GL2 gl, GraphicCollection3D graphic) {
        for (int i = 0; i < graphic.getNumGraphics(); ++i) {
            Graphic gg = graphic.getGraphicN(i);
            if (!this.extent.intersects(gg.getExtent())) continue;
            PolygonZShape shape = (PolygonZShape)gg.getShape();
            PolygonBreak pb = (PolygonBreak)gg.getLegend();
            for (PolygonZ polygonZ : shape.getPolygons()) {
                this.drawTriangle(gl, polygonZ, pb);
            }
        }
    }

    private void drawTriangle(GL2 gl, PolygonZ aPG, PolygonBreak aPGB) {
        PointZ p;
        int i;
        float[] rgba = aPGB.getColor().getRGBComponents(null);
        if (aPGB.isDrawFill()) {
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            gl.glBegin(4);
            for (i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f(this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z));
            }
            gl.glEnd();
        }
        if (aPGB.isDrawOutline()) {
            rgba = aPGB.getOutlineColor().getRGBComponents(null);
            gl.glLineWidth(aPGB.getOutlineSize());
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            gl.glBegin(3);
            for (i = 0; i < aPG.getOutLine().size(); ++i) {
                p = (PointZ)aPG.getOutLine().get(i);
                gl.glVertex3f(this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z));
            }
            gl.glEnd();
        }
    }

    private void drawTriangle(GL2 gl, PointZ[] points, PolygonBreak aPGB) {
        PointZ p;
        int i;
        float[] rgba = aPGB.getColor().getRGBComponents(null);
        if (aPGB.isDrawFill()) {
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glBegin(4);
            for (i = 0; i < 3; ++i) {
                p = points[i];
                gl.glVertex3f(this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z));
            }
            gl.glEnd();
        }
        if (aPGB.isDrawOutline()) {
            rgba = aPGB.getOutlineColor().getRGBComponents(null);
            gl.glLineWidth(aPGB.getOutlineSize());
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            gl.glBegin(3);
            for (i = 0; i < 3; ++i) {
                p = points[i];
                gl.glVertex3f(this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z));
            }
            gl.glEnd();
        }
    }

    private void drawSurface(GL2 gl, SurfaceGraphics surface) {
        float[] rgba;
        PointZ p;
        int j;
        int i;
        PolygonBreak pgb = (PolygonBreak)surface.getLegendBreak(0, 0);
        int dim1 = surface.getDim1();
        int dim2 = surface.getDim2();
        if (pgb.isDrawFill()) {
            gl.glEnable(32823);
            gl.glPolygonOffset(1.0f, 1.0f);
            for (i = 0; i < dim1 - 1; ++i) {
                for (j = 0; j < dim2 - 1; ++j) {
                    gl.glBegin(7);
                    p = surface.getVertex(i, j);
                    rgba = surface.getRGBA(i, j);
                    gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
                    gl.glVertex3f(this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z));
                    p = surface.getVertex(i + 1, j);
                    rgba = surface.getRGBA(i + 1, j);
                    gl.glColor3f(rgba[0], rgba[1], rgba[2]);
                    gl.glVertex3f(this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z));
                    p = surface.getVertex(i + 1, j + 1);
                    rgba = surface.getRGBA(i + 1, j + 1);
                    gl.glColor3f(rgba[0], rgba[1], rgba[2]);
                    gl.glVertex3f(this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z));
                    p = surface.getVertex(i, j + 1);
                    rgba = surface.getRGBA(i, j + 1);
                    gl.glColor3f(rgba[0], rgba[1], rgba[2]);
                    gl.glVertex3f(this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z));
                    gl.glEnd();
                }
            }
            gl.glDisable(32823);
        }
        if (pgb.isDrawOutline()) {
            rgba = pgb.getOutlineColor().getRGBComponents(null);
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            gl.glLineWidth(pgb.getOutlineSize());
            for (i = 0; i < dim1; ++i) {
                gl.glBegin(3);
                for (j = 0; j < dim2; ++j) {
                    p = surface.getVertex(i, j);
                    gl.glVertex3f(this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z));
                }
                gl.glEnd();
            }
            for (int j2 = 0; j2 < dim2; ++j2) {
                gl.glBegin(3);
                for (int i2 = 0; i2 < dim1; ++i2) {
                    p = surface.getVertex(i2, j2);
                    gl.glVertex3f(this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z));
                }
                gl.glEnd();
            }
        }
    }

    private void drawIsosurface(GL2 gl, IsosurfaceGraphics isosurface) {
        List<PointZ[]> triangles = isosurface.getTriangles();
        PolygonBreak pgb = (PolygonBreak)isosurface.getLegendBreak();
        for (PointZ[] triangle : triangles) {
            this.drawTriangle(gl, triangle, pgb);
        }
    }

    private void drawImage(GL2 gl, Graphic graphic) {
        ImageShape ishape = (ImageShape)graphic.getShape();
        BufferedImage image = ishape.getImage();
        Texture texture = AWTTextureIO.newTexture((GLProfile)gl.getGLProfile(), (BufferedImage)image, (boolean)true);
        int idTexture = texture.getTextureObject();
        List<PointZ> coords = ishape.getCoords();
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        gl.glBindTexture(3553, idTexture);
        gl.glTexParameteri(3553, 10241, 9728);
        gl.glTexParameteri(3553, 10240, 9729);
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3f(this.transform_xf((float)coords.get((int)0).X), this.transform_yf((float)coords.get((int)0).Y), this.transform_zf((float)coords.get((int)0).Z));
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3f(this.transform_xf((float)coords.get((int)1).X), this.transform_yf((float)coords.get((int)1).Y), this.transform_zf((float)coords.get((int)1).Z));
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3f(this.transform_xf((float)coords.get((int)2).X), this.transform_yf((float)coords.get((int)2).Y), this.transform_zf((float)coords.get((int)2).Z));
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3f(this.transform_xf((float)coords.get((int)3).X), this.transform_yf((float)coords.get((int)3).Y), this.transform_zf((float)coords.get((int)3).Z));
        gl.glEnd();
        gl.glBindTexture(3553, 0);
    }

    private void drawImage(GL2 gl) throws IOException {
        File im = new File("D:\\Temp\\image\\lenna.jpg ");
        BufferedImage image = ImageIO.read(im);
        Texture t = AWTTextureIO.newTexture((GLProfile)gl.getGLProfile(), (BufferedImage)image, (boolean)true);
        int idTexture = t.getTextureObject((GL)gl);
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        gl.glBindTexture(3553, idTexture);
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3f(-1.0f, -1.0f, 1.0f);
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3f(1.0f, -1.0f, 1.0f);
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3f(1.0f, 1.0f, 1.0f);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3f(-1.0f, 1.0f, 1.0f);
        gl.glEnd();
        gl.glBindTexture(3553, 0);
    }

    private void drawTexture(GL2 gl, Graphic graphic) {
        TextureShape ishape = (TextureShape)graphic.getShape();
        Texture texture = ishape.getTexture();
        if (texture == null) {
            try {
                ishape.loadTexture();
                texture = ishape.getTexture();
            }
            catch (IOException ex) {
                Logger.getLogger(Plot3DGL.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (texture == null) {
            return;
        }
        int idTexture = texture.getTextureObject();
        List<PointZ> coords = ishape.getCoords();
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        gl.glBindTexture(3553, idTexture);
        gl.glTexParameteri(3553, 10241, 9987);
        gl.glTexParameteri(3553, 10240, 9729);
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3f(this.transform_xf((float)coords.get((int)0).X), this.transform_yf((float)coords.get((int)0).Y), this.transform_zf((float)coords.get((int)0).Z));
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3f(this.transform_xf((float)coords.get((int)1).X), this.transform_yf((float)coords.get((int)1).Y), this.transform_zf((float)coords.get((int)1).Z));
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3f(this.transform_xf((float)coords.get((int)2).X), this.transform_yf((float)coords.get((int)2).Y), this.transform_zf((float)coords.get((int)2).Z));
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3f(this.transform_xf((float)coords.get((int)3).X), this.transform_yf((float)coords.get((int)3).Y), this.transform_zf((float)coords.get((int)3).Z));
        gl.glEnd();
        gl.glBindTexture(3553, 0);
    }

    void drawWindArrow(GL2 gl, Graphic graphic) {
        if (this.extent.intersects(graphic.getExtent())) {
            WindArrow3D shape = (WindArrow3D)graphic.getShape();
            PointBreak pb = (PointBreak)graphic.getLegend();
            PointZ sp = (PointZ)shape.getPoint();
            PointZ ep = shape.getEndPoint();
            float x1 = this.transform_xf((float)sp.X);
            float y1 = this.transform_yf((float)sp.Y);
            float z1 = this.transform_zf((float)sp.Z);
            float x2 = this.transform_xf((float)ep.X);
            float y2 = this.transform_yf((float)ep.Y);
            float z2 = this.transform_zf((float)ep.Z);
            gl.glPushMatrix();
            gl.glPushAttrib(8);
            gl.glDisable(2884);
            float[] rgba = pb.getColor().getRGBComponents(null);
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            gl.glLineWidth(pb.getOutlineSize());
            gl.glBegin(1);
            gl.glVertex3f(x1, y1, z1);
            gl.glVertex3f(x2, y2, z2);
            gl.glEnd();
            float[] v = new float[]{x2 - x1, y2 - y1, z2 - z1};
            float norm_of_v = (float)Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
            float coneRadius = 0.05f;
            float coneHgt = coneRadius * 0.4f;
            float[] vConeLocation = new float[]{x1, y1, z1};
            float[] mat44 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
            float[] dVec = new float[]{v[0], v[1], v[2]};
            float[] norm_startVec = VectorUtil.normalizeVec3((float[])dVec);
            float[] zaxis = new float[]{0.0f, 0.0f, 1.0f};
            float[] norm_endVec = VectorUtil.normalizeVec3((float[])zaxis);
            if (Float.isNaN(norm_endVec[0]) || Float.isNaN(norm_endVec[1]) || Float.isNaN(norm_endVec[2])) {
                norm_endVec[0] = 0.0f;
                norm_endVec[1] = 0.0f;
                norm_endVec[2] = 0.0f;
            }
            if ((double)(norm_startVec[0] - norm_endVec[0]) > 1.0E-14 && (double)(norm_startVec[1] - norm_endVec[1]) > 1.0E-14 && (double)(norm_startVec[2] - norm_endVec[2]) > 1.0E-14) {
                mat44[0] = 1.0f;
                mat44[5] = 1.0f;
                mat44[10] = 1.0f;
                mat44[15] = 1.0f;
            } else {
                float[] axb = new float[3];
                VectorUtil.crossVec3((float[])axb, (float[])norm_startVec, (float[])norm_endVec);
                float[] norm_axb = VectorUtil.normalizeVec3((float[])axb);
                if (Float.isNaN(norm_axb[0]) || Float.isNaN(norm_axb[1]) || Float.isNaN(norm_axb[2])) {
                    norm_axb[0] = 0.0f;
                    norm_axb[1] = 0.0f;
                    norm_axb[2] = 0.0f;
                }
                float ac = (float)Math.acos(VectorUtil.dotVec3((float[])norm_startVec, (float[])norm_endVec));
                float s = (float)Math.sin(ac);
                float c = (float)Math.cos(ac);
                float t = 1.0f - c;
                float x = norm_axb[0];
                float y = norm_axb[1];
                float z = norm_axb[2];
                mat44[0] = t * x * x + c;
                mat44[1] = t * x * y - s * z;
                mat44[2] = t * x * z + s * y;
                mat44[4] = t * x * y + s * z;
                mat44[5] = t * y * y + c;
                mat44[6] = t * y * z - s * x;
                mat44[8] = t * x * z - s * y;
                mat44[9] = t * y * z + s * x;
                mat44[10] = t * z * z + c;
                mat44[15] = 1.0f;
            }
            gl.glTranslatef(vConeLocation[0], vConeLocation[1], vConeLocation[2]);
            gl.glMultMatrixf(mat44, 0);
            GLUquadric cone_obj = this.glu.gluNewQuadric();
            this.glu.gluCylinder(cone_obj, 0.0, (double)coneHgt, (double)coneRadius, 8, 1);
            gl.glPopAttrib();
            gl.glPopMatrix();
        }
    }

    void drawCircle(GL2 gl, float z, float radius, PolygonBreak bb) {
        int i;
        double angle;
        float[] rgba;
        int points = 100;
        if (bb.isDrawFill()) {
            rgba = bb.getColor().getRGBColorComponents(null);
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            gl.glBegin(6);
            angle = 0.0;
            for (i = 0; i < points; ++i) {
                angle = Math.PI * 2 * (double)i / (double)points;
                gl.glVertex3f((float)Math.cos(angle) * radius, (float)Math.sin(angle) * radius, z);
            }
            gl.glEnd();
        }
        if (bb.isDrawOutline()) {
            rgba = bb.getOutlineColor().getRGBColorComponents(null);
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            gl.glLineWidth(bb.getOutlineSize());
            gl.glBegin(2);
            angle = 0.0;
            for (i = 0; i < points; ++i) {
                angle = Math.PI * 2 * (double)i / (double)points;
                gl.glVertex3f((float)Math.cos(angle) * radius, (float)Math.sin(angle) * radius, z);
            }
            gl.glEnd();
        }
    }

    void drawCubic(GL2 gl, Graphic graphic) {
        if (this.extent.intersects(graphic.getExtent())) {
            int[] ii;
            int n;
            CubicShape cubic = (CubicShape)graphic.getShape();
            BarBreak bb = (BarBreak)graphic.getLegend();
            List<PointZ> ps = cubic.getPoints();
            ArrayList<float[]> vertex = new ArrayList<float[]>();
            for (PointZ p : ps) {
                vertex.add(new float[]{this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z)});
            }
            gl.glEnable(32823);
            gl.glPolygonOffset(1.0f, 1.0f);
            int[][] index = cubic.getIndex();
            float[] rgba = bb.getColor().getRGBComponents(null);
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            gl.glBegin(7);
            int[][] nArray = index;
            int n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                for (int i : ii = nArray[n]) {
                    gl.glVertex3f(((float[])vertex.get(i))[0], ((float[])vertex.get(i))[1], ((float[])vertex.get(i))[2]);
                }
            }
            gl.glEnd();
            gl.glDisable(32823);
            rgba = bb.getOutlineColor().getRGBColorComponents(null);
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            gl.glLineWidth(bb.getOutlineSize());
            gl.glBegin(1);
            nArray = cubic.getLineIndex();
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                for (int i : ii = nArray[n]) {
                    gl.glVertex3f(((float[])vertex.get(i))[0], ((float[])vertex.get(i))[1], ((float[])vertex.get(i))[2]);
                }
            }
            gl.glEnd();
        }
    }

    void drawCylinder(GL2 gl, Graphic graphic) {
        if (this.extent.intersects(graphic.getExtent())) {
            CylinderShape cylinder = (CylinderShape)graphic.getShape();
            BarBreak bb = (BarBreak)graphic.getLegend();
            List<PointZ> ps = cylinder.getPoints();
            ArrayList<float[]> vertex = new ArrayList<float[]>();
            for (PointZ p : ps) {
                vertex.add(new float[]{this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z)});
            }
            double height = ((float[])vertex.get(1))[2] - ((float[])vertex.get(0))[2];
            gl.glPushMatrix();
            gl.glPushAttrib(8);
            gl.glDisable(2884);
            float[] rgba = bb.getColor().getRGBComponents(null);
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            gl.glTranslatef(((float[])vertex.get(0))[0], ((float[])vertex.get(0))[1], ((float[])vertex.get(0))[2]);
            GLUquadric cone_obj = this.glu.gluNewQuadric();
            this.glu.gluCylinder(cone_obj, cylinder.getRadius(), cylinder.getRadius(), height, 100, 1);
            bb.setDrawOutline(false);
            this.drawCircle(gl, (float)height, (float)cylinder.getRadius(), bb);
            gl.glPopAttrib();
            gl.glPopMatrix();
        }
    }

    void drawLegend(GL2 gl) {
        if (!this.legends.isEmpty()) {
            ChartColorBar legend = (ChartColorBar)this.legends.get(0);
            LegendScheme ls = legend.getLegendScheme();
            int bNum = ls.getBreakNum();
            if (ls.getLegendBreaks().get(bNum - 1).isNoData()) {
                --bNum;
            }
            float x = 1.6f;
            float y = -1.0f;
            float lHeight = 2.0f;
            float lWidth = lHeight / (float)legend.getAspect();
            ArrayList<Integer> labelIdxs = new ArrayList<Integer>();
            ArrayList<String> tLabels = new ArrayList<String>();
            if (legend.isAutoTick()) {
                float legendLen = this.toScreenLength(x, y, 0.0f, x, y + lHeight, 0.0f);
                int tickGap = this.getLegendTickGap(legend, legendLen);
                int sIdx = bNum % tickGap / 2;
                int labNum = bNum - 1;
                if (ls.getLegendType() == LegendType.UniqueValue) {
                    ++labNum;
                } else if (legend.isDrawMinLabel()) {
                    sIdx = 0;
                    labNum = bNum;
                }
                while (sIdx < labNum) {
                    labelIdxs.add(sIdx);
                    sIdx += tickGap;
                }
            } else {
                for (int i = 0; i < bNum; ++i) {
                    ColorBreak cb = ls.getLegendBreaks().get(i);
                    double v = Double.parseDouble(cb.getEndValue().toString());
                    if (!legend.getTickLocations().contains(v)) continue;
                    labelIdxs.add(i);
                    int tickIdx = legend.getTickLocations().indexOf(v);
                    tLabels.add(legend.getTickLabels().get(tickIdx).getText());
                }
            }
            float barHeight = lHeight / (float)bNum;
            float yy = y;
            for (int i = 0; i < bNum; ++i) {
                float[] rgba = ls.getLegendBreak(i).getColor().getRGBComponents(null);
                gl.glColor3f(rgba[0], rgba[1], rgba[2]);
                gl.glBegin(7);
                gl.glVertex2f(x, yy);
                gl.glVertex2f(x + lWidth, yy);
                gl.glVertex2f(x + lWidth, yy + barHeight);
                gl.glVertex2f(x, yy + barHeight);
                gl.glEnd();
                yy += barHeight;
            }
            float[] rgba = Color.black.getRGBComponents(null);
            gl.glColor3f(rgba[0], rgba[1], rgba[2]);
            gl.glLineWidth(1.0f);
            gl.glBegin(3);
            gl.glVertex2f(x, y);
            gl.glVertex2f(x, y + lHeight);
            gl.glVertex2f(x + lWidth, y + lHeight);
            gl.glVertex2f(x + lWidth, y);
            gl.glVertex2f(x, y);
            gl.glEnd();
            int idx = 0;
            yy = y;
            for (int i = 0; i < bNum; ++i) {
                if (labelIdxs.contains(i)) {
                    ColorBreak cb = ls.getLegendBreaks().get(i);
                    String caption = legend.isAutoTick() ? (ls.getLegendType() == LegendType.UniqueValue ? cb.getCaption() : DataConvert.removeTailingZeros(cb.getEndValue().toString())) : (String)tLabels.get(idx);
                    if (ls.getLegendType() == LegendType.UniqueValue) {
                        this.drawString(gl, caption, legend.getTickLabelFont(), Color.black, x + lWidth, yy + barHeight * 0.5f, 0.0f, XAlign.LEFT, YAlign.CENTER, 5.0f, 0.0f);
                    } else {
                        rgba = Color.black.getRGBComponents(null);
                        gl.glColor3f(rgba[0], rgba[1], rgba[2]);
                        gl.glLineWidth(1.0f);
                        gl.glBegin(1);
                        gl.glVertex2f(x + lWidth * 0.5f, yy + barHeight);
                        gl.glVertex2f(x + lWidth, yy + barHeight);
                        gl.glEnd();
                        this.drawString(gl, caption, legend.getTickLabelFont(), Color.black, x + lWidth, yy + barHeight, 0.0f, XAlign.LEFT, YAlign.CENTER, 5.0f, 0.0f);
                    }
                    ++idx;
                }
                yy += barHeight;
            }
        }
    }

    private float transform_xf(float v) {
        return (v - this.xmin) / (this.xmax - this.xmin) * 2.0f - 1.0f;
    }

    private double transform_x(double v) {
        return (v - (double)this.xmin) / (double)(this.xmax - this.xmin) * 2.0 - 1.0;
    }

    private float transform_yf(float v) {
        return (v - this.ymin) / (this.ymax - this.ymin) * 2.0f - 1.0f;
    }

    private double transform_y(double v) {
        return (v - (double)this.ymin) / (double)(this.ymax - this.ymin) * 2.0 - 1.0;
    }

    private float transform_zf(float v) {
        return (v - this.zmin) / (this.zmax - this.zmin) * 2.0f - 1.0f;
    }

    private double transform_z(double v) {
        return (v - (double)this.zmin) / (double)(this.zmax - this.zmin) * 2.0 - 1.0;
    }

    private float[] transformf(PointZ p) {
        return new float[]{this.transform_xf((float)p.X), this.transform_yf((float)p.Y), this.transform_zf((float)p.Z)};
    }

    private double[] transform(PointZ p) {
        return new double[]{this.transform_x(p.X), this.transform_y(p.Y), this.transform_z(p.Z)};
    }

    public void dispose(GLAutoDrawable drawable) {
    }

    public void init(GLAutoDrawable drawable) {
        this.drawable = drawable;
        GL2 gl = drawable.getGL().getGL2();
        gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        gl.glEnable(2832);
        gl.glEnable(2929);
        gl.glShadeModel(7425);
        gl.glDepthFunc(515);
        gl.glHint(3152, 4354);
        gl.glEnable(3553);
        this.tessCallback = new tessellCallBack(gl, this.glu);
        this.positionArea = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        this.width = width;
        this.height = height;
        this.positionArea = this.getPositionArea(new Rectangle2D.Double(0.0, 0.0, width, height));
        GL2 gl = drawable.getGL().getGL2();
        if (height <= 0) {
            height = 1;
        }
        float h = (float)width / (float)height;
        gl.glViewport(0, 0, width, height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        float v = 2.0f;
        gl.glOrthof(-v, v, -v, v, -v, v);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    @Override
    public Margin getTightInset(Graphics2D g, Rectangle2D positionArea) {
        return null;
    }

    public static void main(String[] args) {
        GLProfile gp = GLProfile.get((String)"GL2");
        GLCapabilities cap = new GLCapabilities(gp);
        GLChartPanel gc = new GLChartPanel(cap, new Plot3DGL());
        gc.setSize(400, 400);
        JFrame frame = new JFrame("JOGL Line");
        frame.add((Component)((Object)gc));
        frame.setSize(500, 400);
        frame.setVisible(true);
    }

    class tessellCallBack
    implements GLUtessellatorCallback {
        private final GL2 gl;
        private final GLU glu;

        public tessellCallBack(GL2 gl, GLU glu) {
            this.gl = gl;
            this.glu = glu;
        }

        public void begin(int type) {
            this.gl.glBegin(type);
        }

        public void end() {
            this.gl.glEnd();
        }

        public void vertex(Object vertexData) {
            if (vertexData instanceof double[]) {
                double[] pointer = (double[])vertexData;
                if (pointer.length == 6) {
                    this.gl.glColor3dv(pointer, 3);
                }
                this.gl.glVertex3dv(pointer, 0);
            }
        }

        public void vertexData(Object vertexData, Object polygonData) {
        }

        public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
            double[] vertex = new double[]{coords[0], coords[1], coords[2]};
            outData[0] = vertex;
        }

        public void combineData(double[] coords, Object[] data, float[] weight, Object[] outData, Object polygonData) {
        }

        public void error(int errnum) {
            String estring = this.glu.gluErrorString(errnum);
            System.err.println("Tessellation Error: " + estring);
            System.exit(0);
        }

        public void beginData(int type, Object polygonData) {
        }

        public void endData(Object polygonData) {
        }

        public void edgeFlag(boolean boundaryEdge) {
        }

        public void edgeFlagData(boolean boundaryEdge, Object polygonData) {
        }

        public void errorData(int errnum, Object polygonData) {
        }
    }
}

