/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.plot;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.chart.plot.ChartPlotMethod;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.legend.PolylineBreak;

public class SeriesLegend {
    private ChartPlotMethod plotMethod = ChartPlotMethod.LINE;
    private List<ColorBreak> legendBreaks = new ArrayList<ColorBreak>();
    private Color errorColor = Color.black;

    public SeriesLegend() {
    }

    public SeriesLegend(ColorBreak cb) {
        this();
        this.legendBreaks.add(cb);
    }

    public SeriesLegend(int n) {
        this();
        for (int i = 0; i < n; ++i) {
            this.legendBreaks.add(new PolylineBreak());
        }
    }

    public ChartPlotMethod getPlotMethod() {
        return this.plotMethod;
    }

    public void setPlotMethod(ChartPlotMethod value) {
        this.plotMethod = value;
    }

    public boolean isPoint() {
        return this.legendBreaks.get(0) instanceof PointBreak;
    }

    public boolean isLine() {
        return this.legendBreaks.get(0) instanceof PolylineBreak;
    }

    public boolean isPolygon() {
        return this.legendBreaks.get(0) instanceof PolygonBreak;
    }

    public boolean isMutiple() {
        return this.legendBreaks.size() > 1;
    }

    public ColorBreak getLegendBreak() {
        return this.legendBreaks.get(0);
    }

    public void setLegendBreak(ColorBreak cb) {
        this.legendBreaks.clear();
        this.legendBreaks.add(cb);
    }

    public ColorBreak getLegendBreak(int idx) {
        if (idx >= this.legendBreaks.size()) {
            idx = 0;
        }
        return this.legendBreaks.get(idx);
    }

    public void setLegendBreak(int idx, ColorBreak cb) {
        this.legendBreaks.set(idx, cb);
    }

    public Color getErrorColor() {
        return this.errorColor;
    }

    public void setErrorColor(Color value) {
        this.errorColor = value;
    }

    public void addLegendBreak(ColorBreak cb) {
        this.legendBreaks.add(cb);
    }

    public int getBreakNum() {
        return this.legendBreaks.size();
    }
}

