/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.StationData;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.table.ColumnData;

public abstract class DataMath {
    public static Object add(Object a, Object b) {
        if (a.getClass() == GridData.class) {
            if (b.getClass() == GridData.class) {
                return ((GridData)a).add((GridData)b);
            }
            return ((GridData)a).add(Double.parseDouble(b.toString()));
        }
        if (a.getClass() == StationData.class) {
            if (b.getClass() == StationData.class) {
                return ((StationData)a).add((StationData)b);
            }
            return ((StationData)a).add(Double.parseDouble(b.toString()));
        }
        if (b.getClass() == GridData.class) {
            return ((GridData)b).add(Double.parseDouble(a.toString()));
        }
        if (b.getClass() == StationData.class) {
            return ((StationData)b).add(Double.parseDouble(a.toString()));
        }
        return Double.parseDouble(a.toString()) + Double.parseDouble(b.toString());
    }

    public static Object sub(Object a, Object b) {
        if (a.getClass() == GridData.class) {
            if (b.getClass() == GridData.class) {
                return ((GridData)a).sub((GridData)b);
            }
            return ((GridData)a).sub(Double.parseDouble(b.toString()));
        }
        if (a.getClass() == StationData.class) {
            if (b.getClass() == StationData.class) {
                return ((StationData)a).sub((StationData)b);
            }
            return ((StationData)a).sub(Double.parseDouble(b.toString()));
        }
        if (b.getClass() == GridData.class) {
            return DataMath.sub(Double.parseDouble(a.toString()), (GridData)b);
        }
        if (b.getClass() == StationData.class) {
            return DataMath.sub(Double.parseDouble(a.toString()), (StationData)b);
        }
        return Double.parseDouble(a.toString()) - Double.parseDouble(b.toString());
    }

    public static GridData sub(double value, GridData gridData) {
        int xNum = gridData.getXNum();
        int yNum = gridData.getYNum();
        GridData cGrid = new GridData(gridData);
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                cGrid.data[i][j] = MIMath.doubleEquals(gridData.data[i][j], gridData.missingValue) ? gridData.missingValue : value - gridData.data[i][j];
            }
        }
        return cGrid;
    }

    public static StationData sub(double value, StationData stData) {
        StationData cStData = new StationData();
        for (int i = 0; i < stData.stations.size(); ++i) {
            String aStid = stData.stations.get(i);
            double aValue = stData.getValue(i);
            double x = stData.getX(i);
            double y = stData.getY(i);
            if (MIMath.doubleEquals(aValue, stData.missingValue)) {
                cStData.addData(aStid, x, y, aValue);
                continue;
            }
            cStData.addData(aStid, x, y, value - aValue);
        }
        return cStData;
    }

    public static Object mul(Object a, Object b) {
        if (a.getClass() == GridData.class) {
            if (b.getClass() == GridData.class) {
                return ((GridData)a).mul((GridData)b);
            }
            return ((GridData)a).mul(Double.parseDouble(b.toString()));
        }
        if (a.getClass() == StationData.class) {
            if (b.getClass() == StationData.class) {
                return ((StationData)a).mul((StationData)b);
            }
            return ((StationData)a).mul(Double.parseDouble(b.toString()));
        }
        if (b.getClass() == GridData.class) {
            return ((GridData)b).mul(Double.parseDouble(a.toString()));
        }
        if (b.getClass() == StationData.class) {
            return ((StationData)b).mul(Double.parseDouble(a.toString()));
        }
        return Double.parseDouble(a.toString()) * Double.parseDouble(b.toString());
    }

    public static Object div(Object a, Object b) {
        if (a.getClass() == GridData.class) {
            if (b.getClass() == GridData.class) {
                return ((GridData)a).div((GridData)b);
            }
            return ((GridData)a).div(Double.parseDouble(b.toString()));
        }
        if (a.getClass() == StationData.class) {
            if (b.getClass() == StationData.class) {
                return ((StationData)a).div((StationData)b);
            }
            return ((StationData)a).div(Double.parseDouble(b.toString()));
        }
        if (b.getClass() == GridData.class) {
            return DataMath.div_1(Double.parseDouble(a.toString()), (GridData)b);
        }
        if (b.getClass() == StationData.class) {
            return DataMath.div_1(Double.parseDouble(a.toString()), (StationData)b);
        }
        return Double.parseDouble(a.toString()) / Double.parseDouble(b.toString());
    }

    public static GridData div_1(double value, GridData gridData) {
        int xNum = gridData.getXNum();
        int yNum = gridData.getYNum();
        GridData cGrid = new GridData(gridData);
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                cGrid.data[i][j] = MIMath.doubleEquals(gridData.data[i][j], gridData.missingValue) ? gridData.missingValue : (gridData.data[i][j] == 0.0 ? gridData.missingValue : value / gridData.data[i][j]);
            }
        }
        return cGrid;
    }

    public static StationData div_1(double value, StationData stData) {
        StationData cStData = new StationData();
        for (int i = 0; i < stData.stations.size(); ++i) {
            String aStid = stData.stations.get(i);
            double aValue = stData.getValue(i);
            double x = stData.getX(i);
            double y = stData.getY(i);
            if (aValue == 0.0 || MIMath.doubleEquals(aValue, stData.missingValue)) {
                cStData.addData(aStid, x, y, aValue);
                continue;
            }
            cStData.addData(aStid, x, y, value / aValue);
        }
        return cStData;
    }

    public static double[] getUVFromDS(double windDir, double windSpeed) {
        double dir = windDir + 180.0;
        if (dir > 360.0) {
            dir -= 360.0;
        }
        dir = dir * Math.PI / 180.0;
        double U = windSpeed * Math.sin(dir);
        double V = windSpeed * Math.cos(dir);
        return new double[]{U, V};
    }

    public static GridData[] getUVFromDS(GridData windDirData, GridData windSpeedData) {
        GridData uData = new GridData(windDirData);
        GridData vData = new GridData(windDirData);
        for (int i = 0; i < windDirData.getYNum(); ++i) {
            for (int j = 0; j < windDirData.getXNum(); ++j) {
                if (MIMath.doubleEquals(windDirData.data[i][j], windDirData.missingValue) || MIMath.doubleEquals(windSpeedData.data[i][j], windSpeedData.missingValue)) {
                    uData.data[i][j] = uData.missingValue;
                    vData.data[i][j] = vData.missingValue;
                    continue;
                }
                double[] uv = DataMath.getUVFromDS(windDirData.data[i][j], windSpeedData.data[i][j]);
                uData.data[i][j] = uv[0];
                vData.data[i][j] = uv[1];
            }
        }
        return new GridData[]{uData, vData};
    }

    public static StationData[] getUVFromDS(StationData windDirData, StationData windSpeedData) {
        StationData uData = new StationData(windDirData);
        StationData vData = new StationData(windSpeedData);
        for (int i = 0; i < windDirData.getStNum(); ++i) {
            if (MIMath.doubleEquals(windDirData.data[i][2], windDirData.missingValue) || MIMath.doubleEquals(windSpeedData.data[i][2], windSpeedData.missingValue)) {
                uData.data[i][2] = uData.missingValue;
                vData.data[i][2] = vData.missingValue;
                continue;
            }
            double[] uv = DataMath.getUVFromDS(windDirData.data[i][2], windSpeedData.data[i][2]);
            uData.data[i][2] = uv[0];
            vData.data[i][2] = uv[1];
        }
        return new StationData[]{uData, vData};
    }

    public static double[] getDSFromUV(double U, double V) {
        double windDir;
        double windSpeed = Math.sqrt(U * U + V * V);
        if (windSpeed == 0.0) {
            windDir = 0.0;
        } else {
            windDir = Math.asin(U / windSpeed) * 180.0 / Math.PI;
            if (U < 0.0 && V < 0.0) {
                windDir = 180.0 - windDir;
            } else if (U > 0.0 && V < 0.0) {
                windDir = 180.0 - windDir;
            } else if (U < 0.0 && V > 0.0) {
                windDir = 360.0 + windDir;
            }
            windDir += 180.0;
            if (windDir >= 360.0) {
                windDir -= 360.0;
            }
        }
        return new double[]{windDir, windSpeed};
    }

    public static GridData[] getDSFromUV(GridData uData, GridData vData) {
        GridData windDirData = new GridData(uData);
        GridData windSpeedData = new GridData(uData);
        for (int i = 0; i < uData.getYNum(); ++i) {
            for (int j = 0; j < uData.getXNum(); ++j) {
                if (MIMath.doubleEquals(uData.data[i][j], uData.missingValue) || MIMath.doubleEquals(vData.data[i][j], vData.missingValue)) {
                    windDirData.data[i][j] = windDirData.missingValue;
                    windSpeedData.data[i][j] = windSpeedData.missingValue;
                    continue;
                }
                double[] ds = DataMath.getDSFromUV(uData.data[i][j], vData.data[i][j]);
                windDirData.data[i][j] = ds[0];
                windSpeedData.data[i][j] = ds[1];
            }
        }
        return new GridData[]{windDirData, windSpeedData};
    }

    public static StationData[] getDSFromUV(StationData uData, StationData vData) {
        StationData windDirData = new StationData(uData);
        StationData windSpeedData = new StationData(vData);
        for (int i = 0; i < windDirData.getStNum(); ++i) {
            if (MIMath.doubleEquals(uData.data[i][2], uData.missingValue) || MIMath.doubleEquals(vData.data[i][2], vData.missingValue)) {
                windDirData.data[i][2] = windDirData.missingValue;
                windSpeedData.data[i][2] = windSpeedData.missingValue;
                continue;
            }
            double[] ds = DataMath.getDSFromUV(uData.data[i][2], vData.data[i][2]);
            windDirData.data[i][2] = ds[0];
            windSpeedData.data[i][2] = ds[1];
        }
        return new StationData[]{windDirData, windSpeedData};
    }

    public static double[] getEndPoint(double x, double y, double angle, double len) {
        double[] r = DataMath.getUVFromDS(angle, len);
        r[0] = r[0] + x;
        r[1] = r[1] + y;
        return r;
    }

    public static double sum(double[] values) {
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        return sum /= (double)values.length;
    }

    public static Object abs(Object a) {
        if (a.getClass() == GridData.class) {
            return ((GridData)a).abs();
        }
        if (a.getClass() == StationData.class) {
            return ((StationData)a).abs();
        }
        return Math.abs(Double.parseDouble(a.toString()));
    }

    public static Object asin(Object a) {
        if (a.getClass() == GridData.class) {
            return ((GridData)a).asin();
        }
        if (a.getClass() == StationData.class) {
            return ((StationData)a).asin();
        }
        return Math.asin(Double.parseDouble(a.toString()));
    }

    public static Object acos(Object a) {
        if (a.getClass() == GridData.class) {
            return ((GridData)a).acos();
        }
        if (a.getClass() == StationData.class) {
            return ((StationData)a).acos();
        }
        return Math.acos(Double.parseDouble(a.toString()));
    }

    public static Object atan(Object a) {
        if (a.getClass() == GridData.class) {
            return ((GridData)a).atan();
        }
        if (a.getClass() == StationData.class) {
            return ((StationData)a).atan();
        }
        return Math.atan(Double.parseDouble(a.toString()));
    }

    public static Object sin(Object a) {
        if (a.getClass() == GridData.class) {
            return ((GridData)a).sin();
        }
        if (a.getClass() == StationData.class) {
            return ((StationData)a).sin();
        }
        return Math.sin(Double.parseDouble(a.toString()));
    }

    public static Object cos(Object a) {
        if (a.getClass() == GridData.class) {
            return ((GridData)a).cos();
        }
        if (a.getClass() == StationData.class) {
            return ((StationData)a).cos();
        }
        return Math.cos(Double.parseDouble(a.toString()));
    }

    public static Object tan(Object a) {
        if (a.getClass() == GridData.class) {
            return ((GridData)a).tan();
        }
        if (a.getClass() == StationData.class) {
            return ((StationData)a).tan();
        }
        return Math.tan(Double.parseDouble(a.toString()));
    }

    public static Object exp(Object a) {
        if (a.getClass() == GridData.class) {
            return ((GridData)a).exp();
        }
        if (a.getClass() == StationData.class) {
            return ((StationData)a).exp();
        }
        return Math.exp(Double.parseDouble(a.toString()));
    }

    public static Object pow(Object a, double p) {
        if (a.getClass() == GridData.class) {
            return ((GridData)a).pow(p);
        }
        if (a.getClass() == StationData.class) {
            return ((StationData)a).pow(p);
        }
        return Math.pow(Double.parseDouble(a.toString()), p);
    }

    public static Object log(Object a) {
        if (a.getClass() == GridData.class) {
            return ((GridData)a).log();
        }
        if (a.getClass() == StationData.class) {
            return ((StationData)a).log();
        }
        return Math.log(Double.parseDouble(a.toString()));
    }

    public static Object log10(Object a) {
        if (a.getClass() == GridData.class) {
            return ((GridData)a).log10();
        }
        if (a.getClass() == StationData.class) {
            return ((StationData)a).log10();
        }
        return Math.log10(Double.parseDouble(a.toString()));
    }

    public static Object sqrt(Object a) {
        if (a.getClass() == GridData.class) {
            return ((GridData)a).sqrt();
        }
        if (a.getClass() == StationData.class) {
            return ((StationData)a).sqrt();
        }
        return Math.sqrt(Double.parseDouble(a.toString()));
    }

    public static GridData average(List<GridData> gDataList) {
        GridData rData = gDataList.get(0);
        for (int i = 1; i < gDataList.size(); ++i) {
            rData = rData.add(gDataList.get(i));
        }
        rData = rData.div(gDataList.size());
        return rData;
    }

    public static GridData average(List<GridData> gDataList, boolean ignoreUndef) {
        if (ignoreUndef) {
            return DataMath.average(gDataList);
        }
        GridData rData = new GridData(gDataList.get(0));
        GridData numData = new GridData(gDataList.get(0));
        rData.setValue(0.0);
        numData.setValue(0.0);
        for (int d = 0; d < gDataList.size(); ++d) {
            GridData aGrid = gDataList.get(d);
            for (int i = 0; i < rData.getYNum(); ++i) {
                for (int j = 0; j < rData.getXNum(); ++j) {
                    if (MIMath.doubleEquals(aGrid.data[i][j], aGrid.missingValue)) continue;
                    rData.data[i][j] = aGrid.data[i][j] + rData.data[i][j];
                    double[] dArray = numData.data[i];
                    int n = j;
                    dArray[n] = dArray[n] + 1.0;
                }
            }
        }
        for (int i = 0; i < rData.getYNum(); ++i) {
            for (int j = 0; j < rData.getXNum(); ++j) {
                if (rData.data[i][j] != 0.0) continue;
                rData.data[i][j] = rData.missingValue;
            }
        }
        rData = rData.div(numData);
        return rData;
    }

    public static GridData average(List<GridData> gDataList, boolean ignoreUndef, int validNum) {
        if (ignoreUndef) {
            return DataMath.average(gDataList);
        }
        GridData rData = new GridData(gDataList.get(0));
        GridData numData = new GridData(gDataList.get(0));
        rData.setValue(0.0);
        numData.setValue(0.0);
        for (int d = 0; d < gDataList.size(); ++d) {
            GridData aGrid = gDataList.get(d);
            for (int i = 0; i < rData.getYNum(); ++i) {
                for (int j = 0; j < rData.getXNum(); ++j) {
                    if (MIMath.doubleEquals(aGrid.data[i][j], aGrid.missingValue)) continue;
                    rData.data[i][j] = aGrid.data[i][j] + rData.data[i][j];
                    double[] dArray = numData.data[i];
                    int n = j;
                    dArray[n] = dArray[n] + 1.0;
                }
            }
        }
        for (int i = 0; i < rData.getYNum(); ++i) {
            for (int j = 0; j < rData.getXNum(); ++j) {
                if (rData.data[i][j] != 0.0) continue;
                rData.data[i][j] = rData.missingValue;
            }
        }
        numData.replaceValue(validNum, 0.0, false);
        rData = rData.div(numData);
        return rData;
    }

    public static StationData mean(List<StationData> datalist) {
        StationData cStData = new StationData();
        StationData stdata = datalist.get(0);
        cStData.projInfo = stdata.projInfo;
        for (int i = 0; i < stdata.stations.size(); ++i) {
            double aValue;
            String aStid = stdata.stations.get(i);
            if (aStid.equals("99999") || (aValue = stdata.getValue(i)) == stdata.missingValue) continue;
            double sum = aValue;
            int n = 1;
            for (int j = 1; j < datalist.size(); ++j) {
                double bValue;
                StationData sd = datalist.get(j);
                int stIdx = sd.stations.indexOf(aStid);
                if (stIdx < 0 || (bValue = sd.getValue(stIdx)) == sd.missingValue) continue;
                sum += bValue;
                ++n;
            }
            double x = stdata.getX(i);
            double y = stdata.getY(i);
            cStData.addData(aStid, x, y, sum /= (double)n);
        }
        return cStData;
    }

    public static double[] leastSquareTrend(double[] xData, double[] yData) {
        int n = xData.length;
        double sumX = 0.0;
        double sumY = 0.0;
        double sumSquareX = 0.0;
        double sumXY = 0.0;
        for (int i = 0; i < n; ++i) {
            sumX += xData[i];
            sumY += yData[i];
            sumSquareX += xData[i] * xData[i];
            sumXY += xData[i] * yData[i];
        }
        double a = (sumSquareX * sumY - sumX * sumXY) / ((double)n * sumSquareX - sumX * sumX);
        double b = ((double)n * sumXY - sumX * sumY) / ((double)n * sumSquareX - sumX * sumX);
        return new double[]{a, b};
    }

    public static GridData leastSquareTrend(List<GridData> dataList, double[] xData) {
        int n = dataList.size();
        double[] yData = new double[n];
        double missingValue = dataList.get((int)0).missingValue;
        GridData rData = new GridData(dataList.get(0));
        rData = rData.setValue(missingValue);
        for (int i = 0; i < dataList.get(0).getYNum(); ++i) {
            for (int j = 0; j < dataList.get(0).getXNum(); ++j) {
                boolean ifcal = true;
                for (int d = 0; d < n; ++d) {
                    double value = dataList.get((int)d).data[i][j];
                    if (MIMath.doubleEquals(value, dataList.get((int)d).missingValue)) {
                        ifcal = false;
                        break;
                    }
                    yData[d] = dataList.get((int)d).data[i][j];
                }
                if (!ifcal) continue;
                rData.data[i][j] = DataMath.leastSquareTrend(xData, yData)[1];
            }
        }
        return rData;
    }

    public static float getR(List<Double> xData, List<Double> yData) {
        int n = xData.size();
        double x_sum = 0.0;
        double y_sum = 0.0;
        for (int i = 0; i < n; ++i) {
            x_sum += xData.get(i).doubleValue();
            y_sum += yData.get(i).doubleValue();
        }
        double sx_sum = 0.0;
        double sy_sum = 0.0;
        double xy_sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sx_sum += xData.get(i) * xData.get(i);
            sy_sum += yData.get(i) * yData.get(i);
            xy_sum += xData.get(i) * yData.get(i);
        }
        double r = ((double)n * xy_sum - x_sum * y_sum) / (Math.sqrt((double)n * sx_sum - x_sum * x_sum) * Math.sqrt((double)n * sy_sum - y_sum * y_sum));
        return (float)r;
    }

    public static float getR(ColumnData xcData, ColumnData ycData) {
        List<Number> xData = xcData.getDataValues();
        List<Number> yData = ycData.getDataValues();
        ArrayList<Double> xxData = new ArrayList<Double>();
        ArrayList<Double> yyData = new ArrayList<Double>();
        for (int i = 0; i < xcData.size(); ++i) {
            if (Double.isNaN(xData.get(i).doubleValue()) || Double.isNaN(yData.get(i).doubleValue())) continue;
            xxData.add(xData.get(i).doubleValue());
            yyData.add(yData.get(i).doubleValue());
        }
        return DataMath.getR(xxData, yyData);
    }

    public static double[] mann_Kendall_Trend(List<Double> ts) {
        double[] nts = new double[ts.size()];
        for (int i = 0; i < ts.size(); ++i) {
            nts[i] = ts.get(i);
        }
        return DataMath.mann_Kendall_Trend(nts);
    }

    public static double[] mann_Kendall_Trend(double[] ts) {
        int s = 0;
        int k = 0;
        int n = ts.length;
        double[] differ = new double[n * (n - 1) / 2];
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (ts[j] > ts[i]) {
                    ++s;
                } else if (ts[j] < ts[i]) {
                    --s;
                }
                differ[k] = (ts[j] - ts[i]) / (double)(j - i);
                ++k;
            }
        }
        double var = n * (n - 1) * (2 * n + 5) / 18;
        double z = s > 0 ? (double)(s - 1) / Math.sqrt(var) : (s == 0 ? 0.0 : (double)(s + 1) / Math.sqrt(var));
        Arrays.sort(differ);
        double beta = k % 2 == 0 ? (differ[k / 2] + differ[k / 2 + 1]) / 2.0 : differ[k / 2 + 1];
        return new double[]{z, beta};
    }

    public static double[] mann_Kendall_Trend_1(double[] ts) {
        int s = 0;
        int k = 0;
        int n = ts.length;
        int[] p = new int[n - 1];
        int psum = 0;
        double[] differ = new double[n * (n - 1) / 2];
        for (int i = 0; i < n - 1; ++i) {
            s = 0;
            for (int j = i + 1; j < n; ++j) {
                if (ts[j] > ts[i]) {
                    ++s;
                }
                differ[k] = (ts[j] - ts[i]) / (double)(j - i);
                ++k;
            }
            p[i] = s;
            psum += s;
        }
        double t = 4.0 * (double)psum / (double)(n * (n - 1)) - 1.0;
        double var = 2.0 * (2.0 * (double)n + 5.0) / (9.0 * (double)n * (double)(n - 1));
        double u = t / Math.sqrt(var);
        Arrays.sort(differ);
        double beta = k % 2 == 0 ? (differ[k / 2] + differ[k / 2 + 1]) / 2.0 : differ[k / 2 + 1];
        return new double[]{u, beta};
    }

    public static GridData magnitude(GridData uData, GridData vData) {
        int xNum = uData.getXNum();
        int yNum = uData.getYNum();
        GridData cGrid = new GridData(uData);
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                cGrid.data[i][j] = Math.abs(uData.data[i][j] / uData.missingValue - 1.0) < 0.01 || Math.abs(vData.data[i][j] / vData.missingValue - 1.0) < 0.01 ? uData.missingValue : Math.sqrt(uData.data[i][j] * uData.data[i][j] + vData.data[i][j] * vData.data[i][j]);
            }
        }
        return cGrid;
    }

    public static StationData magnitude(StationData uData, StationData vData) {
        int i;
        if (!MIMath.isExtentCross(uData.dataExtent, vData.dataExtent).booleanValue()) {
            return null;
        }
        StationData cStData = new StationData();
        ArrayList<double[]> cData = new ArrayList<double[]>();
        int stIdx = -1;
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        for (i = 0; i < uData.stations.size(); ++i) {
            double bValue;
            double aValue;
            String aStid = uData.stations.get(i);
            if (aStid.equals("99999") || (aValue = uData.data[2][i]) == uData.missingValue || (stIdx = vData.stations.indexOf(aStid)) < 0 || (bValue = vData.data[2][stIdx]) == vData.missingValue) continue;
            cStData.stations.add(aStid);
            double[] theData = new double[]{uData.data[0][i], uData.data[1][i], Math.sqrt(aValue * aValue + bValue * bValue)};
            cData.add(theData);
            if (cStData.stations.size() == 1) {
                maxX = minX = theData[0];
                maxY = minY = theData[1];
                continue;
            }
            if (minX > theData[0]) {
                minX = theData[0];
            } else if (maxX < theData[0]) {
                maxX = theData[0];
            }
            if (minY > theData[1]) {
                minY = theData[1];
                continue;
            }
            if (!(maxY < theData[1])) continue;
            maxY = theData[1];
        }
        cStData.dataExtent.minX = minX;
        cStData.dataExtent.maxX = maxX;
        cStData.dataExtent.minY = minY;
        cStData.dataExtent.maxY = maxY;
        cStData.data = new double[3][cData.size()];
        for (i = 0; i < cData.size(); ++i) {
            cStData.data[0][i] = ((double[])cData.get(i))[0];
            cStData.data[1][i] = ((double[])cData.get(i))[1];
            cStData.data[2][i] = ((double[])cData.get(i))[2];
        }
        return cStData;
    }

    public static GridData cdiff(GridData aData, boolean isX) {
        int xnum = aData.getXNum();
        int ynum = aData.getYNum();
        GridData bData = new GridData(aData);
        for (int i = 0; i < ynum; ++i) {
            for (int j = 0; j < xnum; ++j) {
                double b;
                double a;
                if (i == 0 || i == ynum - 1 || j == 0 || j == xnum - 1) {
                    bData.data[i][j] = aData.missingValue;
                    continue;
                }
                if (isX) {
                    a = aData.data[i][j + 1];
                    b = aData.data[i][j - 1];
                } else {
                    a = aData.data[i + 1][j];
                    b = aData.data[i - 1][j];
                }
                bData.data[i][j] = MIMath.doubleEquals(a, aData.missingValue) || MIMath.doubleEquals(b, aData.missingValue) ? aData.missingValue : a - b;
            }
        }
        return bData;
    }

    public static GridData hcurl(GridData uData, GridData vData) {
        GridData lonData = new GridData(uData);
        GridData latData = new GridData(vData);
        for (int i = 0; i < uData.getYNum(); ++i) {
            for (int j = 0; j < uData.getXNum(); ++j) {
                lonData.data[i][j] = uData.xArray[j];
                latData.data[i][j] = uData.yArray[i];
            }
        }
        GridData dv = DataMath.cdiff(vData, true);
        GridData dx = DataMath.cdiff(lonData, true).mul(Math.PI / 180);
        GridData du = DataMath.cdiff(uData.mul((GridData)DataMath.cos(latData.mul(Math.PI / 180))), false);
        GridData dy = DataMath.cdiff(latData, false).mul(Math.PI / 180);
        GridData gData = dv.div(dx).sub(du.div(dy)).div(((GridData)DataMath.cos(latData.mul(Math.PI / 180))).mul(6370000.0));
        return gData;
    }

    public static GridData hdivg(GridData uData, GridData vData) {
        GridData lonData = new GridData(uData);
        GridData latData = new GridData(uData);
        for (int i = 0; i < uData.getYNum(); ++i) {
            for (int j = 0; j < uData.getXNum(); ++j) {
                lonData.data[i][j] = uData.xArray[j];
                latData.data[i][j] = uData.yArray[i];
            }
        }
        GridData du = DataMath.cdiff(uData, true);
        GridData dx = DataMath.cdiff(lonData, true).mul(Math.PI / 180);
        GridData dv = DataMath.cdiff(vData.mul((GridData)DataMath.cos(latData.mul(Math.PI / 180))), false);
        GridData dy = DataMath.cdiff(latData, false).mul(Math.PI / 180);
        GridData gData = du.div(dx).add(dv.div(dy)).div(((GridData)DataMath.cos(latData.mul(Math.PI / 180))).mul(6370000.0));
        return gData;
    }

    public static Object[] gauss2Lats(int nlat) {
        double d;
        double c;
        int i;
        double acon = 57.29577951308232;
        double xlim = 1.0E-7;
        int iNum = nlat;
        double[] cosc = new double[iNum];
        double[] gwt = new double[iNum];
        double[] sinc = new double[iNum];
        double[] colat = new double[iNum];
        double[] wos2 = new double[iNum];
        for (i = 0; i < iNum; ++i) {
            cosc[i] = 0.0;
            gwt[i] = 0.0;
            sinc[i] = 0.0;
            colat[i] = 0.0;
            wos2[i] = 0.0;
        }
        int nzero = nlat / 2;
        for (i = 1; i <= nzero; ++i) {
            cosc[i - 1] = Math.sin(((double)i - 0.5) * Math.PI / (double)nlat + 1.5707963267948966);
        }
        int fi = nlat;
        double fi1 = (double)fi + 1.0;
        double a = (double)fi * fi1 / Math.sqrt(4.0 * fi1 * fi1 - 1.0);
        double b = fi1 * (double)fi / Math.sqrt(4.0 * (double)fi * (double)fi - 1.0);
        for (i = 0; i < nzero; ++i) {
            double g = DataMath.gord(nlat, cosc[i]);
            double gm = DataMath.gord(nlat - 1, cosc[i]);
            double gp = DataMath.gord(nlat + 1, cosc[i]);
            double gt = (cosc[i] * cosc[i] - 1.0) / (a * gp - b * gm);
            double delta = g * gt;
            cosc[i] = cosc[i] - delta;
            while (Math.abs(delta) > xlim) {
                g = DataMath.gord(nlat, cosc[i]);
                gm = DataMath.gord(nlat - 1, cosc[i]);
                gp = DataMath.gord(nlat + 1, cosc[i]);
                gt = (cosc[i] * cosc[i] - 1.0) / (a * gp - b * gm);
                delta = g * gt;
                cosc[i] = cosc[i] - delta;
            }
            c = 2.0 * (1.0 - cosc[i] * cosc[i]);
            d = DataMath.gord(nlat - 1, cosc[i]);
            d = d * d * (double)fi * (double)fi;
            gwt[i] = c * ((double)fi - 0.5) / d;
        }
        for (i = 0; i < nzero; ++i) {
            colat[i] = Math.acos(cosc[i]);
            sinc[i] = Math.sin(colat[i]);
            wos2[i] = gwt[i] / (sinc[i] * sinc[i]);
        }
        if (nlat % 2 != 0) {
            i = nzero;
            cosc[i] = 0.0;
            c = 2.0;
            d = DataMath.gord(nlat - 1, cosc[i]);
            d = d * d * (double)fi * (double)fi;
            gwt[i] = c * ((double)fi - 0.5) / d;
            colat[i] = 1.5707963267948966;
            sinc[i] = 1.0;
            wos2[i] = gwt[i];
        }
        for (i = nlat - nzero; i < nlat; ++i) {
            int j = nlat - i - 1;
            cosc[i] = -cosc[j];
            gwt[i] = gwt[j];
            colat[i] = Math.PI - colat[j];
            sinc[i] = sinc[j];
            wos2[i] = wos2[j];
        }
        double ylat = -90.0;
        double[] xlat = new double[nlat];
        double[] dlat = new double[nlat];
        for (i = 0; i < nzero; ++i) {
            xlat[i] = -Math.acos(sinc[i]) * acon;
            dlat[i] = xlat[i] - ylat;
            ylat = xlat[i];
        }
        if (nlat % 2 != 0) {
            i = nzero;
            xlat[i] = 0.0;
            dlat[i] = xlat[i] - ylat;
        }
        for (i = nlat - nzero; i < nlat; ++i) {
            xlat[i] = Math.acos(sinc[i]) * acon;
            dlat[i] = xlat[i] - ylat;
            ylat = xlat[i];
        }
        return new Object[]{xlat, dlat};
    }

    private static double gord(int n, double x) {
        double colat = Math.acos(x);
        double c1 = Math.sqrt(2.0);
        for (int i = 1; i <= n; ++i) {
            c1 *= Math.sqrt(1.0 - 1.0 / (double)(4 * i * i));
        }
        int fn = n;
        double ang = (double)fn * colat;
        double s1 = 0.0;
        double c4 = 1.0;
        double a = -1.0;
        double b = 0.0;
        for (int k = 0; k <= n; k += 2) {
            if (k == n) {
                c4 = 0.5 * c4;
            }
            s1 += c4 * Math.cos(ang);
            int fk = k;
            ang = colat * ((double)(fn - fk) - 2.0);
            c4 = (a += 2.0) * ((double)fn - (b += 1.0) + 1.0) / (b * ((double)(fn + fn) - a)) * c4;
        }
        return s1 * c1;
    }
}

