/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.dataframe;

import org.meteoinfo.data.dataframe.DataFrame;
import org.meteoinfo.data.dataframe.DateTimeIndex;
import org.meteoinfo.data.dataframe.GroupBy;
import org.meteoinfo.data.dataframe.impl.Aggregation;
import org.meteoinfo.data.dataframe.impl.Function;
import org.meteoinfo.data.dataframe.impl.Grouping;

public class DataFrameGroupBy
extends GroupBy {
    private final DataFrame dataFrame;

    public DataFrameGroupBy(Grouping groups, DataFrame dataFrame) {
        this.groups = groups;
        this.dataFrame = dataFrame;
    }

    public <V> DataFrame apply(Function<?, ?> function) {
        DataFrame df = this.groups.apply(this.dataFrame, function);
        if (this.dataFrame.getIndex() instanceof DateTimeIndex) {
            ((DateTimeIndex)df.getIndex()).setPeriod(((DateTimeIndex)this.dataFrame.getIndex()).getResamplePeriod());
        }
        return df;
    }

    @Override
    public DataFrame count() {
        DataFrame r = this.apply(new Aggregation.Count());
        return r;
    }

    @Override
    public DataFrame sum() {
        DataFrame r = this.apply(new Aggregation.Sum());
        return r;
    }

    @Override
    public DataFrame mean() {
        DataFrame r = this.apply(new Aggregation.Mean());
        return r;
    }

    @Override
    public DataFrame min() {
        DataFrame r = this.apply(new Aggregation.Min());
        return r;
    }

    @Override
    public DataFrame max() {
        DataFrame r = this.apply(new Aggregation.Max());
        return r;
    }

    @Override
    public DataFrame median() {
        DataFrame r = this.apply(new Aggregation.Median());
        return r;
    }

    @Override
    public DataFrame stdDev() {
        DataFrame r = this.apply(new Aggregation.StdDev());
        return r;
    }

    @Override
    public DataFrame percentile(double quantile) {
        DataFrame r = this.apply(new Aggregation.Percentile(quantile * 100.0));
        return r;
    }
}

