/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.table.DataTable;

public class StationInfoData {
    private List<String> _fields = new ArrayList<String>();
    private List<String> _variables = new ArrayList<String>();
    private List<List<String>> _dataList = new ArrayList<List<String>>();
    private List<String> _stations = new ArrayList<String>();

    public List<String> getVariables() {
        return this._variables;
    }

    public void setVariables(List<String> value) {
        this._variables = value;
    }

    public List<String> getFields() {
        return this._fields;
    }

    public void setFields(List<String> value) {
        this._fields = value;
    }

    public List<String> getStations() {
        return this._stations;
    }

    public void setStations(List<String> value) {
        this._stations = value;
    }

    public List<List<String>> getDataList() {
        return this._dataList;
    }

    public void setDataList(List<List<String>> value) {
        this._dataList = value;
    }

    public DataTable extractStationData(List<String> sts, List<String> colNames) throws Exception {
        return this.extractStationData(sts, colNames, null);
    }

    public DataTable extractStationData(List<String> sts, List<String> colNames, Date time) throws Exception {
        DataTable dt = new DataTable();
        dt.addColumn("Station", DataType.STRING);
        dt.addColumn("Longitude", DataType.FLOAT);
        dt.addColumn("Latitude", DataType.FLOAT);
        if (time != null) {
            dt.addColumn("Time", DataType.DATE);
        }
        for (String colName : colNames) {
            if (!this._fields.contains(colName)) continue;
            dt.addColumn(colName, DataType.STRING);
        }
        int rn = 0;
        for (String st : sts) {
            int idx = this._stations.indexOf(st);
            if (idx < 0) continue;
            dt.addRow();
            dt.setValue(rn, "Station", (Object)st);
            List<String> dlist = this._dataList.get(idx);
            dt.setValue(rn, "Longitude", (Object)Float.valueOf(Float.parseFloat(dlist.get(1))));
            dt.setValue(rn, "Latitude", (Object)Float.valueOf(Float.parseFloat(dlist.get(2))));
            if (time != null) {
                dt.setValue(rn, "Time", (Object)time);
            }
            for (String colName : colNames) {
                int cidx = this._fields.indexOf(colName);
                if (cidx < 0) continue;
                dt.setValue(rn, colName, (Object)dlist.get(cidx));
            }
            ++rn;
        }
        return dt;
    }

    public void saveAsCSVFile(String fileName) throws IOException {
        int i;
        BufferedWriter sr = new BufferedWriter(new FileWriter(fileName));
        String aStr = "";
        for (i = 0; i < this._fields.size(); ++i) {
            aStr = i == 0 ? this._fields.get(i) : aStr + "," + this._fields.get(i);
        }
        sr.write(aStr);
        sr.newLine();
        sr.flush();
        for (i = 0; i < this._dataList.size(); ++i) {
            List<String> dList = this._dataList.get(i);
            for (int j = 0; j < dList.size(); ++j) {
                aStr = j == 0 ? dList.get(j) : aStr + "," + dList.get(j);
            }
            sr.write(aStr);
            sr.newLine();
            sr.flush();
        }
        sr.close();
    }
}

