/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.hysplit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IGridDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.arl.ARLDataInfo;
import org.meteoinfo.data.meteodata.ascii.ASCIIGridDataInfo;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.util.BigDecimalUtil;
import org.meteoinfo.global.util.DateUtil;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Dimension;
import org.meteoinfo.ndarray.DimensionType;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.Section;

public class HYSPLITConcDataInfo
extends DataInfo
implements IGridDataInfo {
    private int _pack_flag;
    private int _loc_num;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;

    public HYSPLITConcDataInfo() {
        this.setDataType(MeteoDataType.HYSPLIT_Conc);
    }

    public HYSPLITConcDataInfo(boolean bigendian) {
        this();
        this.byteOrder = bigendian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    public void setBigEndian(boolean value) {
        this.byteOrder = value ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    public void readDataInfo(String fileName) {
        try {
            int hBytes;
            int j;
            int i;
            this.setFileName(fileName);
            RandomAccessFile br = new RandomAccessFile(fileName, "r");
            br.skipBytes(4);
            byte[] aBytes = new byte[4];
            br.read(aBytes);
            String Ident = new String(aBytes);
            byte[] bytes = new byte[28];
            br.read(bytes);
            int start = 0;
            System.arraycopy(bytes, start, aBytes, 0, 4);
            int year = DataConvert.bytes2Int(aBytes, this.byteOrder);
            System.arraycopy(bytes, start += 4, aBytes, 0, 4);
            int month = DataConvert.bytes2Int(aBytes, this.byteOrder);
            System.arraycopy(bytes, start += 4, aBytes, 0, 4);
            int day = DataConvert.bytes2Int(aBytes, this.byteOrder);
            System.arraycopy(bytes, start += 4, aBytes, 0, 4);
            int hour = DataConvert.bytes2Int(aBytes, this.byteOrder);
            System.arraycopy(bytes, start += 4, aBytes, 0, 4);
            int forecast_hour = DataConvert.bytes2Int(aBytes, this.byteOrder);
            System.arraycopy(bytes, start += 4, aBytes, 0, 4);
            this._loc_num = DataConvert.bytes2Int(aBytes, this.byteOrder);
            System.arraycopy(bytes, start += 4, aBytes, 0, 4);
            this._pack_flag = DataConvert.bytes2Int(aBytes, this.byteOrder);
            Object[][] locArray = new Object[8][this._loc_num];
            bytes = new byte[this._loc_num * 40];
            br.read(bytes);
            start = 0;
            for (i = 0; i < this._loc_num; ++i) {
                start += 8;
                for (j = 0; j < 4; ++j) {
                    System.arraycopy(bytes, start, aBytes, 0, 4);
                    locArray[j][i] = DataConvert.bytes2Int(aBytes, this.byteOrder);
                    start += 4;
                }
                for (j = 4; j < 7; ++j) {
                    System.arraycopy(bytes, start, aBytes, 0, 4);
                    locArray[j][i] = Float.valueOf(DataConvert.bytes2Float(aBytes, this.byteOrder));
                    start += 4;
                }
                System.arraycopy(bytes, start, aBytes, 0, 4);
                locArray[7][i] = DataConvert.bytes2Int(aBytes, this.byteOrder);
                start += 4;
            }
            String fName = new File(fileName).getName().toLowerCase();
            if (fName.contains("gemzint")) {
                br.skipBytes(4);
            } else {
                br.skipBytes(8);
            }
            bytes = new byte[24];
            br.read(bytes);
            start = 0;
            System.arraycopy(bytes, start, aBytes, 0, 4);
            int lat_point_num = DataConvert.bytes2Int(aBytes, this.byteOrder);
            System.arraycopy(bytes, start += 4, aBytes, 0, 4);
            int lon_point_num = DataConvert.bytes2Int(aBytes, this.byteOrder);
            System.arraycopy(bytes, start += 4, aBytes, 0, 4);
            float lat_delta = DataConvert.bytes2Float(aBytes, this.byteOrder);
            System.arraycopy(bytes, start += 4, aBytes, 0, 4);
            float lon_delta = DataConvert.bytes2Float(aBytes, this.byteOrder);
            System.arraycopy(bytes, start += 4, aBytes, 0, 4);
            float lat_LF = DataConvert.bytes2Float(aBytes, this.byteOrder);
            System.arraycopy(bytes, start += 4, aBytes, 0, 4);
            float lon_LF = DataConvert.bytes2Float(aBytes, this.byteOrder);
            double[] X = new double[lon_point_num];
            double[] Y = new double[lat_point_num];
            double lonMin = BigDecimalUtil.toDouble(lon_LF);
            double lonDelta = BigDecimalUtil.toDouble(lon_delta);
            for (i = 0; i < lon_point_num; ++i) {
                X[i] = BigDecimalUtil.add(lonMin, BigDecimalUtil.mul((double)i, lonDelta));
            }
            if (X[0] == 0.0 && BigDecimalUtil.add(X[X.length - 1], (double)lon_delta) == 360.0) {
                this.setGlobal(true);
            }
            double latMin = BigDecimalUtil.toDouble(lat_LF);
            double latDelta = BigDecimalUtil.toDouble(lat_delta);
            for (i = 0; i < lat_point_num; ++i) {
                Y[i] = BigDecimalUtil.add(latMin, BigDecimalUtil.mul((double)i, latDelta));
            }
            this.addAttribute(new Attribute("data_format", "HYSPLIT Concentration"));
            Dimension xDim = new Dimension(DimensionType.X);
            xDim.setShortName("lon");
            xDim.setValues(X);
            this.setXDimension(xDim);
            this.addDimension(xDim);
            Dimension yDim = new Dimension(DimensionType.Y);
            yDim.setShortName("lat");
            yDim.setValues(Y);
            this.setYDimension(yDim);
            this.addDimension(yDim);
            ArrayList<Variable> variables = new ArrayList<Variable>();
            br.skipBytes(8);
            br.read(aBytes);
            int level_num = DataConvert.bytes2Int(aBytes, this.byteOrder);
            double[] heights = new double[level_num];
            bytes = new byte[level_num * 4];
            br.read(bytes);
            start = 0;
            for (i = 0; i < level_num; ++i) {
                System.arraycopy(bytes, start, aBytes, 0, 4);
                heights[i] = DataConvert.bytes2Int(aBytes, this.byteOrder);
                start += 4;
            }
            Dimension zDim = new Dimension(DimensionType.Z);
            zDim.setShortName("level");
            zDim.setValues(heights);
            this.setZDimension(zDim);
            this.addDimension(zDim);
            br.skipBytes(8);
            br.read(aBytes);
            int pollutant_num = DataConvert.bytes2Int(aBytes, this.byteOrder);
            for (i = 0; i < pollutant_num; ++i) {
                br.read(aBytes);
                String vName = new String(aBytes);
                vName = vName.trim();
                Variable var = new Variable();
                var.setName(vName);
                var.setDataType(DataType.FLOAT);
                var.addAttribute("long_name", vName);
                variables.add(var);
            }
            this.setVariables(variables);
            int hByte_num = hBytes = 36 + lon_point_num * 40 + 32 + 12 + level_num * 4 + 12 + pollutant_num * 4;
            int tNum = 0;
            int[] sampleTimes = new int[6];
            ArrayList<Date> sample_start = new ArrayList<Date>();
            ArrayList<Date> sample_stop = new ArrayList<Date>();
            do {
                br.skipBytes(8);
                bytes = new byte[24];
                br.read(bytes);
                start = 0;
                for (i = 0; i < 6; ++i) {
                    System.arraycopy(bytes, start, aBytes, 0, 4);
                    sampleTimes[i] = DataConvert.bytes2Int(aBytes, this.byteOrder);
                    start += 4;
                }
                year = sampleTimes[0];
                year = year < 50 ? 2000 + year : 1900 + year;
                GregorianCalendar cal = new GregorianCalendar(year, sampleTimes[1] - 1, sampleTimes[2], sampleTimes[3], 0, 0);
                Date aDateTime = cal.getTime();
                sample_start.add(aDateTime);
                br.skipBytes(8);
                bytes = new byte[24];
                br.read(bytes);
                start = 0;
                for (i = 0; i < 6; ++i) {
                    System.arraycopy(bytes, start, aBytes, 0, 4);
                    sampleTimes[i] = DataConvert.bytes2Int(aBytes, this.byteOrder);
                    start += 4;
                }
                year = sampleTimes[0];
                year = year < 50 ? 2000 + year : 1900 + year;
                cal = new GregorianCalendar(year, sampleTimes[1] - 1, sampleTimes[2], sampleTimes[3], 0, 0);
                aDateTime = cal.getTime();
                sample_stop.add(aDateTime);
                for (i = 0; i < pollutant_num; ++i) {
                    for (j = 0; j < level_num; ++j) {
                        int aLevel;
                        String aType;
                        if (this._pack_flag == 1) {
                            br.skipBytes(8);
                            br.read(aBytes);
                            aType = new String(aBytes);
                            br.read(aBytes);
                            aLevel = DataConvert.bytes2Int(aBytes, this.byteOrder);
                            br.read(aBytes);
                            int aN = DataConvert.bytes2Int(aBytes, this.byteOrder);
                            br.skipBytes(aN * 8);
                            continue;
                        }
                        br.skipBytes(8);
                        br.read(aBytes);
                        aType = new String(aBytes);
                        br.read(aBytes);
                        aLevel = DataConvert.bytes2Int(aBytes, this.byteOrder);
                        br.skipBytes(lat_point_num * lon_point_num * 4);
                    }
                }
                ++tNum;
            } while (br.getFilePointer() + 10L <= br.length());
            ArrayList<Double> values = new ArrayList<Double>();
            for (Date t : sample_start) {
                values.add(DateUtil.toOADate(t));
            }
            Dimension tDim = new Dimension(DimensionType.T);
            tDim.setShortName("time");
            tDim.setValues(values);
            this.setTimeDimension(tDim);
            this.addDimension(tDim);
            for (Variable v : variables) {
                v.setDimension(tDim);
                v.setDimension(zDim);
                v.setDimension(yDim);
                v.setDimension(xDim);
            }
            this.setVariables(variables);
            br.close();
        }
        catch (IOException ex) {
            Logger.getLogger(ASCIIGridDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public Array read(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.read(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        try {
            Variable var = this.getVariable(varName);
            Section section = new Section(origin, size, stride);
            Array dataArray = Array.factory(DataType.DOUBLE, section.getShape());
            int rangeIdx = 0;
            Range timeRange = section.getRank() > 2 ? section.getRange(rangeIdx++) : new Range(0, 0);
            Range levRange = var.getLevelNum() > 0 ? section.getRange(rangeIdx++) : new Range(0, 0);
            Range yRange = section.getRange(rangeIdx++);
            Range xRange = section.getRange(rangeIdx);
            IndexIterator ii = dataArray.getIndexIterator();
            for (int timeIdx = timeRange.first(); timeIdx <= timeRange.last(); timeIdx += timeRange.stride()) {
                for (int levelIdx = levRange.first(); levelIdx <= levRange.last(); levelIdx += levRange.stride()) {
                    this.readXY(varName, timeIdx, levelIdx, yRange, xRange, ii);
                }
            }
            return dataArray;
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(HYSPLITConcDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private void readXY(String varName, int timeIdx, int levelIdx, Range yRange, Range xRange, IndexIterator ii) {
        try {
            int j;
            int i;
            int varIdx = this.getVariableNames().indexOf(varName);
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            byte[] aBytes = new byte[4];
            int xNum = this.getXDimension().getLength();
            int yNum = this.getYDimension().getLength();
            double[][] dataArray = new double[xNum][yNum];
            double[] data = new double[yNum * xNum];
            br.skipBytes(36);
            int nBytes = 40 * this._loc_num;
            br.skipBytes(nBytes);
            String fName = new File(this.getFileName()).getName().toLowerCase();
            if (fName.contains("gemzint")) {
                br.skipBytes(28);
            } else {
                br.skipBytes(32);
            }
            nBytes = 12 + this.getZDimension().getLength() * 4;
            br.skipBytes(nBytes);
            nBytes = 12 + this.getVariableNum() * 4;
            br.skipBytes(nBytes);
            byte[] sbytes = new byte[2];
            int start = 0;
            for (int t = 0; t < this.getTimeNum(); ++t) {
                br.skipBytes(64);
                block4: for (i = 0; i < this.getVariableNum(); ++i) {
                    for (j = 0; j < this.getZDimension().getLength(); ++j) {
                        int aN;
                        int aLevel;
                        String aType;
                        if (t == timeIdx && i == varIdx && j == levelIdx) {
                            double aConc;
                            int JP;
                            int IP;
                            byte[] bytes;
                            if (br.getFilePointer() + 28L > br.length()) continue block4;
                            if (this._pack_flag == 1) {
                                br.skipBytes(8);
                                br.read(aBytes);
                                aType = new String(aBytes);
                                br.read(aBytes);
                                aLevel = DataConvert.bytes2Int(aBytes, this.byteOrder);
                                br.read(aBytes);
                                aN = DataConvert.bytes2Int(aBytes, this.byteOrder);
                                bytes = new byte[aN * 8];
                                br.read(bytes);
                                start = 0;
                                for (int k = 0; k < aN; ++k) {
                                    System.arraycopy(bytes, start, sbytes, 0, 2);
                                    IP = DataConvert.bytes2Short(sbytes, this.byteOrder) - 1;
                                    System.arraycopy(bytes, start += 2, sbytes, 0, 2);
                                    JP = DataConvert.bytes2Short(sbytes, this.byteOrder) - 1;
                                    System.arraycopy(bytes, start += 2, aBytes, 0, 4);
                                    aConc = DataConvert.bytes2Float(aBytes, this.byteOrder);
                                    start += 4;
                                    if (IP < 0 || IP >= xNum || JP < 0 || JP >= yNum) continue;
                                    dataArray[IP][JP] = aConc;
                                }
                                continue;
                            }
                            br.skipBytes(8);
                            br.read(aBytes);
                            aType = new String(aBytes);
                            br.read(aBytes);
                            aLevel = DataConvert.bytes2Int(aBytes, this.byteOrder);
                            bytes = new byte[yNum * xNum * 4];
                            br.read(bytes);
                            start = 0;
                            for (JP = 0; JP < yNum; ++JP) {
                                for (IP = 0; IP < xNum; ++IP) {
                                    System.arraycopy(bytes, start, aBytes, 0, 4);
                                    aConc = DataConvert.bytes2Float(aBytes, this.byteOrder);
                                    start += 4;
                                    dataArray[IP][JP] = aConc;
                                }
                            }
                            continue;
                        }
                        if (br.getFilePointer() + 28L > br.length()) continue block4;
                        if (this._pack_flag == 1) {
                            br.skipBytes(8);
                            br.read(aBytes);
                            aType = new String(aBytes);
                            br.read(aBytes);
                            aLevel = DataConvert.bytes2Int(aBytes, this.byteOrder);
                            br.read(aBytes);
                            aN = DataConvert.bytes2Int(aBytes, this.byteOrder);
                            br.skipBytes(aN * 8);
                            continue;
                        }
                        br.skipBytes(8);
                        br.read(aBytes);
                        aType = new String(aBytes);
                        br.read(aBytes);
                        aLevel = DataConvert.bytes2Int(aBytes, this.byteOrder);
                        br.skipBytes(yNum * xNum * 4);
                    }
                }
                if (br.getFilePointer() + 10L > br.length()) break;
            }
            br.close();
            for (i = 0; i < yNum; ++i) {
                for (j = 0; j < xNum; ++j) {
                    data[i * xNum + j] = dataArray[j][i];
                }
            }
            for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
                for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                    int index = y * xNum + x;
                    ii.setDoubleNext(data[index]);
                }
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public GridArray getGridArray(String varName) {
        return null;
    }

    @Override
    public GridData getGridData_LonLat(int timeIdx, int varIdx, int levelIdx) {
        try {
            int j;
            int i;
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            byte[] aBytes = new byte[4];
            int xNum = this.getXDimension().getLength();
            int yNum = this.getYDimension().getLength();
            double[][] dataArray = new double[xNum][yNum];
            double[][] newDataArray = new double[yNum][xNum];
            br.skipBytes(36);
            int nBytes = 40 * this._loc_num;
            br.skipBytes(nBytes);
            String fName = new File(this.getFileName()).getName().toLowerCase();
            if (fName.contains("gemzint")) {
                br.skipBytes(28);
            } else {
                br.skipBytes(32);
            }
            nBytes = 12 + this.getZDimension().getLength() * 4;
            br.skipBytes(nBytes);
            nBytes = 12 + this.getVariableNum() * 4;
            br.skipBytes(nBytes);
            for (int t = 0; t < this.getTimeNum(); ++t) {
                br.skipBytes(64);
                block3: for (i = 0; i < this.getVariableNum(); ++i) {
                    for (j = 0; j < this.getZDimension().getLength(); ++j) {
                        int JP;
                        int IP;
                        int k;
                        int aN;
                        int aLevel;
                        String aType;
                        if (t == timeIdx && i == varIdx && j == levelIdx) {
                            double aConc;
                            if (br.getFilePointer() + 28L > br.length()) continue block3;
                            if (this._pack_flag == 1) {
                                br.skipBytes(8);
                                br.read(aBytes);
                                aType = new String(aBytes);
                                aLevel = br.readInt();
                                aN = br.readInt();
                                for (k = 0; k < aN && br.getFilePointer() + 8L <= br.length(); ++k) {
                                    IP = br.readShort() - 1;
                                    JP = br.readShort() - 1;
                                    aConc = br.readFloat();
                                    if (IP < 0 || IP >= xNum || JP < 0 || JP >= yNum) continue;
                                    dataArray[IP][JP] = aConc;
                                }
                                continue;
                            }
                            br.skipBytes(8);
                            br.read(aBytes);
                            aType = new String(aBytes);
                            aLevel = br.readInt();
                            for (JP = 0; JP < yNum; ++JP) {
                                for (IP = 0; IP < xNum; ++IP) {
                                    dataArray[IP][JP] = aConc = (double)br.readFloat();
                                }
                            }
                            continue;
                        }
                        if (br.getFilePointer() + 28L > br.length()) continue block3;
                        if (this._pack_flag == 1) {
                            br.skipBytes(8);
                            br.read(aBytes);
                            aType = new String(aBytes);
                            aLevel = br.readInt();
                            aN = br.readInt();
                            for (k = 0; k < aN && br.getFilePointer() + 8L <= br.length(); ++k) {
                                IP = br.readShort();
                                JP = br.readShort();
                                br.skipBytes(4);
                            }
                            continue;
                        }
                        br.skipBytes(8);
                        br.read(aBytes);
                        aType = new String(aBytes);
                        aLevel = br.readInt();
                        for (JP = 0; JP < yNum; ++JP) {
                            for (IP = 0; IP < xNum; ++IP) {
                                br.skipBytes(4);
                            }
                        }
                    }
                }
                if (br.getFilePointer() + 10L > br.length()) break;
            }
            br.close();
            double[] newX = this.getXDimension().getValues();
            for (i = 0; i < xNum; ++i) {
                for (j = 0; j < yNum; ++j) {
                    newDataArray[j][i] = dataArray[i][j];
                }
            }
            GridData gridData = new GridData();
            gridData.data = newDataArray;
            gridData.xArray = newX;
            gridData.yArray = this.getYDimension().getValues();
            gridData.missingValue = this.getMissingValue();
            return gridData;
        }
        catch (IOException ex) {
            Logger.getLogger(ASCIIGridDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_TimeLat(int lonIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_TimeLon(int latIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLat(int lonIdx, int varIdx, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLon(int latIdx, int varIdx, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelTime(int latIdx, int varIdx, int lonIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Time(int lonIdx, int latIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Level(int lonIdx, int latIdx, int varIdx, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lon(int timeIdx, int latIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lat(int timeIdx, int lonIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

