/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.netcdf;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.ndarray.ArrayStructure;
import org.meteoinfo.ndarray.Dimension;
import org.meteoinfo.ndarray.InvalidRangeException;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Range;
import ucar.ma2.Section;

public class NCUtil {
    public static org.meteoinfo.ndarray.DataType convertDataType(DataType ncDataType) {
        org.meteoinfo.ndarray.DataType dataType = org.meteoinfo.ndarray.DataType.getType(ncDataType.toString());
        return dataType;
    }

    public static DataType convertDataType(org.meteoinfo.ndarray.DataType dataType) {
        DataType ncDataType = DataType.getType((String)dataType.toString());
        return ncDataType;
    }

    public static org.meteoinfo.ndarray.Array convertArray(Array ncArray) {
        if (ncArray == null) {
            return null;
        }
        org.meteoinfo.ndarray.DataType dt = NCUtil.convertDataType(ncArray.getDataType());
        if (dt == org.meteoinfo.ndarray.DataType.OBJECT && ncArray.getObject(0).getClass() == String.class) {
            dt = org.meteoinfo.ndarray.DataType.STRING;
        }
        org.meteoinfo.ndarray.Array array = null;
        switch (dt) {
            case STRUCTURE: 
            case SEQUENCE: {
                array = new ArrayStructure(ncArray.getShape());
                array.setArrayObject(ncArray);
                break;
            }
            default: {
                array = org.meteoinfo.ndarray.Array.factory(dt, ncArray.getShape(), ncArray.getStorage());
            }
        }
        return array;
    }

    public static Array convertArray(org.meteoinfo.ndarray.Array array) {
        Array ncArray = null;
        switch (array.getDataType()) {
            case STRUCTURE: 
            case SEQUENCE: {
                ncArray = (Array)((ArrayStructure)array).getArrayObject();
                break;
            }
            default: {
                ncArray = Array.factory((DataType)NCUtil.convertDataType(array.getDataType()), (int[])array.getShape(), (Object)array.getStorage());
            }
        }
        return ncArray;
    }

    public static Dimension convertDimension(ucar.nc2.Dimension ncDim) {
        Dimension dim = new Dimension();
        dim.setShortName(ncDim.getShortName());
        dim.setLength(ncDim.getLength());
        dim.setUnlimited(ncDim.isUnlimited());
        dim.setShared(ncDim.isShared());
        dim.setVariableLength(ncDim.isVariableLength());
        return dim;
    }

    public static List<Dimension> convertDimensions(List<ucar.nc2.Dimension> ncDims) {
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        for (ucar.nc2.Dimension ncDim : ncDims) {
            dims.add(NCUtil.convertDimension(ncDim));
        }
        return dims;
    }

    public static Attribute convertAttribute(ucar.nc2.Attribute ncAttr) {
        Attribute attr = new Attribute(ncAttr.getShortName());
        attr.setStringValue(ncAttr.getStringValue());
        attr.setValues(NCUtil.convertArray(ncAttr.getValues()));
        return attr;
    }

    public static ucar.nc2.Attribute convertAttribute(Attribute attr) {
        ucar.nc2.Attribute ncAttr = new ucar.nc2.Attribute(attr.getShortName(), NCUtil.convertArray(attr.getValues()));
        return ncAttr;
    }

    public static Variable convertVariable(ucar.nc2.Variable ncVar) {
        Variable var = new Variable();
        var.setName(ncVar.getShortName());
        var.setDataType(NCUtil.convertDataType(ncVar.getDataType()));
        var.setDescription(ncVar.getDescription());
        var.setDimensions(NCUtil.convertDimensions(ncVar.getDimensions()));
        for (ucar.nc2.Attribute ncAttr : ncVar.getAttributes()) {
            var.addAttribute(NCUtil.convertAttribute(ncAttr));
        }
        var.setUnits(ncVar.getUnitsString());
        return var;
    }

    public static org.meteoinfo.ndarray.Section convertSection(Section ncSection) {
        try {
            ArrayList<org.meteoinfo.ndarray.Range> ranges = new ArrayList<org.meteoinfo.ndarray.Range>();
            for (Range range : ncSection.getRanges()) {
                ranges.add(new org.meteoinfo.ndarray.Range(range.getName(), range.first(), range.last(), range.stride()));
            }
            org.meteoinfo.ndarray.Section section = new org.meteoinfo.ndarray.Section(ranges);
            return section;
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(NCUtil.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

