/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geoprocess;

import java.util.ArrayList;
import java.util.Arrays;
import org.meteoinfo.global.PointD;

public class Spline {
    private static PointD[] interpolateBezier(PointD p0, PointD p1, PointD p2, PointD p3, int samples) {
        PointD[] result = new PointD[samples];
        Vec2 v0 = new Vec2(p0);
        Vec2 v1 = new Vec2(p1);
        Vec2 v2 = new Vec2(p2);
        Vec2 v3 = new Vec2(p3);
        for (int i = 0; i < samples; ++i) {
            float t = (float)(i + 1) / ((float)samples + 1.0f);
            result[i] = v0.multiply((1.0f - t) * (1.0f - t) * (1.0f - t)).add(v1.multiply(3.0f * (1.0f - t) * (1.0f - t) * t)).add(v2.multiply(3.0f * (1.0f - t) * t * t)).add(v3.multiply(t * t * t)).toPointD();
        }
        return result;
    }

    private static PointD[] interpolateCardinalSpline(PointD p0, PointD p1, PointD p2, PointD p3, int samples) {
        float tension = 0.5f;
        Vec2 v0 = new Vec2(p0);
        Vec2 v1 = new Vec2(p1);
        Vec2 v2 = new Vec2(p2);
        Vec2 v3 = new Vec2(p3);
        PointD u = v2.subtract(v0).multiply(tension / 3.0f).add(v1).toPointD();
        PointD v = v1.subtract(v3).multiply(tension / 3.0f).add(v2).toPointD();
        return Spline.interpolateBezier(p1, u, v, p2, samples);
    }

    public static PointD[] cardinalSpline(PointD[] points, int samplesInSegment) {
        ArrayList<PointD> result = new ArrayList<PointD>();
        for (int i = 0; i < points.length - 1; ++i) {
            result.add(points[i]);
            PointD[] pds = Spline.interpolateCardinalSpline(points[Math.max(i - 1, 0)], points[i], points[i + 1], points[Math.min(i + 2, points.length - 1)], samplesInSegment);
            result.addAll(Arrays.asList(pds));
        }
        result.add(points[points.length - 1]);
        return result.toArray(new PointD[result.size()]);
    }

    private static class Vec2 {
        public double X;
        public double Y;

        public Vec2(double x, double y) {
            this.X = x;
            this.Y = y;
        }

        public Vec2(PointD p) {
            this.X = p.X;
            this.Y = p.Y;
        }

        public PointD toPointD() {
            return new PointD(this.X, this.Y);
        }

        public Vec2 add(Vec2 v) {
            return new Vec2(this.X + v.X, this.Y + v.Y);
        }

        public Vec2 subtract(Vec2 v) {
            return new Vec2(this.X - v.X, this.Y - v.Y);
        }

        public Vec2 multiply(float f) {
            return new Vec2(this.X * (double)f, this.Y * (double)f);
        }

        public Vec2 divide(float f) {
            return new Vec2(this.X / (double)f, this.Y / (double)f);
        }
    }
}

