/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.global.util;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.meteoinfo.data.mapdata.webmap.GeoPosition;
import org.meteoinfo.data.mapdata.webmap.TileFactoryInfo;
import org.w3c.dom.Document;

public final class GeoUtil {
    public static Dimension getMapSize(int zoom, TileFactoryInfo info) {
        return new Dimension(info.getMapWidthInTilesAtZoom(zoom), info.getMapWidthInTilesAtZoom(zoom));
    }

    public static boolean isValidTile(int x, int y, int zoomLevel, TileFactoryInfo info) {
        if (x < 0 || y < 0) {
            return false;
        }
        if (info.getMapCenterInPixelsAtZoom(zoomLevel).getX() * 2.0 <= (double)(x * info.getTileSize(zoomLevel))) {
            return false;
        }
        if (info.getMapCenterInPixelsAtZoom(zoomLevel).getY() * 2.0 <= (double)(y * info.getTileSize(zoomLevel))) {
            return false;
        }
        return zoomLevel >= info.getMinimumZoomLevel() && zoomLevel <= info.getMaximumZoomLevel();
    }

    public static Point2D getBitmapCoordinate(GeoPosition c, int zoomLevel, TileFactoryInfo info) {
        return GeoUtil.getBitmapCoordinate(c.getLatitude(), c.getLongitude(), zoomLevel, info);
    }

    public static Point2D getBitmapCoordinate(double latitude, double longitude, int zoomLevel, TileFactoryInfo info) {
        double x = info.getMapCenterInPixelsAtZoom(zoomLevel).getX() + longitude * info.getLongitudeDegreeWidthInPixels(zoomLevel);
        double e = Math.sin(latitude * (Math.PI / 180));
        if (e > 0.9999) {
            e = 0.9999;
        }
        if (e < -0.9999) {
            e = -0.9999;
        }
        double y = info.getMapCenterInPixelsAtZoom(zoomLevel).getY() + 0.5 * Math.log((1.0 + e) / (1.0 - e)) * -1.0 * info.getLongitudeRadianWidthInPixels(zoomLevel);
        return new Point2D.Double(x, y);
    }

    public static GeoPosition getPosition(Point2D pixelCoordinate, int zoom, TileFactoryInfo info) {
        double e2;
        double wx = pixelCoordinate.getX();
        double wy = pixelCoordinate.getY();
        double flon = (wx - info.getMapCenterInPixelsAtZoom(zoom).getX()) / info.getLongitudeDegreeWidthInPixels(zoom);
        double e1 = (wy - info.getMapCenterInPixelsAtZoom(zoom).getY()) / (-1.0 * info.getLongitudeRadianWidthInPixels(zoom));
        double flat = e2 = (2.0 * Math.atan(Math.exp(e1)) - 1.5707963267948966) / (Math.PI / 180);
        GeoPosition wc = new GeoPosition(flat, flon);
        return wc;
    }

    public static GeoPosition getPositionForAddress(String[] fields) throws IOException {
        return GeoUtil.getPositionForAddress(fields[0], fields[1], fields[2]);
    }

    public static GeoPosition getPositionForAddress(String street, String city, String state) throws IOException {
        try {
            URL load = new URL("http://api.local.yahoo.com/MapsService/V1/geocode?appid=joshy688&street=" + street.replace(' ', '+') + "&city=" + city.replace(' ', '+') + "&state=" + state.replace(' ', '+'));
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(load.openConnection().getInputStream());
            XPath xpath = XPathFactory.newInstance().newXPath();
            Double lat = (Double)xpath.evaluate("//Result/Latitude/text()", doc, XPathConstants.NUMBER);
            Double lon = (Double)xpath.evaluate("//Result/Longitude/text()", doc, XPathConstants.NUMBER);
            return new GeoPosition(lat, lon);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Failed to retrieve location information from the internet: " + e.toString());
        }
    }

    public static double getResolution(int zoomLevel, double lat) {
        double latRadians = lat * Math.PI / 180.0;
        double res = 156543.034 * Math.cos(latRadians) / Math.pow(2.0, zoomLevel);
        return res;
    }

    public static double getScale(int zoomLevel, double lat) {
        int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        double scale = 1.0 / ((double)dpi * 39.37 * GeoUtil.getResolution(zoomLevel, lat));
        return scale;
    }
}

