/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.map;

import com.l2fprod.common.beans.BaseBeanInfo;
import com.l2fprod.common.beans.ExtendedPropertyDescriptor;
import com.l2fprod.common.beans.editor.ComboBoxPropertyEditor;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.layer.LayerTypes;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.map.MapView;
import org.meteoinfo.shape.ShapeTypes;

public class MaskOut {
    private static MapView _mapView;
    private boolean _setMaskLayer;
    private String _maskLayer;
    private List<String> _layerList;

    public MaskOut(MapView aMapView) {
        _mapView = aMapView;
        this._setMaskLayer = false;
        this._maskLayer = "";
    }

    public void setMapView(MapView mapView) {
        _mapView = mapView;
    }

    public List<String> getPolygonMapLayers() {
        return this._layerList;
    }

    public void setPolygonMapLayers(List<String> layers) {
        this._layerList = layers;
    }

    public boolean isMask() {
        return this._setMaskLayer;
    }

    public void setMask(boolean istrue) {
        this._setMaskLayer = istrue;
        _mapView.paintLayers();
    }

    public String getMaskLayer() {
        return this._maskLayer;
    }

    public void setMaskLayer(String lname) {
        this._maskLayer = lname;
        _mapView.paintLayers();
    }

    public static List<String> getLayerNames() {
        ArrayList<String> layerNames = new ArrayList<String>();
        for (MapLayer aLayer : _mapView.getLayers()) {
            if (aLayer.getLayerType() != LayerTypes.VectorLayer || aLayer.getShapeType() != ShapeTypes.Polygon) continue;
            layerNames.add(aLayer.getLayerName());
        }
        return layerNames;
    }

    public static class LayerNameEditor
    extends ComboBoxPropertyEditor {
        public LayerNameEditor() {
            Object[] names = MaskOut.getLayerNames().toArray(new String[0]);
            this.setAvailableValues(names);
        }
    }

    public static class MaskOutBeanBeanInfo
    extends BaseBeanInfo {
        public MaskOutBeanBeanInfo() {
            super(MaskOutBean.class);
            ExtendedPropertyDescriptor e = this.addProperty("maskLayer");
            e.setCategory("General").setPropertyEditorClass(LayerNameEditor.class);
            e.setDisplayName("Layer Name");
            e.setShortDescription("The name of the layers can be used as maskout");
            e = this.addProperty("mask");
            e.setCategory("General").setDisplayName("Is Maskout");
        }
    }

    public class MaskOutBean {
        public boolean isMask() {
            return MaskOut.this._setMaskLayer;
        }

        public void setMask(boolean istrue) {
            MaskOut.this._setMaskLayer = istrue;
            _mapView.paintLayers();
        }

        public String getMaskLayer() {
            return MaskOut.this._maskLayer;
        }

        public void setMaskLayer(String lname) {
            MaskOut.this._maskLayer = lname;
            _mapView.paintLayers();
        }
    }
}

