/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.fitting;

import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import org.meteoinfo.math.fitting.TrendLine;
import org.meteoinfo.ndarray.Array;

public abstract class OLSTrendLine
implements TrendLine {
    RealMatrix coef = null;
    double rs;

    protected abstract double[] xVector(double var1);

    protected abstract boolean logY();

    @Override
    public void setValues(Array y, Array x) {
        int i;
        if (x.getSize() != y.getSize()) {
            throw new IllegalArgumentException(String.format("The numbers of y and x values must be equal (%d != %d)", y.getSize(), x.getSize()));
        }
        y = y.copyIfView();
        x = x.copyIfView();
        double[][] xData = new double[(int)x.getSize()][];
        int i2 = 0;
        while ((long)i2 < x.getSize()) {
            xData[i2] = this.xVector(x.getDouble(i2));
            ++i2;
        }
        double[] yy = new double[(int)y.getSize()];
        if (this.logY()) {
            for (i = 0; i < yy.length; ++i) {
                yy[i] = (long)i < x.getSize() ? Math.log(y.getDouble(i)) : y.getDouble(i);
            }
        } else {
            for (i = 0; i < yy.length; ++i) {
                yy[i] = y.getDouble(i);
            }
        }
        OLSMultipleLinearRegression ols = new OLSMultipleLinearRegression();
        ols.setNoIntercept(true);
        ols.newSampleData(yy, (double[][])xData);
        this.coef = MatrixUtils.createColumnRealMatrix((double[])ols.estimateRegressionParameters());
        this.rs = ols.calculateRSquared();
    }

    @Override
    public double predict(double x) {
        double yhat = this.coef.preMultiply(this.xVector(x))[0];
        if (this.logY()) {
            yhat = Math.exp(yhat);
        }
        return yhat;
    }
}

