/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.info;

import java.util.List;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.meteoinfo.global.PointD;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.info.ProjectionInfo;
import org.meteoinfo.shape.PolygonShape;

public class GeostationarySatellite
extends ProjectionInfo {
    public GeostationarySatellite(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    @Override
    public ProjectionNames getProjectionName() {
        return ProjectionNames.Geostationary_Satellite;
    }

    @Override
    void updateBoundary() {
        double epsilon = 1.0E-10;
        double a = this.crs.getDatum().getEllipsoid().getA();
        double b = this.crs.getDatum().getEllipsoid().getB();
        double h = this.crs.getProjection().getHeightOfOrbit();
        double max_x = h * Math.asin(a / (a + h));
        double max_y = h * Math.asin(b / (a + h));
        double easting = this.crs.getProjection().getFalseEasting();
        double northing = this.crs.getProjection().getFalseNorthing();
        List<PointD> points = this.ellipse_boundary(max_x, max_y, easting, northing, 201);
        PolygonShape ps = new PolygonShape();
        ps.setPoints(points);
        this.boundary = ps;
    }
}

