/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.info;

import java.util.ArrayList;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.meteoinfo.global.PointD;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.ProjectionUtil;
import org.meteoinfo.projection.info.ProjectionInfo;
import org.meteoinfo.shape.PolygonShape;

public class Molleweide
extends ProjectionInfo {
    public Molleweide(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    @Override
    public ProjectionNames getProjectionName() {
        return ProjectionNames.Molleweide;
    }

    @Override
    void updateBoundary() {
        double lat;
        double epsilon = 1.0E-10;
        double cenLon = this.getCenterLon();
        double minLon = cenLon - 180.0 + epsilon;
        double maxLon = cenLon + 180.0 - epsilon;
        double minLat = -90.0;
        double maxLat = 90.0;
        ArrayList<PointD> points = new ArrayList<PointD>();
        double lon = minLon;
        lon = maxLon;
        for (lat = minLat; lat < maxLat; lat += 1.0) {
            points.add(new PointD(lon, lat));
        }
        lon = minLon;
        for (lat = maxLat; lat > minLat; lat -= 1.0) {
            points.add(new PointD(lon, lat));
        }
        lat = minLat;
        points.add(new PointD(lon, lat));
        PolygonShape ps = new PolygonShape();
        ps.setPoints(points);
        this.boundary = ProjectionUtil.projectPolygonShape(ps, KnownCoordinateSystems.geographic.world.WGS1984, this);
    }
}

