/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.info;

import java.util.List;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.meteoinfo.global.PointD;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.info.ProjectionInfo;
import org.meteoinfo.shape.PolygonShape;

public class OrthographicAzimuthal
extends ProjectionInfo {
    public OrthographicAzimuthal(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    @Override
    public ProjectionNames getProjectionName() {
        return ProjectionNames.Orthographic_Azimuthal;
    }

    @Override
    void updateBoundary() {
        double a = this.crs.getDatum().getEllipsoid().getA();
        double b = this.crs.getDatum().getEllipsoid().getB();
        double easting = this.crs.getProjection().getFalseEasting();
        double northing = this.crs.getProjection().getFalseNorthing();
        List<PointD> points = this.ellipse_boundary(a, b, easting, northing, 201);
        PolygonShape ps = new PolygonShape();
        ps.setPoints(points);
        this.boundary = ps;
    }
}

