/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.info;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.InvalidValueException;
import org.locationtech.proj4j.datum.Datum;
import org.locationtech.proj4j.datum.Ellipsoid;
import org.locationtech.proj4j.parser.Proj4Parser;
import org.locationtech.proj4j.proj.Projection;
import org.meteoinfo.global.PointD;
import org.meteoinfo.math.ArrayUtil;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.projection.ProjRegistry;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.info.Albers;
import org.meteoinfo.projection.info.Common;
import org.meteoinfo.projection.info.GeostationarySatellite;
import org.meteoinfo.projection.info.Hammer;
import org.meteoinfo.projection.info.LambertAzimuthalEqualArea;
import org.meteoinfo.projection.info.LambertConformalConic;
import org.meteoinfo.projection.info.LambertEqualAreaConic;
import org.meteoinfo.projection.info.LongLat;
import org.meteoinfo.projection.info.Mercator;
import org.meteoinfo.projection.info.Molleweide;
import org.meteoinfo.projection.info.OrthographicAzimuthal;
import org.meteoinfo.projection.info.Robinson;
import org.meteoinfo.projection.info.Sinusoidal;
import org.meteoinfo.projection.info.StereographicAzimuthal;
import org.meteoinfo.projection.info.TransverseMercator;
import org.meteoinfo.projection.info.Wagner3;
import org.meteoinfo.shape.PolygonShape;

public abstract class ProjectionInfo {
    protected CoordinateReferenceSystem crs;
    protected PolygonShape boundary;
    protected float cutoff = Float.NaN;

    public static ProjectionInfo factory(CoordinateReferenceSystem crs) {
        ProjectionInfo projInfo;
        Projection proj = crs.getProjection();
        switch (proj.toString()) {
            case "LongLat": {
                projInfo = new LongLat(crs);
                break;
            }
            case "Albers Equal Area": {
                projInfo = new Albers(crs);
                break;
            }
            case "Lambert Conformal Conic": {
                projInfo = new LambertConformalConic(crs);
                break;
            }
            case "Lambert Equal Area Conic": {
                projInfo = new LambertEqualAreaConic(crs);
                break;
            }
            case "Lambert Azimuthal Equal Area": {
                projInfo = new LambertAzimuthalEqualArea(crs);
                break;
            }
            case "Stereographic Azimuthal": {
                projInfo = new StereographicAzimuthal(crs);
                break;
            }
            case "Mercator": {
                projInfo = new Mercator(crs);
                break;
            }
            case "Robinson": {
                projInfo = new Robinson(crs);
                break;
            }
            case "Molleweide": {
                projInfo = new Molleweide(crs);
                break;
            }
            case "Geostationary Satellite": {
                projInfo = new GeostationarySatellite(crs);
                break;
            }
            case "Sinusoidal": {
                projInfo = new Sinusoidal(crs);
                break;
            }
            case "Orthographic Azimuthal": {
                projInfo = new OrthographicAzimuthal(crs);
                break;
            }
            case "Hammer Eckert": {
                projInfo = new Hammer(crs);
                break;
            }
            case "Universal Tranverse Mercator": 
            case "Transverse Mercator": {
                projInfo = new TransverseMercator(crs);
                break;
            }
            case "Wagner III": {
                projInfo = new Wagner3(crs);
                break;
            }
            default: {
                projInfo = new Common(crs);
            }
        }
        projInfo.updateBoundary();
        return projInfo;
    }

    public static ProjectionInfo factory(String proj4Str) {
        CRSFactory crsFactory = new CRSFactory();
        proj4Str = proj4Str.replace("+", " +");
        proj4Str = proj4Str.trim();
        return ProjectionInfo.factory(crsFactory.createFromParameters("custom", proj4Str));
    }

    public static ProjectionInfo factoryESRI(String esriStr) {
        CRSFactory crsFactory = new CRSFactory();
        ProjRegistry registry = new ProjRegistry();
        String[] params = ProjectionInfo.getParameterArray(ProjectionInfo.esriStringToProj4Params(registry, esriStr));
        Proj4Parser parser = new Proj4Parser(crsFactory.getRegistry());
        CoordinateReferenceSystem crs = parser.parse("custom", params);
        return ProjectionInfo.factory(crs);
    }

    public static ProjectionInfo factory(ProjectionNames name) {
        CRSFactory crsFactory = new CRSFactory();
        String proj4Str = "+proj=" + name.getProj4Name();
        return ProjectionInfo.factory(crsFactory.createFromParameters("custom", proj4Str));
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public abstract ProjectionNames getProjectionName();

    public boolean isLonLat() {
        return this.getProjectionName() == ProjectionNames.LongLat;
    }

    public double getCenterLon() {
        return this.crs.getProjection().getProjectionLongitudeDegrees();
    }

    public double getCenterLat() {
        return this.crs.getProjection().getProjectionLatitudeDegrees();
    }

    public PolygonShape getBoundary() {
        return this.boundary;
    }

    public void setBoundary(PolygonShape value) {
        this.boundary = value;
    }

    public float getCutoff() {
        return this.cutoff;
    }

    public void setCutoff(float value) {
    }

    public void setCutoff_bak(float value) {
        this.cutoff = value;
        this.updateBoundary();
    }

    public List<String> getValidParas() {
        return new ArrayList<String>();
    }

    void updateBoundary() {
    }

    protected List<PointD> ellipse_boundary(double semimajor, double semiminor, double easting, double northing, int n) {
        Array t = ArrayUtil.lineSpace(0, Math.PI * -2, n, true);
        ArrayList<PointD> r = new ArrayList<PointD>();
        int i = 0;
        while ((long)i < t.getSize()) {
            double x = semimajor * Math.cos(t.getDouble(i)) + easting;
            double y = semiminor * Math.sin(t.getDouble(i)) + northing;
            r.add(new PointD(x, y));
            ++i;
        }
        return r;
    }

    public double getRefCutLon() {
        double refLon = this.getCoordinateReferenceSystem().getProjection().getProjectionLongitudeDegrees();
        if ((refLon += 180.0) > 180.0) {
            refLon -= 360.0;
        } else if (refLon < -180.0) {
            refLon += 360.0;
        }
        return refLon;
    }

    public String toProj4String() {
        return this.crs.getParameterString();
    }

    public double getInverseFlattening(Ellipsoid ellipsoid) {
        if (ellipsoid.poleRadius == ellipsoid.equatorRadius) {
            return 0.0;
        }
        return ellipsoid.equatorRadius / (ellipsoid.equatorRadius - ellipsoid.poleRadius);
    }

    private static String[] getParameterArray(Map params) {
        String[] args = new String[params.size()];
        int i = 0;
        Set key = params.keySet();
        for (String s : key) {
            args[i] = "+" + s + "=" + params.get(s);
            ++i;
        }
        return args;
    }

    public static Map esriStringToProj4Params(ProjRegistry registry, String esriString) {
        int iEnd;
        int iStart;
        String value;
        String key;
        HashMap<String, String> params = new HashMap<String, String>();
        if (!esriString.contains("PROJCS")) {
            key = "proj";
            value = "longlat";
            params.put(key, value);
        } else {
            Projection projection = null;
            iStart = esriString.indexOf("PROJECTION") + 12;
            String s = esriString.substring(iStart, iEnd = esriString.indexOf("]", iStart) - 1);
            if (s != null && (projection = registry.getProjectionEsri(s)) == null) {
                throw new InvalidValueException("Unknown projection: " + s);
            }
            String proj4Name = registry.getProj4Name(projection);
            key = "proj";
            value = proj4Name;
            params.put(key, value);
        }
        if (esriString.contains("DATUM") && (iEnd = esriString.indexOf(",", iStart = esriString.indexOf("DATUM") + 7) - 1) > iStart) {
            key = "datum";
            value = esriString.substring(iStart, iEnd);
            value = value.equals("D_WGS_1984") ? "WGS84" : "WGS84";
            params.put(key, value);
        }
        if (esriString.contains("SPHEROID") && (iEnd = esriString.indexOf("]", iStart = esriString.indexOf("SPHEROID") + 9)) > iStart) {
            String extracted = esriString.substring(iStart, iEnd);
            String[] terms = extracted.split(",");
            String name = terms[0];
            name = (name = name.substring(1, name.length() - 1)).equals("WGS_1984") ? "WGS84" : "WGS84";
            key = "ellps";
            value = name;
            params.put(key, value);
            key = "a";
            value = terms[1];
            params.put(key, value);
            key = "rf";
            value = terms[2];
            params.put(key, value);
        }
        if ((value = ProjectionInfo.getParameter("False_Easting", esriString)) != null) {
            key = "x_0";
            params.put(key, value);
        }
        if ((value = ProjectionInfo.getParameter("False_Northing", esriString)) != null) {
            key = "y_0";
            params.put(key, value);
        }
        if ((value = ProjectionInfo.getParameter("Central_Meridian", esriString)) != null) {
            key = "lon_0";
            params.put(key, value);
        }
        if ((value = ProjectionInfo.getParameter("Standard_Parallel_1", esriString)) != null) {
            key = "lat_1";
            params.put(key, value);
        }
        if ((value = ProjectionInfo.getParameter("Standard_Parallel_2", esriString)) != null) {
            key = "lat_2";
            params.put(key, value);
        }
        if ((value = ProjectionInfo.getParameter("Scale_Factor", esriString)) != null) {
            key = "k_0";
            params.put(key, value);
        }
        if ((value = ProjectionInfo.getParameter("Latitude_Of_Origin", esriString)) != null) {
            key = "lat_0";
            params.put(key, value);
        }
        return params;
    }

    private static String getParameter(String name, String esriString) {
        String result = null;
        String par = "PARAMETER[\"" + name;
        int iStart = esriString.toLowerCase().indexOf(par.toLowerCase());
        if (iStart >= 0) {
            int iEnd = esriString.indexOf(",", iStart += 13 + name.length()) - 1;
            result = esriString.substring(iStart, iEnd);
        }
        return result;
    }

    public String toEsriString(Ellipsoid ellipsoid) {
        return "SPHEROID[\"" + ellipsoid.getName() + "\"," + ellipsoid.getEquatorRadius() + "," + this.getInverseFlattening(ellipsoid) + "]";
    }

    public String toEsriString(Datum datum) {
        return "DATUM[\"" + datum.getName() + "\"," + this.toEsriString(datum.getEllipsoid()) + "]";
    }

    public String toEsriString() {
        String result = "";
        String geoName = "GCS_WGS_1984";
        Projection proj = this.crs.getProjection();
        if (proj.getName().equals("longlat")) {
            result = "GEOGCS[\"" + geoName + "\"," + this.toEsriString(this.crs.getDatum()) + ",PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]]";
            return result;
        }
        String name = "Custom";
        result = "PROJCS[\"" + name + "\",GEOGCS[\"" + geoName + "\"," + this.toEsriString(this.crs.getDatum()) + ",PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]], ";
        result = result + "PROJECTION[\"" + proj.getName() + "\"],";
        result = result + "PARAMETER[\"False_Easting\"," + String.valueOf(proj.getFalseEasting()) + "],";
        result = result + "PARAMETER[\"False_Northing\"," + String.valueOf(proj.getFalseNorthing()) + "],";
        result = result + "PARAMETER[\"Central_Meridian\"," + String.valueOf(proj.getProjectionLongitudeDegrees()) + "],";
        result = result + "PARAMETER[\"Standard_Parallel_1\"," + String.valueOf(proj.getProjectionLatitude1Degrees()) + "],";
        result = result + "PARAMETER[\"Standard_Parallel_2\"," + String.valueOf(proj.getProjectionLatitude2Degrees()) + "],";
        result = result + "PARAMETER[\"Scale_Factor\"," + String.valueOf(proj.getScaleFactor()) + "],";
        result = result + "PARAMETER[\"Latitude_Of_Origin\"," + String.valueOf(proj.getProjectionLatitudeDegrees()) + "],";
        result = result + "UNIT[\"Meter\",1.0]]";
        return result;
    }

    public String toString() {
        return this.crs.getParameterString();
    }

    public boolean equals(Projection projA, Projection projB) {
        if (!projA.getName().equals(projB.getName())) {
            return false;
        }
        if (projA.getEquatorRadius() != projB.getEquatorRadius()) {
            return false;
        }
        if (projA.getEllipsoid().eccentricity != projB.getEllipsoid().eccentricity) {
            return false;
        }
        if (!projA.getEllipsoid().isEqual(projA.getEllipsoid(), 1.0E-7)) {
            return false;
        }
        if (projA.getEllipsoid().eccentricity2 != projB.getEllipsoid().eccentricity2) {
            return false;
        }
        if (projA.getFalseEasting() != projB.getFalseEasting()) {
            return false;
        }
        if (projA.getFalseNorthing() != projB.getFalseNorthing()) {
            return false;
        }
        if (projA.getFromMetres() != projB.getFromMetres()) {
            return false;
        }
        if (projA.getProjectionLatitudeDegrees() != projB.getProjectionLatitudeDegrees()) {
            return false;
        }
        if (projA.getProjectionLatitude1Degrees() != projB.getProjectionLatitude1Degrees()) {
            return false;
        }
        if (projA.getProjectionLongitudeDegrees() != projB.getProjectionLongitudeDegrees()) {
            return false;
        }
        if (projA.getScaleFactor() != projB.getScaleFactor()) {
            return false;
        }
        return projA.getTrueScaleLatitudeDegrees() == projB.getTrueScaleLatitudeDegrees();
    }

    public boolean equals(ProjectionInfo projInfo) {
        String proj4Str2;
        if (this.getProjectionName() == ProjectionNames.LongLat && projInfo.getProjectionName() == ProjectionNames.LongLat) {
            return true;
        }
        String proj4Str1 = this.toProj4String();
        if (proj4Str1.equals(proj4Str2 = projInfo.toProj4String())) {
            return true;
        }
        if (!this.crs.getDatum().isEqual(projInfo.crs.getDatum())) {
            return false;
        }
        return this.equals(this.crs.getProjection(), projInfo.crs.getProjection());
    }

    public static double calScaleFactorFromStandardParallel(double stP) {
        double e = 0.081819191;
        double tF = (stP = Math.PI * stP / 180.0) > 0.0 ? Math.tan(0.7853981633974483 - stP / 2.0) * Math.pow((1.0 + e * Math.sin(stP)) / (1.0 - e * Math.sin(stP)), e / 2.0) : Math.tan(0.7853981633974483 + stP / 2.0) / Math.pow((1.0 + e * Math.sin(stP)) / (1.0 - e * Math.sin(stP)), e / 2.0);
        double mF = Math.cos(stP) / Math.pow(1.0 - e * e * Math.pow(Math.sin(stP), 2.0), 0.5);
        double k0 = mF * Math.pow(Math.pow(1.0 + e, 1.0 + e) * Math.pow(1.0 - e, 1.0 - e), 0.5) / (2.0 * tF);
        return k0;
    }
}

