/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.info;

import java.util.ArrayList;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.meteoinfo.global.PointD;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.ProjectionUtil;
import org.meteoinfo.projection.info.ProjectionInfo;
import org.meteoinfo.shape.PolygonShape;

public class StereographicAzimuthal
extends ProjectionInfo {
    public StereographicAzimuthal(CoordinateReferenceSystem crs) {
        this.crs = crs;
        this.cutoff = 0.0f;
    }

    @Override
    public ProjectionNames getProjectionName() {
        if (this.isNorthPolar()) {
            return ProjectionNames.North_Polar_Stereographic_Azimuthal;
        }
        if (this.isSouthPolar()) {
            return ProjectionNames.South_Polar_Stereographic_Azimuthal;
        }
        return ProjectionNames.Stereographic_Azimuthal;
    }

    public boolean isNorthPolar() {
        return this.crs.getProjection().getProjectionLatitudeDegrees() == 90.0;
    }

    public boolean isSouthPolar() {
        return this.crs.getProjection().getProjectionLatitudeDegrees() == -90.0;
    }

    @Override
    public void setCutoff(float value) {
        this.cutoff = value;
        this.updateBoundary();
    }

    @Override
    void updateBoundary() {
        ArrayList<PointD> points = new ArrayList<PointD>();
        double lat = this.cutoff;
        for (double lon = -180.0; lon <= 180.0; lon += 1.0) {
            points.add(new PointD(lon, lat));
        }
        PolygonShape ps = new PolygonShape();
        ps.setPoints(points);
        this.boundary = ProjectionUtil.projectPolygonShape(ps, KnownCoordinateSystems.geographic.world.WGS1984, this);
    }
}

