/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.shape;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointD;
import org.meteoinfo.shape.PointZ;
import org.meteoinfo.shape.Shape;
import org.meteoinfo.shape.ShapeTypes;

public class CylinderShape
extends Shape {
    private List<PointZ> points;
    double radius = 1.0;

    public CylinderShape() {
        this.points = new ArrayList<PointZ>();
        this.points.add(new PointZ());
        this.points.add(new PointZ());
        this.setExtent(MIMath.getPointsExtent(this.points));
    }

    public CylinderShape(List<PointZ> points, double radius) {
        this.points = points;
        this.radius = radius;
        this.setExtent(MIMath.getPointsExtent(this.points));
    }

    public CylinderShape(PointZ p1, PointZ p2, double radius) {
        this.points = new ArrayList<PointZ>();
        this.points.add(p1);
        this.points.add(p2);
        this.radius = radius;
        this.setExtent(MIMath.getPointsExtent(this.points));
    }

    @Override
    public ShapeTypes getShapeType() {
        return ShapeTypes.CYLINDER;
    }

    @Override
    public Geometry toGeometry(GeometryFactory factory) {
        return null;
    }

    public List<PointZ> getPoints() {
        return this.points;
    }

    public PointZ getPoint(int i) {
        return this.points.get(i);
    }

    @Override
    public void setPoints(List<? extends PointD> value) {
        this.points = value;
        this.setExtent(MIMath.getPointsExtent(this.points));
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double value) {
        this.radius = value;
    }

    public double getDiameter() {
        return this.radius * 2.0;
    }

    public double getHeight() {
        return this.points.get((int)1).Z - this.points.get((int)0).Z;
    }
}

