/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.shape;

public enum ShapeTypes {
    Point(1),
    Polyline(3),
    Polygon(5),
    PointZ(11),
    PolylineZ(13),
    PolygonZ(15),
    PointM(21),
    PolylineM(23),
    PolygonM(25),
    WindArraw(41),
    WindBarb(42),
    WeatherSymbol(43),
    StationModel(44),
    Image(99),
    Rectangle(51),
    CurveLine(52),
    CurvePolygon(53),
    Ellipse(54),
    Circle(55),
    Bar(56),
    PolylineError(57),
    ARC(58),
    TEXT(59),
    TEXTURE(60),
    CUBIC(61),
    CYLINDER(62),
    CONE(63),
    SPHERE(64);

    private final int value;

    public int getValue() {
        return this.value;
    }

    private ShapeTypes(int value) {
        this.value = value;
    }

    public static ShapeTypes valueOf(int ordinal) {
        switch (ordinal) {
            case 1: {
                return Point;
            }
            case 3: {
                return Polyline;
            }
            case 5: {
                return Polygon;
            }
            case 11: {
                return PointZ;
            }
            case 13: {
                return PolylineZ;
            }
            case 15: {
                return PolygonZ;
            }
            case 21: {
                return PointM;
            }
            case 23: {
                return PolylineM;
            }
            case 25: {
                return PolygonM;
            }
            case 41: {
                return WindArraw;
            }
            case 42: {
                return WindBarb;
            }
            case 43: {
                return WeatherSymbol;
            }
            case 44: {
                return StationModel;
            }
            case 51: {
                return Rectangle;
            }
            case 52: {
                return CurveLine;
            }
            case 53: {
                return CurvePolygon;
            }
            case 54: {
                return Ellipse;
            }
            case 55: {
                return Circle;
            }
            case 99: {
                return Image;
            }
        }
        throw new IndexOutOfBoundsException("Invalid ordinal");
    }

    public boolean isPoint() {
        switch (this) {
            case Point: 
            case PointM: 
            case PointZ: 
            case WindArraw: 
            case WindBarb: 
            case WeatherSymbol: 
            case StationModel: {
                return true;
            }
        }
        return false;
    }

    public boolean isLine() {
        switch (this) {
            case Polyline: 
            case PolylineZ: 
            case PolylineM: 
            case CurveLine: {
                return true;
            }
        }
        return false;
    }

    public boolean isPolygon() {
        switch (this) {
            case Polygon: 
            case PolygonM: 
            case PolygonZ: 
            case Rectangle: 
            case CurvePolygon: 
            case Ellipse: 
            case Circle: {
                return true;
            }
        }
        return false;
    }

    public boolean isSameLegendType(ShapeTypes st) {
        if (this == st) {
            return true;
        }
        if (this.isLine() && st.isLine()) {
            return true;
        }
        if (this.isPoint() && st.isPoint()) {
            return true;
        }
        return this.isPolygon() && st.isPolygon();
    }
}

