/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.table;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.meteoinfo.global.util.DateUtil;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.table.DataColumn;

public class ColumnData {
    private DataColumn dataColumn;
    private List data;

    public ColumnData(DataColumn col) {
        this.dataColumn = col;
        switch (col.getDataType()) {
            case INT: {
                this.data = new ArrayList();
                break;
            }
            case FLOAT: {
                this.data = new ArrayList();
                break;
            }
            case DOUBLE: {
                this.data = new ArrayList();
                break;
            }
            case STRING: {
                this.data = new ArrayList();
                break;
            }
            case DATE: {
                this.data = new ArrayList();
                break;
            }
            case BOOLEAN: {
                this.data = new ArrayList();
            }
        }
    }

    public ColumnData(String colName, DataType type) {
        this(new DataColumn(colName, type));
    }

    public DataColumn getDataColumn() {
        return this.dataColumn;
    }

    public void setDataColumn(DataColumn value) {
        this.dataColumn = value;
    }

    public List getData() {
        return this.data;
    }

    public void setData(List value) {
        this.data = value;
    }

    public DataType getDataType() {
        return this.dataColumn.getDataType();
    }

    public int size() {
        return this.data.size();
    }

    public void addData(Object value) {
        switch (this.dataColumn.getDataType()) {
            case INT: {
                this.addData((Integer)value);
                break;
            }
            case FLOAT: {
                this.addData((Float)value);
                break;
            }
            case DOUBLE: {
                this.addData((Double)value);
                break;
            }
            case STRING: {
                this.addData((String)value);
                break;
            }
            case DATE: {
                this.addData((Date)value);
                break;
            }
            case BOOLEAN: {
                this.addData((Boolean)value);
            }
        }
    }

    public void addData(Double value) {
        this.data.add(value);
    }

    public void addData(Float value) {
        this.data.add(value);
    }

    public void addData(Integer value) {
        this.data.add(value);
    }

    public void addData(String value) {
        this.data.add(value);
    }

    public void addData(Date value) {
        this.data.add(value);
    }

    public void addData(boolean value) {
        this.data.add(value);
    }

    public Object getValue(int idx) {
        switch (this.dataColumn.getDataType()) {
            case INT: {
                return (Integer)this.data.get(idx);
            }
            case FLOAT: {
                return (Float)this.data.get(idx);
            }
            case DOUBLE: {
                return (Double)this.data.get(idx);
            }
            case STRING: {
                return (String)this.data.get(idx);
            }
            case DATE: {
                return (Date)this.data.get(idx);
            }
            case BOOLEAN: {
                return (Boolean)this.data.get(idx);
            }
        }
        return null;
    }

    public List<String> getDataStrings() {
        ArrayList<String> r = new ArrayList<String>();
        for (Object v : this.data) {
            r.add(v.toString());
        }
        return r;
    }

    public List<Number> getDataValues() {
        if (this.dataColumn.getDataType() == DataType.DOUBLE) {
            return this.data;
        }
        ArrayList<Number> values = new ArrayList<Number>();
        switch (this.dataColumn.getDataType()) {
            case INT: {
                Iterator iterator = this.data.iterator();
                while (iterator.hasNext()) {
                    int v = (Integer)iterator.next();
                    values.add(v);
                }
                break;
            }
            case FLOAT: {
                for (Object v : this.data) {
                    if (v == null) {
                        values.add(Float.valueOf(Float.NaN));
                        continue;
                    }
                    values.add(Float.valueOf(((Float)v).floatValue()));
                }
                break;
            }
            case STRING: {
                for (String v : this.data) {
                    if (v.isEmpty()) {
                        values.add(Double.NaN);
                        continue;
                    }
                    values.add(Double.parseDouble(v));
                }
                break;
            }
            case DATE: {
                for (Date v : this.data) {
                    values.add(DateUtil.toOADate(v));
                }
                break;
            }
        }
        return values;
    }

    public List<Number> getValidDataValues() {
        List<Number> values = this.getDataValues();
        int len = values.size();
        for (int i = 0; i < len; ++i) {
            if (!Double.isNaN(values.get(i).doubleValue())) continue;
            values.remove(i);
            --len;
            --i;
        }
        return values;
    }

    public boolean contains(Object value) {
        return this.data.contains(value);
    }

    public Double mean() {
        double mean = 0.0;
        int n = 0;
        switch (this.dataColumn.getDataType()) {
            case INT: {
                Iterator iterator = this.data.iterator();
                while (iterator.hasNext()) {
                    int v = (Integer)iterator.next();
                    mean += (double)v;
                    ++n;
                }
                break;
            }
            case FLOAT: {
                Iterator iterator = this.data.iterator();
                while (iterator.hasNext()) {
                    float v = ((Float)iterator.next()).floatValue();
                    if (v == Float.NaN) continue;
                    mean += (double)v;
                    ++n;
                }
                break;
            }
            case DOUBLE: {
                Iterator iterator = this.data.iterator();
                while (iterator.hasNext()) {
                    double v = (Double)iterator.next();
                    if (v == Double.NaN) continue;
                    mean += v;
                    ++n;
                }
                break;
            }
        }
        if (n > 0) {
            return mean /= (double)n;
        }
        return Double.NaN;
    }

    public ColumnData add(Object value, String colName) {
        ColumnData rColData;
        block31: {
            DataType thisType = this.dataColumn.getDataType();
            if (!thisType.isNumeric()) {
                return null;
            }
            DataType inType = this.getDataType(value);
            if (!inType.isNumeric()) {
                return null;
            }
            rColData = null;
            switch (thisType) {
                case INT: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.INT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData(Float.valueOf((float)((Integer)this.getValue(i)).intValue() + (float)((Integer)value).intValue()));
                            }
                            break;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData(Float.valueOf((float)((Integer)this.getValue(i)).intValue() + ((Float)value).floatValue()));
                            }
                            break;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData((double)((Integer)this.getValue(i)).intValue() + (Double)value);
                            }
                            break;
                        }
                    }
                    break;
                }
                case FLOAT: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData(Float.valueOf(((Float)this.getValue(i)).floatValue() + (float)((Integer)value).intValue()));
                            }
                            break;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData(Float.valueOf(((Float)this.getValue(i)).floatValue() + ((Float)value).floatValue()));
                            }
                            break;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData((double)((Float)this.getValue(i)).floatValue() + (Double)value);
                            }
                            break;
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData((Double)this.getValue(i) + (double)((Integer)value).intValue());
                            }
                            break block31;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData((Double)this.getValue(i) + (double)((Float)value).floatValue());
                            }
                            break block31;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData((Double)this.getValue(i) + (Double)value);
                            }
                        }
                    }
                }
            }
        }
        return rColData;
    }

    public ColumnData add(ColumnData colData, String colName) {
        DataType thisType = this.dataColumn.getDataType();
        if (thisType == DataType.DATE || thisType == DataType.BOOLEAN) {
            return null;
        }
        DataType inType = colData.getDataType();
        if (inType == DataType.DATE || inType == DataType.BOOLEAN) {
            return null;
        }
        if (thisType == DataType.STRING && inType != DataType.STRING) {
            return null;
        }
        if (inType == DataType.STRING && thisType != DataType.STRING) {
            return null;
        }
        ColumnData rColData = null;
        switch (thisType) {
            case INT: {
                switch (inType) {
                    case INT: {
                        rColData = new ColumnData(colName, DataType.INT);
                        for (int i = 0; i < this.data.size(); ++i) {
                            if (i >= colData.size()) continue;
                            rColData.addData((Integer)this.getValue(i) + (Integer)colData.getValue(i));
                        }
                        break;
                    }
                    case FLOAT: {
                        rColData = new ColumnData(colName, DataType.FLOAT);
                        for (int i = 0; i < this.data.size(); ++i) {
                            if (i >= colData.size()) continue;
                            rColData.addData(Float.valueOf((float)((Integer)this.getValue(i)).intValue() + ((Float)colData.getValue(i)).floatValue()));
                        }
                        break;
                    }
                    case DOUBLE: {
                        rColData = new ColumnData(colName, DataType.DOUBLE);
                        for (int i = 0; i < this.data.size(); ++i) {
                            if (i >= colData.size()) continue;
                            rColData.addData((double)((Integer)this.getValue(i)).intValue() + (Double)colData.getValue(i));
                        }
                        break;
                    }
                }
                break;
            }
            case FLOAT: {
                switch (inType) {
                    case INT: {
                        rColData = new ColumnData(colName, DataType.FLOAT);
                        for (int i = 0; i < this.data.size(); ++i) {
                            if (i >= colData.size()) continue;
                            rColData.addData(Float.valueOf(((Float)this.getValue(i)).floatValue() + (float)((Integer)colData.getValue(i)).intValue()));
                        }
                        break;
                    }
                    case FLOAT: {
                        rColData = new ColumnData(colName, DataType.FLOAT);
                        for (int i = 0; i < this.data.size(); ++i) {
                            if (i >= colData.size()) continue;
                            rColData.addData(Float.valueOf(((Float)this.getValue(i)).floatValue() + ((Float)colData.getValue(i)).floatValue()));
                        }
                        break;
                    }
                    case DOUBLE: {
                        rColData = new ColumnData(colName, DataType.DOUBLE);
                        for (int i = 0; i < this.data.size(); ++i) {
                            if (i >= colData.size()) continue;
                            rColData.addData((double)((Float)this.getValue(i)).floatValue() + (Double)colData.getValue(i));
                        }
                        break;
                    }
                }
                break;
            }
            case DOUBLE: {
                switch (inType) {
                    case INT: {
                        rColData = new ColumnData(colName, DataType.DOUBLE);
                        for (int i = 0; i < this.data.size(); ++i) {
                            if (i >= colData.size()) continue;
                            rColData.addData((Double)this.getValue(i) + (double)((Integer)colData.getValue(i)).intValue());
                        }
                        break;
                    }
                    case FLOAT: {
                        rColData = new ColumnData(colName, DataType.DOUBLE);
                        for (int i = 0; i < this.data.size(); ++i) {
                            if (i >= colData.size()) continue;
                            rColData.addData((Double)this.getValue(i) + (double)((Float)colData.getValue(i)).floatValue());
                        }
                        break;
                    }
                    case DOUBLE: {
                        rColData = new ColumnData(colName, DataType.DOUBLE);
                        for (int i = 0; i < this.data.size(); ++i) {
                            if (i >= colData.size()) continue;
                            rColData.addData((Double)this.getValue(i) + (Double)colData.getValue(i));
                        }
                        break;
                    }
                }
                break;
            }
            case STRING: {
                rColData = new ColumnData(colName, DataType.STRING);
                for (int i = 0; i < this.data.size(); ++i) {
                    if (i >= colData.size()) continue;
                    rColData.addData((String)this.getValue(i) + (String)colData.getValue(i));
                }
                break;
            }
        }
        return rColData;
    }

    public ColumnData sub(Object value, String colName) {
        ColumnData rColData;
        block31: {
            DataType thisType = this.dataColumn.getDataType();
            if (!thisType.isNumeric()) {
                return null;
            }
            DataType inType = this.getDataType(value);
            if (!inType.isNumeric()) {
                return null;
            }
            rColData = null;
            switch (thisType) {
                case INT: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.INT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData(Float.valueOf((float)((Integer)this.getValue(i)).intValue() - (float)((Integer)value).intValue()));
                            }
                            break;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData(Float.valueOf((float)((Integer)this.getValue(i)).intValue() - ((Float)value).floatValue()));
                            }
                            break;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData((double)((Integer)this.getValue(i)).intValue() - (Double)value);
                            }
                            break;
                        }
                    }
                    break;
                }
                case FLOAT: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData(Float.valueOf(((Float)this.getValue(i)).floatValue() - (float)((Integer)value).intValue()));
                            }
                            break;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData(Float.valueOf(((Float)this.getValue(i)).floatValue() - ((Float)value).floatValue()));
                            }
                            break;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData((double)((Float)this.getValue(i)).floatValue() - (Double)value);
                            }
                            break;
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData((Double)this.getValue(i) - (double)((Integer)value).intValue());
                            }
                            break block31;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData((Double)this.getValue(i) - (double)((Float)value).floatValue());
                            }
                            break block31;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData((Double)this.getValue(i) - (Double)value);
                            }
                        }
                    }
                }
            }
        }
        return rColData;
    }

    public ColumnData sub(ColumnData colData, String colName) {
        ColumnData rColData;
        block31: {
            DataType thisType = this.dataColumn.getDataType();
            if (!thisType.isNumeric()) {
                return null;
            }
            DataType inType = colData.getDataType();
            if (!inType.isNumeric()) {
                return null;
            }
            rColData = null;
            switch (thisType) {
                case INT: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.INT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData((Integer)this.getValue(i) - (Integer)colData.getValue(i));
                            }
                            break;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData(Float.valueOf((float)((Integer)this.getValue(i)).intValue() - ((Float)colData.getValue(i)).floatValue()));
                            }
                            break;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData((double)((Integer)this.getValue(i)).intValue() - (Double)colData.getValue(i));
                            }
                            break;
                        }
                    }
                    break;
                }
                case FLOAT: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData(Float.valueOf(((Float)this.getValue(i)).floatValue() - (float)((Integer)colData.getValue(i)).intValue()));
                            }
                            break;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData(Float.valueOf(((Float)this.getValue(i)).floatValue() - ((Float)colData.getValue(i)).floatValue()));
                            }
                            break;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData((double)((Float)this.getValue(i)).floatValue() - (Double)colData.getValue(i));
                            }
                            break;
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData((Double)this.getValue(i) - (double)((Integer)colData.getValue(i)).intValue());
                            }
                            break block31;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData((Double)this.getValue(i) - (double)((Float)colData.getValue(i)).floatValue());
                            }
                            break block31;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData((Double)this.getValue(i) - (Double)colData.getValue(i));
                            }
                        }
                    }
                }
            }
        }
        return rColData;
    }

    public ColumnData mul(Object value, String colName) {
        ColumnData rColData;
        block31: {
            DataType thisType = this.dataColumn.getDataType();
            if (!thisType.isNumeric()) {
                return null;
            }
            DataType inType = this.getDataType(value);
            if (!inType.isNumeric()) {
                return null;
            }
            rColData = null;
            switch (thisType) {
                case INT: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.INT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData(Float.valueOf((float)((Integer)this.getValue(i)).intValue() * (float)((Integer)value).intValue()));
                            }
                            break;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData(Float.valueOf((float)((Integer)this.getValue(i)).intValue() * ((Float)value).floatValue()));
                            }
                            break;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData((double)((Integer)this.getValue(i)).intValue() * (Double)value);
                            }
                            break;
                        }
                    }
                    break;
                }
                case FLOAT: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData(Float.valueOf(((Float)this.getValue(i)).floatValue() * (float)((Integer)value).intValue()));
                            }
                            break;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData(Float.valueOf(((Float)this.getValue(i)).floatValue() * ((Float)value).floatValue()));
                            }
                            break;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData((double)((Float)this.getValue(i)).floatValue() * (Double)value);
                            }
                            break;
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData((Double)this.getValue(i) * (double)((Integer)value).intValue());
                            }
                            break block31;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData((Double)this.getValue(i) * (double)((Float)value).floatValue());
                            }
                            break block31;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData((Double)this.getValue(i) * (Double)value);
                            }
                        }
                    }
                }
            }
        }
        return rColData;
    }

    public ColumnData mul(ColumnData colData, String colName) {
        ColumnData rColData;
        block31: {
            DataType thisType = this.dataColumn.getDataType();
            if (!thisType.isNumeric()) {
                return null;
            }
            DataType inType = colData.getDataType();
            if (!inType.isNumeric()) {
                return null;
            }
            rColData = null;
            switch (thisType) {
                case INT: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.INT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData((Integer)this.getValue(i) * (Integer)colData.getValue(i));
                            }
                            break;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData(Float.valueOf((float)((Integer)this.getValue(i)).intValue() * ((Float)colData.getValue(i)).floatValue()));
                            }
                            break;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData((double)((Integer)this.getValue(i)).intValue() * (Double)colData.getValue(i));
                            }
                            break;
                        }
                    }
                    break;
                }
                case FLOAT: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData(Float.valueOf(((Float)this.getValue(i)).floatValue() * (float)((Integer)colData.getValue(i)).intValue()));
                            }
                            break;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData(Float.valueOf(((Float)this.getValue(i)).floatValue() * ((Float)colData.getValue(i)).floatValue()));
                            }
                            break;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData((double)((Float)this.getValue(i)).floatValue() * (Double)colData.getValue(i));
                            }
                            break;
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData((Double)this.getValue(i) * (double)((Integer)colData.getValue(i)).intValue());
                            }
                            break block31;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData((Double)this.getValue(i) * (double)((Float)colData.getValue(i)).floatValue());
                            }
                            break block31;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData((Double)this.getValue(i) * (Double)colData.getValue(i));
                            }
                        }
                    }
                }
            }
        }
        return rColData;
    }

    public ColumnData div(ColumnData colData, String colName) {
        ColumnData rColData;
        block31: {
            DataType thisType = this.dataColumn.getDataType();
            if (!thisType.isNumeric()) {
                return null;
            }
            DataType inType = colData.getDataType();
            if (!inType.isNumeric()) {
                return null;
            }
            rColData = null;
            switch (thisType) {
                case INT: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData(Float.valueOf((float)((Integer)this.getValue(i)).intValue() / (float)((Integer)colData.getValue(i)).intValue()));
                            }
                            break;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData(Float.valueOf((float)((Integer)this.getValue(i)).intValue() / ((Float)colData.getValue(i)).floatValue()));
                            }
                            break;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData((double)((Integer)this.getValue(i)).intValue() / (Double)colData.getValue(i));
                            }
                            break;
                        }
                    }
                    break;
                }
                case FLOAT: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData(Float.valueOf(((Float)this.getValue(i)).floatValue() / (float)((Integer)colData.getValue(i)).intValue()));
                            }
                            break;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData(Float.valueOf(((Float)this.getValue(i)).floatValue() / ((Float)colData.getValue(i)).floatValue()));
                            }
                            break;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData((double)((Float)this.getValue(i)).floatValue() / (Double)colData.getValue(i));
                            }
                            break;
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData((Double)this.getValue(i) / (double)((Integer)colData.getValue(i)).intValue());
                            }
                            break block31;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData((Double)this.getValue(i) / (double)((Float)colData.getValue(i)).floatValue());
                            }
                            break block31;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                if (i >= colData.size()) continue;
                                rColData.addData((Double)this.getValue(i) / (Double)colData.getValue(i));
                            }
                        }
                    }
                }
            }
        }
        return rColData;
    }

    public ColumnData div(Object value, String colName) {
        ColumnData rColData;
        block31: {
            DataType thisType = this.dataColumn.getDataType();
            if (!thisType.isNumeric()) {
                return null;
            }
            DataType inType = this.getDataType(value);
            if (!inType.isNumeric()) {
                return null;
            }
            rColData = null;
            switch (thisType) {
                case INT: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData(Float.valueOf((float)((Integer)this.getValue(i)).intValue() / (float)((Integer)value).intValue()));
                            }
                            break;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData(Float.valueOf((float)((Integer)this.getValue(i)).intValue() / ((Float)value).floatValue()));
                            }
                            break;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData((double)((Integer)this.getValue(i)).intValue() / (Double)value);
                            }
                            break;
                        }
                    }
                    break;
                }
                case FLOAT: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData(Float.valueOf(((Float)this.getValue(i)).floatValue() / (float)((Integer)value).intValue()));
                            }
                            break;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.FLOAT);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData(Float.valueOf(((Float)this.getValue(i)).floatValue() / ((Float)value).floatValue()));
                            }
                            break;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData((double)((Float)this.getValue(i)).floatValue() / (Double)value);
                            }
                            break;
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    switch (inType) {
                        case INT: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData((Double)this.getValue(i) / (double)((Integer)value).intValue());
                            }
                            break block31;
                        }
                        case FLOAT: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData((Double)this.getValue(i) / (double)((Float)value).floatValue());
                            }
                            break block31;
                        }
                        case DOUBLE: {
                            rColData = new ColumnData(colName, DataType.DOUBLE);
                            for (int i = 0; i < this.data.size(); ++i) {
                                rColData.addData((Double)this.getValue(i) / (Double)value);
                            }
                        }
                    }
                }
            }
        }
        return rColData;
    }

    private DataType getDataType(Object value) {
        if (value instanceof Integer) {
            return DataType.INT;
        }
        if (value instanceof Float) {
            return DataType.FLOAT;
        }
        if (value instanceof Double) {
            return DataType.DOUBLE;
        }
        if (value instanceof Boolean) {
            return DataType.BOOLEAN;
        }
        if (value instanceof String) {
            return DataType.STRING;
        }
        if (value instanceof Date) {
            return DataType.DATE;
        }
        return null;
    }
}

