/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import org.meteoinfo.ui.SplitButtonActionListener;

public class JSplitButton
extends JButton
implements MouseMotionListener,
MouseListener,
ActionListener,
Serializable {
    private int separatorSpacing = 4;
    private int splitWidth = 22;
    private int arrowSize = 8;
    private boolean onSplit;
    private Rectangle splitRectangle;
    private JPopupMenu popupMenu;
    private boolean alwaysDropDown;
    private Color arrowColor = Color.BLACK;
    private Color disabledArrowColor = Color.GRAY;
    private Image image;
    protected SplitButtonActionListener splitButtonActionListener = null;

    public JSplitButton(String text, Icon icon) {
        super(text, icon);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addActionListener(this);
    }

    public JSplitButton(String text) {
        this(text, null);
    }

    public JSplitButton(Icon icon) {
        this(null, icon);
    }

    public JSplitButton() {
        this(null, null);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
        this.image = null;
    }

    public int getSeparatorSpacing() {
        return this.separatorSpacing;
    }

    public void setSeparatorSpacing(int separatorSpacing) {
        this.separatorSpacing = separatorSpacing;
    }

    public boolean isAlwaysDropDown() {
        return this.alwaysDropDown;
    }

    public void setAlwaysDropDown(boolean alwaysDropDown) {
        this.alwaysDropDown = alwaysDropDown;
    }

    public Color getArrowColor() {
        return this.arrowColor;
    }

    public void setArrowColor(Color arrowColor) {
        this.arrowColor = arrowColor;
        this.image = null;
    }

    public Color getDisabledArrowColor() {
        return this.disabledArrowColor;
    }

    public void setDisabledArrowColor(Color disabledArrowColor) {
        this.disabledArrowColor = disabledArrowColor;
        this.image = null;
    }

    public int getSplitWidth() {
        return this.splitWidth;
    }

    public void setSplitWidth(int splitWidth) {
        this.splitWidth = splitWidth;
    }

    public int getArrowSize() {
        return this.arrowSize;
    }

    public void setArrowSize(int arrowSize) {
        this.arrowSize = arrowSize;
        this.image = null;
    }

    public Image getImage() {
        if (this.image != null) {
            return this.image;
        }
        Graphics2D g = null;
        BufferedImage img = new BufferedImage(this.arrowSize, this.arrowSize, 1);
        g = img.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        g.setColor(this.popupMenu != null ? this.arrowColor : this.disabledArrowColor);
        g.fillPolygon(new int[]{0, 0, this.arrowSize / 2}, new int[]{0, this.arrowSize, this.arrowSize / 2}, 3);
        g.dispose();
        img = this.rotate(img, 90);
        BufferedImage dimg = new BufferedImage(img.getWidth(), img.getHeight(), 2);
        g = dimg.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.drawImage(img, null, 0, 0);
        g.dispose();
        for (int i = 0; i < dimg.getHeight(); ++i) {
            for (int j = 0; j < dimg.getWidth(); ++j) {
                if (dimg.getRGB(j, i) != Color.WHITE.getRGB()) continue;
                dimg.setRGB(j, i, 9378844);
            }
        }
        this.image = Toolkit.getDefaultToolkit().createImage(dimg.getSource());
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics gClone = g.create();
        Color oldColor = gClone.getColor();
        this.splitRectangle = new Rectangle(this.getWidth() - this.splitWidth, 0, this.splitWidth, this.getHeight());
        gClone.translate(this.splitRectangle.x, this.splitRectangle.y);
        int mh = this.getHeight() / 2;
        int mw = this.splitWidth / 2;
        gClone.drawImage(this.getImage(), mw - this.arrowSize / 2, mh + 2 - this.arrowSize / 2, null);
        if (this.onSplit && !this.alwaysDropDown && this.popupMenu != null) {
            gClone.setColor(UIManager.getLookAndFeelDefaults().getColor("Button.background"));
            gClone.drawLine(1, this.separatorSpacing + 2, 1, this.getHeight() - this.separatorSpacing - 2);
            gClone.setColor(UIManager.getLookAndFeelDefaults().getColor("Button.shadow"));
            gClone.drawLine(2, this.separatorSpacing + 2, 2, this.getHeight() - this.separatorSpacing - 2);
        }
        gClone.setColor(oldColor);
    }

    private BufferedImage rotate(BufferedImage img, int angle) {
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage dimg = new BufferedImage(w, h, img.getType());
        Graphics2D g = dimg.createGraphics();
        g.rotate(Math.toRadians(angle), w / 2, h / 2);
        g.drawImage(img, null, 0, 0);
        return dimg;
    }

    public void addSplitButtonActionListener(SplitButtonActionListener l) {
        this.listenerList.add(SplitButtonActionListener.class, l);
    }

    public void removeSplitButtonActionListener(SplitButtonActionListener l) {
        if (l != null && this.getAction() == l) {
            this.setAction(null);
        } else {
            this.listenerList.remove(SplitButtonActionListener.class, l);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.onSplit = this.splitRectangle.contains(e.getPoint());
        this.repaint(this.splitRectangle);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.popupMenu == null) {
            this.fireButtonClicked(e);
        } else if (this.alwaysDropDown) {
            this.popupMenu.show(this, 0, this.getHeight());
            this.fireButtonClicked(e);
        } else if (this.onSplit) {
            this.popupMenu.show(this, 0, this.getHeight());
            this.fireSplitbuttonClicked(e);
        } else {
            this.fireButtonClicked(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.onSplit = false;
        this.repaint(this.splitRectangle);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    private void fireButtonClicked(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SplitButtonActionListener.class) continue;
            if (e == null) {
                String actionCommand = event.getActionCommand();
                if (actionCommand == null) {
                    actionCommand = this.getActionCommand();
                }
                e = new ActionEvent(this, 1001, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((SplitButtonActionListener)listeners[i + 1]).buttonClicked(e);
        }
    }

    private void fireSplitbuttonClicked(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SplitButtonActionListener.class) continue;
            if (e == null) {
                String actionCommand = event.getActionCommand();
                if (actionCommand == null) {
                    actionCommand = this.getActionCommand();
                }
                e = new ActionEvent(this, 1001, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((SplitButtonActionListener)listeners[i + 1]).splitButtonClicked(e);
        }
    }
}

