/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart;

import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableModel;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.meteoinfo.chart.Chart;
import org.meteoinfo.chart.IChartPanel;
import org.meteoinfo.chart.IPointSelectedListener;
import org.meteoinfo.chart.MouseMode;
import org.meteoinfo.chart.PointSelectedEvent;
import org.meteoinfo.chart.plot.AbstractPlot2D;
import org.meteoinfo.chart.plot.MapPlot;
import org.meteoinfo.chart.plot.Plot;
import org.meteoinfo.chart.plot.Plot3D;
import org.meteoinfo.chart.plot.PlotType;
import org.meteoinfo.chart.plot.XY1DPlot;
import org.meteoinfo.chart.plot3d.Projector;
import org.meteoinfo.data.mapdata.Field;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.GenericFileFilter;
import org.meteoinfo.global.PointF;
import org.meteoinfo.image.ImageUtil;
import org.meteoinfo.layer.LayerTypes;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.layer.RasterLayer;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.map.FrmIdentifer;
import org.meteoinfo.map.FrmIdentiferGrid;
import org.meteoinfo.map.MapView;
import org.meteoinfo.ndarray.DataType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChartPanel
extends JPanel
implements IChartPanel {
    private final EventListenerList listeners = new EventListenerList();
    private BufferedImage mapBitmap = new BufferedImage(10, 10, 2);
    private BufferedImage tempImage = null;
    private boolean newPaint = false;
    private boolean doubleBuffer = true;
    private Chart chart;
    private Plot currentPlot;
    private Dimension chartSize;
    private Point mouseDownPoint = new Point(0, 0);
    private Point mouseLastPos = new Point(0, 0);
    private boolean dragMode = false;
    private JPopupMenu popupMenu;
    private MouseMode mouseMode;
    private List<int[]> selectedPoints;
    private int xShift = 0;
    private int yShift = 0;
    private double paintScale = 1.0;
    private LocalDateTime lastMouseWheelTime;
    private Timer mouseWheelDetctionTimer;

    public ChartPanel() {
        this.setBackground(Color.lightGray);
        this.setSize(200, 200);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ChartPanel.this.onComponentResized(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ChartPanel.this.onMouseClicked(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ChartPanel.this.onMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ChartPanel.this.onMouseReleased(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                ChartPanel.this.onMouseMoved(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                ChartPanel.this.onMouseDragged(e);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                ChartPanel.this.onMouseWheelMoved(e);
            }
        });
        this.mouseWheelDetctionTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocalDateTime now = LocalDateTime.now();
                if (Duration.between(ChartPanel.this.lastMouseWheelTime, now).toMillis() > 200L) {
                    ChartPanel.this.xShift = 0;
                    ChartPanel.this.yShift = 0;
                    ChartPanel.this.paintScale = 1.0;
                    ChartPanel.this.repaintNew();
                    ChartPanel.this.mouseWheelDetctionTimer.stop();
                }
            }
        });
        this.popupMenu = new JPopupMenu();
        JMenuItem undoZoom = new JMenuItem("Undo zoom");
        undoZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartPanel.this.onUndoZoomClick();
            }
        });
        this.popupMenu.add(undoZoom);
        this.popupMenu.addSeparator();
        JMenuItem saveFigure = new JMenuItem("Save figure");
        saveFigure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartPanel.this.onSaveFigureClick(e);
            }
        });
        this.popupMenu.add(saveFigure);
        this.chart = null;
        this.mouseMode = MouseMode.DEFAULT;
    }

    public ChartPanel(Chart chart) {
        this();
        this.chart = chart;
        if (this.chart != null) {
            this.chart.setParent(this);
        }
    }

    public ChartPanel(Chart chart, int width, int height) {
        this(chart);
        this.chartSize = new Dimension(width, height);
        this.setPreferredSize(this.chartSize);
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart value) {
        this.chart = value;
        if (this.chart != null) {
            this.chart.setParent(this);
        }
    }

    public boolean isDoubleBuffer() {
        return this.doubleBuffer;
    }

    public void setDoubleBuffer(boolean value) {
        this.doubleBuffer = value;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public MouseMode getMouseMode() {
        return this.mouseMode;
    }

    @Override
    public void setMouseMode(MouseMode value) {
        this.mouseMode = value;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Cursor customCursor = Cursor.getPredefinedCursor(0);
        switch (this.mouseMode) {
            case SELECT: {
                customCursor = Cursor.getPredefinedCursor(1);
                break;
            }
            case ZOOM_IN: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/zoom_in_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Zoom In");
                break;
            }
            case ZOOM_OUT: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/zoom_out_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Zoom In");
                break;
            }
            case PAN: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/Pan_Open_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Pan");
                break;
            }
            case IDENTIFER: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/identifer_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Identifer");
                break;
            }
            case ROTATE: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/rotate.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Identifer");
            }
        }
        this.setCursor(customCursor);
    }

    public List<int[]> getSelectedPoints() {
        return this.selectedPoints;
    }

    public void addPointSelectedListener(IPointSelectedListener listener) {
        this.listeners.add(IPointSelectedListener.class, listener);
    }

    public void removePointSelectedListener(IPointSelectedListener listener) {
        this.listeners.remove(IPointSelectedListener.class, listener);
    }

    public void firePointSelectedEvent() {
        this.firePointSelectedEvent(new PointSelectedEvent(this));
    }

    private void firePointSelectedEvent(PointSelectedEvent event) {
        Object[] listeners = this.listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IPointSelectedListener.class) continue;
            ((IPointSelectedListener)listeners[i + 1]).pointSelectedEvent(event);
        }
    }

    public int getFigureWidth() {
        int width = this.chartSize != null ? this.chartSize.width : this.getWidth();
        return width;
    }

    public int getFigureHeight() {
        int height = this.chartSize != null ? this.chartSize.height : this.getHeight();
        return height;
    }

    public Plot selPlot(int x, int y) {
        if (this.chart == null) {
            return null;
        }
        int n = this.chart.getPlots().size();
        for (int i = n - 1; i >= 0; --i) {
            Plot plot = this.chart.getPlots().get(i);
            Rectangle2D rect = plot.getGraphArea();
            if (!rect.contains(x, y)) continue;
            return plot;
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        MapPlot plot;
        super.paintComponent(g);
        if (this.getWidth() < 5 || this.getHeight() < 5) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.newPaint) {
            this.paintGraphics(g2);
        } else {
            AffineTransform mx = new AffineTransform();
            AffineTransformOp aop = new AffineTransformOp(mx, 3);
            g2.drawImage(this.mapBitmap, aop, 0, 0);
        }
        if (this.dragMode) {
            switch (this.mouseMode) {
                case SELECT: 
                case ZOOM_IN: {
                    int aWidth = Math.abs(this.mouseLastPos.x - this.mouseDownPoint.x);
                    int aHeight = Math.abs(this.mouseLastPos.y - this.mouseDownPoint.y);
                    int aX = Math.min(this.mouseLastPos.x, this.mouseDownPoint.x);
                    int aY = Math.min(this.mouseLastPos.y, this.mouseDownPoint.y);
                    g2.setColor(this.getForeground());
                    float[] dash1 = new float[]{2.0f};
                    g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f));
                    g2.draw(new java.awt.Rectangle(aX, aY, aWidth, aHeight));
                }
            }
        }
        if (this.currentPlot != null && this.currentPlot instanceof MapPlot && (plot = (MapPlot)this.currentPlot).getMapView().isDrawIdentiferShape() && plot.getSelectedLayer() != null && plot.getSelectedLayer().getLayerType() == LayerTypes.VectorLayer) {
            VectorLayer layer = (VectorLayer)plot.getSelectedLayer();
            Rectangle2D rect = plot.getGraphArea();
            java.awt.Rectangle rr = new java.awt.Rectangle((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            plot.getMapView().drawIdShape(g2, layer.getShapes().get(layer.getIdentiferShape()), rr);
        }
        g2.dispose();
    }

    public void repaintNew() {
        if (this.doubleBuffer) {
            this.paintGraphics();
        } else {
            this.newPaint = true;
            this.repaint();
            this.updateViewImage();
        }
    }

    private void repaintOld() {
        if (this.doubleBuffer) {
            this.repaint();
        } else {
            this.newPaint = false;
            this.repaint();
        }
    }

    private void updateViewImage() {
        int width;
        int height;
        if (this.getWidth() < 5 || this.getHeight() < 5) {
            return;
        }
        if (this.chartSize != null) {
            height = this.chartSize.height;
            width = this.chartSize.width;
        } else {
            width = this.getWidth();
            height = this.getHeight();
        }
        this.mapBitmap = new BufferedImage(width, height, 2);
        Graphics2D g = this.mapBitmap.createGraphics();
        this.print(g);
        g.dispose();
    }

    @Override
    public void paintGraphics() {
        int width;
        int height;
        if (this.getWidth() < 5 || this.getHeight() < 5) {
            return;
        }
        if (this.chartSize != null) {
            height = this.chartSize.height;
            width = this.chartSize.width;
        } else {
            width = this.getWidth();
            height = this.getHeight();
        }
        this.mapBitmap = new BufferedImage(width, height, 2);
        if (this.chart != null) {
            Graphics2D g = this.mapBitmap.createGraphics();
            Rectangle2D.Double chartArea = this.chartSize == null ? new Rectangle2D.Double(0.0, 0.0, this.mapBitmap.getWidth(), this.mapBitmap.getHeight()) : new Rectangle2D.Double(0.0, 0.0, this.chartSize.width, this.chartSize.height);
            this.chart.draw(g, chartArea);
        }
        this.repaint();
    }

    public void paintGraphics(Graphics2D g) {
        if (this.chart != null) {
            Rectangle2D.Double chartArea = this.chartSize == null ? new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()) : new Rectangle2D.Double(0.0, 0.0, this.chartSize.width, this.chartSize.height);
            this.chart.draw(g, chartArea);
        }
    }

    public void paintGraphics(Graphics2D g, int width, int height) {
        if (this.chart != null) {
            Rectangle2D.Double chartArea = new Rectangle2D.Double(0.0, 0.0, width, height);
            this.chart.draw(g, chartArea);
        }
    }

    void onComponentResized(ComponentEvent e) {
        if (this.getWidth() > 0 && this.getHeight() > 0 && this.chart != null) {
            this.repaintNew();
        }
    }

    void onMousePressed(MouseEvent e) {
        this.mouseDownPoint.x = e.getX();
        this.mouseDownPoint.y = e.getY();
        this.mouseLastPos = (Point)this.mouseDownPoint.clone();
        switch (this.mouseMode) {
            case PAN: {
                Plot plot = this.selPlot(e.getX(), e.getY());
                if (plot == null) break;
                Rectangle2D mapRect = plot.getGraphArea();
                this.tempImage = new BufferedImage((int)mapRect.getWidth() - 2, (int)mapRect.getHeight() - 2, 2);
                Graphics2D tg = this.tempImage.createGraphics();
                tg.setColor(Color.white);
                tg.fill(mapRect);
                tg.drawImage((Image)this.mapBitmap, -((int)mapRect.getX()) - 1, -((int)mapRect.getY()) - 1, this);
                tg.dispose();
            }
        }
    }

    void onMouseMoved(MouseEvent e) {
        this.dragMode = false;
    }

    void onMouseReleased(MouseEvent e) {
        this.dragMode = false;
        Plot plt = this.chart.findPlot(this.mouseDownPoint.x, this.mouseDownPoint.y);
        if (!(plt instanceof AbstractPlot2D)) {
            return;
        }
        AbstractPlot2D xyplot = (AbstractPlot2D)plt;
        this.currentPlot = xyplot;
        switch (this.mouseMode) {
            case ZOOM_IN: {
                Extent drawExtent;
                if (Math.abs(this.mouseLastPos.x - this.mouseDownPoint.x) <= 5) break;
                if (xyplot instanceof MapPlot) {
                    MapPlot plot = (MapPlot)xyplot;
                    Rectangle2D graphArea = xyplot.getGraphArea();
                    double[] xy1 = plot.screenToProj((double)this.mouseDownPoint.x - graphArea.getX(), (double)this.mouseDownPoint.y - graphArea.getY(), graphArea);
                    double[] xy2 = plot.screenToProj((double)this.mouseLastPos.x - graphArea.getX(), (double)this.mouseLastPos.y - graphArea.getY(), graphArea);
                    Extent extent = new Extent();
                    extent.minX = Math.min(xy1[0], xy2[0]);
                    extent.maxX = Math.max(xy1[0], xy2[0]);
                    extent.minY = Math.min(xy1[1], xy2[1]);
                    extent.maxY = Math.max(xy1[1], xy2[1]);
                    plot.setDrawExtent(extent);
                    this.repaintNew();
                    break;
                }
                Rectangle2D graphArea = xyplot.getGraphArea();
                double[] xy1 = xyplot.screenToProj((double)this.mouseDownPoint.x - graphArea.getX(), (double)this.mouseDownPoint.y - graphArea.getY(), graphArea);
                double[] xy2 = xyplot.screenToProj((double)this.mouseLastPos.x - graphArea.getX(), (double)this.mouseLastPos.y - graphArea.getY(), graphArea);
                Extent extent = new Extent();
                extent.minX = Math.min(xy1[0], xy2[0]);
                extent.maxX = Math.max(xy1[0], xy2[0]);
                extent.minY = Math.min(xy1[1], xy2[1]);
                extent.maxY = Math.max(xy1[1], xy2[1]);
                if (xyplot.getXAxis().isInverse()) {
                    drawExtent = xyplot.getDrawExtent();
                    double minx = drawExtent.getWidth() - (extent.maxX - drawExtent.minX) + drawExtent.minX;
                    double maxx = drawExtent.getWidth() - (extent.minX - drawExtent.minX) + drawExtent.minX;
                    extent.minX = minx;
                    extent.maxX = maxx;
                }
                if (xyplot.getYAxis().isInverse()) {
                    drawExtent = xyplot.getDrawExtent();
                    double miny = drawExtent.getHeight() - (extent.maxY - drawExtent.minY) + drawExtent.minY;
                    double maxy = drawExtent.getHeight() - (extent.minY - drawExtent.minY) + drawExtent.minY;
                    extent.minY = miny;
                    extent.maxY = maxy;
                }
                xyplot.setDrawExtent(extent);
                this.repaintNew();
                break;
            }
            case ZOOM_OUT: {
                if (e.getButton() != 1) break;
                double zoom = 1.5;
                Extent extent = xyplot.getDrawExtent();
                double owidth = extent.getWidth();
                double oheight = extent.getHeight();
                double width = owidth * zoom;
                double height = oheight * zoom;
                double xshift = (owidth - width) * 0.5;
                double yshift = (oheight - height) * 0.5;
                extent.minX += xshift;
                extent.maxX -= xshift;
                extent.minY += yshift;
                extent.maxY -= yshift;
                xyplot.setDrawExtent(extent);
                this.repaintNew();
                break;
            }
            case SELECT: {
                XY1DPlot plot;
                Rectangle2D graphArea;
                if (Math.abs(this.mouseLastPos.x - this.mouseDownPoint.x) <= 5 || !(xyplot instanceof XY1DPlot) || !(graphArea = (plot = (XY1DPlot)xyplot).getGraphArea()).contains(this.mouseDownPoint.x, this.mouseDownPoint.y) && !graphArea.contains(this.mouseLastPos.x, this.mouseLastPos.y)) break;
                double[] xy1 = plot.screenToProj((double)this.mouseDownPoint.x - graphArea.getX(), (double)this.mouseDownPoint.y - graphArea.getY(), graphArea);
                double[] xy2 = plot.screenToProj((double)this.mouseLastPos.x - graphArea.getX(), (double)this.mouseLastPos.y - graphArea.getY(), graphArea);
                Extent extent = new Extent();
                extent.minX = Math.min(xy1[0], xy2[0]);
                extent.maxX = Math.max(xy1[0], xy2[0]);
                extent.minY = Math.min(xy1[1], xy2[1]);
                extent.maxY = Math.max(xy1[1], xy2[1]);
                this.selectedPoints = plot.getDataset().selectPoints(extent);
                this.firePointSelectedEvent();
                this.repaintNew();
                break;
            }
            case PAN: {
                if (e.getButton() != 1) break;
                int deltaX = e.getX() - this.mouseDownPoint.x;
                int deltaY = e.getY() - this.mouseDownPoint.y;
                double minX = -deltaX;
                double minY = -deltaY;
                double maxX = xyplot.getGraphArea().getWidth() - (double)deltaX;
                double maxY = xyplot.getGraphArea().getHeight() - (double)deltaY;
                xyplot.zoomToExtentScreen(minX, maxX, minY, maxY);
                this.repaintNew();
            }
        }
    }

    void onMouseDragged(MouseEvent e) {
        this.dragMode = true;
        int x = e.getX();
        int y = e.getY();
        switch (this.mouseMode) {
            case SELECT: 
            case ZOOM_IN: {
                this.repaintOld();
                break;
            }
            case PAN: {
                Plot plot = this.selPlot(e.getX(), e.getY());
                if (plot == null) break;
                Graphics2D g = (Graphics2D)this.getGraphics();
                Rectangle2D mapRect = plot.getGraphArea();
                g.setClip(mapRect);
                g.setColor(Color.white);
                int aX = e.getX() - this.mouseDownPoint.x;
                int aY = e.getY() - this.mouseDownPoint.y;
                if (aX > 0) {
                    if (mapRect.getX() >= 0.0) {
                        g.fillRect((int)mapRect.getX(), (int)mapRect.getY(), aX, (int)mapRect.getHeight());
                    } else {
                        g.fillRect(0, (int)mapRect.getY(), aX, (int)mapRect.getHeight());
                    }
                } else if (mapRect.getX() <= (double)this.getWidth()) {
                    g.fillRect((int)(mapRect.getX() + mapRect.getWidth() + (double)aX), (int)mapRect.getY(), Math.abs(aX), (int)mapRect.getHeight());
                } else {
                    g.fillRect(this.getWidth() + aX, (int)mapRect.getY(), Math.abs(aX), (int)mapRect.getHeight());
                }
                if (aY > 0) {
                    if (mapRect.getY() >= 0.0) {
                        g.fillRect((int)mapRect.getX(), (int)mapRect.getY(), (int)mapRect.getWidth(), aY);
                    } else {
                        g.fillRect((int)mapRect.getX(), 0, (int)mapRect.getWidth(), aY);
                    }
                } else if (mapRect.getY() + mapRect.getHeight() <= (double)(this.getX() + this.getHeight())) {
                    g.fillRect((int)mapRect.getX(), (int)mapRect.getY() + (int)mapRect.getHeight() + aY, (int)mapRect.getWidth(), Math.abs(aY));
                } else {
                    g.fillRect((int)mapRect.getX(), this.getY() + this.getHeight() + aY, (int)mapRect.getWidth(), Math.abs(aY));
                }
                int startX = (int)mapRect.getX() + aX;
                int startY = (int)mapRect.getY() + aY;
                g.drawImage((Image)this.tempImage, startX, startY, this);
                g.setColor(this.getForeground());
                g.draw(mapRect);
                break;
            }
            case ROTATE: {
                Plot plot = this.selPlot(this.mouseDownPoint.x, this.mouseDownPoint.y);
                if (plot == null || plot.getPlotType() != PlotType.XYZ) break;
                Plot3D plot3d = (Plot3D)plot;
                Projector projector = plot3d.getProjector();
                float new_value = 0.0f;
                if (e.isControlDown()) {
                    projector.set2D_xTranslation(projector.get2D_xTranslation() + (x - this.mouseLastPos.x));
                    projector.set2D_yTranslation(projector.get2D_yTranslation() + (y - this.mouseLastPos.y));
                } else if (e.isShiftDown()) {
                    new_value = projector.getY2DScaling() + (float)(y - this.mouseLastPos.y) * 0.5f;
                    if (new_value > 60.0f) {
                        new_value = 60.0f;
                    }
                    if (new_value < 2.0f) {
                        new_value = 2.0f;
                    }
                    projector.set2DScaling(new_value);
                } else {
                    for (new_value = projector.getRotationAngle() + (float)(x - this.mouseLastPos.x); new_value > 360.0f; new_value -= 360.0f) {
                    }
                    while (new_value < 0.0f) {
                        new_value += 360.0f;
                    }
                    projector.setRotationAngle(new_value);
                    new_value = projector.getElevationAngle() + (float)(y - this.mouseLastPos.y);
                    if (new_value > 90.0f) {
                        new_value = 90.0f;
                    } else if (new_value < 0.0f) {
                        new_value = 0.0f;
                    }
                    projector.setElevationAngle(new_value);
                }
                this.repaintNew();
            }
        }
        this.mouseLastPos.x = x;
        this.mouseLastPos.y = y;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void onMouseClicked(MouseEvent e) {
        int clickTimes = e.getClickCount();
        if (clickTimes != 1) return;
        if (e.getButton() == 1) {
            switch (this.mouseMode) {
                case IDENTIFER: {
                    RasterLayer aRLayer;
                    int[] ijIdx;
                    Plot plot = this.selPlot(e.getX(), e.getY());
                    if (plot == null) {
                        return;
                    }
                    if (!(plot instanceof MapPlot)) {
                        return;
                    }
                    this.currentPlot = plot;
                    MapPlot mplot = (MapPlot)plot;
                    final MapView mapView = mplot.getMapView();
                    MapLayer aMLayer = mplot.getSelectedLayer();
                    if (aMLayer == null) {
                        return;
                    }
                    if (aMLayer.getLayerType() == LayerTypes.ImageLayer) {
                        return;
                    }
                    Rectangle2D rect = mplot.getGraphArea();
                    PointF aPoint = new PointF((float)e.getX() - (float)rect.getX(), (float)e.getY() - (float)rect.getY());
                    if (aMLayer.getLayerType() == LayerTypes.VectorLayer) {
                        VectorLayer aLayer = (VectorLayer)aMLayer;
                        List<Integer> selectedShapes = mapView.selectShapes(aLayer, aPoint, true, false);
                        if (selectedShapes.size() <= 0) return;
                        if (mapView.frmIdentifer == null) {
                            mapView.frmIdentifer = new FrmIdentifer((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false, mapView);
                            mapView.frmIdentifer.addWindowListener(new WindowAdapter(){

                                @Override
                                public void windowClosed(WindowEvent e) {
                                    mapView.setDrawIdentiferShape(false);
                                    ChartPanel.this.repaintOld();
                                }
                            });
                        }
                        Object[] colNames = new String[]{"Field", "Value"};
                        int shapeIdx = selectedShapes.get(0);
                        aLayer.setIdentiferShape(shapeIdx);
                        mapView._drawIdentiferShape = true;
                        Object[][] tData = new Object[aLayer.getFieldNumber() + 1][2];
                        String fieldStr = "Index";
                        String valueStr = String.valueOf(shapeIdx);
                        tData[0][0] = fieldStr;
                        tData[0][1] = valueStr;
                        if (aLayer.getShapeNum() > 0) {
                            for (int i = 0; i < aLayer.getFieldNumber(); ++i) {
                                Field field = aLayer.getField(i);
                                fieldStr = field.getColumnName();
                                Object value = aLayer.getCellValue(i, shapeIdx);
                                if (value == null) {
                                    valueStr = "";
                                } else if (field.getDataType() == DataType.DATE) {
                                    DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                                    valueStr = format.format((LocalDateTime)value);
                                } else {
                                    valueStr = value.toString();
                                }
                                tData[i + 1][0] = fieldStr;
                                tData[i + 1][1] = valueStr;
                            }
                        }
                        DefaultTableModel dtm = new DefaultTableModel(tData, colNames){

                            @Override
                            public boolean isCellEditable(int row, int column) {
                                return false;
                            }
                        };
                        mapView.frmIdentifer.getTable().setModel(dtm);
                        mapView.frmIdentifer.repaint();
                        if (!mapView.frmIdentifer.isVisible()) {
                            mapView.frmIdentifer.setLocationRelativeTo(this);
                            mapView.frmIdentifer.setVisible(true);
                        }
                        mapView.setDrawIdentiferShape(true);
                        this.repaintOld();
                        return;
                    }
                    if (aMLayer.getLayerType() != LayerTypes.RasterLayer || (ijIdx = mapView.selectGridCell(aRLayer = (RasterLayer)aMLayer, aPoint)) == null) return;
                    int iIdx = ijIdx[0];
                    int jIdx = ijIdx[1];
                    double aValue = aRLayer.getCellValue(iIdx, jIdx);
                    if (mapView._frmIdentiferGrid == null) {
                        mapView._frmIdentiferGrid = new FrmIdentiferGrid((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false);
                    }
                    mapView._frmIdentiferGrid.setIIndex(iIdx);
                    mapView._frmIdentiferGrid.setJIndex(jIdx);
                    mapView._frmIdentiferGrid.setCellValue(aValue);
                    if (mapView._frmIdentiferGrid.isVisible()) return;
                    mapView._frmIdentiferGrid.setLocationRelativeTo(this);
                    mapView._frmIdentiferGrid.setVisible(true);
                }
            }
            return;
        } else {
            if (e.getButton() != 3) return;
            this.popupMenu.show(this, e.getX(), e.getY());
        }
    }

    void onMouseWheelMoved(MouseWheelEvent e) {
        Plot plt = this.selPlot(e.getX(), e.getY());
        if (!(plt instanceof AbstractPlot2D)) {
            return;
        }
        Extent drawExtent = ((AbstractPlot2D)plt).getDrawExtent();
        double lonRan = drawExtent.maxX - drawExtent.minX;
        double latRan = drawExtent.maxY - drawExtent.minY;
        double mouseLon = drawExtent.minX + lonRan / 2.0;
        double mouseLat = drawExtent.minY + latRan / 2.0;
        double zoomF = 1.0f + (float)e.getWheelRotation() / 10.0f;
        double minX = mouseLon - lonRan / 2.0 * zoomF;
        double maxX = mouseLon + lonRan / 2.0 * zoomF;
        double minY = mouseLat - latRan / 2.0 * zoomF;
        double maxY = mouseLat + latRan / 2.0 * zoomF;
        switch (this.mouseMode) {
            case PAN: {
                if (plt instanceof MapPlot) {
                    MapPlot mplt = (MapPlot)plt;
                    Graphics2D g = (Graphics2D)this.getGraphics();
                    Rectangle2D mapRect = mplt.getGraphArea();
                    this.lastMouseWheelTime = LocalDateTime.now();
                    if (!this.mouseWheelDetctionTimer.isRunning()) {
                        this.mouseWheelDetctionTimer.start();
                        this.tempImage = new BufferedImage((int)mapRect.getWidth() - 2, (int)mapRect.getHeight() - 2, 2);
                        Graphics2D tg = this.tempImage.createGraphics();
                        tg.setColor(Color.white);
                        tg.fill(mapRect);
                        tg.drawImage((Image)this.mapBitmap, -((int)mapRect.getX()) - 1, -((int)mapRect.getY()) - 1, this);
                        tg.dispose();
                    }
                    g.setClip(mapRect);
                    g.setColor(Color.white);
                    this.paintScale /= zoomF;
                    float nWidth = (float)mapRect.getWidth() * (float)this.paintScale;
                    float nHeight = (float)mapRect.getHeight() * (float)this.paintScale;
                    float nx = ((float)mapRect.getWidth() - nWidth) / 2.0f;
                    float ny = ((float)mapRect.getHeight() - nHeight) / 2.0f;
                    if (nx > 0.0f) {
                        g.fillRect((int)mapRect.getX(), (int)mapRect.getY(), (int)nx, (int)mapRect.getHeight());
                        g.fillRect((int)(mapRect.getMaxX() - (double)nx), (int)mapRect.getY(), (int)nx, (int)mapRect.getHeight());
                    }
                    if (ny > 0.0f) {
                        g.fillRect((int)mapRect.getX(), (int)mapRect.getY(), (int)mapRect.getWidth(), (int)ny);
                        g.fillRect((int)mapRect.getX(), (int)(mapRect.getMaxY() - (double)ny), (int)mapRect.getWidth(), (int)ny);
                    }
                    g.drawImage(this.tempImage, (int)(mapRect.getX() + (double)nx), (int)(mapRect.getY() + (double)ny), (int)nWidth, (int)nHeight, null);
                    g.setColor(this.getForeground());
                    g.draw(mapRect);
                    mplt.setDrawExtent(new Extent(minX, maxX, minY, maxY));
                    break;
                }
                ((AbstractPlot2D)plt).setDrawExtent(new Extent(minX, maxX, minY, maxY));
                this.repaintNew();
            }
        }
    }

    @Override
    public void onUndoZoomClick() {
        AbstractPlot2D xyplot = this.currentPlot == null ? (AbstractPlot2D)this.chart.getPlots().get(0) : (AbstractPlot2D)this.currentPlot;
        xyplot.setDrawExtent((Extent)xyplot.getExtent().clone());
        this.repaintNew();
    }

    private void onSaveFigureClick(ActionEvent e) {
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        String[] fileExts = new String[]{"png"};
        GenericFileFilter pngFileFilter = new GenericFileFilter(fileExts, "Png Image (*.png)");
        aDlg.addChoosableFileFilter(pngFileFilter);
        fileExts = new String[]{"gif"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "Gif Image (*.gif)");
        aDlg.addChoosableFileFilter(mapFileFilter);
        fileExts = new String[]{"jpg"};
        mapFileFilter = new GenericFileFilter(fileExts, "Jpeg Image (*.jpg)");
        aDlg.addChoosableFileFilter(mapFileFilter);
        fileExts = new String[]{"eps"};
        mapFileFilter = new GenericFileFilter(fileExts, "EPS file (*.eps)");
        aDlg.addChoosableFileFilter(mapFileFilter);
        fileExts = new String[]{"pdf"};
        mapFileFilter = new GenericFileFilter(fileExts, "PDF file (*.pdf)");
        aDlg.addChoosableFileFilter(mapFileFilter);
        fileExts = new String[]{"emf"};
        mapFileFilter = new GenericFileFilter(fileExts, "EMF file (*.emf)");
        aDlg.addChoosableFileFilter(mapFileFilter);
        aDlg.setFileFilter(pngFileFilter);
        aDlg.setAcceptAllFileFilterUsed(false);
        if (0 == aDlg.showSaveDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            System.setProperty("user.dir", aFile.getParent());
            String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
            String fileName = aFile.getAbsolutePath();
            if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                fileName = fileName + "." + extent;
            }
            if (new File(fileName).exists()) {
                int overwrite = JOptionPane.showConfirmDialog(this, "File exists! Overwrite it?");
                if (overwrite == 0) {
                    this.saveImage(fileName);
                }
            } else {
                this.saveImage(fileName);
            }
        }
    }

    @Override
    public void saveImage(String aFile) {
        try {
            this.saveImage(aFile, null);
        }
        catch (IOException | InterruptedException | PrintException ex) {
            Logger.getLogger(ChartPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void saveImage(String aFile, Integer sleep) throws FileNotFoundException, PrintException, IOException, InterruptedException {
        int h;
        int w;
        if (this.chartSize == null) {
            w = this.getWidth();
            h = this.getHeight();
        } else {
            w = this.chartSize.width;
            h = this.chartSize.height;
        }
        this.saveImage(aFile, w, h, sleep);
    }

    public void saveImage(String aFile, int width, int height, Integer sleep) throws FileNotFoundException, PrintException, IOException, InterruptedException {
        if (aFile.endsWith(".ps")) {
            DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            String mimeType = "application/postscript";
            StreamPrintServiceFactory[] factories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(flavor, mimeType);
            FileOutputStream out = new FileOutputStream(aFile);
            if (factories.length > 0) {
                StreamPrintService service = factories[0].getPrintService(out);
                SimpleDoc doc = new SimpleDoc(new Printable(){

                    @Override
                    public int print(Graphics g, PageFormat pf, int page) {
                        if (page >= 1) {
                            return 1;
                        }
                        double sf1 = pf.getImageableWidth() / (double)(ChartPanel.this.getWidth() + 1);
                        double sf2 = pf.getImageableHeight() / (double)(ChartPanel.this.getHeight() + 1);
                        double s = Math.min(sf1, sf2);
                        Graphics2D g2 = (Graphics2D)g;
                        g2.translate((pf.getWidth() - pf.getImageableWidth()) / 2.0, (pf.getHeight() - pf.getImageableHeight()) / 2.0);
                        g2.scale(s, s);
                        ChartPanel.this.paintGraphics(g2);
                        return 0;
                    }
                }, flavor, null);
                DocPrintJob job = service.createPrintJob();
                HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
                job.print(doc, attributes);
                out.close();
            }
        } else if (aFile.endsWith(".eps")) {
            Properties p = new Properties();
            p.setProperty("PageSize", "A5");
            PSGraphics2D g = new PSGraphics2D(new File(aFile), new Dimension(width, height));
            g.startExport();
            this.paintGraphics((Graphics2D)g, width, height);
            g.endExport();
            g.dispose();
        } else if (aFile.endsWith(".pdf")) {
            try {
                Document document = new Document(new Rectangle((float)width, (float)height));
                PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(aFile));
                document.open();
                PdfContentByte cb = writer.getDirectContent();
                PdfTemplate pdfTemp = cb.createTemplate((float)width, (float)height);
                PdfGraphics2D g2 = new PdfGraphics2D((PdfContentByte)pdfTemp, (float)width, (float)height, true);
                this.paintGraphics((Graphics2D)g2, width, height);
                g2.dispose();
                cb.addTemplate(pdfTemp, 0.0f, 0.0f);
                document.close();
            }
            catch (DocumentException | FileNotFoundException e) {
                e.printStackTrace();
            }
        } else if (aFile.endsWith(".emf")) {
            EMFGraphics2D g = new EMFGraphics2D(new File(aFile), new Dimension(width, height));
            g.startExport();
            this.paintGraphics((Graphics2D)g, width, height);
            g.endExport();
            g.dispose();
        } else {
            String extension = aFile.substring(aFile.lastIndexOf(46) + 1);
            BufferedImage aImage = extension.equalsIgnoreCase("bmp") ? new BufferedImage(width, height, 1) : new BufferedImage(width, height, 2);
            Graphics2D g = aImage.createGraphics();
            this.paintGraphics(g, width, height);
            if (sleep != null) {
                Thread.sleep(sleep * 1000);
            }
            if (extension.equalsIgnoreCase("jpg")) {
                BufferedImage newImage = new BufferedImage(aImage.getWidth(), aImage.getHeight(), 1);
                newImage.createGraphics().drawImage(aImage, 0, 0, Color.BLACK, null);
                ImageIO.write((RenderedImage)newImage, extension, new File(aFile));
            } else {
                ImageIO.write((RenderedImage)aImage, extension, new File(aFile));
            }
        }
    }

    public void saveImage_bak(String aFile, int width, int height, Integer sleep) throws FileNotFoundException, PrintException, IOException, InterruptedException {
        if (aFile.endsWith(".ps")) {
            DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            String mimeType = "application/postscript";
            StreamPrintServiceFactory[] factories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(flavor, mimeType);
            FileOutputStream out = new FileOutputStream(aFile);
            if (factories.length > 0) {
                StreamPrintService service = factories[0].getPrintService(out);
                SimpleDoc doc = new SimpleDoc(new Printable(){

                    @Override
                    public int print(Graphics g, PageFormat pf, int page) {
                        if (page >= 1) {
                            return 1;
                        }
                        double sf1 = pf.getImageableWidth() / (double)(ChartPanel.this.getWidth() + 1);
                        double sf2 = pf.getImageableHeight() / (double)(ChartPanel.this.getHeight() + 1);
                        double s = Math.min(sf1, sf2);
                        Graphics2D g2 = (Graphics2D)g;
                        g2.translate((pf.getWidth() - pf.getImageableWidth()) / 2.0, (pf.getHeight() - pf.getImageableHeight()) / 2.0);
                        g2.scale(s, s);
                        ChartPanel.this.paintGraphics(g2);
                        return 0;
                    }
                }, flavor, null);
                DocPrintJob job = service.createPrintJob();
                HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
                job.print(doc, attributes);
                out.close();
            }
        } else if (aFile.endsWith(".eps")) {
            Properties p = new Properties();
            p.setProperty("PageSize", "A5");
            PSGraphics2D g = new PSGraphics2D(new File(aFile), new Dimension(width, height));
            g.startExport();
            this.paintGraphics((Graphics2D)g, width, height);
            g.endExport();
            g.dispose();
        } else if (aFile.endsWith(".pdf")) {
            PDFGraphics2D g = new PDFGraphics2D(new File(aFile), new Dimension(width, height));
            g.startExport();
            this.paintGraphics((Graphics2D)g, width, height);
            g.endExport();
            g.dispose();
        } else if (aFile.endsWith(".emf")) {
            EMFGraphics2D g = new EMFGraphics2D(new File(aFile), new Dimension(width, height));
            g.startExport();
            this.paintGraphics((Graphics2D)g, width, height);
            g.endExport();
            g.dispose();
        } else {
            String extension = aFile.substring(aFile.lastIndexOf(46) + 1);
            BufferedImage aImage = extension.equalsIgnoreCase("bmp") ? new BufferedImage(width, height, 1) : new BufferedImage(width, height, 2);
            Graphics2D g = aImage.createGraphics();
            this.paintGraphics(g, width, height);
            if (sleep != null) {
                Thread.sleep(sleep * 1000);
            }
            if (extension.equalsIgnoreCase("jpg")) {
                BufferedImage newImage = new BufferedImage(aImage.getWidth(), aImage.getHeight(), 1);
                newImage.createGraphics().drawImage(aImage, 0, 0, Color.BLACK, null);
                ImageIO.write((RenderedImage)newImage, extension, new File(aFile));
            } else {
                ImageIO.write((RenderedImage)aImage, extension, new File(aFile));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveImage_Jpeg_old(String fileName, int dpi) throws IOException {
        BufferedImage image = this.mapBitmap;
        Iterator<ImageWriter> i = ImageIO.getImageWritersByFormatName("jpeg");
        if (i.hasNext()) {
            ImageWriter imageWriter = i.next();
            ImageWriteParam param = imageWriter.getDefaultWriteParam();
            ImageTypeSpecifier its = new ImageTypeSpecifier(image.getColorModel(), image.getSampleModel());
            IIOMetadata iomd = imageWriter.getDefaultImageMetadata(its, param);
            String formatName = "javax_imageio_jpeg_image_1.0";
            Node node = iomd.getAsTree(formatName);
            NodeList nl = node.getChildNodes();
            for (int j = 0; j < nl.getLength(); ++j) {
                Node n = nl.item(j);
                System.out.println("node from IOMetadata is : " + n.getNodeName());
                if (!n.getNodeName().equals("JPEGvariety")) continue;
                NodeList childNodes = n.getChildNodes();
                for (int k = 0; k < childNodes.getLength(); ++k) {
                    System.out.println("node #" + k + " is " + childNodes.item(k).getNodeName());
                    if (!childNodes.item(k).getNodeName().equals("app0JFIF")) continue;
                    NamedNodeMap nnm = childNodes.item(k).getAttributes();
                    Node resUnitsNode = this.getAttributeByName(childNodes.item(k), "resUnits");
                    Node XdensityNode = this.getAttributeByName(childNodes.item(k), "Xdensity");
                    Node YdensityNode = this.getAttributeByName(childNodes.item(k), "Ydensity");
                    resUnitsNode.setNodeValue("1");
                    XdensityNode.setNodeValue(String.valueOf(dpi));
                    YdensityNode.setNodeValue(String.valueOf(dpi));
                    System.out.println("name=" + resUnitsNode.getNodeName() + ", value=" + resUnitsNode.getNodeValue());
                    System.out.println("name=" + XdensityNode.getNodeName() + ", value=" + XdensityNode.getNodeValue());
                    System.out.println("name=" + YdensityNode.getNodeName() + ", value=" + YdensityNode.getNodeValue());
                }
                break;
            }
            try {
                iomd.setFromTree(formatName, node);
            }
            catch (IIOInvalidTreeException e) {
                e.printStackTrace();
            }
            IIOImage iioimage = new IIOImage(image, null, iomd);
            try (FileImageOutputStream stream = new FileImageOutputStream(new File(fileName));){
                imageWriter.setOutput(stream);
                imageWriter.write(iioimage);
            }
        }
    }

    private Node getAttributeByName(Node node, String attributeName) {
        if (node == null) {
            return null;
        }
        NamedNodeMap nnm = node.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node n = nnm.item(i);
            if (!n.getNodeName().equals(attributeName)) continue;
            return n;
        }
        return null;
    }

    public boolean saveImage_Jpeg(String file, int dpi) {
        int h;
        int w;
        if (this.chartSize == null) {
            w = this.getWidth();
            h = this.getHeight();
        } else {
            w = this.chartSize.width;
            h = this.chartSize.height;
        }
        return this.saveImage_Jpeg(file, w, h, dpi);
    }

    public boolean saveImage_Jpeg(String file, int width, int height, int dpi) {
        double scaleFactor = (double)dpi / 72.0;
        BufferedImage bufferedImage = new BufferedImage((int)((double)width * scaleFactor), (int)((double)height * scaleFactor), 1);
        Graphics2D g = bufferedImage.createGraphics();
        AffineTransform at = g.getTransform();
        at.scale(scaleFactor, scaleFactor);
        g.setTransform(at);
        this.paintGraphics(g, width, height);
        try {
            ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("jpeg").next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(new File(file));
            imageWriter.setOutput(ios);
            JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)imageWriter.getDefaultWriteParam();
            jpegParams.setCompressionMode(2);
            jpegParams.setCompressionQuality(0.85f);
            IIOMetadata data = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(bufferedImage), jpegParams);
            Element tree = (Element)data.getAsTree("javax_imageio_jpeg_image_1.0");
            Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
            jfif.setAttribute("Xdensity", Integer.toString(dpi));
            jfif.setAttribute("Ydensity", Integer.toString(dpi));
            jfif.setAttribute("resUnits", "1");
            data.setFromTree("javax_imageio_jpeg_image_1.0", tree);
            imageWriter.write(null, new IIOImage(bufferedImage, null, data), jpegParams);
            ios.close();
            imageWriter.dispose();
        }
        catch (Exception e) {
            return false;
        }
        g.dispose();
        return true;
    }

    public void saveImage(String fileName, int dpi) throws IOException, InterruptedException {
        this.saveImage(fileName, dpi, null);
    }

    public void saveImage(String fileName, int dpi, Integer sleep) throws IOException, InterruptedException {
        int width;
        int height;
        if (this.chartSize != null) {
            height = this.chartSize.height;
            width = this.chartSize.width;
        } else {
            width = this.getWidth();
            height = this.getHeight();
        }
        this.saveImage(fileName, dpi, width, height, sleep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveImage(String fileName, int dpi, int width, int height, Integer sleep) throws IOException, InterruptedException {
        File output = new File(fileName);
        output.delete();
        String formatName = fileName.substring(fileName.lastIndexOf(46) + 1);
        if (formatName.equals("jpg")) {
            formatName = "jpeg";
            this.saveImage_Jpeg(fileName, width, height, dpi);
            return;
        }
        double scaleFactor = (double)dpi / 72.0;
        BufferedImage image = new BufferedImage((int)((double)width * scaleFactor), (int)((double)height * scaleFactor), 2);
        Graphics2D g = image.createGraphics();
        AffineTransform at = g.getTransform();
        at.scale(scaleFactor, scaleFactor);
        g.setTransform(at);
        this.paintGraphics(g, width, height);
        Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName(formatName);
        while (iw.hasNext()) {
            ImageWriter writer = iw.next();
            ImageWriteParam writeParam = writer.getDefaultWriteParam();
            ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(2);
            IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
            if (metadata == null) {
                metadata = writer.getDefaultImageMetadata(typeSpecifier, null);
            }
            if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
            ImageUtil.setDPI(metadata, dpi);
            if (sleep != null) {
                Thread.sleep(sleep * 1000);
            }
            try (ImageOutputStream stream = ImageIO.createImageOutputStream(output);){
                writer.setOutput(stream);
                writer.write(metadata, new IIOImage(image, null, metadata), writeParam);
                break;
            }
        }
        g.dispose();
    }

    public BufferedImage getViewImage() {
        return this.mapBitmap;
    }

    public BufferedImage paintViewImage() {
        int h;
        int w;
        if (this.chartSize == null) {
            w = this.getWidth();
            h = this.getHeight();
        } else {
            w = this.chartSize.width;
            h = this.chartSize.height;
        }
        return this.paintViewImage(w, h);
    }

    public BufferedImage paintViewImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        this.paintGraphics(g);
        return image;
    }

    public BufferedImage paintViewImage(int dpi) {
        int h;
        int w;
        if (this.chartSize == null) {
            w = this.getWidth();
            h = this.getHeight();
        } else {
            w = this.chartSize.width;
            h = this.chartSize.height;
        }
        return this.paintViewImage(w, h, dpi);
    }

    public BufferedImage paintViewImage(int width, int height, int dpi) {
        double scaleFactor = (double)dpi / 72.0;
        BufferedImage image = new BufferedImage((int)((double)width * scaleFactor), (int)((double)height * scaleFactor), 2);
        Graphics2D g = image.createGraphics();
        AffineTransform at = g.getTransform();
        at.scale(scaleFactor, scaleFactor);
        g.setTransform(at);
        this.paintGraphics(g, width, height);
        return image;
    }

    public boolean hasWebMap() {
        if (this.chart != null) {
            return this.chart.hasWebMap();
        }
        return false;
    }
}

