/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.axis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.Location;
import org.meteoinfo.chart.axis.LogAxis;
import org.meteoinfo.chart.axis.PositionType;
import org.meteoinfo.chart.axis.TimeAxis;
import org.meteoinfo.chart.plot.AbstractPlot2D;
import org.meteoinfo.chart.plot.XAlign;
import org.meteoinfo.chart.plot.YAlign;
import org.meteoinfo.drawing.Draw;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.util.BigDecimalUtil;
import org.meteoinfo.global.util.JDateUtil;
import org.meteoinfo.legend.LineStyles;

public class Axis
implements Cloneable {
    protected boolean xAxis = true;
    protected Location location;
    protected ChartText label = null;
    protected boolean visible = true;
    protected boolean drawTickLine = true;
    protected boolean drawTickLabel = true;
    protected boolean drawLabel = false;
    protected Color lineColor = Color.black;
    protected float lineWidth = 1.0f;
    protected LineStyles lineStyle = LineStyles.SOLID;
    protected Color tickColor = Color.black;
    protected Stroke tickStroke = new BasicStroke(1.0f);
    protected int tickLength = 5;
    protected boolean insideTick = true;
    protected Font tickLabelFont = new Font("Arial", 0, 14);
    protected Color tickLabelColor = Color.black;
    protected float tickLabelAngle = 0.0f;
    protected int tickLabelGap = 1;
    protected double tickStartValue;
    protected double tickDeltaValue;
    protected double minValue = 0.0;
    protected double maxValue = 1.0;
    protected double[] tickValues;
    protected boolean inverse;
    protected List<Double> tickLocations;
    protected List<ChartText> tickLabels;
    protected boolean autoTick;
    protected boolean minorTickVisible;
    protected int minorTickNum;
    protected int tickSpace;
    protected PositionType positionType;
    protected float position;

    public Axis() {
        this.updateTickValues();
        this.inverse = false;
        this.tickLocations = new ArrayList<Double>();
        this.tickLabels = new ArrayList<ChartText>();
        this.autoTick = true;
        this.minorTickVisible = false;
        this.minorTickNum = 5;
        this.tickSpace = 5;
        this.positionType = PositionType.OUTERWARD;
        this.position = 0.0f;
    }

    public Axis(ChartText label) {
        this();
        this.label = label;
    }

    public Axis(String label) {
        this();
        this.label = new ChartText(label);
    }

    public Axis(String label, boolean xAxis) {
        this(label);
        this.xAxis = xAxis;
        this.location = this.xAxis ? Location.BOTTOM : Location.LEFT;
    }

    public Axis(ChartText label, boolean xAxis) {
        this(label);
        this.xAxis = xAxis;
        this.location = this.xAxis ? Location.BOTTOM : Location.LEFT;
    }

    public Axis(String label, boolean xAxis, Location loc) {
        this(label);
        this.xAxis = xAxis;
        this.location = loc;
    }

    public Axis(String label, boolean xAxis, Location loc, boolean drawTickLabel) {
        this(label);
        this.xAxis = xAxis;
        this.location = loc;
        this.drawTickLabel = drawTickLabel;
    }

    public Axis(Axis axis) {
        this(axis.getLabel(), axis.isXAxis());
        this.autoTick = axis.isAutoTick();
        this.drawLabel = axis.isDrawLabel();
        this.drawTickLabel = axis.isDrawTickLabel();
        this.drawTickLine = axis.isDrawTickLine();
        this.insideTick = axis.isInsideTick();
        this.inverse = axis.isInverse();
        this.label.setColor(axis.getLabelColor());
        this.lineWidth = axis.getLineWidth();
        this.lineStyle = axis.getLineStyle();
        this.location = axis.getLocation();
        this.maxValue = axis.getMaxValue();
        this.minValue = axis.getMinValue();
        this.minorTickNum = axis.getMinorTickNum();
        this.minorTickVisible = axis.isMinorTickVisible();
        this.tickColor = axis.getTickColor();
        this.tickDeltaValue = axis.getTickDeltaValue();
        this.tickLabelColor = axis.getTickLabelColor();
        this.tickLabelFont = axis.getTickLabelFont();
        this.tickLength = axis.getTickLength();
        this.visible = axis.isVisible();
        this.position = axis.getPosition();
        this.positionType = axis.getPositionType();
    }

    public boolean isXAxis() {
        return this.xAxis;
    }

    public void setXAxis(boolean value) {
        this.xAxis = value;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location value) {
        this.location = value;
    }

    public ChartText getLabel() {
        return this.label;
    }

    public void setLabel(ChartText value) {
        this.label = value;
        if (this.label != null && (this.location == Location.BOTTOM || this.location == Location.LEFT)) {
            this.drawLabel = true;
        }
    }

    public void setLabel(String value) {
        ChartText text = new ChartText(value);
        if (this.xAxis) {
            text.setXAlign(XAlign.CENTER);
            text.setYAlign(YAlign.TOP);
        } else {
            text.setAngle(90.0f);
            text.setXAlign(XAlign.CENTER);
            text.setYAlign(YAlign.BOTTOM);
        }
        this.setLabel(text);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public boolean isDrawTickLine() {
        return this.drawTickLine;
    }

    public void setDrawTickLine(boolean value) {
        this.drawTickLine = value;
    }

    public boolean isDrawTickLabel() {
        return this.drawTickLabel;
    }

    public void setDrawTickLabel(boolean value) {
        this.drawTickLabel = value;
    }

    public boolean isDrawLabel() {
        return this.drawLabel;
    }

    public void setDrawLabel(boolean value) {
        this.drawLabel = value;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color value) {
        this.lineColor = value;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float value) {
        this.lineWidth = value;
    }

    public LineStyles getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(LineStyles value) {
        this.lineStyle = value;
    }

    public Stroke getLineStroke() {
        return new BasicStroke(this.lineWidth, 2, 0, 10.0f, Draw.getDashPattern(this.lineStyle), 0.0f);
    }

    public Color getTickColor() {
        return this.tickColor;
    }

    public void setTickColor(Color value) {
        this.tickColor = value;
    }

    public Stroke getTickStroke() {
        return this.tickStroke;
    }

    public void setTickStroke(Stroke value) {
        this.tickStroke = value;
    }

    public int getTickLength() {
        return this.tickLength;
    }

    public void setTickLength(int value) {
        this.tickLength = value;
    }

    public boolean isInsideTick() {
        return this.insideTick;
    }

    public void setInsideTick(boolean value) {
        this.insideTick = value;
    }

    public Font getLabelFont() {
        return this.label.getFont();
    }

    public void setLabelFont(Font value) {
        this.label.setFont(value);
    }

    public Color getLabelColor() {
        return this.label.getColor();
    }

    public void setLabelColor(Color value) {
        this.label.setColor(value);
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public void setTickLabelFont(Font value) {
        this.tickLabelFont = value;
    }

    public Color getTickLabelColor() {
        return this.tickLabelColor;
    }

    public void setTickLabelColor(Color value) {
        this.tickLabelColor = value;
    }

    public float getTickLabelAngle() {
        return this.tickLabelAngle;
    }

    public void setTickLabelAngle(float value) {
        this.tickLabelAngle = value;
    }

    public int getTickLabelGap() {
        return this.tickLabelGap;
    }

    public void setTickLabelGap(int value) {
        this.tickLabelGap = value;
    }

    public double getTickStartValue() {
        return this.tickStartValue;
    }

    public void setTickStartValue(double value) {
        this.tickStartValue = value;
    }

    public double getTickDeltaValue() {
        return this.tickDeltaValue;
    }

    public void setTickDeltaValue(double value) {
        this.tickDeltaValue = value;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double value) {
        this.minValue = value;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double value) {
        this.maxValue = value;
    }

    public double[] getTickValues() {
        if (this.autoTick) {
            return this.tickValues;
        }
        ArrayList<Double> values = new ArrayList<Double>();
        for (double v : this.tickLocations) {
            if (!(v >= this.minValue) || !(v <= this.maxValue)) continue;
            values.add(v);
        }
        double[] vs = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            vs[i] = (Double)values.get(i);
        }
        return vs;
    }

    public void setTickValues(double[] value) {
        this.tickValues = value;
        this.tickDeltaValue = value.length > 1 ? BigDecimalUtil.sub(value[1], value[0]) : 0.0;
    }

    public void setTickValues(List<Double> value) {
        this.tickValues = new double[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            this.tickValues[i] = value.get(i);
        }
        this.tickDeltaValue = value.size() > 1 ? BigDecimalUtil.sub(value.get(1), value.get(0)) : 0.0;
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public void setInverse(boolean value) {
        this.inverse = value;
    }

    public List<Double> getTickLocations() {
        return this.tickLocations;
    }

    public void setTickLocations(List<Number> value) {
        this.tickLocations.clear();
        this.tickLabels.clear();
        for (Number v : value) {
            this.tickLocations.add(v.doubleValue());
            this.tickLabels.add(new ChartText(String.valueOf(v)));
        }
        this.autoTick = false;
    }

    public void setTickLocations(double[] value) {
        this.tickLocations.clear();
        this.tickLabels.clear();
        for (double v : value) {
            this.tickLocations.add(v);
            String tick = String.valueOf(v);
            tick = DataConvert.removeTailingZeros(tick);
            this.tickLabels.add(new ChartText(tick));
        }
        this.autoTick = false;
    }

    public List<ChartText> getTickLabels() {
        return this.tickLabels;
    }

    public List<String> getTickLabelText() {
        ArrayList<String> strs = new ArrayList<String>();
        for (ChartText ct : this.tickLabels) {
            strs.add(ct.toString());
        }
        return strs;
    }

    public void setTickLabelText(List<String> value) {
        this.tickLabels = new ArrayList<ChartText>();
        for (String v : value) {
            this.tickLabels.add(new ChartText(v));
        }
        this.autoTick = false;
    }

    public void setTickLabels(List<ChartText> value) {
        this.tickLabels = value;
    }

    public void setTickLabels_Number(List<Number> value) {
        this.tickLabels = new ArrayList<ChartText>();
        for (Number v : value) {
            this.tickLabels.add(new ChartText(v.toString()));
        }
        this.autoTick = false;
    }

    public boolean isAutoTick() {
        return this.autoTick;
    }

    public void setAutoTick(boolean value) {
        this.autoTick = value;
    }

    public boolean isMinorTickVisible() {
        return this.minorTickVisible;
    }

    public void setMinorTickVisible(boolean value) {
        this.minorTickVisible = value;
    }

    public int getMinorTickNum() {
        return this.minorTickNum;
    }

    public void setMinorTickNum(int value) {
        this.minorTickNum = value;
    }

    public int getTickSpace() {
        return this.tickSpace;
    }

    public void setTickSpace(int value) {
        this.tickSpace = value;
    }

    public PositionType getPositionType() {
        return this.positionType;
    }

    public void setPositionType(PositionType value) {
        this.positionType = value;
    }

    public void setPositionType(String value) {
        this.positionType = PositionType.valueOf(value.toUpperCase());
    }

    public float getPosition() {
        return this.position;
    }

    public void setPosition(float value) {
        this.position = value;
    }

    public void setMinMaxValue(double minValue, double maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        if (Double.isNaN(minValue) || Double.isNaN(maxValue)) {
            return;
        }
        this.updateTickValues();
    }

    public void updateTickValues() {
        List<Object> r = MIMath.getIntervalValues1(this.minValue, this.maxValue);
        this.tickValues = (double[])r.get(0);
        this.tickDeltaValue = (Double)r.get(1);
    }

    public void updateTickLabels() {
        ArrayList<ChartText> tls = new ArrayList<ChartText>();
        if (this.autoTick) {
            if (this.getTickValues() == null) {
                return;
            }
            this.tickLocations = new ArrayList<Double>();
            for (double value : this.getTickValues()) {
                this.tickLocations.add(value);
                String lab = String.valueOf(value);
                lab = DataConvert.removeTailingZeros(lab);
                tls.add(new ChartText(lab));
            }
        } else {
            for (int i = 0; i < this.tickLocations.size() && i < this.tickLabels.size(); ++i) {
                double v = this.tickLocations.get(i);
                if (!(v >= this.minValue) || !(v <= this.maxValue)) continue;
                tls.add(this.tickLabels.get(i));
            }
        }
        this.tickLabels = tls;
    }

    public int getMaxLabelLength(Graphics2D g) {
        this.updateTickLabels();
        int max = 0;
        g.setFont(this.tickLabelFont);
        for (int i = 0; i < this.tickLabels.size(); ++i) {
            ChartText lab = this.tickLabels.get(i);
            Dimension dim = Draw.getStringDimension(lab.getText(), g);
            int width = dim.width;
            if (this.tickLabelAngle != 0.0f) {
                width = (int)(dim.getWidth() * Math.cos((double)this.tickLabelAngle * Math.PI / 180.0));
                int height = dim.height;
                width = Math.max(width, height);
            }
            if (max >= width) continue;
            max = width;
        }
        return max;
    }

    public String getMaxLenLable() {
        this.updateTickLabels();
        if (this.tickLabels.isEmpty()) {
            return "1";
        }
        ChartText rlab = this.tickLabels.get(0);
        for (ChartText lab : this.tickLabels) {
            if (lab.getText().length() <= rlab.getText().length()) continue;
            rlab = lab;
        }
        return rlab.getText();
    }

    public ChartText getMaxLenText() {
        this.updateTickLabels();
        if (this.tickLabels.isEmpty()) {
            return new ChartText("1");
        }
        ChartText rlab = this.tickLabels.get(0);
        for (ChartText lab : this.tickLabels) {
            if (lab.getText().length() <= rlab.getText().length()) continue;
            rlab = lab;
        }
        return rlab;
    }

    public Dimension getMaxTickDim(Graphics2D g) {
        this.updateTickLabels();
        Dimension dim = new Dimension();
        if (this.tickLabels.isEmpty()) {
            return dim;
        }
        double width = dim.getWidth();
        double height = dim.getHeight();
        for (int i = 0; i < this.tickLabels.size(); ++i) {
            ChartText ct = this.tickLabels.get(i);
            ct.setAngle(this.tickLabelAngle);
            Dimension dim1 = ct.getTrueDimension(g);
            if (width < dim1.getWidth()) {
                width = dim1.getWidth();
            }
            if (!(height < dim1.getHeight())) continue;
            height = dim1.getHeight();
        }
        dim.setSize(width, height);
        return dim;
    }

    public ChartText getMaxLinesText() {
        this.updateTickLabels();
        if (this.tickLabels.isEmpty()) {
            return new ChartText("1");
        }
        ChartText rlab = this.tickLabels.get(0);
        for (ChartText lab : this.tickLabels) {
            if (lab.getTexts().size() <= rlab.getTexts().size()) continue;
            rlab = lab;
        }
        return rlab;
    }

    public int getMaxTickLableLines() {
        this.updateTickLabels();
        if (this.tickLabels.isEmpty()) {
            return 1;
        }
        int ln = this.tickLabels.get(0).getLineNum();
        for (ChartText lab : this.tickLabels) {
            if (lab.getLineNum() <= ln) continue;
            ln = lab.getLineNum();
        }
        return ln;
    }

    public void updateLabelGap(Graphics2D g, Rectangle2D rect) {
        int nn;
        if (this.getTickValues() == null) {
            return;
        }
        int n = this.getTickValues().length;
        if (this.xAxis) {
            double len = rect.getWidth();
            int labLen = this.getMaxLabelLength(g);
            nn = (int)(len * 0.8 / (double)labLen);
        } else {
            double len = rect.getHeight();
            FontMetrics metrics = g.getFontMetrics(this.label.getFont());
            nn = (int)(len / (double)metrics.getHeight());
        }
        if (nn == 0) {
            nn = 1;
        }
        this.tickLabelGap = n / nn + 1;
    }

    public int getLabelGap(Graphics2D g, double len) {
        if (this.getTickValues() == null) {
            return 1;
        }
        int n = this.getTickValues().length;
        FontMetrics metrics = g.getFontMetrics(this.label.getFont());
        int nn = (int)(len / (double)metrics.getHeight());
        if (nn == 0) {
            nn = 1;
        }
        return n / nn + 1;
    }

    public void setColor_All(Color c) {
        this.lineColor = c;
        this.tickColor = c;
        this.tickLabelColor = c;
        this.label.setColor(c);
    }

    public void draw(Graphics2D g, Rectangle2D area, AbstractPlot2D plot) {
        if (plot.getDrawExtent() == null) {
            return;
        }
        if (this.xAxis) {
            this.drawXAxis(g, area, plot);
        } else {
            this.drawYAxis(g, area, plot);
        }
    }

    private void drawXAxis(Graphics2D g, Rectangle2D area, AbstractPlot2D plot) {
        float labx;
        double x;
        double[] xy;
        double sy = 0.0;
        double miny = area.getY();
        double minx = area.getX();
        double maxx = area.getX() + area.getWidth();
        double maxy = area.getY() + area.getHeight();
        float laby = (float)maxy;
        g.setColor(this.lineColor);
        g.setStroke(this.getLineStroke());
        switch (this.positionType) {
            case OUTERWARD: {
                if (this.location == Location.BOTTOM) {
                    sy = maxy + (double)this.position;
                    break;
                }
                sy = miny - (double)this.position;
                break;
            }
            case AXES: {
                sy = miny + (double)this.position * area.getHeight();
                break;
            }
            case DATA: {
                xy = plot.projToScreen(plot.getDrawExtent().minX, this.position, area);
                sy = miny + xy[1];
            }
        }
        g.draw(new Line2D.Double(minx, sy, maxx, sy));
        int len = 0;
        if (this.drawTickLine) {
            TimeAxis tAxis;
            g.setColor(this.tickColor);
            g.setStroke(this.tickStroke);
            g.setFont(this.tickLabelFont);
            len = this.tickLength;
            this.updateTickLabels();
            int n = 0;
            while (n < this.getTickValues().length) {
                int i;
                double value = this.getTickValues()[n];
                if (value >= this.minValue && value <= this.maxValue) {
                    xy = plot.projToScreen(value, plot.getDrawExtent().minY, area);
                    x = xy[0];
                    x += minx;
                    if (this.location == Location.BOTTOM) {
                        if (this.insideTick) {
                            g.draw(new Line2D.Double(x, sy, x, sy - (double)len));
                        } else {
                            g.draw(new Line2D.Double(x, sy, x, sy + (double)len));
                        }
                    } else if (this.insideTick) {
                        g.draw(new Line2D.Double(x, sy, x, sy + (double)len));
                    } else {
                        g.draw(new Line2D.Double(x, sy, x, sy - (double)len));
                    }
                    if (this.drawTickLabel && n < this.tickLabels.size()) {
                        ChartText chartText = this.tickLabels.get(n);
                        g.setFont(this.tickLabelFont);
                        if (this.location == Location.BOTTOM) {
                            laby = this.insideTick ? (float)sy : (float)(sy + (double)len);
                            laby += (float)this.tickSpace;
                        } else {
                            laby = this.insideTick ? (float)sy : (float)(sy - (double)len);
                            laby -= (float)this.tickSpace;
                        }
                        Dimension dim = Draw.getStringDimension(chartText.getText(), this.tickLabelAngle, g);
                        labx = (float)x;
                        for (String dstr : chartText.getTexts()) {
                            if (this.location == Location.BOTTOM) {
                                if (this.tickLabelAngle == 0.0f) {
                                    Draw.drawString(g, labx, laby, dstr, XAlign.CENTER, YAlign.TOP, true);
                                } else if (this.tickLabelAngle < 45.0f) {
                                    Draw.drawString(g, labx, laby, dstr, XAlign.RIGHT, YAlign.TOP, this.tickLabelAngle, true);
                                } else {
                                    Draw.drawString(g, labx, laby, dstr, XAlign.RIGHT, YAlign.CENTER, this.tickLabelAngle, true);
                                }
                                laby = (float)((double)laby + (dim.getHeight() + (double)chartText.getLineSpace()));
                                continue;
                            }
                            if (this.tickLabelAngle == 0.0f) {
                                Draw.drawString(g, labx, laby, dstr, XAlign.CENTER, YAlign.BOTTOM, true);
                            } else if (this.tickLabelAngle < 45.0f) {
                                Draw.drawString(g, labx, laby, dstr, XAlign.LEFT, YAlign.BOTTOM, this.tickLabelAngle, true);
                            } else {
                                Draw.drawString(g, labx, laby, dstr, XAlign.LEFT, YAlign.CENTER, this.tickLabelAngle, true);
                            }
                            laby = (float)((double)laby - (dim.getHeight() + (double)chartText.getLineSpace()));
                        }
                    }
                }
                n += this.getTickLabelGap();
                if (!this.isMinorTickVisible()) continue;
                int minorLen = len - 2;
                double sp = this.tickDeltaValue * (double)this.getTickLabelGap() / (double)this.minorTickNum;
                if (this instanceof LogAxis) {
                    if (n >= this.getTickValues().length) break;
                    sp = (this.getTickValues()[n] - this.getTickValues()[n - 1]) / (double)this.minorTickNum;
                }
                ArrayList<Double> xx = new ArrayList<Double>();
                if (n == 1 && value > this.minValue + sp) {
                    double value1 = value;
                    for (int i2 = 0; i2 < this.minorTickNum - 1 && !((value1 -= sp) <= this.minValue); ++i2) {
                        xy = plot.projToScreen(value1, plot.getDrawExtent().minY, area);
                        x = xy[0];
                        xx.add(x += minx);
                    }
                }
                for (i = 0; i < this.minorTickNum - 1 && !((value += sp) >= this.maxValue); ++i) {
                    if (value <= this.minValue) continue;
                    xy = plot.projToScreen(value, plot.getDrawExtent().minY, area);
                    x = xy[0];
                    xx.add(x += minx);
                }
                for (i = 0; i < xx.size(); ++i) {
                    x = (Double)xx.get(i);
                    if (this.location == Location.BOTTOM) {
                        if (this.insideTick) {
                            g.draw(new Line2D.Double(x, sy, x, sy - (double)minorLen));
                            continue;
                        }
                        g.draw(new Line2D.Double(x, sy, x, sy + (double)minorLen));
                        continue;
                    }
                    if (this.insideTick) {
                        g.draw(new Line2D.Double(x, sy, x, sy + (double)minorLen));
                        continue;
                    }
                    g.draw(new Line2D.Double(x, sy, x, sy - (double)minorLen));
                }
            }
            if (this.drawTickLabel && this instanceof TimeAxis && (tAxis = (TimeAxis)this).isVarFormat()) {
                String drawStr = null;
                switch (tAxis.getTimeUnit()) {
                    case MONTH: {
                        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy");
                        LocalDateTime cdate = JDateUtil.fromOADate(this.getTickValues()[0]);
                        drawStr = format.format(cdate);
                        break;
                    }
                    case DAY: {
                        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM");
                        LocalDateTime cdate = JDateUtil.fromOADate(this.getTickValues()[0]);
                        drawStr = format.format(cdate);
                        break;
                    }
                    case HOUR: 
                    case MINUTE: 
                    case SECOND: {
                        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                        LocalDateTime cdate = JDateUtil.fromOADate(this.getTickValues()[0]);
                        drawStr = format.format(cdate);
                    }
                }
                if (drawStr != null) {
                    labx = (float)minx;
                    Draw.drawString(g, labx, laby += (float)this.tickSpace, drawStr, XAlign.LEFT, YAlign.TOP, true);
                    laby += (float)(Draw.getStringDimension((String)drawStr, (Graphics2D)g).height + this.tickSpace);
                }
            }
        }
        if (this.isDrawLabel()) {
            x = (maxx - minx) / 2.0 + minx;
            g.setFont(this.getLabelFont());
            g.setColor(this.getLabelColor());
            labx = (float)x;
            this.label.setXAlign(XAlign.CENTER);
            if (this.getLocation() == Location.BOTTOM) {
                this.label.setYAlign(YAlign.TOP);
            } else {
                this.label.setYAlign(YAlign.BOTTOM);
            }
            this.label.draw(g, labx, laby);
        }
    }

    private void drawYAxis(Graphics2D g, Rectangle2D area, AbstractPlot2D plot) {
        double y;
        double[] xy;
        double sx = 0.0;
        double miny = area.getY();
        double minx = area.getX();
        double maxx = area.getX() + area.getWidth();
        double maxy = area.getY() + area.getHeight();
        g.setColor(this.getLineColor());
        g.setStroke(this.getLineStroke());
        switch (this.positionType) {
            case OUTERWARD: {
                if (this.location == Location.LEFT) {
                    sx = minx - (double)this.position;
                    break;
                }
                sx = maxx + (double)this.position;
                break;
            }
            case AXES: {
                sx = minx + (double)this.position * area.getWidth();
                break;
            }
            case DATA: {
                xy = plot.projToScreen(this.position, plot.getDrawExtent().minY, area);
                sx = minx + xy[0];
            }
        }
        g.draw(new Line2D.Double(sx, maxy, sx, miny));
        int len = 0;
        if (this.drawTickLine) {
            g.setColor(this.getTickColor());
            g.setStroke(this.getTickStroke());
            g.setFont(this.getTickLabelFont());
            this.updateLabelGap(g, area);
            len = this.getTickLength();
            this.updateTickLabels();
            int n = 0;
            while (n < this.getTickValues().length) {
                int i;
                double value = this.getTickValues()[n];
                xy = plot.projToScreen(plot.getDrawExtent().minX, value, area);
                y = xy[1];
                y += area.getY();
                if (this.location == Location.LEFT) {
                    if (this.isInsideTick()) {
                        g.draw(new Line2D.Double(sx, y, sx + (double)len, y));
                    } else {
                        g.draw(new Line2D.Double(sx, y, sx - (double)len, y));
                    }
                } else if (this.isInsideTick()) {
                    g.draw(new Line2D.Double(sx, y, sx - (double)len, y));
                } else {
                    g.draw(new Line2D.Double(sx, y, sx + (double)len, y));
                }
                if (this.drawTickLabel && n < this.tickLabels.size()) {
                    float laby;
                    float labx;
                    String drawStr = this.tickLabels.get(n).getText();
                    g.setFont(this.tickLabelFont);
                    if (this.location == Location.LEFT) {
                        labx = (float)(sx - (double)this.tickSpace);
                        if (!this.isInsideTick()) {
                            labx -= (float)len;
                        }
                        laby = (float)y;
                        Draw.drawString(g, labx, laby, drawStr, XAlign.RIGHT, YAlign.CENTER, this.tickLabelAngle, true);
                    } else {
                        labx = (float)(sx + (double)this.tickSpace);
                        if (!this.isInsideTick()) {
                            labx += (float)len;
                        }
                        laby = (float)y;
                        Draw.drawString(g, labx, laby, drawStr, XAlign.LEFT, YAlign.CENTER, this.tickLabelAngle, true);
                    }
                }
                n += this.getTickLabelGap();
                if (!this.isMinorTickVisible()) continue;
                int minorLen = len - 2;
                double sp = this.tickDeltaValue * (double)this.getTickLabelGap() / (double)this.minorTickNum;
                if (this instanceof LogAxis) {
                    if (n >= this.getTickValues().length) break;
                    sp = (this.getTickValues()[n] - this.getTickValues()[n - 1]) / (double)this.minorTickNum;
                }
                ArrayList<Double> yy = new ArrayList<Double>();
                if (n == 1 && value > this.minValue + sp) {
                    double value1 = value;
                    for (int i2 = 0; i2 < this.minorTickNum - 1 && !((value1 -= sp) <= this.minValue); ++i2) {
                        xy = plot.projToScreen(plot.getDrawExtent().minX, value1, area);
                        y = xy[1];
                        yy.add(y += miny);
                    }
                }
                for (i = 0; i < this.minorTickNum - 1 && !((value += sp) >= this.maxValue); ++i) {
                    if (value <= this.minValue) continue;
                    xy = plot.projToScreen(plot.getDrawExtent().minX, value, area);
                    y = xy[1];
                    yy.add(y += miny);
                }
                for (i = 0; i < yy.size(); ++i) {
                    y = (Double)yy.get(i);
                    if (this.location == Location.LEFT) {
                        if (this.isInsideTick()) {
                            g.draw(new Line2D.Double(sx, y, sx + (double)minorLen, y));
                            continue;
                        }
                        g.draw(new Line2D.Double(sx, y, sx - (double)minorLen, y));
                        continue;
                    }
                    if (this.isInsideTick()) {
                        g.draw(new Line2D.Double(sx, y, sx - (double)minorLen, y));
                        continue;
                    }
                    g.draw(new Line2D.Double(sx, y, sx + (double)minorLen, y));
                }
            }
        }
        XAlign x_align = XAlign.CENTER;
        YAlign y_align = YAlign.BOTTOM;
        if (this.isDrawLabel()) {
            double x;
            if (this.location == Location.LEFT) {
                x = sx - (double)this.tickSpace;
                if (this.drawTickLine) {
                    if (!this.isInsideTick()) {
                        x -= (double)len;
                    }
                    if (this.drawTickLabel) {
                        x = x - (double)this.getMaxLabelLength(g) - (double)this.tickSpace;
                    }
                }
                y = (maxy - miny) / 2.0 + miny;
                if (this.label.getAngle() == 90.0f) {
                    x_align = XAlign.CENTER;
                    y_align = YAlign.BOTTOM;
                } else if (this.label.getAngle() == -90.0f) {
                    x_align = XAlign.CENTER;
                    y_align = YAlign.TOP;
                    x -= (double)this.label.getDimension((Graphics2D)g).height;
                } else if (this.label.getAngle() == 0.0f) {
                    x_align = XAlign.RIGHT;
                    y_align = YAlign.CENTER;
                } else if (Math.abs(this.label.getAngle()) == 180.0f) {
                    x_align = XAlign.LEFT;
                    y_align = YAlign.TOP;
                    y -= (double)this.label.getDimension((Graphics2D)g).height;
                } else if (this.label.getAngle() > 0.0f && this.label.getAngle() < 90.0f) {
                    x_align = XAlign.RIGHT;
                    y_align = YAlign.TOP;
                }
            } else {
                x = sx + (double)this.tickSpace;
                if (this.drawTickLine) {
                    if (!this.isInsideTick()) {
                        x += (double)len;
                    }
                    if (this.drawTickLabel) {
                        x = x + (double)this.getMaxLabelLength(g) + 5.0;
                    }
                }
                y = (maxy - miny) / 2.0 + miny;
                y_align = YAlign.TOP;
            }
            this.label.setXAlign(x_align);
            this.label.setYAlign(y_align);
            this.label.draw(g, (float)x, (float)y);
        }
    }

    public int getXAxisHeight(Graphics2D g) {
        Dimension dim;
        if (!this.isVisible()) {
            return 0;
        }
        int height = 0;
        if (!this.insideTick) {
            height += this.tickLength;
        }
        this.updateTickLabels();
        if (this.isDrawTickLabel() && this.tickLabels.size() > 0) {
            dim = this.getMaxTickDim(g);
            height += this.tickSpace + dim.height;
            Dimension dim1 = Draw.getStringDimension("Test", g);
            if (this instanceof TimeAxis) {
                height += dim1.height + this.tickSpace;
            }
        }
        if (this.isDrawLabel()) {
            g.setFont(this.getLabelFont());
            dim = Draw.getStringDimension(this.getLabel().getText(), g);
            height += dim.height + this.tickSpace * 2;
        }
        return height;
    }

    public int getYAxisWidth(Graphics2D g) {
        if (!this.isVisible()) {
            return 0;
        }
        int width = 0;
        if (this.isDrawTickLabel()) {
            width += this.getMaxLabelLength(g) + this.tickSpace + this.tickSpace;
        }
        if (!this.isInsideTick()) {
            width += this.getTickLength();
        }
        if (this.isDrawLabel()) {
            g.setFont(this.getLabelFont());
            Dimension dim = Draw.getStringDimension(this.getLabel().getText(), g);
            width += dim.height + 10 - this.tickSpace;
        }
        return width;
    }

    public Object clone() throws CloneNotSupportedException {
        Axis o = null;
        try {
            o = (Axis)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return o;
    }
}

