/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.axis;

import java.util.ArrayList;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.axis.Axis;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.MIMath;

public class LogAxis
extends Axis {
    public LogAxis(Axis axis) {
        super(axis);
    }

    @Override
    public void updateTickValues() {
        double[] r = MIMath.getIntervalValues_Log(this.getMinValue(), this.getMaxValue());
        this.setTickValues(r);
        this.setTickDeltaValue(1.0);
    }

    @Override
    public void updateTickLabels() {
        ArrayList<ChartText> tls = new ArrayList<ChartText>();
        if (this.isAutoTick()) {
            if (this.getTickValues() == null) {
                return;
            }
            for (double value : this.getTickValues()) {
                String lab = String.valueOf(value);
                lab = DataConvert.removeTailingZeros(lab);
                tls.add(new ChartText(lab));
            }
            ArrayList<Double> values = new ArrayList<Double>();
            for (ChartText tl : tls) {
                values.add(Double.parseDouble(tl.getText()));
            }
            tls.clear();
            for (Double v : values) {
                int e = (int)Math.floor(Math.log10(v));
                tls.add(new ChartText("$10^{" + String.valueOf(e) + "}$"));
            }
        } else {
            for (int i = 0; i < this.getTickLocations().size() && i < this.getTickLabels().size(); ++i) {
                double v = this.getTickLocations().get(i);
                if (!(v >= this.getMinValue()) || !(v <= this.getMaxValue())) continue;
                tls.add(this.getTickLabels().get(i));
            }
        }
        this.setTickLabels(tls);
    }
}

