/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.dataframe;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.meteoinfo.data.dataframe.Index;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.util.JDateUtil;
import org.meteoinfo.math.ArrayMath;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;

public class DateTimeIndex
extends Index<LocalDateTime> {
    TemporalAmount period;
    TemporalAmount resamplePeriod;
    DateTimeFormatter dtFormatter;

    public DateTimeIndex() {
        this.format = "yyyy-MM-dd";
        this.dtFormatter = DateTimeFormatter.ofPattern(this.format);
        this.dataType = DataType.DATE;
    }

    public DateTimeIndex(Array data) {
        this(ArrayMath.asList(data));
    }

    public DateTimeIndex(List data) {
        this(data, "Index");
    }

    public DateTimeIndex(List data, String name) {
        this();
        this.name = name;
        if (data.get(0) instanceof Date) {
            this.data = new ArrayList();
            for (Date d : data) {
                this.data.add(d.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
            }
        } else {
            this.data = data;
        }
        this.updateFormat();
    }

    public DateTimeIndex(String start, String end, String freq) {
        this();
        LocalDateTime sdt = JDateUtil.getDateTime(start);
        LocalDateTime edt = JDateUtil.getDateTime(end);
        this.period = JDateUtil.getPeriod(freq);
        this.setFormat(JDateUtil.getDateFormat(this.period));
        this.data = JDateUtil.getDateTimes(sdt, edt, this.period);
    }

    public DateTimeIndex(String start, int tNum, String freq) {
        this();
        LocalDateTime sdt = JDateUtil.getDateTime(start);
        this.period = JDateUtil.getPeriod(freq);
        this.setFormat(JDateUtil.getDateFormat(this.period));
        this.data = JDateUtil.getDateTimes(sdt, tNum, this.period);
    }

    public DateTimeIndex(int tNum, String end, String freq) {
        this();
        LocalDateTime edt = JDateUtil.getDateTime(end);
        this.period = JDateUtil.getPeriod(freq);
        this.setFormat(JDateUtil.getDateFormat(this.period));
        this.data = JDateUtil.getDateTimes(tNum, edt, this.period);
    }

    public TemporalAmount getPeriod() {
        return this.period;
    }

    public void setPeriod(TemporalAmount value) {
        this.period = value;
        this.setFormat(JDateUtil.getDateFormat(value));
    }

    public TemporalAmount getResamplePeriod() {
        return this.resamplePeriod == null ? this.period : this.resamplePeriod;
    }

    public void setResamplPeriod(TemporalAmount value) {
        this.resamplePeriod = value;
    }

    @Override
    public void setFormat(String value) {
        super.setFormat(value);
        this.dtFormatter = DateTimeFormatter.ofPattern(this.format);
    }

    @Override
    public String getNameFormat() {
        String str = this.dtFormatter.format((TemporalAccessor)this.data.get(0));
        return "%" + String.valueOf(str.length()) + "s";
    }

    public int indexOf(LocalDateTime d) {
        return this.data.indexOf(d);
    }

    private LocalDateTime toDateTime(Object d) {
        LocalDateTime dt = null;
        if (d instanceof LocalDateTime) {
            dt = (LocalDateTime)d;
        } else if (d instanceof Date) {
            dt = ((Date)d).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        } else if (d instanceof Timestamp) {
            dt = ((Timestamp)d).toLocalDateTime();
        } else if (d instanceof String) {
            dt = JDateUtil.getDateTime((String)d);
        }
        return dt;
    }

    public int indexOf(Date d) {
        LocalDateTime dt = d.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return this.data.indexOf(dt);
    }

    public int indexOf(String d) {
        LocalDateTime dt = JDateUtil.getDateTime(d);
        return this.data.indexOf(dt);
    }

    @Override
    public List<Integer> indexOf(List ds) {
        ArrayList<Integer> r;
        block4: {
            block5: {
                block3: {
                    r = new ArrayList<Integer>();
                    if (!(ds.get(0) instanceof Date)) break block3;
                    for (Object d : ds) {
                        r.add(this.indexOf((Date)d));
                    }
                    break block4;
                }
                if (!(ds.get(0) instanceof LocalDateTime)) break block5;
                for (Object d : ds) {
                    r.add(this.indexOf((LocalDateTime)d));
                }
                break block4;
            }
            if (!(ds.get(0) instanceof String)) break block4;
            for (Object d : ds) {
                r.add(this.indexOf((String)d));
            }
        }
        return r;
    }

    @Override
    public Object[] getIndices(List<Object> labels) {
        if (labels.get(0) instanceof LocalDateTime) {
            return super.getIndices(labels);
        }
        ArrayList<Object> dts = new ArrayList<Object>();
        for (Object label : labels) {
            dts.add(this.toDateTime(label));
        }
        return super.getIndices(dts);
    }

    @Override
    public Object[] getIndices(Object label) {
        if (label instanceof LocalDateTime) {
            return super.getIndices(label);
        }
        LocalDateTime dt = this.toDateTime(label);
        return super.getIndices(dt);
    }

    @Override
    public DateTimeIndex subIndex() {
        DateTimeIndex r = new DateTimeIndex(this.data);
        r.setFormat(this.format);
        return r;
    }

    @Override
    public DateTimeIndex subIndex(List<Integer> idx) {
        DateTimeIndex r = new DateTimeIndex();
        for (int i : idx) {
            r.add((LocalDateTime)this.data.get(i));
        }
        r.setFormat(this.format);
        return r;
    }

    @Override
    public DateTimeIndex subIndex(int start, int end, int step) {
        ArrayList rv = new ArrayList();
        for (int i = start; i < end; i += step) {
            rv.add(this.data.get(i));
        }
        DateTimeIndex r = new DateTimeIndex(rv);
        r.setFormat(this.format);
        return r;
    }

    public Index getYear() {
        ArrayList<Integer> years = new ArrayList<Integer>();
        for (LocalDateTime dt : this.data) {
            years.add(dt.getYear());
        }
        return Index.factory(years);
    }

    public Index getMonth() {
        ArrayList<Integer> months = new ArrayList<Integer>();
        for (LocalDateTime dt : this.data) {
            months.add(dt.getMonthValue());
        }
        return Index.factory(months);
    }

    public Index getDay() {
        ArrayList<Integer> days = new ArrayList<Integer>();
        for (LocalDateTime dt : this.data) {
            days.add(dt.getDayOfMonth());
        }
        return Index.factory(days);
    }

    public Index getHour() {
        ArrayList<Integer> hours = new ArrayList<Integer>();
        for (LocalDateTime dt : this.data) {
            hours.add(dt.getHour());
        }
        return Index.factory(hours);
    }

    public Index getMinute() {
        ArrayList<Integer> minutes = new ArrayList<Integer>();
        for (LocalDateTime dt : this.data) {
            minutes.add(dt.getMinute());
        }
        return Index.factory(minutes);
    }

    public Index getSecond() {
        ArrayList<Integer> seconds = new ArrayList<Integer>();
        for (LocalDateTime dt : this.data) {
            seconds.add(dt.getSecond());
        }
        return Index.factory(seconds);
    }

    @Override
    public void updateFormat() {
        int n = Math.min(10, this.data.size());
        String ff = "yyyyMMddHHmmSS";
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(ff);
        int idx = 8;
        for (int i = 0; i < n; ++i) {
            String str = dtf.format((TemporalAccessor)this.data.get(i));
            str = DataConvert.removeTail0(str);
            idx = Math.max(idx, str.length());
        }
        switch (idx) {
            case 8: {
                ff = "yyyy-MM-dd";
                break;
            }
            case 9: 
            case 10: {
                ff = "yyyy-MM-dd HH";
                break;
            }
            case 11: 
            case 12: {
                ff = "yyyy-MM-dd HH:mm";
                break;
            }
            case 13: 
            case 14: {
                ff = "yyyy-MM-dd HH:mm:SS";
            }
        }
        this.setFormat(ff);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DateTimeIndex([");
        for (int i = 0; i < this.size(); ++i) {
            sb.append("'");
            sb.append(this.toString(i));
            sb.append("'");
            if (i < 100) {
                if (i >= this.size() - 1) break;
            } else {
                sb.append(", ...");
                break;
            }
            sb.append(", ");
        }
        sb.append("])");
        return sb.toString();
    }

    @Override
    public String toString(int idx) {
        return this.dtFormatter.format((TemporalAccessor)this.data.get(idx));
    }

    @Override
    public String toString(int idx, String format) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(format);
        return dtf.format((TemporalAccessor)this.data.get(idx));
    }

    @Override
    public Object clone() {
        ArrayList ndata = new ArrayList(this.data);
        DateTimeIndex r = new DateTimeIndex(ndata, this.name);
        r.format = this.format;
        r.period = this.period;
        r.resamplePeriod = this.resamplePeriod;
        return r;
    }
}

