/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.dataframe;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.meteoinfo.data.dataframe.DateTimeIndex;
import org.meteoinfo.data.dataframe.GroupBy;
import org.meteoinfo.data.dataframe.Series;
import org.meteoinfo.data.dataframe.impl.Aggregation;
import org.meteoinfo.data.dataframe.impl.Function;
import org.meteoinfo.data.dataframe.impl.Grouping;
import org.meteoinfo.data.dataframe.impl.SparseBitSet;
import org.meteoinfo.ndarray.InvalidRangeException;

public class SeriesGroupBy
extends GroupBy
implements Iterable<Map.Entry<Object, Series>> {
    private final Series series;
    private Map<Object, Series> sGroups = null;

    public SeriesGroupBy(Grouping groups, Series series) {
        this.groups = groups;
        this.series = series;
    }

    public Series getGroup(Object key) throws InvalidRangeException {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        SparseBitSet _rows = this.groups.getGroup(key);
        int r = _rows.nextSetBit(0);
        while (r >= 0) {
            rows.add(r);
            r = _rows.nextSetBit(r + 1);
        }
        return this.series.getValues(rows);
    }

    public <V> Series apply(Function<?, ?> function) {
        Series s = this.groups.apply(this.series, function);
        if (this.series.getIndex() instanceof DateTimeIndex && s.getIndex() instanceof DateTimeIndex) {
            ((DateTimeIndex)s.getIndex()).setPeriod(((DateTimeIndex)this.series.getIndex()).getResamplePeriod());
        }
        return s;
    }

    @Override
    public Series count() {
        Series r = this.apply(new Aggregation.Count());
        return r;
    }

    @Override
    public Series sum() {
        Series r = this.apply(new Aggregation.Sum());
        return r;
    }

    @Override
    public Series mean() {
        Series r = this.apply(new Aggregation.Mean());
        return r;
    }

    @Override
    public Series min() {
        Series r = this.apply(new Aggregation.Min());
        return r;
    }

    @Override
    public Series max() {
        Series r = this.apply(new Aggregation.Max());
        return r;
    }

    @Override
    public Series median() {
        Series r = this.apply(new Aggregation.Median());
        return r;
    }

    @Override
    public Series stdDev() {
        Series r = this.apply(new Aggregation.StdDev());
        return r;
    }

    @Override
    public Series percentile(double quantile) {
        Series r = this.apply(new Aggregation.Percentile(quantile * 100.0));
        return r;
    }

    @Override
    public Iterator<Map.Entry<Object, Series>> iterator() {
        if (this.sGroups == null) {
            this.sGroups = new LinkedHashMap<Object, Series>();
            for (Map.Entry<Object, SparseBitSet> v : this.groups) {
                try {
                    this.sGroups.put(v.getKey(), this.getGroup(v.getKey()));
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.sGroups.entrySet().iterator();
    }
}

