/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.mapdata;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.meteoinfo.data.mapdata.Field;
import org.meteoinfo.io.EndianDataOutputStream;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.table.DataColumn;
import org.meteoinfo.table.DataRow;
import org.meteoinfo.table.DataTable;

public final class AttributeTable
implements Cloneable {
    private int _numRecords;
    private LocalDateTime _updateDate;
    private int _headerLength;
    private int _recordLength;
    private int _numFields;
    private List<Field> _columns;
    private byte _fileType;
    private EndianDataOutputStream _writer;
    private File _file;
    private DataTable _dataTable;
    private final int FileDescriptorSize = 32;
    private boolean _attributesPopulated;
    private char[] _characterContent;
    private byte[] _byteContent;
    private long[] _offsets;
    private boolean _hasDeletedRecords;
    private boolean _loaded;
    private List<Integer> _deletedRows;
    private String encoding = "UTF-8";

    public AttributeTable() {
        this.configure();
    }

    public AttributeTable(String filename) throws FileNotFoundException, IOException, Exception {
        this._file = new File(filename);
        this.configure();
        File aFile = new File(filename);
        if (aFile.exists()) {
            this.open(filename);
        }
    }

    private void configure() {
        this._fileType = (byte)3;
        this._dataTable = new DataTable();
        this._columns = new ArrayList<Field>();
        this._attributesPopulated = true;
        this._deletedRows = new ArrayList<Integer>();
        this._characterContent = new char[1];
    }

    public File getFile() {
        return this._file;
    }

    public int getNumRecords() {
        return this._dataTable.getRows().size();
    }

    public DataTable getTable() {
        return this._dataTable;
    }

    public void setTable(DataTable table) {
        this._dataTable = table;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String value) {
        this.encoding = value;
    }

    public void updateDataTable() {
        for (DataColumn col : this._dataTable.getColumns()) {
            if (!col.getClass().equals(DataColumn.class)) continue;
            Field field = new Field(col);
        }
    }

    public void open(String filename) throws FileNotFoundException, IOException, Exception {
        String fileName = filename.replace(filename.substring(filename.lastIndexOf(".")), ".dbf");
        File file = new File(fileName);
        if (!file.exists()) {
            fileName = filename.replace(filename.substring(filename.lastIndexOf(".")), ".DBF");
        }
        this.openDBF(fileName);
    }

    public void openDBF(String fileName) throws FileNotFoundException, IOException, Exception {
        this._attributesPopulated = false;
        this._dataTable = new DataTable();
        this._file = new File(fileName);
        if (!this._file.exists()) {
            System.out.println("The dbf file for this shapefile was not found.");
            return;
        }
        DataInputStream myReader = new DataInputStream(new BufferedInputStream(new FileInputStream(this._file)));
        this.readTableHeader(myReader);
        myReader.close();
    }

    private void readTableHeader(DataInputStream reader) throws IOException, Exception {
        byte[] arr = new byte[12];
        reader.read(arr);
        ByteBuffer buffer = ByteBuffer.wrap(arr);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this._fileType = buffer.get();
        if (this._fileType != 3) {
            throw new Exception("Unsupported DBF reader Type " + this._fileType);
        }
        byte year = buffer.get();
        byte month = buffer.get();
        byte day = buffer.get();
        this._updateDate = LocalDateTime.of(year + 1900, month, (int)day, 0, 0);
        this._numRecords = buffer.getInt();
        this._headerLength = buffer.getShort();
        this._recordLength = buffer.getShort();
        reader.skipBytes(20);
        this._numFields = (this._headerLength - 32 - 1) / 32;
        this._columns = new ArrayList<Field>();
        for (int i = 0; i < this._numFields; ++i) {
            arr = new byte[18];
            reader.read(arr);
            buffer = ByteBuffer.wrap(arr);
            byte[] bytes = new byte[11];
            buffer.get(bytes);
            String name = new String(bytes, this.encoding);
            int nullPoint = name.indexOf(0);
            if (nullPoint != -1) {
                name = name.substring(0, nullPoint);
            }
            char Code = (char)buffer.get();
            int dataAddress = buffer.getInt();
            int tempLength = buffer.get() & 0xFF;
            byte decimalcount = buffer.get();
            reader.skipBytes(14);
            int j = 1;
            String tempName = name;
            while (this._dataTable.getColumnNames().contains(tempName)) {
                tempName = name + j;
                ++j;
            }
            name = tempName;
            Field myField = new Field(name, Code, tempLength, (int)decimalcount);
            this._columns.add(myField);
            this._dataTable.getColumns().add(myField);
        }
        reader.readByte();
    }

    private void load() throws FileNotFoundException, IOException {
        RandomAccessFile rafo = new RandomAccessFile(this._file, "r");
        rafo.seek(this._headerLength + 1);
        if ((int)rafo.length() == this._headerLength) {
            return;
        }
        int length = (int)rafo.length() - this._headerLength - 1;
        this._byteContent = new byte[length];
        rafo.read(this._byteContent);
        rafo.close();
        if (this._hasDeletedRecords) {
            int recordCount = length / this._recordLength;
            this._offsets = new long[this._numRecords];
            int j = 0;
            for (int i = 0; i <= recordCount; ++i) {
                if ((char)this._byteContent[i * this._recordLength] != '*') {
                    this._offsets[j] = i * this._recordLength;
                }
                if (++j == this._numRecords) break;
            }
        }
        this._loaded = true;
    }

    public void fill(int numRows) throws FileNotFoundException, IOException, Exception {
        if (!this._loaded) {
            this.load();
        }
        this._dataTable.getRows().clear();
        if (!this._file.exists()) {
            this._numRecords = numRows;
            this._dataTable.addColumn("FID", DataType.INT);
            for (int row = 0; row < numRows; ++row) {
                DataRow dr = this._dataTable.newRow();
                dr.setValue("FID", (Object)row);
                this._dataTable.addRow(dr);
            }
            return;
        }
        for (int row = 0; row < this._numRecords; ++row) {
            try {
                this._dataTable.addRow(this.readTableRowFromBytes(row));
                continue;
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                this._dataTable.addRow(this._dataTable.newRow());
            }
        }
        this._attributesPopulated = true;
    }

    private DataRow readTableRowFromBytes(int currentRow) throws Exception {
        DataRow result = this._dataTable.newRow();
        long start = !this._hasDeletedRecords ? (long)(currentRow * this._recordLength) : this._offsets[currentRow];
        for (int col = 0; col < this._dataTable.getColumns().size(); ++col) {
            Field CurrentField = this._columns.get(col);
            char tempFieldType = CurrentField.getTypeCharacter();
            byte[] cBuffer = Arrays.copyOfRange(this._byteContent, (int)start, (int)start + CurrentField.getLength());
            start += (long)CurrentField.getLength();
            Object tempObject = null;
            switch (tempFieldType) {
                case 'L': {
                    char tempChar = (char)cBuffer[0];
                    if (tempChar == 'T' || tempChar == 't' || tempChar == 'Y' || tempChar == 'y') {
                        tempObject = true;
                        break;
                    }
                    tempObject = false;
                    break;
                }
                case 'C': {
                    tempObject = new String(cBuffer, this.encoding).trim();
                    break;
                }
                case 'T': {
                    throw new Exception();
                }
                case 'D': {
                    byte[] dBuffer = Arrays.copyOfRange(cBuffer, 0, 4);
                    String tempString = new String(dBuffer);
                    int year = Integer.parseInt(tempString);
                    dBuffer = Arrays.copyOfRange(cBuffer, 4, 6);
                    tempString = new String(dBuffer);
                    int month = Integer.parseInt(tempString);
                    dBuffer = Arrays.copyOfRange(cBuffer, 6, 8);
                    tempString = new String(dBuffer);
                    int day = Integer.parseInt(tempString);
                    tempObject = LocalDateTime.of(year, month, day, 0, 0);
                    break;
                }
                case 'B': 
                case 'F': 
                case 'N': {
                    String tempStr = new String(cBuffer);
                    if (tempStr.trim().equals("null")) break;
                    if (tempStr.trim().isEmpty()) {
                        tempStr = "0";
                    }
                    DataType t = CurrentField.getDataType();
                    switch (t) {
                        case INT: {
                            tempObject = Integer.parseInt(tempStr.trim());
                            break;
                        }
                        case FLOAT: {
                            tempObject = Float.valueOf(Float.parseFloat(tempStr));
                            break;
                        }
                        case DOUBLE: {
                            tempObject = Double.parseDouble(tempStr);
                        }
                    }
                    break;
                }
                default: {
                    throw new Exception("Do not know how to parse Field type " + tempFieldType);
                }
            }
            result.setValue(CurrentField.getColumnName(), tempObject);
        }
        return result;
    }

    public void save() {
        try {
            this.updateSchema();
            this._writer = new EndianDataOutputStream(new BufferedOutputStream(new FileOutputStream(this._file)));
            this.writeHeader(this._writer);
            this.writeTable();
            this._writer.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(AttributeTable.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(AttributeTable.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void save(String fileName) {
        try {
            this.updateSchema();
            this._writer = new EndianDataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
            this.writeHeader(this._writer);
            this.writeTable();
            this._writer.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(AttributeTable.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(AttributeTable.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void saveAs(String fileName, boolean overwrite) {
        if (this._file == null) {
            this._file = new File(fileName);
            this.save();
        } else {
            if (this._file.getAbsoluteFile().equals(fileName)) {
                this.save();
                return;
            }
            if (new File(fileName).exists() && !overwrite && JOptionPane.showConfirmDialog(null, "The file " + fileName + " already exists.  Do you wish to overwrite it?", "File Exists", 0) == 1) {
                return;
            }
            this.save(fileName);
        }
    }

    private void updateSchema() {
        ArrayList<Field> tempColumns = new ArrayList<Field>();
        this._recordLength = 1;
        this._numRecords = this._dataTable.getRows().size();
        this._updateDate = LocalDateTime.now();
        this._headerLength = 32 + 32 * this._dataTable.getColumns().size() + 1;
        if (this._columns == null) {
            this._columns = new ArrayList<Field>();
        }
        ArrayList<Field> removeFields = new ArrayList<Field>();
        for (Field fld : this._columns) {
            if (!this._dataTable.getColumnNames().contains(fld.getColumnName())) {
                removeFields.add(fld);
                continue;
            }
            tempColumns.add(fld);
        }
        for (Field field : removeFields) {
            this._columns.remove(field);
        }
        if (this._dataTable.getColumns() != null) {
            for (DataColumn dc : this._dataTable.getColumns()) {
                if (this.columnNameExists(dc.getColumnName())) continue;
                Field fld = new Field(dc);
                tempColumns.add(fld);
            }
        }
        this._columns = tempColumns;
        for (Field fld : this._columns) {
            this._recordLength += fld.getLength();
        }
    }

    private boolean columnNameExists(String name) {
        for (Field fld : this._columns) {
            if (!fld.getColumnName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void writeHeader(EndianDataOutputStream writer) throws IOException {
        writer.writeByteLE(this._fileType);
        LocalDateTime trialTime = LocalDateTime.now();
        writer.writeByteLE(trialTime.getYear() - 1900);
        writer.writeByteLE(trialTime.getMonthValue());
        writer.writeByteLE(trialTime.getDayOfMonth());
        writer.writeIntLE(this._numRecords);
        writer.writeShortLE((short)this._headerLength);
        writer.writeShortLE((short)this._recordLength);
        for (int i = 0; i < 20; ++i) {
            writer.writeByteLE(0);
        }
        for (int i = 0; i < this._columns.size(); ++i) {
            int j;
            Field currentField = this._columns.get(i);
            byte[] bytes = currentField.getColumnName().getBytes(this.encoding);
            for (j = 0; j < 11; ++j) {
                if (bytes.length > j) {
                    writer.writeByteLE(bytes[j]);
                    continue;
                }
                writer.writeByteLE(0);
            }
            writer.writeByteLE(currentField.getTypeCharacter());
            writer.writeIntLE(0);
            writer.writeByteLE(currentField.getLength());
            writer.writeByteLE(currentField.getDecimalCount());
            for (j = 0; j < 14; ++j) {
                writer.writeByteLE(0);
            }
        }
        writer.writeByteLE(13);
    }

    public void writeTable() throws IOException {
        if (this._dataTable == null) {
            return;
        }
        for (int row = 0; row < this._dataTable.getRows().size(); ++row) {
            this._writer.writeByteLE(32);
            block8: for (int fld = 0; fld < this._columns.size(); ++fld) {
                Field currentField = this._columns.get(fld);
                String name = currentField.getColumnName();
                Object columnValue = ((DataRow)this._dataTable.getRows().get(row)).getValue(name);
                switch (currentField.getTypeCharacter()) {
                    case 'C': 
                    case 'G': 
                    case 'M': 
                    case 'c': {
                        String ss = (String)columnValue;
                        while (ss.length() < currentField.getLength()) {
                            ss = ss + "                                                                                                                  ";
                        }
                        StringBuffer tmps = new StringBuffer(ss);
                        tmps.setLength(currentField.getLength());
                        this._writer.write(tmps.toString().getBytes(this.encoding), 0, currentField.getLength());
                        continue block8;
                    }
                    case 'D': {
                        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMdd");
                        String ds = format.format((LocalDateTime)columnValue);
                        this._writer.write(ds.getBytes(), 0, ds.length());
                        continue block8;
                    }
                    case 'N': 
                    case 'n': {
                        String fs = currentField.getDataType() == DataType.INT ? String.format("%1$" + String.valueOf(currentField.getLength()) + "d", columnValue) : String.format("%1$" + String.valueOf(currentField.getLength()) + "." + String.valueOf(currentField.getDecimalCount()) + "f", columnValue);
                        if (fs.length() > currentField.getLength()) {
                            fs = fs.substring(0, currentField.getLength());
                        }
                        this._writer.writeBytesLE(fs);
                        continue block8;
                    }
                    case 'F': 
                    case 'f': {
                        String x = String.format("%1$" + String.valueOf(currentField.getLength()) + "." + String.valueOf(currentField.getDecimalCount()) + "f", columnValue);
                        this._writer.writeBytesLE(x);
                        continue block8;
                    }
                    case 'L': {
                        if (columnValue == null || columnValue.equals("") || columnValue.equals(" ")) {
                            this._writer.writeBytesLE(" ");
                            continue block8;
                        }
                        boolean b = (Boolean)columnValue;
                        this._writer.writeBytesLE(b ? "T" : "F");
                    }
                }
            }
        }
    }

    public Object clone() {
        AttributeTable newAT = new AttributeTable();
        newAT.setTable((DataTable)this._dataTable.clone());
        return newAT;
    }
}

