/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.mapdata.webmap;

import java.awt.EventQueue;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.lang.ref.SoftReference;
import javax.swing.SwingUtilities;
import org.meteoinfo.beans.AbstractBean;
import org.meteoinfo.data.mapdata.webmap.TileFactory;

public class Tile
extends AbstractBean {
    private Priority priority = Priority.High;
    private boolean isLoading = false;
    private Throwable error;
    private String url;
    private boolean loaded = false;
    private int zoom;
    private int x;
    private int y;
    SoftReference<BufferedImage> image = new SoftReference<Object>(null);
    private PropertyChangeListener uniqueListener = null;
    private TileFactory dtf;

    public Tile(int x, int y, int zoom) {
        this.loaded = false;
        this.zoom = zoom;
        this.x = x;
        this.y = y;
    }

    Tile(int x, int y, int zoom, String url, Priority priority, TileFactory dtf) {
        this.url = url;
        this.loaded = false;
        this.zoom = zoom;
        this.x = x;
        this.y = y;
        this.priority = priority;
        this.dtf = dtf;
    }

    public synchronized boolean isLoaded() {
        return this.loaded;
    }

    synchronized void setLoaded(boolean loaded) {
        boolean old = this.isLoaded();
        this.loaded = loaded;
        this.firePropertyChange("loaded", old, this.isLoaded());
    }

    public Throwable getUnrecoverableError() {
        return this.error;
    }

    public Throwable getLoadingError() {
        return this.error;
    }

    public BufferedImage getImage() {
        BufferedImage img = this.image.get();
        if (img == null) {
            this.setLoaded(false);
            this.dtf.startLoading(this);
        }
        return img;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void addUniquePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.uniqueListener != null && this.uniqueListener != listener) {
            this.removePropertyChangeListener(propertyName, this.uniqueListener);
        }
        if (this.uniqueListener != listener) {
            this.uniqueListener = listener;
            this.addPropertyChangeListener(propertyName, this.uniqueListener);
        }
    }

    void firePropertyChangeOnEDT(final String propertyName, final Object oldValue, final Object newValue) {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Tile.this.firePropertyChange(propertyName, oldValue, newValue);
                }
            });
        }
    }

    private static void p(String string) {
        System.out.println(string);
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public void setLoading(boolean isLoading) {
        this.isLoading = isLoading;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public String getURL() {
        return this.url;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public static enum Priority {
        High,
        Low;

    }
}

