/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.arl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.locationtech.proj4j.proj.Projection;
import org.meteoinfo.bak.ArrayMath;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IGridDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.arl.DataHead;
import org.meteoinfo.data.meteodata.arl.DataLabel;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.util.BigDecimalUtil;
import org.meteoinfo.global.util.GlobalUtil;
import org.meteoinfo.global.util.JDateUtil;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Dimension;
import org.meteoinfo.ndarray.DimensionType;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.Section;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.Reproject;
import org.meteoinfo.projection.info.ProjectionInfo;

public class ARLDataInfo
extends DataInfo
implements IGridDataInfo {
    public Boolean isLatLon = false;
    public DataHead dataHead;
    public long recLen;
    private long indexLen;
    public int recsPerTime;
    public List<List<String>> LevelVarList = new ArrayList<List<String>>();
    public int levelNum = 0;
    public List<Double> levels = new ArrayList<Double>();
    public double missingValue = -9999.0;
    public double[] X;
    public double[] Y;
    public boolean isGlobal = false;
    private RandomAccessFile _bw = null;
    private long indexRecPos = 0L;

    public ARLDataInfo() {
        this.setDataType(MeteoDataType.ARL_Grid);
    }

    public void setX(List<Number> value) {
        this.X = new double[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            this.X[i] = value.get(i).doubleValue();
        }
    }

    public void setY(List<Number> value) {
        this.Y = new double[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            this.Y[i] = value.get(i).doubleValue();
        }
    }

    public boolean isLargeGrid() {
        return this.X.length >= 1000 || this.Y.length >= 1000;
    }

    public static boolean canOpen(String fileName) {
        try {
            RandomAccessFile br = new RandomAccessFile(fileName, "r");
            DataLabel dl = ARLDataInfo.readDataLabel(br);
            br.close();
            LocalDateTime t = dl.getTimeValue();
            return t != null;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        catch (IOException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @Override
    public void readDataInfo(String fileName) {
        this.setFileName(fileName);
        try {
            String vName;
            int j;
            int vNum;
            int i;
            RandomAccessFile br = new RandomAccessFile(fileName, "r");
            DataHead aDH = new DataHead();
            ArrayList<String> vList = new ArrayList<String>();
            DataLabel aDL = ARLDataInfo.readDataLabel(br);
            byte[] bytes = new byte[4];
            br.read(bytes);
            aDH.MODEL = new String(bytes).trim();
            bytes = new byte[3];
            br.read(bytes);
            aDH.ICX = Integer.parseInt(new String(bytes).trim());
            bytes = new byte[2];
            br.read(bytes);
            aDH.MN = Short.parseShort(new String(bytes).trim());
            bytes = new byte[7];
            br.read(bytes);
            aDH.POLE_LAT = Float.parseFloat(new String(bytes).trim());
            br.read(bytes);
            aDH.POLE_LON = Float.parseFloat(new String(bytes).trim());
            br.read(bytes);
            aDH.REF_LAT = Float.parseFloat(new String(bytes).trim());
            br.read(bytes);
            aDH.REF_LON = Float.parseFloat(new String(bytes).trim());
            br.read(bytes);
            aDH.SIZE = Float.parseFloat(new String(bytes).trim());
            br.read(bytes);
            aDH.ORIENT = Float.parseFloat(new String(bytes).trim());
            br.read(bytes);
            aDH.TANG_LAT = Float.parseFloat(new String(bytes).trim());
            br.read(bytes);
            aDH.SYNC_XP = Float.parseFloat(new String(bytes).trim());
            br.read(bytes);
            aDH.SYNC_YP = Float.parseFloat(new String(bytes).trim());
            br.read(bytes);
            aDH.SYNC_LAT = Float.parseFloat(new String(bytes).trim());
            br.read(bytes);
            aDH.SYNC_LON = Float.parseFloat(new String(bytes).trim());
            br.read(bytes);
            aDH.DUMMY = Float.parseFloat(new String(bytes).trim());
            bytes = new byte[3];
            br.read(bytes);
            aDH.NX = Integer.parseInt(new String(bytes).trim());
            br.read(bytes);
            aDH.NY = Integer.parseInt(new String(bytes).trim());
            br.read(bytes);
            aDH.NZ = Integer.parseInt(new String(bytes).trim());
            bytes = new byte[2];
            br.read(bytes);
            aDH.K_FLAG = Short.parseShort(new String(bytes).trim());
            bytes = new byte[4];
            br.read(bytes);
            aDH.LENH = Integer.parseInt(new String(bytes).trim());
            if (aDL.XGPT) {
                int xn = aDL.IGC.charAt(0) - 64;
                int yn = aDL.IGC.charAt(1) - 64;
                aDH.NX += xn * 1000;
                aDH.NY += yn * 1000;
            }
            int NXY = aDH.NX * aDH.NY;
            int LEN = NXY + 50;
            this.recLen = LEN;
            int indexRecNum = 1;
            this.indexLen = this.recLen;
            if (aDH.LENH > NXY) {
                bytes = new byte[NXY - 108];
                br.read(bytes);
                ArrayList<Byte> byteList = new ArrayList<Byte>();
                for (byte b : bytes) {
                    byteList.add(b);
                }
                for (i = 0; i < 100 && (aDL = ARLDataInfo.readDataLabel(br)).getVarName().equalsIgnoreCase("INDX"); ++i) {
                    bytes = new byte[NXY];
                    br.read(bytes);
                    for (byte b : bytes) {
                        byteList.add(b);
                    }
                }
                indexRecNum = i + 1;
                this.indexLen += (long)i * this.recLen;
                bytes = new byte[byteList.size()];
                for (i = 0; i < byteList.size(); ++i) {
                    bytes[i] = (Byte)byteList.get(i);
                }
                int idx = 0;
                for (i = 0; i < aDH.NZ; ++i) {
                    int n = 6;
                    byte[] nbytes = Arrays.copyOfRange(bytes, idx, idx + n);
                    idx += n;
                    String lstr = new String(nbytes);
                    this.levels.add(Double.parseDouble(lstr.trim()));
                    n = 2;
                    nbytes = Arrays.copyOfRange(bytes, idx, idx + n);
                    vNum = Integer.parseInt(new String(nbytes).trim());
                    idx += n;
                    for (j = 0; j < vNum; ++j) {
                        n = 4;
                        nbytes = Arrays.copyOfRange(bytes, idx, idx + n);
                        idx += n;
                        vName = new String(nbytes).trim();
                        vList.add(vName);
                        idx += 4;
                    }
                    this.LevelVarList.add(new ArrayList(vList));
                    vList.clear();
                }
            } else {
                for (i = 0; i < aDH.NZ; ++i) {
                    bytes = new byte[6];
                    br.read(bytes);
                    String lstr = new String(bytes);
                    this.levels.add(Double.parseDouble(lstr.trim()));
                    bytes = new byte[2];
                    br.read(bytes);
                    vNum = Integer.parseInt(new String(bytes).trim());
                    bytes = new byte[4];
                    for (j = 0; j < vNum; ++j) {
                        br.read(bytes);
                        vName = new String(bytes).trim();
                        vList.add(vName);
                        br.read(bytes);
                    }
                    this.LevelVarList.add(new ArrayList(vList));
                    vList.clear();
                }
            }
            this.levelNum = aDH.NZ;
            this.dataHead = aDH;
            if (aDH.SIZE == 0.0f) {
                this.isLatLon = true;
                this.X = new double[aDH.NX];
                this.Y = new double[aDH.NY];
                double xmin = BigDecimalUtil.toDouble(aDH.SYNC_LON);
                double xdelta = BigDecimalUtil.toDouble(aDH.REF_LON);
                this.X[0] = xmin;
                for (i = 1; i < aDH.NX; ++i) {
                    this.X[i] = BigDecimalUtil.add(this.X[i - 1], xdelta);
                }
                if (this.X[aDH.NX - 1] + (double)aDH.REF_LON - this.X[0] == 360.0) {
                    this.isGlobal = true;
                }
                double ymin = BigDecimalUtil.toDouble(aDH.SYNC_LAT);
                double ydelta = BigDecimalUtil.toDouble(aDH.REF_LAT);
                this.Y[0] = ymin;
                for (i = 1; i < aDH.NY; ++i) {
                    this.Y[i] = BigDecimalUtil.add(this.Y[i - 1], ydelta);
                }
            } else {
                this.isLatLon = false;
                String ProjStr = aDH.POLE_LAT == 90.0f || aDH.POLE_LAT == -90.0f ? (aDH.TANG_LAT == 90.0f || aDH.TANG_LAT == -90.0f ? "+proj=stere+lat_ts=" + String.valueOf(aDH.REF_LAT) + "+lat_0=" + String.valueOf(aDH.TANG_LAT) + "+lon_0=" + String.valueOf(aDH.REF_LON + aDH.ORIENT) : (aDH.TANG_LAT == 0.0f ? "+proj=merc+lon_0=" + String.valueOf(aDH.REF_LON + aDH.ORIENT) : "+proj=lcc+lat_0=" + String.valueOf(aDH.REF_LAT) + "+lat_1=" + String.valueOf(aDH.TANG_LAT) + "+lat_2=" + String.valueOf(aDH.TANG_LAT) + "+lon_0=" + String.valueOf(aDH.REF_LON + aDH.ORIENT))) : (aDH.TANG_LAT == 0.0f ? "+proj=tmerc+lat_0=" + String.valueOf(aDH.POLE_LAT) + "+lon_0=" + String.valueOf(aDH.REF_LON + aDH.ORIENT) : "+proj=lcc+lat_0=" + String.valueOf(aDH.REF_LAT) + "+lat_1=" + String.valueOf(aDH.TANG_LAT) + "+lat_2=" + String.valueOf(aDH.TANG_LAT) + "+lon_0=" + String.valueOf(aDH.REF_LON + aDH.ORIENT));
                ProjectionInfo theProj = ProjectionInfo.factory(ProjStr);
                this.setProjectionInfo(theProj);
                this.X = new double[aDH.NX];
                this.Y = new double[aDH.NY];
                this.getProjectedXY(theProj, aDH.SIZE * 1000.0f, aDH.SYNC_XP, aDH.SYNC_YP, aDH.SYNC_LON, aDH.SYNC_LAT, this.X, this.Y);
            }
            Dimension xDim = new Dimension(DimensionType.X);
            xDim.setValues(this.X);
            this.setXDimension(xDim);
            this.addDimension(xDim);
            Dimension yDim = new Dimension(DimensionType.Y);
            yDim.setValues(this.Y);
            this.setYDimension(yDim);
            this.addDimension(yDim);
            byte[] dataBytes = new byte[NXY];
            br.seek(0L);
            int recNum = 0;
            int timeNum = 0;
            int year = aDL.getYear();
            year = year < 50 ? 2000 + year : 1900 + year;
            LocalDateTime oldTime = LocalDateTime.of(year, aDL.getMonth(), aDL.getDay(), aDL.getHour(), 0, 0);
            ArrayList<LocalDateTime> times = new ArrayList<LocalDateTime>();
            times.add(oldTime);
            while (br.getFilePointer() < br.length() - 1L) {
                aDL = ARLDataInfo.readDataLabel(br);
                br.read(dataBytes);
                if (aDL.getVarName().equalsIgnoreCase("INDX")) continue;
                LocalDateTime aTime = LocalDateTime.of(year, aDL.getMonth(), aDL.getDay(), aDL.getHour(), 0, 0);
                if (!aTime.equals(oldTime)) {
                    times.add(aTime);
                    oldTime = aTime;
                    ++timeNum;
                }
                if (timeNum != 0) continue;
                ++recNum;
            }
            br.close();
            ArrayList<Double> values = new ArrayList<Double>();
            for (LocalDateTime t : times) {
                values.add(JDateUtil.toOADate(t));
            }
            Dimension tDim = new Dimension(DimensionType.T);
            tDim.setValues(values);
            this.setTimeDimension(tDim);
            this.addDimension(tDim);
            this.recsPerTime = recNum + indexRecNum;
            vList.clear();
            ArrayList<Variable> variables = new ArrayList<Variable>();
            for (i = 0; i < this.LevelVarList.size(); ++i) {
                for (j = 0; j < this.LevelVarList.get(i).size(); ++j) {
                    Variable aVar;
                    vName = this.LevelVarList.get(i).get(j);
                    if (!vList.contains(vName)) {
                        vList.add(vName);
                        aVar = new Variable();
                        aVar.setName(vName);
                        aVar.setDataType(DataType.FLOAT);
                        aVar.addAttribute("long_name", vName);
                        aVar.getLevels().add(this.levels.get(i));
                        aVar.getLevelIdxs().add(i);
                        aVar.getVarInLevelIdxs().add(j);
                        variables.add(aVar);
                        continue;
                    }
                    int varIdx = vList.indexOf(vName);
                    aVar = (Variable)variables.get(varIdx);
                    aVar.getLevels().add(this.levels.get(i));
                    aVar.getLevelIdxs().add(i);
                    aVar.getVarInLevelIdxs().add(j);
                }
            }
            ArrayList<Dimension> zdims = new ArrayList<Dimension>();
            for (Variable var : variables) {
                var.setDimension(this.getTimeDimension());
                int len = var.getLevels().size();
                if (len > 1) {
                    Dimension zDim = null;
                    for (Dimension dim : zdims) {
                        if (dim.getLength() != len) continue;
                        zDim = dim;
                        break;
                    }
                    if (zDim == null) {
                        zDim = new Dimension(DimensionType.Z);
                        zDim.setName("Z_" + String.valueOf(len));
                        zDim.setValues(var.getLevels());
                        zdims.add(zDim);
                        this.addDimension(zDim);
                    }
                    var.setDimension(zDim);
                }
                var.setDimension(this.getYDimension());
                var.setDimension(this.getXDimension());
            }
            this.setTimes(times);
            this.setVariables(variables);
        }
        catch (IOException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static DataLabel readDataLabel(RandomAccessFile br) {
        try {
            DataLabel aDL = new DataLabel();
            byte[] bytes = new byte[2];
            br.read(bytes);
            aDL.setYear(Short.parseShort(new String(bytes).trim()));
            br.read(bytes);
            aDL.setMonth(Short.parseShort(new String(bytes).trim()));
            br.read(bytes);
            aDL.setDay(Short.parseShort(new String(bytes).trim()));
            br.read(bytes);
            aDL.setHour(Short.parseShort(new String(bytes).trim()));
            br.read(bytes);
            aDL.setForecast(Short.parseShort(new String(bytes).trim()));
            br.read(bytes);
            aDL.setLevel(Short.parseShort(new String(bytes).trim()));
            br.read(bytes);
            String gridStr = new String(bytes).trim();
            if (MIMath.isNumeric(gridStr)) {
                aDL.setGrid(Short.parseShort(gridStr));
            } else {
                aDL.XGPT = true;
                aDL.IGC = gridStr;
            }
            bytes = new byte[4];
            br.read(bytes);
            aDL.setVarName(new String(bytes).trim());
            br.read(bytes);
            aDL.setExponent(Integer.parseInt(new String(bytes).trim()));
            bytes = new byte[14];
            br.read(bytes);
            aDL.setPrecision(Double.parseDouble(new String(bytes).trim()));
            br.read(bytes);
            aDL.setValue(Double.parseDouble(new String(bytes).trim()));
            return aDL;
        }
        catch (IOException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private void getProjectedXY(ProjectionInfo projInfo, float size, float sync_XP, float sync_YP, float sync_Lon, float sync_Lat, double[] X, double[] Y) {
        int i;
        ProjectionInfo fromProj = KnownCoordinateSystems.geographic.world.WGS1984;
        double[][] points = new double[][]{{new BigDecimal(String.valueOf(sync_Lon)).doubleValue(), new BigDecimal(String.valueOf(sync_Lat)).doubleValue()}};
        Reproject.reprojectPoints(points, fromProj, projInfo, 0, 1);
        double sync_X = points[0][0];
        double sync_Y = points[0][1];
        int i_XP = (int)sync_XP;
        double i_X = sync_XP == (float)i_XP ? sync_X : sync_X - (double)((sync_XP - (float)i_XP) * size);
        int i_YP = (int)sync_YP;
        double i_Y = sync_YP == (float)i_YP ? sync_Y : sync_Y - (double)((sync_YP - (float)i_YP) * size);
        int nx = X.length;
        int ny = Y.length;
        double xlb = i_X - (double)((float)(i_XP - 1) * size);
        double ylb = i_Y - (double)((float)(i_YP - 1) * size);
        for (i = 0; i < nx; ++i) {
            X[i] = xlb + (double)((float)i * size);
        }
        for (i = 0; i < ny; ++i) {
            Y[i] = ylb + (double)((float)i * size);
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    private double[][] unpackARLGridData(byte[] dataBytes, int xNum, int yNum, DataLabel aDL) {
        double[][] gridData = new double[yNum][xNum];
        double SCALE = Math.pow(2.0, 7 - aDL.getExponent());
        double VOLD = aDL.getValue();
        int INDX = 0;
        for (int j = 0; j < yNum; ++j) {
            for (int i = 0; i < xNum; ++i) {
                gridData[j][i] = (double)(DataConvert.byte2Int(dataBytes[INDX]) - 127) / SCALE + VOLD;
                ++INDX;
                VOLD = gridData[j][i];
            }
            VOLD = gridData[j][0];
        }
        return gridData;
    }

    private float[] unpackARLData(byte[] dataBytes, int xNum, int yNum, DataLabel aDL) {
        float VOLD;
        int n = dataBytes.length;
        float[] data = new float[n];
        float SCALE = (float)Math.pow(2.0, 7 - aDL.getExponent());
        float init = VOLD = (float)aDL.getValue();
        int INDX = 0;
        for (int j = 0; j < yNum; ++j) {
            for (int i = 0; i < xNum; ++i) {
                float v;
                data[INDX] = v = (float)(DataConvert.byte2Int(dataBytes[INDX]) - 127) / SCALE + VOLD;
                if (i == 0) {
                    init = v;
                }
                ++INDX;
                VOLD = v;
            }
            VOLD = init;
        }
        return data;
    }

    @Override
    public Array read(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.read(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        try {
            Variable var = this.getVariable(varName);
            Section section = new Section(origin, size, stride);
            Array dataArray = Array.factory(DataType.FLOAT, section.getShape());
            int rangeIdx = 0;
            Range timeRange = section.getRank() > 2 ? section.getRange(rangeIdx++) : new Range(0, 0);
            Range levRange = var.getLevelNum() > 0 ? section.getRange(rangeIdx++) : new Range(0, 0);
            Range yRange = section.getRange(rangeIdx++);
            Range xRange = section.getRange(rangeIdx);
            IndexIterator ii = dataArray.getIndexIterator();
            for (int timeIdx = timeRange.first(); timeIdx <= timeRange.last(); timeIdx += timeRange.stride()) {
                for (int levelIdx = levRange.first(); levelIdx <= levRange.last(); levelIdx += levRange.stride()) {
                    this.readXY(varName, timeIdx, levelIdx, yRange, xRange, ii);
                }
            }
            return dataArray;
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private void readXY(String varName, int timeIdx, int levelIdx, Range yRange, Range xRange, IndexIterator ii) {
        try {
            int varIdx = this.getVariableNames().indexOf(varName);
            int xNum = this.dataHead.NX;
            int yNum = this.dataHead.NY;
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            Variable aVar = this.getVariables().get(varIdx);
            if (aVar.getLevelNum() > 1) {
                ++levelIdx;
            }
            varIdx = this.LevelVarList.get(levelIdx).indexOf(aVar.getName());
            br.seek((long)(timeIdx * this.recsPerTime) * this.recLen);
            br.seek(br.getFilePointer() + this.indexLen);
            for (int i = 0; i < levelIdx; ++i) {
                br.seek(br.getFilePointer() + (long)this.LevelVarList.get(i).size() * this.recLen);
            }
            br.seek(br.getFilePointer() + (long)varIdx * this.recLen);
            DataLabel aDL = ARLDataInfo.readDataLabel(br);
            byte[] dataBytes = new byte[(int)this.recLen - 50];
            br.read(dataBytes);
            br.close();
            float[] data = this.unpackARLData(dataBytes, xNum, yNum, aDL);
            for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
                for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                    int index = y * xNum + x;
                    ii.setFloatNext(data[index]);
                }
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public GridArray getGridArray(String varName) {
        return null;
    }

    @Override
    public GridData getGridData_LonLat(int timeIdx, int varIdx, int levelIdx) {
        try {
            int xNum = this.dataHead.NX;
            int yNum = this.dataHead.NY;
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            Variable aVar = this.getVariables().get(varIdx);
            if (aVar.getLevelNum() > 1) {
                ++levelIdx;
            }
            varIdx = this.LevelVarList.get(levelIdx).indexOf(aVar.getName());
            br.seek((long)(timeIdx * this.recsPerTime) * this.recLen);
            br.seek(br.getFilePointer() + this.indexLen);
            for (int i = 0; i < levelIdx; ++i) {
                br.seek(br.getFilePointer() + (long)this.LevelVarList.get(i).size() * this.recLen);
            }
            br.seek(br.getFilePointer() + (long)varIdx * this.recLen);
            DataLabel aDL = ARLDataInfo.readDataLabel(br);
            byte[] dataBytes = new byte[(int)this.recLen - 50];
            br.read(dataBytes);
            br.close();
            double[][] theData = this.unpackARLGridData(dataBytes, xNum, yNum, aDL);
            GridData gridData = new GridData();
            gridData.data = theData;
            gridData.missingValue = this.missingValue;
            gridData.xArray = this.X;
            gridData.yArray = this.Y;
            return gridData;
        }
        catch (IOException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_TimeLat(int lonIdx, int varIdx, int levelIdx) {
        try {
            int xNum = this.dataHead.NX;
            int yNum = this.dataHead.NY;
            int tNum = this.getTimeNum();
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            double[][] newGridData = new double[tNum][yNum];
            Variable aVar = this.getVariables().get(varIdx);
            if (aVar.getLevelNum() > 1) {
                ++levelIdx;
            }
            varIdx = this.LevelVarList.get(levelIdx).indexOf(aVar.getName());
            for (int t = 0; t < tNum; ++t) {
                int i;
                br.seek((long)(t * this.recsPerTime) * this.recLen);
                br.seek(br.getFilePointer() + this.indexLen);
                for (i = 0; i < levelIdx; ++i) {
                    br.seek(br.getFilePointer() + (long)this.LevelVarList.get(i).size() * this.recLen);
                }
                br.seek(br.getFilePointer() + (long)varIdx * this.recLen);
                DataLabel aDL = ARLDataInfo.readDataLabel(br);
                byte[] dataBytes = new byte[(int)this.recLen - 50];
                br.read(dataBytes);
                double[][] theData = this.unpackARLGridData(dataBytes, xNum, yNum, aDL);
                for (i = 0; i < yNum; ++i) {
                    newGridData[t][i] = theData[i][lonIdx];
                }
            }
            br.close();
            GridData gridData = new GridData();
            gridData.data = newGridData;
            gridData.missingValue = this.missingValue;
            gridData.xArray = this.Y;
            gridData.yArray = new double[tNum];
            for (int i = 0; i < tNum; ++i) {
                gridData.yArray[i] = JDateUtil.toOADate(this.getTimes().get(i));
            }
            return gridData;
        }
        catch (IOException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_TimeLon(int latIdx, int varIdx, int levelIdx) {
        try {
            int xNum = this.dataHead.NX;
            int yNum = this.dataHead.NY;
            int tNum = this.getTimeNum();
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            double[][] newGridData = new double[tNum][xNum];
            Variable aVar = this.getVariables().get(varIdx);
            if (aVar.getLevelNum() > 1) {
                ++levelIdx;
            }
            varIdx = this.LevelVarList.get(levelIdx).indexOf(aVar.getName());
            for (int t = 0; t < tNum; ++t) {
                br.seek((long)(t * this.recsPerTime) * this.recLen);
                br.seek(br.getFilePointer() + this.indexLen);
                for (int i = 0; i < levelIdx; ++i) {
                    br.seek(br.getFilePointer() + (long)this.LevelVarList.get(i).size() * this.recLen);
                }
                br.seek(br.getFilePointer() + (long)varIdx * this.recLen);
                DataLabel aDL = ARLDataInfo.readDataLabel(br);
                byte[] dataBytes = new byte[(int)this.recLen - 50];
                br.read(dataBytes);
                double[][] theData = this.unpackARLGridData(dataBytes, xNum, yNum, aDL);
                for (int j = 0; j < xNum; ++j) {
                    newGridData[t][j] = theData[latIdx][j];
                }
            }
            br.close();
            GridData gridData = new GridData();
            gridData.data = newGridData;
            gridData.missingValue = this.missingValue;
            gridData.xArray = this.X;
            gridData.yArray = new double[tNum];
            for (int i = 0; i < tNum; ++i) {
                gridData.yArray[i] = JDateUtil.toOADate(this.getTimes().get(i));
            }
            return gridData;
        }
        catch (IOException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_LevelLat(int lonIdx, int varIdx, int timeIdx) {
        try {
            int xNum = this.dataHead.NX;
            int yNum = this.dataHead.NY;
            int lNum = this.getVariables().get(varIdx).getLevelNum();
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            double[][] newGridData = new double[lNum][yNum];
            br.seek((long)(timeIdx * this.recsPerTime) * this.recLen);
            br.seek(br.getFilePointer() + this.indexLen);
            long aLevPosition = br.getFilePointer();
            for (int i = 0; i < lNum; ++i) {
                int j;
                int nvarIdx = this.getVariables().get(varIdx).getVarInLevelIdxs().get(i);
                int levIdx = this.getVariables().get(varIdx).getLevelIdxs().get(i);
                br.seek(aLevPosition);
                for (j = 0; j < levIdx; ++j) {
                    br.seek(br.getFilePointer() + (long)this.LevelVarList.get(j).size() * this.recLen);
                }
                br.seek(br.getFilePointer() + (long)nvarIdx * this.recLen);
                DataLabel aDL = ARLDataInfo.readDataLabel(br);
                byte[] dataBytes = new byte[(int)this.recLen - 50];
                br.read(dataBytes);
                double[][] theData = this.unpackARLGridData(dataBytes, xNum, yNum, aDL);
                for (j = 0; j < yNum; ++j) {
                    newGridData[i][j] = theData[j][lonIdx];
                }
            }
            br.close();
            GridData gridData = new GridData();
            gridData.data = newGridData;
            gridData.missingValue = this.missingValue;
            gridData.xArray = this.Y;
            gridData.yArray = new double[lNum];
            for (int i = 0; i < lNum; ++i) {
                gridData.yArray[i] = this.getVariables().get(varIdx).getLevels().get(i);
            }
            return gridData;
        }
        catch (IOException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_LevelLon(int latIdx, int varIdx, int timeIdx) {
        try {
            int xNum = this.dataHead.NX;
            int yNum = this.dataHead.NY;
            int lNum = this.getVariables().get(varIdx).getLevelNum();
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            double[][] newGridData = new double[lNum][xNum];
            br.seek((long)(timeIdx * this.recsPerTime) * this.recLen);
            br.seek(br.getFilePointer() + this.indexLen);
            long aLevPosition = br.getFilePointer();
            for (int i = 0; i < lNum; ++i) {
                int j;
                int nvarIdx = this.getVariables().get(varIdx).getVarInLevelIdxs().get(i);
                int levIdx = this.getVariables().get(varIdx).getLevelIdxs().get(i);
                br.seek(aLevPosition);
                for (j = 0; j < levIdx; ++j) {
                    br.seek(br.getFilePointer() + (long)this.LevelVarList.get(j).size() * this.recLen);
                }
                br.seek(br.getFilePointer() + (long)nvarIdx * this.recLen);
                DataLabel aDL = ARLDataInfo.readDataLabel(br);
                byte[] dataBytes = new byte[(int)this.recLen - 50];
                br.read(dataBytes);
                double[][] theData = this.unpackARLGridData(dataBytes, xNum, yNum, aDL);
                for (j = 0; j < xNum; ++j) {
                    newGridData[i][j] = theData[latIdx][j];
                }
            }
            br.close();
            GridData gridData = new GridData();
            gridData.data = newGridData;
            gridData.missingValue = this.missingValue;
            gridData.xArray = this.X;
            gridData.yArray = new double[lNum];
            for (int i = 0; i < lNum; ++i) {
                gridData.yArray[i] = this.getVariables().get(varIdx).getLevels().get(i);
            }
            return gridData;
        }
        catch (IOException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_LevelTime(int latIdx, int varIdx, int lonIdx) {
        try {
            int i;
            int xNum = this.dataHead.NX;
            int yNum = this.dataHead.NY;
            int lNum = this.getVariables().get(varIdx).getLevelNum();
            int tNum = this.getTimeNum();
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            double[][] newGridData = new double[lNum][tNum];
            for (int t = 0; t < tNum; ++t) {
                br.seek((long)(t * this.recsPerTime) * this.recLen);
                br.seek(br.getFilePointer() + this.indexLen);
                long aLevPosition = br.getFilePointer();
                for (int i2 = 0; i2 < lNum; ++i2) {
                    int nvarIdx = this.getVariables().get(varIdx).getVarInLevelIdxs().get(i2);
                    int levIdx = this.getVariables().get(varIdx).getLevelIdxs().get(i2);
                    br.seek(aLevPosition);
                    for (int j = 0; j < levIdx; ++j) {
                        br.seek(br.getFilePointer() + (long)this.LevelVarList.get(j).size() * this.recLen);
                    }
                    br.seek(br.getFilePointer() + (long)nvarIdx * this.recLen);
                    DataLabel aDL = ARLDataInfo.readDataLabel(br);
                    byte[] dataBytes = new byte[(int)this.recLen - 50];
                    br.read(dataBytes);
                    double[][] theData = this.unpackARLGridData(dataBytes, xNum, yNum, aDL);
                    newGridData[i2][t] = theData[latIdx][lonIdx];
                }
            }
            br.close();
            GridData gridData = new GridData();
            gridData.data = newGridData;
            gridData.missingValue = this.missingValue;
            gridData.xArray = new double[tNum];
            for (i = 0; i < tNum; ++i) {
                gridData.xArray[i] = JDateUtil.toOADate(this.getTimes().get(i));
            }
            gridData.yArray = new double[lNum];
            for (i = 0; i < lNum; ++i) {
                gridData.yArray[i] = this.getVariables().get(varIdx).getLevels().get(i);
            }
            return gridData;
        }
        catch (IOException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_Time(int lonIdx, int latIdx, int varIdx, int levelIdx) {
        try {
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            int xNum = this.dataHead.NX;
            int yNum = this.dataHead.NY;
            GridData aGridData = new GridData();
            aGridData.missingValue = this.missingValue;
            aGridData.xArray = new double[this.getTimeNum()];
            aGridData.yArray = new double[1];
            aGridData.yArray[0] = 0.0;
            aGridData.data = new double[1][this.getTimeNum()];
            Variable aVar = this.getVariables().get(varIdx);
            if (aVar.getLevelNum() > 1) {
                ++levelIdx;
            }
            varIdx = this.LevelVarList.get(levelIdx).indexOf(aVar.getName());
            for (int t = 0; t < this.getTimeNum(); ++t) {
                br.seek((long)(t * this.recsPerTime) * this.recLen);
                br.seek(br.getFilePointer() + this.indexLen);
                for (int i = 0; i < levelIdx; ++i) {
                    br.seek(br.getFilePointer() + (long)this.LevelVarList.get(i).size() * this.recLen);
                }
                br.seek(br.getFilePointer() + (long)varIdx * this.recLen);
                DataLabel aDL = ARLDataInfo.readDataLabel(br);
                byte[] dataBytes = new byte[(int)this.recLen - 50];
                br.read(dataBytes);
                double[][] gridData = this.unpackARLGridData(dataBytes, xNum, yNum, aDL);
                double aValue = gridData[latIdx][lonIdx];
                aGridData.xArray[t] = JDateUtil.toOADate(this.getTimes().get(t));
                aGridData.data[0][t] = aValue;
            }
            br.close();
            return aGridData;
        }
        catch (IOException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_Level(int lonIdx, int latIdx, int varIdx, int timeIdx) {
        try {
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            int xNum = this.dataHead.NX;
            int yNum = this.dataHead.NY;
            int lNum = this.getVariables().get(varIdx).getLevelNum();
            GridData aGridData = new GridData();
            aGridData.missingValue = this.missingValue;
            aGridData.xArray = new double[lNum];
            aGridData.yArray = new double[1];
            aGridData.yArray[0] = 0.0;
            aGridData.data = new double[1][lNum];
            br.seek((long)(timeIdx * this.recsPerTime) * this.recLen);
            br.seek(br.getFilePointer() + this.indexLen);
            long aLevPosition = br.getFilePointer();
            for (int i = 0; i < lNum; ++i) {
                int nvarIdx = this.getVariables().get(varIdx).getVarInLevelIdxs().get(i);
                int levIdx = this.getVariables().get(varIdx).getLevelIdxs().get(i);
                br.seek(aLevPosition);
                for (int j = 0; j < levIdx; ++j) {
                    br.seek(br.getFilePointer() + (long)this.LevelVarList.get(j).size() * this.recLen);
                }
                br.seek(br.getFilePointer() + (long)nvarIdx * this.recLen);
                DataLabel aDL = ARLDataInfo.readDataLabel(br);
                byte[] dataBytes = new byte[(int)this.recLen - 50];
                br.read(dataBytes);
                double[][] gridData = this.unpackARLGridData(dataBytes, xNum, yNum, aDL);
                double aValue = gridData[latIdx][lonIdx];
                aGridData.xArray[i] = this.levels.get(levIdx);
                aGridData.data[0][i] = aValue;
            }
            br.close();
            return aGridData;
        }
        catch (IOException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_Lon(int timeIdx, int latIdx, int varIdx, int levelIdx) {
        try {
            int i;
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            int xNum = this.dataHead.NX;
            int yNum = this.dataHead.NY;
            GridData aGridData = new GridData();
            aGridData.missingValue = this.missingValue;
            aGridData.xArray = this.X;
            aGridData.yArray = new double[1];
            aGridData.yArray[0] = 0.0;
            aGridData.data = new double[1][this.X.length];
            Variable aVar = this.getVariables().get(varIdx);
            if (aVar.getLevelNum() > 1) {
                ++levelIdx;
            }
            varIdx = this.LevelVarList.get(levelIdx).indexOf(aVar.getName());
            br.seek((long)(timeIdx * this.recsPerTime) * this.recLen);
            br.seek(br.getFilePointer() + this.indexLen);
            for (i = 0; i < levelIdx; ++i) {
                br.seek(br.getFilePointer() + (long)this.LevelVarList.get(i).size() * this.recLen);
            }
            br.seek(br.getFilePointer() + (long)varIdx * this.recLen);
            DataLabel aDL = ARLDataInfo.readDataLabel(br);
            byte[] dataBytes = new byte[(int)this.recLen - 50];
            br.read(dataBytes);
            double[][] gridData = this.unpackARLGridData(dataBytes, xNum, yNum, aDL);
            for (i = 0; i < xNum; ++i) {
                double aValue;
                aGridData.data[0][i] = aValue = gridData[latIdx][i];
            }
            br.close();
            return aGridData;
        }
        catch (IOException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_Lat(int timeIdx, int lonIdx, int varIdx, int levelIdx) {
        try {
            int i;
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            int xNum = this.dataHead.NX;
            int yNum = this.dataHead.NY;
            GridData aGridData = new GridData();
            aGridData.missingValue = this.missingValue;
            aGridData.xArray = this.Y;
            aGridData.yArray = new double[1];
            aGridData.yArray[0] = 0.0;
            aGridData.data = new double[1][this.Y.length];
            Variable aVar = this.getVariables().get(varIdx);
            if (aVar.getLevelNum() > 1) {
                ++levelIdx;
            }
            varIdx = this.LevelVarList.get(levelIdx).indexOf(aVar.getName());
            br.seek((long)(timeIdx * this.recsPerTime) * this.recLen);
            br.seek(br.getFilePointer() + this.indexLen);
            for (i = 0; i < levelIdx; ++i) {
                br.seek(br.getFilePointer() + (long)this.LevelVarList.get(i).size() * this.recLen);
            }
            br.seek(br.getFilePointer() + (long)varIdx * this.recLen);
            DataLabel aDL = ARLDataInfo.readDataLabel(br);
            byte[] dataBytes = new byte[(int)this.recLen - 50];
            br.read(dataBytes);
            double[][] gridData = this.unpackARLGridData(dataBytes, xNum, yNum, aDL);
            for (i = 0; i < yNum; ++i) {
                double aValue;
                aGridData.data[0][i] = aValue = gridData[i][lonIdx];
            }
            br.close();
            return aGridData;
        }
        catch (IOException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void createDataFile(String fileName) {
        try {
            this._bw = new RandomAccessFile(fileName, "rw");
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void closeDataFile() {
        try {
            this._bw.close();
            this._bw = null;
        }
        catch (IOException ex) {
            Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public DataHead getDataHead(ProjectionInfo projInfo, String model, int kFlag, int icx, short mn) {
        this.setIndexRecPos();
        DataHead aDH = new DataHead();
        aDH.MODEL = model;
        aDH.ICX = icx;
        aDH.MN = mn;
        aDH.K_FLAG = (short)kFlag;
        aDH.LENH = 108;
        for (int i = 0; i < this.levels.size(); ++i) {
            aDH.LENH += this.LevelVarList.get(i).size() * 8 + 8;
        }
        aDH.DUMMY = 0.0f;
        aDH.NX = this.X.length;
        aDH.NY = this.Y.length;
        aDH.NZ = this.levels.size();
        if (projInfo.getProjectionName() == ProjectionNames.LongLat) {
            aDH.POLE_LAT = 90.0f;
            aDH.POLE_LON = 0.0f;
            aDH.REF_LAT = (float)(this.Y[1] - this.Y[0]);
            aDH.REF_LON = (float)(this.X[1] - this.X[0]);
            aDH.SIZE = 0.0f;
            aDH.ORIENT = 0.0f;
            aDH.TANG_LAT = 0.0f;
            aDH.SYNC_XP = 1.0f;
            aDH.SYNC_YP = 1.0f;
            aDH.SYNC_LAT = (float)this.Y[0];
            aDH.SYNC_LON = (float)this.X[0];
        } else {
            float sync_x = 1.0f;
            float sync_y = 1.0f;
            double x = this.X[0];
            double y = this.Y[0];
            double[][] points = new double[][]{{x, y}};
            ProjectionInfo toProj = KnownCoordinateSystems.geographic.world.WGS1984;
            Reproject.reprojectPoints(points, projInfo, toProj, 0, 1);
            double sync_lon = points[0][0];
            double sync_lat = points[0][1];
            Projection aProj = projInfo.getCoordinateReferenceSystem().getProjection();
            double tanLat = this.eqvlat(aProj.getProjectionLatitude1Degrees(), aProj.getProjectionLatitude2Degrees());
            tanLat = Double.parseDouble(String.format("%.2f", tanLat));
            switch (projInfo.getProjectionName()) {
                case Lambert_Conformal_Conic: {
                    aDH.POLE_LAT = (float)tanLat;
                    aDH.POLE_LON = (float)aProj.getProjectionLongitudeDegrees();
                    aDH.REF_LAT = (float)aProj.getProjectionLatitudeDegrees();
                    aDH.REF_LON = (float)aProj.getProjectionLongitudeDegrees();
                    aDH.SIZE = (float)(this.X[1] - this.X[0]) / 1000.0f;
                    aDH.ORIENT = 0.0f;
                    aDH.TANG_LAT = (float)tanLat;
                    aDH.SYNC_XP = sync_x;
                    aDH.SYNC_YP = sync_y;
                    aDH.SYNC_LAT = (float)sync_lat;
                    aDH.SYNC_LON = (float)sync_lon;
                    break;
                }
                case Mercator: {
                    aDH.POLE_LAT = 0.0f;
                    aDH.POLE_LON = (float)aProj.getProjectionLongitudeDegrees();
                    aDH.REF_LAT = (float)tanLat;
                    aDH.REF_LON = (float)aProj.getProjectionLongitudeDegrees();
                    aDH.SIZE = (float)(this.X[1] - this.X[0]) / 1000.0f;
                    aDH.ORIENT = 0.0f;
                    aDH.TANG_LAT = (float)tanLat;
                    aDH.SYNC_XP = sync_x;
                    aDH.SYNC_YP = sync_y;
                    aDH.SYNC_LAT = (float)sync_lat;
                    aDH.SYNC_LON = (float)sync_lon;
                    break;
                }
                case North_Polar_Stereographic_Azimuthal: {
                    aDH.POLE_LAT = 90.0f;
                    aDH.POLE_LON = (float)aProj.getProjectionLongitudeDegrees();
                    aDH.REF_LAT = (float)tanLat;
                    aDH.REF_LON = (float)aProj.getProjectionLongitudeDegrees();
                    aDH.SIZE = (float)(this.X[1] - this.X[0]) / 1000.0f;
                    aDH.ORIENT = 0.0f;
                    aDH.TANG_LAT = (float)aProj.getProjectionLatitude2Degrees();
                    aDH.SYNC_XP = sync_x;
                    aDH.SYNC_YP = sync_y;
                    aDH.SYNC_LAT = (float)sync_lat;
                    aDH.SYNC_LON = (float)sync_lon;
                    break;
                }
                case South_Polar_Stereographic_Azimuthal: {
                    aDH.POLE_LAT = -90.0f;
                    aDH.POLE_LON = (float)aProj.getProjectionLongitudeDegrees();
                    aDH.REF_LAT = (float)tanLat;
                    aDH.REF_LON = (float)aProj.getProjectionLongitudeDegrees();
                    aDH.SIZE = (float)(this.X[1] - this.X[0]) / 1000.0f;
                    aDH.ORIENT = 0.0f;
                    aDH.TANG_LAT = (float)aProj.getProjectionLatitude2Degrees();
                    aDH.SYNC_XP = 1.0f;
                    aDH.SYNC_YP = 1.0f;
                    aDH.SYNC_LAT = (float)sync_lat;
                    aDH.SYNC_LON = (float)sync_lon;
                }
            }
        }
        return aDH;
    }

    private double eqvlat(double lat1, double lat2) {
        double al2;
        double al1;
        double slat2;
        double RADPDEG = Math.PI / 180;
        double DEGPRAD = 57.29577951308232;
        double slat1 = Math.sin(RADPDEG * lat1);
        if (slat1 < (slat2 = Math.sin(RADPDEG * lat2))) {
            double temp = slat1;
            slat1 = slat2;
            slat2 = temp;
        }
        if (slat1 == slat2) {
            return Math.asin(slat1) * DEGPRAD;
        }
        if (slat1 == -slat2) {
            return 0.0;
        }
        if (slat1 >= 1.0) {
            return 90.0;
        }
        if (slat2 <= -1.0) {
            return -90.0;
        }
        double tau = (slat1 - slat2) / (2.0 - slat1 - slat2);
        double FSM = 0.001;
        if (tau > FSM) {
            al1 = Math.log((1.0 - slat1) / (1.0 - slat2)) / (slat1 - slat2);
        } else {
            tau *= tau;
            al1 = -2.0 / (2.0 - slat1 - slat2) * (1.0 + tau * (0.3333333333333333 + tau * (0.2 + tau * (0.14285714285714285 + tau))));
        }
        tau = (slat1 - slat2) / (2.0 + slat1 + slat2);
        if (tau > FSM) {
            al2 = Math.log((1.0 + slat1) / (1.0 + slat2)) / (slat1 - slat2);
        } else {
            tau *= tau;
            al2 = 2.0 / (2.0 + slat1 + slat2) * (1.0 + tau * (0.3333333333333333 + tau * (0.2 + tau * (0.14285714285714285 + tau))));
        }
        double eqvlat = Math.asin((al1 + al2) / (al1 - al2)) * DEGPRAD;
        return eqvlat;
    }

    private double eqvlat_bak(double lat1, double lat2) {
        double AL2;
        double AL1;
        double SINL2;
        double RADPDG = Math.PI / 180;
        double SINL1 = Math.sin(lat1 * RADPDG);
        if (Math.abs(SINL1 - (SINL2 = Math.sin(lat2 * RADPDG))) > 0.001) {
            AL1 = Math.log((1.0 - SINL1) / (1.0 - SINL2));
            AL2 = Math.log((1.0 + SINL1) / (1.0 + SINL2));
        } else {
            double TAU = -(SINL1 - SINL2) / (2.0 - SINL1 - SINL2);
            TAU *= TAU;
            AL1 = 2.0 / (2.0 - SINL1 - SINL2) * (1.0 + TAU * (0.3333333333333333 + TAU * (0.2 + TAU * 0.14285714285714285)));
            TAU = (SINL1 - SINL2) / (2.0 + SINL1 + SINL2);
            TAU *= TAU;
            AL2 = -2.0 / (2.0 + SINL1 + SINL2) * (1.0 + TAU * (0.3333333333333333 + TAU * (0.2 + TAU * 0.14285714285714285)));
        }
        double EQVLAT = Math.asin((AL1 + AL2) / (AL1 - AL2)) / RADPDG;
        return EQVLAT;
    }

    private String padNumStr(String str, int n) {
        String nstr = str;
        if (nstr.indexOf(46) < 0) {
            nstr = nstr + ".";
        }
        if (nstr.length() > n) {
            nstr = nstr.substring(0, n);
        }
        return GlobalUtil.padRight(nstr, n, '0');
    }

    public void setIndexRecPos() {
        if (this._bw != null) {
            try {
                this.indexRecPos = this._bw.getFilePointer();
            }
            catch (IOException ex) {
                Logger.getLogger(ARLDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void writeSDL(LocalDateTime time) throws IOException {
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyMMddHH");
        String dateStr = format.format(time);
        this._bw.writeBytes(dateStr);
        this._bw.writeBytes("00");
        this._bw.writeBytes("00");
        if (this.isLargeGrid()) {
            String igc = this.getIGC();
            this._bw.writeBytes(igc);
        } else {
            this._bw.writeBytes("99");
        }
        this._bw.writeBytes("INDX");
        this._bw.writeBytes("   0");
        this._bw.writeBytes(" 0.0000000E+00");
        this._bw.writeBytes(" 0.0000000E+00");
    }

    public void writeIndexRecord(LocalDateTime time, DataHead aDH, List<List<Integer>> ksums) throws IOException {
        String str;
        this._bw.seek(this.indexRecPos);
        this.writeSDL(time);
        this._bw.writeBytes(GlobalUtil.padRight(aDH.MODEL, 4, '1'));
        this._bw.writeBytes(GlobalUtil.padLeft(String.valueOf(aDH.ICX), 3, ' '));
        this._bw.writeBytes(GlobalUtil.padLeft(String.valueOf(aDH.MN), 2, ' '));
        this._bw.writeBytes(this.padNumStr(String.valueOf(aDH.POLE_LAT), 7));
        this._bw.writeBytes(this.padNumStr(String.valueOf(aDH.POLE_LON), 7));
        this._bw.writeBytes(this.padNumStr(String.valueOf(aDH.REF_LAT), 7));
        this._bw.writeBytes(this.padNumStr(String.valueOf(aDH.REF_LON), 7));
        this._bw.writeBytes(this.padNumStr(String.valueOf(aDH.SIZE), 7));
        this._bw.writeBytes(this.padNumStr(String.valueOf(aDH.ORIENT), 7));
        this._bw.writeBytes(this.padNumStr(String.valueOf(aDH.TANG_LAT), 7));
        this._bw.writeBytes(this.padNumStr(String.valueOf(aDH.SYNC_XP), 7));
        this._bw.writeBytes(this.padNumStr(String.valueOf(aDH.SYNC_YP), 7));
        this._bw.writeBytes(this.padNumStr(String.valueOf(aDH.SYNC_LAT), 7));
        this._bw.writeBytes(this.padNumStr(String.valueOf(aDH.SYNC_LON), 7));
        this._bw.writeBytes(this.padNumStr(String.valueOf(aDH.DUMMY), 7));
        if (aDH.NX >= 1000) {
            str = String.valueOf(aDH.NX);
            str = str.substring(str.length() - 3);
            this._bw.writeBytes(str);
        } else {
            this._bw.writeBytes(GlobalUtil.padLeft(String.valueOf(aDH.NX), 3, ' '));
        }
        if (aDH.NY >= 1000) {
            str = String.valueOf(aDH.NY);
            str = str.substring(str.length() - 3);
            this._bw.writeBytes(str);
        } else {
            this._bw.writeBytes(GlobalUtil.padLeft(String.valueOf(aDH.NY), 3, ' '));
        }
        this._bw.writeBytes(GlobalUtil.padLeft(String.valueOf(aDH.NZ), 3, ' '));
        this._bw.writeBytes(GlobalUtil.padLeft(String.valueOf(aDH.K_FLAG), 2, ' '));
        this._bw.writeBytes(GlobalUtil.padLeft(String.valueOf(aDH.LENH), 4, ' '));
        ByteBuffer bb = ByteBuffer.allocate(aDH.LENH - 108);
        for (int i = 0; i < aDH.NZ; ++i) {
            String levStr = this.padNumStr(String.valueOf(this.levels.get(i)), 6);
            bb.put(levStr.getBytes());
            int vNum = this.LevelVarList.get(i).size();
            bb.put(GlobalUtil.padLeft(String.valueOf(vNum), 2, ' ').getBytes());
            for (int j = 0; j < vNum; ++j) {
                bb.put(GlobalUtil.padRight(this.LevelVarList.get(i).get(j), 4, '1').getBytes());
                if (ksums == null) {
                    bb.put("226".getBytes());
                } else {
                    String ksumStr = GlobalUtil.padLeft(ksums.get(i).get(j).toString(), 3, ' ');
                    bb.put(ksumStr.getBytes());
                }
                bb.put(" ".getBytes());
            }
        }
        int nxy = aDH.NX * aDH.NY;
        if (nxy >= aDH.LENH) {
            this._bw.write(bb.array());
        } else {
            byte[] bytes = bb.array();
            int idx = 0;
            this._bw.write(Arrays.copyOfRange(bytes, idx, idx + (nxy - 108)));
            idx += nxy - 108;
            while (idx < bytes.length) {
                this.writeSDL(time);
                this._bw.write(Arrays.copyOfRange(bytes, idx, idx + nxy));
                idx += nxy;
            }
        }
        ((Buffer)bb).clear();
        if (nxy > aDH.LENH) {
            this._bw.write(new byte[aDH.NY * aDH.NX - aDH.LENH]);
        }
        this._bw.seek(this._bw.length());
    }

    public void writeGridData(DataLabel aDL, GridData gridData) throws IOException {
        byte[] dataBytes = this.packARLGridData(gridData, aDL);
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyMMddHH");
        String dateStr = format.format(aDL.getTime());
        this._bw.writeBytes(dateStr);
        this._bw.writeBytes(GlobalUtil.padLeft(String.valueOf(aDL.getForecast()), 2, ' '));
        this._bw.writeBytes(GlobalUtil.padLeft(String.valueOf(aDL.getLevel()), 2, ' '));
        if (aDL.XGPT) {
            this._bw.writeBytes(aDL.IGC);
        } else {
            this._bw.writeBytes(GlobalUtil.padLeft(String.valueOf(aDL.getGrid()), 2, ' '));
        }
        this._bw.writeBytes(GlobalUtil.padRight(aDL.getVarName(), 4, '1'));
        this._bw.writeBytes(GlobalUtil.padLeft(String.valueOf(aDL.getExponent()), 4, ' '));
        DecimalFormat dformat = new DecimalFormat("0.0000000E00");
        String preStr = dformat.format(aDL.getPrecision());
        if (!preStr.contains("E-")) {
            preStr = preStr.replace("E", "E+");
        }
        this._bw.writeBytes(GlobalUtil.padLeft(preStr, 14, ' '));
        preStr = dformat.format(aDL.getValue());
        if (!preStr.contains("E-")) {
            preStr = preStr.replace("E", "E+");
        }
        this._bw.writeBytes(GlobalUtil.padLeft(preStr, 14, ' '));
        this._bw.write(dataBytes);
    }

    public Array diffOriginPack(Array a) {
        DataLabel dl = new DataLabel();
        return this.diffOriginPack(a, dl);
    }

    public Array diffOriginPack(Array a, DataLabel dl) {
        Object[] p = this.packARLGridData(a, dl);
        byte[] dataBytes = (byte[])p[0];
        int[] shape = a.getShape();
        int ny = shape[0];
        int nx = shape[1];
        float[] up = this.unpackARLData(dataBytes, nx, ny, dl);
        Array b = Array.factory(DataType.FLOAT, shape, (Object)up);
        Array diff = ArrayMath.sub(a, b);
        return diff;
    }

    public int writeGridData(DataLabel aDL, Array a) throws IOException {
        Object[] r = this.packARLGridData(a, aDL);
        byte[] dataBytes = (byte[])r[0];
        int ksum = (Integer)r[1];
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyMMddHH");
        String dateStr = format.format(aDL.getTime());
        this._bw.writeBytes(dateStr);
        String fcst = GlobalUtil.padLeft(String.valueOf(aDL.getForecast()), 2, ' ');
        if (fcst.length() > 2) {
            fcst = fcst.substring(fcst.length() - 2);
        }
        this._bw.writeBytes(fcst);
        this._bw.writeBytes(GlobalUtil.padLeft(String.valueOf(aDL.getLevel()), 2, ' '));
        if (aDL.XGPT) {
            this._bw.writeBytes(aDL.IGC);
        } else {
            this._bw.writeBytes(GlobalUtil.padLeft(String.valueOf(aDL.getGrid()), 2, ' '));
        }
        this._bw.writeBytes(GlobalUtil.padRight(aDL.getVarName(), 4, '1'));
        this._bw.writeBytes(GlobalUtil.padLeft(String.valueOf(aDL.getExponent()), 4, ' '));
        DecimalFormat dformat = new DecimalFormat("0.0000000E00");
        String preStr = dformat.format(aDL.getPrecision());
        if (!preStr.contains("E-")) {
            preStr = preStr.replace("E", "E+");
        }
        this._bw.writeBytes(GlobalUtil.padLeft(preStr, 14, ' '));
        preStr = dformat.format(aDL.getValue());
        if (!preStr.contains("E-")) {
            preStr = preStr.replace("E", "E+");
        }
        this._bw.writeBytes(GlobalUtil.padLeft(preStr, 14, ' '));
        this._bw.write(dataBytes);
        return ksum;
    }

    public void writeGridData(LocalDateTime time, int levelIdx, String varName, int forecast, int grid, GridData gridData) throws IOException {
        DataLabel aDL = new DataLabel(time);
        aDL.setLevel(levelIdx);
        aDL.setVarName(varName);
        aDL.setGrid(grid);
        if (this.isLargeGrid()) {
            aDL.XGPT = true;
            aDL.IGC = this.getIGC();
        }
        aDL.setForecast(forecast);
        this.writeGridData(aDL, gridData);
    }

    public int writeGridData(LocalDateTime time, int levelIdx, String varName, int forecast, int grid, Array gridData) throws IOException {
        DataLabel aDL = new DataLabel(time);
        aDL.setLevel(levelIdx);
        aDL.setVarName(varName);
        aDL.setGrid(grid);
        if (this.isLargeGrid()) {
            aDL.XGPT = true;
            aDL.IGC = this.getIGC();
        }
        aDL.setForecast(forecast);
        int ksum = this.writeGridData(aDL, gridData);
        return ksum;
    }

    private String getIGC() {
        int xn = this.X.length / 1000;
        int yn = this.Y.length / 1000;
        char xc = (char)(xn + 64);
        char yc = (char)(yn + 64);
        return new String(new char[]{xc, yc});
    }

    private byte[] packARLGridData(GridData gridData, DataLabel aDL) {
        int j;
        int i;
        double var1;
        int nx = gridData.getXNum();
        int ny = gridData.getYNum();
        double rold = var1 = gridData.data[0][0];
        double rmax = 0.0;
        for (i = 0; i < ny; ++i) {
            for (j = 0; j < nx; ++j) {
                rmax = Math.max(Math.abs(gridData.data[i][j] - rold), rmax);
                rold = gridData.data[i][j];
            }
            rold = gridData.data[i][0];
        }
        double sexp = 0.0;
        if (rmax != 0.0) {
            sexp = Math.log(rmax) / Math.log(2.0);
        }
        int nexp = (int)sexp;
        if (sexp >= 0.0 || sexp % 1.0 == 0.0) {
            ++nexp;
        }
        double prec = Math.pow(2.0, nexp) / 254.0;
        byte[] dataBytes = new byte[ny * nx];
        double SCALE = Math.pow(2.0, 7 - nexp);
        double VOLD = var1;
        double rcol = var1;
        int ksum = 0;
        int INDX = 0;
        for (j = 0; j < ny; ++j) {
            VOLD = rcol;
            for (i = 0; i < nx; ++i) {
                int ival = (int)((gridData.data[j][i] - VOLD) * SCALE + 127.5);
                dataBytes[INDX] = (byte)ival;
                VOLD = (double)(ival - 127) / SCALE + VOLD;
                if (i == 0) {
                    rcol = VOLD;
                }
                if ((ksum += ival) >= 256) {
                    ksum -= 255;
                }
                ++INDX;
            }
        }
        aDL.setExponent(nexp);
        aDL.setPrecision(prec);
        aDL.setValue(var1);
        return dataBytes;
    }

    private Object[] packARLGridData(Array a, DataLabel aDL) {
        int j;
        int i;
        double var1;
        int nx = a.getShape()[1];
        int ny = a.getShape()[0];
        double rold = var1 = a.getDouble(0);
        double rmax = 0.0;
        for (i = 0; i < ny; ++i) {
            for (j = 0; j < nx; ++j) {
                rmax = Math.max(Math.abs(a.getDouble(i * nx + j) - rold), rmax);
                rold = a.getDouble(i * nx + j);
            }
            rold = a.getDouble(i * nx);
        }
        double sexp = 0.0;
        if (rmax != 0.0) {
            sexp = Math.log(rmax) / Math.log(2.0);
        }
        int nexp = (int)sexp;
        if (sexp >= 0.0 || sexp % 1.0 == 0.0) {
            ++nexp;
        }
        double prec = Math.pow(2.0, nexp) / 254.0;
        byte[] dataBytes = new byte[ny * nx];
        double SCALE = Math.pow(2.0, 7 - nexp);
        double VOLD = var1;
        double rcol = var1;
        int ksum = 0;
        int INDX = 0;
        for (j = 0; j < ny; ++j) {
            VOLD = rcol;
            for (i = 0; i < nx; ++i) {
                int ival = (int)((a.getDouble(j * nx + i) - VOLD) * SCALE + 127.5);
                dataBytes[INDX] = (byte)ival;
                VOLD = (double)(ival - 127) / SCALE + VOLD;
                if (i == 0) {
                    rcol = VOLD;
                }
                if ((ksum += ival) >= 256) {
                    ksum -= 255;
                }
                ++INDX;
            }
        }
        aDL.setExponent(nexp);
        aDL.setPrecision(prec);
        aDL.setValue(var1);
        return new Object[]{dataBytes, ksum};
    }
}

