/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.bandraster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.mapdata.geotiff.GeoTiff;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IGridDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.math.ArrayMath;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.Dimension;
import org.meteoinfo.ndarray.DimensionType;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;

public class GeoTiffDataInfo
extends DataInfo
implements IGridDataInfo {
    private GeoTiff geoTiff;
    private int bandNum;

    public GeoTiffDataInfo() {
        this.setDataType(MeteoDataType.GEOTIFF);
    }

    @Override
    public void readDataInfo(String fileName) {
        try {
            this.setFileName(fileName);
            this.geoTiff = new GeoTiff(fileName);
            this.geoTiff.read();
            List<double[]> xy = this.geoTiff.readXY();
            double[] X = xy.get(0);
            double[] Y = xy.get(1);
            Dimension xDim = new Dimension(DimensionType.X);
            xDim.setValues(X);
            this.setXDimension(xDim);
            this.addDimension(xDim);
            Dimension yDim = new Dimension(DimensionType.Y);
            yDim.setValues(Y);
            yDim.setReverse(true);
            this.setYDimension(yDim);
            this.addDimension(yDim);
            this.bandNum = this.geoTiff.getBandNum();
            Dimension bDim = null;
            if (this.bandNum > 1) {
                bDim = new Dimension(DimensionType.Other);
                bDim.setValues(new double[this.bandNum]);
                this.addDimension(bDim);
            }
            ArrayList<Variable> variables = new ArrayList<Variable>();
            Variable aVar = new Variable();
            aVar.setName("var");
            aVar.addDimension(yDim);
            aVar.addDimension(xDim);
            if (this.bandNum > 1) {
                aVar.addDimension(bDim);
            }
            variables.add(aVar);
            this.setVariables(variables);
            this.setProjectionInfo(this.geoTiff.readProj());
        }
        catch (IOException ex) {
            Logger.getLogger(GeoTiffDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public String generateInfoText() {
        String dataInfo = "Data Type: GeoTiff";
        dataInfo = dataInfo + System.getProperty("line.separator") + super.generateInfoText();
        return dataInfo;
    }

    @Override
    public Array read(String varName) {
        Array r = null;
        try {
            r = this.geoTiff.readArray();
        }
        catch (IOException ex) {
            Logger.getLogger(GeoTiffDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        try {
            Array array = this.read(varName);
            array = ArrayMath.section(array, origin, size, stride);
            return array;
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(GeoTiffDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private void readXY(Range yRange, Range xRange, IndexIterator ii) {
        int[][] data = this.geoTiff.readData();
        for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
            for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                ii.setFloatNext(data[y][x]);
            }
        }
    }

    @Override
    public GridArray getGridArray(String varName) {
        return null;
    }

    @Override
    public GridData getGridData_LonLat(int timeIdx, int varIdx, int levelIdx) {
        GridData gdata = this.geoTiff.getGridData_Value();
        gdata.xArray = this.getXDimension().getValues();
        gdata.yArray = this.getYDimension().getValues();
        gdata.projInfo = this.getProjectionInfo();
        return gdata;
    }

    @Override
    public GridData getGridData_TimeLat(int lonIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_TimeLon(int latIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLat(int lonIdx, int varIdx, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLon(int latIdx, int varIdx, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelTime(int latIdx, int varIdx, int lonIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Time(int lonIdx, int latIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Level(int lonIdx, int latIdx, int varIdx, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lon(int timeIdx, int latIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lat(int timeIdx, int lonIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

