/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.bufr;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.global.DataConvert;
import ucar.nc2.iosp.bufr.BufrTableLookup;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageScanner;

public class BufrDataInfo {
    private RandomAccessFile bw = null;
    private long indicatorPos = 0L;
    private long dataPos = 0L;
    private int edition = 3;
    private BufrTableLookup lookup;
    protected static int[] BIT_MASK = new int[]{128, 64, 32, 16, 8, 4, 2, 1};

    public Message readFirstMessage(String fileName) throws FileNotFoundException, IOException {
        ucar.unidata.io.RandomAccessFile br = new ucar.unidata.io.RandomAccessFile(fileName, "r");
        MessageScanner ms = new MessageScanner(br);
        Message m = ms.getFirstDataMessage();
        br.close();
        return m;
    }

    public List<Message> readMessages(String fileName) throws IOException {
        ucar.unidata.io.RandomAccessFile br = new ucar.unidata.io.RandomAccessFile(fileName, "r");
        MessageScanner ms = new MessageScanner(br);
        ArrayList<Message> messages = new ArrayList<Message>();
        while (ms.hasNext()) {
            messages.add(ms.next());
        }
        br.close();
        return messages;
    }

    public void createDataFile(String fileName) {
        try {
            this.bw = new RandomAccessFile(fileName, "rw");
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(BufrDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void closeDataFile() {
        try {
            this.bw.close();
            this.bw = null;
        }
        catch (IOException ex) {
            Logger.getLogger(BufrDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public int writeIndicatorSection(int bufrLength, int edition) throws IOException {
        this.indicatorPos = this.bw.getFilePointer();
        this.bw.writeBytes("BUFR");
        byte[] ints = DataConvert.toUint3Int(bufrLength);
        this.bw.write(ints);
        this.bw.write(edition);
        this.edition = edition;
        return 8;
    }

    public void reWriteIndicatorSection(int bufrLength, int edition) throws IOException {
        this.bw.seek(this.indicatorPos);
        this.bw.writeBytes("BUFR");
        byte[] ints = DataConvert.toUint3Int(bufrLength);
        this.bw.write(ints);
        this.bw.write(edition);
        this.edition = edition;
        this.bw.seek(this.bw.length());
    }

    public int writeIdentificationSection(int len, int master_table, int subcenter_id, int center_id, int update_sequence, int optional, int category, int sub_category, int master_table_version, int local_table_version, int year, int month, int day, int hour, int minute) throws IOException {
        byte[] ints = DataConvert.toUint3Int(len);
        this.bw.write(ints);
        this.bw.write(master_table);
        this.bw.write(subcenter_id);
        this.bw.write(center_id);
        this.bw.write(update_sequence);
        this.bw.write(optional);
        this.bw.write(category);
        this.bw.write(sub_category);
        this.bw.write(master_table_version);
        this.bw.write(local_table_version);
        this.bw.write(year);
        this.bw.write(month);
        this.bw.write(day);
        this.bw.write(hour);
        this.bw.write(minute);
        this.bw.write(0);
        return len;
    }

    public int writeDataDescriptionSection(int ndatasets, int datatype, List<String> descriptors) throws IOException {
        int len = 7 + descriptors.size() * 2;
        byte[] ints = DataConvert.toUint3Int(len);
        this.bw.write(ints);
        this.bw.write(0);
        ints = DataConvert.toUint2Int(ndatasets);
        this.bw.write(ints);
        this.bw.write(datatype);
        for (String des : descriptors) {
            short fxy = Descriptor.getFxy((String)des);
            this.bw.writeShort(fxy);
        }
        return len;
    }

    public int writeDataSectionHead(int len) throws IOException {
        this.dataPos = this.bw.getFilePointer();
        byte[] ints = DataConvert.toUint3Int(len);
        this.bw.write(ints);
        this.bw.write(0);
        return 4;
    }

    public void reWriteDataSectionHead(int len) throws IOException {
        this.bw.seek(this.dataPos);
        byte[] ints = DataConvert.toUint3Int(len);
        this.bw.write(ints);
        this.bw.write(0);
        this.bw.seek(this.bw.length());
    }

    public int write(int value, int nbits) throws IOException {
        int n;
        BitSet bits = new BitSet(nbits);
        int index = 0;
        while ((long)value != 0L) {
            if ((long)value % 2L != 0L) {
                bits.set(index);
            }
            ++index;
            value >>>= 1;
        }
        byte[] bytes = bits.toByteArray();
        if (bytes.length < (n = nbits / 8)) {
            byte[] nbytes = new byte[n];
            for (int i = 0; i < n; ++i) {
                nbytes[i] = i < n - bytes.length ? (byte)0 : bytes[i - (n - bytes.length)];
            }
            this.bw.write(nbytes);
            return nbytes.length;
        }
        this.bw.write(bytes);
        return bytes.length;
    }

    public int write(String des, int value) throws IOException {
        DataDescriptor dds = new DataDescriptor(Descriptor.getFxy((String)des), null);
        int len = dds.getBitWidth();
        return this.write(value, len);
    }

    public int write(List<Integer> values, List<Integer> nbits) throws IOException {
        int tnb = 0;
        for (int n : nbits) {
            tnb += n;
        }
        BitSet bits = new BitSet(tnb);
        int sidx = 0;
        for (int k = 0; k < values.size(); ++k) {
            int value = values.get(k);
            int nb = nbits.get(k);
            BitSet temp = new BitSet(nb);
            int index = 0;
            while ((long)value != 0L) {
                if ((long)value % 2L != 0L) {
                    temp.set(index);
                }
                ++index;
                value >>>= 1;
            }
            for (int i = 0; i < index; ++i) {
                if (!temp.get(i)) continue;
                bits.set(sidx + nb - i - 1);
            }
            sidx += nb;
        }
        byte[] bytes = this.toByteArray(bits);
        this.bw.write(bytes);
        return bytes.length;
    }

    public byte[] toByteArray(BitSet bs) {
        if (bs.size() == 0) {
            return new byte[0];
        }
        int hiBit = -1;
        for (int i = 0; i < bs.size(); ++i) {
            if (!bs.get(i)) continue;
            hiBit = i;
        }
        int n = (hiBit + 8) / 8;
        byte[] bytes = new byte[n];
        if (n == 0) {
            return bytes;
        }
        Arrays.fill(bytes, (byte)0);
        for (int i = 0; i < n * 8; ++i) {
            if (!bs.get(i)) continue;
            BufrDataInfo.setBit(i, bytes);
        }
        return bytes;
    }

    protected static void setBit(int bit, byte[] bytes) {
        int size;
        int n = size = bytes == null ? 0 : bytes.length * 8;
        if (bit >= size) {
            throw new ArrayIndexOutOfBoundsException("Byte array too small");
        }
        int n2 = bit / 8;
        bytes[n2] = (byte)(bytes[n2] | BIT_MASK[bit % 8]);
    }

    public int writeEndSection() throws IOException {
        this.bw.writeBytes("7777");
        return 4;
    }
}

