/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.micaps;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IGridDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.micaps.MICAPS4DataInfo;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.util.JDateUtil;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Dimension;
import org.meteoinfo.ndarray.DimensionType;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.Section;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.Reproject;
import org.meteoinfo.projection.info.ProjectionInfo;

public class MICAPS13DataInfo
extends DataInfo
implements IGridDataInfo {
    private String _description;
    private LocalDateTime _time;
    private int _xNum;
    private int _yNum;
    private double _lon_LB;
    private double _lat_LB;
    private double _lon_Center;
    private double _lat_Center;
    private int _projOption;
    private double _zoomFactor;
    private int _imageType;
    private String _tableName;
    private byte[] _imageBytes;

    public MICAPS13DataInfo() {
        this.setDataType(MeteoDataType.MICAPS_13);
    }

    @Override
    public void readDataInfo(String fileName) {
        try {
            LocalDateTime tt;
            this.setFileName(fileName);
            RandomAccessFile br = new RandomAccessFile(fileName, "r");
            byte[] bytes = new byte[128];
            br.read(bytes);
            String header = new String(bytes, "GBK").trim();
            String[] dataArray = header.split("\\s+");
            this._description = dataArray[2];
            int year = Integer.parseInt(dataArray[3]);
            if (year < 100) {
                year = year > 50 ? 1900 + year : 2000 + year;
            }
            this._time = tt = LocalDateTime.of(year, Integer.parseInt(dataArray[4]), Integer.parseInt(dataArray[5]), Integer.parseInt(dataArray[6]), 0, 0);
            this._xNum = Integer.parseInt(dataArray[7]);
            this._yNum = Integer.parseInt(dataArray[8]);
            this._lon_LB = Double.parseDouble(dataArray[9]);
            this._lat_LB = Double.parseDouble(dataArray[10]);
            this._projOption = Integer.parseInt(dataArray[11]);
            this._zoomFactor = Double.parseDouble(dataArray[12]);
            this._imageType = Integer.parseInt(dataArray[13]);
            this._tableName = dataArray[14];
            if (MIMath.isNumeric(dataArray[15]) && MIMath.isNumeric(dataArray[16])) {
                this._lon_Center = Double.parseDouble(dataArray[15]);
                this._lat_Center = Double.parseDouble(dataArray[16]);
                if (this._lon_Center > 180.0) {
                    this._lon_Center /= 100.0;
                }
                if (this._lat_Center > 90.0) {
                    this._lat_Center /= 100.0;
                }
            } else {
                this._lon_Center = 110.0;
                this._lat_Center = 30.0;
            }
            int length = (int)br.length() - 128;
            this._imageBytes = new byte[length];
            br.read(this._imageBytes);
            this.setProjectionInfo(this.getProjectionInfo(this._lon_Center, this._lat_Center, this._projOption));
            Object[] coords = this.calCoordinate(this._lon_LB, this._lat_LB, this._lon_Center, this._lat_Center, this._xNum, this._yNum);
            br.close();
            Dimension tdim = new Dimension(DimensionType.T);
            tdim.addValue(JDateUtil.toOADate(this._time));
            this.setTimeDimension(tdim);
            this.addDimension(tdim);
            Dimension ydim = new Dimension(DimensionType.Y);
            ydim.setValues((double[])coords[1]);
            this.addDimension(ydim);
            this.setYDimension(ydim);
            Dimension xdim = new Dimension(DimensionType.X);
            xdim.setValues((double[])coords[0]);
            this.addDimension(xdim);
            this.setXDimension(xdim);
            Variable var = new Variable();
            var.setName("var");
            var.setDimension(tdim);
            var.setDimension(ydim);
            var.setDimension(xdim);
            this.addVariable(var);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MICAPS13DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MICAPS13DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private ProjectionInfo getProjectionInfo(double lon_Center, double lat_Center, int projOption) {
        String ProjStr = "+proj=lcc+lat_1=" + String.valueOf(lat_Center) + "+lat_2=60+lat_0=0+lon_0=" + String.valueOf(lon_Center) + "+x_0=0+y_0=0";
        switch (projOption) {
            case 1: {
                ProjStr = "+proj=lcc+lat_1=" + String.valueOf(lat_Center) + "+lat_2=60+lat_0=0+lon_0=" + String.valueOf(lon_Center) + "+x_0=0+y_0=0";
                break;
            }
            case 2: {
                ProjStr = "+proj=merc+lon_0=" + String.valueOf(lon_Center);
                break;
            }
            case 3: {
                ProjStr = "+proj=stere+lat_0=90+lon_0=" + String.valueOf(lon_Center);
                break;
            }
            case 4: {
                ProjStr = "+proj=stere+lat_0=-90+lon_0=" + String.valueOf(lon_Center);
            }
        }
        return ProjectionInfo.factory(ProjStr);
    }

    private Object[] calCoordinate(double lon_LB, double lat_LB, double lon_Center, double lat_Center, int xNum, int yNum) {
        int i;
        ProjectionInfo fromProj = KnownCoordinateSystems.geographic.world.WGS1984;
        double[][] points = new double[][]{{lon_LB, lat_LB}};
        Reproject.reprojectPoints(points, fromProj, this.getProjectionInfo(), 0, 1);
        double X_LB = points[0][0];
        double Y_LB = points[0][1];
        points = new double[][]{{lon_Center, lat_Center}};
        Reproject.reprojectPoints(points, fromProj, this.getProjectionInfo(), 0, 1);
        double X_Center = points[0][0];
        double Y_Center = points[0][1];
        double[] X = new double[xNum];
        double[] Y = new double[yNum];
        double xMax = X_Center + (X_Center - X_LB);
        double yMax = Y_Center + (Y_Center - Y_LB);
        double width = xMax - X_LB;
        double height = yMax - Y_LB;
        double xDelt = width / (double)(xNum - 1);
        double yDelt = height / (double)(yNum - 1);
        for (i = 0; i < xNum; ++i) {
            X[i] = X_LB + (double)i * xDelt;
        }
        for (i = 0; i < yNum; ++i) {
            Y[i] = Y_LB + (double)i * yDelt;
        }
        return new Object[]{X, Y};
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public String generateInfoText() {
        String dataInfo = "";
        dataInfo = dataInfo + "File Name: " + this.getFileName();
        dataInfo = dataInfo + System.getProperty("line.separator") + "Description: " + this._description;
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        dataInfo = dataInfo + System.getProperty("line.separator") + "Time: " + format.format(this._time);
        dataInfo = dataInfo + System.getProperty("line.separator") + "X number: " + String.valueOf(this._xNum);
        dataInfo = dataInfo + System.getProperty("line.separator") + "Y number: " + String.valueOf(this._yNum);
        dataInfo = dataInfo + System.getProperty("line.separator") + "Left-Bottom longitude: " + String.valueOf(this._lon_LB);
        dataInfo = dataInfo + System.getProperty("line.separator") + "Left-Bottom latitude: " + String.valueOf(this._lat_LB);
        dataInfo = dataInfo + System.getProperty("line.separator") + "Center longitude: " + String.valueOf(this._lon_Center);
        dataInfo = dataInfo + System.getProperty("line.separator") + "Center latitude: " + String.valueOf(this._lat_Center);
        dataInfo = dataInfo + System.getProperty("line.separator") + "Projection: " + this.getProjectionString(this._projOption);
        dataInfo = dataInfo + System.getProperty("line.separator") + "Zoom factor: " + String.valueOf(this._zoomFactor);
        dataInfo = dataInfo + System.getProperty("line.separator") + "Image type: " + this.getImageType(this._imageType);
        dataInfo = dataInfo + System.getProperty("line.separator") + "Table name: " + this._tableName;
        dataInfo = dataInfo + System.getProperty("line.separator") + super.generateInfoText();
        return dataInfo;
    }

    private String getProjectionString(int proj) {
        String projStr = "Lon/Lat";
        switch (proj) {
            case 1: {
                projStr = "Lambert";
                break;
            }
            case 2: {
                projStr = "Mecator";
                break;
            }
            case 3: {
                projStr = "NorthPolar";
                break;
            }
            case 4: {
                projStr = "SourthPolar";
            }
        }
        return projStr;
    }

    private String getImageType(int iType) {
        String imageType = "1\u2014\u7ea2\u5916\u4e91\u56fe 2\u2014\u96f7\u8fbe\u62fc\u56fe 3\u2014\u5730\u5f62\u56fe 4\u2014\u53ef\u89c1\u5149\u4e91\u56fe 5\u2014\u6c34\u6c7d\u56fe";
        switch (iType) {
            case 1: {
                imageType = "\u7ea2\u5916\u4e91\u56fe";
                break;
            }
            case 2: {
                imageType = "\u96f7\u8fbe\u62fc\u56fe";
                break;
            }
            case 3: {
                imageType = "\u5730\u5f62\u56fe";
                break;
            }
            case 4: {
                imageType = "\u53ef\u89c1\u5149\u4e91\u56fe";
                break;
            }
            case 5: {
                imageType = "\u6c34\u6c7d\u56fe";
            }
        }
        return imageType;
    }

    @Override
    public Array read(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.read(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        try {
            Section section = new Section(origin, size, stride);
            Array dataArray = Array.factory(DataType.INT, section.getShape());
            int rangeIdx = 1;
            Range yRange = section.getRange(rangeIdx++);
            Range xRange = section.getRange(rangeIdx);
            IndexIterator ii = dataArray.getIndexIterator();
            int xNum = this._xNum;
            for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
                for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                    int index = y * xNum + x;
                    ii.setIntNext(DataConvert.byte2Int(this._imageBytes[index]));
                }
            }
            return dataArray;
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(MICAPS4DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridArray getGridArray(String varName) {
        return null;
    }

    @Override
    public GridData getGridData_LonLat(int timeIdx, int varIdx, int levelIdx) {
        GridData gridData = new GridData();
        double[][] gData = new double[this._yNum][this._xNum];
        for (int i = 0; i < this._yNum; ++i) {
            for (int j = 0; j < this._xNum; ++j) {
                gData[i][j] = DataConvert.byte2Int(this._imageBytes[i * this._xNum + j]);
            }
        }
        gridData.data = gData;
        gridData.xArray = this.getXDimension().getValues();
        gridData.yArray = this.getYDimension().getValues();
        return gridData;
    }

    @Override
    public GridData getGridData_TimeLat(int lonIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_TimeLon(int latIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLat(int lonIdx, int varIdx, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLon(int latIdx, int varIdx, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelTime(int latIdx, int varIdx, int lonIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Time(int lonIdx, int latIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Level(int lonIdx, int latIdx, int varIdx, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lon(int timeIdx, int latIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lat(int timeIdx, int lonIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

