/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.netcdf;

import java.io.IOException;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IGridDataInfo;
import org.meteoinfo.data.meteodata.IStationDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.StationInfoData;
import org.meteoinfo.data.meteodata.StationModelData;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.netcdf.Conventions;
import org.meteoinfo.data.meteodata.netcdf.NCUtil;
import org.meteoinfo.data.meteodata.netcdf.TimeUnit;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.util.JDateUtil;
import org.meteoinfo.math.ArrayMath;
import org.meteoinfo.math.ArrayUtil;
import org.meteoinfo.ndarray.Dimension;
import org.meteoinfo.ndarray.DimensionType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.MAMath;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.Reproject;
import org.meteoinfo.projection.info.ProjectionInfo;
import ucar.ma2.Array;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.unidata.io.RandomAccessFile;

public class NetCDFDataInfo
extends DataInfo
implements IGridDataInfo,
IStationDataInfo {
    private String _fileTypeStr;
    private String _fileTypeId;
    private Conventions _convention = Conventions.CF;
    private NetcdfFile ncfile = null;
    private boolean keepOpen = false;
    private List<ucar.nc2.Variable> _variables = new ArrayList<ucar.nc2.Variable>();
    private List<ucar.nc2.Dimension> _dimensions = new ArrayList<ucar.nc2.Dimension>();
    private List<Dimension> dimensions = new ArrayList<Dimension>();
    private List<ucar.nc2.Attribute> _gAtts = new ArrayList<ucar.nc2.Attribute>();
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private ucar.nc2.Variable _xVar = null;
    private ucar.nc2.Variable _yVar = null;
    private ucar.nc2.Variable _levelVar = null;
    private ucar.nc2.Variable _timeVar = null;
    private boolean _isHDFEOS = false;
    private boolean _isSWATH = false;
    private boolean _isPROFILE = false;

    public NetCDFDataInfo() {
        this.setDataType(MeteoDataType.NetCDF);
    }

    public NetcdfFile getFile() {
        return this.ncfile;
    }

    @Override
    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public List<ucar.nc2.Dimension> getNCDimensions() {
        return this._dimensions;
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return this.attributes;
    }

    public List<ucar.nc2.Variable> getNCVariables() {
        return this._variables;
    }

    public String getFileTypeId() {
        return this._fileTypeId;
    }

    public boolean isHDFEOS() {
        return this._isHDFEOS;
    }

    public boolean isSWATH() {
        return this._isSWATH || this._isPROFILE;
    }

    public static boolean canOpen(String fileName) throws IOException {
        boolean r = NetcdfDataset.canOpen((String)fileName);
        if (!r) {
            RandomAccessFile raf = RandomAccessFile.acquire((String)fileName);
            r = H5header.isValidFile((RandomAccessFile)raf);
        }
        return r;
    }

    @Override
    public void readDataInfo(String fileName) {
        this.setFileName(fileName);
        try {
            this.ncfile = NetcdfDataset.openFile((String)fileName, null);
            this.readDataInfo(false);
        }
        catch (IOException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void readDataInfo(String fileName, MeteoDataType mdt) {
        this.setFileName(fileName);
        String iospClassName = "ucar.nc2.grib.collection.Grib2Iosp";
        switch (mdt) {
            case GRIB1: {
                iospClassName = "ucar.nc2.grib.collection.Grib1Iosp";
            }
        }
        try {
            this.ncfile = NetcdfFile.open((String)fileName, (String)iospClassName, (int)0, null, null);
            this.readDataInfo(false);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void readDataInfo(NetcdfFile nf, boolean keepOpen) {
        this.ncfile = nf;
        this.readDataInfo(keepOpen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDataInfo(boolean keepOpen) {
        try {
            String featureType;
            this._fileTypeStr = this.ncfile.getFileTypeDescription();
            this._fileTypeId = this.ncfile.getFileTypeId();
            this._variables = this.ncfile.getVariables();
            this._dimensions = this.ncfile.getDimensions();
            if (this._fileTypeId.equals("HDF5-EOS") || this._fileTypeId.equals("HDF4-EOS")) {
                this._isHDFEOS = true;
                ArrayList dimNames = new ArrayList();
                for (ucar.nc2.Variable var : this._variables) {
                    for (ucar.nc2.Dimension dim : var.getDimensions()) {
                        String dimName = dim.getShortName();
                        if (dimName == null || dimNames.contains(dimName)) continue;
                        dimNames.add(dimName);
                    }
                }
                for (ucar.nc2.Dimension dim : this._dimensions) {
                    if (!dim.getShortName().contains("_")) continue;
                    Iterator iterator = dimNames.iterator();
                    while (iterator.hasNext()) {
                        String dimName = (String)iterator.next();
                        if (!dim.getShortName().contains(dimName)) continue;
                        dim.setShortName(dimName);
                    }
                }
            }
            this.dimensions = new ArrayList<Dimension>();
            for (ucar.nc2.Dimension dimension : this._dimensions) {
                Dimension ndim = NCUtil.convertDimension(dimension);
                if (dimension.getShortName().equals("nXtrack")) {
                    ndim.setDimType(DimensionType.Xtrack);
                }
                this.dimensions.add(ndim);
            }
            this._gAtts = this.ncfile.getGlobalAttributes();
            switch (featureType = this.getGlobalAttStr("featureType")) {
                case "SWATH": {
                    this._isSWATH = true;
                    break;
                }
                case "PROFILE": {
                    this._isPROFILE = true;
                }
            }
            for (ucar.nc2.Attribute ncattr : this._gAtts) {
                this.attributes.add(NCUtil.convertAttribute(ncattr));
            }
            this._convention = this.getConvention();
            this.getProjection();
            this.getDimensionValues(this.ncfile);
            ArrayList<Variable> arrayList = new ArrayList<Variable>();
            for (ucar.nc2.Variable var : this._variables) {
                Variable nvar = NCUtil.convertVariable(var);
                nvar.setDimVar(var.getRank() <= 1);
                if (this._isSWATH || this._isPROFILE) {
                    nvar.setStation(true);
                }
                nvar.getDimensions().clear();
                for (ucar.nc2.Dimension dim : var.getDimensions()) {
                    Dimension ndim;
                    int idx = this.getDimensionIndex(dim);
                    if (idx >= 0) {
                        ndim = this.dimensions.get(idx);
                        nvar.addDimension(ndim);
                        continue;
                    }
                    ndim = NCUtil.convertDimension(dim);
                    ndim.setDimType(DimensionType.Other);
                    nvar.addDimension(ndim);
                }
                double[] packData = this.getPackData(var);
                nvar.setAddOffset(packData[0]);
                nvar.setScaleFactor(packData[1]);
                nvar.setFillValue(packData[2]);
                arrayList.add(nvar);
            }
            this.setVariables(arrayList);
        }
        catch (IOException | ParseException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.keepOpen = keepOpen;
            if (!keepOpen && null != this.ncfile) {
                try {
                    this.ncfile.close();
                    this.ncfile = null;
                }
                catch (IOException ex) {
                    Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    @Override
    public void readDataInfo(String fileName, boolean keepOpen) {
        try {
            this.setFileName(fileName);
            this.ncfile = NetcdfDataset.openFile((String)fileName, null);
            this.readDataInfo(keepOpen);
        }
        catch (IOException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private int getDimensionIndex(ucar.nc2.Dimension dim) {
        ucar.nc2.Dimension idim;
        int i;
        String name2 = dim.getShortName();
        if (name2 == null) {
            return -1;
        }
        for (i = 0; i < this._dimensions.size(); ++i) {
            idim = this._dimensions.get(i);
            if (!idim.getShortName().equals(name2)) continue;
            return i;
        }
        for (i = 0; i < this._dimensions.size(); ++i) {
            int len2;
            String name1;
            int len1;
            idim = this._dimensions.get(i);
            if (idim.getLength() != dim.getLength() || (len1 = (name1 = idim.getShortName()).length()) <= (len2 = name2.length()) || !name1.substring(len1 - len2).equals(name2)) continue;
            return i;
        }
        return -1;
    }

    public ucar.nc2.Dimension findNCDimension(String dimName) {
        for (ucar.nc2.Dimension dim : this._dimensions) {
            if (!dim.getShortName().equalsIgnoreCase(dimName)) continue;
            return dim;
        }
        return null;
    }

    public Dimension findDimension(String dimName) {
        for (Dimension dim : this.dimensions) {
            if (!dim.getShortName().equalsIgnoreCase(dimName)) continue;
            return dim;
        }
        return null;
    }

    public Attribute findGlobalAttribute(String attName) {
        for (Attribute att : this.attributes) {
            if (!att.getShortName().equalsIgnoreCase(attName)) continue;
            return att;
        }
        return null;
    }

    private Dimension findCoordDimension(ucar.nc2.Dimension dim) {
        if (dim.getShortName().equals(this.getXDimension().getShortName())) {
            return this.getXDimension();
        }
        if (dim.getShortName().equals(this.getYDimension().getShortName())) {
            return this.getYDimension();
        }
        if (dim.getShortName().equals(this.getZDimension().getShortName())) {
            return this.getZDimension();
        }
        if (dim.getShortName().equals(this.getTimeDimension().getShortName())) {
            return this.getTimeDimension();
        }
        return null;
    }

    private Conventions getConvention() {
        Conventions convention = this._convention;
        boolean isIOAPI = false;
        boolean isWRFOUT = false;
        for (ucar.nc2.Attribute aAtts : this._gAtts) {
            if (aAtts.getShortName().toLowerCase().equals("ioapi_version")) {
                isIOAPI = true;
                break;
            }
            if (aAtts.getShortName().toUpperCase().equals("TITLE")) {
                String title = aAtts.getStringValue();
                if (title.toUpperCase().contains("OUTPUT FROM WRF") || title.toUpperCase().contains("OUTPUT FROM GEOGRID") || title.toUpperCase().contains("OUTPUT FROM GRIDGEN") || title.toUpperCase().contains("OUTPUT FROM METGRID")) {
                    isWRFOUT = true;
                    break;
                }
                if (title.toUpperCase().contains("OUTPUT FROM") && title.toUpperCase().contains("WRF")) {
                    isWRFOUT = true;
                    break;
                }
            }
            if (!aAtts.getShortName().toUpperCase().equals("WEST-EAST_GRID_DIMENSION") || this.getGlobalAttStr("MAP_PROJ").isEmpty()) continue;
            isWRFOUT = true;
            break;
        }
        if (isIOAPI) {
            convention = Conventions.IOAPI;
        }
        if (isWRFOUT) {
            convention = Conventions.WRFOUT;
        }
        return convention;
    }

    private void getProjection() {
        ProjectionInfo projInfo = this.getProjectionInfo();
        switch (this._convention) {
            case CF: {
                projInfo = this.getProjection_CF();
                break;
            }
            case IOAPI: {
                projInfo = this.getProjection_IOAPI();
                break;
            }
            case WRFOUT: {
                projInfo = this.getProjection_WRFOUT();
            }
        }
        this.setProjectionInfo(projInfo);
    }

    private ProjectionInfo getProjection_CF() {
        ucar.nc2.Variable pVar;
        String projStr = this.getProjectionInfo().toProj4String();
        if (this._isHDFEOS) {
            pVar = null;
            for (ucar.nc2.Variable aVar : this._variables) {
                if (!aVar.getShortName().equals("_HDFEOS_CRS")) continue;
                pVar = aVar;
            }
            if (pVar != null) {
                ucar.nc2.Attribute projAtt = pVar.findAttributeIgnoreCase("Projection");
                String proj = projAtt.getStringValue();
                if (!proj.contains("GCTP_GEO")) {
                    ucar.nc2.Attribute paraAtt = pVar.findAttributeIgnoreCase("ProjParams");
                    org.meteoinfo.ndarray.Array params = NCUtil.convertArray(paraAtt.getValues());
                    if (proj.contains("GCTP_SNSOID")) {
                        projStr = "+proj=sinu+lon_0=" + params.getObject(4).toString() + "+a=" + params.getObject(0).toString() + "+b=" + params.getObject(0).toString();
                    } else if (proj.contains("GCTP_CEA")) {
                        projStr = "+proj=cea+lon_0=" + params.getObject(4).toString() + "+lat_ts=" + String.valueOf(params.getDouble(5) / 1000000.0);
                    }
                }
                ucar.nc2.Attribute ulAtt = pVar.findAttributeIgnoreCase("UpperLeftPointMtrs");
                ucar.nc2.Attribute lrAtt = pVar.findAttributeIgnoreCase("LowerRightMtrs");
                double xmin = ulAtt.getValues().getDouble(0);
                double ymax = ulAtt.getValues().getDouble(1);
                double xmax = lrAtt.getValues().getDouble(0);
                double ymin = lrAtt.getValues().getDouble(1);
                if (proj.contains("GCTP_GEO") && Math.abs(xmax) > 1000000.0) {
                    xmin /= 1000000.0;
                    xmax /= 1000000.0;
                    ymin /= 1000000.0;
                    ymax /= 1000000.0;
                }
                if (ymin > ymax) {
                    double temp = ymax;
                    ymax = ymin;
                    ymin = temp;
                    if (this._fileTypeId.equals("HDF5-EOS")) {
                        this.setYReverse(true);
                    }
                } else if (!this._fileTypeId.equals("HDF5-EOS")) {
                    this.setYReverse(true);
                }
                Dimension xDim = this.findDimension("XDim");
                Dimension yDim = this.findDimension("YDim");
                int xnum = xDim.getLength();
                int ynum = yDim.getLength();
                double xdelt = (xmax - xmin) / (double)xnum;
                double ydelt = (ymax - ymin) / (double)ynum;
                double[] X = new double[xnum];
                xmin += xdelt * 0.5;
                for (int i = 0; i < xnum; ++i) {
                    X[i] = xmin + xdelt * (double)i;
                }
                xDim.setDimType(DimensionType.X);
                xDim.setValues(X);
                this.setXDimension(xDim);
                double[] Y = new double[ynum];
                ymin += ydelt * 0.5;
                for (int i = 0; i < ynum; ++i) {
                    Y[i] = ymin + ydelt * (double)i;
                }
                yDim.setDimType(DimensionType.Y);
                yDim.setValues(Y);
                this.setYDimension(yDim);
            }
        } else {
            pVar = null;
            int pvIdx = -1;
            for (ucar.nc2.Variable aVarS : this._variables) {
                ucar.nc2.Attribute att = aVarS.findAttribute("grid_mapping_name");
                if (att == null) continue;
                pVar = aVarS;
                pvIdx = aVarS.getAttributes().indexOf(att);
                break;
            }
            if (pVar != null) {
                if (pVar.findAttribute("proj4") != null) {
                    projStr = pVar.findAttribute("proj4").getValue(0).toString();
                } else {
                    String attStr;
                    ucar.nc2.Attribute pAtt = (ucar.nc2.Attribute)pVar.getAttributes().get(pvIdx);
                    switch (attStr = pAtt.getStringValue()) {
                        case "albers_conical_equal_area": {
                            org.meteoinfo.ndarray.Array values = NCUtil.convertArray(pVar.findAttribute("standard_parallel").getValues());
                            String sp1 = String.valueOf(values.getDouble(0));
                            String sp2 = "";
                            if (values.getSize() == 2L) {
                                sp2 = String.valueOf(values.getDouble(1));
                            }
                            projStr = "+proj=aea+lat_1=" + sp1;
                            if (!sp2.isEmpty()) {
                                projStr = projStr + "+lat_2=" + sp2;
                            }
                            projStr = projStr + "+lon_0=" + pVar.findAttribute("longitude_of_central_meridian").getValue(0).toString() + "+lat_0=" + pVar.findAttribute("latitude_of_projection_origin").getValue(0).toString();
                            if (pVar.findAttribute("false_easting") != null) {
                                projStr = projStr + "+x_0=" + pVar.findAttribute("false_easting").getValue(0).toString();
                            }
                            if (pVar.findAttribute("false_northing") == null) break;
                            projStr = projStr + "+y_0=" + pVar.findAttribute("false_northing").getValue(0).toString();
                            break;
                        }
                        case "azimuthal_equidistant": {
                            projStr = "+proj=aeqd+lon_0=" + pVar.findAttribute("longitude_of_projection_origin").getValue(0).toString() + "+lat_0=" + pVar.findAttribute("latitude_of_projection_origin").getValue(0).toString();
                            if (pVar.findAttribute("false_easting") != null) {
                                projStr = projStr + "+x_0=" + pVar.findAttribute("false_easting").getValue(0).toString();
                            }
                            if (pVar.findAttribute("false_northing") == null) break;
                            projStr = projStr + "+y_0=" + pVar.findAttribute("false_northing").getValue(0).toString();
                            break;
                        }
                        case "lambert_azimuthal_equal_area": {
                            projStr = "+proj=laea+lon_0=" + pVar.findAttribute("longitude_of_projection_origin").getValue(0).toString() + "+lat_0=" + pVar.findAttribute("latitude_of_projection_origin").getValue(0).toString();
                            if (pVar.findAttribute("false_easting") != null) {
                                projStr = projStr + "+x_0=" + pVar.findAttribute("false_easting").getValue(0).toString();
                            }
                            if (pVar.findAttribute("false_northing") == null) break;
                            projStr = projStr + "+y_0=" + pVar.findAttribute("false_northing").getValue(0).toString();
                            break;
                        }
                        case "lambert_conformal_conic": {
                            org.meteoinfo.ndarray.Array values = NCUtil.convertArray(pVar.findAttribute("standard_parallel").getValues());
                            String sp1 = String.valueOf(values.getDouble(0));
                            String sp2 = "";
                            if (values.getSize() == 2L) {
                                sp2 = String.valueOf(values.getDouble(1));
                            }
                            projStr = "+proj=lcc+lat_1=" + sp1;
                            if (!sp2.isEmpty()) {
                                projStr = projStr + "+lat_2=" + sp2;
                            }
                            projStr = projStr + "+lon_0=" + pVar.findAttribute("longitude_of_central_meridian").getValue(0).toString() + "+lat_0=" + pVar.findAttribute("latitude_of_projection_origin").getValue(0).toString();
                            if (pVar.findAttribute("false_easting") != null) {
                                projStr = projStr + "+x_0=" + pVar.findAttribute("false_easting").getValue(0).toString();
                            }
                            if (pVar.findAttribute("false_northing") == null) break;
                            projStr = projStr + "+y_0=" + pVar.findAttribute("false_northing").getValue(0).toString();
                            break;
                        }
                        case "lambert_cylindrical_equal_area": {
                            projStr = "+proj=cea+lon_0=" + pVar.findAttribute("longitude_of_central_meridian").getValue(0).toString();
                            if (pVar.findAttribute("standard_parallel") != null) {
                                projStr = projStr + "+lat_ts=" + pVar.findAttribute("standard_parallel").getValue(0).toString();
                            } else if (pVar.findAttribute("scale_factor_at_projection_origin") != null) {
                                projStr = projStr + "+k_0=" + pVar.findAttribute("scale_factor_at_projection_origin").getValue(0).toString();
                            }
                            if (pVar.findAttribute("false_easting") != null) {
                                projStr = projStr + "+x_0=" + pVar.findAttribute("false_easting").getValue(0).toString();
                            }
                            if (pVar.findAttribute("false_northing") == null) break;
                            projStr = projStr + "+y_0=" + pVar.findAttribute("false_northing").getValue(0).toString();
                            break;
                        }
                        case "mercator": {
                            projStr = "+proj=merc+lon_0=" + pVar.findAttribute("longitude_of_projection_origin").getValue(0).toString();
                            if (pVar.findAttribute("standard_parallel") != null) {
                                projStr = projStr + "+lat_ts=" + pVar.findAttribute("standard_parallel").getValue(0).toString();
                            } else if (pVar.findAttribute("scale_factor_at_projection_origin") != null) {
                                projStr = projStr + "+k_0=" + pVar.findAttribute("scale_factor_at_projection_origin").getValue(0).toString();
                            }
                            if (pVar.findAttribute("false_easting") != null) {
                                projStr = projStr + "+x_0=" + pVar.findAttribute("false_easting").getValue(0).toString();
                            }
                            if (pVar.findAttribute("false_northing") == null) break;
                            projStr = projStr + "+y_0=" + pVar.findAttribute("false_northing").getValue(0).toString();
                            break;
                        }
                        case "orthographic": {
                            projStr = "+proj=ortho+lon_0=" + pVar.findAttribute("longitude_of_projection_origin").getValue(0).toString() + "+lat_0=" + pVar.findAttribute("latitude_of_projection_origin").getValue(0).toString();
                            if (pVar.findAttribute("false_easting") != null) {
                                projStr = projStr + "+x_0=" + pVar.findAttribute("false_easting").getValue(0).toString();
                            }
                            if (pVar.findAttribute("false_northing") == null) break;
                            projStr = projStr + "+y_0=" + pVar.findAttribute("false_northing").getValue(0).toString();
                            break;
                        }
                        case "polar_stereographic": {
                            projStr = "+proj=stere";
                            if (pVar.findAttribute("longitude_of_projection_origin") != null) {
                                projStr = projStr + "+lon_0=" + pVar.findAttribute("longitude_of_projection_origin").getValue(0).toString();
                            } else if (pVar.findAttribute("straight_vertical_longitude_from_pole") != null) {
                                projStr = projStr + "+lon_0=" + pVar.findAttribute("straight_vertical_longitude_from_pole").getValue(0).toString();
                            }
                            if (pVar.findAttribute("latitude_of_projection_origin") != null) {
                                projStr = projStr + "+lat_0=" + pVar.findAttribute("latitude_of_projection_origin").getValue(0).toString();
                            }
                            if (pVar.findAttribute("standard_parallel") != null) {
                                projStr = projStr + "+lat_ts=" + pVar.findAttribute("standard_parallel").getValue(0).toString();
                            }
                            if (pVar.findAttribute("scaling_factor") != null) {
                                projStr = projStr + "+k=" + pVar.findAttribute("scaling_factor").getValue(0).toString();
                            } else if (pVar.findAttribute("standard_parallel") != null) {
                                String stPs = pVar.findAttribute("standard_parallel").getValue(0).toString();
                                double k0 = ProjectionInfo.calScaleFactorFromStandardParallel(Double.parseDouble(stPs));
                                projStr = projStr + "+k=" + String.format("%1$.2f", k0);
                            } else if (pVar.findAttribute("scale_factor_at_projection_origin") != null) {
                                projStr = projStr + "+k_0=" + pVar.findAttribute("scale_factor_at_projection_origin").getValue(0).toString();
                            }
                            if (pVar.findAttribute("false_easting") != null) {
                                projStr = projStr + "+x_0=" + pVar.findAttribute("false_easting").getValue(0).toString();
                            }
                            if (pVar.findAttribute("false_northing") == null) break;
                            projStr = projStr + "+y_0=" + pVar.findAttribute("false_northing").getValue(0).toString();
                            break;
                        }
                        case "rotated_latitude_longitude": {
                            break;
                        }
                        case "stereographic": {
                            projStr = "+proj=stere+lon_0=" + pVar.findAttribute("longitude_of_projection_origin").getValue(0).toString() + "+lat_0=" + pVar.findAttribute("latitude_of_projection_origin").getValue(0).toString() + "+k_0=" + pVar.findAttribute("scale_factor_at_projection_origin").getValue(0).toString();
                            if (pVar.findAttribute("false_easting") != null) {
                                projStr = projStr + "+x_0=" + pVar.findAttribute("false_easting").getValue(0).toString();
                            }
                            if (pVar.findAttribute("false_northing") == null) break;
                            projStr = projStr + "+y_0=" + pVar.findAttribute("false_northing").getValue(0).toString();
                            break;
                        }
                        case "transverse_mercator": {
                            projStr = "+proj=tmerc+lon_0=" + pVar.findAttribute("longitude_of_central_meridian").getValue(0).toString() + "+lat_0=" + pVar.findAttribute("latitude_of_projection_origin").getValue(0).toString() + "+k_0=" + pVar.findAttribute("scale_factor_at_central_meridian").getValue(0).toString();
                            if (pVar.findAttribute("false_easting") != null) {
                                projStr = projStr + "+x_0=" + pVar.findAttribute("false_easting").getValue(0).toString();
                            }
                            if (pVar.findAttribute("false_northing") == null) break;
                            projStr = projStr + "+y_0=" + pVar.findAttribute("false_northing").getValue(0).toString();
                            break;
                        }
                        case "vertical_perspective": {
                            projStr = "+proj=geos+lon_0=" + pVar.findAttribute("longitude_of_projection_origin").getValue(0).toString() + "+lat_0=" + pVar.findAttribute("latitude_of_projection_origin").getValue(0).toString() + "+h=" + pVar.findAttribute("perspective_point_height").getValue(0).toString();
                            if (pVar.findAttribute("false_easting") != null) {
                                projStr = projStr + "+x_0=" + pVar.findAttribute("false_easting").getValue(0).toString();
                            }
                            if (pVar.findAttribute("false_northing") == null) break;
                            projStr = projStr + "+y_0=" + pVar.findAttribute("false_northing").getValue(0).toString();
                        }
                    }
                }
            }
        }
        try {
            ProjectionInfo projInfo = ProjectionInfo.factory(projStr);
            return projInfo;
        }
        catch (Exception e) {
            return KnownCoordinateSystems.geographic.world.WGS1984;
        }
    }

    private ProjectionInfo getProjection_IOAPI() {
        String projStr = this.getProjectionInfo().toProj4String();
        int gridType = Integer.parseInt(this.getGlobalAttStr("GDTYP"));
        switch (gridType) {
            case 1: {
                break;
            }
            case 2: {
                projStr = "+proj=lcc+lon_0=" + this.getGlobalAttStr("P_GAM") + "+lat_0=" + this.getGlobalAttStr("YCENT") + "+lat_1=" + this.getGlobalAttStr("P_ALP") + "+lat_2=" + this.getGlobalAttStr("P_BET");
                break;
            }
            case 3: {
                projStr = "+proj=omerc+lat_0=" + this.getGlobalAttStr("P_ALP") + "+lonc=" + this.getGlobalAttStr("P_BET") + "+alpha=" + this.getGlobalAttStr("P_GAM");
                break;
            }
            case 4: {
                projStr = "+proj=stere+lon_0=" + this.getGlobalAttStr("P_BET") + "+lat_0=" + this.getGlobalAttStr("P_ALP");
                break;
            }
            case 5: {
                projStr = "+proj=utm+zone=" + this.getGlobalAttStr("P_ALP");
                break;
            }
            case 6: {
                String lat0 = "90";
                if (this.getGlobalAttStr("P_ALP").substring(0, 1).equals("-")) {
                    lat0 = "-90";
                }
                projStr = "+proj=stere+lon_0=" + this.getGlobalAttStr("P_GAM") + "+lat_0=" + lat0;
                String stPs = this.getGlobalAttStr("P_BET");
                double k0 = ProjectionInfo.calScaleFactorFromStandardParallel(Double.parseDouble(stPs));
                projStr = projStr + "+k=" + String.valueOf(k0);
                break;
            }
            case 7: {
                projStr = "+proj=merc+lat_ts=" + this.getGlobalAttStr("P_ALP") + "+lon_0=" + this.getGlobalAttStr("P_GAM");
                break;
            }
            case 8: {
                projStr = "+proj=tmerc+lon_0=" + this.getGlobalAttStr("P_GAM") + "+lat_0=" + this.getGlobalAttStr("P_ALP");
                break;
            }
            case 9: {
                projStr = "+proj=aea+lat_1=" + this.getGlobalAttStr("P_ALP") + "+lat_2=" + this.getGlobalAttStr("P_BET") + "+lat_0=" + this.getGlobalAttStr("YCENT") + "+lon_0=" + this.getGlobalAttStr("P_GAM");
                break;
            }
            case 10: {
                projStr = "+proj=laea+lat_0=" + this.getGlobalAttStr("P_ALP") + "+lon_0=" + this.getGlobalAttStr("P_GAM");
            }
        }
        return ProjectionInfo.factory(projStr);
    }

    private ProjectionInfo getProjection_WRFOUT() {
        String projStr = this.getProjectionInfo().toProj4String();
        String pstr = this.getGlobalAttStr("MAP_PROJ");
        if (pstr.isEmpty()) {
            return this.getProjectionInfo();
        }
        int mapProj = Integer.parseInt(pstr);
        String lon_0 = this.getGlobalAttStr("STAND_LON");
        if (lon_0.isEmpty()) {
            lon_0 = this.getGlobalAttStr("CEN_LON");
        }
        switch (mapProj) {
            case 1: {
                projStr = "+proj=lcc+lon_0=" + lon_0 + "+lat_0=" + this.getGlobalAttStr("CEN_LAT") + "+lat_1=" + this.getGlobalAttStr("TRUELAT1") + "+lat_2=" + this.getGlobalAttStr("TRUELAT2");
                break;
            }
            case 2: {
                String lat0 = "90";
                if (this.getGlobalAttStr("POLE_LAT").substring(0, 1).equals("-")) {
                    lat0 = "-90";
                }
                projStr = "+proj=stere+lon_0=" + lon_0 + "+lat_0=" + lat0;
                String stPs = this.getGlobalAttStr("CEN_LAT");
                double k0 = ProjectionInfo.calScaleFactorFromStandardParallel(Double.parseDouble(stPs));
                projStr = projStr + "+k=" + String.valueOf(k0);
                break;
            }
            case 3: {
                projStr = "+proj=merc+lat_ts=" + this.getGlobalAttStr("CEN_LAT") + "+lon_0=" + lon_0;
            }
        }
        ProjectionInfo projInfo = ProjectionInfo.factory(projStr);
        return projInfo;
    }

    private String getGlobalAttStr(String attName) {
        String attStr = "";
        for (ucar.nc2.Attribute aAttS : this._gAtts) {
            if (!aAttS.getShortName().equals(attName)) continue;
            attStr = aAttS.getValue(0).toString();
            break;
        }
        return attStr;
    }

    private List<LocalDateTime> getTimes(ucar.nc2.Variable aVar, org.meteoinfo.ndarray.Array values) {
        ArrayList<LocalDateTime> times = new ArrayList<LocalDateTime>();
        ucar.nc2.Attribute unitAtt = aVar.findAttribute("units");
        if (unitAtt == null) {
            LocalDateTime sTime = LocalDateTime.of(1985, 1, 1, 0, 0);
            IndexIterator ii = values.getIndexIterator();
            while (ii.hasNext()) {
                times.add(sTime.plusHours(ii.getIntNext()));
            }
            return times;
        }
        String unitsStr = unitAtt.getStringValue();
        if (unitsStr.contains("as")) {
            if (unitsStr.contains("%")) {
                return null;
            }
            DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMdd");
            int i = 0;
            while ((long)i < values.getSize()) {
                String md = String.valueOf(values.getInt(i));
                if (md.length() <= 3) {
                    md = "0" + md;
                }
                times.add(LocalDateTime.parse(md, format));
                ++i;
            }
        } else {
            TimeUnit aTU;
            LocalDateTime sTime = LocalDateTime.now();
            if (unitsStr.equalsIgnoreCase("month")) {
                sTime = LocalDateTime.of(sTime.getYear(), 1, 1, 0, 0, 0);
                aTU = TimeUnit.Month;
            } else {
                aTU = this.getTimeUnit(unitsStr);
                sTime = this.getStartTime(unitsStr);
            }
            int i = 0;
            while ((long)i < values.getSize()) {
                switch (aTU) {
                    case Year: {
                        times.add(sTime.plusYears(values.getInt(i)));
                        break;
                    }
                    case Month: {
                        times.add(sTime.plusMonths(values.getInt(i)));
                        break;
                    }
                    case Day: {
                        times.add(sTime.plusDays(values.getInt(i)));
                        break;
                    }
                    case Hour: {
                        if (sTime.getYear() == 1 && sTime.getMonthValue() == 1 && sTime.getDayOfMonth() == 1 && values.getInt(i) > 48) {
                            times.add(sTime.plusHours(values.getInt(i) - 48));
                            break;
                        }
                        times.add(sTime.plusHours(values.getInt(i)));
                        break;
                    }
                    case Minute: {
                        times.add(sTime.plusMinutes(values.getInt(i)));
                        break;
                    }
                    case Second: {
                        times.add(sTime.plusSeconds(values.getInt(i)));
                    }
                }
                ++i;
            }
        }
        return times;
    }

    private boolean getDimensionValues(NetcdfFile ncfile) throws IOException, ParseException {
        switch (this._convention) {
            case CF: {
                if (this._isHDFEOS) {
                    this.getDimValues_HDFEOS_SWATH();
                    break;
                }
                this.getDimValues_CF();
                if (this.getXDimension() != null && this.getYDimension() != null || this.findNCVariable("Longitude") == null || this.findNCVariable("Latitude") == null) break;
                this._isSWATH = true;
                break;
            }
            case IOAPI: {
                this.getDimValues_IOAPI();
                break;
            }
            case WRFOUT: {
                this.getDimValues_WRF(ncfile);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void getDimValues_HDFEOS_SWATH() throws IOException {
        if (this._isSWATH || this._isPROFILE) {
            org.meteoinfo.ndarray.Array darray;
            ucar.nc2.Variable var = this.findNCVariable("Pressure");
            if (var != null) {
                darray = NCUtil.convertArray(var.read());
                int n = (int)darray.getSize();
                double[] values = new double[n];
                for (int i = 0; i < n; ++i) {
                    values[i] = darray.getDouble(i);
                }
                Dimension zDim = this.findDimension(var.getDimension(0).getShortName());
                zDim.setDimType(DimensionType.Z);
                zDim.setValues(values);
                this.setZDimension(zDim);
            }
            if ((var = this.findNCVariable("Time")) != null && var.getDimensions().size() == 1) {
                darray = NCUtil.convertArray(var.read());
                List<LocalDateTime> times = this.getTimes(var, darray);
                ArrayList<Double> ts = new ArrayList<Double>();
                for (LocalDateTime t : times) {
                    ts.add(JDateUtil.toOADate(t));
                }
                Dimension tDim = this.findDimension(var.getDimension(0).getShortName());
                if (tDim != null) {
                    tDim.setDimType(DimensionType.T);
                    tDim.setValues(ts);
                    this.setTimeDimension(tDim);
                }
            }
        }
    }

    private void getDimValues_CF() throws IOException {
        block10: for (ucar.nc2.Variable var : this._variables) {
            Dimension dim;
            int idx;
            if (var.getRank() != 1 || !var.getDataType().isNumeric() || (idx = this.getDimensionIndex(var.getDimension(0))) == -1 || (dim = this.dimensions.get(idx)).getDimType() != DimensionType.Other) continue;
            DimensionType dimType = this.getDimType(var);
            dim.setDimType(dimType);
            org.meteoinfo.ndarray.Array values = NCUtil.convertArray(var.read());
            if (values.getSize() > 1L && values.getDouble(0) > values.getDouble(1)) {
                switch (dimType) {
                    case X: {
                        this.setXReverse(true);
                        dim.setReverse(true);
                        values = values.flip(0);
                        break;
                    }
                    case Y: {
                        this.setYReverse(true);
                        dim.setReverse(true);
                        values = values.flip(0);
                    }
                }
            }
            switch (dimType) {
                case X: {
                    double[] X = (double[])ArrayUtil.copyToNDJavaArray_Double(values);
                    double XDelt = X[1] - X[0];
                    if (this.getProjectionInfo().isLonLat()) {
                        if (X[X.length - 1] + XDelt - X[0] == 360.0) {
                            this.setGlobal(true);
                        }
                    } else {
                        ucar.nc2.Attribute unitAtt = var.findAttribute("units");
                        if (unitAtt != null && unitAtt.getStringValue().trim().toLowerCase().equals("km")) {
                            for (int i = 0; i < X.length; ++i) {
                                X[i] = X[i] * 1000.0;
                            }
                        }
                    }
                    dim.setValues(X);
                    this.setXDimension(dim);
                    continue block10;
                }
                case Y: {
                    ucar.nc2.Attribute unitAtt;
                    double[] Y = (double[])ArrayUtil.copyToNDJavaArray_Double(values);
                    if (!this.getProjectionInfo().isLonLat() && (unitAtt = var.findAttribute("units")) != null && unitAtt.getStringValue().trim().toLowerCase().equals("km")) {
                        for (int i = 0; i < Y.length; ++i) {
                            Y[i] = Y[i] * 1000.0;
                        }
                    }
                    dim.setValues(Y);
                    this.setYDimension(dim);
                    continue block10;
                }
                case Z: {
                    double[] levels = (double[])ArrayUtil.copyToNDJavaArray_Double(values);
                    dim.setValues(levels);
                    this.setZDimension(dim);
                    continue block10;
                }
                case T: {
                    List<LocalDateTime> times = this.getTimes(var, values);
                    if (times != null) {
                        ArrayList<Double> ts = new ArrayList<Double>();
                        for (LocalDateTime t : times) {
                            ts.add(JDateUtil.toOADate(t));
                        }
                        dim.setValues(ts);
                    }
                    this.setTimeDimension(dim);
                    continue block10;
                }
            }
            dim.setValues((double[])ArrayUtil.copyToNDJavaArray_Double(values));
        }
    }

    private void getDimValues_IOAPI() {
        int i;
        String sDateStr = this.getGlobalAttStr("SDATE");
        String sTimeStr = this.getGlobalAttStr("STIME");
        int len = sTimeStr.length();
        LocalDateTime tt = LocalDateTime.now();
        try {
            tt = LocalDateTime.of(Integer.parseInt(sDateStr.substring(0, 4)), 1, 1, 0, 0, 0);
            if (MIMath.isNumeric(sDateStr.substring(4))) {
                tt = tt.plusDays(Integer.parseInt(sDateStr.substring(4)) - 1);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        if (sTimeStr.length() <= 2) {
            tt = tt.plusSeconds(Integer.parseInt(sTimeStr));
        } else if (sTimeStr.length() <= 4) {
            tt = tt.plusMinutes(Integer.parseInt(sTimeStr.substring(0, len - 2)));
            tt = tt.plusSeconds(Integer.parseInt(sTimeStr.substring(len - 2)));
        } else {
            tt = tt.plusHours(Integer.parseInt(sTimeStr.substring(0, len - 4)));
            tt = tt.plusMinutes(Integer.parseInt(sTimeStr.substring(len - 4, len - 2)));
            tt = tt.plusSeconds(Integer.parseInt(sTimeStr.substring(len - 2)));
        }
        int tNum = this.getDimensionLength("TSTEP");
        sTimeStr = this.getGlobalAttStr("TSTEP");
        len = sTimeStr.length();
        ArrayList<LocalDateTime> times = new ArrayList<LocalDateTime>();
        times.add(tt);
        for (i = 1; i < tNum; ++i) {
            if (sTimeStr.length() <= 2) {
                tt = tt.plusSeconds(Integer.parseInt(sTimeStr));
            } else if (sTimeStr.length() <= 4) {
                tt = tt.plusMinutes(Integer.parseInt(sTimeStr.substring(0, len - 2)));
                tt = tt.plusSeconds(Integer.parseInt(sTimeStr.substring(len - 2)));
            } else {
                tt = tt.plusHours(Integer.parseInt(sTimeStr.substring(0, len - 4)));
                tt = tt.plusMinutes(Integer.parseInt(sTimeStr.substring(len - 4, len - 2)));
                tt = tt.plusSeconds(Integer.parseInt(sTimeStr.substring(len - 2)));
            }
            times.add(tt);
        }
        ArrayList<Double> values = new ArrayList<Double>();
        for (LocalDateTime t : times) {
            values.add(JDateUtil.toOADate(t));
        }
        Dimension tDim = this.findDimension("TSTEP");
        if (tDim != null) {
            tDim.setDimType(DimensionType.T);
            tDim.setValues(values);
            this.setTimeDimension(tDim);
        }
        Attribute levAtt = this.findGlobalAttribute("VGLVLS");
        org.meteoinfo.ndarray.Array array = levAtt.getValues();
        int znum = (int)array.getSize() - 1;
        double[] levels = new double[znum];
        for (i = 0; i < znum; ++i) {
            levels[i] = (array.getDouble(i) + array.getDouble(i + 1)) / 2.0;
        }
        Dimension zDim = this.findDimension("LAY");
        if (zDim != null) {
            zDim.setDimType(DimensionType.Z);
            zDim.setValues(levels);
            this.setZDimension(zDim);
        }
        int xNum = Integer.parseInt(this.getGlobalAttStr("NCOLS"));
        double[] X = new double[xNum];
        double sx = Double.parseDouble(this.getGlobalAttStr("XORIG"));
        double XDelt = Double.parseDouble(this.getGlobalAttStr("XCELL"));
        for (i = 0; i < xNum; ++i) {
            X[i] = sx + XDelt * (double)i;
        }
        Dimension xDim = this.findDimension("COL");
        if (xDim != null) {
            xDim.setDimType(DimensionType.X);
            xDim.setValues(X);
            this.setXDimension(xDim);
        }
        int yNum = Integer.parseInt(this.getGlobalAttStr("NROWS"));
        double[] Y = new double[yNum];
        double sy = Double.parseDouble(this.getGlobalAttStr("YORIG"));
        double YDelt = Double.parseDouble(this.getGlobalAttStr("YCELL"));
        for (i = 0; i < yNum; ++i) {
            Y[i] = sy + YDelt * (double)i;
        }
        Dimension yDim = this.findDimension("ROW");
        if (yDim != null) {
            yDim.setDimType(DimensionType.Y);
            yDim.setValues(Y);
            this.setYDimension(yDim);
        }
    }

    private void getDimValues_WRF(NetcdfFile ncfile) throws ParseException, IOException {
        org.meteoinfo.ndarray.Array larray;
        double orgY;
        double orgX;
        int i;
        int dimLen;
        Dimension xDim = this.findDimension("west_east");
        Dimension yDim = this.findDimension("south_north");
        if (xDim == null || yDim == null) {
            return;
        }
        xDim.setDimType(DimensionType.X);
        yDim.setDimType(DimensionType.Y);
        int xNum = xDim.getLength();
        int yNum = yDim.getLength();
        this._yVar = ncfile.findVariable("XLAT");
        if (this._yVar == null) {
            this._yVar = ncfile.findVariable("XLAT_M");
        }
        this._xVar = ncfile.findVariable("XLONG");
        if (this._xVar == null) {
            this._xVar = ncfile.findVariable("XLONG_M");
        }
        this._levelVar = ncfile.findVariable("ZNU");
        double dx = Double.parseDouble(this.getGlobalAttStr("DX"));
        double dy = Double.parseDouble(this.getGlobalAttStr("DY"));
        ProjectionInfo fromProj = KnownCoordinateSystems.geographic.world.WGS1984;
        double[][] points = new double[1][];
        if (this._yVar != null && this._xVar != null) {
            dimLen = yNum;
            org.meteoinfo.ndarray.Array yarray = NCUtil.convertArray(this._yVar.read().reduce());
            double[] xlat = new double[dimLen];
            for (i = 0; i < dimLen; ++i) {
                xlat[i] = yarray.getDouble(i);
            }
            double orgLat = xlat[0];
            dimLen = xNum;
            org.meteoinfo.ndarray.Array xarray = NCUtil.convertArray(this._xVar.read().reduce());
            double[] xlon = new double[dimLen];
            for (i = 0; i < dimLen; ++i) {
                xlon[i] = xarray.getDouble(i);
            }
            double orgLon = xlon[0];
            points[0] = new double[]{orgLon, orgLat};
            Reproject.reprojectPoints(points, fromProj, this.getProjectionInfo(), 0, 1);
            orgX = points[0][0];
            orgY = points[0][1];
        } else {
            double clon = Double.parseDouble(this.getGlobalAttStr("CEN_LON"));
            double clat = Double.parseDouble(this.getGlobalAttStr("CEN_LAT"));
            points[0] = new double[]{clon, clat};
            Reproject.reprojectPoints(points, fromProj, this.getProjectionInfo(), 0, 1);
            double cx = points[0][0];
            double cy = points[0][1];
            orgX = cx - dx * (double)xNum * 0.5;
            orgY = cy - dy * (double)yNum * 0.5;
        }
        double[] X = new double[xNum];
        for (i = 0; i < xNum; ++i) {
            X[i] = orgX + dx * (double)i;
        }
        xDim.setValues(X);
        this.setXDimension(xDim);
        double[] Y = new double[yNum];
        for (i = 0; i < yNum; ++i) {
            Y[i] = orgY + dy * (double)i;
        }
        yDim.setValues(Y);
        this.setYDimension(yDim);
        Dimension zDim = this.findDimension("bottom_up");
        if (zDim == null) {
            zDim = this.findDimension("bottom_top");
        }
        if (zDim != null) {
            int lNum = zDim.getLength();
            if (this._levelVar != null) {
                dimLen = lNum;
                org.meteoinfo.ndarray.Array larray2 = NCUtil.convertArray(this._levelVar.read().reduce());
                double[] levels = new double[lNum];
                for (i = 0; i < lNum && i < dimLen; ++i) {
                    levels[i] = larray2.getDouble(i);
                }
                zDim.setDimType(DimensionType.Z);
                zDim.setValues(levels);
                this.setZDimension(zDim);
            }
        }
        if ((zDim = this.findDimension("bottom_up_stag")) == null) {
            zDim = this.findDimension("bottom_top_stag");
        }
        if (zDim != null) {
            int lNum = zDim.getLength();
            ucar.nc2.Variable levelVar = ncfile.findVariable("ZNW");
            if (levelVar != null) {
                dimLen = lNum;
                larray = NCUtil.convertArray(levelVar.read().reduce());
                double[] levels = new double[lNum];
                for (i = 0; i < lNum && i < dimLen; ++i) {
                    levels[i] = larray.getDouble(i);
                }
                zDim.setDimType(DimensionType.Z);
                zDim.setValues(levels);
            }
        }
        if ((zDim = this.findDimension("soil_layers_stag")) != null) {
            int lNum = zDim.getLength();
            ucar.nc2.Variable levelVar = ncfile.findVariable("ZS");
            if (levelVar != null) {
                dimLen = lNum;
                larray = NCUtil.convertArray(levelVar.read().reduce());
                double[] levels = new double[lNum];
                for (i = 0; i < lNum && i < dimLen; ++i) {
                    levels[i] = larray.getDouble(i);
                }
                zDim.setDimType(DimensionType.Z);
                zDim.setValues(levels);
            }
        }
        for (ucar.nc2.Variable aVarS : this._variables) {
            if (!aVarS.getShortName().toLowerCase().equals("times") || aVarS.getRank() != 2) continue;
            Dimension tDim = this.findDimension("Time");
            int tNum = tDim.getLength();
            ucar.nc2.Dimension tsDim = ncfile.findDimension("DateStrLen");
            int strLen = tsDim.getLength();
            char[] charData = new char[tNum * strLen];
            org.meteoinfo.ndarray.Array tarray = NCUtil.convertArray(aVarS.read());
            for (i = 0; i < tNum * strLen; ++i) {
                charData[i] = tarray.getChar(i);
            }
            DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH:mm:ss");
            ArrayList<LocalDateTime> times = new ArrayList<LocalDateTime>();
            for (i = 0; i < tNum; ++i) {
                StringBuilder timeStr = new StringBuilder();
                for (int j = 0; j < strLen; ++j) {
                    timeStr.append(charData[i * strLen + j]);
                }
                String tStr = timeStr.toString();
                if (tStr.contains("0000-00-00")) {
                    tStr = "0001-01-01_00:00:00";
                }
                times.add(LocalDateTime.parse(tStr, format));
            }
            ArrayList<Double> values = new ArrayList<Double>();
            for (LocalDateTime t : times) {
                values.add(JDateUtil.toOADate(t));
            }
            tDim.setDimType(DimensionType.T);
            tDim.setValues(values);
            this.setTimeDimension(tDim);
            break;
        }
        Dimension xsdim = this.findDimension("west_east_stag");
        Dimension ysdim = this.findDimension("south_north_stag");
        if (xsdim != null && ysdim != null) {
            xsdim.setDimType(DimensionType.X);
            double[] nX = new double[xNum + 1];
            double norgX = orgX - dx * 0.5;
            for (i = 0; i <= xNum; ++i) {
                nX[i] = norgX + dx * (double)i;
            }
            xsdim.setValues(nX);
            ysdim.setDimType(DimensionType.Y);
            double[] nY = new double[yNum + 1];
            double norgY = orgY - dx * 0.5;
            for (i = 0; i <= yNum; ++i) {
                nY[i] = norgY + dy * (double)i;
            }
            ysdim.setValues(nY);
        }
    }

    private int getDimensionLength(String dimName) {
        for (ucar.nc2.Dimension aDimS : this._dimensions) {
            if (!aDimS.getShortName().equals(dimName)) continue;
            return aDimS.getLength();
        }
        return -1;
    }

    private int getVarLength(Variable aVarS) {
        int dataLen = 1;
        for (int i = 0; i < aVarS.getDimNumber(); ++i) {
            dataLen *= aVarS.getDimensions().get(i).getLength();
        }
        return dataLen;
    }

    public ucar.nc2.Variable findNCVariable(String name) {
        for (ucar.nc2.Variable var : this._variables) {
            if (!var.getShortName().equalsIgnoreCase(name)) continue;
            return var;
        }
        return null;
    }

    private DimensionType getDimType(ucar.nc2.Variable aVar) {
        DimensionType dimType = DimensionType.Other;
        if (this._fileTypeId.equals("HDF5-EOS")) {
            String sName;
            switch (sName = aVar.getShortName().toLowerCase()) {
                case "longitude": {
                    dimType = DimensionType.X;
                    break;
                }
                case "latitude": {
                    dimType = DimensionType.Y;
                    break;
                }
                case "pressure": {
                    dimType = DimensionType.Z;
                    break;
                }
                case "time": {
                    dimType = DimensionType.T;
                }
            }
        } else {
            String sName;
            Object axisAtt;
            if (aVar.findAttributeIgnoreCase("standard_name") != null) {
                axisAtt = aVar.findAttributeIgnoreCase("standard_name");
                switch (sName = axisAtt.getStringValue().trim().toLowerCase()) {
                    case "longitude": 
                    case "projection_x_coordinate": 
                    case "longitude_east": {
                        dimType = DimensionType.X;
                        break;
                    }
                    case "latitude": 
                    case "projection_y_coordinate": 
                    case "latitude_north": {
                        dimType = DimensionType.Y;
                        break;
                    }
                    case "time": {
                        dimType = DimensionType.T;
                        break;
                    }
                    case "level": {
                        dimType = DimensionType.Z;
                    }
                }
            }
            if (dimType == DimensionType.Other && aVar.findAttributeIgnoreCase("long_name") != null) {
                axisAtt = aVar.findAttributeIgnoreCase("long_name");
                switch (sName = axisAtt.getStringValue().trim().toLowerCase()) {
                    case "longitude": 
                    case "coordinate longitude": 
                    case "x": {
                        dimType = DimensionType.X;
                        break;
                    }
                    case "latitude": 
                    case "coordinate latitude": 
                    case "y": {
                        dimType = DimensionType.Y;
                        break;
                    }
                    case "time": 
                    case "initial time": {
                        dimType = DimensionType.T;
                        break;
                    }
                    case "level": 
                    case "pressure": 
                    case "pressure_level": 
                    case "isobaric surface": {
                        dimType = DimensionType.Z;
                        break;
                    }
                    default: {
                        if (!sName.contains("level") && !sName.contains("depths")) break;
                        dimType = DimensionType.Z;
                    }
                }
            }
            if (dimType == DimensionType.Other && aVar.findAttributeIgnoreCase("axis") != null) {
                axisAtt = aVar.findAttributeIgnoreCase("axis");
                switch (sName = axisAtt.getStringValue().trim().toLowerCase()) {
                    case "x": {
                        dimType = DimensionType.X;
                        break;
                    }
                    case "y": {
                        dimType = DimensionType.Y;
                        break;
                    }
                    case "z": {
                        dimType = DimensionType.Z;
                        break;
                    }
                    case "t": {
                        dimType = DimensionType.T;
                    }
                }
            }
            if (dimType == DimensionType.Other && aVar.findAttributeIgnoreCase("GRIB_level_type") != null) {
                dimType = DimensionType.Z;
            }
            if (dimType == DimensionType.Other && aVar.findAttributeIgnoreCase("Grib2_level_type") != null) {
                dimType = DimensionType.Z;
            }
            if (dimType == DimensionType.Other && aVar.findAttributeIgnoreCase("hybrid_layer") != null) {
                dimType = DimensionType.Z;
            }
            if (dimType == DimensionType.Other && aVar.findAttributeIgnoreCase("unitsCategory") != null) {
                sName = aVar.findAttributeIgnoreCase("unitsCategory").getStringValue().trim().toLowerCase();
                switch (sName) {
                    case "longitude": {
                        dimType = DimensionType.X;
                        break;
                    }
                    case "latitude": {
                        dimType = DimensionType.Y;
                    }
                }
            }
            if (dimType == DimensionType.Other) {
                String vName;
                switch (vName = aVar.getShortName().toLowerCase()) {
                    case "lon": 
                    case "longitude": 
                    case "x": {
                        dimType = DimensionType.X;
                        break;
                    }
                    case "lat": 
                    case "latitude": 
                    case "y": {
                        dimType = DimensionType.Y;
                        break;
                    }
                    case "time": {
                        dimType = DimensionType.T;
                        break;
                    }
                    case "level": 
                    case "lev": 
                    case "height": 
                    case "isobaric": 
                    case "pressure": 
                    case "depth": {
                        dimType = DimensionType.Z;
                    }
                }
            }
        }
        return dimType;
    }

    private TimeUnit getTimeUnit(String tStr) {
        TimeUnit aTU = TimeUnit.Second;
        String[] dataArray = (tStr = tStr.trim()).split("\\s+");
        if (dataArray.length < 2) {
            return aTU;
        }
        String tu = dataArray[0];
        if (tu.toLowerCase().contains("second")) {
            aTU = TimeUnit.Second;
        } else if (tu.length() == 1) {
            String str;
            switch (str = tu.toLowerCase()) {
                case "y": {
                    aTU = TimeUnit.Year;
                    break;
                }
                case "d": {
                    aTU = TimeUnit.Day;
                    break;
                }
                case "h": {
                    aTU = TimeUnit.Hour;
                    break;
                }
                case "s": {
                    aTU = TimeUnit.Second;
                }
            }
        } else {
            String str;
            switch (str = tu.toLowerCase().substring(0, 2)) {
                case "yr": 
                case "ye": {
                    aTU = TimeUnit.Year;
                    break;
                }
                case "mo": {
                    aTU = TimeUnit.Month;
                    break;
                }
                case "da": {
                    aTU = TimeUnit.Day;
                    break;
                }
                case "hr": 
                case "ho": {
                    aTU = TimeUnit.Hour;
                    break;
                }
                case "mi": {
                    aTU = TimeUnit.Minute;
                    break;
                }
                case "se": {
                    aTU = TimeUnit.Second;
                }
            }
        }
        return aTU;
    }

    private LocalDateTime getStartTime(String tStr) {
        LocalDateTime sTime = LocalDateTime.now();
        String[] dataArray = (tStr = tStr.trim()).split("\\s+");
        if (dataArray.length < 3) {
            return sTime;
        }
        String ST = dataArray[2];
        if (ST.contains("T")) {
            dataArray = Arrays.copyOf(dataArray, dataArray.length + 1);
            dataArray[dataArray.length - 1] = ST.split("T")[1];
            ST = ST.split("T")[0];
        }
        int year = 2000;
        int month = 1;
        int day = 1;
        int hour = 0;
        int min = 0;
        int sec = 0;
        if (ST.contains("-")) {
            String[] darray1 = ST.split("-");
            year = Integer.parseInt(darray1[0]);
            month = Integer.parseInt(darray1[1]);
            if (darray1[2].length() > 2) {
                darray1[2] = darray1[2].substring(0, 2);
            }
            day = Integer.parseInt(darray1[2]);
            if (dataArray.length >= 4) {
                String hmsStr = dataArray[3];
                hmsStr = hmsStr.replace("0.0", "00");
                try {
                    String[] hms = hmsStr.split(":");
                    hour = Integer.parseInt(hms[0]);
                    if (hms.length > 1) {
                        min = Integer.parseInt(hms[1]);
                    }
                    if (hms.length > 2) {
                        sec = Integer.parseInt(hms[2]);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (ST.contains(":")) {
            String hmsStr = ST;
            hmsStr = hmsStr.replace("0.0", "00");
            try {
                String[] hms = hmsStr.split(":");
                hour = Integer.parseInt(hms[0]);
                if (hms.length > 1) {
                    min = Integer.parseInt(hms[1]);
                }
                if (hms.length > 2) {
                    sec = Integer.parseInt(hms[2]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (year == 0) {
            year = 1;
        }
        sTime = LocalDateTime.of(year, month, day, hour, min, sec);
        return sTime;
    }

    @Override
    public String generateInfoText() {
        String dataInfo;
        block7: {
            ucar.nc2.Dimension dim;
            ucar.nc2.Attribute aAttS;
            Dimension ydim;
            int i;
            dataInfo = "File Name: " + this.getFileName();
            dataInfo = dataInfo + System.getProperty("line.separator") + "File type: " + this._fileTypeStr + " (" + this._fileTypeId + ")";
            dataInfo = dataInfo + System.getProperty("line.separator") + "Dimensions: " + this._dimensions.size();
            for (i = 0; i < this._dimensions.size(); ++i) {
                dataInfo = dataInfo + System.getProperty("line.separator") + "\t" + this._dimensions.get(i).getShortName() + " = " + String.valueOf(this._dimensions.get(i).getLength()) + ";";
            }
            Dimension xdim = this.getXDimension();
            if (xdim != null) {
                dataInfo = dataInfo + System.getProperty("line.separator") + "X Dimension: Xmin = " + String.valueOf(xdim.getMinValue()) + "; Xmax = " + String.valueOf(xdim.getMaxValue()) + "; Xsize = " + String.valueOf(xdim.getLength()) + "; Xdelta = " + String.valueOf(xdim.getDeltaValue());
            }
            if ((ydim = this.getYDimension()) != null) {
                dataInfo = dataInfo + System.getProperty("line.separator") + "Y Dimension: Ymin = " + String.valueOf(ydim.getMinValue()) + "; Ymax = " + String.valueOf(ydim.getMaxValue()) + "; Ysize = " + String.valueOf(ydim.getLength()) + "; Ydelta = " + String.valueOf(ydim.getDeltaValue());
            }
            dataInfo = dataInfo + System.getProperty("line.separator") + "Global Attributes: ";
            for (i = 0; i < this._gAtts.size(); ++i) {
                aAttS = this._gAtts.get(i);
                dataInfo = dataInfo + System.getProperty("line.separator") + "\t: " + aAttS.toString();
            }
            dataInfo = dataInfo + System.getProperty("line.separator") + "Variations: " + this._variables.size();
            for (i = 0; i < this._variables.size(); ++i) {
                int j;
                dataInfo = dataInfo + System.getProperty("line.separator") + "\t" + this._variables.get(i).getDataType().toString() + " " + this._variables.get(i).getFullName() + "(";
                List dims = this._variables.get(i).getDimensions();
                for (j = 0; j < dims.size(); ++j) {
                    dataInfo = dataInfo + ((ucar.nc2.Dimension)dims.get(j)).getShortName() + ",";
                }
                dataInfo = dataInfo.substring(0, dataInfo.length() - 1);
                dataInfo = dataInfo + ");";
                List atts = this._variables.get(i).getAttributes();
                for (j = 0; j < atts.size(); ++j) {
                    aAttS = (ucar.nc2.Attribute)atts.get(j);
                    dataInfo = dataInfo + System.getProperty("line.separator") + "\t\t" + this._variables.get(i).getShortName() + ": " + aAttS.toString();
                }
            }
            Iterator<ucar.nc2.Dimension> iterator = this._dimensions.iterator();
            if (!iterator.hasNext() || !(dim = iterator.next()).isUnlimited()) break block7;
            dataInfo = dataInfo + System.getProperty("line.separator") + "Unlimited dimension: " + dim.getShortName();
        }
        return dataInfo;
    }

    private int getTrueVarIndex(int varIdx) {
        int tVarIdx = varIdx;
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Variable var = this.getVariables().get(i);
            if (tVarIdx > i || tVarIdx == i && var.isPlottable()) break;
            if (var.isPlottable()) continue;
            ++tVarIdx;
        }
        return tVarIdx;
    }

    private double[] getPackData(ucar.nc2.Variable var) {
        double missingValue = this.getMissingValue();
        double add_offset = 0.0;
        double scale_factor = 1.0;
        for (int i = 0; i < var.getAttributes().size(); ++i) {
            ucar.nc2.Attribute att = (ucar.nc2.Attribute)var.getAttributes().get(i);
            String attName = att.getShortName();
            if (attName.equals("add_offset")) {
                add_offset = Double.parseDouble(att.getValue(0).toString());
            }
            if (attName.equals("scale_factor")) {
                scale_factor = Double.parseDouble(att.getValue(0).toString());
            }
            if (attName.equals("missing_value")) {
                missingValue = Double.parseDouble(att.getValue(0).toString());
            }
            if (!attName.equals("_FillValue")) continue;
            try {
                missingValue = Double.parseDouble(att.getValue(0).toString());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new double[]{add_offset, scale_factor, missingValue};
    }

    @Override
    public GridArray getGridArray(String varName) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridData getGridData_LonLat(int timeIdx, int varIdx, int levelIdx) {
        try {
            int i;
            if (this.ncfile == null) {
                this.ncfile = NetcdfDataset.openFile((String)this.getFileName(), null);
            }
            int tVarIdx = varIdx;
            ucar.nc2.Variable var = (ucar.nc2.Variable)this.ncfile.getVariables().get(tVarIdx);
            double[] packData = this.getPackData(var);
            double add_offset = packData[0];
            double scale_factor = packData[1];
            double missingValue = packData[2];
            Variable nvar = this.getVariables().get(tVarIdx);
            int xNum = nvar.getXDimension().getLength();
            int yNum = nvar.getYDimension().getLength();
            double[][] gridData = new double[yNum][xNum];
            int rank = var.getRank();
            int[] origin = new int[rank];
            int[] size = new int[rank];
            int xdimIdx = 0;
            int ydimIdx = 0;
            block17: for (i = 0; i < rank; ++i) {
                ucar.nc2.Dimension dim = var.getDimension(i);
                Dimension ndim = nvar.getDimension(i);
                switch (ndim.getDimType()) {
                    case T: {
                        origin[i] = timeIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    case Z: {
                        origin[i] = levelIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    case Y: {
                        origin[i] = 0;
                        size[i] = yNum;
                        ydimIdx = i;
                        continue block17;
                    }
                    case X: {
                        origin[i] = 0;
                        size[i] = xNum;
                        xdimIdx = i;
                        continue block17;
                    }
                    default: {
                        origin[i] = 0;
                        size[i] = 1;
                    }
                }
            }
            org.meteoinfo.ndarray.Array data2D = NCUtil.convertArray(var.read(origin, size).reduce());
            if (ydimIdx < xdimIdx) {
                for (i = 0; i < yNum; ++i) {
                    for (int j = 0; j < xNum; ++j) {
                        double v = data2D.getDouble(i * xNum + j);
                        gridData[i][j] = v == missingValue ? v : v * scale_factor + add_offset;
                    }
                }
            } else {
                for (i = 0; i < yNum; ++i) {
                    for (int j = 0; j < xNum; ++j) {
                        double v = data2D.getDouble(j * yNum + i);
                        gridData[i][j] = v == missingValue ? v : v * scale_factor + add_offset;
                    }
                }
            }
            GridData aGridData = new GridData();
            aGridData.data = gridData;
            aGridData.xArray = nvar.getXDimension().getValues();
            aGridData.yArray = nvar.getYDimension().getValues();
            aGridData.missingValue = missingValue;
            if (this.isYReverse()) {
                aGridData.yReverse();
            }
            if (this._convention == Conventions.WRFOUT) {
                if (nvar.getName().equals("U")) {
                    aGridData.setXStagger(true);
                }
                if (nvar.getName().equals("V")) {
                    aGridData.setYStagger(true);
                }
            }
            GridData gridData2 = aGridData;
            return gridData2;
        }
        catch (IOException | InvalidRangeException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            GridData gridData = null;
            return gridData;
        }
        finally {
            if (!this.keepOpen && null != this.ncfile) {
                try {
                    this.ncfile.close();
                    this.ncfile = null;
                }
                catch (IOException ex) {
                    Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridData getGridData_TimeLat(int lonIdx, int varIdx, int levelIdx) {
        try {
            int i;
            if (this.ncfile == null) {
                this.ncfile = NetcdfDataset.openFile((String)this.getFileName(), null);
            }
            int tVarIdx = varIdx;
            ucar.nc2.Variable var = this._variables.get(tVarIdx);
            var = this.ncfile.findVariable(var.getShortName());
            double[] packData = this.getPackData(var);
            double add_offset = packData[0];
            double scale_factor = packData[1];
            double missingValue = packData[2];
            Variable nvar = this.getVariables().get(tVarIdx);
            int xNum = nvar.getYDimension().getLength();
            int yNum = nvar.getTDimension().getLength();
            double[][] gridData = new double[yNum][xNum];
            int rank = var.getRank();
            int[] origin = new int[rank];
            int[] size = new int[rank];
            block17: for (i = 0; i < rank; ++i) {
                Dimension ndim = nvar.getDimension(i);
                switch (ndim.getDimType()) {
                    case T: {
                        origin[i] = 0;
                        size[i] = yNum;
                        continue block17;
                    }
                    case Z: {
                        origin[i] = levelIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    case Y: {
                        origin[i] = 0;
                        size[i] = xNum;
                        continue block17;
                    }
                    case X: {
                        origin[i] = lonIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    default: {
                        origin[i] = 0;
                        size[i] = 1;
                    }
                }
            }
            org.meteoinfo.ndarray.Array data2D = NCUtil.convertArray(var.read(origin, size).reduce());
            for (i = 0; i < yNum; ++i) {
                for (int j = 0; j < xNum; ++j) {
                    double v = data2D.getDouble(i * xNum + j);
                    gridData[i][j] = v == missingValue ? v : v * scale_factor + add_offset;
                }
            }
            GridData aGridData = new GridData();
            aGridData.data = gridData;
            aGridData.xArray = nvar.getYDimension().getValues();
            aGridData.yArray = nvar.getTDimension().getValues();
            aGridData.missingValue = missingValue;
            if (this.isYReverse()) {
                aGridData.xReverse();
            }
            GridData gridData2 = aGridData;
            return gridData2;
        }
        catch (IOException | InvalidRangeException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            GridData gridData = null;
            return gridData;
        }
        finally {
            if (null != this.ncfile) {
                try {
                    this.ncfile.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridData getGridData_TimeLon(int latIdx, int varIdx, int levelIdx) {
        try {
            int i;
            if (this.ncfile == null) {
                this.ncfile = NetcdfDataset.openFile((String)this.getFileName(), null);
            }
            int tVarIdx = varIdx;
            ucar.nc2.Variable var = this._variables.get(tVarIdx);
            var = this.ncfile.findVariable(var.getShortName());
            double[] packData = this.getPackData(var);
            double add_offset = packData[0];
            double scale_factor = packData[1];
            double missingValue = packData[2];
            Variable nvar = this.getVariables().get(tVarIdx);
            int xNum = nvar.getXDimension().getLength();
            int yNum = nvar.getTDimension().getLength();
            double[][] gridData = new double[yNum][xNum];
            int rank = var.getRank();
            int[] origin = new int[rank];
            int[] size = new int[rank];
            block17: for (i = 0; i < rank; ++i) {
                Dimension ndim = nvar.getDimension(i);
                switch (ndim.getDimType()) {
                    case T: {
                        origin[i] = 0;
                        size[i] = yNum;
                        continue block17;
                    }
                    case Z: {
                        origin[i] = levelIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    case Y: {
                        origin[i] = latIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    case X: {
                        origin[i] = 0;
                        size[i] = xNum;
                        continue block17;
                    }
                    default: {
                        origin[i] = 0;
                        size[i] = 1;
                    }
                }
            }
            org.meteoinfo.ndarray.Array data2D = NCUtil.convertArray(var.read(origin, size).reduce());
            for (i = 0; i < yNum; ++i) {
                for (int j = 0; j < xNum; ++j) {
                    double v = data2D.getDouble(i * xNum + j);
                    gridData[i][j] = v == missingValue ? v : v * scale_factor + add_offset;
                }
            }
            GridData aGridData = new GridData();
            aGridData.data = gridData;
            aGridData.xArray = nvar.getYDimension().getValues();
            aGridData.yArray = nvar.getTDimension().getValues();
            aGridData.missingValue = missingValue;
            GridData gridData2 = aGridData;
            return gridData2;
        }
        catch (IOException | InvalidRangeException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            GridData gridData = null;
            return gridData;
        }
        finally {
            if (!this.keepOpen && null != this.ncfile) {
                try {
                    this.ncfile.close();
                    this.ncfile = null;
                }
                catch (IOException ex) {
                    Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridData getGridData_LevelLat(int lonIdx, int varIdx, int timeIdx) {
        try {
            int i;
            if (this.ncfile == null) {
                this.ncfile = NetcdfDataset.openFile((String)this.getFileName(), null);
            }
            int tVarIdx = varIdx;
            ucar.nc2.Variable var = this._variables.get(tVarIdx);
            var = this.ncfile.findVariable(var.getShortName());
            double[] packData = this.getPackData(var);
            double add_offset = packData[0];
            double scale_factor = packData[1];
            double missingValue = packData[2];
            Variable nvar = this.getVariables().get(tVarIdx);
            int xNum = nvar.getYDimension().getLength();
            int yNum = nvar.getZDimension().getLength();
            double[][] gridData = new double[yNum][xNum];
            int rank = var.getRank();
            int[] origin = new int[rank];
            int[] size = new int[rank];
            block17: for (i = 0; i < rank; ++i) {
                Dimension ndim = nvar.getDimension(i);
                switch (ndim.getDimType()) {
                    case T: {
                        origin[i] = timeIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    case Z: {
                        origin[i] = 0;
                        size[i] = yNum;
                        continue block17;
                    }
                    case Y: {
                        origin[i] = 0;
                        size[i] = xNum;
                        continue block17;
                    }
                    case X: {
                        origin[i] = lonIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    default: {
                        origin[i] = 0;
                        size[i] = 1;
                    }
                }
            }
            org.meteoinfo.ndarray.Array data2D = NCUtil.convertArray(var.read(origin, size).reduce());
            for (i = 0; i < yNum; ++i) {
                for (int j = 0; j < xNum; ++j) {
                    double v = data2D.getDouble(i * xNum + j);
                    gridData[i][j] = v == missingValue ? v : v * scale_factor + add_offset;
                }
            }
            GridData aGridData = new GridData();
            aGridData.data = gridData;
            aGridData.xArray = nvar.getYDimension().getValues();
            aGridData.yArray = nvar.getZDimension().getValues();
            aGridData.missingValue = missingValue;
            if (this.isYReverse()) {
                aGridData.xReverse();
            }
            GridData gridData2 = aGridData;
            return gridData2;
        }
        catch (IOException | InvalidRangeException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            GridData gridData = null;
            return gridData;
        }
        finally {
            if (!this.keepOpen && null != this.ncfile) {
                try {
                    this.ncfile.close();
                    this.ncfile = null;
                }
                catch (IOException ex) {
                    Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridData getGridData_LevelLon(int latIdx, int varIdx, int timeIdx) {
        try {
            int i;
            if (this.ncfile == null) {
                this.ncfile = NetcdfDataset.openFile((String)this.getFileName(), null);
            }
            int tVarIdx = varIdx;
            ucar.nc2.Variable var = this._variables.get(tVarIdx);
            var = this.ncfile.findVariable(var.getShortName());
            double[] packData = this.getPackData(var);
            double add_offset = packData[0];
            double scale_factor = packData[1];
            double missingValue = packData[2];
            Variable nvar = this.getVariables().get(tVarIdx);
            int xNum = nvar.getXDimension().getLength();
            int yNum = nvar.getZDimension().getLength();
            double[][] gridData = new double[yNum][xNum];
            int rank = var.getRank();
            int[] origin = new int[rank];
            int[] size = new int[rank];
            block17: for (i = 0; i < rank; ++i) {
                Dimension ndim = nvar.getDimension(i);
                switch (ndim.getDimType()) {
                    case T: {
                        origin[i] = timeIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    case Z: {
                        origin[i] = 0;
                        size[i] = yNum;
                        continue block17;
                    }
                    case Y: {
                        origin[i] = latIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    case X: {
                        origin[i] = 0;
                        size[i] = xNum;
                        continue block17;
                    }
                    default: {
                        origin[i] = 0;
                        size[i] = 1;
                    }
                }
            }
            org.meteoinfo.ndarray.Array data2D = NCUtil.convertArray(var.read(origin, size).reduce());
            for (i = 0; i < yNum; ++i) {
                for (int j = 0; j < xNum; ++j) {
                    double v = data2D.getDouble(i * xNum + j);
                    gridData[i][j] = v == missingValue ? v : v * scale_factor + add_offset;
                }
            }
            GridData aGridData = new GridData();
            aGridData.data = gridData;
            aGridData.xArray = nvar.getXDimension().getValues();
            aGridData.yArray = nvar.getZDimension().getValues();
            aGridData.missingValue = missingValue;
            GridData gridData2 = aGridData;
            return gridData2;
        }
        catch (IOException | InvalidRangeException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            GridData gridData = null;
            return gridData;
        }
        finally {
            if (!this.keepOpen && null != this.ncfile) {
                try {
                    this.ncfile.close();
                    this.ncfile = null;
                }
                catch (IOException ex) {
                    Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridData getGridData_LevelTime(int latIdx, int varIdx, int lonIdx) {
        try {
            int i;
            if (this.ncfile == null) {
                this.ncfile = NetcdfDataset.openFile((String)this.getFileName(), null);
            }
            int tVarIdx = varIdx;
            ucar.nc2.Variable var = this._variables.get(tVarIdx);
            var = this.ncfile.findVariable(var.getShortName());
            double[] packData = this.getPackData(var);
            double add_offset = packData[0];
            double scale_factor = packData[1];
            double missingValue = packData[2];
            Variable nvar = this.getVariables().get(tVarIdx);
            int xNum = nvar.getTDimension().getLength();
            int yNum = nvar.getZDimension().getLength();
            double[][] gridData = new double[yNum][xNum];
            int rank = var.getRank();
            int[] origin = new int[rank];
            int[] size = new int[rank];
            block17: for (i = 0; i < rank; ++i) {
                Dimension ndim = nvar.getDimension(i);
                switch (ndim.getDimType()) {
                    case T: {
                        origin[i] = 0;
                        size[i] = xNum;
                        continue block17;
                    }
                    case Z: {
                        origin[i] = 0;
                        size[i] = yNum;
                        continue block17;
                    }
                    case Y: {
                        origin[i] = latIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    case X: {
                        origin[i] = lonIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    default: {
                        origin[i] = 0;
                        size[i] = 1;
                    }
                }
            }
            org.meteoinfo.ndarray.Array data2D = NCUtil.convertArray(var.read(origin, size).reduce());
            if (data2D.getShape()[0] == xNum) {
                data2D = data2D.transpose(0, 1);
            }
            Index index = data2D.getIndex();
            for (i = 0; i < yNum; ++i) {
                for (int j = 0; j < xNum; ++j) {
                    double v = data2D.getDouble(index);
                    gridData[i][j] = v == missingValue ? v : v * scale_factor + add_offset;
                    index.incr();
                }
            }
            GridData aGridData = new GridData();
            aGridData.data = gridData;
            aGridData.xArray = nvar.getTDimension().getValues();
            aGridData.yArray = nvar.getZDimension().getValues();
            aGridData.missingValue = missingValue;
            GridData gridData2 = aGridData;
            return gridData2;
        }
        catch (IOException | InvalidRangeException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            GridData gridData = null;
            return gridData;
        }
        finally {
            if (!this.keepOpen && null != this.ncfile) {
                try {
                    this.ncfile.close();
                    this.ncfile = null;
                }
                catch (IOException ex) {
                    Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridData getGridData_Time(int lonIdx, int latIdx, int varIdx, int levelIdx) {
        try {
            int i;
            if (this.ncfile == null) {
                this.ncfile = NetcdfDataset.openFile((String)this.getFileName(), null);
            }
            int tVarIdx = varIdx;
            ucar.nc2.Variable var = this._variables.get(tVarIdx);
            var = this.ncfile.findVariable(var.getShortName());
            double[] packData = this.getPackData(var);
            double add_offset = packData[0];
            double scale_factor = packData[1];
            double missingValue = packData[2];
            Variable nvar = this.getVariables().get(tVarIdx);
            int dNum = nvar.getTDimension().getLength();
            double[][] gridData = new double[1][dNum];
            int rank = var.getRank();
            int[] origin = new int[rank];
            int[] size = new int[rank];
            block17: for (i = 0; i < rank; ++i) {
                Dimension ndim = nvar.getDimension(i);
                switch (ndim.getDimType()) {
                    case T: {
                        origin[i] = 0;
                        size[i] = dNum;
                        continue block17;
                    }
                    case Z: {
                        origin[i] = levelIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    case Y: {
                        origin[i] = latIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    case X: {
                        origin[i] = lonIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    default: {
                        origin[i] = 0;
                        size[i] = 1;
                    }
                }
            }
            org.meteoinfo.ndarray.Array data1D = NCUtil.convertArray(var.read(origin, size).reduce());
            for (i = 0; i < dNum; ++i) {
                double v = data1D.getDouble(i);
                if (v == missingValue) {
                    gridData[0][1] = v;
                    continue;
                }
                gridData[0][i] = v * scale_factor + add_offset;
            }
            GridData aGridData = new GridData();
            aGridData.data = gridData;
            aGridData.xArray = nvar.getTDimension().getValues();
            aGridData.yArray = new double[1];
            aGridData.missingValue = missingValue;
            GridData gridData2 = aGridData;
            return gridData2;
        }
        catch (IOException | InvalidRangeException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            GridData gridData = null;
            return gridData;
        }
        finally {
            if (!this.keepOpen && null != this.ncfile) {
                try {
                    this.ncfile.close();
                    this.ncfile = null;
                }
                catch (IOException ex) {
                    Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridData getGridData_Level(int lonIdx, int latIdx, int varIdx, int timeIdx) {
        try {
            int i;
            if (this.ncfile == null) {
                this.ncfile = NetcdfDataset.openFile((String)this.getFileName(), null);
            }
            int tVarIdx = varIdx;
            ucar.nc2.Variable var = this._variables.get(tVarIdx);
            var = this.ncfile.findVariable(var.getShortName());
            double[] packData = this.getPackData(var);
            double add_offset = packData[0];
            double scale_factor = packData[1];
            double missingValue = packData[2];
            Variable nvar = this.getVariables().get(tVarIdx);
            int dNum = nvar.getZDimension().getLength();
            double[][] gridData = new double[1][dNum];
            int rank = var.getRank();
            int[] origin = new int[rank];
            int[] size = new int[rank];
            block17: for (i = 0; i < rank; ++i) {
                Dimension ndim = nvar.getDimension(i);
                switch (ndim.getDimType()) {
                    case T: {
                        origin[i] = timeIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    case Z: {
                        origin[i] = 0;
                        size[i] = dNum;
                        continue block17;
                    }
                    case Y: {
                        origin[i] = latIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    case X: {
                        origin[i] = lonIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    default: {
                        origin[i] = 0;
                        size[i] = 1;
                    }
                }
            }
            org.meteoinfo.ndarray.Array data1D = NCUtil.convertArray(var.read(origin, size).reduce());
            for (i = 0; i < dNum; ++i) {
                double v = data1D.getDouble(i);
                if (v == missingValue) {
                    gridData[0][1] = v;
                    continue;
                }
                gridData[0][i] = v * scale_factor + add_offset;
            }
            GridData aGridData = new GridData();
            aGridData.data = gridData;
            aGridData.xArray = nvar.getZDimension().getValues();
            aGridData.yArray = new double[1];
            aGridData.missingValue = missingValue;
            GridData gridData2 = aGridData;
            return gridData2;
        }
        catch (IOException | InvalidRangeException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            GridData gridData = null;
            return gridData;
        }
        finally {
            if (!this.keepOpen && null != this.ncfile) {
                try {
                    this.ncfile.close();
                    this.ncfile = null;
                }
                catch (IOException ex) {
                    Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridData getGridData_Lon(int timeIdx, int latIdx, int varIdx, int levelIdx) {
        try {
            int i;
            if (this.ncfile == null) {
                this.ncfile = NetcdfDataset.openFile((String)this.getFileName(), null);
            }
            int tVarIdx = varIdx;
            ucar.nc2.Variable var = this._variables.get(tVarIdx);
            var = this.ncfile.findVariable(var.getShortName());
            double[] packData = this.getPackData(var);
            double add_offset = packData[0];
            double scale_factor = packData[1];
            double missingValue = packData[2];
            Variable nvar = this.getVariables().get(tVarIdx);
            int dNum = nvar.getXDimension().getLength();
            double[][] gridData = new double[1][dNum];
            int rank = var.getRank();
            int[] origin = new int[rank];
            int[] size = new int[rank];
            block17: for (i = 0; i < rank; ++i) {
                Dimension ndim = nvar.getDimension(i);
                switch (ndim.getDimType()) {
                    case T: {
                        origin[i] = timeIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    case Z: {
                        origin[i] = levelIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    case Y: {
                        origin[i] = latIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    case X: {
                        origin[i] = 0;
                        size[i] = dNum;
                        continue block17;
                    }
                    default: {
                        origin[i] = 0;
                        size[i] = 1;
                    }
                }
            }
            org.meteoinfo.ndarray.Array data1D = NCUtil.convertArray(var.read(origin, size).reduce());
            for (i = 0; i < dNum; ++i) {
                double v = data1D.getDouble(i);
                gridData[0][i] = v == missingValue ? v : v * scale_factor + add_offset;
            }
            GridData aGridData = new GridData();
            aGridData.data = gridData;
            aGridData.xArray = nvar.getXDimension().getValues();
            aGridData.yArray = new double[1];
            aGridData.missingValue = missingValue;
            GridData gridData2 = aGridData;
            return gridData2;
        }
        catch (IOException | InvalidRangeException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            GridData gridData = null;
            return gridData;
        }
        finally {
            if (!this.keepOpen && null != this.ncfile) {
                try {
                    this.ncfile.close();
                    this.ncfile = null;
                }
                catch (IOException ex) {
                    Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridData getGridData_Lat(int timeIdx, int lonIdx, int varIdx, int levelIdx) {
        try {
            int i;
            if (this.ncfile == null) {
                this.ncfile = NetcdfDataset.openFile((String)this.getFileName(), null);
            }
            int tVarIdx = varIdx;
            ucar.nc2.Variable var = this._variables.get(tVarIdx);
            var = this.ncfile.findVariable(var.getShortName());
            double[] packData = this.getPackData(var);
            double add_offset = packData[0];
            double scale_factor = packData[1];
            double missingValue = packData[2];
            Variable nvar = this.getVariables().get(tVarIdx);
            int dNum = nvar.getYDimension().getLength();
            double[][] gridData = new double[1][dNum];
            int rank = var.getRank();
            int[] origin = new int[rank];
            int[] size = new int[rank];
            block17: for (i = 0; i < rank; ++i) {
                Dimension ndim = nvar.getDimension(i);
                switch (ndim.getDimType()) {
                    case T: {
                        origin[i] = timeIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    case Z: {
                        origin[i] = levelIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    case Y: {
                        origin[i] = 0;
                        size[i] = dNum;
                        continue block17;
                    }
                    case X: {
                        origin[i] = lonIdx;
                        size[i] = 1;
                        continue block17;
                    }
                    default: {
                        origin[i] = 0;
                        size[i] = 1;
                    }
                }
            }
            org.meteoinfo.ndarray.Array data1D = NCUtil.convertArray(var.read(origin, size).reduce());
            for (i = 0; i < dNum; ++i) {
                double v = data1D.getDouble(i);
                gridData[0][i] = v == missingValue ? v : v * scale_factor + add_offset;
            }
            GridData aGridData = new GridData();
            aGridData.data = gridData;
            aGridData.xArray = nvar.getYDimension().getValues();
            aGridData.yArray = new double[1];
            aGridData.missingValue = missingValue;
            GridData gridData2 = aGridData;
            return gridData2;
        }
        catch (IOException | InvalidRangeException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            GridData gridData = null;
            return gridData;
        }
        finally {
            if (!this.keepOpen && null != this.ncfile) {
                try {
                    this.ncfile.close();
                    this.ncfile = null;
                }
                catch (IOException ex) {
                    Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StationData getStationData(int timeIdx, int varIdx, int levelIdx) {
        try {
            double maxy;
            double maxx;
            int i;
            if (this.ncfile == null) {
                this.ncfile = NetcdfFile.open((String)this.getFileName());
            }
            int tVarIdx = varIdx;
            ucar.nc2.Variable var = (ucar.nc2.Variable)this.ncfile.getVariables().get(tVarIdx);
            ucar.nc2.Variable lonvar = this.findNCVariable("Longitude");
            ucar.nc2.Variable latvar = this.findNCVariable("Latitude");
            lonvar = (ucar.nc2.Variable)this.ncfile.getVariables().get(this._variables.indexOf(lonvar));
            latvar = (ucar.nc2.Variable)this.ncfile.getVariables().get(this._variables.indexOf(latvar));
            org.meteoinfo.ndarray.Array lonarray = NCUtil.convertArray(lonvar.read());
            org.meteoinfo.ndarray.Array latarray = NCUtil.convertArray(latvar.read());
            int stNum = (int)lonarray.getSize();
            List lldims = lonvar.getDimensions();
            double[] packData = this.getPackData(var);
            double add_offset = packData[0];
            double scale_factor = packData[1];
            double missingValue = packData[2];
            Variable nvar = this.getVariables().get(tVarIdx);
            int rank = var.getRank();
            int[] origin = new int[rank];
            int[] size = new int[rank];
            if (rank == lonvar.getRank()) {
                for (i = 0; i < rank; ++i) {
                    ucar.nc2.Dimension dim = var.getDimension(i);
                    origin[i] = 0;
                    size[i] = dim.getLength();
                }
            } else {
                block16: for (i = 0; i < rank; ++i) {
                    Dimension ndim = nvar.getDimension(i);
                    ucar.nc2.Dimension dim = var.getDimension(i);
                    switch (ndim.getDimType()) {
                        case T: {
                            if (this._isPROFILE) {
                                origin[i] = timeIdx;
                                size[i] = ndim.getLength();
                                continue block16;
                            }
                            origin[i] = timeIdx;
                            size[i] = 1;
                            continue block16;
                        }
                        case Xtrack: {
                            origin[i] = levelIdx;
                            size[i] = dim.getLength();
                            continue block16;
                        }
                        default: {
                            if (lldims.contains(dim)) {
                                origin[i] = 0;
                                size[i] = dim.getLength();
                                continue block16;
                            }
                            origin[i] = levelIdx;
                            size[i] = 1;
                        }
                    }
                }
            }
            org.meteoinfo.ndarray.Array darray = NCUtil.convertArray(var.read(origin, size).reduce());
            double minx = maxx = lonarray.getDouble(0);
            double miny = maxy = latarray.getDouble(0);
            double[][] discretedData = new double[stNum][3];
            StationData stData = new StationData();
            for (i = 0; i < stNum; ++i) {
                double lon = lonarray.getDouble(i);
                double lat = latarray.getDouble(i);
                double v = darray.getDouble(i);
                double value = v == missingValue ? v : v * scale_factor + add_offset;
                discretedData[i][0] = lon;
                discretedData[i][1] = lat;
                discretedData[i][2] = value;
                if (minx > lon) {
                    minx = lon;
                } else if (maxx < lon) {
                    maxx = lon;
                }
                if (miny > lat) {
                    miny = lat;
                    continue;
                }
                if (!(maxy < lat)) continue;
                maxy = lat;
            }
            stData.data = discretedData;
            stData.dataExtent = new Extent(minx, maxx, miny, maxy);
            stData.missingValue = missingValue;
            ArrayList<String> stations = new ArrayList<String>();
            for (i = 0; i < stNum; ++i) {
                stations.add(String.valueOf(i + 1));
            }
            stData.stations = stations;
            StationData stationData = stData;
            return stationData;
        }
        catch (IOException | InvalidRangeException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            StationData stationData = null;
            return stationData;
        }
        finally {
            if (!this.keepOpen && null != this.ncfile) {
                try {
                    this.ncfile.close();
                    this.ncfile = null;
                }
                catch (IOException ex) {
                    Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    @Override
    public StationInfoData getStationInfoData(int timeIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public StationModelData getStationModelData(int timeIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public org.meteoinfo.ndarray.Array read(String varName) {
        return this.read(varName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.meteoinfo.ndarray.Array read(String varName, boolean unpack) {
        try {
            List vars;
            ucar.nc2.Variable var;
            if (this.ncfile == null) {
                this.ncfile = NetcdfFile.open((String)this.getFileName());
            }
            if ((var = this.ncfile.findVariable(varName)) == null) {
                vars = this.ncfile.getVariables();
                for (ucar.nc2.Variable v : vars) {
                    if (!v.getShortName().equals(varName)) continue;
                    var = v;
                    break;
                }
            }
            if (var == null) {
                System.out.println("Variable not exist: " + varName);
                vars = null;
                return vars;
            }
            org.meteoinfo.ndarray.Array data = NCUtil.convertArray(var.read());
            if (unpack) {
                double[] packData = this.getPackData(var);
                double add_offset = packData[0];
                double scale_factor = packData[1];
                double missingValue = packData[2];
                if (add_offset != 0.0 || scale_factor != 1.0) {
                    data = ArrayMath.add(ArrayMath.mul(data, scale_factor), add_offset);
                }
            }
            org.meteoinfo.ndarray.Array add_offset = data;
            return add_offset;
        }
        catch (IOException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            org.meteoinfo.ndarray.Array array = null;
            return array;
        }
        finally {
            if (!this.keepOpen && null != this.ncfile) {
                try {
                    this.ncfile.close();
                    this.ncfile = null;
                }
                catch (IOException ex) {
                    Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    @Override
    public org.meteoinfo.ndarray.Array read(String varName, int[] origin, int[] size, int[] stride) {
        return this.read(varName, origin, size, stride, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.meteoinfo.ndarray.Array read(String varName, int[] origin, int[] size, int[] stride, boolean unpack) {
        try {
            org.meteoinfo.ndarray.Array data;
            List vars;
            ucar.nc2.Variable var;
            if (this.ncfile == null) {
                this.ncfile = NetcdfDataset.openFile((String)this.getFileName(), null);
            }
            if ((var = this.ncfile.findVariable(varName)) == null) {
                vars = this.ncfile.getVariables();
                for (ucar.nc2.Variable v : vars) {
                    if (!v.getShortName().equals(varName)) continue;
                    var = v;
                    break;
                }
            }
            if (var == null) {
                System.out.println("Variable not exist: " + varName);
                vars = null;
                return vars;
            }
            boolean negStride = false;
            for (int s : stride) {
                if (s >= 0) continue;
                negStride = true;
                break;
            }
            if (negStride) {
                int[] pStride = new int[stride.length];
                ArrayList<Integer> flips = new ArrayList<Integer>();
                for (int i = 0; i < stride.length; ++i) {
                    pStride[i] = Math.abs(stride[i]);
                    if (stride[i] >= 0) continue;
                    flips.add(i);
                }
                Section section = new Section(origin, size, pStride);
                org.meteoinfo.ndarray.Array r = NCUtil.convertArray(var.read(section));
                Iterator iterator = flips.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    r = r.flip(i);
                }
                data = org.meteoinfo.ndarray.Array.factory(r.getDataType(), r.getShape());
                MAMath.copy(data, r);
            } else {
                Section section = new Section(origin, size, stride);
                data = NCUtil.convertArray(var.read(section));
            }
            if (unpack) {
                double[] packData = this.getPackData(var);
                double add_offset = packData[0];
                double scale_factor = packData[1];
                double missingValue = packData[2];
                if (add_offset != 0.0 || scale_factor != 1.0) {
                    data = ArrayMath.add(ArrayMath.mul(data, scale_factor), add_offset);
                }
            }
            org.meteoinfo.ndarray.Array array = data;
            return array;
        }
        catch (IOException | InvalidRangeException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            org.meteoinfo.ndarray.Array array = null;
            return array;
        }
        finally {
            if (!this.keepOpen && null != this.ncfile) {
                try {
                    this.ncfile.close();
                    this.ncfile = null;
                }
                catch (IOException ex) {
                    Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public org.meteoinfo.ndarray.Array read(String varName, int[] origin, int[] size) {
        return this.read(varName, origin, size, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.meteoinfo.ndarray.Array read(String varName, int[] origin, int[] size, boolean unpack) {
        try {
            if (this.ncfile == null) {
                this.ncfile = NetcdfFile.open((String)this.getFileName());
            }
            ucar.nc2.Variable var = this.ncfile.findVariable(varName);
            Section section = new Section(origin, size);
            org.meteoinfo.ndarray.Array data = NCUtil.convertArray(var.read(section));
            if (unpack) {
                double[] packData = this.getPackData(var);
                double add_offset = packData[0];
                double scale_factor = packData[1];
                double missingValue = packData[2];
                if (add_offset != 0.0 || scale_factor != 1.0) {
                    data = ArrayMath.add(ArrayMath.mul(data, scale_factor), add_offset);
                }
            }
            org.meteoinfo.ndarray.Array array = data;
            return array;
        }
        catch (IOException | InvalidRangeException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            org.meteoinfo.ndarray.Array array = null;
            return array;
        }
        finally {
            if (!this.keepOpen && null != this.ncfile) {
                try {
                    this.ncfile.close();
                    this.ncfile = null;
                }
                catch (IOException ex) {
                    Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.meteoinfo.ndarray.Array read_pack(String varName, int[] origin, int[] size) {
        try {
            if (this.ncfile == null) {
                this.ncfile = NetcdfFile.open((String)this.getFileName());
            }
            ucar.nc2.Variable var = this.ncfile.findVariable(varName);
            Section section = new Section(origin, size);
            org.meteoinfo.ndarray.Array data = NCUtil.convertArray(var.read(section));
            double[] packData = this.getPackData(var);
            double add_offset = packData[0];
            double scale_factor = packData[1];
            double missingValue = packData[2];
            if (add_offset != 0.0 || scale_factor != 1.0) {
                data = ArrayMath.add(ArrayMath.mul(data, scale_factor), add_offset);
            }
            org.meteoinfo.ndarray.Array array = data;
            return array;
        }
        catch (IOException | InvalidRangeException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            org.meteoinfo.ndarray.Array array = null;
            return array;
        }
        finally {
            if (!this.keepOpen && null != this.ncfile) {
                try {
                    this.ncfile.close();
                    this.ncfile = null;
                }
                catch (IOException ex) {
                    Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.meteoinfo.ndarray.Array read(String varName, String key) {
        try {
            org.meteoinfo.ndarray.Array data;
            if (this.ncfile == null) {
                this.ncfile = NetcdfFile.open((String)this.getFileName());
            }
            ucar.nc2.Variable var = this.ncfile.findVariable(varName);
            org.meteoinfo.ndarray.Array array = data = NCUtil.convertArray(var.read(key));
            return array;
        }
        catch (IOException | InvalidRangeException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            org.meteoinfo.ndarray.Array array = null;
            return array;
        }
        finally {
            if (!this.keepOpen && null != this.ncfile) {
                try {
                    this.ncfile.close();
                    this.ncfile = null;
                }
                catch (IOException ex) {
                    Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static GridData arrayToGrid(org.meteoinfo.ndarray.Array array, Dimension xdim, Dimension ydim) {
        int yNum = ydim.getLength();
        int xNum = xdim.getLength();
        double[][] gridData = new double[yNum][xNum];
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                gridData[i][j] = array.getDouble(j * yNum + i);
            }
        }
        GridData aGridData = new GridData();
        aGridData.data = gridData;
        aGridData.xArray = xdim.getValues();
        aGridData.yArray = ydim.getValues();
        return aGridData;
    }

    public static org.meteoinfo.ndarray.Array gridToArray2D(GridData gData) {
        org.meteoinfo.ndarray.Array a = org.meteoinfo.ndarray.Array.factory(gData.data);
        int[] shape = new int[]{gData.getYNum(), gData.getXNum()};
        a = a.reshape(shape);
        return a;
    }

    public static org.meteoinfo.ndarray.Array gridToArray3D(GridData gData) {
        org.meteoinfo.ndarray.Array a = org.meteoinfo.ndarray.Array.factory(gData.data);
        int[] shape = new int[]{1, gData.getYNum(), gData.getXNum()};
        a = a.reshape(shape);
        return a;
    }

    public static org.meteoinfo.ndarray.Array gridToArray4D(GridData gData) {
        org.meteoinfo.ndarray.Array a = org.meteoinfo.ndarray.Array.factory(gData.data);
        int[] shape = new int[]{1, 1, gData.getYNum(), gData.getXNum()};
        a = a.reshape(shape);
        return a;
    }

    public NetcdfFileWriter createNCFile(String fileName) throws IOException {
        NetcdfFileWriter ncfilew = NetcdfFileWriter.createNew((NetcdfFileWriter.Version)NetcdfFileWriter.Version.netcdf3, (String)fileName);
        for (Dimension dim : this.dimensions) {
            ncfilew.addDimension(null, dim.getShortName(), dim.getLength(), dim.isUnlimited(), dim.isVariableLength());
        }
        for (ucar.nc2.Attribute attr : this._gAtts) {
            ncfilew.addGroupAttribute(null, attr);
        }
        for (ucar.nc2.Variable var : this._variables) {
            ucar.nc2.Variable nvar = ncfilew.addVariable(null, var.getShortName(), var.getDataType(), var.getDimensions());
            for (ucar.nc2.Attribute attr : var.getAttributes()) {
                nvar.addAttribute(attr);
            }
        }
        ncfilew.create();
        return ncfilew;
    }

    public static void joinDataFiles(List<String> inFiles, String outFile, String tDimName) {
        int fNum = inFiles.size();
        if (fNum < 2) {
            JOptionPane.showMessageDialog(null, "There should be at least two files!", "Error", 0);
            return;
        }
        String aFile = inFiles.get(0);
        String bFile = inFiles.get(1);
        NetCDFDataInfo aDataInfo = new NetCDFDataInfo();
        NetCDFDataInfo bDataInfo = new NetCDFDataInfo();
        aDataInfo.readDataInfo(aFile);
        bDataInfo.readDataInfo(bFile);
        int dataJoinType = NetCDFDataInfo.getDataJoinType(aDataInfo, bDataInfo, tDimName);
        if (dataJoinType == 0) {
            JOptionPane.showMessageDialog(null, "Data dimensions are not same!", "Error", 0);
            return;
        }
        if (dataJoinType == 2) {
            try {
                NetCDFDataInfo.joinDataFiles_Variable(inFiles, outFile);
            }
            catch (IOException | InvalidRangeException ex) {
                Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                if (dataJoinType == 1) {
                    NetCDFDataInfo.joinDataFiles_Time(inFiles, outFile, tDimName);
                } else {
                    NetCDFDataInfo.joinDataFiles_Time_pack(inFiles, outFile, tDimName);
                }
            }
            catch (IOException | ParseException | InvalidRangeException ex) {
                Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void joinDataFiles_Time(List<String> inFiles, String outFile, String timeDimStr) throws IOException, InvalidRangeException, ParseException {
        int i;
        int fNum = inFiles.size();
        if (fNum < 2) {
            JOptionPane.showMessageDialog(null, "There should be at least two files!", "Error", 0);
            return;
        }
        String aFile = inFiles.get(0);
        NetCDFDataInfo aDataInfo = new NetCDFDataInfo();
        aDataInfo.readDataInfo(aFile);
        switch (aDataInfo.getConvention()) {
            case WRFOUT: {
                timeDimStr = "Time";
            }
        }
        for (i = 0; i < aDataInfo.getDimensions().size(); ++i) {
            Dimension aDimS = aDataInfo.getDimensions().get(i);
            if (!aDimS.getShortName().equals(timeDimStr)) continue;
            aDimS.setUnlimited(true);
            break;
        }
        ArrayList<String> varNames = new ArrayList<String>();
        for (Variable var : aDataInfo.getVariables()) {
            if (MIMath.isNumeric(var.getName().substring(0, 1))) {
                var.setName('V' + var.getName());
            }
            varNames.add(var.getName());
        }
        NetcdfFileWriter ncfilew = NetcdfFileWriter.createNew((NetcdfFileWriter.Version)NetcdfFileWriter.Version.netcdf3, (String)outFile);
        ArrayList<ucar.nc2.Dimension> dims = new ArrayList<ucar.nc2.Dimension>();
        for (Dimension dim : aDataInfo.dimensions) {
            if (dim.getShortName().equals(timeDimStr)) {
                dims.add(ncfilew.addUnlimitedDimension(dim.getShortName()));
                continue;
            }
            dims.add(ncfilew.addDimension(null, dim.getShortName(), dim.getLength()));
        }
        for (ucar.nc2.Attribute attr : aDataInfo._gAtts) {
            ncfilew.addGroupAttribute(null, attr);
        }
        for (ucar.nc2.Variable var : aDataInfo._variables) {
            Object dim2;
            ArrayList<ucar.nc2.Dimension> vdims = new ArrayList<ucar.nc2.Dimension>();
            block8: for (Object dim2 : var.getDimensions()) {
                for (ucar.nc2.Dimension vdim : dims) {
                    if (!vdim.getShortName().equals(dim2.getShortName())) continue;
                    vdims.add(vdim);
                    continue block8;
                }
            }
            ucar.nc2.Variable nvar = ncfilew.addVariable(null, var.getShortName(), var.getDataType(), vdims);
            if (var.getDimensions().size() == 1 && ((ucar.nc2.Dimension)var.getDimensions().get(0)).getShortName().equals(timeDimStr)) {
                nvar.addAttribute(new ucar.nc2.Attribute("units", "hours since 1800-1-1 00:00:00"));
                nvar.addAttribute(new ucar.nc2.Attribute("long_name", "Time"));
                nvar.addAttribute(new ucar.nc2.Attribute("standard_name", "time"));
                nvar.addAttribute(new ucar.nc2.Attribute("axis", "T"));
                continue;
            }
            dim2 = var.getAttributes().iterator();
            while (dim2.hasNext()) {
                ucar.nc2.Attribute attr = (ucar.nc2.Attribute)dim2.next();
                nvar.addAttribute(attr);
            }
        }
        LocalDateTime sTime = LocalDateTime.of(1800, 1, 1, 0, 0, 0);
        ncfilew.create();
        int tDimNum = 0;
        for (i = 0; i < fNum; ++i) {
            ArrayList<String> dimNames;
            aFile = inFiles.get(i);
            aDataInfo = new NetCDFDataInfo();
            aDataInfo.readDataInfo(aFile);
            if (i == 0) {
                for (ucar.nc2.Variable var : ncfilew.getNetcdfFile().getVariables()) {
                    dimNames = new ArrayList<String>();
                    for (ucar.nc2.Dimension dim : var.getDimensions()) {
                        dimNames.add(dim.getShortName());
                    }
                    if (dimNames.contains(timeDimStr)) continue;
                    org.meteoinfo.ndarray.Array varaData = aDataInfo.read(var.getShortName(), false);
                    ncfilew.write(var, NCUtil.convertArray(varaData));
                }
            }
            for (ucar.nc2.Variable var : ncfilew.getNetcdfFile().getVariables()) {
                if (!varNames.contains(var.getShortName())) continue;
                dimNames = new ArrayList();
                for (ucar.nc2.Dimension dim : var.getDimensions()) {
                    dimNames.add(dim.getShortName());
                }
                if (!dimNames.contains(timeDimStr)) continue;
                ucar.nc2.Variable dvar = aDataInfo.findNCVariable(var.getShortName());
                int tDimIdx = dimNames.indexOf(timeDimStr);
                int dimNum = var.getDimensions().size();
                int[] start = new int[dimNum];
                int[] count = new int[dimNum];
                if (dimNum == 4) {
                    start[2] = 0;
                    count[2] = ((ucar.nc2.Dimension)dvar.getDimensions().get(2)).getLength();
                    start[3] = 0;
                    count[3] = ((ucar.nc2.Dimension)dvar.getDimensions().get(3)).getLength();
                    for (int d1 = 0; d1 < ((ucar.nc2.Dimension)dvar.getDimensions().get(0)).getLength(); ++d1) {
                        start[0] = d1;
                        count[0] = 1;
                        int d2 = 0;
                        while (d2 < ((ucar.nc2.Dimension)dvar.getDimensions().get(1)).getLength()) {
                            start[0] = d1;
                            start[1] = d2++;
                            count[1] = 1;
                            org.meteoinfo.ndarray.Array varaData = aDataInfo.read(dvar.getShortName(), start, count, false);
                            int n = tDimIdx;
                            start[n] = start[n] + tDimNum;
                            ncfilew.write(var, start, NCUtil.convertArray(varaData));
                        }
                    }
                    continue;
                }
                if (dimNum == 3) {
                    start[1] = 0;
                    count[1] = ((ucar.nc2.Dimension)dvar.getDimensions().get(1)).getLength();
                    start[2] = 0;
                    count[2] = ((ucar.nc2.Dimension)dvar.getDimensions().get(2)).getLength();
                    int d1 = 0;
                    while (d1 < ((ucar.nc2.Dimension)dvar.getDimensions().get(0)).getLength()) {
                        start[0] = d1++;
                        count[0] = 1;
                        org.meteoinfo.ndarray.Array varaData = aDataInfo.read(dvar.getShortName(), start, count, false);
                        int n = tDimIdx;
                        start[n] = start[n] + tDimNum;
                        ncfilew.write(var, start, NCUtil.convertArray(varaData));
                    }
                    continue;
                }
                for (int v = 0; v < dvar.getDimensions().size(); ++v) {
                    start[v] = 0;
                    count[v] = dvar.getDimension(v).getLength();
                }
                org.meteoinfo.ndarray.Array varaData = aDataInfo.read(dvar.getShortName());
                int n = tDimIdx;
                start[n] = start[n] + tDimNum;
                if (dimNum == 1) {
                    List<Integer> times = aDataInfo.getTimeValues(sTime, "hours");
                    varaData = org.meteoinfo.ndarray.Array.factory(NCUtil.convertDataType(dvar.getDataType()), dvar.getShape());
                    for (int j = 0; j < times.size(); ++j) {
                        varaData.setDouble(j, (double)times.get(j).intValue());
                    }
                    if (i > 0) {
                        var.getDimension(0).setLength(var.getDimension(0).getLength() + varaData.getShape()[0]);
                    }
                }
                ncfilew.write(var, start, NCUtil.convertArray(varaData));
            }
            tDimNum += aDataInfo.findDimension(timeDimStr).getLength();
        }
        ncfilew.flush();
        ncfilew.close();
    }

    public static void joinDataFiles_Time_pack(List<String> inFiles, String outFile, String timeDimStr) throws IOException, InvalidRangeException, ParseException {
        int i;
        int fNum = inFiles.size();
        if (fNum < 2) {
            JOptionPane.showMessageDialog(null, "There should be at least two files!", "Error", 0);
            return;
        }
        String aFile = inFiles.get(0);
        NetCDFDataInfo aDataInfo = new NetCDFDataInfo();
        aDataInfo.readDataInfo(aFile);
        switch (aDataInfo.getConvention()) {
            case WRFOUT: {
                timeDimStr = "Time";
            }
        }
        for (i = 0; i < aDataInfo.getDimensions().size(); ++i) {
            Dimension aDimS = aDataInfo.getDimensions().get(i);
            if (!aDimS.getShortName().equals(timeDimStr)) continue;
            aDimS.setUnlimited(true);
            break;
        }
        ArrayList<String> varNames = new ArrayList<String>();
        for (Variable var : aDataInfo.getVariables()) {
            if (MIMath.isNumeric(var.getName().substring(0, 1))) {
                var.setName('V' + var.getName());
            }
            varNames.add(var.getName());
        }
        NetcdfFileWriter ncfilew = NetcdfFileWriter.createNew((NetcdfFileWriter.Version)NetcdfFileWriter.Version.netcdf3, (String)outFile);
        ArrayList<ucar.nc2.Dimension> dims = new ArrayList<ucar.nc2.Dimension>();
        for (Dimension dim : aDataInfo.dimensions) {
            if (dim.getShortName().equals(timeDimStr)) {
                dims.add(ncfilew.addUnlimitedDimension(dim.getShortName()));
                continue;
            }
            dims.add(ncfilew.addDimension(null, dim.getShortName(), dim.getLength()));
        }
        for (ucar.nc2.Attribute attr : aDataInfo._gAtts) {
            ncfilew.addGroupAttribute(null, attr);
        }
        for (ucar.nc2.Variable var : aDataInfo._variables) {
            Object dim2;
            ArrayList<ucar.nc2.Dimension> vdims = new ArrayList<ucar.nc2.Dimension>();
            block8: for (Object dim2 : var.getDimensions()) {
                for (ucar.nc2.Dimension vdim : dims) {
                    if (!vdim.getShortName().equals(dim2.getShortName())) continue;
                    vdims.add(vdim);
                    continue block8;
                }
            }
            ucar.nc2.Variable nvar = var.findAttribute("add_offset") != null || var.findAttribute("scale_factor") != null ? ncfilew.addVariable(null, var.getShortName(), DataType.DOUBLE, vdims) : ncfilew.addVariable(null, var.getShortName(), var.getDataType(), vdims);
            if (var.getDimensions().size() == 1 && ((ucar.nc2.Dimension)var.getDimensions().get(0)).getShortName().equals(timeDimStr)) {
                nvar.addAttribute(new ucar.nc2.Attribute("units", "hours since 1800-1-1 00:00:00"));
                nvar.addAttribute(new ucar.nc2.Attribute("long_name", "Time"));
                nvar.addAttribute(new ucar.nc2.Attribute("standard_name", "time"));
                nvar.addAttribute(new ucar.nc2.Attribute("axis", "T"));
                continue;
            }
            dim2 = var.getAttributes().iterator();
            while (dim2.hasNext()) {
                ucar.nc2.Attribute attr = (ucar.nc2.Attribute)dim2.next();
                if (attr.getShortName().equals("add_offset") || attr.getShortName().equals("scale_factor")) continue;
                nvar.addAttribute(attr);
            }
        }
        LocalDateTime sTime = LocalDateTime.of(1800, 1, 1, 0, 0, 0);
        ncfilew.create();
        int tDimNum = 0;
        for (i = 0; i < fNum; ++i) {
            ArrayList<String> dimNames;
            aFile = inFiles.get(i);
            aDataInfo = new NetCDFDataInfo();
            aDataInfo.readDataInfo(aFile);
            if (i == 0) {
                for (ucar.nc2.Variable var : ncfilew.getNetcdfFile().getVariables()) {
                    dimNames = new ArrayList<String>();
                    for (ucar.nc2.Dimension dim : var.getDimensions()) {
                        dimNames.add(dim.getShortName());
                    }
                    if (dimNames.contains(timeDimStr)) continue;
                    org.meteoinfo.ndarray.Array varaData = aDataInfo.read(var.getShortName());
                    ncfilew.write(var, NCUtil.convertArray(varaData));
                }
            }
            for (ucar.nc2.Variable var : ncfilew.getNetcdfFile().getVariables()) {
                if (!varNames.contains(var.getShortName())) continue;
                dimNames = new ArrayList();
                for (ucar.nc2.Dimension dim : var.getDimensions()) {
                    dimNames.add(dim.getShortName());
                }
                if (!dimNames.contains(timeDimStr)) continue;
                ucar.nc2.Variable dvar = aDataInfo.findNCVariable(var.getShortName());
                int tDimIdx = dimNames.indexOf(timeDimStr);
                int dimNum = var.getDimensions().size();
                int[] start = new int[dimNum];
                int[] count = new int[dimNum];
                if (dimNum == 4) {
                    start[2] = 0;
                    count[2] = ((ucar.nc2.Dimension)dvar.getDimensions().get(2)).getLength();
                    start[3] = 0;
                    count[3] = ((ucar.nc2.Dimension)dvar.getDimensions().get(3)).getLength();
                    for (int d1 = 0; d1 < ((ucar.nc2.Dimension)dvar.getDimensions().get(0)).getLength(); ++d1) {
                        start[0] = d1;
                        count[0] = 1;
                        for (int d2 = 0; d2 < ((ucar.nc2.Dimension)dvar.getDimensions().get(1)).getLength(); ++d2) {
                            start[0] = d1;
                            start[1] = d2;
                            count[1] = 1;
                            org.meteoinfo.ndarray.Array varaData = dvar.findAttribute("add_offset") != null || dvar.findAttribute("scale_factor") != null ? aDataInfo.read_pack(dvar.getShortName(), start, count) : aDataInfo.read(dvar.getShortName(), start, count);
                            int n = tDimIdx;
                            start[n] = start[n] + tDimNum;
                            ncfilew.write(var, start, NCUtil.convertArray(varaData));
                        }
                    }
                    continue;
                }
                if (dimNum == 3) {
                    start[1] = 0;
                    count[1] = ((ucar.nc2.Dimension)dvar.getDimensions().get(1)).getLength();
                    start[2] = 0;
                    count[2] = ((ucar.nc2.Dimension)dvar.getDimensions().get(2)).getLength();
                    for (int d1 = 0; d1 < ((ucar.nc2.Dimension)dvar.getDimensions().get(0)).getLength(); ++d1) {
                        start[0] = d1;
                        count[0] = 1;
                        org.meteoinfo.ndarray.Array varaData = dvar.findAttribute("add_offset") != null || dvar.findAttribute("scale_factor") != null ? aDataInfo.read_pack(dvar.getShortName(), start, count) : aDataInfo.read(dvar.getShortName(), start, count);
                        int n = tDimIdx;
                        start[n] = start[n] + tDimNum;
                        ncfilew.write(var, start, NCUtil.convertArray(varaData));
                    }
                    continue;
                }
                for (int v = 0; v < dvar.getDimensions().size(); ++v) {
                    start[v] = 0;
                    count[v] = dvar.getDimension(v).getLength();
                }
                org.meteoinfo.ndarray.Array varaData = aDataInfo.read(dvar.getShortName());
                int n = tDimIdx;
                start[n] = start[n] + tDimNum;
                if (dimNum == 1) {
                    List<Integer> times = aDataInfo.getTimeValues(sTime, "hours");
                    varaData = org.meteoinfo.ndarray.Array.factory(NCUtil.convertDataType(dvar.getDataType()), dvar.getShape());
                    for (int j = 0; j < times.size(); ++j) {
                        varaData.setDouble(j, (double)times.get(j).intValue());
                    }
                    if (i > 0) {
                        var.getDimension(0).setLength(var.getDimension(0).getLength() + varaData.getShape()[0]);
                    }
                }
                ncfilew.write(var, start, NCUtil.convertArray(varaData));
            }
            tDimNum += aDataInfo.findDimension(timeDimStr).getLength();
        }
        ncfilew.flush();
        ncfilew.close();
    }

    public static void joinDataFiles_Variable(List<String> inFiles, String outFile) throws IOException, InvalidRangeException {
        int fNum = inFiles.size();
        if (fNum < 2) {
            JOptionPane.showMessageDialog(null, "There should be at least two files!", "Error", 0);
            return;
        }
        String aFile = inFiles.get(0);
        NetCDFDataInfo aDataInfo = new NetCDFDataInfo();
        aDataInfo.readDataInfo(aFile);
        NetcdfFileWriter ncfile = NetcdfFileWriter.createNew((NetcdfFileWriter.Version)NetcdfFileWriter.Version.netcdf3, (String)outFile);
        for (Dimension dimension : aDataInfo.dimensions) {
            ncfile.addDimension(null, dimension.getShortName(), dimension.getLength(), dimension.isUnlimited(), dimension.isVariableLength());
        }
        for (ucar.nc2.Attribute attribute : aDataInfo._gAtts) {
            ncfile.addGroupAttribute(null, attribute);
        }
        ArrayList<ucar.nc2.Variable> nvars = new ArrayList<ucar.nc2.Variable>();
        for (ucar.nc2.Variable var : aDataInfo._variables) {
            ucar.nc2.Variable nvar = ncfile.addVariable(null, var.getShortName(), var.getDataType(), var.getDimensions());
            for (ucar.nc2.Attribute attr : var.getAttributes()) {
                nvar.addAttribute(attr);
            }
            nvars.add(nvar);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<NetCDFDataInfo> mncf = new ArrayList<NetCDFDataInfo>();
        List<String> varNames = aDataInfo.getVariableNames();
        for (int i = 1; i < fNum; ++i) {
            NetCDFDataInfo df = new NetCDFDataInfo();
            df.readDataInfo(inFiles.get(i));
            ArrayList<ucar.nc2.Variable> vars = new ArrayList<ucar.nc2.Variable>();
            for (ucar.nc2.Variable var : df._variables) {
                if (varNames.contains(var.getShortName())) continue;
                ucar.nc2.Variable nvar = ncfile.addVariable(null, var.getShortName(), var.getDataType(), var.getDimensions());
                for (ucar.nc2.Attribute attr : var.getAttributes()) {
                    nvar.addAttribute(attr);
                }
                vars.add(nvar);
                varNames.add(var.getShortName());
            }
            mncf.add(df);
            arrayList.add(vars);
        }
        ncfile.create();
        for (ucar.nc2.Variable nvar : nvars) {
            int ndim = nvar.getDimensions().size();
            if (ndim < 4) {
                ncfile.write(nvar, NCUtil.convertArray(aDataInfo.read(nvar.getShortName(), false)));
                continue;
            }
            int[] start = new int[ndim];
            int[] count = new int[ndim];
            for (int j = 1; j < ndim; ++j) {
                start[j] = 0;
                count[j] = nvar.getDimension(j).getLength();
            }
            int n = nvar.getDimension(0).getLength();
            int i = 0;
            while (i < n) {
                start[0] = i++;
                count[0] = 1;
                ncfile.write(nvar, start, NCUtil.convertArray(aDataInfo.read(nvar.getShortName(), start, count, false)));
            }
        }
        for (int i = 0; i < mncf.size(); ++i) {
            List vars = (List)arrayList.get(i);
            if (vars.isEmpty()) continue;
            NetCDFDataInfo df = (NetCDFDataInfo)mncf.get(i);
            for (ucar.nc2.Variable nvar : vars) {
                int ndim = nvar.getDimensions().size();
                if (ndim < 4) {
                    ncfile.write(nvar, NCUtil.convertArray(df.read(nvar.getShortName(), false)));
                    continue;
                }
                int[] start = new int[ndim];
                int[] count = new int[ndim];
                int n = nvar.getDimension(0).getLength();
                for (int j = 1; j < ndim; ++j) {
                    start[j] = 0;
                    count[j] = nvar.getDimension(j).getLength();
                }
                int k = 0;
                while (k < n) {
                    start[0] = k++;
                    count[0] = 1;
                    ncfile.write(nvar, start, NCUtil.convertArray(df.read(nvar.getShortName(), start, count, false)));
                }
            }
        }
        ncfile.flush();
        ncfile.close();
    }

    private static int getDataJoinType(NetCDFDataInfo aDataInfo, NetCDFDataInfo bDataInfo, String tDimName) {
        int i;
        int ndims = aDataInfo.getDimensions().size();
        if (ndims != bDataInfo.getDimensions().size()) {
            return 0;
        }
        boolean IsSame = true;
        boolean IsJoinVar = true;
        block0: for (i = 0; i < ndims; ++i) {
            Dimension aDim = aDataInfo.getDimensions().get(i);
            Dimension bDim = bDataInfo.getDimensions().get(i);
            if (!aDim.getShortName().equals(bDim.getShortName())) {
                IsSame = false;
                break;
            }
            if (aDim.getShortName().toLowerCase().equals(tDimName)) {
                if (aDim.getLength() != bDim.getLength()) {
                    IsJoinVar = false;
                }
                for (int j = 0; j < aDataInfo.getTimeNum(); ++j) {
                    double t2;
                    double t1 = aDataInfo.getTimeValue(j);
                    if (t1 == (t2 = bDataInfo.getTimeValue(j))) continue;
                    IsJoinVar = false;
                    continue block0;
                }
                continue;
            }
            if (aDim.getLength() == bDim.getLength()) continue;
            IsSame = false;
            break;
        }
        if (!IsSame) {
            return 0;
        }
        if (IsJoinVar) {
            return 2;
        }
        if (aDataInfo.getVariableNum() != bDataInfo.getVariableNum()) {
            return 0;
        }
        IsSame = true;
        boolean unpack = false;
        for (i = 0; i < aDataInfo.getVariableNum(); ++i) {
            Variable aVarS = aDataInfo.getVariables().get(i);
            Variable bVarS = bDataInfo.getVariables().get(i);
            if (!aVarS.getName().equals(bVarS.getName()) || aVarS.getDimNumber() != bVarS.getDimNumber()) {
                IsSame = false;
                break;
            }
            if (unpack) continue;
            Attribute aao = aVarS.findAttribute("add_offset");
            Attribute asf = aVarS.findAttribute("scale_factor");
            Attribute bao = bVarS.findAttribute("add_offset");
            Attribute bsf = bVarS.findAttribute("scale_factor");
            if (aao != null) {
                if (bao == null) {
                    unpack = true;
                } else {
                    double vbao;
                    double vaao = Double.parseDouble(aao.getValue(0).toString());
                    if (vaao != (vbao = Double.parseDouble(bao.getValue(0).toString()))) {
                        unpack = true;
                    }
                }
            } else if (bao != null) {
                unpack = true;
            }
            if (asf != null) {
                double vbsf;
                if (bsf == null) {
                    unpack = true;
                    continue;
                }
                double vasf = Double.parseDouble(asf.getValue(0).toString());
                if (vasf == (vbsf = Double.parseDouble(bsf.getValue(0).toString()))) continue;
                unpack = true;
                continue;
            }
            if (bsf == null) continue;
            unpack = true;
        }
        if (IsSame) {
            if (unpack) {
                return 3;
            }
            return 1;
        }
        return 0;
    }

    public static void addTimeDimension(String inFile, String outFile, LocalDateTime aTime) {
        try {
            NetCDFDataInfo.addTimeDimension(inFile, outFile, aTime, "days");
        }
        catch (IOException | ParseException | InvalidRangeException ex) {
            Logger.getLogger(NetCDFDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void addTimeDimension(String inFile, String outFile, LocalDateTime aTime, String timeUnit) throws ParseException, IOException, InvalidRangeException {
        NetCDFDataInfo aDataInfo = new NetCDFDataInfo();
        aDataInfo.readDataInfo(inFile);
        List<String> varList = aDataInfo.getVariableNames();
        if (varList.contains("time")) {
            return;
        }
        LocalDateTime sTime = LocalDateTime.of(1800, 1, 1, 0, 0, 0);
        int tvalue = DataInfo.getTimeValue(aTime, sTime, timeUnit.toLowerCase());
        NetcdfFileWriter ncfilew = NetcdfFileWriter.createNew((NetcdfFileWriter.Version)NetcdfFileWriter.Version.netcdf3, (String)outFile);
        for (Dimension dimension : aDataInfo.dimensions) {
            ncfilew.addDimension(null, dimension.getShortName(), dimension.getLength(), dimension.isUnlimited(), dimension.isVariableLength());
        }
        ucar.nc2.Dimension tdim = ncfilew.addDimension(null, "time", 1);
        for (ucar.nc2.Attribute attr : aDataInfo._gAtts) {
            ncfilew.addGroupAttribute(null, attr);
        }
        for (ucar.nc2.Variable var : aDataInfo._variables) {
            List dims = var.getDimensions();
            if (dims.size() > 1) {
                dims.add(0, tdim);
            }
            ucar.nc2.Variable nvar = ncfilew.addVariable(null, var.getShortName(), var.getDataType(), dims);
            for (ucar.nc2.Attribute attr : var.getAttributes()) {
                nvar.addAttribute(attr);
            }
        }
        ArrayList<ucar.nc2.Dimension> arrayList = new ArrayList<ucar.nc2.Dimension>();
        arrayList.add(tdim);
        ucar.nc2.Variable tvar = ncfilew.addVariable(null, "time", DataType.INT, arrayList);
        tvar.addAttribute(new ucar.nc2.Attribute("units", timeUnit.toLowerCase() + " since 1800-1-1 00:00:00"));
        tvar.addAttribute(new ucar.nc2.Attribute("long_name", "Time"));
        tvar.addAttribute(new ucar.nc2.Attribute("standard_name", "time"));
        tvar.addAttribute(new ucar.nc2.Attribute("axis", "T"));
        ncfilew.create();
        for (ucar.nc2.Variable var : aDataInfo._variables) {
            int dimNum = var.getDimensions().size();
            int[] start = new int[dimNum];
            int[] count = new int[dimNum];
            if (dimNum == 4) {
                start[2] = 0;
                count[2] = ((ucar.nc2.Dimension)var.getDimensions().get(2)).getLength();
                start[3] = 0;
                count[3] = ((ucar.nc2.Dimension)var.getDimensions().get(3)).getLength();
                for (int d1 = 0; d1 < ((ucar.nc2.Dimension)var.getDimensions().get(0)).getLength(); ++d1) {
                    start[0] = d1;
                    count[0] = 1;
                    int d2 = 0;
                    while (d2 < ((ucar.nc2.Dimension)var.getDimensions().get(1)).getLength()) {
                        start[0] = d1;
                        start[1] = d2++;
                        count[1] = 1;
                        org.meteoinfo.ndarray.Array varaData = aDataInfo.read(var.getShortName(), start, count);
                        ncfilew.write(var, start, NCUtil.convertArray(varaData));
                    }
                }
                continue;
            }
            if (dimNum == 3) {
                start[1] = 0;
                count[1] = ((ucar.nc2.Dimension)var.getDimensions().get(1)).getLength();
                start[2] = 0;
                count[2] = ((ucar.nc2.Dimension)var.getDimensions().get(2)).getLength();
                int d1 = 0;
                while (d1 < ((ucar.nc2.Dimension)var.getDimensions().get(0)).getLength()) {
                    start[0] = d1++;
                    count[0] = 1;
                    org.meteoinfo.ndarray.Array varaData = aDataInfo.read(var.getShortName(), start, count);
                    ncfilew.write(var, start, NCUtil.convertArray(varaData));
                }
                continue;
            }
            for (int v = 0; v < var.getDimensions().size(); ++v) {
                start[v] = 0;
                count[v] = var.getDimension(v).getLength();
            }
            org.meteoinfo.ndarray.Array varaData = aDataInfo.read(var.getShortName(), start, count);
            ncfilew.write(var, start, NCUtil.convertArray(varaData));
        }
        ArrayInt.D1 timeValue = new ArrayInt.D1(tvalue, false);
        ncfilew.write(tvar, (Array)timeValue);
        ncfilew.flush();
        ncfilew.close();
    }
}

