/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geoprocess.analysis;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.geoprocess.analysis.DistanceType;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.shape.PointZ;
import org.meteoinfo.shape.PolylineZShape;

public class Clustering {
    public static void calculate(String inFile, String outFile, int N, int M, int LN, DistanceType disType) throws FileNotFoundException, IOException {
        int j;
        int i;
        String aLine;
        double[][] DATA = new double[N][M];
        ArrayList<String> flags = new ArrayList<String>();
        BufferedReader sr = new BufferedReader(new FileReader(new File(inFile)));
        int row = 0;
        while ((aLine = sr.readLine()) != null) {
            String[] aDataArray;
            if (aLine.isEmpty() || ((aDataArray = aLine.split(",")).length - 2) / 3 != M / 2) continue;
            flags.add(aDataArray[0] + "," + aDataArray[1]);
            int col = 0;
            for (i = 0; i <= M / 2 - 1; ++i) {
                for (j = 0; j <= 2; ++j) {
                    if (j == 2) continue;
                    DATA[row][col] = Double.parseDouble(aDataArray[i * 3 + j + 2]);
                    ++col;
                }
            }
            ++row;
        }
        sr.close();
        int[][] ICLASS = Clustering.calculation(DATA, LN, disType);
        BufferedWriter sw = new BufferedWriter(new FileWriter(new File(outFile)));
        aLine = "Time,Height";
        for (i = 2; i <= LN; ++i) {
            aLine = aLine + "," + String.valueOf(i) + "CL";
        }
        sw.write(aLine);
        sw.newLine();
        for (i = 0; i <= N - 1; ++i) {
            aLine = (String)flags.get(i);
            for (j = 0; j <= LN - 2; ++j) {
                aLine = aLine + "," + String.valueOf(ICLASS[i][j]);
            }
            sw.write(aLine);
            sw.newLine();
        }
        sw.close();
    }

    public static void calculate(List<VectorLayer> trajLayers, String outFile, int N, int M, int LN, int interval, DistanceType disType) throws IOException {
        int j;
        String aLine;
        int i;
        double[][] DATA = new double[N][M];
        ArrayList<String> flags = new ArrayList<String>();
        int row = 0;
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMddHH");
        for (VectorLayer layer : trajLayers) {
            int sNum = layer.getShapeNum();
            for (i = 0; i < sNum; ++i) {
                LocalDateTime aDate = (LocalDateTime)layer.getCellValue("Date", i);
                int hour = Integer.parseInt(layer.getCellValue("Hour", i).toString());
                aDate = aDate.withHour(hour);
                aLine = format.format(aDate);
                String height = layer.getCellValue("Height", i).toString();
                flags.add(aLine + "," + height);
                PolylineZShape aPLZ = (PolylineZShape)layer.getShapes().get(i);
                int col = 0;
                for (j = 0; j < aPLZ.getPointNum(); ++j) {
                    if (j % interval != 0) continue;
                    PointZ aPoint = (PointZ)aPLZ.getPoints().get(j);
                    DATA[row][col] = aPoint.Y;
                    DATA[row][++col] = aPoint.X;
                    ++col;
                }
                ++row;
            }
        }
        int[][] ICLASS = Clustering.calculation(DATA, LN, disType);
        BufferedWriter sw = new BufferedWriter(new FileWriter(new File(outFile)));
        aLine = "Time,Height";
        for (i = 2; i <= LN; ++i) {
            aLine = aLine + "," + String.valueOf(i) + "CL";
        }
        sw.write(aLine);
        sw.newLine();
        for (i = 0; i <= N - 1; ++i) {
            aLine = (String)flags.get(i);
            for (j = 0; j <= LN - 2; ++j) {
                aLine = aLine + "," + String.valueOf(ICLASS[i][j]);
            }
            sw.write(aLine);
            sw.newLine();
        }
        sw.close();
    }

    public static void calculation(double[][] DATA, String outFile, int LN, DistanceType disType) throws IOException {
        int i;
        int N = DATA.length;
        int M = DATA[0].length;
        double[] CRIT = new double[N];
        double[] MEMBR = new double[N];
        double[] CRITVAL = new double[LN];
        int[] IA = new int[N];
        int[] IB = new int[N];
        int[][] ICLASS = new int[N][LN];
        int[] HVALS = new int[LN];
        int[] IORDER = new int[LN];
        int[] HEIGHT = new int[LN];
        int[] NN = new int[N];
        double[] DISNN = new double[N];
        double[] D = new double[N * (N - 1) / 2];
        boolean[] FLAG = new boolean[N];
        int LEN = N * (N - 1) / 2;
        int IOPT = 1;
        Clustering.HC(N, M, IOPT, DATA, IA, IB, CRIT, MEMBR, NN, DISNN, FLAG, D, disType);
        Clustering.HCASS(N, IA, IB, CRIT, LN, ICLASS, HVALS, IORDER, CRITVAL, HEIGHT);
        BufferedWriter sw = new BufferedWriter(new FileWriter(new File(outFile)));
        String aLine = "NO";
        for (i = 2; i <= LN; ++i) {
            aLine = aLine + "," + String.valueOf(i) + "CL";
        }
        sw.write(aLine);
        sw.newLine();
        for (i = 0; i <= N - 1; ++i) {
            aLine = String.valueOf(i + 1);
            for (int j = 0; j <= LN - 2; ++j) {
                aLine = aLine + "," + String.valueOf(ICLASS[i][j]);
            }
            sw.write(aLine);
            sw.newLine();
        }
        sw.close();
    }

    public static int[][] calculation(double[][] DATA, int LN, DistanceType disType) {
        int N = DATA.length;
        int M = DATA[0].length;
        double[] CRIT = new double[N];
        double[] MEMBR = new double[N];
        double[] CRITVAL = new double[LN];
        int[] IA = new int[N];
        int[] IB = new int[N];
        int[][] ICLASS = new int[N][LN];
        int[] HVALS = new int[LN];
        int[] IORDER = new int[LN];
        int[] HEIGHT = new int[LN];
        int[] NN = new int[N];
        double[] DISNN = new double[N];
        double[] D = new double[N * (N - 1) / 2];
        boolean[] FLAG = new boolean[N];
        int IOPT = 1;
        Clustering.HC(N, M, IOPT, DATA, IA, IB, CRIT, MEMBR, NN, DISNN, FLAG, D, disType);
        Clustering.HCASS(N, IA, IB, CRIT, LN, ICLASS, HVALS, IORDER, CRITVAL, HEIGHT);
        return ICLASS;
    }

    private static void HC(int N, int M, int IOPT, double[][] DATA, int[] IA, int[] IB, double[] CRIT, double[] MEMBR, int[] NN, double[] DISNN, boolean[] FLAG, double[] DISS, DistanceType DISTYPE) {
        double DMIN;
        int k;
        int IND;
        int j;
        int i;
        double INF = 1.0 * Math.pow(10.0, 20.0);
        for (i = 0; i <= N - 1; ++i) {
            MEMBR[i] = 1.0;
            FLAG[i] = true;
        }
        int NCL = N;
        if (DISTYPE == DistanceType.ANGLE) {
            double X0 = DATA[0][0];
            double Y0 = DATA[0][1];
            for (i = 0; i <= N - 2; ++i) {
                for (j = i + 1; j <= N - 1; ++j) {
                    IND = Clustering.IOFFSET(N, i + 1, j + 1);
                    DISS[IND] = 0.0;
                    for (k = 1; k <= M / 2 - 1; ++k) {
                        double A = Math.pow(DATA[i][2 * k] - X0, 2.0) + Math.pow(DATA[i][2 * k + 1] - Y0, 2.0);
                        double B = Math.pow(DATA[j][2 * k] - X0, 2.0) + Math.pow(DATA[j][2 * k + 1] - Y0, 2.0);
                        double C = Math.pow(DATA[j][2 * k] - DATA[i][2 * k], 2.0) + Math.pow(DATA[j][2 * k + 1] - DATA[i][2 * k + 1], 2.0);
                        double ANGLE = A == 0.0 | B == 0.0 ? 0.0 : 0.5 * (A + B - C) / Math.sqrt(A * B);
                        if (Math.abs(ANGLE) > 1.0) {
                            ANGLE = 1.0;
                        }
                        DISS[IND] = DISS[IND] + Math.acos(ANGLE);
                    }
                    DISS[IND] = DISS[IND] / (double)(M / 2);
                    if (IOPT != 1) continue;
                    DISS[IND] = DISS[IND] / 2.0;
                }
            }
        } else {
            for (i = 0; i <= N - 2; ++i) {
                for (j = i + 1; j <= N - 1; ++j) {
                    IND = Clustering.IOFFSET(N, i + 1, j + 1);
                    DISS[IND] = 0.0;
                    for (k = 0; k <= M / 2 - 1; ++k) {
                        DISS[IND] = DISS[IND] + Math.pow(DATA[i][2 * k] - DATA[j][2 * k], 2.0) + Math.pow(DATA[i][2 * k + 1] - DATA[j][2 * k + 1], 2.0);
                    }
                    DISS[IND] = Math.sqrt(DISS[IND]);
                    if (IOPT != 1) continue;
                    DISS[IND] = DISS[IND] / 2.0;
                }
            }
        }
        int JM = 0;
        for (i = 0; i <= N - 2; ++i) {
            DMIN = INF;
            for (j = i + 1; j <= N - 1; ++j) {
                IND = Clustering.IOFFSET(N, i + 1, j + 1);
                if (DISS[IND] >= DMIN) continue;
                DMIN = DISS[IND];
                JM = j;
            }
            NN[i] = JM;
            DISNN[i] = DMIN;
        }
        do {
            int IM = 0;
            DMIN = INF;
            for (i = 0; i <= N - 2; ++i) {
                if (!FLAG[i] || DISNN[i] >= DMIN) continue;
                DMIN = DISNN[i];
                IM = i;
                JM = NN[i];
            }
            int I2 = Math.min(IM, JM);
            int J2 = Math.max(IM, JM);
            IA[N - --NCL - 1] = I2 + 1;
            IB[N - NCL - 1] = J2 + 1;
            CRIT[N - NCL - 1] = DMIN;
            int JJ = 0;
            FLAG[J2] = false;
            DMIN = INF;
            for (k = 0; k <= N - 1; ++k) {
                if (!FLAG[k] || k == I2) continue;
                double X = MEMBR[I2] + MEMBR[J2] + MEMBR[k];
                int IND1 = I2 < k ? Clustering.IOFFSET(N, I2 + 1, k + 1) : Clustering.IOFFSET(N, k + 1, I2 + 1);
                int IND2 = J2 < k ? Clustering.IOFFSET(N, J2 + 1, k + 1) : Clustering.IOFFSET(N, k + 1, J2 + 1);
                int IND3 = Clustering.IOFFSET(N, I2 + 1, J2 + 1);
                double XX = DISS[IND3];
                if (IOPT == 1) {
                    DISS[IND1] = (MEMBR[I2] + MEMBR[k]) * DISS[IND1] + (MEMBR[J2] + MEMBR[k]) * DISS[IND2] - MEMBR[k] * XX;
                    DISS[IND1] = DISS[IND1] / X;
                }
                if (IOPT == 2) {
                    DISS[IND1] = Math.min(DISS[IND1], DISS[IND2]);
                }
                if (IOPT == 3) {
                    DISS[IND1] = Math.max(DISS[IND1], DISS[IND2]);
                }
                if (IOPT == 4) {
                    DISS[IND1] = (MEMBR[I2] * DISS[IND1] + MEMBR[J2] * DISS[IND2]) / (MEMBR[I2] + MEMBR[J2]);
                }
                if (IOPT == 5) {
                    DISS[IND1] = 0.5 * DISS[IND1] + 0.5 * DISS[IND2];
                }
                if (IOPT == 6) {
                    DISS[IND1] = 0.5 * DISS[IND1] + 0.5 * DISS[IND2] - 0.25 * XX;
                }
                if (IOPT == 7) {
                    DISS[IND1] = (MEMBR[I2] * DISS[IND1] + MEMBR[J2] * DISS[IND2] - MEMBR[I2] * MEMBR[J2] * XX / (MEMBR[I2] + MEMBR[J2])) / (MEMBR[I2] + MEMBR[J2]);
                }
                if (I2 > k || DISS[IND1] >= DMIN) continue;
                DMIN = DISS[IND1];
                JJ = k;
            }
            MEMBR[I2] = MEMBR[I2] + MEMBR[J2];
            DISNN[I2] = DMIN;
            NN[I2] = JJ;
            for (i = 0; i <= N - 2; ++i) {
                if (!FLAG[i] || !(NN[i] == I2 | NN[i] == J2)) continue;
                DMIN = INF;
                for (j = i + 1; j <= N - 1; ++j) {
                    IND = Clustering.IOFFSET(N, i + 1, j + 1);
                    if (!FLAG[j] || i == j || DISS[IND] >= DMIN) continue;
                    DMIN = DISS[IND];
                    JJ = j;
                }
                NN[i] = JJ;
                DISNN[i] = DMIN;
            }
        } while (NCL != 1);
    }

    private static int IOFFSET(int N, int I, int J) {
        return J + (I - 1) * N - I * (I + 1) / 2 - 1;
    }

    private static void HCASS(int N, int[] IA, int[] IB, double[] CRIT, int LEV, int[][] ICLASS, int[] HVALS, int[] IORDER, double[] CRITVAL, int[] HEIGHT) {
        int j;
        int i;
        HVALS[0] = 1;
        HVALS[1] = IB[N - 2];
        int LOC = 2;
        for (i = N - 3; i >= N - LEV; --i) {
            boolean ifGo = true;
            for (j = 0; j <= LOC - 1; ++j) {
                if (IA[i] != HVALS[j]) continue;
                ifGo = false;
            }
            if (ifGo) {
                HVALS[LOC] = IA[i];
                ++LOC;
            }
            ifGo = true;
            for (j = 0; j <= LOC - 1; ++j) {
                if (IB[i] != HVALS[j]) continue;
                ifGo = false;
            }
            if (!ifGo) continue;
            HVALS[LOC] = IB[i];
            ++LOC;
        }
        for (int LEVEL = N - LEV; LEVEL <= N - 2; ++LEVEL) {
            for (i = 0; i <= N - 1; ++i) {
                int ICL = i + 1;
                for (int ILEV = 0; ILEV <= LEVEL - 1; ++ILEV) {
                    if (IB[ILEV] != ICL) continue;
                    ICL = IA[ILEV];
                }
                int NCL = N - LEVEL - 1;
                ICLASS[i][NCL - 1] = ICL;
            }
        }
        for (i = 0; i <= N - 1; ++i) {
            block7: for (j = 0; j <= LEV - 2; ++j) {
                for (int k = 1; k <= LEV - 1; ++k) {
                    if (ICLASS[i][j] != HVALS[k]) continue;
                    ICLASS[i][j] = k + 1;
                    continue block7;
                }
            }
        }
    }

    private static void HCDEN(int LEV, int[] IORDER, int[] HEIGHT, double[] CRITVAL) {
    }
}

