/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.global.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.joda.time.Years;
import org.joda.time.format.DateTimeFormatter;
import org.meteoinfo.global.util.BigDecimalUtil;
import org.meteoinfo.global.util.TypeUtilsBak;

public class DateUtil {
    public static Date addDays(Date sDate, float days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(sDate);
        int intDays = (int)days;
        cal.add(6, intDays);
        int hours = (int)((days - (float)intDays) * 24.0f);
        cal.add(10, hours);
        return cal.getTime();
    }

    public static int getDaysInMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, 1);
        return cal.getActualMaximum(5);
    }

    public static List<Integer> getTimeDeltaValues(List<Date> times, Date baseDate, String tDelta) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseDate);
        long sl = cal.getTimeInMillis();
        for (int i = 0; i < times.size(); ++i) {
            int value;
            cal.setTime(times.get(i));
            long el = cal.getTimeInMillis();
            long delta = el - sl;
            if (tDelta.equalsIgnoreCase("hours")) {
                value = (int)(delta / 3600000L);
                values.add(value);
                continue;
            }
            if (!tDelta.equalsIgnoreCase("days")) continue;
            value = (int)(delta / 86400000L);
            values.add(value);
        }
        return values;
    }

    public static int getTimeDeltaValue(Date t, Date baseDate, String tDelta) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseDate);
        long sl = cal.getTimeInMillis();
        int value = 0;
        cal.setTime(t);
        long el = cal.getTimeInMillis();
        long delta = el - sl;
        if (tDelta.equalsIgnoreCase("hours")) {
            value = (int)(delta / 3600000L);
        } else if (tDelta.equalsIgnoreCase("days")) {
            value = (int)(delta / 86400000L);
        }
        return value;
    }

    public static int getDays(Date t, Date baseDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseDate);
        long sl = cal.getTimeInMillis();
        cal.setTime(t);
        long el = cal.getTimeInMillis();
        long delta = el - sl;
        int value = (int)(delta / 86400000L);
        return value;
    }

    public static int getHours(Date t, Date baseDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseDate);
        long sl = cal.getTimeInMillis();
        cal.setTime(t);
        long el = cal.getTimeInMillis();
        long delta = el - sl;
        int value = (int)(delta / 3600000L);
        return value;
    }

    public static Date fromOADate(double oaDate) {
        Date date = new Date();
        long t = (long)BigDecimalUtil.mul(oaDate, 1000000.0);
        date.setTime(t);
        return date;
    }

    public static double toOADate(Date date) {
        double oaDate = date.getTime();
        oaDate = BigDecimalUtil.div(oaDate, 1000000.0);
        return oaDate;
    }

    public static boolean equals(Date a, Date b) {
        return a.getTime() == b.getTime();
    }

    public static int dayOfYear(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day);
        int doy = cal.get(6);
        return doy;
    }

    public static Date doy2date(int year, int doy) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(6, doy);
        return cal.getTime();
    }

    public static PeriodType getPeriodType(String p) {
        PeriodType pt = PeriodType.days();
        switch (p) {
            case "H": {
                pt = PeriodType.hours();
                break;
            }
            case "M": {
                pt = PeriodType.minutes();
                break;
            }
            case "S": {
                pt = PeriodType.seconds();
                break;
            }
            case "m": {
                pt = PeriodType.months();
                break;
            }
            case "Y": {
                pt = PeriodType.years();
            }
        }
        return pt;
    }

    public static ReadablePeriod getPeriod(String pStr) {
        Hours pe;
        String p;
        int n = 1;
        int idx = 0;
        for (int i = 0; i < pStr.length() && !Character.isLetter(pStr.charAt(i)); ++i) {
            ++idx;
        }
        if (idx == 0) {
            p = pStr;
        } else {
            p = pStr.substring(idx);
            n = Integer.parseInt(pStr.substring(0, idx));
        }
        switch (p) {
            case "H": {
                pe = Hours.hours((int)n);
                break;
            }
            case "T": 
            case "Min": {
                pe = Minutes.minutes((int)n);
                break;
            }
            case "S": {
                pe = Seconds.seconds((int)n);
                break;
            }
            case "D": {
                pe = Days.days((int)n);
                break;
            }
            case "W": {
                pe = Weeks.weeks((int)n);
                break;
            }
            case "M": {
                pe = Months.months((int)n);
                break;
            }
            case "Y": {
                pe = Years.years((int)n);
                break;
            }
            default: {
                pe = new Period();
            }
        }
        return pe;
    }

    public static String getDateFormat(ReadablePeriod p) {
        String df = "yyyy-MM-dd";
        if (p instanceof Hours) {
            df = "yyyy-MM-dd HH";
        } else if (p instanceof Minutes) {
            df = "yyyy-MM-dd HH:mm";
        } else if (p instanceof Seconds) {
            df = "yyyy-MM-dd HH:mm:ss";
        }
        return df;
    }

    public static DateTime getDateTime(String dts) {
        int year;
        int day;
        int month;
        String[] ymd;
        String dateStr = dts;
        String timeStr = null;
        if (dts.contains(":")) {
            String[] v = dts.split("\\s+");
            dateStr = v[0].trim();
            timeStr = v[1].trim();
        }
        if (dateStr.contains("/")) {
            ymd = dateStr.split("/");
            month = Integer.parseInt(ymd[0]);
            day = Integer.parseInt(ymd[1]);
            year = Integer.parseInt(ymd[2]);
        } else if (dateStr.contains("-")) {
            ymd = dateStr.split("-");
            month = Integer.parseInt(ymd[1]);
            day = Integer.parseInt(ymd[2]);
            year = Integer.parseInt(ymd[0]);
        } else {
            year = Integer.parseInt(dateStr.substring(0, 4));
            month = Integer.parseInt(dateStr.substring(4, 6));
            day = Integer.parseInt(dateStr.substring(6));
        }
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (timeStr != null) {
            String[] hms = timeStr.split(":");
            hour = Integer.parseInt(hms[0]);
            minute = Integer.parseInt(hms[1]);
            second = hms.length == 3 ? Integer.parseInt(hms[2]) : 0;
        }
        return new DateTime(year, month, day, hour, minute, second);
    }

    public static DateTime getDateTime_(String dts) {
        DateTimeFormatter dtf = dts.contains(":") ? TypeUtilsBak.getDateTimeFormatter(dts) : TypeUtilsBak.getDateFormatter(dts);
        DateTime dt = dtf.parseDateTime(dts);
        return dt;
    }

    public static List<DateTime> getDateTimes(DateTime start, DateTime end, ReadablePeriod p) {
        ArrayList<DateTime> dts = new ArrayList<DateTime>();
        while (!start.isAfter((ReadableInstant)end)) {
            dts.add(start);
            start = start.plus(p);
        }
        return dts;
    }

    public static List<DateTime> getDateTimes(DateTime start, int tNum, ReadablePeriod p) {
        ArrayList<DateTime> dts = new ArrayList<DateTime>();
        for (int i = 0; i < tNum; ++i) {
            dts.add(start);
            start = start.plus(p);
        }
        return dts;
    }

    public static List<DateTime> getDateTimes(int tNum, DateTime end, ReadablePeriod p) {
        ArrayList<DateTime> dts = new ArrayList<DateTime>();
        for (int i = 0; i < tNum; ++i) {
            dts.add(end);
            end = end.minus(p);
        }
        return dts;
    }
}

