/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.Imaging;
import org.meteoinfo.image.AnimatedGifEncoder;
import org.meteoinfo.math.ArrayMath;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.Index1D;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;

public class ImageUtil {
    private static final double INCH_2_CM = 2.54;

    public static Array imageRead(String fileName) throws IOException, ImageReadException {
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        BufferedImage image = extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("jpeg") ? ImageIO.read(new File(fileName)) : Imaging.getBufferedImage((File)new File(fileName));
        return ImageUtil.imageRead(image);
    }

    public static Array imageRead(BufferedImage image) {
        int xn = image.getWidth();
        int yn = image.getHeight();
        Array r = Array.factory(DataType.INT, new int[]{yn, xn, 3});
        Index index = r.getIndex();
        for (int i = 0; i < yn; ++i) {
            for (int j = 0; j < xn; ++j) {
                int rgb = image.getRGB(j, yn - i - 1);
                Color color = new Color(rgb);
                r.setInt(index.set(i, j, 0), color.getRed());
                r.setInt(index.set(i, j, 1), color.getGreen());
                r.setInt(index.set(i, j, 2), color.getBlue());
            }
        }
        return r;
    }

    public static BufferedImage imageLoad(String fileName) throws IOException, ImageReadException {
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        BufferedImage image = extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("jpeg") ? ImageIO.read(new File(fileName)) : Imaging.getBufferedImage((File)new File(fileName));
        return image;
    }

    public static BufferedImage createImage(Array data) {
        boolean isAlpha;
        int width = data.getShape()[1];
        int height = data.getShape()[0];
        Color undefColor = Color.white;
        BufferedImage aImage = new BufferedImage(width, height, 2);
        Index index = data.getIndex();
        boolean bl = isAlpha = data.getShape()[2] == 4;
        if (data.getDataType() == DataType.FLOAT || data.getDataType() == DataType.DOUBLE) {
            if (isAlpha) {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        float r = data.getFloat(index.set(i, j, 0));
                        float g = data.getFloat(index.set(i, j, 1));
                        float b = data.getFloat(index.set(i, j, 2));
                        float a = data.getFloat(index.set(i, j, 3));
                        Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) || Double.isNaN(a) ? undefColor : new Color(r, g, b, a);
                        aImage.setRGB(j, height - i - 1, color.getRGB());
                    }
                }
            } else {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        float r = data.getFloat(index.set(i, j, 0));
                        float g = data.getFloat(index.set(i, j, 1));
                        float b = data.getFloat(index.set(i, j, 2));
                        Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) ? undefColor : new Color(r, g, b);
                        aImage.setRGB(j, height - i - 1, color.getRGB());
                    }
                }
            }
        } else if (isAlpha) {
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int r = data.getInt(index.set(i, j, 0));
                    int g = data.getInt(index.set(i, j, 1));
                    int b = data.getInt(index.set(i, j, 2));
                    int a = data.getInt(index.set(i, j, 3));
                    Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) || Double.isNaN(a) ? undefColor : new Color(r, g, b, a);
                    aImage.setRGB(j, height - i - 1, color.getRGB());
                }
            }
        } else {
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int r = data.getInt(index.set(i, j, 0));
                    int g = data.getInt(index.set(i, j, 1));
                    int b = data.getInt(index.set(i, j, 2));
                    Color color = Double.isNaN(r) || Double.isNaN(g) || Double.isNaN(b) ? undefColor : new Color(r, g, b);
                    aImage.setRGB(j, height - i - 1, color.getRGB());
                }
            }
        }
        return aImage;
    }

    public static void imageSave(Array data, String fileName) throws IOException, ImageWriteException {
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        BufferedImage image = ImageUtil.createImage(data);
        ImageFormat format = ImageUtil.getImageFormat(extension);
        if (format == ImageFormats.JPEG) {
            ImageIO.write((RenderedImage)image, extension, new File(fileName));
        } else {
            Imaging.writeImage((BufferedImage)image, (File)new File(fileName), (ImageFormat)format, null);
        }
    }

    public static void imageSave(BufferedImage image, String fileName) throws IOException, ImageWriteException {
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        ImageFormat format = ImageUtil.getImageFormat(extension);
        if (format == ImageFormats.JPEG) {
            ImageIO.write((RenderedImage)image, extension, new File(fileName));
        } else {
            Imaging.writeImage((BufferedImage)image, (File)new File(fileName), (ImageFormat)format, null);
        }
    }

    private static ImageFormat getImageFormat(String ext) {
        ImageFormats format = ImageFormats.PNG;
        switch (ext.toLowerCase()) {
            case "gif": {
                format = ImageFormats.GIF;
                break;
            }
            case "jpeg": 
            case "jpg": {
                format = ImageFormats.JPEG;
                break;
            }
            case "bmp": {
                format = ImageFormats.BMP;
                break;
            }
            case "tif": 
            case "tiff": {
                format = ImageFormats.TIFF;
            }
        }
        return format;
    }

    public static Array count(Array data, int size) {
        int ny = data.getShape()[0];
        int nx = data.getShape()[1];
        int skip = size / 2;
        Array r = Array.factory(DataType.INT, data.getShape());
        for (int i = 0; i < ny; ++i) {
            int j;
            if (i < skip || i >= ny - skip) {
                for (j = 0; j < nx; ++j) {
                    r.setInt(i * nx + j, 0);
                }
                continue;
            }
            for (j = 0; j < nx; ++j) {
                if (j < skip || j >= nx - skip) {
                    r.setInt(i * nx + j, 0);
                    continue;
                }
                int n = 0;
                for (int ii = i - skip; ii <= i + skip; ++ii) {
                    for (int jj = j - skip; jj <= j + skip; ++jj) {
                        if (!(data.getDouble(ii * nx + jj) > 0.0)) continue;
                        ++n;
                    }
                }
                r.setInt(i * nx + j, n);
            }
        }
        return r;
    }

    public static Array mean(Array data, int size, boolean positive) {
        int ny = data.getShape()[0];
        int nx = data.getShape()[1];
        int skip = size / 2;
        Array r = Array.factory(data.getDataType(), data.getShape());
        for (int i = 0; i < ny; ++i) {
            int j;
            if (i < skip || i >= ny - skip) {
                for (j = 0; j < nx; ++j) {
                    r.setObject(i * nx + j, (Object)0);
                }
                continue;
            }
            for (j = 0; j < nx; ++j) {
                int jj;
                int ii;
                if (j < skip || j >= nx - skip) {
                    r.setObject(i * nx + j, (Object)0);
                    continue;
                }
                int n = 0;
                double sum = 0.0;
                if (positive) {
                    for (ii = i - skip; ii <= i + skip; ++ii) {
                        for (jj = j - skip; jj <= j + skip; ++jj) {
                            if (!(data.getDouble(ii * nx + jj) > 0.0)) continue;
                            sum += data.getDouble(ii * nx + jj);
                            ++n;
                        }
                    }
                } else {
                    for (ii = i - skip; ii <= i + skip; ++ii) {
                        for (jj = j - skip; jj <= j + skip; ++jj) {
                            if (Double.isNaN(data.getDouble(ii * nx + jj))) continue;
                            sum += data.getDouble(ii * nx + jj);
                            ++n;
                        }
                    }
                }
                if (n > 0) {
                    r.setObject(i * nx + j, (Object)(sum / (double)n));
                    continue;
                }
                r.setObject(i * nx + j, (Object)0);
            }
        }
        return r;
    }

    public static Array minimumFilter(Array data, int size) throws InvalidRangeException {
        int[] shape = data.getShape();
        int half = size / 2;
        int n = data.getRank();
        Array r = Array.factory(data.getDataType(), shape);
        IndexIterator iter = data.getIndexIterator();
        IndexIterator riter = r.getIndexIterator();
        while (iter.hasNext()) {
            iter.next();
            int[] counter = iter.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int i = 0; i < n; ++i) {
                int si = counter[i] - half >= 0 ? counter[i] - half : 0;
                int ei = counter[i] + half < shape[i] ? counter[i] + half : shape[i] - 1;
                ranges.add(new Range(si, ei));
            }
            Array temp = data.section(ranges);
            double min = ArrayMath.min(temp).doubleValue();
            riter.setDoubleNext(min);
        }
        return r;
    }

    public static Array maximumFilter(Array data, int size) throws InvalidRangeException {
        int[] shape = data.getShape();
        int half = size / 2;
        int n = data.getRank();
        Array r = Array.factory(data.getDataType(), shape);
        IndexIterator iter = data.getIndexIterator();
        IndexIterator riter = r.getIndexIterator();
        while (iter.hasNext()) {
            iter.next();
            int[] counter = iter.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int i = 0; i < n; ++i) {
                int si = counter[i] - half >= 0 ? counter[i] - half : 0;
                int ei = counter[i] + half < shape[i] ? counter[i] + half : shape[i] - 1;
                ranges.add(new Range(si, ei));
            }
            Array temp = data.section(ranges);
            double max = ArrayMath.max(temp).doubleValue();
            riter.setDoubleNext(max);
        }
        return r;
    }

    private static Array corrlated1D(Array a, double[] weights) {
        int size = weights.length;
        int origin = size / 2;
        int n = (int)a.getSize();
        Array r = Array.factory(a.getDataType(), a.getShape());
        Index1D index = (Index1D)a.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            double v = 0.0;
            for (int j = 0; j < size; ++j) {
                int idx = i - origin + j;
                if (idx < 0) {
                    idx = -idx;
                } else if (idx > n - 1) {
                    idx = n - 1 - (idx - (n - 1));
                }
                index.set(idx);
                v += a.getDouble(index) * weights[j];
            }
            r.setDouble(i, v);
            ++i;
        }
        return r;
    }

    public static Array gaussianFilter(Array data, int size, double sigma) throws InvalidRangeException {
        int i;
        double[] weights = new double[size];
        double sum = 0.0;
        int origin = size / 2;
        for (i = 0; i < size; ++i) {
            double g = Math.exp((double)(-(i - origin) * (i - origin)) / (2.0 * sigma * sigma));
            sum += g;
            weights[i] = g;
        }
        i = 0;
        while (i < size) {
            int n = i++;
            weights[n] = weights[n] / sum;
        }
        int ndim = data.getRank();
        int[] shape = data.getShape();
        Array r = Array.factory(data.getDataType(), shape);
        Index rindex = r.getIndex();
        int[] rcurrent = new int[ndim];
        for (int axis = 0; axis < ndim; ++axis) {
            int[] nshape = new int[ndim - 1];
            for (int i2 = 0; i2 < ndim; ++i2) {
                if (i2 < axis) {
                    nshape[i2] = shape[i2];
                    continue;
                }
                if (i2 <= axis) continue;
                nshape[i2 - 1] = shape[i2];
            }
            Index index = Index.factory(nshape);
            int i3 = 0;
            while ((long)i3 < index.getSize()) {
                int[] current = index.getCurrentCounter();
                ArrayList<Range> ranges = new ArrayList<Range>();
                for (int j = 0; j < ndim; ++j) {
                    if (j == axis) {
                        ranges.add(new Range(0, shape[j] - 1, 1));
                        rcurrent[j] = 0;
                        continue;
                    }
                    int idx = j;
                    if (idx > axis) {
                        --idx;
                    }
                    ranges.add(new Range(current[idx], current[idx], 1));
                    rcurrent[j] = current[idx];
                }
                Array temp = data.section(ranges);
                temp = ImageUtil.corrlated1D(temp, weights);
                for (int j = 0; j < shape[axis]; ++j) {
                    rcurrent[axis] = j;
                    rindex.set(rcurrent);
                    r.setDouble(rindex, temp.getDouble(j));
                }
                index.incr();
                ++i3;
            }
        }
        return r;
    }

    public static void createGifAnimator(List<String> inImageFiles, String outGifFile, int delay, int repeat) {
        try {
            AnimatedGifEncoder e = new AnimatedGifEncoder();
            e.setRepeat(0);
            e.setDelay(delay);
            e.start(outGifFile);
            for (String infn : inImageFiles) {
                e.addFrame(ImageIO.read(new File(infn)));
            }
            e.finish();
        }
        catch (Exception e) {
            System.out.println("Create gif animator failed:");
            e.printStackTrace();
        }
    }

    public static void createGifAnimator(List<String> inImageFiles, String outGifFile, int delay) {
        ImageUtil.createGifAnimator(inImageFiles, outGifFile, delay, 0);
    }

    public static void createGifAnimator(File[] infiles, File outfile, int delay) {
        try {
            AnimatedGifEncoder e = new AnimatedGifEncoder();
            e.setRepeat(0);
            e.setDelay(delay);
            e.start(outfile.getCanonicalPath());
            for (File inf : infiles) {
                e.addFrame(ImageIO.read(inf));
            }
            e.finish();
        }
        catch (Exception e) {
            System.out.println("Create gif animator failed:");
            e.printStackTrace();
        }
    }

    public static void setDPI(IIOMetadata metadata, float dpi) throws IIOInvalidTreeException {
        double dotsPerMilli = 1.0 * (double)dpi / 10.0 / 2.54;
        IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
        horiz.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
        vert.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode dim = new IIOMetadataNode("Dimension");
        dim.appendChild(horiz);
        dim.appendChild(vert);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(dim);
        metadata.mergeTree("javax_imageio_1.0", root);
    }
}

