/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.layer;

import com.l2fprod.common.model.DefaultBeanInfoResolver;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.BeanInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.ParserConfigurationException;
import org.meteoinfo.global.GenericFileFilter;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.layer.ChartSet;
import org.meteoinfo.layer.FrmChartLabel;
import org.meteoinfo.layer.ImageLayer;
import org.meteoinfo.layer.LayerTypes;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.layer.RasterLayer;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.layer.WebMapLayer;
import org.meteoinfo.legend.AlignType;
import org.meteoinfo.legend.ChartTypes;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.FrmLegendBreaks;
import org.meteoinfo.legend.LegendManage;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.LegendType;
import org.meteoinfo.legend.LegendView;
import org.meteoinfo.legend.MapFrame;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.legend.PolylineBreak;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.shape.PointZ;
import org.meteoinfo.shape.Shape;
import org.meteoinfo.shape.ShapeTypes;
import org.meteoinfo.table.DataRow;
import org.meteoinfo.ui.CheckBoxListEntry;
import org.meteoinfo.ui.JCheckBoxList;
import org.xml.sax.SAXException;

public class FrmLayerProperty
extends JDialog {
    private MapLayer _mapLayer = null;
    private Object _object;
    private MapFrame _mapFrame = null;
    private LegendScheme _legendScheme = null;
    private boolean _ifCreateLegendScheme = false;
    private boolean _isLoading = false;
    private JCheckBoxList checkBoxList_Fields;
    private JButton jButton_AddBreak;
    private JButton jButton_Apply;
    private JButton jButton_Cancel;
    private JButton jButton_ChartLabel;
    private JButton jButton_ExportLegend;
    private JButton jButton_ImportLegend;
    private JButton jButton_MakeBreaks;
    private JButton jButton_MoveBreakDown;
    private JButton jButton_MoveBreakUp;
    private JButton jButton_OK;
    private JButton jButton_RemoveAllBreaks;
    private JButton jButton_RemoveBreak;
    private JButton jButton_ReverseBreaks;
    private JCheckBox jCheckBox_CollisionAvoidance;
    private JCheckBox jCheckBox_DisplayIn3D;
    private JComboBox jComboBox_Align;
    private JComboBox jComboBox_ChartType;
    private JComboBox jComboBox_Field;
    private JComboBox jComboBox_LegendType;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabel_BarWidth;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel_Chart;
    private JPanel jPanel_General;
    private JPanel jPanel_Legend;
    private JScrollPane jScrollPane2;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextField_BarWidth;
    private JTextField jTextField_Maximum;
    private JTextField jTextField_Minimum;
    private JTextField jTextField_Thickness;
    private JTextField jTextField_XShift;
    private JTextField jTextField_YShift;
    private JToolBar jToolBar1;
    private LegendView legendView1;
    private LegendView legendView_Chart;
    private PropertySheetPanel propertySheetPanel1;

    public FrmLayerProperty(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.jButton_Cancel = new JButton();
        this.jButton_OK = new JButton();
        this.jButton_Apply = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel_General = new JPanel();
        this.propertySheetPanel1 = new PropertySheetPanel();
        this.jPanel_Legend = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.jButton_ImportLegend = new JButton();
        this.jButton_ExportLegend = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButton_AddBreak = new JButton();
        this.jButton_RemoveBreak = new JButton();
        this.jButton_RemoveAllBreaks = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButton_MoveBreakUp = new JButton();
        this.jButton_MoveBreakDown = new JButton();
        this.jButton_ReverseBreaks = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButton_MakeBreaks = new JButton();
        this.legendView1 = new LegendView();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jComboBox_LegendType = new JComboBox();
        this.jComboBox_Field = new JComboBox();
        this.jPanel_Chart = new JPanel();
        this.jLabel3 = new JLabel();
        this.jComboBox_ChartType = new JComboBox();
        this.legendView_Chart = new LegendView();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jTextField_Minimum = new JTextField();
        this.jLabel5 = new JLabel();
        this.jTextField_Maximum = new JTextField();
        this.jLabel_BarWidth = new JLabel();
        this.jTextField_BarWidth = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextField_XShift = new JTextField();
        this.jLabel8 = new JLabel();
        this.jTextField_YShift = new JTextField();
        this.jCheckBox_CollisionAvoidance = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.jComboBox_Align = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jCheckBox_DisplayIn3D = new JCheckBox();
        this.jLabel10 = new JLabel();
        this.jTextField_Thickness = new JTextField();
        this.jScrollPane2 = new JScrollPane();
        this.checkBoxList_Fields = new JCheckBoxList();
        this.jButton_ChartLabel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Layer Property");
        this.setResizable(false);
        this.jButton_Cancel.setText("Cancel");
        this.jButton_Cancel.setPreferredSize(new Dimension(70, 27));
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLayerProperty.this.jButton_CancelActionPerformed(evt);
            }
        });
        this.jButton_OK.setText("OK");
        this.jButton_OK.setPreferredSize(new Dimension(70, 27));
        this.jButton_OK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLayerProperty.this.jButton_OKActionPerformed(evt);
            }
        });
        this.jButton_Apply.setText("Apply");
        this.jButton_Apply.setPreferredSize(new Dimension(70, 27));
        this.jButton_Apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLayerProperty.this.jButton_ApplyActionPerformed(evt);
            }
        });
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmLayerProperty.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jPanel_General.setToolTipText("");
        GroupLayout jPanel_GeneralLayout = new GroupLayout(this.jPanel_General);
        this.jPanel_General.setLayout(jPanel_GeneralLayout);
        jPanel_GeneralLayout.setHorizontalGroup(jPanel_GeneralLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.propertySheetPanel1, -1, 378, Short.MAX_VALUE));
        jPanel_GeneralLayout.setVerticalGroup(jPanel_GeneralLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.propertySheetPanel1, -1, 409, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("General", this.jPanel_General);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButton_ImportLegend.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Open.Image.png")));
        this.jButton_ImportLegend.setToolTipText("Import Legend");
        this.jButton_ImportLegend.setFocusable(false);
        this.jButton_ImportLegend.setHorizontalTextPosition(0);
        this.jButton_ImportLegend.setVerticalTextPosition(3);
        this.jButton_ImportLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLayerProperty.this.jButton_ImportLegendActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_ImportLegend);
        this.jButton_ExportLegend.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Save.Image.png")));
        this.jButton_ExportLegend.setToolTipText("Export Legend");
        this.jButton_ExportLegend.setFocusable(false);
        this.jButton_ExportLegend.setHorizontalTextPosition(0);
        this.jButton_ExportLegend.setVerticalTextPosition(3);
        this.jButton_ExportLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLayerProperty.this.jButton_ExportLegendActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_ExportLegend);
        this.jToolBar1.add(this.jSeparator1);
        this.jButton_AddBreak.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Add.Image.png")));
        this.jButton_AddBreak.setToolTipText("Add Break");
        this.jButton_AddBreak.setFocusable(false);
        this.jButton_AddBreak.setHorizontalTextPosition(0);
        this.jButton_AddBreak.setVerticalTextPosition(3);
        this.jButton_AddBreak.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLayerProperty.this.jButton_AddBreakActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_AddBreak);
        this.jButton_RemoveBreak.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Del.Image.png")));
        this.jButton_RemoveBreak.setToolTipText("Remove Break");
        this.jButton_RemoveBreak.setFocusable(false);
        this.jButton_RemoveBreak.setHorizontalTextPosition(0);
        this.jButton_RemoveBreak.setVerticalTextPosition(3);
        this.jButton_RemoveBreak.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLayerProperty.this.jButton_RemoveBreakActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_RemoveBreak);
        this.jButton_RemoveAllBreaks.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_DelAll.Image.png")));
        this.jButton_RemoveAllBreaks.setToolTipText("Remove All Breaks");
        this.jButton_RemoveAllBreaks.setFocusable(false);
        this.jButton_RemoveAllBreaks.setHorizontalTextPosition(0);
        this.jButton_RemoveAllBreaks.setVerticalTextPosition(3);
        this.jButton_RemoveAllBreaks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLayerProperty.this.jButton_RemoveAllBreaksActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_RemoveAllBreaks);
        this.jToolBar1.add(this.jSeparator2);
        this.jButton_MoveBreakUp.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Up.Image.png")));
        this.jButton_MoveBreakUp.setToolTipText("Move Break Up");
        this.jButton_MoveBreakUp.setFocusable(false);
        this.jButton_MoveBreakUp.setHorizontalTextPosition(0);
        this.jButton_MoveBreakUp.setVerticalTextPosition(3);
        this.jButton_MoveBreakUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLayerProperty.this.jButton_MoveBreakUpActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_MoveBreakUp);
        this.jButton_MoveBreakDown.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Down.Image.png")));
        this.jButton_MoveBreakDown.setToolTipText("Move Break Down");
        this.jButton_MoveBreakDown.setFocusable(false);
        this.jButton_MoveBreakDown.setHorizontalTextPosition(0);
        this.jButton_MoveBreakDown.setVerticalTextPosition(3);
        this.jButton_MoveBreakDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLayerProperty.this.jButton_MoveBreakDownActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_MoveBreakDown);
        this.jButton_ReverseBreaks.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Reverse.Image.png")));
        this.jButton_ReverseBreaks.setToolTipText("Reverse Breaks");
        this.jButton_ReverseBreaks.setFocusable(false);
        this.jButton_ReverseBreaks.setHorizontalTextPosition(0);
        this.jButton_ReverseBreaks.setVerticalTextPosition(3);
        this.jButton_ReverseBreaks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLayerProperty.this.jButton_ReverseBreaksActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_ReverseBreaks);
        this.jToolBar1.add(this.jSeparator3);
        this.jButton_MakeBreaks.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_MakeBreaks.Image.png")));
        this.jButton_MakeBreaks.setFocusable(false);
        this.jButton_MakeBreaks.setHorizontalTextPosition(0);
        this.jButton_MakeBreaks.setVerticalTextPosition(3);
        this.jButton_MakeBreaks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLayerProperty.this.jButton_MakeBreaksActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_MakeBreaks);
        GroupLayout legendView1Layout = new GroupLayout(this.legendView1);
        this.legendView1.setLayout(legendView1Layout);
        legendView1Layout.setHorizontalGroup(legendView1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        legendView1Layout.setVerticalGroup(legendView1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 312, Short.MAX_VALUE));
        this.jLabel1.setText("Legend Type:");
        this.jLabel2.setText("Field:");
        this.jComboBox_LegendType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_LegendType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLayerProperty.this.jComboBox_LegendTypeActionPerformed(evt);
            }
        });
        this.jComboBox_Field.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLayerProperty.this.jComboBox_FieldActionPerformed(evt);
            }
        });
        GroupLayout jPanel_LegendLayout = new GroupLayout(this.jPanel_Legend);
        this.jPanel_Legend.setLayout(jPanel_LegendLayout);
        jPanel_LegendLayout.setHorizontalGroup(jPanel_LegendLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, 378, Short.MAX_VALUE).addComponent(this.legendView1, -1, 378, Short.MAX_VALUE).addGroup(jPanel_LegendLayout.createSequentialGroup().addGap(56, 56, 56).addGroup(jPanel_LegendLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_LegendLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBox_LegendType, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox_Field, -2, 163, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel_LegendLayout.setVerticalGroup(jPanel_LegendLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_LegendLayout.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addGroup(jPanel_LegendLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_LegendLayout.createSequentialGroup().addGap(43, 43, 43).addComponent(this.jLabel2)).addGroup(jPanel_LegendLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_LegendLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox_LegendType, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBox_Field, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.legendView1, -1, 312, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Legend", this.jPanel_Legend);
        this.jLabel3.setText("Chart Type:");
        this.jComboBox_ChartType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_ChartType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLayerProperty.this.jComboBox_ChartTypeActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Size"));
        this.jLabel4.setText("Minimum:");
        this.jLabel5.setText("Maximum:");
        this.jLabel_BarWidth.setText("BarWidth:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel_BarWidth, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField_Minimum, -2, 77, -2).addComponent(this.jTextField_Maximum).addComponent(this.jTextField_BarWidth)).addGap(16, 16, 16)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextField_Minimum, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextField_Maximum, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_BarWidth).addComponent(this.jTextField_BarWidth, -2, -1, -2))));
        this.jLabel7.setText("X Shift:");
        this.jLabel8.setText("Y Shift:");
        this.jCheckBox_CollisionAvoidance.setText("Avoid collision");
        this.jCheckBox_CollisionAvoidance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLayerProperty.this.jCheckBox_CollisionAvoidanceActionPerformed(evt);
            }
        });
        this.jLabel9.setText("Align:");
        this.jComboBox_Align.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("3D"));
        this.jCheckBox_DisplayIn3D.setText("Display in 3D");
        this.jLabel10.setText("Thickness:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jCheckBox_DisplayIn3D).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_Thickness))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jCheckBox_DisplayIn3D).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.jTextField_Thickness, -2, -1, -2)).addGap(0, 12, Short.MAX_VALUE)));
        this.checkBoxList_Fields.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.checkBoxList_Fields.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmLayerProperty.this.checkBoxList_FieldsMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.checkBoxList_Fields);
        this.jButton_ChartLabel.setText("Label");
        this.jButton_ChartLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLayerProperty.this.jButton_ChartLabelActionPerformed(evt);
            }
        });
        GroupLayout jPanel_ChartLayout = new GroupLayout(this.jPanel_Chart);
        this.jPanel_Chart.setLayout(jPanel_ChartLayout);
        jPanel_ChartLayout.setHorizontalGroup(jPanel_ChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_ChartLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel_ChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_ChartLayout.createSequentialGroup().addGroup(jPanel_ChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel_ChartLayout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 185, -2).addGroup(jPanel_ChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_ChartLayout.createSequentialGroup().addGap(34, 34, 34).addGroup(jPanel_ChartLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel7).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_ChartLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTextField_YShift, -1, 79, Short.MAX_VALUE).addComponent(this.jTextField_XShift))).addGroup(jPanel_ChartLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)))).addGroup(jPanel_ChartLayout.createSequentialGroup().addComponent(this.legendView_Chart, -2, 181, -2).addGroup(jPanel_ChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_ChartLayout.createSequentialGroup().addGap(34, 34, 34).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_Align, -2, 97, -2)).addGroup(jPanel_ChartLayout.createSequentialGroup().addGap(26, 26, 26).addComponent(this.jCheckBox_CollisionAvoidance)).addGroup(jPanel_ChartLayout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE))))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel_ChartLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_ChartType, -2, 162, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton_ChartLabel).addGap(44, 44, 44)))));
        jPanel_ChartLayout.setVerticalGroup(jPanel_ChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_ChartLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_ChartLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jComboBox_ChartType, -2, -1, -2).addComponent(this.jButton_ChartLabel)).addGap(8, 8, 8).addGroup(jPanel_ChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_ChartLayout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_ChartLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jTextField_XShift, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_ChartLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jTextField_YShift, -2, -1, -2))).addComponent(this.jScrollPane2, -2, 169, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_ChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.legendView_Chart, -2, 183, -2).addGroup(jPanel_ChartLayout.createSequentialGroup().addComponent(this.jCheckBox_CollisionAvoidance).addGap(18, 18, 18).addGroup(jPanel_ChartLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jComboBox_Align, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jPanel2, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Chart", this.jPanel_Chart);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(32, Short.MAX_VALUE).addComponent(this.jButton_Apply, -2, 82, -2).addGap(26, 26, 26).addComponent(this.jButton_OK, -2, 82, -2).addGap(18, 18, 18).addComponent(this.jButton_Cancel, -2, 82, -2).addGap(61, 61, 61)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(this.jButton_Apply, -1, -1, Short.MAX_VALUE).addComponent(this.jButton_OK, -1, -1, Short.MAX_VALUE).addComponent(this.jButton_Cancel, -2, -1, -2)).addGap(8, 8, 8)));
        this.pack();
    }

    private void jButton_ApplyActionPerformed(ActionEvent evt) {
        this.propertySheetPanel1.writeToObject(this._object);
        switch (this.jTabbedPane1.getSelectedIndex()) {
            case 1: {
                this._mapLayer.setLegendScheme(this.legendView1.getLegendScheme());
                break;
            }
            case 2: {
                if (((VectorLayer)this._mapLayer).getChartPoints().size() > 0) {
                    this.updateCharts();
                    ((VectorLayer)this._mapLayer).updateCharts();
                    break;
                }
                this.addCharts();
            }
        }
        this._mapFrame.updateLayerNode(this._mapLayer);
        this._mapFrame.getMapView().paintLayers();
    }

    private void addCharts() {
        this.updateCharts();
        ((VectorLayer)this._mapLayer).addCharts();
    }

    private void updateCharts() {
        double[] minMax;
        int i;
        if (this.checkBoxList_Fields.getCheckedIdexes().length < 1) {
            return;
        }
        VectorLayer aLayer = (VectorLayer)this._mapLayer;
        ChartSet chartSet = aLayer.getChartSet();
        chartSet.setChartType(ChartTypes.valueOf(this.jComboBox_ChartType.getSelectedItem().toString()));
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (i = 0; i < this.checkBoxList_Fields.getCheckedIdexes().length; ++i) {
            fieldNames.add(((CheckBoxListEntry)this.checkBoxList_Fields.getCheckedItems().get(i)).getValue().toString());
        }
        chartSet.setFieldNames(fieldNames);
        chartSet.setLegendScheme(this.legendView_Chart.getLegendScheme());
        chartSet.setMinSize(Integer.parseInt(this.jTextField_Minimum.getText()));
        chartSet.setMaxSize(Integer.parseInt(this.jTextField_Maximum.getText()));
        chartSet.setBarWidth(Integer.parseInt(this.jTextField_BarWidth.getText()));
        chartSet.setXShift(Integer.parseInt(this.jTextField_XShift.getText()));
        chartSet.setYShift(Integer.parseInt(this.jTextField_YShift.getText()));
        chartSet.setAvoidCollision(this.jCheckBox_CollisionAvoidance.isSelected());
        chartSet.setAlignType(AlignType.valueOf(this.jComboBox_Align.getSelectedItem().toString()));
        chartSet.setView3D(this.jCheckBox_DisplayIn3D.isSelected());
        chartSet.setThickness(Integer.parseInt(this.jTextField_Thickness.getText()));
        ArrayList<Double> minList = new ArrayList<Double>();
        ArrayList<Double> maxList = new ArrayList<Double>();
        ArrayList<Double> sumList = new ArrayList<Double>();
        for (i = 0; i < aLayer.getShapeNum(); ++i) {
            ArrayList<Double> vList = new ArrayList<Double>();
            double sum = 0.0;
            for (int j = 0; j < fieldNames.size(); ++j) {
                double v = Double.parseDouble(aLayer.getCellValue((String)fieldNames.get(j), i).toString());
                vList.add(v);
                sum += v;
            }
            minMax = MIMath.getMinMaxValue(vList, -9999.0);
            minList.add(minMax[0]);
            maxList.add(minMax[1]);
            sumList.add(sum);
        }
        switch (chartSet.getChartType()) {
            case BarChart: {
                minMax = MIMath.getMinMaxValue(minList, -9999.0);
                chartSet.setMinValue((float)minMax[0]);
                minMax = MIMath.getMinMaxValue(maxList, -9999.0);
                chartSet.setMaxValue((float)minMax[1]);
                break;
            }
            case PieChart: {
                minMax = MIMath.getMinMaxValue(sumList, -9999.0);
                chartSet.setMinValue((float)minMax[0]);
                chartSet.setMaxValue((float)minMax[1]);
            }
        }
    }

    private void jButton_OKActionPerformed(ActionEvent evt) {
        this.propertySheetPanel1.writeToObject(this._object);
        switch (this.jTabbedPane1.getSelectedIndex()) {
            case 1: {
                this._mapLayer.setLegendScheme(this.legendView1.getLegendScheme());
                break;
            }
            case 2: {
                ((VectorLayer)this._mapLayer).removeCharts();
                this.addCharts();
            }
        }
        this._mapFrame.updateLayerNode(this._mapLayer);
        this._mapFrame.getMapView().paintLayers();
        switch (this.jTabbedPane1.getSelectedIndex()) {
            case 0: 
            case 1: {
                this.dispose();
            }
        }
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        switch (this.jTabbedPane1.getSelectedIndex()) {
            case 0: {
                this.dispose();
                break;
            }
            case 1: {
                this._mapLayer.setLegendScheme(this._legendScheme);
                this._mapFrame.updateLayerNode(this._mapLayer);
                this._mapFrame.getMapView().paintLayers();
                this.dispose();
                break;
            }
            case 2: {
                ((VectorLayer)this._mapLayer).removeCharts();
                this._mapFrame.updateLayerNode(this._mapLayer);
                this._mapFrame.getMapView().paintLayers();
            }
        }
    }

    private void jComboBox_LegendTypeActionPerformed(ActionEvent evt) {
        if (this._isLoading) {
            return;
        }
        if (this.jComboBox_LegendType.getItemCount() == 0) {
            return;
        }
        LegendType aLT = (LegendType)((Object)this.jComboBox_LegendType.getSelectedItem());
        switch (this._mapLayer.getLayerType()) {
            case VectorLayer: {
                this._ifCreateLegendScheme = false;
                this.setFieldByLegendType(aLT);
                this._ifCreateLegendScheme = true;
                break;
            }
            case RasterLayer: {
                switch (aLT) {
                    case UniqueValue: {
                        List<Number> values = ((RasterLayer)this._mapLayer).getGridData().getUniqueValues();
                        this._legendScheme = LegendManage.createUniqValueLegendScheme(values, ShapeTypes.Image);
                        break;
                    }
                    case GraduatedColor: {
                        if (this._legendScheme != null && this._legendScheme.getLegendType() == LegendType.GraduatedColor) break;
                        this._legendScheme = LegendManage.createLegendSchemeFromGridData(((RasterLayer)this._mapLayer).getGridData(), LegendType.GraduatedColor, ShapeTypes.Polygon);
                    }
                }
                this.legendView1.setLegendScheme(this._legendScheme);
                this.legendView1.repaint();
            }
        }
    }

    private void jComboBox_FieldActionPerformed(ActionEvent evt) {
        if (this._isLoading) {
            return;
        }
        if (this.jComboBox_Field.getItemCount() == 0) {
            return;
        }
        LegendType aLT = (LegendType)((Object)this.jComboBox_LegendType.getSelectedItem());
        String fieldName = this.jComboBox_Field.getSelectedItem().toString();
        if (!"<None>".equals(fieldName)) {
            this.createLegendScheme(aLT, fieldName);
        }
    }

    private void jButton_ImportLegendActionPerformed(ActionEvent evt) {
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(new File(System.getProperty("user.dir")));
        String[] fileExts = new String[]{"lgs", "pal"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "LegendScheme file (*.lgs,*.pal)");
        aDlg.setFileFilter(mapFileFilter);
        if (0 == aDlg.showOpenDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            System.setProperty("user.dir", aFile.getParent());
            String fext = GenericFileFilter.getExtension(aFile);
            if (fext.equals("pal")) {
                this._legendScheme.importFromPaletteFile_Unique(aFile.getAbsolutePath());
            } else if (fext.equals("lgs")) {
                try {
                    VectorLayer layer;
                    this._legendScheme.importFromXMLFile(aFile.getAbsolutePath());
                    if (this._mapLayer.getLayerType() == LayerTypes.VectorLayer && (layer = (VectorLayer)this._mapLayer).getField(this._legendScheme.getFieldName()) == null) {
                        this._legendScheme.setFieldName(this.jComboBox_Field.getSelectedItem().toString());
                    }
                }
                catch (ParserConfigurationException ex) {
                    Logger.getLogger(FrmLayerProperty.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (SAXException ex) {
                    Logger.getLogger(FrmLayerProperty.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(FrmLayerProperty.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this._ifCreateLegendScheme = false;
            this.jComboBox_LegendType.setSelectedItem(this._legendScheme.getLegendType().toString());
            if ((this._legendScheme.getFieldName() == null || this._legendScheme.getFieldName().isEmpty()) && this.jComboBox_Field.getSelectedIndex() >= 0) {
                this._legendScheme.setFieldName(this.jComboBox_Field.getSelectedItem().toString());
            }
            this.jComboBox_Field.setSelectedItem(this._legendScheme.getFieldName());
            this.legendView1.update(this._legendScheme);
            this._ifCreateLegendScheme = true;
        }
    }

    private void jButton_ExportLegendActionPerformed(ActionEvent evt) {
        JFileChooser aDlg = new JFileChooser();
        String[] fileExts = new String[]{"lgs"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "LegendScheme file (*.lgs)");
        aDlg.setFileFilter(mapFileFilter);
        String path = System.getProperty("user.dir");
        aDlg.setCurrentDirectory(new File(path));
        if (0 == aDlg.showSaveDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            String filePath = aFile.getAbsolutePath();
            if (!filePath.substring(filePath.length() - 4).equals(".lgs")) {
                filePath = filePath + ".lgs";
            }
            try {
                this._legendScheme.exportToXMLFile(filePath);
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(FrmLayerProperty.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void jButton_AddBreakActionPerformed(ActionEvent evt) {
        switch (this._legendScheme.getShapeType()) {
            case Polyline: 
            case PolylineZ: {
                PolylineBreak aPLB = new PolylineBreak();
                aPLB.setDrawPolyline(true);
                aPLB.setWidth(0.1f);
                aPLB.setColor(Color.red);
                aPLB.setStartValue(0);
                aPLB.setEndValue(0);
                aPLB.setCaption("");
                this._legendScheme.getLegendBreaks().add(aPLB);
                break;
            }
            case Point: {
                PointBreak aPB = new PointBreak();
                aPB.setDrawShape(true);
                aPB.setDrawFill(true);
                aPB.setSize(5.0f);
                aPB.setColor(Color.red);
                aPB.setStartValue(0);
                aPB.setEndValue(0);
                aPB.setCaption("");
                this._legendScheme.getLegendBreaks().add(aPB);
                break;
            }
            case Polygon: {
                PolygonBreak aPGB = new PolygonBreak();
                aPGB.setDrawShape(true);
                aPGB.setDrawFill(true);
                aPGB.setColor(Color.red);
                aPGB.setStartValue(0);
                aPGB.setEndValue(0);
                aPGB.setCaption("");
                this._legendScheme.getLegendBreaks().add(aPGB);
                break;
            }
            case Image: {
                ColorBreak aCB = new ColorBreak();
                aCB.setColor(Color.red);
                aCB.setStartValue(0);
                aCB.setEndValue(0);
                aCB.setCaption("");
                this._legendScheme.getLegendBreaks().add(aCB);
            }
        }
        this.legendView1.update(this._legendScheme);
    }

    private void jButton_RemoveBreakActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.legendView1.getSelectedRows().size(); ++i) {
            int rowIdx = this.legendView1.getSelectedRows().get(i);
            this._legendScheme.getLegendBreaks().remove(rowIdx);
        }
        this.legendView1.update(this._legendScheme);
    }

    private void jButton_RemoveAllBreaksActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(null, "If remove all breaks?", "Alarm", 0) == 0) {
            this._legendScheme.getLegendBreaks().clear();
            this.legendView1.update(this._legendScheme);
        }
    }

    private void jButton_MoveBreakUpActionPerformed(ActionEvent evt) {
        int oldIdx = this.legendView1.getSelectedRows().get(0);
        if (oldIdx > 0) {
            PointBreak aPB;
            if (this._legendScheme.getShapeType() == ShapeTypes.Point && (aPB = (PointBreak)this._legendScheme.getLegendBreaks().get(oldIdx)).isNoData()) {
                return;
            }
            int newIdx = oldIdx - 1;
            this._legendScheme.getLegendBreaks().add(newIdx, this._legendScheme.getLegendBreaks().get(oldIdx));
            this._legendScheme.getLegendBreaks().remove(oldIdx + 1);
            this.legendView1.getSelectedRows().clear();
            this.legendView1.getSelectedRows().add(newIdx);
            this.legendView1.update(this._legendScheme);
        }
    }

    private void jButton_MoveBreakDownActionPerformed(ActionEvent evt) {
        PointBreak aPB;
        int oldIdx = this.legendView1.getSelectedRows().get(0);
        int endIdx = this.legendView1.getLegendScheme().getBreakNum() - 1;
        if (this._legendScheme.getShapeType() == ShapeTypes.Point && (aPB = (PointBreak)this._legendScheme.getLegendBreaks().get(oldIdx)).isNoData()) {
            --endIdx;
        }
        if (oldIdx < endIdx) {
            int newIdx = oldIdx + 2;
            this._legendScheme.getLegendBreaks().add(newIdx, this._legendScheme.getLegendBreaks().get(oldIdx));
            this._legendScheme.getLegendBreaks().remove(oldIdx);
            this.legendView1.getSelectedRows().clear();
            this.legendView1.getSelectedRows().add(newIdx - 1);
            this.legendView1.update(this._legendScheme);
        }
    }

    private void jButton_ReverseBreaksActionPerformed(ActionEvent evt) {
        Collections.reverse(this._legendScheme.getLegendBreaks());
        if (this._legendScheme.getHasNoData()) {
            this._legendScheme.getLegendBreaks().add(this._legendScheme.getLegendBreaks().get(0));
            this._legendScheme.getLegendBreaks().remove(0);
        }
        this.legendView1.update(this._legendScheme);
    }

    private void jButton_MakeBreaksActionPerformed(ActionEvent evt) {
        boolean isUniqueValue = false;
        if (this._legendScheme.getLegendType() == LegendType.UniqueValue) {
            isUniqueValue = true;
        }
        FrmLegendBreaks frmLB = new FrmLegendBreaks((Dialog)this, false, isUniqueValue);
        frmLB.setLegendScheme(this._legendScheme);
        frmLB.setLocationRelativeTo(this);
        frmLB.setVisible(true);
    }

    private void checkBoxList_FieldsMouseClicked(MouseEvent evt) {
        DefaultListModel listModel = (DefaultListModel)this.checkBoxList_Fields.getModel();
        int idx = this.checkBoxList_Fields.getSelectedIndex();
        CheckBoxListEntry item = (CheckBoxListEntry)listModel.getElementAt(idx);
        String selFieldStr = item.getValue().toString();
        if (item.isSelected()) {
            PolygonBreak aPB = new PolygonBreak();
            aPB.setCaption(selFieldStr);
            aPB.setTag(selFieldStr);
            aPB.setColor(LegendManage.createRandomColors(1)[0]);
            this.legendView_Chart.getLegendScheme().getLegendBreaks().add(aPB);
        } else {
            for (int i = 0; i < this.legendView_Chart.getLegendScheme().getBreakNum(); ++i) {
                if (!this.legendView_Chart.getLegendScheme().getLegendBreaks().get(i).getTag().equals(selFieldStr)) continue;
                this.legendView_Chart.getLegendScheme().getLegendBreaks().remove(i);
                break;
            }
        }
        this.legendView_Chart.repaint();
    }

    private void jComboBox_ChartTypeActionPerformed(ActionEvent evt) {
        if (this.jComboBox_ChartType.getItemCount() > 0) {
            if (this.jComboBox_ChartType.getSelectedItem().toString().equals(ChartTypes.PieChart.toString())) {
                this.jLabel_BarWidth.setEnabled(false);
                this.jTextField_BarWidth.setEnabled(false);
            } else {
                this.jLabel_BarWidth.setEnabled(true);
                this.jTextField_BarWidth.setEnabled(true);
            }
        }
    }

    private void jCheckBox_CollisionAvoidanceActionPerformed(ActionEvent evt) {
        ((VectorLayer)this._mapLayer).getChartSet().setAvoidCollision(this.jCheckBox_CollisionAvoidance.isSelected());
        if (((VectorLayer)this._mapLayer).getChartPoints().size() > 0) {
            this._mapFrame.getMapView().paintLayers();
        }
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        int selIndex = this.jTabbedPane1.getSelectedIndex();
        switch (selIndex) {
            case 0: 
            case 1: {
                this.jButton_Apply.setText("Apply");
                this.jButton_OK.setText("OK");
                this.jButton_Cancel.setText("Cancel");
                break;
            }
            case 2: {
                this.jButton_Apply.setText("Update");
                this.jButton_OK.setText("Reset");
                this.jButton_Cancel.setText("Clear");
            }
        }
    }

    private void jButton_ChartLabelActionPerformed(ActionEvent evt) {
        FrmChartLabel frm = new FrmChartLabel((Dialog)this, false, ((VectorLayer)this._mapLayer).getChartSet());
        frm.setLocationRelativeTo(this);
        frm.setVisible(true);
    }

    private void setFieldByLegendType(LegendType aLT) {
        this.setFieldByLegendType(aLT, !this._isLoading);
    }

    private void setFieldByLegendType(LegendType aLT, boolean createLegend) {
        if (this._mapLayer.getLayerType() == LayerTypes.VectorLayer) {
            VectorLayer aLayer = (VectorLayer)this._mapLayer;
            switch (aLT) {
                case SingleSymbol: {
                    this.jComboBox_Field.setEnabled(false);
                    this.jComboBox_Field.removeAllItems();
                    this._ifCreateLegendScheme = createLegend;
                    this.createLegendScheme(aLT, "");
                    this._ifCreateLegendScheme = false;
                    break;
                }
                case UniqueValue: {
                    this.jComboBox_Field.setEnabled(true);
                    this.jComboBox_Field.removeAllItems();
                    for (String fn : aLayer.getFieldNames()) {
                        this.jComboBox_Field.addItem(fn);
                    }
                    this.jComboBox_Field.setSelectedItem("<None>");
                    break;
                }
                case GraduatedColor: {
                    this.jComboBox_Field.setEnabled(true);
                    this.jComboBox_Field.removeAllItems();
                    for (int i = 0; i < aLayer.getFieldNumber(); ++i) {
                        if (!aLayer.getField(i).isNumeric()) continue;
                        this.jComboBox_Field.addItem(aLayer.getFieldName(i));
                    }
                    switch (aLayer.getShapeType()) {
                        case PolylineM: {
                            this.jComboBox_Field.addItem("Geometry_M");
                            break;
                        }
                        case PolylineZ: {
                            this.jComboBox_Field.addItem("Geometry_M");
                            this.jComboBox_Field.addItem("Geometry_Z");
                        }
                    }
                    this.jComboBox_Field.setSelectedItem("<None>");
                }
            }
        }
    }

    private void createLegendScheme(LegendType aLT, String fieldName) {
        if (this._ifCreateLegendScheme) {
            ShapeTypes aST = this._legendScheme.getShapeType();
            double min = this._legendScheme.getMinValue();
            double max = this._legendScheme.getMaxValue();
            switch (aLT) {
                case SingleSymbol: {
                    Color aColor = Color.black;
                    switch (aST) {
                        case Point: {
                            aColor = Color.black;
                            break;
                        }
                        case Polyline: 
                        case PolylineZ: {
                            aColor = Color.black;
                            break;
                        }
                        case Polygon: 
                        case Image: {
                            aColor = new Color(255, 251, 195);
                        }
                    }
                    float size = 1.0f;
                    if (this._legendScheme.getShapeType() == ShapeTypes.Point) {
                        size = 5.0f;
                    }
                    this._legendScheme = LegendManage.createSingleSymbolLegendScheme(this._legendScheme.getShapeType(), aColor, size);
                    this.jButton_AddBreak.setEnabled(false);
                    this.jButton_RemoveBreak.setEnabled(false);
                    this.jButton_RemoveAllBreaks.setEnabled(false);
                    this.jButton_MoveBreakDown.setEnabled(false);
                    this.jButton_MoveBreakUp.setEnabled(false);
                    this.jButton_MakeBreaks.setEnabled(false);
                    this.jButton_ReverseBreaks.setEnabled(false);
                    break;
                }
                case UniqueValue: {
                    ArrayList<String> valueList = new ArrayList<String>();
                    VectorLayer aLayer = (VectorLayer)this._mapLayer;
                    boolean isDateField = false;
                    DataType colType = aLayer.getAttributeTable().getTable().getColumns().get(fieldName).getDataType();
                    if (colType == DataType.DATE) {
                        isDateField = true;
                    }
                    ArrayList<String> captions = new ArrayList<String>();
                    for (int i = 0; i < aLayer.getAttributeTable().getNumRecords(); ++i) {
                        if (valueList.contains(((DataRow)aLayer.getAttributeTable().getTable().getRows().get(i)).getValue(fieldName).toString())) continue;
                        valueList.add(((DataRow)aLayer.getAttributeTable().getTable().getRows().get(i)).getValue(fieldName).toString());
                        if (!isDateField) continue;
                        captions.add(((DataRow)aLayer.getAttributeTable().getTable().getRows().get(i)).getValue(fieldName).toString());
                    }
                    Color[] colors = valueList.size() <= 13 ? LegendManage.createRainBowColors(valueList.size()) : LegendManage.createRandomColors(valueList.size());
                    ArrayList<Color> CList = new ArrayList<Color>(Arrays.asList(colors));
                    CList.add(0, Color.white);
                    colors = CList.toArray(new Color[CList.size()]);
                    this._legendScheme = isDateField ? LegendManage.createUniqValueLegendScheme(valueList, captions, colors, aST, min, max, this._legendScheme.getHasNoData(), this._legendScheme.getUndefValue()) : LegendManage.createUniqValueLegendScheme(valueList, colors, aST, min, max, this._legendScheme.getHasNoData(), this._legendScheme.getUndefValue());
                    this._legendScheme.setFieldName(fieldName);
                    this.jButton_AddBreak.setEnabled(true);
                    this.jButton_RemoveBreak.setEnabled(true);
                    this.jButton_RemoveAllBreaks.setEnabled(true);
                    this.jButton_MoveBreakDown.setEnabled(true);
                    this.jButton_MoveBreakUp.setEnabled(true);
                    this.jButton_MakeBreaks.setEnabled(true);
                    this.jButton_ReverseBreaks.setEnabled(true);
                    break;
                }
                case GraduatedColor: {
                    double[] minmax;
                    VectorLayer aLayer = (VectorLayer)this._mapLayer;
                    ArrayList<Double> S = new ArrayList<Double>();
                    if (fieldName.equals("Geometry_M")) {
                        for (Shape shape : aLayer.getShapes()) {
                            for (PointZ pointZ : shape.getPoints()) {
                                S.add(pointZ.M);
                            }
                        }
                    } else if (fieldName.equals("Geometry_Z")) {
                        for (Shape shape : aLayer.getShapes()) {
                            for (PointZ pointZ : shape.getPoints()) {
                                S.add(pointZ.Z);
                            }
                        }
                    } else {
                        for (int i = 0; i < aLayer.getAttributeTable().getNumRecords(); ++i) {
                            String string = aLayer.getCellValue(fieldName, i).toString();
                            if (string.isEmpty()) {
                                S.add(0.0);
                                continue;
                            }
                            S.add(Double.parseDouble(string));
                        }
                    }
                    if ((min = (minmax = MIMath.getMinMaxValue(S, this._legendScheme.getUndefValue()))[0]) == (max = minmax[1])) {
                        JOptionPane.showMessageDialog(this, "The values of all shapes are same!");
                        break;
                    }
                    double[] dArray = LegendManage.createContourValues(min, max);
                    Color[] colors = LegendManage.createRainBowColors(dArray.length + 1);
                    this._legendScheme = LegendManage.createGraduatedLegendScheme(dArray, colors, aST, min, max, this._legendScheme.getHasNoData(), this._legendScheme.getUndefValue());
                    this._legendScheme.setFieldName(fieldName);
                    this.jButton_AddBreak.setEnabled(true);
                    this.jButton_RemoveBreak.setEnabled(true);
                    this.jButton_RemoveAllBreaks.setEnabled(true);
                    this.jButton_MoveBreakDown.setEnabled(true);
                    this.jButton_MoveBreakUp.setEnabled(true);
                    this.jButton_MakeBreaks.setEnabled(true);
                    this.jButton_ReverseBreaks.setEnabled(true);
                }
            }
            this.legendView1.setLegendScheme(this._legendScheme);
            this.legendView1.repaint();
        }
    }

    public PropertySheetPanel getPropertySheet() {
        return this.propertySheetPanel1;
    }

    public void setMapLayer(MapLayer aLayer) {
        this._mapLayer = aLayer;
        this._object = aLayer;
        switch (aLayer.getLayerType()) {
            case VectorLayer: {
                this._legendScheme = (LegendScheme)this._mapLayer.getLegendScheme().clone();
                this.legendView1.setLegendScheme(this._mapLayer.getLegendScheme());
                break;
            }
            case RasterLayer: {
                if (this._mapLayer.getLegendScheme() != null) {
                    this._legendScheme = (LegendScheme)this._mapLayer.getLegendScheme().clone();
                    this.legendView1.setLegendScheme(this._mapLayer.getLegendScheme());
                } else {
                    this._legendScheme = null;
                }
                this._object = new RasterLayer.RasterLayerBean((RasterLayer)aLayer);
                break;
            }
            case ImageLayer: {
                this._object = new ImageLayer.ImageLayerBean((ImageLayer)aLayer);
                break;
            }
            case WebMapLayer: {
                this._object = new WebMapLayer.WebMapLayerBean((WebMapLayer)aLayer);
            }
        }
        DefaultBeanInfoResolver resolver = new DefaultBeanInfoResolver();
        BeanInfo beanInfo = resolver.getBeanInfo(this._object);
        this.propertySheetPanel1.setMode(1);
        this.propertySheetPanel1.setProperties(beanInfo.getPropertyDescriptors());
        this.propertySheetPanel1.readFromObject(this._object);
        this._ifCreateLegendScheme = false;
        this._isLoading = true;
        this.update();
        this._ifCreateLegendScheme = true;
        this._isLoading = false;
        if (this.jComboBox_LegendType.isEnabled() && this._legendScheme != null) {
            this.setFieldByLegendType((LegendType)((Object)this.jComboBox_LegendType.getSelectedItem()), false);
        }
    }

    public void setLegendScheme(LegendScheme aLS) {
        this._legendScheme = (LegendScheme)aLS.clone();
        this.legendView1.setLegendScheme(this._legendScheme);
        this.legendView1.update(aLS);
    }

    private void update() {
        this.jTabbedPane1.removeAll();
        this.jTabbedPane1.addTab("General", this.jPanel_General);
        switch (this._mapLayer.getLayerType()) {
            case VectorLayer: 
            case RasterLayer: {
                if (this._legendScheme == null) break;
                this.jTabbedPane1.addTab("Legend", this.jPanel_Legend);
            }
        }
        block3 : switch (this._mapLayer.getLayerType()) {
            case VectorLayer: {
                this.jComboBox_LegendType.setEnabled(true);
                this.jComboBox_Field.setEnabled(true);
                this.jComboBox_LegendType.removeAllItems();
                this.jComboBox_LegendType.addItem(LegendType.SingleSymbol);
                this.jComboBox_LegendType.addItem(LegendType.UniqueValue);
                this.jComboBox_LegendType.addItem(LegendType.GraduatedColor);
                this.jComboBox_LegendType.setSelectedItem((Object)this._legendScheme.getLegendType());
                switch ((LegendType)((Object)this.jComboBox_LegendType.getSelectedItem())) {
                    case SingleSymbol: {
                        this.jButton_AddBreak.setEnabled(false);
                        this.jButton_RemoveBreak.setEnabled(false);
                        this.jButton_RemoveAllBreaks.setEnabled(false);
                        this.jButton_MoveBreakUp.setEnabled(false);
                        this.jButton_MoveBreakDown.setEnabled(false);
                        this.jButton_MakeBreaks.setEnabled(false);
                        this.jComboBox_Field.setEnabled(false);
                        this.jComboBox_Field.removeAllItems();
                        break;
                    }
                    default: {
                        this.jButton_AddBreak.setEnabled(true);
                        this.jButton_RemoveBreak.setEnabled(true);
                        this.jButton_RemoveAllBreaks.setEnabled(true);
                        this.jButton_MoveBreakUp.setEnabled(true);
                        this.jButton_MoveBreakDown.setEnabled(true);
                        this.jButton_MakeBreaks.setEnabled(true);
                    }
                }
                this.jComboBox_Field.setSelectedItem(this._legendScheme.getFieldName());
                switch (this._mapLayer.getLegendScheme().getBreakType()) {
                    case PointBreak: 
                    case PolygonBreak: {
                        this.jTabbedPane1.addTab("Chart", this.jPanel_Chart);
                        VectorLayer aLayer = (VectorLayer)this._mapLayer;
                        if (this._mapLayer.getShapeType() == ShapeTypes.Polygon) {
                            this.jComboBox_ChartType.removeAllItems();
                            this.jComboBox_ChartType.addItem(ChartTypes.BarChart.toString());
                            this.jComboBox_ChartType.addItem(ChartTypes.PieChart.toString());
                        } else {
                            this.jComboBox_ChartType.removeAllItems();
                            this.jComboBox_ChartType.addItem(ChartTypes.BarChart.toString());
                            this.jComboBox_ChartType.addItem(ChartTypes.PieChart.toString());
                        }
                        this.jComboBox_ChartType.setSelectedItem(aLayer.getChartSet().getChartType().toString());
                        aLayer.getChartSet().update();
                        DefaultListModel<CheckBoxListEntry> listModel = new DefaultListModel<CheckBoxListEntry>();
                        for (int i = 0; i < aLayer.getFieldNumber(); ++i) {
                            if (!aLayer.getField(i).isNumeric()) continue;
                            String fn = aLayer.getFieldName(i);
                            boolean isCheck = false;
                            if (aLayer.getChartSet().getFieldNames().contains(fn)) {
                                isCheck = true;
                            }
                            listModel.addElement(new CheckBoxListEntry((Object)fn, isCheck));
                        }
                        this.checkBoxList_Fields.setModel(listModel);
                        this.jTextField_BarWidth.setText(String.valueOf(aLayer.getChartSet().getBarWidth()));
                        this.jTextField_Maximum.setText(String.valueOf(aLayer.getChartSet().getMaxSize()));
                        this.jTextField_Minimum.setText(String.valueOf(aLayer.getChartSet().getMinSize()));
                        this.jTextField_XShift.setText(String.valueOf(aLayer.getChartSet().getXShift()));
                        this.jTextField_YShift.setText(String.valueOf(aLayer.getChartSet().getYShift()));
                        this.jCheckBox_CollisionAvoidance.setSelected(aLayer.getChartSet().isAvoidCollision());
                        this.jComboBox_Align.removeAllItems();
                        for (AlignType align : AlignType.values()) {
                            this.jComboBox_Align.addItem(align.toString());
                        }
                        this.jComboBox_Align.setSelectedItem(aLayer.getChartSet().getAlignType().toString());
                        this.jCheckBox_DisplayIn3D.setSelected(aLayer.getChartSet().isView3D());
                        this.jTextField_Thickness.setText(String.valueOf(aLayer.getChartSet().getThickness()));
                        this.legendView_Chart.setLegendScheme(aLayer.getChartSet().getLegendScheme());
                        break block3;
                    }
                }
                break;
            }
            case RasterLayer: {
                if (this._legendScheme == null) break;
                this.jComboBox_LegendType.setEnabled(true);
                this.jComboBox_Field.removeAllItems();
                this.jComboBox_Field.setEnabled(false);
                this.jComboBox_LegendType.removeAllItems();
                this.jComboBox_LegendType.addItem(LegendType.UniqueValue);
                this.jComboBox_LegendType.addItem(LegendType.GraduatedColor);
                this.jComboBox_LegendType.setSelectedItem((Object)this._legendScheme.getLegendType());
                this.jButton_AddBreak.setEnabled(true);
                this.jButton_RemoveBreak.setEnabled(true);
                this.jButton_RemoveAllBreaks.setEnabled(true);
                this.jButton_MoveBreakUp.setEnabled(true);
                this.jButton_MoveBreakDown.setEnabled(true);
                this.jButton_MakeBreaks.setEnabled(true);
                break;
            }
            default: {
                this.jComboBox_LegendType.removeAllItems();
                this.jComboBox_LegendType.setEnabled(false);
                this.jComboBox_Field.removeAllItems();
                this.jComboBox_Field.setEnabled(false);
                this.jButton_AddBreak.setEnabled(true);
                this.jButton_RemoveBreak.setEnabled(true);
                this.jButton_RemoveAllBreaks.setEnabled(true);
                this.jButton_MoveBreakUp.setEnabled(true);
                this.jButton_MoveBreakDown.setEnabled(true);
                this.jButton_MakeBreaks.setEnabled(true);
            }
        }
    }

    public void setMapFrame(MapFrame mf) {
        this._mapFrame = mf;
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmLayerProperty.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmLayerProperty.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmLayerProperty.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmLayerProperty.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmLayerProperty dialog = new FrmLayerProperty((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

